


$include (REG_MG84FG516.INC)
$include (Delay.inc)


PageP_SFR_Write		EQU	04h
PageP_SFR_Read		EQU	05h

CKCON2			EQU	40h
CKCON3			EQU	41h
PCON2			EQU	44h
PCON3			EQU	45h

;Ctrl_MCU

data_ISP_CTRL SEGMENT DATA
         RSEG   data_ISP_CTRL
var:		DS	1




	CSEG	AT	0000h
	JMP	Start

	CSEG	AT	006Bh
	JMP	KBI_INT



code_main	SEGMENT CODE
	RSEG	code_main
	USING	0

Start:
	MOV	PUCON0, #0Fh				;enable P0, P1 internal pull high
	ORL	EIE1, #20h
	SETB	EA
	
	delay_ms	5
	
	MOV	KBPATN, #0FFh
	MOV	KBCON, #00h
	MOV	KBMASK, #0FFh				;Will Enable KP Interrupt

	CLR	P1.0
	ORL	PCON0, #02h				;into power down

	CLR	P1.1					;pull low any P0.x will wake up MCU.

Main:
	JMP	Main


KBI_INT:
	MOV	KBCON, #00h				;Clear KP Interrupt Flag
	MOV	KBMASK, #00h				;Will Disable KP Interrupt

	RETI

	END
