/**
 ******************************************************************************
 *
 * @file        MG32_LCD_MID.h
 * @brief       Header file of LCD MID module.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2025/06/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2024 megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer 
 *      The Demo software is provided "AS IS" without any warranty, either 
 *      expressed or implied, including, but not limited to, the implied warranties 
 *      of merchantability and fitness for a particular purpose. The author will 
 *      not be liable for any special, incidental, consequential or indirect 
 *      damages due to loss of data or any other reason. 
 *      These statements agree with the world wide and local dictated laws about 
 *      authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MG32_LCD_MID_H
#define __MG32_LCD_MID_H

#include "MG32.h"
#if defined(ModuleExist_LCD)

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "MG32_LCD.h"
#include "MG32_DRV.h"
#include "MG32_MID.h"

#include "stdio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/** @name LCD_Exported_Types LCD Exported Types
 * @{
 */

/**
 *****************************************************************************
 * @brief LCD Init structure definition
 *****************************************************************************
 */
typedef struct __attribute__((packed))
{
    uint32_t Divider;         /*!< Configures the LCD Divider.
                                 This parameter can be one value of reference LCD_Divider */
    uint32_t Prescaler;       /*!< Configures the LCD Prescaler.
                                 This parameter can be one value of reference LCD_Prescaler */
    uint32_t Duty;            /*!< Configures the LCD Duty.
                                 This parameter can be one value of reference LCD_Duty */
    uint32_t DeadTime;        /*!< Configures the LCD Dead Time.
                                 This parameter can be one value of reference LCD_DeadTime */
    uint32_t OverVoltageDetect; /*!< Configures the LCD Over Voltage Detection.
                                 This parameter can be one value of reference LCD_OverVoltageDetect */
    uint32_t VoltageSource;   /*!< Selects the LCD Voltage source.
                                 This parameter can be one value of reference LCD_VoltageSource */
    uint32_t Contrast;        /*!< Configures the LCD Contrast.
                                 This parameter can be one value of reference LCD_Contrast */
    uint32_t Bias;            /*!< Configures the LCD Bias.
                                 This parameter can be one value of reference LCD_Bias */
    uint32_t PulseOnDuration; /*!< Configures the LCD Pulse On Duration.
                                 This parameter can be one value of reference LCD_PulseOnDuration */
    uint32_t HighDrive;       /*!< Configures the LCD High Drive.
                                 This parameter can be one value of reference LCD_HighDrive */
    uint32_t BlinkDivider;    /*!< Configures the LCD Blink divider.
                                 This parameter can be one value of reference BlinkDivider */
    uint32_t BlinkCount;      /*!< Configures the LCD Blinking frame counter.
                                 This parameter can be one value of reference BlinkCount */
    uint32_t COM0PIN;         /*!< Configures the COM0 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM1PIN;         /*!< Configures the COM1 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM2PIN;         /*!< Configures the COM2 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM3PIN;         /*!< Configures the COM3 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM4PIN;         /*!< Configures the COM4 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM5PIN;         /*!< Configures the COM5 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM6PIN;         /*!< Configures the COM6 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
    uint32_t COM7PIN;         /*!< Configures the COM7 LCD I/O Pin.
                                 This Parameter can be one value of reference LCD_Pn */
}LCD_InitTypeDef;


/**
 *****************************************************************************
 * @brief MID LCD State structures definition
 *****************************************************************************
 */
typedef enum
{
    MID_LCD_STATE_RESET             = 0x00,    /*!< Peripheral is not yet Initialized */
    MID_LCD_STATE_READY             = 0x01,    /*!< Peripheral Initialized and ready for use */
    MID_LCD_STATE_BUSY              = 0x02,    /*!< an internal process is ongoing */
    MID_LCD_STATE_TIMEOUT           = 0x03,    /*!< Timeout state */
    MID_LCD_STATE_ERROR             = 0x04     /*!< Error */
}MID_LCD_StateTypeDef;


/**
 *****************************************************************************
 * @brief  handle Structure definition
 *****************************************************************************
 */
typedef struct __attribute__((packed))
{
    LCD_Struct                    *Instance;  /* LCD registers base address */
    LCD_InitTypeDef               Init;       /* LCD communication parameters */
    MID_LockTypeDef               Lock;       /* Locking object */
    __IO MID_LCD_StateTypeDef     State;      /* LCD communication state */
    __IO uint32_t                 ErrorCode;  /* LCD Error code */
}LCD_HandleTypeDef;


/**
 * @}
 */

/* Exported constants --------------------------------------------------------*/
/** @name LCD_Error_Codes   LCD Error Codes
 * @{
 */
#define MID_LCD_ERROR_NONE      (0x00U)    /*!< No error */
#define MID_LCD_ERROR_FCRSF     (0x01U)    /*!< Synchro flag timeout error */
#define MID_LCD_ERROR_UDR       (0x02U)    /*!< Update display request flag timeout error */
#define MID_LCD_ERROR_UDD       (0x04U)    /*!< Update display done flag timeout error */
#define MID_LCD_ERROR_ENS       (0x08U)    /*!< LCD enabled status flag timeout error */
#define MID_LCD_ERROR_RDY       (0x10U)    /*!< LCD Booster ready timeout error */
/**
 * @}
 */


/** @name LCD_Pn LCD I/O Pin
 * @{
 */
#define LCD_P0                  (0x00000000U)          /*!< LCD IO Pin 0          */
#define LCD_P1                  (0x00000001U)          /*!< LCD IO Pin 1          */
#define LCD_P2                  (0x00000002U)          /*!< LCD IO Pin 2          */
#define LCD_P3                  (0x00000003U)          /*!< LCD IO Pin 3          */
#define LCD_P4                  (0x00000004U)          /*!< LCD IO Pin 4          */
#define LCD_P5                  (0x00000005U)          /*!< LCD IO Pin 5          */
#define LCD_P6                  (0x00000006U)          /*!< LCD IO Pin 6          */
#define LCD_P7                  (0x00000007U)          /*!< LCD IO Pin 7          */
#define LCD_P8                  (0x00000008U)          /*!< LCD IO Pin 8          */
#define LCD_P9                  (0x00000009U)          /*!< LCD IO Pin 9          */
#define LCD_P10                 (0x0000000AU)          /*!< LCD IO Pin 10         */
#define LCD_P11                 (0x0000000BU)          /*!< LCD IO Pin 11         */
#define LCD_P12                 (0x0000000CU)          /*!< LCD IO Pin 12         */
#define LCD_P13                 (0x0000000DU)          /*!< LCD IO Pin 13         */
#define LCD_P14                 (0x0000000EU)          /*!< LCD IO Pin 14         */
#define LCD_P15                 (0x0000000FU)          /*!< LCD IO Pin 15         */
#define LCD_P16                 (0x00000010U)          /*!< LCD IO Pin 16         */
#define LCD_P17                 (0x00000011U)          /*!< LCD IO Pin 17         */
#define LCD_P18                 (0x00000012U)          /*!< LCD IO Pin 18         */
#define LCD_P19                 (0x00000013U)          /*!< LCD IO Pin 19         */
#define LCD_P20                 (0x00000014U)          /*!< LCD IO Pin 20         */
#define LCD_P21                 (0x00000015U)          /*!< LCD IO Pin 21         */
#define LCD_P22                 (0x00000016U)          /*!< LCD IO Pin 22         */
#define LCD_P23                 (0x00000017U)          /*!< LCD IO Pin 23         */
#define LCD_P24                 (0x00000018U)          /*!< LCD IO Pin 24         */
#define LCD_P25                 (0x00000019U)          /*!< LCD IO Pin 25         */
#define LCD_P26                 (0x0000001AU)          /*!< LCD IO Pin 26         */
#define LCD_P27                 (0x0000001BU)          /*!< LCD IO Pin 27         */
#define LCD_P28                 (0x0000001CU)          /*!< LCD IO Pin 28         */
#define LCD_P29                 (0x0000001DU)          /*!< LCD IO Pin 29         */
#define LCD_P30                 (0x0000001EU)          /*!< LCD IO Pin 30         */
#define LCD_P31                 (0x0000001FU)          /*!< LCD IO Pin 31         */
#define LCD_P32                 (0x00000020U)          /*!< LCD IO Pin 32         */
#define LCD_P33                 (0x00000021U)          /*!< LCD IO Pin 33         */
#define LCD_P34                 (0x00000022U)          /*!< LCD IO Pin 34         */
#define LCD_P35                 (0x00000023U)          /*!< LCD IO Pin 35         */
#define LCD_P36                 (0x00000024U)          /*!< LCD IO Pin 36         */
#define LCD_P37                 (0x00000025U)          /*!< LCD IO Pin 37         */
#define LCD_P38                 (0x00000026U)          /*!< LCD IO Pin 38         */
#define LCD_P39                 (0x00000027U)          /*!< LCD IO Pin 39         */
#define LCD_P40                 (0x00000028U)          /*!< LCD IO Pin 40         */
#define LCD_P41                 (0x00000029U)          /*!< LCD IO Pin 41         */
#define LCD_P42                 (0x0000002AU)          /*!< LCD IO Pin 42         */
#define LCD_P43                 (0x0000002BU)          /*!< LCD IO Pin 43         */

#define IS_LCD_COM0PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM1PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM2PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM3PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM4PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM5PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM6PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))

#define IS_LCD_COM7PIN(__LCDIO__) (((__LCDIO__) == LCD_P0) || \
                                   ((__LCDIO__) == LCD_P1) || \
                                   ((__LCDIO__) == LCD_P2) || \
                                   ((__LCDIO__) == LCD_P3) || \
                                   ((__LCDIO__) == LCD_P4) || \
                                   ((__LCDIO__) == LCD_P5) || \
                                   ((__LCDIO__) == LCD_P6) || \
                                   ((__LCDIO__) == LCD_P7) || \
                                   ((__LCDIO__) == LCD_P8) || \
                                   ((__LCDIO__) == LCD_P9) || \
                                   ((__LCDIO__) == LCD_P10) || \
                                   ((__LCDIO__) == LCD_P11) || \
                                   ((__LCDIO__) == LCD_P12) || \
                                   ((__LCDIO__) == LCD_P13) || \
                                   ((__LCDIO__) == LCD_P14) || \
                                   ((__LCDIO__) == LCD_P15) || \
                                   ((__LCDIO__) == LCD_P16) || \
                                   ((__LCDIO__) == LCD_P17) || \
                                   ((__LCDIO__) == LCD_P18) || \
                                   ((__LCDIO__) == LCD_P19) || \
                                   ((__LCDIO__) == LCD_P20) || \
                                   ((__LCDIO__) == LCD_P21) || \
                                   ((__LCDIO__) == LCD_P22) || \
                                   ((__LCDIO__) == LCD_P23) || \
                                   ((__LCDIO__) == LCD_P24) || \
                                   ((__LCDIO__) == LCD_P25) || \
                                   ((__LCDIO__) == LCD_P26) || \
                                   ((__LCDIO__) == LCD_P27) || \
                                   ((__LCDIO__) == LCD_P28) || \
                                   ((__LCDIO__) == LCD_P29) || \
                                   ((__LCDIO__) == LCD_P30) || \
                                   ((__LCDIO__) == LCD_P31) || \
                                   ((__LCDIO__) == LCD_P32) || \
                                   ((__LCDIO__) == LCD_P33) || \
                                   ((__LCDIO__) == LCD_P34) || \
                                   ((__LCDIO__) == LCD_P35) || \
                                   ((__LCDIO__) == LCD_P36) || \
                                   ((__LCDIO__) == LCD_P37) || \
                                   ((__LCDIO__) == LCD_P38) || \
                                   ((__LCDIO__) == LCD_P39) || \
                                   ((__LCDIO__) == LCD_P40) || \
                                   ((__LCDIO__) == LCD_P41) || \
                                   ((__LCDIO__) == LCD_P42) || \
                                   ((__LCDIO__) == LCD_P43))
/**
 * @}
 */


/** @name LCD_Divider LCD Divider
 * @{
 */
#define LCD_DIVIDER_1                   LCD_CLK_CK_DIV_div1_w             /*!< LCD frequency = CK_LCD       */
#define LCD_DIVIDER_2                   LCD_CLK_CK_DIV_div2_w             /*!< LCD frequency = CK_LCD/2     */
#define LCD_DIVIDER_4                   LCD_CLK_CK_DIV_div4_w             /*!< LCD frequency = CK_LCD/4     */
#define LCD_DIVIDER_8                   LCD_CLK_CK_DIV_div8_w             /*!< LCD frequency = CK_LCD/8     */
#define LCD_DIVIDER_16                  LCD_CLK_CK_DIV_div16_w            /*!< LCD frequency = CK_LCD/16    */
#define LCD_DIVIDER_32                  LCD_CLK_CK_DIV_div32_w            /*!< LCD frequency = CK_LCD/32    */
#define LCD_DIVIDER_64                  LCD_CLK_CK_DIV_div64_w            /*!< LCD frequency = CK_LCD/64    */
#define LCD_DIVIDER_128                 LCD_CLK_CK_DIV_div128_w           /*!< LCD frequency = CK_LCD/128   */

#define IS_LCD_DIVIDER(__DIVIDER__) (((__DIVIDER__) == LCD_DIVIDER_1) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_2) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_4) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_8) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_16) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_32) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_64) || \
                                     ((__DIVIDER__) == LCD_DIVIDER_128))

/**
 * @}
 */


/** @name LCD_Prescaler LCD Prescaler
 * @{
 */
#define LCD_PRESCALER_1        (0x00000000U)           /*!< CLKPS = LCDCLK        */
#define LCD_PRESCALER_2        (0x00010000U)           /*!< CLKPS = LCDCLK/2      */
#define LCD_PRESCALER_3        (0x00020000U)           /*!< CLKPS = LCDCLK/3      */
#define LCD_PRESCALER_4        (0x00030000U)           /*!< CLKPS = LCDCLK/4      */
#define LCD_PRESCALER_5        (0x00040000U)           /*!< CLKPS = LCDCLK/5      */
#define LCD_PRESCALER_6        (0x00050000U)           /*!< CLKPS = LCDCLK/6      */
#define LCD_PRESCALER_7        (0x00060000U)           /*!< CLKPS = LCDCLK/7      */
#define LCD_PRESCALER_8        (0x00070000U)           /*!< CLKPS = LCDCLK/8      */
#define LCD_PRESCALER_9        (0x00080000U)           /*!< CLKPS = LCDCLK/9      */
#define LCD_PRESCALER_10       (0x00090000U)           /*!< CLKPS = LCDCLK/10     */
#define LCD_PRESCALER_11       (0x000A0000U)           /*!< CLKPS = LCDCLK/11     */
#define LCD_PRESCALER_12       (0x000B0000U)           /*!< CLKPS = LCDCLK/12     */
#define LCD_PRESCALER_13       (0x000C0000U)           /*!< CLKPS = LCDCLK/13     */
#define LCD_PRESCALER_14       (0x000D0000U)           /*!< CLKPS = LCDCLK/14     */
#define LCD_PRESCALER_15       (0x000E0000U)           /*!< CLKPS = LCDCLK/15     */
#define LCD_PRESCALER_16       (0x000F0000U)           /*!< CLKPS = LCDCLK/16     */
#define LCD_PRESCALER_17       (0x00100000U)           /*!< CLKPS = LCDCLK/17     */
#define LCD_PRESCALER_18       (0x00110000U)           /*!< CLKPS = LCDCLK/18     */
#define LCD_PRESCALER_19       (0x00120000U)           /*!< CLKPS = LCDCLK/19     */
#define LCD_PRESCALER_20       (0x00130000U)           /*!< CLKPS = LCDCLK/20     */
#define LCD_PRESCALER_21       (0x00140000U)           /*!< CLKPS = LCDCLK/21     */
#define LCD_PRESCALER_22       (0x00150000U)           /*!< CLKPS = LCDCLK/22     */
#define LCD_PRESCALER_23       (0x00160000U)           /*!< CLKPS = LCDCLK/23     */
#define LCD_PRESCALER_24       (0x00170000U)           /*!< CLKPS = LCDCLK/24     */
#define LCD_PRESCALER_25       (0x00180000U)           /*!< CLKPS = LCDCLK/25     */
#define LCD_PRESCALER_26       (0x00190000U)           /*!< CLKPS = LCDCLK/26     */
#define LCD_PRESCALER_27       (0x001A0000U)           /*!< CLKPS = LCDCLK/27     */
#define LCD_PRESCALER_28       (0x001B0000U)           /*!< CLKPS = LCDCLK/28     */
#define LCD_PRESCALER_29       (0x001C0000U)           /*!< CLKPS = LCDCLK/29     */
#define LCD_PRESCALER_30       (0x001D0000U)           /*!< CLKPS = LCDCLK/30     */
#define LCD_PRESCALER_31       (0x001E0000U)           /*!< CLKPS = LCDCLK/31     */
#define LCD_PRESCALER_32       (0x001F0000U)           /*!< CLKPS = LCDCLK/32     */

#define IS_LCD_PRESCALER(__PRESCALER__) (((__PRESCALER__) == LCD_PRESCALER_1) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_2) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_3) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_4) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_5) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_6) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_7) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_8) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_9) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_10) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_11) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_12) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_13) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_14) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_15) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_16) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_17) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_18) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_19) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_20) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_21) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_22) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_23) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_24) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_25) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_26) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_27) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_28) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_29) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_30) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_31) || \
                                         ((__PRESCALER__) == LCD_PRESCALER_32))

/**
 * @}
 */


/** @name LCD_Duty LCD Duty
 * @{
 */
#define LCD_DUTY_STATIC                 LCD_CR0_DUTY_static_w             /*!< Static duty */
#define LCD_DUTY_1_2                    LCD_CR0_DUTY_d12_w                /*!< 1/2 duty    */
#define LCD_DUTY_1_3                    LCD_CR0_DUTY_d13_w                /*!< 1/3 duty    */
#define LCD_DUTY_1_4                    LCD_CR0_DUTY_d14_w                /*!< 1/4 duty    */
#define LCD_DUTY_1_5                    LCD_CR0_DUTY_d15_w                /*!< 1/5 duty    */
#define LCD_DUTY_1_6                    LCD_CR0_DUTY_d16_w                /*!< 1/6 duty    */
#define LCD_DUTY_1_7                    LCD_CR0_DUTY_d17_w                /*!< 1/7 duty    */
#define LCD_DUTY_1_8                    LCD_CR0_DUTY_d18_w                /*!< 1/8 duty    */

#define IS_LCD_DUTY(__DUTY__) (((__DUTY__) == LCD_DUTY_STATIC) || \
                               ((__DUTY__) == LCD_DUTY_1_2) || \
                               ((__DUTY__) == LCD_DUTY_1_3) || \
                               ((__DUTY__) == LCD_DUTY_1_4) || \
                               ((__DUTY__) == LCD_DUTY_1_5) || \
                               ((__DUTY__) == LCD_DUTY_1_6) || \
                               ((__DUTY__) == LCD_DUTY_1_7) || \
                               ((__DUTY__) == LCD_DUTY_1_8))
/**
 * @}
 */


/** @name LCD_DeadTime LCD Dead Time
 * @{
 */
#define LCD_DEADTIME_0                  (0x00000000UL)                    /*!< No dead Time  */
#define LCD_DEADTIME_1                  (0x01000000UL)                    /*!< One Phase between different couple of Frame   */
#define LCD_DEADTIME_2                  (0x02000000UL)                    /*!< Two Phase between different couple of Frame   */
#define LCD_DEADTIME_3                  (0x03000000UL)                    /*!< Three Phase between different couple of Frame */
#define LCD_DEADTIME_4                  (0x04000000UL)                    /*!< Four Phase between different couple of Frame  */
#define LCD_DEADTIME_5                  (0x05000000UL)                    /*!< Five Phase between different couple of Frame  */
#define LCD_DEADTIME_6                  (0x06000000UL)                    /*!< Six Phase between different couple of Frame   */
#define LCD_DEADTIME_7                  (0x07000000UL)                    /*!< Seven Phase between different couple of Frame */
#define LCD_DEADTIME_8                  (0x08000000UL)                    /*!< Eight Phase between different couple of Frame */
#define LCD_DEADTIME_9                  (0x09000000UL)                    /*!< Nine Phase between different couple of Frame */
#define LCD_DEADTIME_10                 (0x0A000000UL)                    /*!< Ten Phase between different couple of Frame */
#define LCD_DEADTIME_11                 (0x0B000000UL)                    /*!< Eleven Phase between different couple of Frame */
#define LCD_DEADTIME_12                 (0x0C000000UL)                    /*!< Twelve Phase between different couple of Frame */
#define LCD_DEADTIME_13                 (0x0D000000UL)                    /*!< Thirteen Phase between different couple of Frame */
#define LCD_DEADTIME_14                 (0x0E000000UL)                    /*!< Fourteen Phase between different couple of Frame */
#define LCD_DEADTIME_15                 (0x0F000000UL)                    /*!< Fifteen Phase between different couple of Frame */

#define IS_LCD_DEAD_TIME(__TIME__) (((__TIME__) == LCD_DEADTIME_0) || \
                                    ((__TIME__) == LCD_DEADTIME_1) || \
                                    ((__TIME__) == LCD_DEADTIME_2) || \
                                    ((__TIME__) == LCD_DEADTIME_3) || \
                                    ((__TIME__) == LCD_DEADTIME_4) || \
                                    ((__TIME__) == LCD_DEADTIME_5) || \
                                    ((__TIME__) == LCD_DEADTIME_6) || \
                                    ((__TIME__) == LCD_DEADTIME_7) || \
                                    ((__TIME__) == LCD_DEADTIME_8) || \
                                    ((__TIME__) == LCD_DEADTIME_9) || \
                                    ((__TIME__) == LCD_DEADTIME_10) || \
                                    ((__TIME__) == LCD_DEADTIME_11) || \
                                    ((__TIME__) == LCD_DEADTIME_12) || \
                                    ((__TIME__) == LCD_DEADTIME_13) || \
                                    ((__TIME__) == LCD_DEADTIME_14) || \
                                    ((__TIME__) == LCD_DEADTIME_15))
/**
 * @}
 */


/** @name LCD_OverVoltageDetect LCD Over Voltage Detection
 * @{
 */
#define LCD_OVERVOLTAGEDETECT_ENABLE    LCD_CR1_OVD_DIS_enable_w    /*!<       */
#define LCD_OVERVOLTAGEDETECT_DISABLE   LCD_CR1_OVD_DIS_disable_w   /*!<       */

#define IS_LCD_OVER_VOLTAGE_DETECT_ENABLE(__VALUE__) (((__VALUE__) == LCD_OVERVOLTAGEDETECT_ENABLE) || \
                                                      ((__VALUE__) == LCD_OVERVOLTAGEDETECT_DISABLE))
/**
 * @}
 */


/** @name LCD_ResistorLadder LCD Resistor Ladder Selects
 * @{
 */
#define LCD_RESISTORLADDER_INTERNAL     LCD_CR0_RL_SEL_int_w    /*!< use Resistor Ladder Internal */
#define LCD_RESISTORLADDER_EXTERNAL     LCD_CR0_RL_SEL_ext_w    /*!< use Resistor Ladder External */

#define IS_LCD_RESISTO_RLADDER(RLADDER) (((RLADDER) == LCD_RESISTORLADDER_INTERNAL) || \
                                         ((RLADDER) == LCD_RESISTORLADDER_EXTERNAL))
/**
 * @}
 */


/** @name LCD_VoltageSource LCD Voltage Source
 * @{
 */
#define LCD_VOLTAGESOURCE_OFF           LCD_CR0_VS_SEL_off_w    /*!< OFF the LCD */
#define LCD_VOLTAGESOURCE_VDD           LCD_CR0_VS_SEL_avdd_w   /*!< VDD voltage source for the LCD */
#define LCD_VOLTAGESOURCE_EXTERNAL      LCD_CR0_VS_SEL_ext_w    /*!< External voltage source for the LCD */
#define LCD_VOLTAGESOURCE_CHARGEPUMP    LCD_CR0_VS_SEL_cp_w     /*!< Charge Pump voltage source for the LCD */

#define IS_LCD_VOLTAGE_SOURCE(SOURCE) (((SOURCE) == LCD_VOLTAGESOURCE_OFF) || \
                                       ((SOURCE) == LCD_VOLTAGESOURCE_VDD) || \
                                       ((SOURCE) == LCD_VOLTAGESOURCE_EXTERNAL) || \
                                       ((SOURCE) == LCD_VOLTAGESOURCE_CHARGEPUMP))
/**
 * @}
 */


/** @name LCD_Contrast LCD Contrast
 * @{
 */
#define LCD_CONTRASTLEVEL_0               LCD_CR1_VT_SEL_lvl0_w         /*!< Typecal Voltage = 2.36V    */
#define LCD_CONTRASTLEVEL_1               LCD_CR1_VT_SEL_lvl1_w         /*!< Typecal Voltage = 2.44V    */
#define LCD_CONTRASTLEVEL_2               LCD_CR1_VT_SEL_lvl2_w         /*!< Typecal Voltage = 2.52V    */
#define LCD_CONTRASTLEVEL_3               LCD_CR1_VT_SEL_lvl3_w         /*!< Typecal Voltage = 2.60V    */
#define LCD_CONTRASTLEVEL_4               LCD_CR1_VT_SEL_lvl4_w         /*!< Typecal Voltage = 3.68V    */
#define LCD_CONTRASTLEVEL_5               LCD_CR1_VT_SEL_lvl5_w         /*!< Typecal Voltage = 3.76V    */
#define LCD_CONTRASTLEVEL_6               LCD_CR1_VT_SEL_lvl6_w         /*!< Typecal Voltage = 3.84V    */
#define LCD_CONTRASTLEVEL_7               LCD_CR1_VT_SEL_lvl7_w         /*!< Typecal Voltage = 3.92V    */
#define LCD_CONTRASTLEVEL_8               LCD_CR1_VT_SEL_lvl8_w         /*!< Typecal Voltage = 3.00V    */
#define LCD_CONTRASTLEVEL_9               LCD_CR1_VT_SEL_lvl9_w         /*!< Typecal Voltage = 3.08V    */
#define LCD_CONTRASTLEVEL_10              LCD_CR1_VT_SEL_lvl10_w        /*!< Typecal Voltage = 3.16V    */
#define LCD_CONTRASTLEVEL_11              LCD_CR1_VT_SEL_lvl11_w        /*!< Typecal Voltage = 3.24V    */
#define LCD_CONTRASTLEVEL_12              LCD_CR1_VT_SEL_lvl12_w        /*!< Typecal Voltage = 3.32V    */
#define LCD_CONTRASTLEVEL_13              LCD_CR1_VT_SEL_lvl13_w        /*!< Typecal Voltage = 3.40V    */
#define LCD_CONTRASTLEVEL_14              LCD_CR1_VT_SEL_lvl14_w        /*!< Typecal Voltage = 3.48V    */
#define LCD_CONTRASTLEVEL_15              LCD_CR1_VT_SEL_lvl15_w        /*!< Typecal Voltage = 3.56V    */
#define LCD_CONTRASTLEVEL_MASK            LCD_CR1_VT_SEL_mask_w         /*!< Contrast Level Mask        */

#define IS_LCD_CONTRAST(__CONTRAST__) (((__CONTRAST__) == LCD_CONTRASTLEVEL_0) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_1) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_2) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_3) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_4) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_5) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_6) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_7) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_8) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_9) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_10) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_11) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_12) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_13) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_14) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_15) || \
                                       ((__CONTRAST__) == LCD_CONTRASTLEVEL_MASK))
/**
 * @}
 */


/** @name LCD_Bias LCD Bias
 * @{
 */
#define LCD_BIAS_STATIC                 LCD_CR0_BIAS_static_w   /*!< static Bias */
#define LCD_BIAS_1_2                    LCD_CR0_BIAS_b12_w      /*!< 1/2 Bias */
#define LCD_BIAS_1_3                    LCD_CR0_BIAS_b13_w      /*!< 1/3 Bias */
#define LCD_BIAS_1_4                    LCD_CR0_BIAS_b14_w      /*!< 1/4 Bias */

#define IS_LCD_BIAS(__BIAS__) (((__BIAS__) == LCD_BIAS_STATIC) || \
                               ((__BIAS__) == LCD_BIAS_1_2) || \
                               ((__BIAS__) == LCD_BIAS_1_3) || \
                               ((__BIAS__) == LCD_BIAS_1_4))
/**
 * @}
 */


/** @name LCD_PulseOnDuration LCD Pulse On Duration
 * @{
 */
#define LCD_PULSEONDURATION_0           (0x00000000UL)                  /*!< Pulse ON duration = 0 pulse   */
#define LCD_PULSEONDURATION_1           (0x01000000UL)                  /*!< Pulse ON duration = 1 / CK_LCD_INT  */
#define LCD_PULSEONDURATION_2           (0x02000000UL)                  /*!< Pulse ON duration = 2 / CK_LCD_INT  */
#define LCD_PULSEONDURATION_3           (0x03000000UL)                  /*!< Pulse ON duration = 3 / CK_LCD_INT  */
#define LCD_PULSEONDURATION_4           (0x04000000UL)                  /*!< Pulse ON duration = 4 / CK_LCD_INT  */
#define LCD_PULSEONDURATION_5           (0x05000000UL)                  /*!< Pulse ON duration = 5 / CK_LCD_INT  */
#define LCD_PULSEONDURATION_6           (0x06000000UL)                  /*!< Pulse ON duration = 6 / CK_LCD_INT  */
#define LCD_PULSEONDURATION_7           (0x07000000UL)                  /*!< Pulse ON duration = 7 / CK_LCD_INT  */

#define IS_LCD_PULSE_ON_DURATION(__DURATION__) (((__DURATION__) == LCD_PULSEONDURATION_0) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_1) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_2) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_3) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_4) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_5) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_6) || \
                                                ((__DURATION__) == LCD_PULSEONDURATION_7))
/**
 * @}
 */


/** @name LCD_HighDrive LCD HighDrive
 * @{
 */
#define LCD_HIGHDRIVE_0           LCD_CR1_DRV_MDS_normal_w        /*!< Low resistance Drive   */
#define LCD_HIGHDRIVE_1           LCD_CR1_DRV_MDS_high_w          /*!< High resistance Drive  */

#define IS_LCD_HIGHDRIVE(__HIGHDRIVE__) (((__HIGHDRIVE__) == LCD_HIGHDRIVE_0) || \
                                         ((__HIGHDRIVE__) == LCD_HIGHDRIVE_1))
/**
 * @}
 */


/** @name LCD_Flag LCD Flag
 * @{
 */
#define LCD_FLAG_BLKOF                  LCD_STA_BLKOFF_mask_w
#define LCD_FLAG_BLKON                  LCD_STA_BLKONF_mask_w
#define LCD_FLAG_CPR                    LCD_STA_CPRF_mask_w
#define LCD_FLAG_UDC                    LCD_STA_UDCF_mask_w
#define LCD_FLAG_SO                     LCD_STA_SOF_mask_w
#define LCD_FLAG_PRDY                   LCD_STA_PRDYF_mask_w
#define LCD_FLAG_DE                     LCD_STA_DEF_mask_w
/**
 * @}
 */


/** @name LCD_Interrupts LCD Interrupts
 * @{
 */
#define LCD_IT_BLKOFF                   LCD_INT_BLKOFF_IE_mask_w
#define LCD_IT_BLKON                    LCD_INT_BLKON_IE_mask_w
#define LCD_IT_CPR                      LCD_INT_CPR_IE_mask_w
#define LCD_IT_UDC                      LCD_INT_UDC_IE_mask_w
#define LCD_IT_SOF                      LCD_INT_SOF_IE_mask_w
#define LCD_IT_IEA                      LCD_INT_IEA_mask_w
/**
 * @}
 */


/** @name LCD_RAMRegister LCD RAMRegister
 * @{
 */
#define LCD_RAM_REGISTER0               (0x00000000U) /*!< LCD RAM Register 0  */
#define LCD_RAM_REGISTER1               (0x00000001U) /*!< LCD RAM Register 1  */
#define LCD_RAM_REGISTER2               (0x00000002U) /*!< LCD RAM Register 2  */
#define LCD_RAM_REGISTER3               (0x00000003U) /*!< LCD RAM Register 3  */
#define LCD_RAM_REGISTER4               (0x00000004U) /*!< LCD RAM Register 4  */
#define LCD_RAM_REGISTER5               (0x00000005U) /*!< LCD RAM Register 5  */
#define LCD_RAM_REGISTER6               (0x00000006U) /*!< LCD RAM Register 6  */
#define LCD_RAM_REGISTER7               (0x00000007U) /*!< LCD RAM Register 7  */
#define LCD_RAM_REGISTER8               (0x00000008U) /*!< LCD RAM Register 8  */
#define LCD_RAM_REGISTER9               (0x00000009U) /*!< LCD RAM Register 9  */
#define LCD_RAM_REGISTER10              (0x0000000AU) /*!< LCD RAM Register 10 */

#define IS_LCD_RAM_REGISTER(__REGISTER__) (((__REGISTER__) == LCD_RAM_REGISTER0) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER1) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER2) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER3) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER4) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER5) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER6) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER7) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER8) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER9) || \
                                           ((__REGISTER__) == LCD_RAM_REGISTER10))
/**
 * @}
 */


/** @name LCD_BlinkDivider LCD Blinking Clock CK_LCD_BLK Divider.
 * @{
 */
#define LCD_BLINKDIVIDER_4              LCD_CLK_CK_BDIV_div4_w                  /*!< The Blink Divider = CK_LCD_DIV4   */
#define LCD_BLINKDIVIDER_8              LCD_CLK_CK_BDIV_div8_w                  /*!< The Blink Divider = CK_LCD_DIV8   */
#define LCD_BLINKDIVIDER_16             LCD_CLK_CK_BDIV_div16_w                 /*!< The Blink Divider = CK_LCD_DIV16  */
#define LCD_BLINKDIVIDER_32             LCD_CLK_CK_BDIV_div32_w                 /*!< The Blink Divider = CK_LCD_DIV32  */
#define LCD_BLINKDIVIDER_MASK           LCD_CLK_CK_BDIV_mask_w                  /*!< The Blink Divider Mask            */

#define IS_LCD_BLINK_DIVIDER(__DIVIDER__) (((__DIVIDER__) == LCD_BLINKDIVIDER_4) || \
                                           ((__DIVIDER__) == LCD_BLINKDIVIDER_8) || \
                                           ((__DIVIDER__) == LCD_BLINKDIVIDER_16) || \
                                           ((__DIVIDER__) == LCD_BLINKDIVIDER_32) || \
                                           ((__DIVIDER__) == LCD_BLINKDIVIDER_MASK)
/**
 * @}
 */


/** @name LCD_BlinkMode LCD Blink Mode
 * @{
 */
#define LCD_BLINKMODE_OFF               LCD_CR2_BLK_MDS_disable_w               /*!< Blink disabled                             */
#define LCD_BLINKMODE_ON                LCD_CR2_BLK_MDS_all_w                   /*!< Blink enabled on SEG[0], COM[0] (1 pixel)  */

#define IS_LCD_BLINK_MODE(__MODE__) (((__MODE__) == LCD_BLINKMODE_OFF) || \
                                     ((__MODE__) == LCD_BLINKMODE_ON))
/**
 * @}
 */


/* Exported macro ------------------------------------------------------------*/
/*
 *****************************************************************************
 * @brief Reset LCD handle state
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_RESET_HANDLE_STATE(__HANDLE__)  ((__HANDLE__)->State = HAL_LCD_STATE_RESET)
#define __MID_LCD_RESET_HANDLE_STATE(__HANDLE__)  ((__HANDLE__)->State = HAL_LCD_STATE_RESET)


/*
 *****************************************************************************
 * @brief  Macro to configure the LCD dead time.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__DEADTIME__" specifies the LCD dead time.
 *   This parameter can be one of the following values:
 *     @arg LCD_DEADTIME_0: No dead Time
 *     @arg LCD_DEADTIME_1: One Phase between different couple of Frame
 *     @arg LCD_DEADTIME_2: Two Phase between different couple of Frame
 *     @arg LCD_DEADTIME_3: Three Phase between different couple of Frame
 *     @arg LCD_DEADTIME_4: Four Phase between different couple of Frame
 *     @arg LCD_DEADTIME_5: Five Phase between different couple of Frame
 *     @arg LCD_DEADTIME_6: Six Phase between different couple of Frame 
 *     @arg LCD_DEADTIME_7: Seven Phase between different couple of Frame
 *     @arg LCD_DEADTIME_8: Eight Phase between different couple of Frame
 *     @arg LCD_DEADTIME_9: Nine Phase between different couple of Frame
 *     @arg LCD_DEADTIME_10: Ten Phase between different couple of Frame
 *     @arg LCD_DEADTIME_11: Eleven Phase between different couple of Frame
 *     @arg LCD_DEADTIME_12: Twelve Phase between different couple of Frame
 *     @arg LCD_DEADTIME_13: Thirteen Phase between different couple of Frame
 *     @arg LCD_DEADTIME_14: Fourteen Phase between different couple of Frame
 *     @arg LCD_DEADTIME_15: Fifteen Phase between different couple of Frame
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_DEADTIME_CONFIG(__HANDLE__, __DEADTIME__)     (MODIFY_REG((__HANDLE__)->Instance->CR1.W, LCD_FCR_DEAD, (__DEADTIME__)))
#define __MID_LCD_DEADTIME_CONFIG(__HANDLE__, __DEADTIME__)     (MODIFY_REG((__HANDLE__)->Instance->CR1.W, LCD_FCR_DEAD, (__DEADTIME__)))


/*
 *****************************************************************************
 * @brief  macros to enables or disables the LCD
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_ENABLE(__HANDLE__)                (SET_BIT((__HANDLE__)->Instance->CR0.W, LCD_CR0_EN_mask_w))
#define __DRV_LCD_DISABLE(__HANDLE__)               (CLEAR_BIT((__HANDLE__)->Instance->CR0.W, LCD_CR0_EN_mask_w))
#define __MID_LCD_ENABLE(__HANDLE__)                (SET_BIT((__HANDLE__)->Instance->CR0.W, LCD_CR0_EN_mask_w))
#define __MID_LCD_DISABLE(__HANDLE__)               (CLEAR_BIT((__HANDLE__)->Instance->CR0.W, LCD_CR0_EN_mask_w))


/*
 *****************************************************************************
 * @brief  Macro to configure the LCD Contrast.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__CONTRAST__" specifies the LCD Contrast.
 *   This parameter can be one of the following values:
 *     @arg LCD_CONTRASTLEVEL_0: Typecal Voltage = 2.36V
 *     @arg LCD_CONTRASTLEVEL_1: Typecal Voltage = 2.44V
 *     @arg LCD_CONTRASTLEVEL_2: Typecal Voltage = 2.52V
 *     @arg LCD_CONTRASTLEVEL_3: Typecal Voltage = 2.60V
 *     @arg LCD_CONTRASTLEVEL_4: Typecal Voltage = 3.68V
 *     @arg LCD_CONTRASTLEVEL_5: Typecal Voltage = 3.76V
 *     @arg LCD_CONTRASTLEVEL_6: Typecal Voltage = 3.84V
 *     @arg LCD_CONTRASTLEVEL_7: Typecal Voltage = 3.92V
 *     @arg LCD_CONTRASTLEVEL_8: Typecal Voltage = 3.00V
 *     @arg LCD_CONTRASTLEVEL_9: Typecal Voltage = 3.08V
 *     @arg LCD_CONTRASTLEVEL_10: Typecal Voltage = 3.16V
 *     @arg LCD_CONTRASTLEVEL_11: Typecal Voltage = 3.24V
 *     @arg LCD_CONTRASTLEVEL_12: Typecal Voltage = 3.32V
 *     @arg LCD_CONTRASTLEVEL_13: Typecal Voltage = 3.40V
 *     @arg LCD_CONTRASTLEVEL_14: Typecal Voltage = 3.48V
 *     @arg LCD_CONTRASTLEVEL_15: Typecal Voltage = 3.56V
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_CONTRAST_CONFIG(__HANDLE__, __CONTRAST__) \
            MODIFY_REG((__HANDLE__)->Instance->CR1.W, LCD_CONTRASTLEVEL_MASK, (__CONTRAST__))

#define __MID_LCD_CONTRAST_CONFIG(__HANDLE__, __CONTRAST__) \
            MODIFY_REG((__HANDLE__)->Instance->CR1.W, LCD_CONTRASTLEVEL_MASK, (__CONTRAST__))


/*
 *****************************************************************************
 * @brief  Charge Pump to enables or disables the LCD
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_CHARGEPUMP_ENABLE(__HANDLE__)     (SET_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_CP_EN_mask_w))
#define __DRV_LCD_CHARGEPUMP_DISABLE(__HANDLE__)    (CLEAR_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_CP_EN_mask_w))
#define __MID_LCD_CHARGEPUMP_ENABLE(__HANDLE__)     (SET_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_CP_EN_mask_w))
#define __MID_LCD_CHARGEPUMP_DISABLE(__HANDLE__)    (CLEAR_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_CP_EN_mask_w))


/*
 *****************************************************************************
 * @brief  Macro to configure the LCD pulses on duration.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__DURATION__" specifies the LCD pulse on duration in terms of 
 *         CK_PS (prescaled LCD clock period) pulses.
 *   This parameter can be one of the following values:
 *     @arg LCD_PULSEONDURATION_0: 0 pulse
 *     @arg LCD_PULSEONDURATION_1: Pulse ON duration = 1 / CK_LCD_INT
 *     @arg LCD_PULSEONDURATION_2: Pulse ON duration = 2 / CK_LCD_INT
 *     @arg LCD_PULSEONDURATION_3: Pulse ON duration = 3 / CK_LCD_INT
 *     @arg LCD_PULSEONDURATION_4: Pulse ON duration = 4 / CK_LCD_INT
 *     @arg LCD_PULSEONDURATION_5: Pulse ON duration = 5 / CK_LCD_INT
 *     @arg LCD_PULSEONDURATION_6: Pulse ON duration = 6 / CK_LCD_INT
 *     @arg LCD_PULSEONDURATION_7: Pulse ON duration = 7 / CK_LCD_INT
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_PULSEONDURATION_CONFIG(__HANDLE__, __DURATION__)  MODIFY_REG((__HANDLE__)->Instance->CR1.W, LCD_CR1_DRV_PW_mask_w, (__DURATION__))
#define __MID_LCD_PULSEONDURATION_CONFIG(__HANDLE__, __DURATION__)  MODIFY_REG((__HANDLE__)->Instance->CR1.W, LCD_CR1_DRV_PW_mask_w, (__DURATION__))


/*
 *****************************************************************************
 * @brief  Macros to enable or disable the low resistance divider. Displays with high 
 *         internal resistance may need a longer drive time to achieve 
 *         satisfactory contrast. This function is useful in this case if some 
 *         additional power consumption can be tolerated.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @note   When this mode is enabled, the PulseOn Duration (PON) have to be 
 *         programmed to 1/CK_PS (LCD_PULSEONDURATION_1).
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_HIGHDRIVER_ENABLE(__HANDLE__)     (SET_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_DRV_MDS_mask_w))
#define __DRV_LCD_HIGHDRIVER_DISABLE(__HANDLE__)    (CLEAR_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_DRV_MDS_mask_w))
#define __MID_LCD_HIGHDRIVER_ENABLE(__HANDLE__)     (SET_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_DRV_MDS_mask_w))
#define __MID_LCD_HIGHDRIVER_DISABLE(__HANDLE__)    (CLEAR_BIT((__HANDLE__)->Instance->CR1.W, LCD_CR1_DRV_MDS_mask_w))


/**
 *****************************************************************************
 * @brief  Enables or disables the specified LCD interrupt.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__INTERRUPT__" specifies the LCD interrupt source to be enabled or disabled.
 *          This parameter can be one of the following values:
 *     @arg LCD_IT_BLKOFF : Blinking off interrupt enable interrupt
 *     @arg LCD_IT_BLKON : Blinking on interrupt enable interrupt
 *     @arg LCD_IT_CPR : Charge pump power ready interrupt
 *     @arg LCD_IT_UDC : Update display data completed interrupt
 *     @arg LCD_IT_SOF : Start of Frame interrupt
 *     @arg LCD_IT_IEA : LCD interrupt all interrupt
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_ENABLE_IT(__HANDLE__, __INTERRUPT__) \
                             SET_BIT((__HANDLE__)->Instance->INT.W, (__INTERRUPT__))

#define __DRV_LCD_DISABLE_IT(__HANDLE__, __INTERRUPT__) \
                             CLEAR_BIT((__HANDLE__)->Instance->INT.W, (__INTERRUPT__))

#define __MID_LCD_ENABLE_IT(__HANDLE__, __INTERRUPT__) \
                             SET_BIT((__HANDLE__)->Instance->INT.W, (__INTERRUPT__))

#define __MID_LCD_DISABLE_IT(__HANDLE__, __INTERRUPT__) \
                             CLEAR_BIT((__HANDLE__)->Instance->INT.W, (__INTERRUPT__))


/**
 *****************************************************************************
 * @brief  Checks whether the specified LCD interrupt is enabled or not.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__IT__" specifies the LCD interrupt source to check.
 *        This parameter can be one of the following values:
 *     @arg LCD_IT_BLKOFF : Blinking off interrupt enable interrupt
 *     @arg LCD_IT_BLKON : Blinking on interrupt enable interrupt
 *     @arg LCD_IT_CPR : Charge pump power ready interrupt
 *     @arg LCD_IT_UDC : Update display data completed interrupt
 *     @arg LCD_IT_SOF : Start of Frame interrupt
 *     @arg LCD_IT_IEA : LCD interrupt all interrupt
 * @retval The state of __INTERRUPT__ (TRUE or FALSE).
 *****************************************************************************
 */
#define __DRV_LCD_GET_IT_SOURCE(__HANDLE__, __IT__) (((__HANDLE__)->Instance->INT.W) & (__INTERRUPT__))
#define __MID_LCD_GET_IT_SOURCE(__HANDLE__, __IT__) (((__HANDLE__)->Instance->INT.W) & (__INTERRUPT__))


/**
 *****************************************************************************
 * @brief  Checks whether the specified LCD flag is set or not.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__FLAG__" specifies the flag to check.
 *        This parameter can be one of the following values:
 *        @arg LCD_FLAG_BLKOF : Blinking OFF.
 *        @arg LCD_FLAG_BLKON : Blinking ON.
 *        @arg LCD_FLAG_CPR : Charge pump power ready.
 *        @arg LCD_FLAG_UDC : Update display data completed.
 *        @arg LCD_FLAG_SO :  Start of frame.
 *        @arg LCD_FLAG_PRDY : Power source ready.
 *        @arg LCD_FLAG_DE : Display enabled.
 * @retval The new state of __FLAG__ (TRUE or FALSE).
 *****************************************************************************
 */
#define __DRV_LCD_GET_FLAG(__HANDLE__, __FLAG__)    (((__HANDLE__)->Instance->STA.W & (__FLAG__)) == (__FLAG__))
#define __MID_LCD_GET_FLAG(__HANDLE__, __FLAG__)    (((__HANDLE__)->Instance->STA.W & (__FLAG__)) == (__FLAG__))


/**
 *****************************************************************************
 * @brief  Clears the specified LCD pending flag.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__FLAG__" specifies the flag to clear.
 *        This parameter can be any combination of the following values:
 *        @arg LCD_FLAG_BLKOF : Blinking OFF.
 *        @arg LCD_FLAG_BLKON : Blinking ON.
 *        @arg LCD_FLAG_CPR : Charge pump power ready.
 *        @arg LCD_FLAG_UDC : Update display data completed.
 *        @arg LCD_FLAG_SO :  Start of frame.
 *        @arg LCD_FLAG_PRDY : Power source ready.
 *        @arg LCD_FLAG_DE : Display enabled.
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_CLEAR_FLAG(__HANDLE__, __FLAG__)  ((__HANDLE__)->Instance->STA.W = (__FLAG__))
#define __MID_LCD_CLEAR_FLAG(__HANDLE__, __FLAG__)  ((__HANDLE__)->Instance->STA.W = (__FLAG__))


/*
 *****************************************************************************
 * @brief  Macro to configure the LCD Blink mode and Blink frequency.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @param  "__BLINKDIVIDER__" specifies the LCD blink divider.
 *     @arg LCD_BLINKDIVIDER_4:    The Blink divider = fLcd/8
 *     @arg LCD_BLINKDIVIDER_8:    The Blink divider = fLcd/16
 *     @arg LCD_BLINKDIVIDER_16:   The Blink divider = fLcd/32
 *     @arg LCD_BLINKDIVIDER_32:   The Blink divider = fLcd/64 
 * @param  __BLINKCOUNT__ specifies the LCD blink count.
 *     @arg The Blink frame counter value 1 ~ 127
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_BLINK_CONFIG(__HANDLE__, __BLINKDIVIDER__, __BLINKCOUNT__)  \
            MODIFY_REG((__HANDLE__)->Instance->CLK.W, LCD_BLINKDIVIDER_MASK, (__BLINKDIVIDER__)); \
            MODIFY_REG((__HANDLE__)->Instance->CR2.W, LCD_CR2_LCD_CR2_BCNT_mask_w, ((__BLINKCOUNT__) << LCD_CR2_BCNT_shift_w))

#define __MID_LCD_BLINK_CONFIG(__HANDLE__, __BLINKDIVIDER__, __BLINKCOUNT__)  \
            MODIFY_REG((__HANDLE__)->Instance->CLK.W, LCD_BLINKDIVIDER_MASK, (__BLINKDIVIDER__)); \
            MODIFY_REG((__HANDLE__)->Instance->CR2.W, LCD_CR2_LCD_CR2_BCNT_mask_w, ((__BLINKCOUNT__) << LCD_CR2_BCNT_shift_w))


/**
 *****************************************************************************
 * @brief  Enables or disables the specified LCD Blink.
 * @param  "__HANDLE__" specifies the LCD Handle.
 * @retval None
 *****************************************************************************
 */
#define __DRV_LCD_BLINK_ENABLE(__HANDLE__) SET_BIT((__HANDLE__)->Instance->CR2.W, LCD_CR2_BLK_MDS_disable_w)
#define __MID_LCD_BLINK_ENABLE(__HANDLE__) SET_BIT((__HANDLE__)->Instance->CR2.W, LCD_CR2_BLK_MDS_disable_w)
#define __DRV_LCD_BLINK_DISABLE(__HANDLE__) CLEAR_BIT((__HANDLE__)->Instance->CR2.W, LCD_CR2_BLK_MDS_all_w)
#define __MID_LCD_BLINK_DISABLE(__HANDLE__) CLEAR_BIT((__HANDLE__)->Instance->CR2.W, LCD_CR2_BLK_MDS_all_w)


/* Exported functions prototypes ---------------------------------------------*/

/** @name LCD_Exported_Functions_Group1
 * @{
 */
/* Initialization/de-initialization methods  **********************************/
MID_StatusTypeDef MID_LCD_DeInit(LCD_HandleTypeDef *mlcd);
MID_StatusTypeDef MID_LCD_Init(LCD_HandleTypeDef *mlcd);
void MID_LCD_MspInit(LCD_HandleTypeDef *mlcd);
void MID_LCD_MspDeInit(LCD_HandleTypeDef *mlcd);

/**
 * @}
 */


/** @name LCD_Exported_Functions_Group2
 * @{
 */
/* IO operation methods *******************************************************/
MID_StatusTypeDef MID_LCD_DisplayDataUpdate(LCD_HandleTypeDef *mlcd, uint32_t *DataIndex);
MID_StatusTypeDef MID_LCD_Blink(LCD_HandleTypeDef *mlcd, FunctionalState State);
MID_StatusTypeDef MID_LCD_Clear(LCD_HandleTypeDef *mlcd);

/**
 * @}
 */


/** @name LCD_Exported_Functions_Group3
 * @{
 */
/* Peripheral State methods  **************************************************/
MID_LCD_StateTypeDef MID_LCD_GetState(LCD_HandleTypeDef *mlcd);
uint32_t MID_LCD_GetError(LCD_HandleTypeDef *mlcd);

/**
 * @}
 */


/** @name LCD_Private_Functions
 * @{
 */
/* Private functions ---------------------------------------------------------*/
MID_StatusTypeDef LCD_WaitForSynchro(LCD_HandleTypeDef *mlcd);

/**
 * @}
 */


/* Private defines -----------------------------------------------------------*/
/* USER CODE BEGIN Private defines */

/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* for #if defined(ModuleExist_LCD) */

#endif /* __MG32_LCD_MID_H */

