;/*
;********************************************************************************************************
;                                    EXCEPTION VECTORS & STARTUP CODE
;
; File      : cstartup.s
; For       : ARMv6M Cortex-M0
; Mode      : Thumb2
; Toolchain : RealView Development Suite
;             RealView Microcontroller Development Kit (MDK)
;             ARM Developer Suite (ADS)
;             Keil uVision
;********************************************************************************************************
;*/

;/*
;********************************************************************************************************
;*                           <<< Use Configuration Wizard in Context Menu >>>
;*
;* Note(s) : (1) The 猩ision4 Configuration Wizard enables menu driven configuration of assembler, 
;*               C/C++, or debugger initialization files. The Configuration Wizard uses control items 
;*               that are embedded into the comments of the configuration file.
;*
;********************************************************************************************************
;*/

;/*
;********************************************************************************************************
;*                                              STACK DEFINITIONS
;*
;* Configuration Wizard Menu:
;* // <h> Stack Configuration
;* //   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
;* // </h>;
;*********************************************************************************************************
;*/

STACK_SIZE      EQU     0x00000100
                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   STACK_SIZE
__initial_sp


;/*
;********************************************************************************************************
;*                                              STACK DEFINITIONS
; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>
;*********************************************************************************************************
;*/

HEAP_SIZE       EQU     0x00000100
                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   HEAP_SIZE
__heap_limit


                PRESERVE8
                THUMB


                                                      ; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
				IMPORT  BSP_IntHandlerWWDG
				IMPORT  BSP_IntHandlerSYS
				IMPORT  BSP_IntHandlerEXINT0
				IMPORT  BSP_IntHandlerEXINT1
				IMPORT  BSP_IntHandlerEXINT2
				IMPORT  BSP_IntHandlerEXINT3
				IMPORT  BSP_IntHandlerCOMP
				IMPORT  BSP_IntHandlerDMA
				IMPORT  BSP_IntHandlerADC
				IMPORT  BSP_IntHandlerDAC
				IMPORT  BSP_IntHandlerTM0x
				IMPORT  BSP_IntHandlerTM10
				IMPORT  BSP_IntHandlerTM1x
				IMPORT  BSP_IntHandlerTM20
				IMPORT  BSP_IntHandlerTM2x
				IMPORT  BSP_IntHandlerTM3x
				IMPORT  BSP_IntHandlerURT0
				IMPORT  BSP_IntHandlerURT123
				IMPORT  BSP_IntHandlerSPI0
				IMPORT  BSP_IntHandlerI2C0
				IMPORT  BSP_IntHandlerI2Cx
				IMPORT  BSP_IntHandlerUSB

                IMPORT  OS_CPU_PendSVHandler
                IMPORT  OS_CPU_SysTickHandler

__Vectors       DCD     __initial_sp                      ; Top of Stack
                DCD     Reset_Handler                     ; Reset Handler
                DCD     App_NMI_ISR                       ; NMI Handler
                DCD     App_Fault_ISR                     ; Hard Fault Handler
                DCD     App_MemFault_ISR                  ; MPU Fault Handler
                DCD     App_BusFault_ISR                  ; Bus Fault Handler
                DCD     App_UsageFault_ISR                ; Usage Fault Handler
                DCD     App_Spurious_ISR                  ; Reserved
                DCD     App_Spurious_ISR                  ; Reserved
                DCD     App_Spurious_ISR                  ; Reserved
                DCD     App_Spurious_ISR                  ; Reserved
                DCD     App_Spurious_ISR                  ; SVCall Handler
                DCD     App_Spurious_ISR                  ; Debug Monitor Handler
                DCD     App_Spurious_ISR                  ; Reserved
                DCD     OS_CPU_PendSVHandler              ; PendSV Handler
                DCD     OS_CPU_SysTickHandler             ; SysTick Handler

                                                          ;  External Interrupts
                DCD     BSP_IntHandlerWWDG                ; 16, INTISR[  0]  Window Watchdog.
                DCD     BSP_IntHandlerSYS                 ; 17, INTISR[  1]  SYS through EXTI Line Detection.
                DCD     App_Reserved_ISR                  ; 18, INTISR[  2]  
                DCD     BSP_IntHandlerEXINT0              ; 19, INTISR[  3]  EXINT0 Global Interrupt.
                DCD     BSP_IntHandlerEXINT1              ; 20, INTISR[  4]  EXINT1 Global Interrupt.
                DCD     BSP_IntHandlerEXINT2              ; 21, INTISR[  5]  EXINT2 Global Interrupt.
                DCD     BSP_IntHandlerEXINT3              ; 22, INTISR[  6]  EXINT3 Global Interrupt.
                DCD     BSP_IntHandlerCOMP                ; 23, INTISR[  7]  COMP Global Interrupt.
                DCD     BSP_IntHandlerDMA                 ; 24, INTISR[  8]  DMA Global Interrupt.
                DCD     App_Reserved_ISR                  ; 25, INTISR[  9]  
                DCD     BSP_IntHandlerADC                 ; 26, INTISR[ 10]  ADC Global Interrupt.
                DCD     BSP_IntHandlerDAC                 ; 27, INTISR[ 11]  DAC Global Interrupt.
                DCD     BSP_IntHandlerTM0x                ; 28, INTISR[ 12]  TM0x Global Interrupt.
                DCD     BSP_IntHandlerTM10                ; 29, INTISR[ 13]  TM10 Global Interrupt.
                DCD     BSP_IntHandlerTM1x                ; 30, INTISR[ 14]  TM1x Global Interrupt.
                DCD     BSP_IntHandlerTM20                ; 31, INTISR[ 15]  TM20 Global Interrupt.
                DCD     BSP_IntHandlerTM2x                ; 32, INTISR[ 16]  TM2x Global Interrupt.
                DCD     BSP_IntHandlerTM3x                ; 33, INTISR[ 17]  TM3x Global Interrupt.
				DCD     App_Reserved_ISR                  ; 34, INTISR[ 18]  
                DCD     App_Reserved_ISR                  ; 35, INTISR[ 19]  
                DCD     BSP_IntHandlerURT0                ; 36, INTISR[ 20]  URT0 Global Interrupts.
                DCD     BSP_IntHandlerURT123              ; 37, INTISR[ 21]  URT123 Global Interrupts.
                DCD     App_Reserved_ISR                  ; 38, INTISR[ 22]  
                DCD     App_Reserved_ISR                  ; 39, INTISR[ 23]  
                DCD     BSP_IntHandlerSPI0                ; 40, INTISR[ 24]  SPI0 Global Interrupt.
                DCD     App_Reserved_ISR                  ; 41, INTISR[ 25]  
                DCD     App_Reserved_ISR                  ; 42, INTISR[ 26]  
                DCD     App_Reserved_ISR                  ; 43, INTISR[ 27]  
                DCD     BSP_IntHandlerI2C0                ; 44, INTISR[ 28]  I2C0 Global Interrupt.
				DCD     BSP_IntHandlerI2Cx                ; 45, INTISR[ 29]  I2C1 Global Interrupt.
                DCD     BSP_IntHandlerUSB                 ; 46, INTISR[ 30]  USB Global Interrupt.
				DCD     App_Reserved_ISR                  ; 47, INTISR[ 31]  
                
                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC    
                EXPORT  Reset_Handler                 [WEAK]
                IMPORT  __main

                LDR     R0, =__main
                BX      R0
                ENDP

; Dummy Exception Handlers (infinite loops which can be modified)                

App_NMI_ISR      PROC
                EXPORT  App_NMI_ISR                   [WEAK]
                B       .
                ENDP
App_Fault_ISR\
                PROC
                EXPORT  App_Fault_ISR                 [WEAK]
                B       .
                ENDP
App_MemFault_ISR\
                PROC
                EXPORT  App_MemFault_ISR             [WEAK]
                B       .
                ENDP
App_BusFault_ISR\
                PROC
                EXPORT  App_BusFault_ISR             [WEAK]
                B       .
                ENDP
App_UsageFault_ISR\
                PROC
                EXPORT  App_UsageFault_ISR            [WEAK]
                B       .
                ENDP
App_Spurious_ISR\
                PROC
                EXPORT  App_Spurious_ISR                [WEAK]
                B       .
                ENDP
App_Reserved_ISR\
                PROC
                EXPORT  App_Reserved_ISR                [WEAK]
                B       .
                ENDP


                ALIGN


                                                                ; User Initial Stack & Heap

                IF      :DEF:__MICROLIB
                
                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit
                
                ELSE
                
                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap

__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + STACK_SIZE)
                LDR     R2, =(Heap_Mem  +  HEAP_SIZE)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END
