


/**
 ******************************************************************************
 *
 * @file        TH222x_2_ARGB.c
 * @brief       This is to test TH222x ARGB C file.
 
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_IWDT_DRV.h"
#include "TH222x_Global.h"
#include "BSP_2_ARGB_WS2812.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define TH222x_ARGB_COLOR       4

#define TH222x_ARGB_PIECE       14

#define TH222x_ARGB_G           0
#define TH222x_ARGB_R           1
#define TH222x_ARGB_B           2



/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_ARGB_UpdateFlag;

static uint8_t  TH222x_ARGB_Status;
static uint16_t TH222x_ARGB_DramaTime;
static uint16_t TH222x_ARGB_DramaTimeMax;
static uint8_t  TH222x_ARGB_DramaAct;
static uint8_t  TH222x_ARGB_DramaActMax;
                                          
static uint8_t TH222x_ARGB_DramaBUF[TH222x_ARGB_PIECE * 3];                   /*!<.The buffer is use for ARGB calculate.*/


const static uint8_t TH222x_ARGBDefault_TABLE[TH222x_ARGB_COLOR][3] = {
                                                                          {0 ,   5 ,   0},    // 1st Color : [G : R : B ] = [  0, 50,  0]
                                                                          {5 ,   0 ,   0},    // 2nd Color : [G : R : B ] = [ 50,  0,  0]
                                                                          {0 ,   0 ,   5},    // 3rd Color : [G : R : B ] = [  0,  0, 50] 
                                                                          {5 ,   5 ,   5},    // 4th Color : [G : R : B ] = [ 50, 50, 50]
                                                                      };

/* Private function prototypes -----------------------------------------------*/                                                                   
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

                                                                      
/**
 *******************************************************************************
 * @brief	   TH222x ARGB parameter default initial.
 * @details     
 * @return      
 * @note       No
 *******************************************************************************
 */
void TH222x_ARGBParameter_DeInit(void)
{
    uint8_t TH222x_ARGB_DeInitTmp;
    
    TH222x_ARGB_UpdateFlag = 0;
    
    TH222x_ARGB_DramaTime      = 0;
    TH222x_ARGB_DramaTimeMax   = 400;
    
    TH222x_ARGB_DramaAct       = 0;
    TH222x_ARGB_DramaActMax    = (TH222x_ARGB_COLOR - 1);
    
    
    /*Clear ARGB data*/
    for( TH222x_ARGB_DeInitTmp = 0; TH222x_ARGB_DeInitTmp < (TH222x_ARGB_PIECE*3); TH222x_ARGB_DeInitTmp++)
    {
        TH222x_ARGB_DramaBUF[TH222x_ARGB_DeInitTmp] = 0;
    }
    
    TH222x_ARGB_Status         = TH222x_READY;
}
/**
 *******************************************************************************
 * @brief	   TH222x ARGB main function.
 * @details     
 * @return      
 * @note       No
 *******************************************************************************
 */
void TH222x_ARGB(void)
{
    uint8_t TH222x_ARGB_Tmp;
    uint8_t TH222x_ARGB_Adr;
    
    if( TH222x_ARGB_UpdateFlag == 0)
    {
        return;
    }
    
    TH222x_ARGB_UpdateFlag = 0;
    
    if( TH222x_ARGB_Status == TH222x_READY)
    {
        TH222x_ARGB_Status = TH222x_BUSY;
        
        NVIC_SetPriority(EXINT3_IRQn,1);
        BSP_ARGB_SendData(TH222x_ARGB_DramaBUF,TH222x_ARGB_PIECE);
    }
    
    if( TH222x_ARGB_DramaTime < TH222x_ARGB_DramaTimeMax)
    {
        TH222x_ARGB_DramaTime = TH222x_ARGB_DramaTime + 1;
        return;
    }
    TH222x_ARGB_DramaTime = 0;
    TH222x_ARGB_Adr       = 0;
    
    for( TH222x_ARGB_Tmp = 0; TH222x_ARGB_Tmp < TH222x_ARGB_PIECE; TH222x_ARGB_Tmp++)
    {
        TH222x_ARGB_Adr = (TH222x_ARGB_Tmp * 3);
        
        TH222x_ARGB_DramaBUF[TH222x_ARGB_Adr + TH222x_ARGB_G] = TH222x_ARGBDefault_TABLE[TH222x_ARGB_DramaAct][TH222x_ARGB_G];
        TH222x_ARGB_DramaBUF[TH222x_ARGB_Adr + TH222x_ARGB_R] = TH222x_ARGBDefault_TABLE[TH222x_ARGB_DramaAct][TH222x_ARGB_R];
        TH222x_ARGB_DramaBUF[TH222x_ARGB_Adr + TH222x_ARGB_B] = TH222x_ARGBDefault_TABLE[TH222x_ARGB_DramaAct][TH222x_ARGB_B];
    }
    TH222x_ARGB_Status = TH222x_ARGB_Status | TH222x_READY;
    
    TH222x_ARGB_DramaAct = TH222x_ARGB_DramaAct + 1;
    
    if ( TH222x_ARGB_DramaAct > TH222x_ARGB_DramaActMax)
    {
        TH222x_ARGB_DramaAct = 0;
    }
}
/**
 *******************************************************************************
 * @brief	   
 * @details     
 * @return      
 * @note       No
 *******************************************************************************
 */
void BSP_ARGB_CpltCallback(void) 
{
    NVIC_SetPriority(EXINT3_IRQn,0);
    TH222x_ARGB_Status = TH222x_ARGB_Status & (uint8_t)(~TH222x_BUSY);
    IWDT_RefreshCounter();
}





