/**
 ******************************************************************************
 *
 * @file        BSP_VariableResistor.c
 * @brief       This is Variable Resistor C file
 
 * @par         Project
 *              MG32F02K128
 * @version     V1.00
 * @date        2024/08/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "BSP_LED.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define BSP_LED0_PINX      PINE(8)
#define BSP_LED1_PINX      PINE(9)

#define BSP_LED0_PIN       PE8
#define BSP_LED1_PIN       PE9

/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function ----------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       LED initial.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_LED_Init(void)
{
    PIN_InitTypeDef  LED_Pin;

    /*Pin configure*/
    LED_Pin.PINX_Mode               = PINX_Mode_PushPull_O;
    LED_Pin.PINX_PUResistant        = PINX_PUResistant_Disable;
    LED_Pin.PINX_Speed              = PINX_Speed_High;
    LED_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    LED_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    LED_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    LED_Pin.PINX_Alternate_Function = 0;
    GPIO_PinMode_Config(BSP_LED0_PINX, &LED_Pin);
    GPIO_PinMode_Config(BSP_LED1_PINX, &LED_Pin);
}

/**
 *******************************************************************************
 * @brief       LED control
 * @details     
 * @param[in]   LED_Number:
 *  @arg\b      BSP_LED0 : Control LED0
 *  @arg\b      BSP_LED1 : Control LED1
 * @param[in]   LEDn_ON_OFF:
 *  @arg\b      BSP_LED_ON : LED ON
 *  @arg\b      BSP_LED_OFF: LED OFF
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_LED_Cmd( uint8_t LED_Number, uint8_t LEDn_ON_OFF)
{
    if( LED_Number == BSP_LED0)
    {
        BSP_LED0_PIN = LEDn_ON_OFF;
    }
    else
    {
        BSP_LED1_PIN = LEDn_ON_OFF;
    }
}

