



/**
 ******************************************************************************
 *
 * @file        MG32_Common_API.c
 * @brief       Common C file.
 
 * @par         Project
 *              Mouse
 * @version     V1.00
 * @date        2022/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/ 
 
 
/**
 *******************************************************************************
 * @brief	    GPIO initial
 * @details     Pin mode initial
 * @param[in]   PinName: PINA(n) ~ PIND(n) (n = 0 ~ 15)
 * @param[in]   PinMode: 
 *   @arg\b     Analog_Mode: IO mode control.
 *   @arg\b     Data_DIR_OUT_QB      : Quasi-Birdirectional output.
 *   @arg\b     Data_DIR_OUT_OD_NoRU : Open drain output and disable internal pull-up resister.
 *   @arg\b     Data_DIR_OUT_OD_RU   : Open drain output with internal pull-up resister.
 *   @arg\b     Data_DIR_OUT_PP      : Push pull output.
 *   @arg\b     Data_DIR_IN_NoRU     : Digital input and disable internal pull-up resister.
 *   @arg\b     Data_DIR_IN_RU       : Digital input with internal pull-up resister.
 * @param[in]   PinAFS: Pin alternate function select.
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */ 
void GPIO_PinConfig(Pin_Struct* PinName , GPIO_Mode_TypeDef PinMode , uint8_t PinAFS)
{
    PIN_InitTypeDef                 PINX_InitStruct;
    
    
    if( PinMode == Data_DIR_OUT_QB)
    {
        PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
        PINX_InitStruct.PINX_Mode               = PINX_Mode_Quasi_IO;
        PINX_InitStruct.PINX_Speed              = PINX_Speed_High;
    }
    else if( PinMode == Data_DIR_OUT_OD_NoRU)
    {
        PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Disable;
        PINX_InitStruct.PINX_Mode				= PINX_Mode_OpenDrain_O;
        PINX_InitStruct.PINX_Speed              = PINX_Speed_High;
    }
    else if( PinMode == Data_DIR_OUT_OD_RU)
    {
        PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
        PINX_InitStruct.PINX_Mode				= PINX_Mode_OpenDrain_O;
        PINX_InitStruct.PINX_Speed              = PINX_Speed_High;
    }
    else if( PinMode == Data_DIR_OUT_PP)
    {
         PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
         PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O;
         PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;
    }
    else if( PinMode == Data_DIR_IN_NoRU)
    {
        PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Disable;
        PINX_InitStruct.PINX_Mode				= PINX_Mode_Digital_I;
        PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;
    }
    else if( PinMode == Data_DIR_IN_RU)
    {
        PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
        PINX_InitStruct.PINX_Mode				= PINX_Mode_Digital_I;
        PINX_InitStruct.PINX_Speed              = PINX_Speed_High;
    }
    else 
    {
        PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Disable;
        PINX_InitStruct.PINX_Mode				= PINX_Mode_Analog_IO;
        PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;
    }

    PINX_InitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    PINX_InitStruct.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    PINX_InitStruct.PINX_Inverse            = PINX_Inverse_Disable;
    PINX_InitStruct.PINX_Alternate_Function = PinAFS;
    GPIO_PinMode_Config(PinName,&PINX_InitStruct);  
}




