

/**
 ******************************************************************************
 *
 * @file        TH222x_9_RotaryEncoder.c
 * @brief       This is to test TH222x Rotary Encoder C file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/08
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_9_RotaryEncoder.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_RotaryEncoder_UpdateFlag;                    // UpdateFlag=0 (Nothing)    
                                                            // UpdateFlag=1 (Needs to do ...)

// ----------------------------------------------------------------------------
#if BSP_18_7SEGMENT_DISPLAY == 1
static int16_t TH222x_RotaryEncoderStatus;                  // 0 ~ TH222x_RotaryEncoderStatus+TH222x_RotaryEncoderTmp
#endif

static int32_t TH222x_RotaryEncoderTime;                    // The range is 0~400.
    
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       Rotary Encoder parameter default initial.  
 * @details     Deinitial "Rotary Encoder"'s parameter
 *              1. TH222x_RotaryEncoder_UpdateFlag=0
 *              2. TH222x_RotaryEncoderTime=0
 *              3. TH222x_RotaryEncoderStatus=0 (when enable 4x7-SEG display)
 * @return      None
 *******************************************************************************
 */
void TH222x_RotaryEncoderParameter_DeInit(void)
{
    // ------------------------------------------------------------------------
    TH222x_RotaryEncoder_UpdateFlag = 0;					// No update event

    TH222x_RotaryEncoderTime        = 0;
    
    // ------------------------------------------------------------------------
    #if BSP_18_7SEGMENT_DISPLAY == 1
        TH222x_RotaryEncoderStatus  = 0;
    #endif
}

/**
 *******************************************************************************
 * @brief	    Rotary Encoder main flow.
 * @details     Rotary function
 * 				1. Clockwise direction will turn on R-LED.
 * 				2. AntiClockwise direction will turn on G-LED.
 * 				3. Press Rotary Encoder will turn on Y-LED.
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_RotaryEncoder(void)
{
    int16_t TH222x_RotaryEncoderTmp;
    
    // ------------------------------------------------------------------------
    // untile TH222x_RotaryEncoder_UpdateFlag=1 (SysTick control this item)
    // ------------------------------------------------------------------------
    if(TH222x_RotaryEncoder_UpdateFlag==0)
    {
        return;
    }  
    TH222x_RotaryEncoder_UpdateFlag = 0;
    
    // ------------------------------------------------------------------------
    // Clear rotary encoder counter accumulatied value if 2s no change status.
    // ------------------------------------------------------------------------
    if(TH222x_RotaryEncoderTime == 400)
    {
        #if BSP_18_7SEGMENT_DISPLAY == 1
            TH222x_RotaryEncoderStatus = 0;
        #endif
        TH222x_RotaryEncoderTime   = 0;
    }
    
    // ------------------------------------------------------------------------
    // Detect rotary encoder status.
    // ------------------------------------------------------------------------
    BSP_RotaryEncoder_main();
    
    // ------------------------------------------------------------------------
    // To check rotary encoder status whether change or not.
    // ------------------------------------------------------------------------
    if(Rotary_CTR.ChangeFlag == 0)
    {
        TH222x_RotaryEncoderTime = TH222x_RotaryEncoderTime + 1;
        return;
    }
    TH222x_RotaryEncoderTime = 0;
    
    // ------------------------------------------------------------------------
    // Light on TH223x's Y-LED if M-Key status change (Press event)
    // ------------------------------------------------------------------------
    if(Rotary_CTR.ChangeFlag & ROTARY_CHANGEFLAG_BUTTON)
    {
        TH222x_CTR.GLED_Count = TH222x_CTR.LED_CountMax;
        TH222x_CTR.RLED_Count = TH222x_CTR.LED_CountMax;
        TH222x_CTR.YLED_Count = 0;

        TH222x_CTR.YLED_Lock  = 1;
    }
    
    // ------------------------------------------------------------------------
    // Rotary encoder.
    // ------------------------------------------------------------------------
    if(Rotary_CTR.ChangeFlag & ROTARY_CHANGEFLAG_ENCODE) 
    {
        TH222x_RotaryEncoderTmp    = (int16_t)Rotary_CTR.Encoder_Status;
        
        // Light on TH223x G-LED if rotary encoder is negative.
        if(TH222x_RotaryEncoderTmp < 0)
        {
            TH222x_CTR.YLED_Count = TH222x_CTR.LED_CountMax;
            TH222x_CTR.RLED_Count = TH222x_CTR.LED_CountMax;
            
            TH222x_CTR.GLED_Lock  = 1;
            TH222x_CTR.GLED_Count = 0;
        }
        // Light on TH223x R-LED if rotary encoder is positive .
        else
        {
            TH222x_CTR.YLED_Count = TH222x_CTR.LED_CountMax;
            TH222x_CTR.GLED_Count = TH222x_CTR.LED_CountMax;
            
            TH222x_CTR.RLED_Lock  = 1;
            TH222x_CTR.RLED_Count = 0;
        }
        // If 7Segment module enable 7Segment display rotary encoder counter accumulatied value.
        #if BSP_18_7SEGMENT_DISPLAY == 1
            TH222x_RotaryEncoderStatus = TH222x_RotaryEncoderStatus + TH222x_RotaryEncoderTmp;
            if(TH222x_RotaryEncoderStatus < 0)
            {
                TH222x_7Segment_ShowSignedValue((int16_t)TH222x_RotaryEncoderStatus);
            }
            else
            {
                TH222x_7Segment_ShowSignedValue((int16_t)TH222x_RotaryEncoderStatus);
            }
        #endif
    }

    Rotary_CTR.ChangeFlag = 0;
}












