


/**
 ******************************************************************************
 *
 * @file        BSP_7Segment.h
 * @brief       This is seven seqment display H file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/04/20
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _BSP_7SEGMENT_H

#define _BSP_7SEGMENT_H

#include "MG32.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_GPL_DRV.h"


/**
 * @name define
 *   		
 */ 
///@{

#define SEG7_DPMASK_NONE        0x00        // No display
#define SEG7_DPMASK_2ND         0x01        // '.' 
#define SEG7_DPMASK_COLON       0x02        // COLON is ':'
#define SEG7_DPMASK_3RD         0x04        // '.' 
#define SEG7_DPMASK_4TH         0x08        // '.' 


#define SEG7_DISPLAY_SUCCESS    0
#define SEG7_DISPLAY_FAILURE    1

///@}


/**
 * @name function
 *   		
 */ 
///@{
void BSP_7Segment_Init(void);
void BSP_7Segment_main(void);

void BSP_7Segment_Disable(void);
uint8_t BSP_7Segment_ShowSignedValue(int16_t SEG7_iValueX, uint8_t SEG7_iVaule_DP);
uint8_t BSP_7Segment_ShowUnsignedValue(uint16_t SEG7_uValue, uint8_t SEG_uValue_DP );
void BSP_7Segment_TriggerUserDefineDisplay(void);
///@}




#endif


