/**
 ******************************************************************************
 *
 * @file        BSP_12_BLE.h
 * @brief       BLE HC06 BSP h Code.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/01/06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2021 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 

#ifndef _BSP_BLE_H
#define _BSP_BLE_H


#include "MG32__Common_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_URT_DRV.h"


/**
 * @name define
 *   		
 */ 
///@{
// ----------------------------------------------------------------------------
#define BufferSize              64              			// DataBuffer size

#define RX_Timout_MAX			5							// 5: 20ms

// ----------------------------------------------------------------------------
// if BLE can't reply 'OK' character that record state.
#define State_ConnectFail       0x01                        // State, connect fail flag
#define State_VersionFail       0x02                        // State, got version fail flag
#define State_NameFail          0x04                        // State, set name fail flag
#define State_PINFail           0x08                        // State, set PIN fail flag
#define State_BaudrateFail      0x10                        // State, set baud rate fail flag

// ----------------------------------------------------------------------------
// BLE initial state level (TX mode)
#define BLE_IDLE				0x00						// BLE in idle state
#define BLE_ACTIVE				0x10						// BLE requests HC-06 to active
#define BLE_VERSION				0x20						// BLE requests HC-06 version
#define BLE_BAUD4				0x30						// BLE requests HC-06 baudrate
#define BLE_NAME				0x40						// BLE requests HC-06 name.
#define BLE_PIN					0x50						// BLE set HC-06 pins
#define BLE_QNAME				0x60						// Query/Set Device Name
#define BLE_TXRXmode			0x70						// BLE in TX/RX mode

// BLE has received the complete
#define BLE_RX_Complete			0x01						// BLE Receive complete
///@}


/**
 * @name typedef
 *   		
 */ 
///@{
typedef struct
{
    uint8_t  DataBuffer[BufferSize];   						// TX/RX data buffer (Ring buffer)

    uint8_t* TX_POINTER;       	 							// URT1 TX source index

    uint8_t* RX_POINTER;       	 							// URT1 RX source index

    uint8_t* RX_Old_POINTER;                                // Previous RX pointer for TX

    uint8_t  TX_LENGTH;       	 							// URT1 TX remain length

    uint8_t  RX_LENGTH;       	 							// URT1 RX remain length

    uint8_t  BLE_InitState;									// Reference :
    														//   {BLE_IDLE, BLE_ACTIVE, BLE_VERSION, BLE_BAUD4, BLE_NAME, BLE_PIN}

    uint16_t  RX_Timeout;									//    RX timeout counter : 0~RX_Timout_MAX}

    uint8_t  BLE_HC06_State;								// BLE HC06 Error state.
    														// Reference :
    														//   {State_ConnectFail, State_VersionFail, State_NameFail,
    														//    State_PINFail, State_BaudrateFail}

} BLE_HC06_CHAR;


///@}

/**
 * @name variables
 *   		
 */ 
///@{
///@}

/**
 * @name function
 *   		
 */ 
///@{
// in BSP_12_BLE.c
void BSP_URT1_Init9600 (void);
void BLE_TransmitData (uint8_t* TX_Index, uint8_t TX_Number);
void URT123_IRQHandler(void);

//For TH222x_12_BLE.c
void TH222x_BLEParameter_DeInit(void);
void TH222x_BLE_Init(void);
void TH222x_BLE(void);
void TH222x_BLE_InitProcess(void);
///@}



#endif



