
/**
 ******************************************************************************
 *
 * @file        EPD_2in13V3_Function.h
 *              
 * @brief       This file contains all the functions prototypes for the EPD_2in13_Function 
 *              firmware library.
 *              
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2023/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */


#if !defined(_WAVESHARE_2in13_EPD_H)

/*!< _WAVESHARE_2in13_EPD_H */ 
#define _WAVESHARE_2in13_EPD_H


/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_DRV.h"
#include "MG32_MID.h"

/* External function prototypes ----------------------------------------------*/

/* Private includes ----------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/

// WaveShare 2.13" Command Table
#define Driver_Output_control                   0x01    
#define Gate_Driving_voltage_control            0x03
#define Source_Driving_voltage_control          0x04
#define User_Command_OTP_Program                0x08
#define Write_Register_for_User_Command         0x09
#define Read_Register_for_User_Command          0x0A
#define Booster_Soft_start_Control              0x0C
#define Deep_Sleep_mode                         0x10
#define Data_Entry_mode_setting                 0x11
#define SW_RESET                                0x12
#define HV_Ready_Detection                      0x14
#define VCI_Detection                           0x15

// Temperature Control
#define Temperature_Sensor_Control              0x18
#define Temperature_Sensor_Control_Write_Reg    0x1A

// Display Control
#define Master_Activation                       0x20
#define Display_Update_Control_1                0x21
#define Display_Update_Control_2                0x22

// RAM Write/Read
#define Write_RAM                               0x24
#define Write_RAM_RED                           0x26

// VCOM / OTP 
#define Write_VCOM_register                     0x2C
#define OTP_Register_Read_for_Display_Option    0x2D
#define Status_Bit_Read                         0x2F
#define Program_WS_OTP                          0x30

// LUT control
#define Write_LUT_register                      0x32
#define OTP_program_mode                        0x39
#define Border_Waveform_Control                 0x3C

// Window Size / Address
#define Set_RAM_X_address_Start_End_position    0x44
#define Set_RAM_Y_address_Start_End_position    0x45
#define Set_RAM_X_address_counter               0x4E
#define Set_RAM_Y_address_counter               0x4F



/* Private define ------------------------------------------------------------*/
/**
  * @brief  EPD Control pin
  */
#define EPD_CS_Pin                              PB0
#define EPD_CS_GPIO_PORT                        GPIOB

/**
  * @brief  EPD Command/data pin = PB4
  */
#define EPD_CMD_DAT_Pin                         PB4
#define EPD_CmdData_GPIO_PORT                   GPIOB

/**
  * @brief  EPD Reset pin
  */
#define EPD_RESET_Pin                           PB5
#define EPD_RESET_GPIO_PORT                     GPIOB

/**
  * @brief  EPD Busy pin
  */
#define EPD_BUSY_Pin                            PB6
#define EPD_BUSY_GPIO_PORT                      GPIOB

/**
  * @brief  EPD PWR pin (less this pin) 
  */
//#define EPD_PWR_Pin                             PB7
//#define EPD_PWR_GPIO_PORT                       GPIOB


/*################################ EPD #######################################*/ 
/* Chip Select macro definition */
#define EPD_CS_LOW()                            EPD_CS_Pin = 0
#define EPD_CS_HIGH()                           EPD_CS_Pin = 1

/* EPD Data/Command macro definition */
#define EPD_CMD_LOW()                           EPD_CMD_DAT_Pin = 0
#define EPD_DAT_HIGH()                          EPD_CMD_DAT_Pin = 1

/* EPD Reset macro definition */
#define EPD_RESET_ACTIVE()                      EPD_RESET_Pin = 0
#define EPD_RESET_INACTIVE()                    EPD_RESET_Pin = 1

/* EPD BUSY macro definition */              
#define EPD_WAIT_BUSY_LOW()                     while(EPD_BUSY_Pin == 1)
                
/* EPD PWR macro definition (less this pin) */              
//#define EPD_PWR_LOW()                           EPD_PWR_Pin = 0
//#define EPD_PWR_HIGH()                          EPD_PWR_Pin = 1


/* Private macro -------------------------------------------------------------*/

/* Private variables ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/

/* Private user code ---------------------------------------------------------*/


/**
 * @name	Function announce
 *   		
 */ 
///@{  
/* EPD Command/Data Write Functions */
void EPD_IO_V3_WriteData(uint8_t RegValue); 
void EPD_IO_V3_WriteReg(uint8_t Reg);
/* EPD Control Functions */
void EPD_2in13_V3_Reset(void);
void EPD_2in13_V3_SetWindoes(uint16_t Xstart, uint16_t Ystart, uint16_t Xend, uint16_t Yend);
void EPD_2in13_V3_SetCursor(uint16_t Xstart, uint16_t Ystart);
void EPD_2in13_V3_UpdateLUT(uint8_t *LUT);
void EPD_2in13_V3_EntrySLEEP(void);
void EPD_RefreshDisplay(void);
/* EPD All Screen Functions */
void EPD_2in13_V3_Full_Init(void);
void EPD_2IN13_V3_Draw_All_Screen(uint8_t *ptr8);
void EPD_2IN13_V3_Clear(void);
/* EPD Partial Functions */
void EPD_2IN13_V3_Draw_Partial_Pattern(uint8_t StartX, uint8_t StartY, uint8_t Width, uint8_t Hight, uint8_t *ptr8);
void EPD_2IN13_V3_Draw_Font17x24(uint8_t x, uint8_t y, uint8_t *ptr8);

///@}

#endif
