/**
 ******************************************************************************
 *
 * @file        MG32_USB.h
 *
 * @brief       MG32 USB Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:38 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_USB_H
#define _MG32_USB_H
#define _MG32_USB_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_USB_H_VER)
    #error "_MG32_USB_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      USB_Struct
 *              USB  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  BUSYF         :1;     //[0] USB data transfer busy flag.
            __I  uint8_t  BUSF          :1;     //[1] USB bus event global interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t  ERRF          :1;     //[3] USB bus error global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  SOF           :1;     //[4] USB host SOF received interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ESOF          :1;     //[5] USB expected start of frame interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  LPMF          :1;     //[7] USB LPM L1 state request interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP0F          :1;     //[8] USB endpoint-0 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP1F          :1;     //[9] USB endpoint-1 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP2F          :1;     //[10] USB endpoint-2 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP3F          :1;     //[11] USB endpoint-3 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP4F          :1;     //[12] USB endpoint-4 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP5F          :1;     //[13] USB endpoint-5 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP6F          :1;     //[14] USB endpoint-6 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  EP7F          :1;     //[15] USB endpoint-7 event global interrupt flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[17..16] 
            __IO uint8_t  OVRF          :1;     //[18] USB packet memory overrun interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  SETUPF        :1;     //[19] USB wrong Setup data received error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  NORSF         :1;     //[20] USB host no response error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BSTF          :1;     //[21] USB Bit Stuffing error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CRCF          :1;     //[22] USB cyclic redundancy check error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  SUSF          :1;     //[24] USB bus suspend state detected interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RSMF          :1;     //[25] USB bus resume state detected interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RSTF          :1;     //[26] USB bus reset detected interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RWKF          :1;     //[27] USB remote wakeup interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[28] 
            __I  uint8_t  BSUSF         :2;     //[30..29] USB current bus suspend state.
                                        //0x0 = Active : USB DPC Active (Device Power Control)
                                        //0x1 = Suspend : USB DPC Suspend
                                        //0x2 = SendResume : USB DPC Send-Resume (Remote-wakeup)
                                        //0x3 = LPMSuspend : USB LPM Suspend
            __IO uint8_t  SE1F          :1;     //[31] USB SE1 state detect interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  USB status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] USB interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BUS_IE        :1;     //[1] USB bus event global interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[2] 
            __IO uint8_t  ERR_IE        :1;     //[3] USB bus error global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SOF_IE        :1;     //[4] USB host SOF received interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ESOF_IE       :1;     //[5] USB expected start of frame interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  LPM_IE        :1;     //[7] USB LPM L1 state request interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP0_IE        :1;     //[8] USB endpoint-0 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP1_IE        :1;     //[9] USB endpoint-1 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP2_IE        :1;     //[10] USB endpoint-2 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP3_IE        :1;     //[11] USB endpoint-3 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP4_IE        :1;     //[12] USB endpoint-4 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP5_IE        :1;     //[13] USB endpoint-5 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP6_IE        :1;     //[14] USB endpoint-6 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EP7_IE        :1;     //[15] USB endpoint-7 event global interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[17..16] 
            __IO uint8_t  OVR_IE        :1;     //[18] USB packet memory overrun interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SETUP_IE      :1;     //[19] USB wrong Setup data received error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NORS_IE       :1;     //[20] USB host no ACK response error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BST_IE        :1;     //[21] USB Bit Stuffing error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CRC_IE        :1;     //[22] USB cyclic redundancy check error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  SUS_IE        :1;     //[24] USB bus suspend state detected interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RSM_IE        :1;     //[25] USB bus resume state detected interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RST_IE        :1;     //[26] USB bus reset detected interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RWK_IE        :1;     //[27] USB remote wakeup interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[30..28] 
            __IO uint8_t  SE1_IE        :1;     //[31] USB SE1 state detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  USB interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t               :16;    //[15..0] 
            __I  uint8_t                :8;     //[23..16] 
            __IO uint8_t  GPR           :8;     //[31..24] General purpose data register bits.
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  USB clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  DI_STA        :1;     //[0] USB differential input state.
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t  DPI_STA       :1;     //[2] USB bus differential signal plus input line DP status.
            __I  uint8_t  DMI_STA       :1;     //[3] USB bus differential signal minus input line DM status.
            __I  uint8_t  SE0_STA       :1;     //[4] USB SE0 state.
            __I  uint8_t  SE1_STA       :1;     //[5] USB SE1 state.
            __I  uint8_t  J_STA         :1;     //[6] USB J state.
            __I  uint8_t  K_STA         :1;     //[7] USB K state.
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :2;     //[11..10] 
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t FNUM          :11;    //[26..16] USB frame number
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }STA2;                              /*!< STA2       ~ Offset[0x0C]  USB status register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] USB function enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  XTR_EN        :1;     //[1] USB transceiver enable
                                        //0 = Disable (Power down)
                                        //1 = Enable (Power on)
            __IO uint8_t  V33_EN        :1;     //[2] USB V33 LDO power-on enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  V33_VDD       :1;     //[3] USB V33 LDO output short to VDD enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SUS_MDS       :1;     //[4] USB Suspend signal detect mode select
                                        //0 = JS : Only detect J state
                                        //1 = Both : detect J state or SE1 state.
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  RWK_DSEL      :2;     //[7..6] USB remote wakeup delay time selection.
                                        //0x0 = DT0 (about 6.48ms)
                                        //0x1 = DT1 (about 3.24ms)
                                        //0x2 = DT2 (about 110us)
                                        //0x3 = DT3 (about 55us)
            __IO uint8_t  RWK_MDS       :1;     //[8] USB remote wakeup control mode select
                                        //0 = Hardware
                                        //1 = Software
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  RWK_TRG       :1;     //[10] USB remote wakeup trigger
                                        //0 = Stop (complete or stop)
                                        //1 = Start (trigger start)
            __IO uint8_t  STP_LVR       :1;     //[11] LVR disable after enter STOP mode when USB is enabled
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  BRST_CTL      :1;     //[12] 
            __IO uint8_t  NORS_EN       :1;     //[13] USB No-response enable for endpoint 0 IN/OUT transaction
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  DPU_EN        :1;     //[16] USB DP line with pull-up resister enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DPU_AUTO      :1;     //[17] 
            __IO uint8_t  DPU_MDS       :1;     //[18] 
            __IO uint8_t  DM_PD         :1;     //[19] USB DM line with pull-down resistor enable. The resistance is about 750K~1M Ohm.
                                        //0 = Disable (disable the pull-down resistors on DM)
                                        //1 = Enable (enable the pull-down resistors on DM)
            __IO uint8_t  DP_PD         :1;     //[20] USB DP line with pull-down resistor enable. The resistance is about 750K~1M Ohm.
                                        //0 = Disable (disable the pull-down resistors on DP)
                                        //1 = Enable (enable the pull-down resistors on DP)
            __IO uint8_t  DM_PD2        :1;     //[21] 
            __IO uint8_t  DM_ODC        :1;     //[22] USB DM pin output drive strength select.
                                        //0 = Level0 : Drive strength normal
                                        //1 = Level1 : Drive strength is Level0 * 1.1
            __IO uint8_t  DP_ODC        :1;     //[23] USB DP pin output drive strength select.
                                        //0 = Level0 : Drive strength normal
                                        //1 = Level1 : Drive strength is Level0 * 1.1
            __I  uint8_t                :6;     //[29..24] 
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  USB control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ADR           :7;     //[6..0] USB device address
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  LPM_EN        :1;     //[16] USB LPM mode enable. This bit is set to enable to support the LPM transactions.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LPM_ACK       :1;     //[17] USB LPM Token acknowledge enable.
                                        //0 = NYET : the valid LPM Token will be NYET
                                        //1 = ACK : the valid LPM Token will be ACK.
            __I  uint8_t  LPM_RWK       :1;     //[18] USB LPM bRemoteWake value
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t  LPM_BESL      :4;     //[23..20] USB LPM BESL value
            __IO uint8_t  LPMNY_IE      :1;     //[24] USB LPM L1 state receive NYET interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LPMST_IE      :1;     //[25] 
            __I  uint8_t                :2;     //[27..26] 
            __IO uint8_t  LPMNYF        :1;     //[28] USB LPM L1 state request interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  LPMSTF        :1;     //[29] 
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  USB control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  DMA_RXSEL0    :3;     //[2..0] Direct memory access end-point index selection for data receiving.
                                        //0x0 = Disable
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x3 = EP3
                                        //0x4 = EP4
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  DMA_TXSEL0    :3;     //[6..4] Direct memory access end-point index selection for data transmission.
                                        //0x0 = Disable
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x3 = EP3
                                        //0x4 = EP4
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  USB control register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  FOPEN_EN      :1;     //[1] 
            __IO uint8_t  UTRO_EN       :1;     //[2] 
            __IO uint8_t  EYEO_EN       :1;     //[3] 
            __I  uint8_t                :2;     //[5..4] 
            __IO uint8_t  UACK_EN       :1;     //[6] 
            __IO uint8_t  UACK_TRG      :1;     //[7] 
            __I  uint8_t                :3;     //[10..8] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  S0_SEL        :2;     //[13..12] 
            __IO uint8_t  S1_SEL        :2;     //[15..14] 
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  DJS15         :1;     //[17] 
            __IO uint8_t  SE1C          :1;     //[18] 
            __IO uint8_t  SE1D          :1;     //[19] 
            __IO uint8_t  STSO_ACK      :1;     //[20] 
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t  USTS          :4;     //[27..24] 
            __I  uint8_t                :1;     //[28] 
            __IO uint8_t  UFOU          :1;     //[29] 
            __IO uint8_t  UROU          :1;     //[30] 
            __IO uint8_t  URDY          :1;     //[31] 
        }MBIT;
    }CR3;                               /*!< CR3        ~ Offset[0x1C]  USB control register 3 */

    __I uint32_t  RESERVED0[8];         /*!< RESERVED0  ~ Offset[0x20]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD0_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK0_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL0_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD0_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK0_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL0_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t  STOVW0F       :1;     //[8] USB SETUP start overwrite flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  EDOVW0F       :1;     //[9] USB SETUP end overwrite flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  SETUP0F       :1;     //[10] USB received setup transaction flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :3;     //[13..11] 
            __IO uint8_t  RXRST0        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST0        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD0F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK0F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL0F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  TXD0F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK0F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL0F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP0CR0;                            /*!< EP0CR0     ~ Offset[0x40]  USB end-point 0 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :4;     //[3..0] 
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM0        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE0       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __I  uint8_t                :1;     //[14] 
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN0         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL0        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC0         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK0     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ0        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK0      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN0         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL0        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC0         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK0     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ0        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK0      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP0CR1;                            /*!< EP0CR1     ~ Offset[0x44]  USB end-point 0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR0        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT0        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP0RX;                             /*!< EP0RX      ~ Offset[0x48]  USB end-point 0 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR0        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT0        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP0TX;                             /*!< EP0TX      ~ Offset[0x4C]  USB end-point 0 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD1_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK1_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL1_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD1_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK1_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL1_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :3;     //[13..11] 
            __IO uint8_t  RXRST1        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST1        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD1F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK1F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL1F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW1F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  TXD1F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK1F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL1F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE1F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP1CR0;                            /*!< EP1CR0     ~ Offset[0x50]  USB end-point 1 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR1        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE1       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE1       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM1        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE1       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM1          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN1         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL1        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC1         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK1     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ1        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK1      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN1         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL1        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC1         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK1     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ1        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK1      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP1CR1;                            /*!< EP1CR1     ~ Offset[0x54]  USB end-point 1 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR1        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT1        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP1RX;                             /*!< EP1RX      ~ Offset[0x58]  USB end-point 1 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR1        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT1        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP1TX;                             /*!< EP1TX      ~ Offset[0x5C]  USB end-point 1 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD2_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK2_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL2_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD2_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK2_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL2_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :6;     //[13..8] 
            __IO uint8_t  RXRST2        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST2        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD2F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK2F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL2F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW2F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  TXD2F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK2F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL2F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE2F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP2CR0;                            /*!< EP2CR0     ~ Offset[0x60]  USB end-point 2 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR2        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE2       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE2       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM2        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE2       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM2          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN2         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL2        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC2         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK2     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ2        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK2      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN2         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL2        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC2         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK2     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ2        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK2      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP2CR1;                            /*!< EP2CR1     ~ Offset[0x64]  USB end-point 2 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR2        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT2        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP2RX;                             /*!< EP2RX      ~ Offset[0x68]  USB end-point 2 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR2        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT2        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP2TX;                             /*!< EP2TX      ~ Offset[0x6C]  USB end-point 2 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD3_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK3_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL3_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD3_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK3_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL3_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :6;     //[13..8] 
            __IO uint8_t  RXRST3        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST3        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD3F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK3F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL3F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW3F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  TXD3F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK3F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL3F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE3F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP3CR0;                            /*!< EP3CR0     ~ Offset[0x70]  USB end-point 3 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR3        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE3       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE3       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM3        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE3       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM3          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN3         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL3        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC3         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK3     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ3        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK3      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN3         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL3        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC3         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK3     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ3        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK3      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP3CR1;                            /*!< EP3CR1     ~ Offset[0x74]  USB end-point 3 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR3        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT3        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP3RX;                             /*!< EP3RX      ~ Offset[0x78]  USB end-point 3 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR3        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT3        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP3TX;                             /*!< EP3TX      ~ Offset[0x7C]  USB end-point 3 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD4_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK4_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL4_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD4_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK4_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL4_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :6;     //[13..8] 
            __IO uint8_t  RXRST4        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST4        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD4F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK4F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL4F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW4F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  TXD4F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK4F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL4F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE4F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP4CR0;                            /*!< EP4CR0     ~ Offset[0x80]  USB end-point 4 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR4        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE4       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE4       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM4        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE4       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM4          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN4         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL4        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC4         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK4     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ4        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK4      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN4         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL4        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC4         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK4     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ4        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK4      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP4CR1;                            /*!< EP4CR1     ~ Offset[0x84]  USB end-point 4 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR4        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT4        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP4RX;                             /*!< EP4RX      ~ Offset[0x88]  USB end-point 4 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR4        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT4        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP4TX;                             /*!< EP4TX      ~ Offset[0x8C]  USB end-point 4 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD5_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK5_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL5_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD5_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK5_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL5_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :6;     //[13..8] 
            __IO uint8_t  RXRST5        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST5        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD5F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK5F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL5F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW5F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  TXD5F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK5F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL5F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE5F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP5CR0;                            /*!< EP5CR0     ~ Offset[0x90]  USB end-point 5 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR5        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE5       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE5       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM5        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE5       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM5          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN5         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL5        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC5         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK5     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ5        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK5      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN5         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL5        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC5         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK5     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ5        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK5      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP5CR1;                            /*!< EP5CR1     ~ Offset[0x94]  USB end-point 5 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR5        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT5        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP5RX;                             /*!< EP5RX      ~ Offset[0x98]  USB end-point 5 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR5        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT5        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP5TX;                             /*!< EP5TX      ~ Offset[0x9C]  USB end-point 5 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD6_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK6_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL6_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD6_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK6_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL6_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :6;     //[13..8] 
            __IO uint8_t  RXRST6        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST6        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD6F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK6F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL6F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW6F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  TXD6F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK6F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL6F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE6F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP6CR0;                            /*!< EP6CR0     ~ Offset[0xA0]  USB end-point 6 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR6        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE6       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE6       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM6        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE6       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM6          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN6         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL6        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC6         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK6     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ6        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK6      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN6         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL6        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC6         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK6     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ6        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK6      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP6CR1;                            /*!< EP6CR1     ~ Offset[0xA4]  USB end-point 6 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR6        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT6        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP6RX;                             /*!< EP6RX      ~ Offset[0xA8]  USB end-point 6 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR6        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT6        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP6TX;                             /*!< EP6TX      ~ Offset[0xAC]  USB end-point 6 transmit register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXD7_IE       :1;     //[0] USB endpoint receiving done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXNAK7_IE     :1;     //[1] USB endpoint receiving NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL7_IE     :1;     //[2] USB endpoint receiving STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXD7_IE       :1;     //[3] USB endpoint transmission  done interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXNAK7_IE     :1;     //[4] USB endpoint transmission  NAK event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL7_IE     :1;     //[5] USB endpoint transmission  STALL event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :6;     //[13..8] 
            __IO uint8_t  RXRST7        :1;     //[14] USB endpoint receiving block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  TXRST7        :1;     //[15] USB endpoint transmission block reset and flags clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __IO uint8_t  RXD7F         :1;     //[16] USB endpoint receiving done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXNAK7F       :1;     //[17] USB endpoint receiving NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXSTL7F       :1;     //[18] USB endpoint receiving STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOOVW7F      :1;     //[19] USB isochronous receive data overwrite error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  TXD7F         :1;     //[24] USB endpoint transmission done flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXNAK7F       :1;     //[25] USB endpoint transmission NAK event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXSTL7F       :1;     //[26] USB endpoint transmission STALL event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ISOTXE7F      :1;     //[27] USB isochronous transmit data empty loss error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }EP7CR0;                            /*!< EP7CR0     ~ Offset[0xB0]  USB end-point 7 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EPADR7        :4;     //[3..0] USB endpoint address
            __IO uint8_t  RXTYPE7       :1;     //[4] USB receive endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  TXTYPE7       :1;     //[6] USB transmit endpoint type select
                                        //0 = BKINT
                                        //1 = ISO
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLNUM7        :5;     //[12..8] USB endpoint memory block number
            __IO uint8_t  BLSIZE7       :1;     //[13] USB endpoint memory block size select
                                        //0 = 2Byte
                                        //1 = 32Byte
            __IO uint8_t  DBM7          :1;     //[14] USB endpoint double buffer mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  RXEN7         :1;     //[16] USB receive endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTL7        :1;     //[17] USB receive endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMC7         :1;     //[18] USB receive memory read complete
                                        //0 = No : no effect
                                        //1 = Complete : read data complete from USB memory
            __IO uint8_t  RXSA_LCK7     :1;     //[19] USB receive control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  RXSEQ7        :1;     //[20] USB receive endpoint sequence bit (read, conditional write)
            __IO uint8_t  RXS_LCK7      :1;     //[21] USB receive data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  TXEN7         :1;     //[24] USB transmit endpoint enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTL7        :1;     //[25] USB transmit endpoint STALL enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMC7         :1;     //[26] USB transmit memory write complete
                                        //0 = No : no effect
                                        //1 = Complete : write data complete to USB memory
            __IO uint8_t  TXSA_LCK7     :1;     //[27] USB transmit control register bits write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  TXSEQ7        :1;     //[28] USB transmit endpoint sequence bit (read, conditional write)
            __IO uint8_t  TXS_LCK7      :1;     //[29] USB transmit data sequence bit write access un-locked control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }EP7CR1;                            /*!< EP7CR1     ~ Offset[0xB4]  USB end-point 7 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t RXADR7        :9;     //[8..0] USB endpoint receive buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t RXCNT7        :9;     //[24..16] USB endpoint receive byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP7RX;                             /*!< EP7RX      ~ Offset[0xB8]  USB end-point 7 receive register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TXADR7        :9;     //[8..0] USB endpoint transmit buffer start address
            __I  uint8_t                :7;     //[15..9] 
            __IO uint16_t TXCNT7        :9;     //[24..16] USB endpoint transmit byte count
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }EP7TX;                             /*!< EP7TX      ~ Offset[0xBC]  USB end-point 7 transmit register */

} USB_Struct;

/**
 ******************************************************************************
 *
 * @name        USB  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define USB_Base                        ((uint32_t)0x54000000)              /*!< USB Control  Module */
#define USB                             ((USB_Struct*) USB_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        USB  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        USB_STA  [register's definitions]
 *              Offset[0x00]  USB status register (0x54000000)
 ******************************************************************************
 */
///@{
#define USB_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_STA */
#define USB_STA_SE1F_mask_w                         ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define USB_STA_SE1F_mask_h1                        ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_STA_SE1F_mask_b3                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_STA_SE1F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_SE1F_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_SE1F_normal_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_SE1F_happened_w                     ((uint32_t)0x80000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_SE1F_happened_h1                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_SE1F_happened_b3                    ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_BSUSF_mask_w                        ((uint32_t)0x60000000)  /*!< Bit Mask of 32bit */
#define USB_STA_BSUSF_mask_h1                       ((uint16_t)0x6000)      /*!< Bit Mask of 16bit */
#define USB_STA_BSUSF_mask_b3                       ((uint8_t )0x60)        /*!< Bit Mask of 8bit */
#define USB_STA_BSUSF_active_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Active of 32bit */
#define USB_STA_BSUSF_active_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Active of 16bit */
#define USB_STA_BSUSF_active_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):Active of 8bit */
#define USB_STA_BSUSF_suspend_w                     ((uint32_t)0x20000000)  /*!< Bit Value =(0x1):Suspend of 32bit */
#define USB_STA_BSUSF_suspend_h1                    ((uint16_t)0x2000)      /*!< Bit Value =(0x1):Suspend of 16bit */
#define USB_STA_BSUSF_suspend_b3                    ((uint8_t )0x20)        /*!< Bit Value =(0x1):Suspend of 8bit */
#define USB_STA_BSUSF_sendresume_w                  ((uint32_t)0x40000000)  /*!< Bit Value =(0x2):SendResume of 32bit */
#define USB_STA_BSUSF_sendresume_h1                 ((uint16_t)0x4000)      /*!< Bit Value =(0x2):SendResume of 16bit */
#define USB_STA_BSUSF_sendresume_b3                 ((uint8_t )0x40)        /*!< Bit Value =(0x2):SendResume of 8bit */
#define USB_STA_BSUSF_lpmsuspend_w                  ((uint32_t)0x60000000)  /*!< Bit Value =(0x3):LPMSuspend of 32bit */
#define USB_STA_BSUSF_lpmsuspend_h1                 ((uint16_t)0x6000)      /*!< Bit Value =(0x3):LPMSuspend of 16bit */
#define USB_STA_BSUSF_lpmsuspend_b3                 ((uint8_t )0x60)        /*!< Bit Value =(0x3):LPMSuspend of 8bit */

#define USB_STA_RWKF_mask_w                         ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_STA_RWKF_mask_h1                        ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_STA_RWKF_mask_b3                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_STA_RWKF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_RWKF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_RWKF_normal_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_RWKF_happened_w                     ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_RWKF_happened_h1                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_RWKF_happened_b3                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_RSTF_mask_w                         ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_STA_RSTF_mask_h1                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_STA_RSTF_mask_b3                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_STA_RSTF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_RSTF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_RSTF_normal_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_RSTF_happened_w                     ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_RSTF_happened_h1                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_RSTF_happened_b3                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_RSMF_mask_w                         ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_STA_RSMF_mask_h1                        ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_STA_RSMF_mask_b3                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_STA_RSMF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_RSMF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_RSMF_normal_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_RSMF_happened_w                     ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_RSMF_happened_h1                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_RSMF_happened_b3                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_SUSF_mask_w                         ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_STA_SUSF_mask_h1                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_STA_SUSF_mask_b3                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_STA_SUSF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_SUSF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_SUSF_normal_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_SUSF_happened_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_SUSF_happened_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_SUSF_happened_b3                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_CRCF_mask_w                         ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define USB_STA_CRCF_mask_h1                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_STA_CRCF_mask_b2                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_STA_CRCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_CRCF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_CRCF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_CRCF_happened_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_CRCF_happened_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_CRCF_happened_b2                    ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_BSTF_mask_w                         ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_STA_BSTF_mask_h1                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_STA_BSTF_mask_b2                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_STA_BSTF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_BSTF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_BSTF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_BSTF_happened_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_BSTF_happened_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_BSTF_happened_b2                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_NORSF_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_STA_NORSF_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_STA_NORSF_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_STA_NORSF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_NORSF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_NORSF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_NORSF_happened_w                    ((uint32_t)0x00100000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_NORSF_happened_h1                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_NORSF_happened_b2                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_SETUPF_mask_w                       ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_STA_SETUPF_mask_h1                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_STA_SETUPF_mask_b2                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_STA_SETUPF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_SETUPF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_SETUPF_normal_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_SETUPF_happened_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_SETUPF_happened_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_SETUPF_happened_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_OVRF_mask_w                         ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_STA_OVRF_mask_h1                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_STA_OVRF_mask_b2                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_STA_OVRF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_OVRF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_OVRF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_OVRF_happened_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_OVRF_happened_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_OVRF_happened_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP7F_mask_w                         ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_STA_EP7F_mask_h0                        ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_STA_EP7F_mask_b1                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_STA_EP7F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP7F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP7F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP7F_happened_w                     ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP7F_happened_h0                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP7F_happened_b1                    ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP6F_mask_w                         ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_STA_EP6F_mask_h0                        ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_STA_EP6F_mask_b1                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_STA_EP6F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP6F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP6F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP6F_happened_w                     ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP6F_happened_h0                    ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP6F_happened_b1                    ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP5F_mask_w                         ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_STA_EP5F_mask_h0                        ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_STA_EP5F_mask_b1                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_STA_EP5F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP5F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP5F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP5F_happened_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP5F_happened_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP5F_happened_b1                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP4F_mask_w                         ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define USB_STA_EP4F_mask_h0                        ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_STA_EP4F_mask_b1                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_STA_EP4F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP4F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP4F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP4F_happened_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP4F_happened_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP4F_happened_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP3F_mask_w                         ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define USB_STA_EP3F_mask_h0                        ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_STA_EP3F_mask_b1                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_STA_EP3F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP3F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP3F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP3F_happened_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP3F_happened_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP3F_happened_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP2F_mask_w                         ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define USB_STA_EP2F_mask_h0                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_STA_EP2F_mask_b1                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_STA_EP2F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP2F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP2F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP2F_happened_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP2F_happened_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP2F_happened_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP1F_mask_w                         ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define USB_STA_EP1F_mask_h0                        ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_STA_EP1F_mask_b1                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_STA_EP1F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP1F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP1F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP1F_happened_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP1F_happened_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP1F_happened_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_EP0F_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define USB_STA_EP0F_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_STA_EP0F_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_STA_EP0F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_EP0F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_EP0F_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_EP0F_happened_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_EP0F_happened_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_EP0F_happened_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_LPMF_mask_w                         ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define USB_STA_LPMF_mask_h0                        ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define USB_STA_LPMF_mask_b0                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_STA_LPMF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_LPMF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_LPMF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_LPMF_happened_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_LPMF_happened_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_LPMF_happened_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_ESOF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_STA_ESOF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_STA_ESOF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_STA_ESOF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_ESOF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_ESOF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_ESOF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_ESOF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_ESOF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_SOF_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_STA_SOF_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_STA_SOF_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_STA_SOF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_SOF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_SOF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_SOF_happened_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_SOF_happened_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_SOF_happened_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_ERRF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_STA_ERRF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_STA_ERRF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_STA_ERRF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_ERRF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_ERRF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_ERRF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_ERRF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_ERRF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_BUSF_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_STA_BUSF_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_STA_BUSF_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_STA_BUSF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_STA_BUSF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_STA_BUSF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_STA_BUSF_happened_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_STA_BUSF_happened_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_STA_BUSF_happened_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_STA_BUSYF_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_STA_BUSYF_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_STA_BUSYF_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_STA_BUSYF_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define USB_STA_BUSYF_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define USB_STA_BUSYF_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_INT  [register's definitions]
 *              Offset[0x04]  USB interrupt enable register (0x54000004)
 ******************************************************************************
 */
///@{
#define USB_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_INT */
#define USB_INT_SE1_IE_mask_w                       ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define USB_INT_SE1_IE_mask_h1                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_INT_SE1_IE_mask_b3                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_INT_SE1_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_SE1_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_SE1_IE_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_SE1_IE_enable_w                     ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_SE1_IE_enable_h1                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_SE1_IE_enable_b3                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_RWK_IE_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_INT_RWK_IE_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_INT_RWK_IE_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_INT_RWK_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_RWK_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_RWK_IE_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_RWK_IE_enable_w                     ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_RWK_IE_enable_h1                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_RWK_IE_enable_b3                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_RST_IE_mask_w                       ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_INT_RST_IE_mask_h1                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_INT_RST_IE_mask_b3                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_INT_RST_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_RST_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_RST_IE_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_RST_IE_enable_w                     ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_RST_IE_enable_h1                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_RST_IE_enable_b3                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_RSM_IE_mask_w                       ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_INT_RSM_IE_mask_h1                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_INT_RSM_IE_mask_b3                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_INT_RSM_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_RSM_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_RSM_IE_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_RSM_IE_enable_w                     ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_RSM_IE_enable_h1                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_RSM_IE_enable_b3                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_SUS_IE_mask_w                       ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_INT_SUS_IE_mask_h1                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_INT_SUS_IE_mask_b3                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_INT_SUS_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_SUS_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_SUS_IE_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_SUS_IE_enable_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_SUS_IE_enable_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_SUS_IE_enable_b3                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_CRC_IE_mask_w                       ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define USB_INT_CRC_IE_mask_h1                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_INT_CRC_IE_mask_b2                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_INT_CRC_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_CRC_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_CRC_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_CRC_IE_enable_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_CRC_IE_enable_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_CRC_IE_enable_b2                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_BST_IE_mask_w                       ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_INT_BST_IE_mask_h1                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_INT_BST_IE_mask_b2                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_INT_BST_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_BST_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_BST_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_BST_IE_enable_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_BST_IE_enable_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_BST_IE_enable_b2                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_NORS_IE_mask_w                      ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_INT_NORS_IE_mask_h1                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_INT_NORS_IE_mask_b2                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_INT_NORS_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_NORS_IE_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_NORS_IE_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_NORS_IE_enable_w                    ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_NORS_IE_enable_h1                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_NORS_IE_enable_b2                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_SETUP_IE_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_INT_SETUP_IE_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_INT_SETUP_IE_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_INT_SETUP_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_SETUP_IE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_SETUP_IE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_SETUP_IE_enable_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_SETUP_IE_enable_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_SETUP_IE_enable_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_OVR_IE_mask_w                       ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_INT_OVR_IE_mask_h1                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_INT_OVR_IE_mask_b2                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_INT_OVR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_OVR_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_OVR_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_OVR_IE_enable_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_OVR_IE_enable_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_OVR_IE_enable_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP7_IE_mask_w                       ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_INT_EP7_IE_mask_h0                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_INT_EP7_IE_mask_b1                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_INT_EP7_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP7_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP7_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP7_IE_enable_w                     ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP7_IE_enable_h0                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP7_IE_enable_b1                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP6_IE_mask_w                       ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_INT_EP6_IE_mask_h0                      ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_INT_EP6_IE_mask_b1                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_INT_EP6_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP6_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP6_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP6_IE_enable_w                     ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP6_IE_enable_h0                    ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP6_IE_enable_b1                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP5_IE_mask_w                       ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_INT_EP5_IE_mask_h0                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_INT_EP5_IE_mask_b1                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_INT_EP5_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP5_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP5_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP5_IE_enable_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP5_IE_enable_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP5_IE_enable_b1                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP4_IE_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define USB_INT_EP4_IE_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_INT_EP4_IE_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_INT_EP4_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP4_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP4_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP4_IE_enable_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP4_IE_enable_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP4_IE_enable_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP3_IE_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define USB_INT_EP3_IE_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_INT_EP3_IE_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_INT_EP3_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP3_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP3_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP3_IE_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP3_IE_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP3_IE_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP2_IE_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define USB_INT_EP2_IE_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_INT_EP2_IE_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_INT_EP2_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP2_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP2_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP2_IE_enable_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP2_IE_enable_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP2_IE_enable_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP1_IE_mask_w                       ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define USB_INT_EP1_IE_mask_h0                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_INT_EP1_IE_mask_b1                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_INT_EP1_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP1_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP1_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP1_IE_enable_w                     ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP1_IE_enable_h0                    ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP1_IE_enable_b1                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_EP0_IE_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define USB_INT_EP0_IE_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_INT_EP0_IE_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_INT_EP0_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_EP0_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_EP0_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_EP0_IE_enable_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_EP0_IE_enable_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_EP0_IE_enable_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_LPM_IE_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define USB_INT_LPM_IE_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define USB_INT_LPM_IE_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_INT_LPM_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_LPM_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_LPM_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_LPM_IE_enable_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_LPM_IE_enable_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_LPM_IE_enable_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_ESOF_IE_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_INT_ESOF_IE_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_INT_ESOF_IE_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_INT_ESOF_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_ESOF_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_ESOF_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_ESOF_IE_enable_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_ESOF_IE_enable_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_ESOF_IE_enable_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_SOF_IE_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_INT_SOF_IE_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_INT_SOF_IE_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_INT_SOF_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_SOF_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_SOF_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_SOF_IE_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_SOF_IE_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_SOF_IE_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_ERR_IE_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_INT_ERR_IE_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_INT_ERR_IE_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_INT_ERR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_ERR_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_ERR_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_ERR_IE_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_ERR_IE_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_ERR_IE_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_BUS_IE_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_INT_BUS_IE_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_INT_BUS_IE_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_INT_BUS_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_BUS_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_BUS_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_BUS_IE_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_BUS_IE_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_BUS_IE_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_CLK  [register's definitions]
 *              Offset[0x08]  USB clock source register (0x54000008)
 ******************************************************************************
 */
///@{
#define USB_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_CLK */
#define USB_CLK_GPR_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define USB_CLK_GPR_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define USB_CLK_GPR_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define USB_CLK_GPR_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define USB_CLK_GPR_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define USB_CLK_GPR_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_STA2  [register's definitions]
 *              Offset[0x0C]  USB status register 2 (0x5400000C)
 ******************************************************************************
 */
///@{
#define USB_STA2_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_STA2 */
#define USB_STA2_FNUM_mask_w                        ((uint32_t)0x07FF0000)  /*!< Bit Mask of 32bit */
#define USB_STA2_FNUM_mask_h1                       ((uint16_t)0x07FF)      /*!< Bit Mask of 16bit */
#define USB_STA2_FNUM_shift_w                       (16)                    /*!< Bit Shift of 32bit */
#define USB_STA2_FNUM_shift_h1                      (0)                     /*!< Bit Shift of 16bit */
#define USB_STA2_FNUM_shift_b2                      (0)                     /*!< Bit Shift of 8bit */

#define USB_STA2_K_STA_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define USB_STA2_K_STA_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define USB_STA2_K_STA_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_STA2_K_STA_shift_w                      (7)                     /*!< Bit Shift of 32bit */
#define USB_STA2_K_STA_shift_h0                     (7)                     /*!< Bit Shift of 16bit */
#define USB_STA2_K_STA_shift_b0                     (7)                     /*!< Bit Shift of 8bit */

#define USB_STA2_J_STA_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_STA2_J_STA_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_STA2_J_STA_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_STA2_J_STA_shift_w                      (6)                     /*!< Bit Shift of 32bit */
#define USB_STA2_J_STA_shift_h0                     (6)                     /*!< Bit Shift of 16bit */
#define USB_STA2_J_STA_shift_b0                     (6)                     /*!< Bit Shift of 8bit */

#define USB_STA2_SE1_STA_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_STA2_SE1_STA_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_STA2_SE1_STA_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_STA2_SE1_STA_shift_w                    (5)                     /*!< Bit Shift of 32bit */
#define USB_STA2_SE1_STA_shift_h0                   (5)                     /*!< Bit Shift of 16bit */
#define USB_STA2_SE1_STA_shift_b0                   (5)                     /*!< Bit Shift of 8bit */

#define USB_STA2_SE0_STA_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_STA2_SE0_STA_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_STA2_SE0_STA_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_STA2_SE0_STA_shift_w                    (4)                     /*!< Bit Shift of 32bit */
#define USB_STA2_SE0_STA_shift_h0                   (4)                     /*!< Bit Shift of 16bit */
#define USB_STA2_SE0_STA_shift_b0                   (4)                     /*!< Bit Shift of 8bit */

#define USB_STA2_DMI_STA_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_STA2_DMI_STA_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_STA2_DMI_STA_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_STA2_DMI_STA_shift_w                    (3)                     /*!< Bit Shift of 32bit */
#define USB_STA2_DMI_STA_shift_h0                   (3)                     /*!< Bit Shift of 16bit */
#define USB_STA2_DMI_STA_shift_b0                   (3)                     /*!< Bit Shift of 8bit */

#define USB_STA2_DPI_STA_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_STA2_DPI_STA_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_STA2_DPI_STA_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_STA2_DPI_STA_shift_w                    (2)                     /*!< Bit Shift of 32bit */
#define USB_STA2_DPI_STA_shift_h0                   (2)                     /*!< Bit Shift of 16bit */
#define USB_STA2_DPI_STA_shift_b0                   (2)                     /*!< Bit Shift of 8bit */

#define USB_STA2_DI_STA_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_STA2_DI_STA_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_STA2_DI_STA_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_STA2_DI_STA_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define USB_STA2_DI_STA_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define USB_STA2_DI_STA_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_CR0  [register's definitions]
 *              Offset[0x10]  USB control register 0 (0x54000010)
 ******************************************************************************
 */
///@{
#define USB_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_CR0 */
#define USB_CR0_DP_ODC_mask_w                       ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DP_ODC_mask_h1                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define USB_CR0_DP_ODC_mask_b2                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_CR0_DP_ODC_level0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Level0 of 32bit */
#define USB_CR0_DP_ODC_level0_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Level0 of 16bit */
#define USB_CR0_DP_ODC_level0_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Level0 of 8bit */
#define USB_CR0_DP_ODC_level1_w                     ((uint32_t)0x00800000)  /*!< Bit Value =(1):Level1 of 32bit */
#define USB_CR0_DP_ODC_level1_h1                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Level1 of 16bit */
#define USB_CR0_DP_ODC_level1_b2                    ((uint8_t )0x80)        /*!< Bit Value =(1):Level1 of 8bit */

#define USB_CR0_DM_ODC_mask_w                       ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DM_ODC_mask_h1                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_CR0_DM_ODC_mask_b2                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_CR0_DM_ODC_level0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Level0 of 32bit */
#define USB_CR0_DM_ODC_level0_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Level0 of 16bit */
#define USB_CR0_DM_ODC_level0_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Level0 of 8bit */
#define USB_CR0_DM_ODC_level1_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(1):Level1 of 32bit */
#define USB_CR0_DM_ODC_level1_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Level1 of 16bit */
#define USB_CR0_DM_ODC_level1_b2                    ((uint8_t )0x40)        /*!< Bit Value =(1):Level1 of 8bit */

#define USB_CR0_DM_PD2_mask_w                       ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DM_PD2_mask_h1                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_CR0_DM_PD2_mask_b2                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_CR0_DM_PD2_disable_w                    ((uint32_t)0x00000000)
#define USB_CR0_DM_PD2_disable_h1                   ((uint16_t)0x0000)
#define USB_CR0_DM_PD2_disable_b2                   ((uint8_t )0x00)
#define USB_CR0_DM_PD2_force_w                      ((uint32_t)0x00200000)
#define USB_CR0_DM_PD2_force_h1                     ((uint16_t)0x0020)
#define USB_CR0_DM_PD2_force_b2                     ((uint8_t )0x20)

#define USB_CR0_DP_PD_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DP_PD_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_CR0_DP_PD_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_CR0_DP_PD_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_DP_PD_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_DP_PD_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_DP_PD_enable_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_DP_PD_enable_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_DP_PD_enable_b2                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_DM_PD_mask_w                        ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DM_PD_mask_h1                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_CR0_DM_PD_mask_b2                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_CR0_DM_PD_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_DM_PD_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_DM_PD_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_DM_PD_enable_w                      ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_DM_PD_enable_h1                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_DM_PD_enable_b2                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_DPU_MDS_mask_w                      ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DPU_MDS_mask_h1                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_CR0_DPU_MDS_mask_b2                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_CR0_DPU_MDS_switch_w                    ((uint32_t)0x00000000)
#define USB_CR0_DPU_MDS_switch_h1                   ((uint16_t)0x0000)
#define USB_CR0_DPU_MDS_switch_b2                   ((uint8_t )0x00)
#define USB_CR0_DPU_MDS_fix_w                       ((uint32_t)0x00040000)
#define USB_CR0_DPU_MDS_fix_h1                      ((uint16_t)0x0004)
#define USB_CR0_DPU_MDS_fix_b2                      ((uint8_t )0x04)

#define USB_CR0_DPU_AUTO_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DPU_AUTO_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_CR0_DPU_AUTO_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_CR0_DPU_AUTO_disable_w                  ((uint32_t)0x00000000)
#define USB_CR0_DPU_AUTO_disable_h1                 ((uint16_t)0x0000)
#define USB_CR0_DPU_AUTO_disable_b2                 ((uint8_t )0x00)
#define USB_CR0_DPU_AUTO_enable_w                   ((uint32_t)0x00020000)
#define USB_CR0_DPU_AUTO_enable_h1                  ((uint16_t)0x0002)
#define USB_CR0_DPU_AUTO_enable_b2                  ((uint8_t )0x02)

#define USB_CR0_DPU_EN_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_CR0_DPU_EN_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_CR0_DPU_EN_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_CR0_DPU_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_DPU_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_DPU_EN_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_DPU_EN_enable_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_DPU_EN_enable_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_DPU_EN_enable_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_NORS_EN_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_CR0_NORS_EN_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_CR0_NORS_EN_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_CR0_NORS_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_NORS_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_NORS_EN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_NORS_EN_enable_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_NORS_EN_enable_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_NORS_EN_enable_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_BRST_CTL_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define USB_CR0_BRST_CTL_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_CR0_BRST_CTL_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_CR0_BRST_CTL_lv2_w                      ((uint32_t)0x00000000)
#define USB_CR0_BRST_CTL_lv2_h0                     ((uint16_t)0x0000)
#define USB_CR0_BRST_CTL_lv2_b1                     ((uint8_t )0x00)
#define USB_CR0_BRST_CTL_sie_w                      ((uint32_t)0x00001000)
#define USB_CR0_BRST_CTL_sie_h0                     ((uint16_t)0x1000)
#define USB_CR0_BRST_CTL_sie_b1                     ((uint8_t )0x10)

#define USB_CR0_STP_LVR_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define USB_CR0_STP_LVR_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_CR0_STP_LVR_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_CR0_STP_LVR_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define USB_CR0_STP_LVR_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define USB_CR0_STP_LVR_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define USB_CR0_STP_LVR_disable_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Disable of 32bit */
#define USB_CR0_STP_LVR_disable_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Disable of 16bit */
#define USB_CR0_STP_LVR_disable_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Disable of 8bit */

#define USB_CR0_RWK_TRG_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define USB_CR0_RWK_TRG_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_CR0_RWK_TRG_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_CR0_RWK_TRG_stop_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define USB_CR0_RWK_TRG_stop_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define USB_CR0_RWK_TRG_stop_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define USB_CR0_RWK_TRG_start_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Start of 32bit */
#define USB_CR0_RWK_TRG_start_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Start of 16bit */
#define USB_CR0_RWK_TRG_start_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Start of 8bit */

#define USB_CR0_RWK_MDS_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define USB_CR0_RWK_MDS_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_CR0_RWK_MDS_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_CR0_RWK_MDS_hardware_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Hardware of 32bit */
#define USB_CR0_RWK_MDS_hardware_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Hardware of 16bit */
#define USB_CR0_RWK_MDS_hardware_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Hardware of 8bit */
#define USB_CR0_RWK_MDS_software_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(1):Software of 32bit */
#define USB_CR0_RWK_MDS_software_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Software of 16bit */
#define USB_CR0_RWK_MDS_software_b1                 ((uint8_t )0x01)        /*!< Bit Value =(1):Software of 8bit */

#define USB_CR0_RWK_DSEL_mask_w                     ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define USB_CR0_RWK_DSEL_mask_h0                    ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define USB_CR0_RWK_DSEL_mask_b0                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define USB_CR0_RWK_DSEL_dt0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DT0 of 32bit */
#define USB_CR0_RWK_DSEL_dt0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DT0 of 16bit */
#define USB_CR0_RWK_DSEL_dt0_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DT0 of 8bit */
#define USB_CR0_RWK_DSEL_dt1_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):DT1 of 32bit */
#define USB_CR0_RWK_DSEL_dt1_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(0x1):DT1 of 16bit */
#define USB_CR0_RWK_DSEL_dt1_b0                     ((uint8_t )0x40)        /*!< Bit Value =(0x1):DT1 of 8bit */
#define USB_CR0_RWK_DSEL_dt2_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):DT2 of 32bit */
#define USB_CR0_RWK_DSEL_dt2_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(0x2):DT2 of 16bit */
#define USB_CR0_RWK_DSEL_dt2_b0                     ((uint8_t )0x80)        /*!< Bit Value =(0x2):DT2 of 8bit */
#define USB_CR0_RWK_DSEL_dt3_w                      ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):DT3 of 32bit */
#define USB_CR0_RWK_DSEL_dt3_h0                     ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):DT3 of 16bit */
#define USB_CR0_RWK_DSEL_dt3_b0                     ((uint8_t )0xC0)        /*!< Bit Value =(0x3):DT3 of 8bit */

#define USB_CR0_SUS_MDS_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_CR0_SUS_MDS_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_CR0_SUS_MDS_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_CR0_SUS_MDS_js_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):JS of 32bit */
#define USB_CR0_SUS_MDS_js_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):JS of 16bit */
#define USB_CR0_SUS_MDS_js_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):JS of 8bit */
#define USB_CR0_SUS_MDS_both_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Both of 32bit */
#define USB_CR0_SUS_MDS_both_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Both of 16bit */
#define USB_CR0_SUS_MDS_both_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Both of 8bit */

#define USB_CR0_V33_VDD_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_CR0_V33_VDD_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_CR0_V33_VDD_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_CR0_V33_VDD_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_V33_VDD_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_V33_VDD_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_V33_VDD_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_V33_VDD_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_V33_VDD_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_V33_EN_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_CR0_V33_EN_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_CR0_V33_EN_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_CR0_V33_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_V33_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_V33_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_V33_EN_enable_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_V33_EN_enable_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_V33_EN_enable_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_XTR_EN_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_CR0_XTR_EN_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_CR0_XTR_EN_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_CR0_XTR_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_XTR_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_XTR_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_XTR_EN_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_XTR_EN_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_XTR_EN_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_CR1  [register's definitions]
 *              Offset[0x14]  USB control register 1 (0x54000014)
 ******************************************************************************
 */
///@{
#define USB_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_CR1 */
#define USB_CR1_LPMSTF_mask_w                       ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPMSTF_mask_h1                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPMSTF_mask_b3                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPMSTF_normal_w                     ((uint32_t)0x00000000)
#define USB_CR1_LPMSTF_normal_h1                    ((uint16_t)0x0000)
#define USB_CR1_LPMSTF_normal_b3                    ((uint8_t )0x00)
#define USB_CR1_LPMSTF_happened_w                   ((uint32_t)0x20000000)
#define USB_CR1_LPMSTF_happened_h1                  ((uint16_t)0x2000)
#define USB_CR1_LPMSTF_happened_b3                  ((uint8_t )0x20)

#define USB_CR1_LPMNYF_mask_w                       ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPMNYF_mask_h1                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPMNYF_mask_b3                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPMNYF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_CR1_LPMNYF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_CR1_LPMNYF_normal_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_CR1_LPMNYF_happened_w                   ((uint32_t)0x10000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_CR1_LPMNYF_happened_h1                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_CR1_LPMNYF_happened_b3                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_CR1_LPMST_IE_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPMST_IE_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPMST_IE_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPMST_IE_disable_w                  ((uint32_t)0x00000000)
#define USB_CR1_LPMST_IE_disable_h1                 ((uint16_t)0x0000)
#define USB_CR1_LPMST_IE_disable_b3                 ((uint8_t )0x00)
#define USB_CR1_LPMST_IE_enable_w                   ((uint32_t)0x02000000)
#define USB_CR1_LPMST_IE_enable_h1                  ((uint16_t)0x0200)
#define USB_CR1_LPMST_IE_enable_b3                  ((uint8_t )0x02)

#define USB_CR1_LPMNY_IE_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPMNY_IE_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPMNY_IE_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPMNY_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR1_LPMNY_IE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR1_LPMNY_IE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR1_LPMNY_IE_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR1_LPMNY_IE_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR1_LPMNY_IE_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR1_LPM_BESL_mask_w                     ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPM_BESL_mask_h1                    ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPM_BESL_mask_b2                    ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPM_BESL_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define USB_CR1_LPM_BESL_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define USB_CR1_LPM_BESL_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define USB_CR1_LPM_RWK_mask_w                      ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPM_RWK_mask_h1                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPM_RWK_mask_b2                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPM_RWK_shift_w                     (18)                    /*!< Bit Shift of 32bit */
#define USB_CR1_LPM_RWK_shift_h1                    (2)                     /*!< Bit Shift of 16bit */
#define USB_CR1_LPM_RWK_shift_b2                    (2)                     /*!< Bit Shift of 8bit */

#define USB_CR1_LPM_ACK_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPM_ACK_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPM_ACK_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPM_ACK_nyet_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):NYET of 32bit */
#define USB_CR1_LPM_ACK_nyet_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):NYET of 16bit */
#define USB_CR1_LPM_ACK_nyet_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):NYET of 8bit */
#define USB_CR1_LPM_ACK_ack_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(1):ACK of 32bit */
#define USB_CR1_LPM_ACK_ack_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(1):ACK of 16bit */
#define USB_CR1_LPM_ACK_ack_b2                      ((uint8_t )0x02)        /*!< Bit Value =(1):ACK of 8bit */

#define USB_CR1_LPM_EN_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_CR1_LPM_EN_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_CR1_LPM_EN_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_CR1_LPM_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_CR1_LPM_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_CR1_LPM_EN_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_CR1_LPM_EN_enable_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_CR1_LPM_EN_enable_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_CR1_LPM_EN_enable_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_CR1_ADR_mask_w                          ((uint32_t)0x0000007F)  /*!< Bit Mask of 32bit */
#define USB_CR1_ADR_mask_h0                         ((uint16_t)0x007F)      /*!< Bit Mask of 16bit */
#define USB_CR1_ADR_mask_b0                         ((uint8_t )0x7F)        /*!< Bit Mask of 8bit */
#define USB_CR1_ADR_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define USB_CR1_ADR_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define USB_CR1_ADR_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_CR2  [register's definitions]
 *              Offset[0x18]  USB control register 2 (0x54000018)
 ******************************************************************************
 */
///@{
#define USB_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_CR2 */
#define USB_CR2_DMA_TXSEL0_mask_w                   ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define USB_CR2_DMA_TXSEL0_mask_h0                  ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define USB_CR2_DMA_TXSEL0_mask_b0                  ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define USB_CR2_DMA_TXSEL0_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define USB_CR2_DMA_TXSEL0_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define USB_CR2_DMA_TXSEL0_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define USB_CR2_DMA_TXSEL0_ep3_w                    ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):EP3 of 32bit */
#define USB_CR2_DMA_TXSEL0_ep3_h0                   ((uint16_t)0x0030)      /*!< Bit Value =(0x3):EP3 of 16bit */
#define USB_CR2_DMA_TXSEL0_ep3_b0                   ((uint8_t )0x30)        /*!< Bit Value =(0x3):EP3 of 8bit */
#define USB_CR2_DMA_TXSEL0_ep4_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):EP4 of 32bit */
#define USB_CR2_DMA_TXSEL0_ep4_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(0x4):EP4 of 16bit */
#define USB_CR2_DMA_TXSEL0_ep4_b0                   ((uint8_t )0x40)        /*!< Bit Value =(0x4):EP4 of 8bit */

#define USB_CR2_DMA_RXSEL0_mask_w                   ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define USB_CR2_DMA_RXSEL0_mask_h0                  ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define USB_CR2_DMA_RXSEL0_mask_b0                  ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define USB_CR2_DMA_RXSEL0_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define USB_CR2_DMA_RXSEL0_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define USB_CR2_DMA_RXSEL0_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define USB_CR2_DMA_RXSEL0_ep3_w                    ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):EP3 of 32bit */
#define USB_CR2_DMA_RXSEL0_ep3_h0                   ((uint16_t)0x0003)      /*!< Bit Value =(0x3):EP3 of 16bit */
#define USB_CR2_DMA_RXSEL0_ep3_b0                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):EP3 of 8bit */
#define USB_CR2_DMA_RXSEL0_ep4_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):EP4 of 32bit */
#define USB_CR2_DMA_RXSEL0_ep4_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(0x4):EP4 of 16bit */
#define USB_CR2_DMA_RXSEL0_ep4_b0                   ((uint8_t )0x04)        /*!< Bit Value =(0x4):EP4 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_CR3  [register's definitions]
 *              Offset[0x1C]  USB control register 3 (0x5400001C)
 ******************************************************************************
 */
///@{
#define USB_CR3_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_CR3 */
#define USB_CR3_URDY_mask_w                         ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define USB_CR3_URDY_mask_h1                        ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_CR3_URDY_mask_b3                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_CR3_URDY_normal_w                       ((uint32_t)0x00000000)
#define USB_CR3_URDY_normal_h1                      ((uint16_t)0x0000)
#define USB_CR3_URDY_normal_b3                      ((uint8_t )0x00)
#define USB_CR3_URDY_happened_w                     ((uint32_t)0x80000000)
#define USB_CR3_URDY_happened_h1                    ((uint16_t)0x8000)
#define USB_CR3_URDY_happened_b3                    ((uint8_t )0x80)

#define USB_CR3_UROU_mask_w                         ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define USB_CR3_UROU_mask_h1                        ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_CR3_UROU_mask_b3                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_CR3_UROU_normal_w                       ((uint32_t)0x00000000)
#define USB_CR3_UROU_normal_h1                      ((uint16_t)0x0000)
#define USB_CR3_UROU_normal_b3                      ((uint8_t )0x00)
#define USB_CR3_UROU_happened_w                     ((uint32_t)0x40000000)
#define USB_CR3_UROU_happened_h1                    ((uint16_t)0x4000)
#define USB_CR3_UROU_happened_b3                    ((uint8_t )0x40)

#define USB_CR3_UFOU_mask_w                         ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_CR3_UFOU_mask_h1                        ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_CR3_UFOU_mask_b3                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_CR3_UFOU_normal_w                       ((uint32_t)0x00000000)
#define USB_CR3_UFOU_normal_h1                      ((uint16_t)0x0000)
#define USB_CR3_UFOU_normal_b3                      ((uint8_t )0x00)
#define USB_CR3_UFOU_happened_w                     ((uint32_t)0x20000000)
#define USB_CR3_UFOU_happened_h1                    ((uint16_t)0x2000)
#define USB_CR3_UFOU_happened_b3                    ((uint8_t )0x20)

#define USB_CR3_USTS_mask_w                         ((uint32_t)0x0F000000)  /*!< Bit Mask of 32bit */
#define USB_CR3_USTS_mask_h1                        ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define USB_CR3_USTS_mask_b3                        ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_CR3_USTS_normal_w                       ((uint32_t)0x00000000)
#define USB_CR3_USTS_normal_h1                      ((uint16_t)0x0000)
#define USB_CR3_USTS_normal_b3                      ((uint8_t )0x00)
#define USB_CR3_USTS_add1_w                         ((uint32_t)0x04000000)
#define USB_CR3_USTS_add1_h1                        ((uint16_t)0x0400)
#define USB_CR3_USTS_add1_b3                        ((uint8_t )0x04)
#define USB_CR3_USTS_dec1_w                         ((uint32_t)0x05000000)
#define USB_CR3_USTS_dec1_h1                        ((uint16_t)0x0500)
#define USB_CR3_USTS_dec1_b3                        ((uint8_t )0x05)
#define USB_CR3_USTS_add4_w                         ((uint32_t)0x06000000)
#define USB_CR3_USTS_add4_h1                        ((uint16_t)0x0600)
#define USB_CR3_USTS_add4_b3                        ((uint8_t )0x06)
#define USB_CR3_USTS_dec4_w                         ((uint32_t)0x07000000)
#define USB_CR3_USTS_dec4_h1                        ((uint16_t)0x0700)
#define USB_CR3_USTS_dec4_b3                        ((uint8_t )0x07)
#define USB_CR3_USTS_hit_w                          ((uint32_t)0x08000000)
#define USB_CR3_USTS_hit_h1                         ((uint16_t)0x0800)
#define USB_CR3_USTS_hit_b3                         ((uint8_t )0x08)

#define USB_CR3_STSO_ACK_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_CR3_STSO_ACK_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_CR3_STSO_ACK_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_CR3_STSO_ACK_stlnak_w                   ((uint32_t)0x00000000)
#define USB_CR3_STSO_ACK_stlnak_h1                  ((uint16_t)0x0000)
#define USB_CR3_STSO_ACK_stlnak_b2                  ((uint8_t )0x00)
#define USB_CR3_STSO_ACK_ack_w                      ((uint32_t)0x00100000)
#define USB_CR3_STSO_ACK_ack_h1                     ((uint16_t)0x0010)
#define USB_CR3_STSO_ACK_ack_b2                     ((uint8_t )0x10)

#define USB_CR3_SE1D_mask_w                         ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_CR3_SE1D_mask_h1                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_CR3_SE1D_mask_b2                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_CR3_SE1D_t0_w                           ((uint32_t)0x00000000)
#define USB_CR3_SE1D_t0_h1                          ((uint16_t)0x0000)
#define USB_CR3_SE1D_t0_b2                          ((uint8_t )0x00)
#define USB_CR3_SE1D_t1_w                           ((uint32_t)0x00080000)
#define USB_CR3_SE1D_t1_h1                          ((uint16_t)0x0008)
#define USB_CR3_SE1D_t1_b2                          ((uint8_t )0x08)

#define USB_CR3_SE1C_mask_w                         ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_CR3_SE1C_mask_h1                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_CR3_SE1C_mask_b2                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_CR3_SE1C_disable_w                      ((uint32_t)0x00000000)
#define USB_CR3_SE1C_disable_h1                     ((uint16_t)0x0000)
#define USB_CR3_SE1C_disable_b2                     ((uint8_t )0x00)
#define USB_CR3_SE1C_auto_w                         ((uint32_t)0x00040000)
#define USB_CR3_SE1C_auto_h1                        ((uint16_t)0x0004)
#define USB_CR3_SE1C_auto_b2                        ((uint8_t )0x04)

#define USB_CR3_DJS15_mask_w                        ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_CR3_DJS15_mask_h1                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_CR3_DJS15_mask_b2                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_CR3_DJS15_onehalf_w                     ((uint32_t)0x00000000)
#define USB_CR3_DJS15_onehalf_h1                    ((uint16_t)0x0000)
#define USB_CR3_DJS15_onehalf_b2                    ((uint8_t )0x00)
#define USB_CR3_DJS15_one_w                         ((uint32_t)0x00020000)
#define USB_CR3_DJS15_one_h1                        ((uint16_t)0x0002)
#define USB_CR3_DJS15_one_b2                        ((uint8_t )0x02)

#define USB_CR3_S1_SEL_mask_w                       ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define USB_CR3_S1_SEL_mask_h0                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define USB_CR3_S1_SEL_mask_b1                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define USB_CR3_S1_SEL_tx_oe_w                      ((uint32_t)0x00000000)
#define USB_CR3_S1_SEL_tx_oe_h0                     ((uint16_t)0x0000)
#define USB_CR3_S1_SEL_tx_oe_b1                     ((uint8_t )0x00)
#define USB_CR3_S1_SEL_sig1_w                       ((uint32_t)0x00004000)
#define USB_CR3_S1_SEL_sig1_h0                      ((uint16_t)0x4000)
#define USB_CR3_S1_SEL_sig1_b1                      ((uint8_t )0x40)
#define USB_CR3_S1_SEL_sig2_w                       ((uint32_t)0x00008000)
#define USB_CR3_S1_SEL_sig2_h0                      ((uint16_t)0x8000)
#define USB_CR3_S1_SEL_sig2_b1                      ((uint8_t )0x80)
#define USB_CR3_S1_SEL_sig3_w                       ((uint32_t)0x0000C000)
#define USB_CR3_S1_SEL_sig3_h0                      ((uint16_t)0xC000)
#define USB_CR3_S1_SEL_sig3_b1                      ((uint8_t )0xC0)

#define USB_CR3_S0_SEL_mask_w                       ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define USB_CR3_S0_SEL_mask_h0                      ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define USB_CR3_S0_SEL_mask_b1                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define USB_CR3_S0_SEL_ck_sof_w                     ((uint32_t)0x00000000)
#define USB_CR3_S0_SEL_ck_sof_h0                    ((uint16_t)0x0000)
#define USB_CR3_S0_SEL_ck_sof_b1                    ((uint8_t )0x00)
#define USB_CR3_S0_SEL_sig1_w                       ((uint32_t)0x00001000)
#define USB_CR3_S0_SEL_sig1_h0                      ((uint16_t)0x1000)
#define USB_CR3_S0_SEL_sig1_b1                      ((uint8_t )0x10)
#define USB_CR3_S0_SEL_sig2_w                       ((uint32_t)0x00002000)
#define USB_CR3_S0_SEL_sig2_h0                      ((uint16_t)0x2000)
#define USB_CR3_S0_SEL_sig2_b1                      ((uint8_t )0x20)
#define USB_CR3_S0_SEL_sig3_w                       ((uint32_t)0x00003000)
#define USB_CR3_S0_SEL_sig3_h0                      ((uint16_t)0x3000)
#define USB_CR3_S0_SEL_sig3_b1                      ((uint8_t )0x30)

#define USB_CR3_UACK_TRG_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define USB_CR3_UACK_TRG_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define USB_CR3_UACK_TRG_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_CR3_UACK_TRG_no_w                       ((uint32_t)0x00000000)
#define USB_CR3_UACK_TRG_no_h0                      ((uint16_t)0x0000)
#define USB_CR3_UACK_TRG_no_b0                      ((uint8_t )0x00)
#define USB_CR3_UACK_TRG_enable_w                   ((uint32_t)0x00000080)
#define USB_CR3_UACK_TRG_enable_h0                  ((uint16_t)0x0080)
#define USB_CR3_UACK_TRG_enable_b0                  ((uint8_t )0x80)

#define USB_CR3_UACK_EN_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_CR3_UACK_EN_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_CR3_UACK_EN_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_CR3_UACK_EN_disable_w                   ((uint32_t)0x00000000)
#define USB_CR3_UACK_EN_disable_h0                  ((uint16_t)0x0000)
#define USB_CR3_UACK_EN_disable_b0                  ((uint8_t )0x00)
#define USB_CR3_UACK_EN_enable_w                    ((uint32_t)0x00000040)
#define USB_CR3_UACK_EN_enable_h0                   ((uint16_t)0x0040)
#define USB_CR3_UACK_EN_enable_b0                   ((uint8_t )0x40)

#define USB_CR3_EYEO_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_CR3_EYEO_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_CR3_EYEO_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_CR3_EYEO_EN_disable_w                   ((uint32_t)0x00000000)
#define USB_CR3_EYEO_EN_disable_h0                  ((uint16_t)0x0000)
#define USB_CR3_EYEO_EN_disable_b0                  ((uint8_t )0x00)
#define USB_CR3_EYEO_EN_enable_w                    ((uint32_t)0x00000008)
#define USB_CR3_EYEO_EN_enable_h0                   ((uint16_t)0x0008)
#define USB_CR3_EYEO_EN_enable_b0                   ((uint8_t )0x08)

#define USB_CR3_UTRO_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_CR3_UTRO_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_CR3_UTRO_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_CR3_UTRO_EN_disable_w                   ((uint32_t)0x00000000)
#define USB_CR3_UTRO_EN_disable_h0                  ((uint16_t)0x0000)
#define USB_CR3_UTRO_EN_disable_b0                  ((uint8_t )0x00)
#define USB_CR3_UTRO_EN_enable_w                    ((uint32_t)0x00000004)
#define USB_CR3_UTRO_EN_enable_h0                   ((uint16_t)0x0004)
#define USB_CR3_UTRO_EN_enable_b0                   ((uint8_t )0x04)

#define USB_CR3_FOPEN_EN_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_CR3_FOPEN_EN_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_CR3_FOPEN_EN_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_CR3_FOPEN_EN_disable_w                  ((uint32_t)0x00000000)
#define USB_CR3_FOPEN_EN_disable_h0                 ((uint16_t)0x0000)
#define USB_CR3_FOPEN_EN_disable_b0                 ((uint8_t )0x00)
#define USB_CR3_FOPEN_EN_enable_w                   ((uint32_t)0x00000002)
#define USB_CR3_FOPEN_EN_enable_h0                  ((uint16_t)0x0002)
#define USB_CR3_FOPEN_EN_enable_b0                  ((uint8_t )0x02)

///@}
/**
 ******************************************************************************
 * @name        USB_EP0CR0  [register's definitions]
 *              Offset[0x40]  USB end-point 0 control register 0 (0x54000040)
 ******************************************************************************
 */
///@{
#define USB_EP0CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP0CR0 */
#define USB_EP0CR0_TXSTL0F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXSTL0F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXSTL0F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXSTL0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_TXSTL0F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_TXSTL0F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_TXSTL0F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_TXSTL0F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_TXSTL0F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_TXNAK0F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXNAK0F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXNAK0F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXNAK0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_TXNAK0F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_TXNAK0F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_TXNAK0F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_TXNAK0F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_TXNAK0F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_TXD0F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXD0F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXD0F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXD0F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_TXD0F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_TXD0F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_TXD0F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_TXD0F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_TXD0F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_RXSTL0F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXSTL0F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXSTL0F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXSTL0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_RXSTL0F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_RXSTL0F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_RXSTL0F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_RXSTL0F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_RXSTL0F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_RXNAK0F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXNAK0F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXNAK0F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXNAK0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_RXNAK0F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_RXNAK0F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_RXNAK0F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_RXNAK0F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_RXNAK0F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_RXD0F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXD0F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXD0F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXD0F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_RXD0F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_RXD0F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_RXD0F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_RXD0F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_RXD0F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_TXRST0_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXRST0_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXRST0_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXRST0_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP0CR0_TXRST0_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP0CR0_TXRST0_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP0CR0_TXRST0_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_TXRST0_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_TXRST0_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_RXRST0_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXRST0_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXRST0_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXRST0_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP0CR0_RXRST0_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP0CR0_RXRST0_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP0CR0_RXRST0_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_RXRST0_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_RXRST0_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_SETUP0F_mask_w                   ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_SETUP0F_mask_h0                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_SETUP0F_mask_b1                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_SETUP0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_SETUP0F_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_SETUP0F_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_SETUP0F_happened_w               ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_SETUP0F_happened_h0              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_SETUP0F_happened_b1              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_EDOVW0F_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_EDOVW0F_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_EDOVW0F_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_EDOVW0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_EDOVW0F_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_EDOVW0F_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_EDOVW0F_happened_w               ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_EDOVW0F_happened_h0              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_EDOVW0F_happened_b1              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_STOVW0F_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_STOVW0F_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_STOVW0F_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_STOVW0F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP0CR0_STOVW0F_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP0CR0_STOVW0F_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP0CR0_STOVW0F_happened_w               ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP0CR0_STOVW0F_happened_h0              ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP0CR0_STOVW0F_happened_b1              ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP0CR0_TXSTL0_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXSTL0_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXSTL0_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXSTL0_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR0_TXSTL0_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR0_TXSTL0_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR0_TXSTL0_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_TXSTL0_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_TXSTL0_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_TXNAK0_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXNAK0_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXNAK0_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXNAK0_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR0_TXNAK0_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR0_TXNAK0_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR0_TXNAK0_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_TXNAK0_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_TXNAK0_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_TXD0_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_TXD0_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_TXD0_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_TXD0_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR0_TXD0_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR0_TXD0_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR0_TXD0_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_TXD0_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_TXD0_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_RXSTL0_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXSTL0_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXSTL0_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXSTL0_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR0_RXSTL0_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR0_RXSTL0_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR0_RXSTL0_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_RXSTL0_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_RXSTL0_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_RXNAK0_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXNAK0_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXNAK0_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXNAK0_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR0_RXNAK0_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR0_RXNAK0_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR0_RXNAK0_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_RXNAK0_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_RXNAK0_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR0_RXD0_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP0CR0_RXD0_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP0CR0_RXD0_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP0CR0_RXD0_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR0_RXD0_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR0_RXD0_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR0_RXD0_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR0_RXD0_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR0_RXD0_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP0CR1  [register's definitions]
 *              Offset[0x44]  USB end-point 0 control register 1 (0x54000044)
 ******************************************************************************
 */
///@{
#define USB_EP0CR1_default                          ((uint32_t)0x01050000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP0CR1 */
#define USB_EP0CR1_TXS_LCK0_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_TXS_LCK0_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_TXS_LCK0_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_TXS_LCK0_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP0CR1_TXS_LCK0_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP0CR1_TXS_LCK0_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP0CR1_TXS_LCK0_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP0CR1_TXS_LCK0_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP0CR1_TXS_LCK0_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP0CR1_TXSEQ0_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_TXSEQ0_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_TXSEQ0_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP0CR1_TXSA_LCK0_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_TXSA_LCK0_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_TXSA_LCK0_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_TXSA_LCK0_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP0CR1_TXSA_LCK0_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP0CR1_TXSA_LCK0_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP0CR1_TXSA_LCK0_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP0CR1_TXSA_LCK0_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP0CR1_TXSA_LCK0_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP0CR1_TXMC0_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_TXMC0_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_TXMC0_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_TXMC0_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP0CR1_TXMC0_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP0CR1_TXMC0_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP0CR1_TXMC0_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP0CR1_TXMC0_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP0CR1_TXMC0_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP0CR1_TXSTL0_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_TXSTL0_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_TXSTL0_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_TXSTL0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR1_TXSTL0_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR1_TXSTL0_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR1_TXSTL0_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR1_TXSTL0_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR1_TXSTL0_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR1_TXEN0_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_TXEN0_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_TXEN0_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_TXEN0_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR1_TXEN0_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR1_TXEN0_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR1_TXEN0_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR1_TXEN0_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR1_TXEN0_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR1_RXS_LCK0_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_RXS_LCK0_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_RXS_LCK0_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_RXS_LCK0_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP0CR1_RXS_LCK0_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP0CR1_RXS_LCK0_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP0CR1_RXS_LCK0_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP0CR1_RXS_LCK0_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP0CR1_RXS_LCK0_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP0CR1_RXSEQ0_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_RXSEQ0_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_RXSEQ0_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP0CR1_RXSA_LCK0_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_RXSA_LCK0_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_RXSA_LCK0_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_RXSA_LCK0_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP0CR1_RXSA_LCK0_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP0CR1_RXSA_LCK0_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP0CR1_RXSA_LCK0_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP0CR1_RXSA_LCK0_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP0CR1_RXSA_LCK0_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP0CR1_RXMC0_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_RXMC0_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_RXMC0_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_RXMC0_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP0CR1_RXMC0_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP0CR1_RXMC0_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP0CR1_RXMC0_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP0CR1_RXMC0_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP0CR1_RXMC0_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP0CR1_RXSTL0_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_RXSTL0_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_RXSTL0_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_RXSTL0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR1_RXSTL0_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR1_RXSTL0_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR1_RXSTL0_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR1_RXSTL0_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR1_RXSTL0_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR1_RXEN0_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_RXEN0_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_RXEN0_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_RXEN0_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP0CR1_RXEN0_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP0CR1_RXEN0_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP0CR1_RXEN0_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP0CR1_RXEN0_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP0CR1_RXEN0_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP0CR1_BLSIZE0_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_BLSIZE0_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_BLSIZE0_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP0CR1_BLSIZE0_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP0CR1_BLSIZE0_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP0CR1_BLSIZE0_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP0CR1_BLSIZE0_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP0CR1_BLSIZE0_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP0CR1_BLSIZE0_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP0CR1_BLNUM0_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP0CR1_BLNUM0_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP0CR1_BLNUM0_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP0RX  [register's definitions]
 *              Offset[0x48]  USB end-point 0 receive register (0x54000048)
 ******************************************************************************
 */
///@{
#define USB_EP0RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP0RX */
#define USB_EP0RX_RXCNT0_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP0RX_RXCNT0_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP0RX_RXADR0_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP0RX_RXADR0_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP0TX  [register's definitions]
 *              Offset[0x4C]  USB end-point 0 transmit register (0x5400004C)
 ******************************************************************************
 */
///@{
#define USB_EP0TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP0TX */
#define USB_EP0TX_TXCNT0_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP0TX_TXCNT0_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP0TX_TXADR0_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP0TX_TXADR0_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP1CR0  [register's definitions]
 *              Offset[0x50]  USB end-point 1 control register 0 (0x54000050)
 ******************************************************************************
 */
///@{
#define USB_EP1CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP1CR0 */
#define USB_EP1CR0_ISOTXE1F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_ISOTXE1F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_ISOTXE1F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_ISOTXE1F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_ISOTXE1F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_ISOTXE1F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_ISOTXE1F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_ISOTXE1F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_ISOTXE1F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_TXSTL1F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXSTL1F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXSTL1F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXSTL1F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_TXSTL1F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_TXSTL1F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_TXSTL1F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_TXSTL1F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_TXSTL1F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_TXNAK1F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXNAK1F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXNAK1F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXNAK1F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_TXNAK1F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_TXNAK1F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_TXNAK1F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_TXNAK1F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_TXNAK1F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_TXD1F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXD1F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXD1F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXD1F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_TXD1F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_TXD1F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_TXD1F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_TXD1F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_TXD1F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_ISOOVW1F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_ISOOVW1F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_ISOOVW1F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_ISOOVW1F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_ISOOVW1F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_ISOOVW1F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_ISOOVW1F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_ISOOVW1F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_ISOOVW1F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_RXSTL1F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXSTL1F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXSTL1F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXSTL1F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_RXSTL1F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_RXSTL1F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_RXSTL1F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_RXSTL1F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_RXSTL1F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_RXNAK1F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXNAK1F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXNAK1F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXNAK1F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_RXNAK1F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_RXNAK1F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_RXNAK1F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_RXNAK1F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_RXNAK1F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_RXD1F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXD1F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXD1F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXD1F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP1CR0_RXD1F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP1CR0_RXD1F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP1CR0_RXD1F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP1CR0_RXD1F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP1CR0_RXD1F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP1CR0_TXRST1_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXRST1_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXRST1_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXRST1_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP1CR0_TXRST1_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP1CR0_TXRST1_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP1CR0_TXRST1_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_TXRST1_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_TXRST1_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_RXRST1_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXRST1_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXRST1_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXRST1_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP1CR0_RXRST1_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP1CR0_RXRST1_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP1CR0_RXRST1_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_RXRST1_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_RXRST1_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_TXSTL1_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXSTL1_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXSTL1_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXSTL1_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR0_TXSTL1_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR0_TXSTL1_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR0_TXSTL1_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_TXSTL1_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_TXSTL1_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_TXNAK1_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXNAK1_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXNAK1_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXNAK1_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR0_TXNAK1_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR0_TXNAK1_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR0_TXNAK1_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_TXNAK1_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_TXNAK1_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_TXD1_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_TXD1_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_TXD1_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_TXD1_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR0_TXD1_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR0_TXD1_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR0_TXD1_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_TXD1_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_TXD1_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_RXSTL1_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXSTL1_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXSTL1_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXSTL1_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR0_RXSTL1_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR0_RXSTL1_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR0_RXSTL1_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_RXSTL1_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_RXSTL1_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_RXNAK1_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXNAK1_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXNAK1_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXNAK1_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR0_RXNAK1_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR0_RXNAK1_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR0_RXNAK1_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_RXNAK1_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_RXNAK1_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR0_RXD1_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP1CR0_RXD1_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP1CR0_RXD1_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP1CR0_RXD1_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR0_RXD1_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR0_RXD1_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR0_RXD1_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR0_RXD1_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR0_RXD1_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP1CR1  [register's definitions]
 *              Offset[0x54]  USB end-point 1 control register 1 (0x54000054)
 ******************************************************************************
 */
///@{
#define USB_EP1CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP1CR1 */
#define USB_EP1CR1_TXS_LCK1_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXS_LCK1_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXS_LCK1_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_TXS_LCK1_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP1CR1_TXS_LCK1_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP1CR1_TXS_LCK1_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP1CR1_TXS_LCK1_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP1CR1_TXS_LCK1_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP1CR1_TXS_LCK1_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP1CR1_TXSEQ1_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXSEQ1_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXSEQ1_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP1CR1_TXSA_LCK1_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXSA_LCK1_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXSA_LCK1_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_TXSA_LCK1_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP1CR1_TXSA_LCK1_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP1CR1_TXSA_LCK1_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP1CR1_TXSA_LCK1_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP1CR1_TXSA_LCK1_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP1CR1_TXSA_LCK1_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP1CR1_TXMC1_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXMC1_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXMC1_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_TXMC1_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP1CR1_TXMC1_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP1CR1_TXMC1_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP1CR1_TXMC1_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP1CR1_TXMC1_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP1CR1_TXMC1_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP1CR1_TXSTL1_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXSTL1_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXSTL1_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_TXSTL1_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR1_TXSTL1_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR1_TXSTL1_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR1_TXSTL1_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR1_TXSTL1_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR1_TXSTL1_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR1_TXEN1_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXEN1_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXEN1_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_TXEN1_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR1_TXEN1_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR1_TXEN1_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR1_TXEN1_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR1_TXEN1_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR1_TXEN1_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR1_RXS_LCK1_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXS_LCK1_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXS_LCK1_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_RXS_LCK1_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP1CR1_RXS_LCK1_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP1CR1_RXS_LCK1_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP1CR1_RXS_LCK1_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP1CR1_RXS_LCK1_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP1CR1_RXS_LCK1_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP1CR1_RXSEQ1_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXSEQ1_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXSEQ1_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP1CR1_RXSA_LCK1_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXSA_LCK1_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXSA_LCK1_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_RXSA_LCK1_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP1CR1_RXSA_LCK1_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP1CR1_RXSA_LCK1_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP1CR1_RXSA_LCK1_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP1CR1_RXSA_LCK1_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP1CR1_RXSA_LCK1_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP1CR1_RXMC1_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXMC1_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXMC1_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_RXMC1_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP1CR1_RXMC1_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP1CR1_RXMC1_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP1CR1_RXMC1_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP1CR1_RXMC1_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP1CR1_RXMC1_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP1CR1_RXSTL1_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXSTL1_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXSTL1_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_RXSTL1_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR1_RXSTL1_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR1_RXSTL1_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR1_RXSTL1_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR1_RXSTL1_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR1_RXSTL1_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR1_RXEN1_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXEN1_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXEN1_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_RXEN1_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR1_RXEN1_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR1_RXEN1_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR1_RXEN1_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR1_RXEN1_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR1_RXEN1_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR1_DBM1_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_DBM1_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_DBM1_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_DBM1_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP1CR1_DBM1_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP1CR1_DBM1_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP1CR1_DBM1_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP1CR1_DBM1_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP1CR1_DBM1_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP1CR1_BLSIZE1_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_BLSIZE1_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_BLSIZE1_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_BLSIZE1_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP1CR1_BLSIZE1_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP1CR1_BLSIZE1_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP1CR1_BLSIZE1_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP1CR1_BLSIZE1_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP1CR1_BLSIZE1_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP1CR1_BLNUM1_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_BLNUM1_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_BLNUM1_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP1CR1_TXTYPE1_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_TXTYPE1_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_TXTYPE1_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_TXTYPE1_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP1CR1_TXTYPE1_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP1CR1_TXTYPE1_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP1CR1_TXTYPE1_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP1CR1_TXTYPE1_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP1CR1_TXTYPE1_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP1CR1_RXTYPE1_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_RXTYPE1_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_RXTYPE1_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_RXTYPE1_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP1CR1_RXTYPE1_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP1CR1_RXTYPE1_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP1CR1_RXTYPE1_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP1CR1_RXTYPE1_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP1CR1_RXTYPE1_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP1CR1_EPADR1_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP1CR1_EPADR1_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP1CR1_EPADR1_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP1CR1_EPADR1_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP1CR1_EPADR1_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP1CR1_EPADR1_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP1RX  [register's definitions]
 *              Offset[0x58]  USB end-point 1 receive register (0x54000058)
 ******************************************************************************
 */
///@{
#define USB_EP1RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP1RX */
#define USB_EP1RX_RXCNT1_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP1RX_RXCNT1_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP1RX_RXADR1_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP1RX_RXADR1_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP1TX  [register's definitions]
 *              Offset[0x5C]  USB end-point 1 transmit register (0x5400005C)
 ******************************************************************************
 */
///@{
#define USB_EP1TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP1TX */
#define USB_EP1TX_TXCNT1_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP1TX_TXCNT1_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP1TX_TXADR1_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP1TX_TXADR1_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP2CR0  [register's definitions]
 *              Offset[0x60]  USB end-point 2 control register 0 (0x54000060)
 ******************************************************************************
 */
///@{
#define USB_EP2CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP2CR0 */
#define USB_EP2CR0_ISOTXE2F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_ISOTXE2F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_ISOTXE2F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_ISOTXE2F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_ISOTXE2F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_ISOTXE2F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_ISOTXE2F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_ISOTXE2F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_ISOTXE2F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_TXSTL2F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXSTL2F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXSTL2F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXSTL2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_TXSTL2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_TXSTL2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_TXSTL2F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_TXSTL2F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_TXSTL2F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_TXNAK2F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXNAK2F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXNAK2F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXNAK2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_TXNAK2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_TXNAK2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_TXNAK2F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_TXNAK2F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_TXNAK2F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_TXD2F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXD2F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXD2F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXD2F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_TXD2F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_TXD2F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_TXD2F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_TXD2F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_TXD2F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_ISOOVW2F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_ISOOVW2F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_ISOOVW2F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_ISOOVW2F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_ISOOVW2F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_ISOOVW2F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_ISOOVW2F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_ISOOVW2F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_ISOOVW2F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_RXSTL2F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXSTL2F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXSTL2F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXSTL2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_RXSTL2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_RXSTL2F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_RXSTL2F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_RXSTL2F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_RXSTL2F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_RXNAK2F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXNAK2F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXNAK2F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXNAK2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_RXNAK2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_RXNAK2F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_RXNAK2F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_RXNAK2F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_RXNAK2F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_RXD2F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXD2F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXD2F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXD2F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP2CR0_RXD2F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP2CR0_RXD2F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP2CR0_RXD2F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP2CR0_RXD2F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP2CR0_RXD2F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP2CR0_TXRST2_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXRST2_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXRST2_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXRST2_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP2CR0_TXRST2_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP2CR0_TXRST2_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP2CR0_TXRST2_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_TXRST2_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_TXRST2_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_RXRST2_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXRST2_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXRST2_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXRST2_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP2CR0_RXRST2_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP2CR0_RXRST2_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP2CR0_RXRST2_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_RXRST2_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_RXRST2_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_TXSTL2_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXSTL2_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXSTL2_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXSTL2_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR0_TXSTL2_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR0_TXSTL2_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR0_TXSTL2_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_TXSTL2_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_TXSTL2_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_TXNAK2_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXNAK2_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXNAK2_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXNAK2_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR0_TXNAK2_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR0_TXNAK2_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR0_TXNAK2_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_TXNAK2_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_TXNAK2_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_TXD2_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_TXD2_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_TXD2_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_TXD2_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR0_TXD2_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR0_TXD2_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR0_TXD2_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_TXD2_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_TXD2_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_RXSTL2_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXSTL2_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXSTL2_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXSTL2_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR0_RXSTL2_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR0_RXSTL2_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR0_RXSTL2_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_RXSTL2_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_RXSTL2_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_RXNAK2_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXNAK2_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXNAK2_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXNAK2_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR0_RXNAK2_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR0_RXNAK2_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR0_RXNAK2_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_RXNAK2_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_RXNAK2_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR0_RXD2_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP2CR0_RXD2_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP2CR0_RXD2_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP2CR0_RXD2_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR0_RXD2_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR0_RXD2_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR0_RXD2_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR0_RXD2_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR0_RXD2_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP2CR1  [register's definitions]
 *              Offset[0x64]  USB end-point 2 control register 1 (0x54000064)
 ******************************************************************************
 */
///@{
#define USB_EP2CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP2CR1 */
#define USB_EP2CR1_TXS_LCK2_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXS_LCK2_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXS_LCK2_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_TXS_LCK2_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP2CR1_TXS_LCK2_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP2CR1_TXS_LCK2_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP2CR1_TXS_LCK2_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP2CR1_TXS_LCK2_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP2CR1_TXS_LCK2_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP2CR1_TXSEQ2_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXSEQ2_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXSEQ2_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP2CR1_TXSA_LCK2_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXSA_LCK2_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXSA_LCK2_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_TXSA_LCK2_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP2CR1_TXSA_LCK2_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP2CR1_TXSA_LCK2_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP2CR1_TXSA_LCK2_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP2CR1_TXSA_LCK2_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP2CR1_TXSA_LCK2_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP2CR1_TXMC2_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXMC2_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXMC2_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_TXMC2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP2CR1_TXMC2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP2CR1_TXMC2_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP2CR1_TXMC2_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP2CR1_TXMC2_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP2CR1_TXMC2_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP2CR1_TXSTL2_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXSTL2_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXSTL2_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_TXSTL2_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR1_TXSTL2_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR1_TXSTL2_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR1_TXSTL2_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR1_TXSTL2_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR1_TXSTL2_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR1_TXEN2_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXEN2_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXEN2_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_TXEN2_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR1_TXEN2_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR1_TXEN2_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR1_TXEN2_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR1_TXEN2_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR1_TXEN2_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR1_RXS_LCK2_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXS_LCK2_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXS_LCK2_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_RXS_LCK2_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP2CR1_RXS_LCK2_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP2CR1_RXS_LCK2_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP2CR1_RXS_LCK2_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP2CR1_RXS_LCK2_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP2CR1_RXS_LCK2_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP2CR1_RXSEQ2_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXSEQ2_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXSEQ2_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP2CR1_RXSA_LCK2_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXSA_LCK2_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXSA_LCK2_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_RXSA_LCK2_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP2CR1_RXSA_LCK2_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP2CR1_RXSA_LCK2_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP2CR1_RXSA_LCK2_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP2CR1_RXSA_LCK2_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP2CR1_RXSA_LCK2_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP2CR1_RXMC2_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXMC2_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXMC2_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_RXMC2_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP2CR1_RXMC2_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP2CR1_RXMC2_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP2CR1_RXMC2_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP2CR1_RXMC2_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP2CR1_RXMC2_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP2CR1_RXSTL2_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXSTL2_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXSTL2_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_RXSTL2_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR1_RXSTL2_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR1_RXSTL2_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR1_RXSTL2_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR1_RXSTL2_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR1_RXSTL2_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR1_RXEN2_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXEN2_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXEN2_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_RXEN2_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR1_RXEN2_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR1_RXEN2_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR1_RXEN2_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR1_RXEN2_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR1_RXEN2_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR1_DBM2_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_DBM2_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_DBM2_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_DBM2_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP2CR1_DBM2_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP2CR1_DBM2_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP2CR1_DBM2_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP2CR1_DBM2_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP2CR1_DBM2_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP2CR1_BLSIZE2_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_BLSIZE2_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_BLSIZE2_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_BLSIZE2_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP2CR1_BLSIZE2_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP2CR1_BLSIZE2_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP2CR1_BLSIZE2_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP2CR1_BLSIZE2_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP2CR1_BLSIZE2_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP2CR1_BLNUM2_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_BLNUM2_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_BLNUM2_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP2CR1_TXTYPE2_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_TXTYPE2_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_TXTYPE2_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_TXTYPE2_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP2CR1_TXTYPE2_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP2CR1_TXTYPE2_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP2CR1_TXTYPE2_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP2CR1_TXTYPE2_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP2CR1_TXTYPE2_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP2CR1_RXTYPE2_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_RXTYPE2_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_RXTYPE2_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_RXTYPE2_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP2CR1_RXTYPE2_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP2CR1_RXTYPE2_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP2CR1_RXTYPE2_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP2CR1_RXTYPE2_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP2CR1_RXTYPE2_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP2CR1_EPADR2_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP2CR1_EPADR2_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP2CR1_EPADR2_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP2CR1_EPADR2_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP2CR1_EPADR2_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP2CR1_EPADR2_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP2RX  [register's definitions]
 *              Offset[0x68]  USB end-point 2 receive register (0x54000068)
 ******************************************************************************
 */
///@{
#define USB_EP2RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP2RX */
#define USB_EP2RX_RXCNT2_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP2RX_RXCNT2_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP2RX_RXADR2_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP2RX_RXADR2_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP2TX  [register's definitions]
 *              Offset[0x6C]  USB end-point 2 transmit register (0x5400006C)
 ******************************************************************************
 */
///@{
#define USB_EP2TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP2TX */
#define USB_EP2TX_TXCNT2_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP2TX_TXCNT2_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP2TX_TXADR2_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP2TX_TXADR2_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP3CR0  [register's definitions]
 *              Offset[0x70]  USB end-point 3 control register 0 (0x54000070)
 ******************************************************************************
 */
///@{
#define USB_EP3CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP3CR0 */
#define USB_EP3CR0_ISOTXE3F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_ISOTXE3F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_ISOTXE3F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_ISOTXE3F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_ISOTXE3F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_ISOTXE3F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_ISOTXE3F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_ISOTXE3F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_ISOTXE3F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_TXSTL3F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXSTL3F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXSTL3F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXSTL3F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_TXSTL3F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_TXSTL3F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_TXSTL3F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_TXSTL3F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_TXSTL3F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_TXNAK3F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXNAK3F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXNAK3F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXNAK3F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_TXNAK3F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_TXNAK3F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_TXNAK3F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_TXNAK3F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_TXNAK3F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_TXD3F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXD3F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXD3F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXD3F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_TXD3F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_TXD3F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_TXD3F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_TXD3F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_TXD3F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_ISOOVW3F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_ISOOVW3F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_ISOOVW3F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_ISOOVW3F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_ISOOVW3F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_ISOOVW3F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_ISOOVW3F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_ISOOVW3F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_ISOOVW3F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_RXSTL3F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXSTL3F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXSTL3F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXSTL3F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_RXSTL3F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_RXSTL3F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_RXSTL3F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_RXSTL3F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_RXSTL3F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_RXNAK3F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXNAK3F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXNAK3F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXNAK3F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_RXNAK3F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_RXNAK3F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_RXNAK3F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_RXNAK3F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_RXNAK3F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_RXD3F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXD3F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXD3F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXD3F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP3CR0_RXD3F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP3CR0_RXD3F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP3CR0_RXD3F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP3CR0_RXD3F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP3CR0_RXD3F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP3CR0_TXRST3_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXRST3_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXRST3_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXRST3_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP3CR0_TXRST3_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP3CR0_TXRST3_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP3CR0_TXRST3_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_TXRST3_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_TXRST3_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_RXRST3_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXRST3_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXRST3_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXRST3_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP3CR0_RXRST3_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP3CR0_RXRST3_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP3CR0_RXRST3_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_RXRST3_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_RXRST3_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_TXSTL3_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXSTL3_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXSTL3_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXSTL3_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR0_TXSTL3_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR0_TXSTL3_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR0_TXSTL3_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_TXSTL3_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_TXSTL3_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_TXNAK3_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXNAK3_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXNAK3_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXNAK3_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR0_TXNAK3_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR0_TXNAK3_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR0_TXNAK3_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_TXNAK3_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_TXNAK3_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_TXD3_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_TXD3_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_TXD3_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_TXD3_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR0_TXD3_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR0_TXD3_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR0_TXD3_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_TXD3_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_TXD3_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_RXSTL3_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXSTL3_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXSTL3_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXSTL3_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR0_RXSTL3_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR0_RXSTL3_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR0_RXSTL3_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_RXSTL3_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_RXSTL3_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_RXNAK3_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXNAK3_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXNAK3_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXNAK3_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR0_RXNAK3_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR0_RXNAK3_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR0_RXNAK3_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_RXNAK3_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_RXNAK3_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR0_RXD3_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP3CR0_RXD3_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP3CR0_RXD3_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP3CR0_RXD3_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR0_RXD3_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR0_RXD3_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR0_RXD3_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR0_RXD3_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR0_RXD3_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP3CR1  [register's definitions]
 *              Offset[0x74]  USB end-point 3 control register 1 (0x54000074)
 ******************************************************************************
 */
///@{
#define USB_EP3CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP3CR1 */
#define USB_EP3CR1_TXS_LCK3_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXS_LCK3_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXS_LCK3_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_TXS_LCK3_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP3CR1_TXS_LCK3_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP3CR1_TXS_LCK3_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP3CR1_TXS_LCK3_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP3CR1_TXS_LCK3_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP3CR1_TXS_LCK3_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP3CR1_TXSEQ3_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXSEQ3_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXSEQ3_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP3CR1_TXSA_LCK3_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXSA_LCK3_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXSA_LCK3_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_TXSA_LCK3_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP3CR1_TXSA_LCK3_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP3CR1_TXSA_LCK3_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP3CR1_TXSA_LCK3_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP3CR1_TXSA_LCK3_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP3CR1_TXSA_LCK3_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP3CR1_TXMC3_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXMC3_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXMC3_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_TXMC3_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP3CR1_TXMC3_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP3CR1_TXMC3_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP3CR1_TXMC3_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP3CR1_TXMC3_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP3CR1_TXMC3_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP3CR1_TXSTL3_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXSTL3_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXSTL3_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_TXSTL3_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR1_TXSTL3_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR1_TXSTL3_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR1_TXSTL3_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR1_TXSTL3_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR1_TXSTL3_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR1_TXEN3_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXEN3_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXEN3_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_TXEN3_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR1_TXEN3_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR1_TXEN3_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR1_TXEN3_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR1_TXEN3_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR1_TXEN3_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR1_RXS_LCK3_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXS_LCK3_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXS_LCK3_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_RXS_LCK3_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP3CR1_RXS_LCK3_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP3CR1_RXS_LCK3_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP3CR1_RXS_LCK3_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP3CR1_RXS_LCK3_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP3CR1_RXS_LCK3_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP3CR1_RXSEQ3_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXSEQ3_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXSEQ3_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP3CR1_RXSA_LCK3_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXSA_LCK3_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXSA_LCK3_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_RXSA_LCK3_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP3CR1_RXSA_LCK3_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP3CR1_RXSA_LCK3_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP3CR1_RXSA_LCK3_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP3CR1_RXSA_LCK3_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP3CR1_RXSA_LCK3_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP3CR1_RXMC3_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXMC3_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXMC3_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_RXMC3_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP3CR1_RXMC3_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP3CR1_RXMC3_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP3CR1_RXMC3_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP3CR1_RXMC3_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP3CR1_RXMC3_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP3CR1_RXSTL3_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXSTL3_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXSTL3_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_RXSTL3_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR1_RXSTL3_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR1_RXSTL3_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR1_RXSTL3_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR1_RXSTL3_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR1_RXSTL3_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR1_RXEN3_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXEN3_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXEN3_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_RXEN3_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR1_RXEN3_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR1_RXEN3_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR1_RXEN3_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR1_RXEN3_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR1_RXEN3_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR1_DBM3_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_DBM3_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_DBM3_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_DBM3_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP3CR1_DBM3_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP3CR1_DBM3_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP3CR1_DBM3_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP3CR1_DBM3_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP3CR1_DBM3_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP3CR1_BLSIZE3_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_BLSIZE3_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_BLSIZE3_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_BLSIZE3_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP3CR1_BLSIZE3_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP3CR1_BLSIZE3_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP3CR1_BLSIZE3_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP3CR1_BLSIZE3_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP3CR1_BLSIZE3_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP3CR1_BLNUM3_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_BLNUM3_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_BLNUM3_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP3CR1_TXTYPE3_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_TXTYPE3_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_TXTYPE3_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_TXTYPE3_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP3CR1_TXTYPE3_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP3CR1_TXTYPE3_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP3CR1_TXTYPE3_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP3CR1_TXTYPE3_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP3CR1_TXTYPE3_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP3CR1_RXTYPE3_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_RXTYPE3_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_RXTYPE3_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_RXTYPE3_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP3CR1_RXTYPE3_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP3CR1_RXTYPE3_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP3CR1_RXTYPE3_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP3CR1_RXTYPE3_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP3CR1_RXTYPE3_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP3CR1_EPADR3_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP3CR1_EPADR3_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP3CR1_EPADR3_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP3CR1_EPADR3_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP3CR1_EPADR3_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP3CR1_EPADR3_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP3RX  [register's definitions]
 *              Offset[0x78]  USB end-point 3 receive register (0x54000078)
 ******************************************************************************
 */
///@{
#define USB_EP3RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP3RX */
#define USB_EP3RX_RXCNT3_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP3RX_RXCNT3_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP3RX_RXADR3_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP3RX_RXADR3_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP3TX  [register's definitions]
 *              Offset[0x7C]  USB end-point 3 transmit register (0x5400007C)
 ******************************************************************************
 */
///@{
#define USB_EP3TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP3TX */
#define USB_EP3TX_TXCNT3_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP3TX_TXCNT3_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP3TX_TXADR3_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP3TX_TXADR3_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP4CR0  [register's definitions]
 *              Offset[0x80]  USB end-point 4 control register 0 (0x54000080)
 ******************************************************************************
 */
///@{
#define USB_EP4CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP4CR0 */
#define USB_EP4CR0_ISOTXE4F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_ISOTXE4F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_ISOTXE4F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_ISOTXE4F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_ISOTXE4F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_ISOTXE4F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_ISOTXE4F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_ISOTXE4F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_ISOTXE4F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_TXSTL4F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXSTL4F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXSTL4F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXSTL4F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_TXSTL4F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_TXSTL4F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_TXSTL4F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_TXSTL4F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_TXSTL4F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_TXNAK4F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXNAK4F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXNAK4F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXNAK4F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_TXNAK4F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_TXNAK4F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_TXNAK4F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_TXNAK4F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_TXNAK4F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_TXD4F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXD4F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXD4F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXD4F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_TXD4F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_TXD4F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_TXD4F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_TXD4F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_TXD4F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_ISOOVW4F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_ISOOVW4F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_ISOOVW4F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_ISOOVW4F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_ISOOVW4F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_ISOOVW4F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_ISOOVW4F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_ISOOVW4F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_ISOOVW4F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_RXSTL4F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXSTL4F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXSTL4F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXSTL4F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_RXSTL4F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_RXSTL4F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_RXSTL4F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_RXSTL4F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_RXSTL4F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_RXNAK4F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXNAK4F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXNAK4F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXNAK4F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_RXNAK4F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_RXNAK4F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_RXNAK4F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_RXNAK4F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_RXNAK4F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_RXD4F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXD4F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXD4F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXD4F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP4CR0_RXD4F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP4CR0_RXD4F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP4CR0_RXD4F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP4CR0_RXD4F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP4CR0_RXD4F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP4CR0_TXRST4_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXRST4_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXRST4_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXRST4_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP4CR0_TXRST4_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP4CR0_TXRST4_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP4CR0_TXRST4_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_TXRST4_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_TXRST4_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_RXRST4_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXRST4_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXRST4_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXRST4_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP4CR0_RXRST4_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP4CR0_RXRST4_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP4CR0_RXRST4_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_RXRST4_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_RXRST4_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_TXSTL4_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXSTL4_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXSTL4_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXSTL4_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR0_TXSTL4_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR0_TXSTL4_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR0_TXSTL4_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_TXSTL4_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_TXSTL4_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_TXNAK4_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXNAK4_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXNAK4_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXNAK4_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR0_TXNAK4_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR0_TXNAK4_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR0_TXNAK4_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_TXNAK4_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_TXNAK4_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_TXD4_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_TXD4_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_TXD4_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_TXD4_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR0_TXD4_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR0_TXD4_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR0_TXD4_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_TXD4_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_TXD4_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_RXSTL4_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXSTL4_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXSTL4_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXSTL4_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR0_RXSTL4_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR0_RXSTL4_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR0_RXSTL4_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_RXSTL4_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_RXSTL4_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_RXNAK4_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXNAK4_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXNAK4_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXNAK4_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR0_RXNAK4_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR0_RXNAK4_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR0_RXNAK4_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_RXNAK4_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_RXNAK4_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR0_RXD4_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP4CR0_RXD4_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP4CR0_RXD4_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP4CR0_RXD4_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR0_RXD4_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR0_RXD4_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR0_RXD4_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR0_RXD4_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR0_RXD4_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP4CR1  [register's definitions]
 *              Offset[0x84]  USB end-point 4 control register 1 (0x54000084)
 ******************************************************************************
 */
///@{
#define USB_EP4CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP4CR1 */
#define USB_EP4CR1_TXS_LCK4_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXS_LCK4_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXS_LCK4_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_TXS_LCK4_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP4CR1_TXS_LCK4_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP4CR1_TXS_LCK4_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP4CR1_TXS_LCK4_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP4CR1_TXS_LCK4_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP4CR1_TXS_LCK4_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP4CR1_TXSEQ4_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXSEQ4_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXSEQ4_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP4CR1_TXSA_LCK4_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXSA_LCK4_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXSA_LCK4_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_TXSA_LCK4_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP4CR1_TXSA_LCK4_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP4CR1_TXSA_LCK4_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP4CR1_TXSA_LCK4_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP4CR1_TXSA_LCK4_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP4CR1_TXSA_LCK4_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP4CR1_TXMC4_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXMC4_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXMC4_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_TXMC4_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP4CR1_TXMC4_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP4CR1_TXMC4_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP4CR1_TXMC4_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP4CR1_TXMC4_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP4CR1_TXMC4_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP4CR1_TXSTL4_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXSTL4_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXSTL4_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_TXSTL4_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR1_TXSTL4_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR1_TXSTL4_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR1_TXSTL4_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR1_TXSTL4_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR1_TXSTL4_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR1_TXEN4_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXEN4_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXEN4_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_TXEN4_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR1_TXEN4_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR1_TXEN4_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR1_TXEN4_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR1_TXEN4_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR1_TXEN4_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR1_RXS_LCK4_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXS_LCK4_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXS_LCK4_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_RXS_LCK4_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP4CR1_RXS_LCK4_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP4CR1_RXS_LCK4_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP4CR1_RXS_LCK4_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP4CR1_RXS_LCK4_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP4CR1_RXS_LCK4_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP4CR1_RXSEQ4_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXSEQ4_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXSEQ4_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP4CR1_RXSA_LCK4_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXSA_LCK4_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXSA_LCK4_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_RXSA_LCK4_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP4CR1_RXSA_LCK4_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP4CR1_RXSA_LCK4_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP4CR1_RXSA_LCK4_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP4CR1_RXSA_LCK4_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP4CR1_RXSA_LCK4_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP4CR1_RXMC4_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXMC4_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXMC4_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_RXMC4_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP4CR1_RXMC4_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP4CR1_RXMC4_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP4CR1_RXMC4_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP4CR1_RXMC4_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP4CR1_RXMC4_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP4CR1_RXSTL4_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXSTL4_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXSTL4_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_RXSTL4_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR1_RXSTL4_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR1_RXSTL4_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR1_RXSTL4_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR1_RXSTL4_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR1_RXSTL4_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR1_RXEN4_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXEN4_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXEN4_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_RXEN4_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR1_RXEN4_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR1_RXEN4_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR1_RXEN4_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR1_RXEN4_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR1_RXEN4_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR1_DBM4_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_DBM4_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_DBM4_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_DBM4_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP4CR1_DBM4_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP4CR1_DBM4_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP4CR1_DBM4_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP4CR1_DBM4_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP4CR1_DBM4_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP4CR1_BLSIZE4_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_BLSIZE4_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_BLSIZE4_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_BLSIZE4_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP4CR1_BLSIZE4_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP4CR1_BLSIZE4_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP4CR1_BLSIZE4_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP4CR1_BLSIZE4_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP4CR1_BLSIZE4_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP4CR1_BLNUM4_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_BLNUM4_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_BLNUM4_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP4CR1_TXTYPE4_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_TXTYPE4_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_TXTYPE4_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_TXTYPE4_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP4CR1_TXTYPE4_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP4CR1_TXTYPE4_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP4CR1_TXTYPE4_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP4CR1_TXTYPE4_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP4CR1_TXTYPE4_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP4CR1_RXTYPE4_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_RXTYPE4_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_RXTYPE4_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_RXTYPE4_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP4CR1_RXTYPE4_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP4CR1_RXTYPE4_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP4CR1_RXTYPE4_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP4CR1_RXTYPE4_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP4CR1_RXTYPE4_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP4CR1_EPADR4_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP4CR1_EPADR4_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP4CR1_EPADR4_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP4CR1_EPADR4_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP4CR1_EPADR4_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP4CR1_EPADR4_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP4RX  [register's definitions]
 *              Offset[0x88]  USB end-point 4 receive register (0x54000088)
 ******************************************************************************
 */
///@{
#define USB_EP4RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP4RX */
#define USB_EP4RX_RXCNT4_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP4RX_RXCNT4_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP4RX_RXADR4_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP4RX_RXADR4_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP4TX  [register's definitions]
 *              Offset[0x8C]  USB end-point 4 transmit register (0x5400008C)
 ******************************************************************************
 */
///@{
#define USB_EP4TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP4TX */
#define USB_EP4TX_TXCNT4_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP4TX_TXCNT4_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP4TX_TXADR4_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP4TX_TXADR4_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP5CR0  [register's definitions]
 *              Offset[0x90]  USB end-point 5 control register 0 (0x54000090)
 ******************************************************************************
 */
///@{
#define USB_EP5CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP5CR0 */
#define USB_EP5CR0_ISOTXE5F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_ISOTXE5F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_ISOTXE5F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_ISOTXE5F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_ISOTXE5F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_ISOTXE5F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_ISOTXE5F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_ISOTXE5F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_ISOTXE5F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_TXSTL5F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXSTL5F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXSTL5F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXSTL5F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_TXSTL5F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_TXSTL5F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_TXSTL5F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_TXSTL5F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_TXSTL5F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_TXNAK5F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXNAK5F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXNAK5F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXNAK5F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_TXNAK5F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_TXNAK5F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_TXNAK5F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_TXNAK5F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_TXNAK5F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_TXD5F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXD5F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXD5F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXD5F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_TXD5F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_TXD5F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_TXD5F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_TXD5F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_TXD5F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_ISOOVW5F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_ISOOVW5F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_ISOOVW5F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_ISOOVW5F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_ISOOVW5F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_ISOOVW5F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_ISOOVW5F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_ISOOVW5F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_ISOOVW5F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_RXSTL5F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXSTL5F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXSTL5F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXSTL5F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_RXSTL5F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_RXSTL5F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_RXSTL5F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_RXSTL5F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_RXSTL5F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_RXNAK5F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXNAK5F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXNAK5F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXNAK5F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_RXNAK5F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_RXNAK5F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_RXNAK5F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_RXNAK5F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_RXNAK5F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_RXD5F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXD5F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXD5F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXD5F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP5CR0_RXD5F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP5CR0_RXD5F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP5CR0_RXD5F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP5CR0_RXD5F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP5CR0_RXD5F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP5CR0_TXRST5_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXRST5_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXRST5_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXRST5_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP5CR0_TXRST5_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP5CR0_TXRST5_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP5CR0_TXRST5_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_TXRST5_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_TXRST5_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_RXRST5_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXRST5_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXRST5_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXRST5_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP5CR0_RXRST5_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP5CR0_RXRST5_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP5CR0_RXRST5_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_RXRST5_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_RXRST5_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_TXSTL5_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXSTL5_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXSTL5_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXSTL5_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR0_TXSTL5_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR0_TXSTL5_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR0_TXSTL5_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_TXSTL5_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_TXSTL5_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_TXNAK5_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXNAK5_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXNAK5_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXNAK5_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR0_TXNAK5_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR0_TXNAK5_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR0_TXNAK5_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_TXNAK5_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_TXNAK5_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_TXD5_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_TXD5_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_TXD5_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_TXD5_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR0_TXD5_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR0_TXD5_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR0_TXD5_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_TXD5_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_TXD5_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_RXSTL5_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXSTL5_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXSTL5_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXSTL5_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR0_RXSTL5_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR0_RXSTL5_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR0_RXSTL5_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_RXSTL5_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_RXSTL5_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_RXNAK5_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXNAK5_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXNAK5_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXNAK5_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR0_RXNAK5_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR0_RXNAK5_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR0_RXNAK5_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_RXNAK5_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_RXNAK5_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR0_RXD5_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP5CR0_RXD5_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP5CR0_RXD5_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP5CR0_RXD5_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR0_RXD5_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR0_RXD5_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR0_RXD5_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR0_RXD5_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR0_RXD5_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP5CR1  [register's definitions]
 *              Offset[0x94]  USB end-point 5 control register 1 (0x54000094)
 ******************************************************************************
 */
///@{
#define USB_EP5CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP5CR1 */
#define USB_EP5CR1_TXS_LCK5_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXS_LCK5_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXS_LCK5_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_TXS_LCK5_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP5CR1_TXS_LCK5_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP5CR1_TXS_LCK5_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP5CR1_TXS_LCK5_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP5CR1_TXS_LCK5_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP5CR1_TXS_LCK5_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP5CR1_TXSEQ5_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXSEQ5_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXSEQ5_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP5CR1_TXSA_LCK5_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXSA_LCK5_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXSA_LCK5_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_TXSA_LCK5_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP5CR1_TXSA_LCK5_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP5CR1_TXSA_LCK5_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP5CR1_TXSA_LCK5_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP5CR1_TXSA_LCK5_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP5CR1_TXSA_LCK5_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP5CR1_TXMC5_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXMC5_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXMC5_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_TXMC5_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP5CR1_TXMC5_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP5CR1_TXMC5_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP5CR1_TXMC5_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP5CR1_TXMC5_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP5CR1_TXMC5_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP5CR1_TXSTL5_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXSTL5_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXSTL5_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_TXSTL5_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR1_TXSTL5_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR1_TXSTL5_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR1_TXSTL5_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR1_TXSTL5_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR1_TXSTL5_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR1_TXEN5_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXEN5_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXEN5_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_TXEN5_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR1_TXEN5_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR1_TXEN5_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR1_TXEN5_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR1_TXEN5_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR1_TXEN5_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR1_RXS_LCK5_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXS_LCK5_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXS_LCK5_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_RXS_LCK5_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP5CR1_RXS_LCK5_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP5CR1_RXS_LCK5_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP5CR1_RXS_LCK5_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP5CR1_RXS_LCK5_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP5CR1_RXS_LCK5_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP5CR1_RXSEQ5_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXSEQ5_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXSEQ5_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP5CR1_RXSA_LCK5_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXSA_LCK5_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXSA_LCK5_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_RXSA_LCK5_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP5CR1_RXSA_LCK5_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP5CR1_RXSA_LCK5_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP5CR1_RXSA_LCK5_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP5CR1_RXSA_LCK5_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP5CR1_RXSA_LCK5_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP5CR1_RXMC5_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXMC5_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXMC5_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_RXMC5_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP5CR1_RXMC5_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP5CR1_RXMC5_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP5CR1_RXMC5_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP5CR1_RXMC5_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP5CR1_RXMC5_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP5CR1_RXSTL5_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXSTL5_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXSTL5_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_RXSTL5_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR1_RXSTL5_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR1_RXSTL5_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR1_RXSTL5_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR1_RXSTL5_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR1_RXSTL5_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR1_RXEN5_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXEN5_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXEN5_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_RXEN5_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR1_RXEN5_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR1_RXEN5_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR1_RXEN5_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR1_RXEN5_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR1_RXEN5_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR1_DBM5_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_DBM5_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_DBM5_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_DBM5_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP5CR1_DBM5_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP5CR1_DBM5_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP5CR1_DBM5_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP5CR1_DBM5_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP5CR1_DBM5_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP5CR1_BLSIZE5_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_BLSIZE5_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_BLSIZE5_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_BLSIZE5_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP5CR1_BLSIZE5_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP5CR1_BLSIZE5_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP5CR1_BLSIZE5_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP5CR1_BLSIZE5_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP5CR1_BLSIZE5_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP5CR1_BLNUM5_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_BLNUM5_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_BLNUM5_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP5CR1_TXTYPE5_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_TXTYPE5_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_TXTYPE5_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_TXTYPE5_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP5CR1_TXTYPE5_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP5CR1_TXTYPE5_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP5CR1_TXTYPE5_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP5CR1_TXTYPE5_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP5CR1_TXTYPE5_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP5CR1_RXTYPE5_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_RXTYPE5_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_RXTYPE5_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_RXTYPE5_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP5CR1_RXTYPE5_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP5CR1_RXTYPE5_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP5CR1_RXTYPE5_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP5CR1_RXTYPE5_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP5CR1_RXTYPE5_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP5CR1_EPADR5_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP5CR1_EPADR5_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP5CR1_EPADR5_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP5CR1_EPADR5_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP5CR1_EPADR5_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP5CR1_EPADR5_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP5RX  [register's definitions]
 *              Offset[0x98]  USB end-point 5 receive register (0x54000098)
 ******************************************************************************
 */
///@{
#define USB_EP5RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP5RX */
#define USB_EP5RX_RXCNT5_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP5RX_RXCNT5_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP5RX_RXADR5_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP5RX_RXADR5_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP5TX  [register's definitions]
 *              Offset[0x9C]  USB end-point 5 transmit register (0x5400009C)
 ******************************************************************************
 */
///@{
#define USB_EP5TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP5TX */
#define USB_EP5TX_TXCNT5_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP5TX_TXCNT5_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP5TX_TXADR5_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP5TX_TXADR5_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP6CR0  [register's definitions]
 *              Offset[0xA0]  USB end-point 6 control register 0 (0x540000A0)
 ******************************************************************************
 */
///@{
#define USB_EP6CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP6CR0 */
#define USB_EP6CR0_ISOTXE6F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_ISOTXE6F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_ISOTXE6F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_ISOTXE6F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_ISOTXE6F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_ISOTXE6F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_ISOTXE6F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_ISOTXE6F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_ISOTXE6F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_TXSTL6F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXSTL6F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXSTL6F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXSTL6F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_TXSTL6F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_TXSTL6F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_TXSTL6F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_TXSTL6F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_TXSTL6F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_TXNAK6F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXNAK6F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXNAK6F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXNAK6F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_TXNAK6F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_TXNAK6F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_TXNAK6F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_TXNAK6F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_TXNAK6F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_TXD6F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXD6F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXD6F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXD6F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_TXD6F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_TXD6F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_TXD6F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_TXD6F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_TXD6F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_ISOOVW6F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_ISOOVW6F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_ISOOVW6F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_ISOOVW6F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_ISOOVW6F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_ISOOVW6F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_ISOOVW6F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_ISOOVW6F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_ISOOVW6F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_RXSTL6F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXSTL6F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXSTL6F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXSTL6F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_RXSTL6F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_RXSTL6F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_RXSTL6F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_RXSTL6F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_RXSTL6F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_RXNAK6F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXNAK6F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXNAK6F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXNAK6F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_RXNAK6F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_RXNAK6F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_RXNAK6F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_RXNAK6F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_RXNAK6F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_RXD6F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXD6F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXD6F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXD6F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP6CR0_RXD6F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP6CR0_RXD6F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP6CR0_RXD6F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP6CR0_RXD6F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP6CR0_RXD6F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP6CR0_TXRST6_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXRST6_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXRST6_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXRST6_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP6CR0_TXRST6_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP6CR0_TXRST6_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP6CR0_TXRST6_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_TXRST6_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_TXRST6_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_RXRST6_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXRST6_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXRST6_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXRST6_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP6CR0_RXRST6_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP6CR0_RXRST6_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP6CR0_RXRST6_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_RXRST6_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_RXRST6_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_TXSTL6_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXSTL6_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXSTL6_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXSTL6_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR0_TXSTL6_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR0_TXSTL6_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR0_TXSTL6_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_TXSTL6_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_TXSTL6_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_TXNAK6_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXNAK6_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXNAK6_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXNAK6_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR0_TXNAK6_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR0_TXNAK6_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR0_TXNAK6_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_TXNAK6_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_TXNAK6_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_TXD6_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_TXD6_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_TXD6_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_TXD6_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR0_TXD6_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR0_TXD6_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR0_TXD6_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_TXD6_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_TXD6_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_RXSTL6_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXSTL6_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXSTL6_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXSTL6_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR0_RXSTL6_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR0_RXSTL6_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR0_RXSTL6_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_RXSTL6_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_RXSTL6_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_RXNAK6_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXNAK6_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXNAK6_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXNAK6_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR0_RXNAK6_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR0_RXNAK6_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR0_RXNAK6_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_RXNAK6_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_RXNAK6_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR0_RXD6_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP6CR0_RXD6_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP6CR0_RXD6_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP6CR0_RXD6_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR0_RXD6_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR0_RXD6_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR0_RXD6_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR0_RXD6_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR0_RXD6_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP6CR1  [register's definitions]
 *              Offset[0xA4]  USB end-point 6 control register 1 (0x540000A4)
 ******************************************************************************
 */
///@{
#define USB_EP6CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP6CR1 */
#define USB_EP6CR1_TXS_LCK6_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXS_LCK6_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXS_LCK6_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_TXS_LCK6_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP6CR1_TXS_LCK6_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP6CR1_TXS_LCK6_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP6CR1_TXS_LCK6_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP6CR1_TXS_LCK6_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP6CR1_TXS_LCK6_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP6CR1_TXSEQ6_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXSEQ6_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXSEQ6_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP6CR1_TXSA_LCK6_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXSA_LCK6_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXSA_LCK6_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_TXSA_LCK6_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP6CR1_TXSA_LCK6_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP6CR1_TXSA_LCK6_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP6CR1_TXSA_LCK6_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP6CR1_TXSA_LCK6_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP6CR1_TXSA_LCK6_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP6CR1_TXMC6_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXMC6_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXMC6_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_TXMC6_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP6CR1_TXMC6_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP6CR1_TXMC6_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP6CR1_TXMC6_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP6CR1_TXMC6_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP6CR1_TXMC6_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP6CR1_TXSTL6_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXSTL6_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXSTL6_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_TXSTL6_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR1_TXSTL6_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR1_TXSTL6_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR1_TXSTL6_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR1_TXSTL6_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR1_TXSTL6_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR1_TXEN6_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXEN6_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXEN6_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_TXEN6_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR1_TXEN6_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR1_TXEN6_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR1_TXEN6_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR1_TXEN6_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR1_TXEN6_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR1_RXS_LCK6_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXS_LCK6_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXS_LCK6_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_RXS_LCK6_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP6CR1_RXS_LCK6_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP6CR1_RXS_LCK6_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP6CR1_RXS_LCK6_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP6CR1_RXS_LCK6_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP6CR1_RXS_LCK6_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP6CR1_RXSEQ6_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXSEQ6_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXSEQ6_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP6CR1_RXSA_LCK6_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXSA_LCK6_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXSA_LCK6_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_RXSA_LCK6_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP6CR1_RXSA_LCK6_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP6CR1_RXSA_LCK6_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP6CR1_RXSA_LCK6_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP6CR1_RXSA_LCK6_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP6CR1_RXSA_LCK6_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP6CR1_RXMC6_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXMC6_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXMC6_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_RXMC6_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP6CR1_RXMC6_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP6CR1_RXMC6_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP6CR1_RXMC6_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP6CR1_RXMC6_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP6CR1_RXMC6_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP6CR1_RXSTL6_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXSTL6_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXSTL6_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_RXSTL6_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR1_RXSTL6_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR1_RXSTL6_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR1_RXSTL6_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR1_RXSTL6_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR1_RXSTL6_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR1_RXEN6_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXEN6_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXEN6_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_RXEN6_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR1_RXEN6_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR1_RXEN6_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR1_RXEN6_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR1_RXEN6_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR1_RXEN6_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR1_DBM6_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_DBM6_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_DBM6_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_DBM6_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP6CR1_DBM6_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP6CR1_DBM6_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP6CR1_DBM6_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP6CR1_DBM6_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP6CR1_DBM6_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP6CR1_BLSIZE6_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_BLSIZE6_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_BLSIZE6_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_BLSIZE6_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP6CR1_BLSIZE6_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP6CR1_BLSIZE6_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP6CR1_BLSIZE6_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP6CR1_BLSIZE6_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP6CR1_BLSIZE6_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP6CR1_BLNUM6_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_BLNUM6_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_BLNUM6_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP6CR1_TXTYPE6_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_TXTYPE6_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_TXTYPE6_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_TXTYPE6_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP6CR1_TXTYPE6_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP6CR1_TXTYPE6_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP6CR1_TXTYPE6_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP6CR1_TXTYPE6_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP6CR1_TXTYPE6_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP6CR1_RXTYPE6_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_RXTYPE6_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_RXTYPE6_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_RXTYPE6_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP6CR1_RXTYPE6_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP6CR1_RXTYPE6_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP6CR1_RXTYPE6_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP6CR1_RXTYPE6_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP6CR1_RXTYPE6_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP6CR1_EPADR6_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP6CR1_EPADR6_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP6CR1_EPADR6_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP6CR1_EPADR6_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP6CR1_EPADR6_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP6CR1_EPADR6_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP6RX  [register's definitions]
 *              Offset[0xA8]  USB end-point 6 receive register (0x540000A8)
 ******************************************************************************
 */
///@{
#define USB_EP6RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP6RX */
#define USB_EP6RX_RXCNT6_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP6RX_RXCNT6_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP6RX_RXADR6_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP6RX_RXADR6_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP6TX  [register's definitions]
 *              Offset[0xAC]  USB end-point 6 transmit register (0x540000AC)
 ******************************************************************************
 */
///@{
#define USB_EP6TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP6TX */
#define USB_EP6TX_TXCNT6_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP6TX_TXCNT6_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP6TX_TXADR6_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP6TX_TXADR6_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP7CR0  [register's definitions]
 *              Offset[0xB0]  USB end-point 7 control register 0 (0x540000B0)
 ******************************************************************************
 */
///@{
#define USB_EP7CR0_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP7CR0 */
#define USB_EP7CR0_ISOTXE7F_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_ISOTXE7F_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_ISOTXE7F_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_ISOTXE7F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_ISOTXE7F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_ISOTXE7F_normal_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_ISOTXE7F_happened_w              ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_ISOTXE7F_happened_h1             ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_ISOTXE7F_happened_b3             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_TXSTL7F_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXSTL7F_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXSTL7F_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXSTL7F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_TXSTL7F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_TXSTL7F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_TXSTL7F_happened_w               ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_TXSTL7F_happened_h1              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_TXSTL7F_happened_b3              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_TXNAK7F_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXNAK7F_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXNAK7F_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXNAK7F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_TXNAK7F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_TXNAK7F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_TXNAK7F_happened_w               ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_TXNAK7F_happened_h1              ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_TXNAK7F_happened_b3              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_TXD7F_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXD7F_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXD7F_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXD7F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_TXD7F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_TXD7F_normal_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_TXD7F_happened_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_TXD7F_happened_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_TXD7F_happened_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_ISOOVW7F_mask_w                  ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_ISOOVW7F_mask_h1                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_ISOOVW7F_mask_b2                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_ISOOVW7F_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_ISOOVW7F_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_ISOOVW7F_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_ISOOVW7F_happened_w              ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_ISOOVW7F_happened_h1             ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_ISOOVW7F_happened_b2             ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_RXSTL7F_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXSTL7F_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXSTL7F_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXSTL7F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_RXSTL7F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_RXSTL7F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_RXSTL7F_happened_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_RXSTL7F_happened_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_RXSTL7F_happened_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_RXNAK7F_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXNAK7F_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXNAK7F_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXNAK7F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_RXNAK7F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_RXNAK7F_normal_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_RXNAK7F_happened_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_RXNAK7F_happened_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_RXNAK7F_happened_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_RXD7F_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXD7F_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXD7F_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXD7F_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define USB_EP7CR0_RXD7F_normal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define USB_EP7CR0_RXD7F_normal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define USB_EP7CR0_RXD7F_happened_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define USB_EP7CR0_RXD7F_happened_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define USB_EP7CR0_RXD7F_happened_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define USB_EP7CR0_TXRST7_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXRST7_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXRST7_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXRST7_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP7CR0_TXRST7_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP7CR0_TXRST7_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP7CR0_TXRST7_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_TXRST7_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_TXRST7_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_RXRST7_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXRST7_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXRST7_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXRST7_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP7CR0_RXRST7_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP7CR0_RXRST7_no_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP7CR0_RXRST7_enable_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_RXRST7_enable_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_RXRST7_enable_b1                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_TXSTL7_IE_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXSTL7_IE_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXSTL7_IE_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXSTL7_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR0_TXSTL7_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR0_TXSTL7_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR0_TXSTL7_IE_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_TXSTL7_IE_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_TXSTL7_IE_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_TXNAK7_IE_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXNAK7_IE_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXNAK7_IE_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXNAK7_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR0_TXNAK7_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR0_TXNAK7_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR0_TXNAK7_IE_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_TXNAK7_IE_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_TXNAK7_IE_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_TXD7_IE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_TXD7_IE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_TXD7_IE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_TXD7_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR0_TXD7_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR0_TXD7_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR0_TXD7_IE_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_TXD7_IE_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_TXD7_IE_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_RXSTL7_IE_mask_w                 ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXSTL7_IE_mask_h0                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXSTL7_IE_mask_b0                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXSTL7_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR0_RXSTL7_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR0_RXSTL7_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR0_RXSTL7_IE_enable_w               ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_RXSTL7_IE_enable_h0              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_RXSTL7_IE_enable_b0              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_RXNAK7_IE_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXNAK7_IE_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXNAK7_IE_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXNAK7_IE_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR0_RXNAK7_IE_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR0_RXNAK7_IE_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR0_RXNAK7_IE_enable_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_RXNAK7_IE_enable_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_RXNAK7_IE_enable_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR0_RXD7_IE_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define USB_EP7CR0_RXD7_IE_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP7CR0_RXD7_IE_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP7CR0_RXD7_IE_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR0_RXD7_IE_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR0_RXD7_IE_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR0_RXD7_IE_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR0_RXD7_IE_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR0_RXD7_IE_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP7CR1  [register's definitions]
 *              Offset[0xB4]  USB end-point 7 control register 1 (0x540000B4)
 ******************************************************************************
 */
///@{
#define USB_EP7CR1_default                          ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP7CR1 */
#define USB_EP7CR1_TXS_LCK7_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXS_LCK7_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXS_LCK7_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_TXS_LCK7_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP7CR1_TXS_LCK7_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP7CR1_TXS_LCK7_locked_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP7CR1_TXS_LCK7_un_locked_w             ((uint32_t)0x20000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP7CR1_TXS_LCK7_un_locked_h1            ((uint16_t)0x2000)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP7CR1_TXS_LCK7_un_locked_b3            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP7CR1_TXSEQ7_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXSEQ7_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXSEQ7_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP7CR1_TXSA_LCK7_mask_w                 ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXSA_LCK7_mask_h1                ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXSA_LCK7_mask_b3                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_TXSA_LCK7_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP7CR1_TXSA_LCK7_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP7CR1_TXSA_LCK7_locked_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP7CR1_TXSA_LCK7_un_locked_w            ((uint32_t)0x08000000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP7CR1_TXSA_LCK7_un_locked_h1           ((uint16_t)0x0800)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP7CR1_TXSA_LCK7_un_locked_b3           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP7CR1_TXMC7_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXMC7_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXMC7_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_TXMC7_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP7CR1_TXMC7_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP7CR1_TXMC7_no_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP7CR1_TXMC7_complete_w                 ((uint32_t)0x04000000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP7CR1_TXMC7_complete_h1                ((uint16_t)0x0400)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP7CR1_TXMC7_complete_b3                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP7CR1_TXSTL7_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXSTL7_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXSTL7_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_TXSTL7_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR1_TXSTL7_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR1_TXSTL7_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR1_TXSTL7_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR1_TXSTL7_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR1_TXSTL7_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR1_TXEN7_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXEN7_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXEN7_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_TXEN7_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR1_TXEN7_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR1_TXEN7_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR1_TXEN7_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR1_TXEN7_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR1_TXEN7_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR1_RXS_LCK7_mask_w                  ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXS_LCK7_mask_h1                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXS_LCK7_mask_b2                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_RXS_LCK7_locked_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP7CR1_RXS_LCK7_locked_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP7CR1_RXS_LCK7_locked_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP7CR1_RXS_LCK7_un_locked_w             ((uint32_t)0x00200000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP7CR1_RXS_LCK7_un_locked_h1            ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP7CR1_RXS_LCK7_un_locked_b2            ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP7CR1_RXSEQ7_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXSEQ7_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXSEQ7_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define USB_EP7CR1_RXSA_LCK7_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXSA_LCK7_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXSA_LCK7_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_RXSA_LCK7_locked_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define USB_EP7CR1_RXSA_LCK7_locked_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define USB_EP7CR1_RXSA_LCK7_locked_b2              ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define USB_EP7CR1_RXSA_LCK7_un_locked_w            ((uint32_t)0x00080000)  /*!< Bit Value =(1):un-Locked of 32bit */
#define USB_EP7CR1_RXSA_LCK7_un_locked_h1           ((uint16_t)0x0008)      /*!< Bit Value =(1):un-Locked of 16bit */
#define USB_EP7CR1_RXSA_LCK7_un_locked_b2           ((uint8_t )0x08)        /*!< Bit Value =(1):un-Locked of 8bit */

#define USB_EP7CR1_RXMC7_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXMC7_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXMC7_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_RXMC7_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define USB_EP7CR1_RXMC7_no_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define USB_EP7CR1_RXMC7_no_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define USB_EP7CR1_RXMC7_complete_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Complete of 32bit */
#define USB_EP7CR1_RXMC7_complete_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Complete of 16bit */
#define USB_EP7CR1_RXMC7_complete_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Complete of 8bit */

#define USB_EP7CR1_RXSTL7_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXSTL7_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXSTL7_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_RXSTL7_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR1_RXSTL7_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR1_RXSTL7_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR1_RXSTL7_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR1_RXSTL7_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR1_RXSTL7_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR1_RXEN7_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXEN7_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXEN7_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_RXEN7_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR1_RXEN7_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR1_RXEN7_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR1_RXEN7_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR1_RXEN7_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR1_RXEN7_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR1_DBM7_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_DBM7_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_DBM7_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_DBM7_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define USB_EP7CR1_DBM7_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define USB_EP7CR1_DBM7_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define USB_EP7CR1_DBM7_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define USB_EP7CR1_DBM7_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define USB_EP7CR1_DBM7_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define USB_EP7CR1_BLSIZE7_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_BLSIZE7_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_BLSIZE7_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_BLSIZE7_2byte_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):2Byte of 32bit */
#define USB_EP7CR1_BLSIZE7_2byte_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):2Byte of 16bit */
#define USB_EP7CR1_BLSIZE7_2byte_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):2Byte of 8bit */
#define USB_EP7CR1_BLSIZE7_32byte_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(1):32Byte of 32bit */
#define USB_EP7CR1_BLSIZE7_32byte_h0                ((uint16_t)0x2000)      /*!< Bit Value =(1):32Byte of 16bit */
#define USB_EP7CR1_BLSIZE7_32byte_b1                ((uint8_t )0x20)        /*!< Bit Value =(1):32Byte of 8bit */

#define USB_EP7CR1_BLNUM7_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_BLNUM7_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_BLNUM7_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define USB_EP7CR1_TXTYPE7_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_TXTYPE7_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_TXTYPE7_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_TXTYPE7_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP7CR1_TXTYPE7_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP7CR1_TXTYPE7_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP7CR1_TXTYPE7_iso_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP7CR1_TXTYPE7_iso_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP7CR1_TXTYPE7_iso_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP7CR1_RXTYPE7_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_RXTYPE7_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_RXTYPE7_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_RXTYPE7_bkint_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):BKINT of 32bit */
#define USB_EP7CR1_RXTYPE7_bkint_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):BKINT of 16bit */
#define USB_EP7CR1_RXTYPE7_bkint_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):BKINT of 8bit */
#define USB_EP7CR1_RXTYPE7_iso_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):ISO of 32bit */
#define USB_EP7CR1_RXTYPE7_iso_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):ISO of 16bit */
#define USB_EP7CR1_RXTYPE7_iso_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):ISO of 8bit */

#define USB_EP7CR1_EPADR7_mask_w                    ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define USB_EP7CR1_EPADR7_mask_h0                   ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define USB_EP7CR1_EPADR7_mask_b0                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define USB_EP7CR1_EPADR7_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define USB_EP7CR1_EPADR7_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define USB_EP7CR1_EPADR7_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP7RX  [register's definitions]
 *              Offset[0xB8]  USB end-point 7 receive register (0x540000B8)
 ******************************************************************************
 */
///@{
#define USB_EP7RX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP7RX */
#define USB_EP7RX_RXCNT7_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP7RX_RXCNT7_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP7RX_RXADR7_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP7RX_RXADR7_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        USB_EP7TX  [register's definitions]
 *              Offset[0xBC]  USB end-point 7 transmit register (0x540000BC)
 ******************************************************************************
 */
///@{
#define USB_EP7TX_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of USB_EP7TX */
#define USB_EP7TX_TXCNT7_mask_w                     ((uint32_t)0x01FF0000)  /*!< Bit Mask of 32bit */
#define USB_EP7TX_TXCNT7_mask_h1                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

#define USB_EP7TX_TXADR7_mask_w                     ((uint32_t)0x000001FF)  /*!< Bit Mask of 32bit */
#define USB_EP7TX_TXADR7_mask_h0                    ((uint16_t)0x01FF)      /*!< Bit Mask of 16bit */

///@}

#endif  // _MG32_USB_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_USB.h                           */
/*----------------------------------------------------------------------------*/
