/**
 *******************************************************************************
 *
 * @file        Sample_OPA_Init.c
 *
 * @brief       The OPA initial code C file
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2025/04/09
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_OPA.h"
#include "MG32_OPA_Init.h"
#include "MG32__ExtraStruct.h"

/* Wizard menu ---------------------------------------------------------------*/
// <<< Use Configuration Wizard in Context Menu >>>
//  <h> OPA0 Config
//      <o0.8..9> OPA positive channel selection <0=> VBUF <1=> OPA_I0 (PA4) <2=> PGA_P0
#define Sample_OPA_OPAPMUX 0x00000100
//      <o0.12..13> OPA negative channel selection <0=> VBUF <1=> OPA_I1 (PA5) <2=> OPA_P0 (PA0)
#define Sample_OPA_OPANMUX 0x00002000
//      <q0.2> OPA low power mode
#define Sample_OPA_OPALPEN 0x00000004

//  </h>
// <<< end of Configuration section >>>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void Sample_OPA_Init(void);

/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief  	    Initialized OPA module.
 * @return      None
 *******************************************************************************
 */
void Sample_OPA_Init(void)
{
    // make sure :

    //===Set CSC init====
    // MG32_CSC_Init.h(Configuration Wizard)
    // Select CK_HS source = CK_IHRCO
    // Select IHRCO = 12M
    // Select CK_MAIN Source = CK_HS
    // Configure PLL->Select APB Prescaler = CK_MAIN/1
    // Configure Peripheral On Mode Clock->OPA = Enable
    // Configure Peripheral On Mode Clock->Port A = Enable

    //==Set GPIO init
    //(OPA) OPA_I0/OPA_I1 pin config:
    // MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->Pin4/5/0
    // GPIO port initial is 0xFFFF
    // Pin4, Pin5 and Pin0 mode is AIO

    /* OPA register initial */
    OPA->CR0.W = (Sample_OPA_OPAPMUX | Sample_OPA_OPANMUX | Sample_OPA_OPALPEN | OPA_CR0_OP0_EN_enable_w);
    
    // Equal driver level
//    OPA_PositivePin_Select(OPA_OP0, OPA_P_OP0_I0);
//    OPA_NegativePin_Select(OPA_OP0, OPA_N_OPA_P0);
//    OPA_Power_Select(OPA_OP0, OPA_NormalPower);
//    OPA_Cmd(OPA_OP0, ENABLE);
    
    // Calibre OPA offset.
    OPA_OffsetCalibration_Cmd(OPA_OP0, ENABLE);
    
}

