



/**
 ******************************************************************************
 *
 * @file        Sample_EXIC_TXEV_RXEV_EvenWakeUp.c
 * @brief       The demo CPU wake up event pin initialize and confiuration sample C file
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2024/12/03
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *  
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 

/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_EXIC_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_TXEV_RXEV_WakeUp(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
*******************************************************************************
* @brief	   TXEV & RXEV Event Wake Up
* @details     1.Port A 13 and 14 initial(TXEV and RXEV).
*    \n        2.Send CPU event.
*    \n        3.Into SLEEP mode wait event happened.
* @return      
* @exception   No
* @note        
* @par         Example
* @code
* @endcode             
*******************************************************************************
*/
void Sample_TXEV_RXEV_WakeUp(void)
{
    PIN_InitTypeDef  PINX_InitStruct;
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 11.0592M or 12.0000MHz
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->Port A = Enable if EXIC Port is PortA
    
    
    //====GPIO Initial==== 
    //PINX_InitStruct.PINX_Pin                = PX_Pin_13|PX_Pin_14;            // Select the pin of the port to initialize (PX_Pin_All represents all pins of the port).
    PINX_InitStruct.PINX_Pin                = PX_Pin_13;            // Select the pin of the port to initialize (PX_Pin_All represents all pins of the port).
    //PINX_InitStruct.PINX_Mode               = PINX_Mode_OpenDrain_O;          // Select GPIO mode 
    PINX_InitStruct.PINX_Mode               = PINX_Mode_PushPull_O;          // Select GPIO mode 
                                                                              //     1.QB: Quasi-Bidirection mode only for PC ) 
    //PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;        // Please select whether to enable the internal pull-up resistor or not.
    PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;                 // Select wehter enable high speed mode
                                                                              //     1.(PINX_Speed_High mode only for PC0~3 , PD0~3 )    
    PINX_InitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;           // Select output drive strength 
                                                                              //     1.(Level 0 & level 3 only for PE0~PE3)
    PINX_InitStruct.PINX_FilterDivider      = PINX_FilterDivider_Bypass;      // Select input filter divider.
    PINX_InitStruct.PINX_Inverse            = PINX_Inverse_Disable;           // Select input signal whether inverse or not.
                                                                              //     1.PINX_Inverse_Disable = L level or falling edge.
                                                                              //     2.PINX_Inverse_Enable  = H level or Rising edge.
    PINX_InitStruct.PINX_Alternate_Function = 1;                              // Select GPIO mode
    GPIO_PortMode_Config(IOMA,&PINX_InitStruct);                              // PorA configuration
    
    PINX_InitStruct.PINX_Pin                = PX_Pin_14;            // Select the pin of the port to initialize (PX_Pin_All represents all pins of the port).
    PINX_InitStruct.PINX_Mode               = PINX_Mode_Digital_I;          // Select GPIO mode 
    GPIO_PortMode_Config(IOMA,&PINX_InitStruct);                              // PorA configuration
    GPIO_WritePort(GPIOA,0xFFFF);                                             // Initialize PortA
    
    //====Event Mask Configuration Enable.====
    EXIC_RXEV_Cmd(ENABLE);
    
    //===Send Event====
    //__SEV();                // It causes an event to be signaled to the CPU (PA13 will output a CPU event pulse).
    
    //=====Enter SLEEP Mode Await Event Input====
    SLEEP_WFE();            // To wake up the CPU, an signal should be sent to PA14.
}

