


/**
 ******************************************************************************
 *
 * @file        TH222x_14_EEPROM.c
 * @brief       This is to test TH222x EEPROM C file.
                
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/06/29
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_14_EEPROM.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	 TH222x EEPROM main function. 
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
uint8_t TH222x_EEPROM(void)
{
    uint8_t lArray8[] = {"megawin MG32F02U128 use arm cortex m0"};
    uint8_t lRxBuff[80];
    
    BSP_EEPROM_Init();                                                       /*!<Initial I2C.*/

    BSP_EEPROM_PageWrite(0x00, lArray8, (sizeof(lArray8) - 1));              /*!<Write EEPROM.*/
    BSP_EEPROM_Read(0x00, lRxBuff, (sizeof(lArray8) - 1));                   /*!<Read EEPROM data.*/
    
    if(strncmp((char *)lArray8, (char *)lRxBuff, (sizeof(lArray8) - 1)))
    {
       return(TH222x_FAILURE);
    }
    else
    {
       return(TH222x_SUCCESS);
    }
}









