/**
 ******************************************************************************
 *
 * @file        
 * @brief       
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2024/08/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "Calendar.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define CALENDAR_MONTH_JANUARY     1
#define CALENDAR_MONTH_FEBRUARY    2
#define CALENDAR_MONTH_MARCH       3
#define CALENDAR_MONTH_APRIL       4
#define CALENDAR_MONTH_MAY         5
#define CALENDAR_MONTH_JUNE        6
#define CALENDAR_MONTH_JULY        7
#define CALENDAR_MONTH_AUGUST      8
#define CALENDAR_MONTH_SEPTEMBER   9
#define CALENDAR_MONTH_OCTOBER     10
#define CALENDAR_MONTH_NOVEMBER    11
#define CALENDAR_MONTH_DECEMBER    12

#define CALENDAR_LEAP_YEAR_NO      0
#define CALENDAR_LEAP_YEAR         1

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
Calendar_TypeDef  Calendar_CTR;

static uint8_t Calendar_Data_UpdateFlag;

static const uint8_t Calendar_MonthDays[13] = {31 ,31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/* Private function ----------------------------------------------------------*/
static void Calendar_YMD_Update(void);
static uint8_t Calendar_IsLeapYear(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @param[in]   
 * @exception   
 * @note        
 *******************************************************************************
 */
void Calendar_Init(void)
{
    /*Default time*/
    Calendar_CTR.Year    = 2025;
    Calendar_CTR.Month   = 5;
    Calendar_CTR.Day     = 2;
    Calendar_CTR.Hour    = 12;
    Calendar_CTR.Minute  = 00;
    Calendar_CTR.Second  = 0;
    Calendar_CTR.mSecond = 0;

    /*Control parameter initial*/
    Calendar_Data_UpdateFlag = 0;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @exception   
 * @note        Need 1ms to call the function    
 *******************************************************************************
 */
void Calendar_Handler(void)
{
    if(Calendar_CTR.mSecond == 999)     
    {
        Calendar_CTR.mSecond = 0;
        Calendar_CTR.Second++;

        if( Calendar_CTR.Second == 60)
        {
            Calendar_CTR.Second = 0;
            Calendar_CTR.Minute++;
        }

        if( Calendar_CTR.Minute == 60)
        {
            Calendar_CTR.Minute = 0;
            Calendar_CTR.Hour++;
        }

        if( Calendar_CTR.Hour == 24)
        {
            Calendar_CTR.Hour = 0;
            Calendar_Data_UpdateFlag = 1;
        }

        if( Calendar_Data_UpdateFlag == 1)
        {
            Calendar_Data_UpdateFlag = 0;
            Calendar_YMD_Update();
        }
    }
    else
    {
        Calendar_CTR.mSecond++;
    }
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @exception   
 * @note        
 *******************************************************************************
 */
static void Calendar_YMD_Update(void)
{
    uint8_t MaxDayOfMonth;
    MaxDayOfMonth = Calendar_MonthDays[Calendar_CTR.Month];

    if( Calendar_CTR.Month == CALENDAR_MONTH_FEBRUARY)
    {
        if( Calendar_IsLeapYear()== CALENDAR_LEAP_YEAR)
        {
            MaxDayOfMonth = 29;
        }
    }

    if( Calendar_CTR.Day == MaxDayOfMonth)
    {
        if( Calendar_CTR.Month == CALENDAR_MONTH_DECEMBER)
        {
            Calendar_CTR.Month = CALENDAR_MONTH_JANUARY;
            Calendar_CTR.Year++;
        }
    }
    else
    {
        Calendar_CTR.Day++;
    }
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @exception   
 * @note        
 *******************************************************************************
 */
static uint8_t Calendar_IsLeapYear(void)
{
    if(((Calendar_CTR.Year % 4) == 0) && ((Calendar_CTR.Year % 100) != 0))
    {
        return(CALENDAR_LEAP_YEAR);
    }
    else if(((Calendar_CTR.Year % 400) == 0))
    {
        return(CALENDAR_LEAP_YEAR);
    }

    return(CALENDAR_LEAP_YEAR_NO);
}

