/**
 ******************************************************************************
 *
 * @file        MG32_I2C.h
 *
 * @brief       MG32 I2C Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:38 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_I2C_H
#define _MG32_I2C_H
#define _MG32_I2C_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_I2C_H_VER)
    #error "_MG32_I2C_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      I2C_Struct
 *              I2C  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  BUSYF         :1;     //[0] I2C busy flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Busy (Event happened)
            __IO uint8_t  EVENTF        :1;     //[1] I2C status event interrupt Flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BUFF          :1;     //[2] I2C buffer mode event flag. (set by hardware , clear by software setting 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ERRF          :1;     //[3] I2C error interrupt flag for invalid no ack, bus arbitration lost bus error or data o
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TMOUTF        :1;     //[4] I2C time-out detect flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  WUPF          :1;     //[5] I2C wakeup from STOP mode flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXF           :1;     //[6] I2C Receive data register not empty
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXF           :1;     //[7] I2C Transmit data register empty
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RSTRF         :1;     //[8] I2C repeat start asserted flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  STOPF         :1;     //[9] I2C stop detection flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CNTF          :1;     //[10] I2C buffer count I2C_BUF_CNT empty status
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ERRCF         :1;     //[11] I2C master mode NACK error flag and state control bit
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  SADRF         :1;     //[12] I2C slave mode slave address matched flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  SLAF          :1;     //[13] I2C slave mode detection status.
            __I  uint8_t  MSTF          :1;     //[14] I2C master mode detection status. It set by Start command and clear by Stop state.
            __I  uint8_t  RWF           :1;     //[15] I2C read or write transfer direction status
                                        //0 = Write
                                        //1 = Read
            __IO uint8_t  TSCF          :1;     //[16] I2C shadow buffer transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  STPSTRF       :1;     //[17] I2C Stop or Start detection flag.  (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXRF          :1;     //[18] I2C  transmit data register remained status
                                        //0 = No data
                                        //1 = Remained data
            __IO uint8_t  ROVRF         :1;     //[19] I2C data buffer receive overrun error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TOVRF         :1;     //[20] I2C data buffer transmit underrun error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  NACKF         :1;     //[21] I2C Not Acknowledge received error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ALOSF         :1;     //[22] I2C bus arbitration lost error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BERRF         :1;     //[23] I2C bus error flag for invalid Stop/Start state
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  I2C status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] I2C interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EVENT_IE      :1;     //[1] I2C status event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BUF_IE        :1;     //[2] I2C buffer mode event Interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ERR_IE        :1;     //[3] I2C no ack error, bus arbitration lost, bus error or data overrun interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMOUT_IE      :1;     //[4] I2C timeout error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WUP_IE        :1;     //[5] I2C wakeup from STOP mode interrupt enable on slave address matched.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :6;     //[15..10] 
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  STPSTR_IE     :1;     //[17] I2C Stop or Start detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :5;     //[29..25] 
            __I  uint8_t  SCLF          :1;     //[30] I2C SCL line status bit.
            __I  uint8_t  SDAF          :1;     //[31] I2C SDA line status bit.
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  I2C interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __IO uint8_t  CK_SEL        :2;     //[3..2] I2C internal clock CK_I2C source select.
                                        //0x0 = PROC : CK_I2C_PR process clock from CSC
                                        //0x1 = Reserved
                                        //0x2 = TM00_TRGO
                                        //0x3 = Reserved
            __IO uint8_t  CK_DIV        :3;     //[6..4] I2C internal clock CK_I2C_INT input divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
                                        //0x4 = DIV16 : divided by 16
                                        //0x5 = DIV32 : divided by 32
                                        //0x6 = DIV64 : divided by 64
                                        //0x7 = DIV128 : divided by 128
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CK_PSC        :4;     //[11..8] I2C internal clock CK_I2C_INT prescaler
            __IO uint8_t  TMO_CKS       :1;     //[12] I2C timeout clock source select.
                                        //0 = CK_UT
                                        //1 = DIV64 (CK_I2C_PSC divided by 64)
            __I  uint8_t                :3;     //[15..13] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  I2C clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  SA_RW         :1;     //[0] I2C slave mode grabbed read/write bit.
            __I  uint8_t  SA_CODE       :7;     //[7..1] I2C slave mode grabbed slave address code
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }SAC;                               /*!< SAC        ~ Offset[0x0C]  I2C slave mode slave address code register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] I2C function enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SADR_EN       :1;     //[1] I2C slave mode main slave address detect enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SADR2_EN      :1;     //[2] I2C slave mode 2nd slave address detect enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NACK_EN       :1;     //[3] I2C master transmit ignore receiving NACK enable for Buffer mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MDS           :2;     //[5..4] I2C operation mode select. The monitor mode is only support for Buffer mode.
                                        //0x0 = I2C : Single/Multi-Master/ Slave mode
                                        //0x1 = Monitor : Monitor-Slave mode
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __IO uint8_t  BUF_EN        :1;     //[6] I2C data buffer enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  GC_EN         :1;     //[7] I2C general call address 0x00 recognized enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[9..8] 
            __I  uint8_t                :1;     //[10] 
            __IO uint8_t  SFBD_EN       :1;     //[11] I2C SDA first bit drive high enable when data transmitted
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SCLS_DIS      :1;     //[12] I2C slave mode clock SCL stretching low control disable
                                        //0 = Enable
                                        //1 = Disable
            __I  uint8_t                :1;     //[13] 
            __IO uint8_t  PDRV_SEL      :2;     //[15..14] I2C pre-drive time select for both SCL and SDA by CK_I2C clock time.
                                        //0x0 = 0T (disable pre-drive)
                                        //0x1 = 1T
                                        //0x2 = 2T
                                        //0x3 = 3T
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :6;     //[29..24] 
            __IO uint8_t  DMA_RXEN      :1;     //[30] Direct memory access enable to receive
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_TXEN      :1;     //[31] Direct memory access enable to transmit
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  I2C control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  LT            :5;     //[4..0] I2C SCL low cycle time by CK_I2C_INT clock time
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  HT            :5;     //[12..8] I2C SCL high cycle time by CK_I2C_INT clock time
            __I  uint8_t                :3;     //[15..13] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  I2C control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  STA           :1;     //[0] I2C START enable bit.
            __IO uint8_t  STO           :1;     //[1] I2C STOP enable bit.
            __IO uint8_t  AA            :1;     //[2] I2C assert Acknowledge enable bit.
            __IO uint8_t  CMD_TC        :1;     //[3] I2C command preload enable control bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  STA_LCK       :1;     //[4] I2C_STA and I2C_PSTA bits write access protected control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  STO_LCK       :1;     //[5] I2C_STO and I2C_PSTO bits write access protected control
                                        //0 = Locked
                                        //1 = un-Locked
            __IO uint8_t  AA_LCK        :1;     //[6] I2C_AA and I2C_PAA bits write access protected control
                                        //0 = Locked
                                        //1 = un-Locked
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BUF_CNT       :3;     //[10..8] I2C transmitted or received data byte count threshold
                                        //0x0 = Reserved
                                        //0x1 = 1-byte
                                        //0x2 = 2-byte
                                        //0x3 = 3-byte
                                        //0x4 = 4-byte
            __I  uint8_t                :5;     //[15..11] 
            __I  uint8_t  ACNT          :3;     //[18..16] I2C transmitted or received data actual byte count value
                                        //0x0 = 0-byte
                                        //0x1 = 1-byte
                                        //0x2 = 2-byte
                                        //0x3 = 3-byte
                                        //0x4 = 4-byte
            __I  uint8_t                :5;     //[23..19] 
            __IO uint8_t  PSTA          :1;     //[24] I2C  preload bit forSTART enable bit.
            __IO uint8_t  PSTO          :1;     //[25] I2C preload bit for STOP enable bit.
            __IO uint8_t  PAA           :1;     //[26] I2C preload bit for Acknowledge enable bit.
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  I2C control register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  SADR          :7;     //[7..1] I2C slave mode main slave address detection request address value.
            __I  uint8_t                :1;     //[8] 
            __IO uint8_t  SADR2         :7;     //[15..9] I2C slave mode 2nd slave address detection request address value.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }SADR;                              /*!< SADR       ~ Offset[0x1C]  I2C slave address detect register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TMO_EN        :1;     //[0] I2C timeout detect enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMO_CTL       :1;     //[1] I2C timeout event happened I2C reset control enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMO_MDS       :2;     //[3..2] I2C timeout detection mode select
                                        //0x0 = SCL-low (SCL low timeout)
                                        //0x1 = SCL-SDA-high (both SCL and SDA high timeout for bus idle condition)
                                        //0x2 = General (general counter)
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  TMO_CNT       :8;     //[15..8] I2C timeout setting value.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TMOUT;                             /*!< TMOUT      ~ Offset[0x20]  I2C timeout control register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x24]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  EVENT         :8;     //[7..0] I2C status event code
            __IO uint8_t  EVENTF2       :1;     //[8] I2C status event interrupt Flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :7;     //[15..9] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA2;                              /*!< STA2       ~ Offset[0x28]  I2C status register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SBUF          :8;     //[7..0] I2C data shift buffer register
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }SBUF;                              /*!< SBUF       ~ Offset[0x2C]  I2C data shift buffer register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t DAT           :32;    //[31..0] I2C data byte register
        }MBIT;
    }DAT;                               /*!< DAT        ~ Offset[0x30]  I2C data register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  SA_MSK        :7;     //[7..1] I2C slave address I2C_SADR mask register
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }MASK;                              /*!< MASK       ~ Offset[0x34]  I2C slave address detect register */

} I2C_Struct;

/**
 ******************************************************************************
 *
 * @name        I2C  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define I2C0_Base                       ((uint32_t)0x51000000)              /*!< I2C Control Module-0 */
#define I2C1_Base                       ((uint32_t)0x51010000)              /*!< I2C Control Module-1 */
#define I2C0                            ((I2C_Struct*) I2C0_Base)
#define I2C1                            ((I2C_Struct*) I2C1_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        I2C  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        I2C_STA  [register's definitions]
 *              Offset[0x00]  I2C status register
 ******************************************************************************
 */
///@{
#define I2C_STA_default                             ((uint32_t)0x00000080)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_STA */
#define I2C_STA_BERRF_mask_w                        ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define I2C_STA_BERRF_mask_h1                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define I2C_STA_BERRF_mask_b2                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define I2C_STA_BERRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_BERRF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_BERRF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_BERRF_happened_w                    ((uint32_t)0x00800000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_BERRF_happened_h1                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_BERRF_happened_b2                   ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_ALOSF_mask_w                        ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define I2C_STA_ALOSF_mask_h1                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define I2C_STA_ALOSF_mask_b2                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_STA_ALOSF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_ALOSF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_ALOSF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_ALOSF_happened_w                    ((uint32_t)0x00400000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_ALOSF_happened_h1                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_ALOSF_happened_b2                   ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_NACKF_mask_w                        ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define I2C_STA_NACKF_mask_h1                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define I2C_STA_NACKF_mask_b2                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define I2C_STA_NACKF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_NACKF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_NACKF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_NACKF_happened_w                    ((uint32_t)0x00200000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_NACKF_happened_h1                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_NACKF_happened_b2                   ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_TOVRF_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define I2C_STA_TOVRF_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define I2C_STA_TOVRF_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_STA_TOVRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_TOVRF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_TOVRF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_TOVRF_happened_w                    ((uint32_t)0x00100000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_TOVRF_happened_h1                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_TOVRF_happened_b2                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_ROVRF_mask_w                        ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define I2C_STA_ROVRF_mask_h1                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define I2C_STA_ROVRF_mask_b2                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_STA_ROVRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_ROVRF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_ROVRF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_ROVRF_happened_w                    ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_ROVRF_happened_h1                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_ROVRF_happened_b2                   ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_TXRF_mask_w                         ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define I2C_STA_TXRF_mask_h1                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define I2C_STA_TXRF_mask_b2                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_STA_TXRF_no_data_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No data of 32bit */
#define I2C_STA_TXRF_no_data_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No data of 16bit */
#define I2C_STA_TXRF_no_data_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):No data of 8bit */
#define I2C_STA_TXRF_remained_data_w                ((uint32_t)0x00040000)  /*!< Bit Value =(1):Remained data of 32bit */
#define I2C_STA_TXRF_remained_data_h1               ((uint16_t)0x0004)      /*!< Bit Value =(1):Remained data of 16bit */
#define I2C_STA_TXRF_remained_data_b2               ((uint8_t )0x04)        /*!< Bit Value =(1):Remained data of 8bit */

#define I2C_STA_STPSTRF_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define I2C_STA_STPSTRF_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_STA_STPSTRF_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_STA_STPSTRF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_STPSTRF_normal_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_STPSTRF_normal_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_STPSTRF_happened_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_STPSTRF_happened_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_STPSTRF_happened_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_TSCF_mask_w                         ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define I2C_STA_TSCF_mask_h1                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_STA_TSCF_mask_b2                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_STA_TSCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_TSCF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_TSCF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_TSCF_happened_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_TSCF_happened_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_TSCF_happened_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_RWF_mask_w                          ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define I2C_STA_RWF_mask_h0                         ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define I2C_STA_RWF_mask_b1                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define I2C_STA_RWF_write_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Write of 32bit */
#define I2C_STA_RWF_write_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Write of 16bit */
#define I2C_STA_RWF_write_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):Write of 8bit */
#define I2C_STA_RWF_read_w                          ((uint32_t)0x00008000)  /*!< Bit Value =(1):Read of 32bit */
#define I2C_STA_RWF_read_h0                         ((uint16_t)0x8000)      /*!< Bit Value =(1):Read of 16bit */
#define I2C_STA_RWF_read_b1                         ((uint8_t )0x80)        /*!< Bit Value =(1):Read of 8bit */

#define I2C_STA_MSTF_mask_w                         ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define I2C_STA_MSTF_mask_h0                        ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define I2C_STA_MSTF_mask_b1                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_STA_MSTF_shift_w                        (14)                    /*!< Bit Shift of 32bit */
#define I2C_STA_MSTF_shift_h0                       (14)                    /*!< Bit Shift of 16bit */
#define I2C_STA_MSTF_shift_b1                       (6)                     /*!< Bit Shift of 8bit */

#define I2C_STA_SLAF_mask_w                         ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define I2C_STA_SLAF_mask_h0                        ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define I2C_STA_SLAF_mask_b1                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define I2C_STA_SLAF_shift_w                        (13)                    /*!< Bit Shift of 32bit */
#define I2C_STA_SLAF_shift_h0                       (13)                    /*!< Bit Shift of 16bit */
#define I2C_STA_SLAF_shift_b1                       (5)                     /*!< Bit Shift of 8bit */

#define I2C_STA_SADRF_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define I2C_STA_SADRF_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define I2C_STA_SADRF_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_STA_SADRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_SADRF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_SADRF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_SADRF_happened_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_SADRF_happened_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_SADRF_happened_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_ERRCF_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define I2C_STA_ERRCF_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define I2C_STA_ERRCF_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_STA_ERRCF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_ERRCF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_ERRCF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_ERRCF_happened_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_ERRCF_happened_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_ERRCF_happened_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_CNTF_mask_w                         ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define I2C_STA_CNTF_mask_h0                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define I2C_STA_CNTF_mask_b1                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_STA_CNTF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_CNTF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_CNTF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_CNTF_happened_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_CNTF_happened_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_CNTF_happened_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_STOPF_mask_w                        ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define I2C_STA_STOPF_mask_h0                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define I2C_STA_STOPF_mask_b1                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_STA_STOPF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_STOPF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_STOPF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_STOPF_happened_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_STOPF_happened_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_STOPF_happened_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_RSTRF_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define I2C_STA_RSTRF_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define I2C_STA_RSTRF_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_STA_RSTRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_RSTRF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_RSTRF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_RSTRF_happened_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_RSTRF_happened_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_RSTRF_happened_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_TXF_mask_w                          ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define I2C_STA_TXF_mask_h0                         ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define I2C_STA_TXF_mask_b0                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define I2C_STA_TXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_TXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_TXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_TXF_happened_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_TXF_happened_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_TXF_happened_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_RXF_mask_w                          ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define I2C_STA_RXF_mask_h0                         ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define I2C_STA_RXF_mask_b0                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_STA_RXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_RXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_RXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_RXF_happened_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_RXF_happened_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_RXF_happened_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_WUPF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define I2C_STA_WUPF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define I2C_STA_WUPF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define I2C_STA_WUPF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_WUPF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_WUPF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_WUPF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_WUPF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_WUPF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_TMOUTF_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define I2C_STA_TMOUTF_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define I2C_STA_TMOUTF_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_STA_TMOUTF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_TMOUTF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_TMOUTF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_TMOUTF_happened_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_TMOUTF_happened_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_TMOUTF_happened_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_ERRF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define I2C_STA_ERRF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define I2C_STA_ERRF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_STA_ERRF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_ERRF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_ERRF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_ERRF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_ERRF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_ERRF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_BUFF_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define I2C_STA_BUFF_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define I2C_STA_BUFF_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_STA_BUFF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_BUFF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_BUFF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_BUFF_happened_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_BUFF_happened_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_BUFF_happened_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_EVENTF_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define I2C_STA_EVENTF_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_STA_EVENTF_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_STA_EVENTF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_EVENTF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_EVENTF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_EVENTF_happened_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA_EVENTF_happened_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA_EVENTF_happened_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA_BUSYF_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define I2C_STA_BUSYF_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_STA_BUSYF_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_STA_BUSYF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA_BUSYF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA_BUSYF_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA_BUSYF_busy_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Busy of 32bit */
#define I2C_STA_BUSYF_busy_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Busy of 16bit */
#define I2C_STA_BUSYF_busy_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Busy of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_INT  [register's definitions]
 *              Offset[0x04]  I2C interrupt enable register
 ******************************************************************************
 */
///@{
#define I2C_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_INT */
#define I2C_INT_SDAF_mask_w                         ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define I2C_INT_SDAF_mask_h1                        ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define I2C_INT_SDAF_mask_b3                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define I2C_INT_SDAF_shift_w                        (31)                    /*!< Bit Shift of 32bit */
#define I2C_INT_SDAF_shift_h1                       (15)                    /*!< Bit Shift of 16bit */
#define I2C_INT_SDAF_shift_b3                       (7)                     /*!< Bit Shift of 8bit */

#define I2C_INT_SCLF_mask_w                         ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define I2C_INT_SCLF_mask_h1                        ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define I2C_INT_SCLF_mask_b3                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_INT_SCLF_shift_w                        (30)                    /*!< Bit Shift of 32bit */
#define I2C_INT_SCLF_shift_h1                       (14)                    /*!< Bit Shift of 16bit */
#define I2C_INT_SCLF_shift_b3                       (6)                     /*!< Bit Shift of 8bit */

#define I2C_INT_STPSTR_IE_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define I2C_INT_STPSTR_IE_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_INT_STPSTR_IE_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_INT_STPSTR_IE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_STPSTR_IE_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_STPSTR_IE_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_STPSTR_IE_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_STPSTR_IE_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_STPSTR_IE_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_INT_WUP_IE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define I2C_INT_WUP_IE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define I2C_INT_WUP_IE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define I2C_INT_WUP_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_WUP_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_WUP_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_WUP_IE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_WUP_IE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_WUP_IE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_INT_TMOUT_IE_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define I2C_INT_TMOUT_IE_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define I2C_INT_TMOUT_IE_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_INT_TMOUT_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_TMOUT_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_TMOUT_IE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_TMOUT_IE_enable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_TMOUT_IE_enable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_TMOUT_IE_enable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_INT_ERR_IE_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define I2C_INT_ERR_IE_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define I2C_INT_ERR_IE_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_INT_ERR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_ERR_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_ERR_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_ERR_IE_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_ERR_IE_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_ERR_IE_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_INT_BUF_IE_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define I2C_INT_BUF_IE_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define I2C_INT_BUF_IE_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_INT_BUF_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_BUF_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_BUF_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_BUF_IE_enable_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_BUF_IE_enable_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_BUF_IE_enable_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_INT_EVENT_IE_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define I2C_INT_EVENT_IE_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_INT_EVENT_IE_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_INT_EVENT_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_EVENT_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_EVENT_IE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_EVENT_IE_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_EVENT_IE_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_EVENT_IE_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define I2C_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_CLK  [register's definitions]
 *              Offset[0x08]  I2C clock source register
 ******************************************************************************
 */
///@{
#define I2C_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_CLK */
#define I2C_CLK_TMO_CKS_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define I2C_CLK_TMO_CKS_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define I2C_CLK_TMO_CKS_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_CLK_TMO_CKS_ck_ut_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):CK_UT of 32bit */
#define I2C_CLK_TMO_CKS_ck_ut_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):CK_UT of 16bit */
#define I2C_CLK_TMO_CKS_ck_ut_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):CK_UT of 8bit */
#define I2C_CLK_TMO_CKS_div64_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):DIV64 of 32bit */
#define I2C_CLK_TMO_CKS_div64_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):DIV64 of 16bit */
#define I2C_CLK_TMO_CKS_div64_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):DIV64 of 8bit */

#define I2C_CLK_CK_PSC_mask_w                       ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define I2C_CLK_CK_PSC_mask_h0                      ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define I2C_CLK_CK_PSC_mask_b1                      ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define I2C_CLK_CK_PSC_shift_w                      (8)                     /*!< Bit Shift of 32bit */
#define I2C_CLK_CK_PSC_shift_h0                     (8)                     /*!< Bit Shift of 16bit */
#define I2C_CLK_CK_PSC_shift_b1                     (0)                     /*!< Bit Shift of 8bit */

#define I2C_CLK_CK_DIV_mask_w                       ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define I2C_CLK_CK_DIV_mask_h0                      ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define I2C_CLK_CK_DIV_mask_b0                      ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define I2C_CLK_CK_DIV_div1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define I2C_CLK_CK_DIV_div1_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define I2C_CLK_CK_DIV_div1_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define I2C_CLK_CK_DIV_div2_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define I2C_CLK_CK_DIV_div2_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define I2C_CLK_CK_DIV_div2_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define I2C_CLK_CK_DIV_div4_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define I2C_CLK_CK_DIV_div4_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define I2C_CLK_CK_DIV_div4_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define I2C_CLK_CK_DIV_div8_w                       ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define I2C_CLK_CK_DIV_div8_h0                      ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define I2C_CLK_CK_DIV_div8_b0                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */
#define I2C_CLK_CK_DIV_div16_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):DIV16 of 32bit */
#define I2C_CLK_CK_DIV_div16_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(0x4):DIV16 of 16bit */
#define I2C_CLK_CK_DIV_div16_b0                     ((uint8_t )0x40)        /*!< Bit Value =(0x4):DIV16 of 8bit */
#define I2C_CLK_CK_DIV_div32_w                      ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):DIV32 of 32bit */
#define I2C_CLK_CK_DIV_div32_h0                     ((uint16_t)0x0050)      /*!< Bit Value =(0x5):DIV32 of 16bit */
#define I2C_CLK_CK_DIV_div32_b0                     ((uint8_t )0x50)        /*!< Bit Value =(0x5):DIV32 of 8bit */
#define I2C_CLK_CK_DIV_div64_w                      ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):DIV64 of 32bit */
#define I2C_CLK_CK_DIV_div64_h0                     ((uint16_t)0x0060)      /*!< Bit Value =(0x6):DIV64 of 16bit */
#define I2C_CLK_CK_DIV_div64_b0                     ((uint8_t )0x60)        /*!< Bit Value =(0x6):DIV64 of 8bit */
#define I2C_CLK_CK_DIV_div128_w                     ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):DIV128 of 32bit */
#define I2C_CLK_CK_DIV_div128_h0                    ((uint16_t)0x0070)      /*!< Bit Value =(0x7):DIV128 of 16bit */
#define I2C_CLK_CK_DIV_div128_b0                    ((uint8_t )0x70)        /*!< Bit Value =(0x7):DIV128 of 8bit */

#define I2C_CLK_CK_SEL_mask_w                       ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define I2C_CLK_CK_SEL_mask_h0                      ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define I2C_CLK_CK_SEL_mask_b0                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define I2C_CLK_CK_SEL_proc_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):PROC of 32bit */
#define I2C_CLK_CK_SEL_proc_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):PROC of 16bit */
#define I2C_CLK_CK_SEL_proc_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):PROC of 8bit */
#define I2C_CLK_CK_SEL_tm00_trgo_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):TM00_TRGO of 32bit */
#define I2C_CLK_CK_SEL_tm00_trgo_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(0x2):TM00_TRGO of 16bit */
#define I2C_CLK_CK_SEL_tm00_trgo_b0                 ((uint8_t )0x08)        /*!< Bit Value =(0x2):TM00_TRGO of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_SAC  [register's definitions]
 *              Offset[0x0C]  I2C slave mode slave address code register
 ******************************************************************************
 */
///@{
#define I2C_SAC_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_SAC */
#define I2C_SAC_SA_CODE_mask_w                      ((uint32_t)0x000000FE)  /*!< Bit Mask of 32bit */
#define I2C_SAC_SA_CODE_mask_h0                     ((uint16_t)0x00FE)      /*!< Bit Mask of 16bit */
#define I2C_SAC_SA_CODE_mask_b0                     ((uint8_t )0xFE)        /*!< Bit Mask of 8bit */
#define I2C_SAC_SA_CODE_shift_w                     (1)                     /*!< Bit Shift of 32bit */
#define I2C_SAC_SA_CODE_shift_h0                    (1)                     /*!< Bit Shift of 16bit */
#define I2C_SAC_SA_CODE_shift_b0                    (1)                     /*!< Bit Shift of 8bit */

#define I2C_SAC_SA_RW_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define I2C_SAC_SA_RW_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_SAC_SA_RW_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_SAC_SA_RW_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define I2C_SAC_SA_RW_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define I2C_SAC_SA_RW_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_CR0  [register's definitions]
 *              Offset[0x10]  I2C control register 0
 ******************************************************************************
 */
///@{
#define I2C_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_CR0 */
#define I2C_CR0_DMA_TXEN_mask_w                     ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define I2C_CR0_DMA_TXEN_mask_h1                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define I2C_CR0_DMA_TXEN_mask_b3                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define I2C_CR0_DMA_TXEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_DMA_TXEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_DMA_TXEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_DMA_TXEN_enable_w                   ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_DMA_TXEN_enable_h1                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_DMA_TXEN_enable_b3                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_DMA_RXEN_mask_w                     ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define I2C_CR0_DMA_RXEN_mask_h1                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define I2C_CR0_DMA_RXEN_mask_b3                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_CR0_DMA_RXEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_DMA_RXEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_DMA_RXEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_DMA_RXEN_enable_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_DMA_RXEN_enable_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_DMA_RXEN_enable_b3                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_PDRV_SEL_mask_w                     ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define I2C_CR0_PDRV_SEL_mask_h0                    ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define I2C_CR0_PDRV_SEL_mask_b1                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define I2C_CR0_PDRV_SEL_0t_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0T of 32bit */
#define I2C_CR0_PDRV_SEL_0t_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0T of 16bit */
#define I2C_CR0_PDRV_SEL_0t_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):0T of 8bit */
#define I2C_CR0_PDRV_SEL_1t_w                       ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):1T of 32bit */
#define I2C_CR0_PDRV_SEL_1t_h0                      ((uint16_t)0x4000)      /*!< Bit Value =(0x1):1T of 16bit */
#define I2C_CR0_PDRV_SEL_1t_b1                      ((uint8_t )0x40)        /*!< Bit Value =(0x1):1T of 8bit */
#define I2C_CR0_PDRV_SEL_2t_w                       ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):2T of 32bit */
#define I2C_CR0_PDRV_SEL_2t_h0                      ((uint16_t)0x8000)      /*!< Bit Value =(0x2):2T of 16bit */
#define I2C_CR0_PDRV_SEL_2t_b1                      ((uint8_t )0x80)        /*!< Bit Value =(0x2):2T of 8bit */
#define I2C_CR0_PDRV_SEL_3t_w                       ((uint32_t)0x0000C000)  /*!< Bit Value =(0x3):3T of 32bit */
#define I2C_CR0_PDRV_SEL_3t_h0                      ((uint16_t)0xC000)      /*!< Bit Value =(0x3):3T of 16bit */
#define I2C_CR0_PDRV_SEL_3t_b1                      ((uint8_t )0xC0)        /*!< Bit Value =(0x3):3T of 8bit */

#define I2C_CR0_SCLS_DIS_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define I2C_CR0_SCLS_DIS_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define I2C_CR0_SCLS_DIS_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_CR0_SCLS_DIS_enable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define I2C_CR0_SCLS_DIS_enable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define I2C_CR0_SCLS_DIS_enable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define I2C_CR0_SCLS_DIS_disable_w                  ((uint32_t)0x00001000)  /*!< Bit Value =(1):Disable of 32bit */
#define I2C_CR0_SCLS_DIS_disable_h0                 ((uint16_t)0x1000)      /*!< Bit Value =(1):Disable of 16bit */
#define I2C_CR0_SCLS_DIS_disable_b1                 ((uint8_t )0x10)        /*!< Bit Value =(1):Disable of 8bit */

#define I2C_CR0_SFBD_EN_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define I2C_CR0_SFBD_EN_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define I2C_CR0_SFBD_EN_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_CR0_SFBD_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_SFBD_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_SFBD_EN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_SFBD_EN_enable_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_SFBD_EN_enable_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_SFBD_EN_enable_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_GC_EN_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define I2C_CR0_GC_EN_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define I2C_CR0_GC_EN_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define I2C_CR0_GC_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_GC_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_GC_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_GC_EN_enable_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_GC_EN_enable_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_GC_EN_enable_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_BUF_EN_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define I2C_CR0_BUF_EN_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define I2C_CR0_BUF_EN_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_CR0_BUF_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_BUF_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_BUF_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_BUF_EN_enable_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_BUF_EN_enable_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_BUF_EN_enable_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_MDS_mask_w                          ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define I2C_CR0_MDS_mask_h0                         ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define I2C_CR0_MDS_mask_b0                         ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define I2C_CR0_MDS_i2c_w                           ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):I2C of 32bit */
#define I2C_CR0_MDS_i2c_h0                          ((uint16_t)0x0000)      /*!< Bit Value =(0x0):I2C of 16bit */
#define I2C_CR0_MDS_i2c_b0                          ((uint8_t )0x00)        /*!< Bit Value =(0x0):I2C of 8bit */
#define I2C_CR0_MDS_monitor_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Monitor of 32bit */
#define I2C_CR0_MDS_monitor_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Monitor of 16bit */
#define I2C_CR0_MDS_monitor_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):Monitor of 8bit */

#define I2C_CR0_NACK_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define I2C_CR0_NACK_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define I2C_CR0_NACK_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_CR0_NACK_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_NACK_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_NACK_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_NACK_EN_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_NACK_EN_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_NACK_EN_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_SADR2_EN_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define I2C_CR0_SADR2_EN_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define I2C_CR0_SADR2_EN_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_CR0_SADR2_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_SADR2_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_SADR2_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_SADR2_EN_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_SADR2_EN_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_SADR2_EN_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_SADR_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define I2C_CR0_SADR_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_CR0_SADR_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_CR0_SADR_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_SADR_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_SADR_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_SADR_EN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_SADR_EN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_SADR_EN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define I2C_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_CR1  [register's definitions]
 *              Offset[0x14]  I2C control register 1
 ******************************************************************************
 */
///@{
#define I2C_CR1_default                             ((uint32_t)0x00000504)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_CR1 */
#define I2C_CR1_HT_mask_w                           ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define I2C_CR1_HT_mask_h0                          ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define I2C_CR1_HT_mask_b1                          ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

#define I2C_CR1_LT_mask_w                           ((uint32_t)0x0000001F)  /*!< Bit Mask of 32bit */
#define I2C_CR1_LT_mask_h0                          ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define I2C_CR1_LT_mask_b0                          ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_CR2  [register's definitions]
 *              Offset[0x18]  I2C control register 2
 ******************************************************************************
 */
///@{
#define I2C_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_CR2 */
#define I2C_CR2_PAA_mask_w                          ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define I2C_CR2_PAA_mask_h1                         ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define I2C_CR2_PAA_mask_b3                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_CR2_PAA_shift_w                         (26)                    /*!< Bit Shift of 32bit */
#define I2C_CR2_PAA_shift_h1                        (10)                    /*!< Bit Shift of 16bit */
#define I2C_CR2_PAA_shift_b3                        (2)                     /*!< Bit Shift of 8bit */

#define I2C_CR2_PSTO_mask_w                         ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define I2C_CR2_PSTO_mask_h1                        ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define I2C_CR2_PSTO_mask_b3                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_CR2_PSTO_shift_w                        (25)                    /*!< Bit Shift of 32bit */
#define I2C_CR2_PSTO_shift_h1                       (9)                     /*!< Bit Shift of 16bit */
#define I2C_CR2_PSTO_shift_b3                       (1)                     /*!< Bit Shift of 8bit */

#define I2C_CR2_PSTA_mask_w                         ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define I2C_CR2_PSTA_mask_h1                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define I2C_CR2_PSTA_mask_b3                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_CR2_PSTA_shift_w                        (24)                    /*!< Bit Shift of 32bit */
#define I2C_CR2_PSTA_shift_h1                       (8)                     /*!< Bit Shift of 16bit */
#define I2C_CR2_PSTA_shift_b3                       (0)                     /*!< Bit Shift of 8bit */

#define I2C_CR2_ACNT_mask_w                         ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define I2C_CR2_ACNT_mask_h1                        ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define I2C_CR2_ACNT_mask_b2                        ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define I2C_CR2_ACNT_0_byte_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0-byte of 32bit */
#define I2C_CR2_ACNT_0_byte_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0-byte of 16bit */
#define I2C_CR2_ACNT_0_byte_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):0-byte of 8bit */
#define I2C_CR2_ACNT_1_byte_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):1-byte of 32bit */
#define I2C_CR2_ACNT_1_byte_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):1-byte of 16bit */
#define I2C_CR2_ACNT_1_byte_b2                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):1-byte of 8bit */
#define I2C_CR2_ACNT_2_byte_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):2-byte of 32bit */
#define I2C_CR2_ACNT_2_byte_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):2-byte of 16bit */
#define I2C_CR2_ACNT_2_byte_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):2-byte of 8bit */
#define I2C_CR2_ACNT_3_byte_w                       ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):3-byte of 32bit */
#define I2C_CR2_ACNT_3_byte_h1                      ((uint16_t)0x0003)      /*!< Bit Value =(0x3):3-byte of 16bit */
#define I2C_CR2_ACNT_3_byte_b2                      ((uint8_t )0x03)        /*!< Bit Value =(0x3):3-byte of 8bit */
#define I2C_CR2_ACNT_4_byte_w                       ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):4-byte of 32bit */
#define I2C_CR2_ACNT_4_byte_h1                      ((uint16_t)0x0004)      /*!< Bit Value =(0x4):4-byte of 16bit */
#define I2C_CR2_ACNT_4_byte_b2                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):4-byte of 8bit */

#define I2C_CR2_BUF_CNT_mask_w                      ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define I2C_CR2_BUF_CNT_mask_h0                     ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define I2C_CR2_BUF_CNT_mask_b1                     ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define I2C_CR2_BUF_CNT_1_byte_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):1-byte of 32bit */
#define I2C_CR2_BUF_CNT_1_byte_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):1-byte of 16bit */
#define I2C_CR2_BUF_CNT_1_byte_b1                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):1-byte of 8bit */
#define I2C_CR2_BUF_CNT_2_byte_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):2-byte of 32bit */
#define I2C_CR2_BUF_CNT_2_byte_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(0x2):2-byte of 16bit */
#define I2C_CR2_BUF_CNT_2_byte_b1                   ((uint8_t )0x02)        /*!< Bit Value =(0x2):2-byte of 8bit */
#define I2C_CR2_BUF_CNT_3_byte_w                    ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):3-byte of 32bit */
#define I2C_CR2_BUF_CNT_3_byte_h0                   ((uint16_t)0x0300)      /*!< Bit Value =(0x3):3-byte of 16bit */
#define I2C_CR2_BUF_CNT_3_byte_b1                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):3-byte of 8bit */
#define I2C_CR2_BUF_CNT_4_byte_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):4-byte of 32bit */
#define I2C_CR2_BUF_CNT_4_byte_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(0x4):4-byte of 16bit */
#define I2C_CR2_BUF_CNT_4_byte_b1                   ((uint8_t )0x04)        /*!< Bit Value =(0x4):4-byte of 8bit */

#define I2C_CR2_AA_LCK_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define I2C_CR2_AA_LCK_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define I2C_CR2_AA_LCK_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define I2C_CR2_AA_LCK_locked_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define I2C_CR2_AA_LCK_locked_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define I2C_CR2_AA_LCK_locked_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define I2C_CR2_AA_LCK_un_locked_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(1):un-Locked of 32bit */
#define I2C_CR2_AA_LCK_un_locked_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(1):un-Locked of 16bit */
#define I2C_CR2_AA_LCK_un_locked_b0                 ((uint8_t )0x40)        /*!< Bit Value =(1):un-Locked of 8bit */

#define I2C_CR2_STO_LCK_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define I2C_CR2_STO_LCK_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define I2C_CR2_STO_LCK_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define I2C_CR2_STO_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define I2C_CR2_STO_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define I2C_CR2_STO_LCK_locked_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define I2C_CR2_STO_LCK_un_locked_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):un-Locked of 32bit */
#define I2C_CR2_STO_LCK_un_locked_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):un-Locked of 16bit */
#define I2C_CR2_STO_LCK_un_locked_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):un-Locked of 8bit */

#define I2C_CR2_STA_LCK_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define I2C_CR2_STA_LCK_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define I2C_CR2_STA_LCK_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define I2C_CR2_STA_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define I2C_CR2_STA_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define I2C_CR2_STA_LCK_locked_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define I2C_CR2_STA_LCK_un_locked_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):un-Locked of 32bit */
#define I2C_CR2_STA_LCK_un_locked_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):un-Locked of 16bit */
#define I2C_CR2_STA_LCK_un_locked_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):un-Locked of 8bit */

#define I2C_CR2_CMD_TC_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define I2C_CR2_CMD_TC_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define I2C_CR2_CMD_TC_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define I2C_CR2_CMD_TC_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_CR2_CMD_TC_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_CR2_CMD_TC_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_CR2_CMD_TC_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_CR2_CMD_TC_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_CR2_CMD_TC_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_CR2_AA_mask_w                           ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define I2C_CR2_AA_mask_h0                          ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define I2C_CR2_AA_mask_b0                          ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define I2C_CR2_AA_shift_w                          (2)                     /*!< Bit Shift of 32bit */
#define I2C_CR2_AA_shift_h0                         (2)                     /*!< Bit Shift of 16bit */
#define I2C_CR2_AA_shift_b0                         (2)                     /*!< Bit Shift of 8bit */

#define I2C_CR2_STO_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define I2C_CR2_STO_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_CR2_STO_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_CR2_STO_shift_w                         (1)                     /*!< Bit Shift of 32bit */
#define I2C_CR2_STO_shift_h0                        (1)                     /*!< Bit Shift of 16bit */
#define I2C_CR2_STO_shift_b0                        (1)                     /*!< Bit Shift of 8bit */

#define I2C_CR2_STA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define I2C_CR2_STA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_CR2_STA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_CR2_STA_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define I2C_CR2_STA_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define I2C_CR2_STA_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_SADR  [register's definitions]
 *              Offset[0x1C]  I2C slave address detect register
 ******************************************************************************
 */
///@{
#define I2C_SADR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_SADR */
#define I2C_SADR_SADR2_mask_w                       ((uint32_t)0x0000FE00)  /*!< Bit Mask of 32bit */
#define I2C_SADR_SADR2_mask_h0                      ((uint16_t)0xFE00)      /*!< Bit Mask of 16bit */
#define I2C_SADR_SADR2_mask_b1                      ((uint8_t )0xFE)        /*!< Bit Mask of 8bit */
#define I2C_SADR_SADR2_shift_w                      (9)                     /*!< Bit Shift of 32bit */
#define I2C_SADR_SADR2_shift_h0                     (9)                     /*!< Bit Shift of 16bit */
#define I2C_SADR_SADR2_shift_b1                     (1)                     /*!< Bit Shift of 8bit */

#define I2C_SADR_SADR_mask_w                        ((uint32_t)0x000000FE)  /*!< Bit Mask of 32bit */
#define I2C_SADR_SADR_mask_h0                       ((uint16_t)0x00FE)      /*!< Bit Mask of 16bit */
#define I2C_SADR_SADR_mask_b0                       ((uint8_t )0xFE)        /*!< Bit Mask of 8bit */
#define I2C_SADR_SADR_shift_w                       (1)                     /*!< Bit Shift of 32bit */
#define I2C_SADR_SADR_shift_h0                      (1)                     /*!< Bit Shift of 16bit */
#define I2C_SADR_SADR_shift_b0                      (1)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_TMOUT  [register's definitions]
 *              Offset[0x20]  I2C timeout control register
 ******************************************************************************
 */
///@{
#define I2C_TMOUT_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_TMOUT */
#define I2C_TMOUT_TMO_CNT_mask_w                    ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define I2C_TMOUT_TMO_CNT_mask_h0                   ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define I2C_TMOUT_TMO_CNT_mask_b1                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define I2C_TMOUT_TMO_CNT_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define I2C_TMOUT_TMO_CNT_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define I2C_TMOUT_TMO_CNT_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define I2C_TMOUT_TMO_MDS_mask_w                    ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define I2C_TMOUT_TMO_MDS_mask_h0                   ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define I2C_TMOUT_TMO_MDS_mask_b0                   ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define I2C_TMOUT_TMO_MDS_scl_low_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):SCL-low of 32bit */
#define I2C_TMOUT_TMO_MDS_scl_low_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):SCL-low of 16bit */
#define I2C_TMOUT_TMO_MDS_scl_low_b0                ((uint8_t )0x00)        /*!< Bit Value =(0x0):SCL-low of 8bit */
#define I2C_TMOUT_TMO_MDS_scl_sda_high_w            ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):SCL-SDA-high of 32bit */
#define I2C_TMOUT_TMO_MDS_scl_sda_high_h0           ((uint16_t)0x0004)      /*!< Bit Value =(0x1):SCL-SDA-high of 16bit */
#define I2C_TMOUT_TMO_MDS_scl_sda_high_b0           ((uint8_t )0x04)        /*!< Bit Value =(0x1):SCL-SDA-high of 8bit */
#define I2C_TMOUT_TMO_MDS_general_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):General of 32bit */
#define I2C_TMOUT_TMO_MDS_general_h0                ((uint16_t)0x0008)      /*!< Bit Value =(0x2):General of 16bit */
#define I2C_TMOUT_TMO_MDS_general_b0                ((uint8_t )0x08)        /*!< Bit Value =(0x2):General of 8bit */

#define I2C_TMOUT_TMO_CTL_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define I2C_TMOUT_TMO_CTL_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define I2C_TMOUT_TMO_CTL_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define I2C_TMOUT_TMO_CTL_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_TMOUT_TMO_CTL_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_TMOUT_TMO_CTL_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_TMOUT_TMO_CTL_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_TMOUT_TMO_CTL_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_TMOUT_TMO_CTL_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define I2C_TMOUT_TMO_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define I2C_TMOUT_TMO_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define I2C_TMOUT_TMO_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_TMOUT_TMO_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define I2C_TMOUT_TMO_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define I2C_TMOUT_TMO_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define I2C_TMOUT_TMO_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define I2C_TMOUT_TMO_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define I2C_TMOUT_TMO_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_STA2  [register's definitions]
 *              Offset[0x28]  I2C status register 2
 ******************************************************************************
 */
///@{
#define I2C_STA2_default                            ((uint32_t)0x000000F8)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_STA2 */
#define I2C_STA2_EVENTF2_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define I2C_STA2_EVENTF2_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define I2C_STA2_EVENTF2_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define I2C_STA2_EVENTF2_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define I2C_STA2_EVENTF2_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define I2C_STA2_EVENTF2_normal_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define I2C_STA2_EVENTF2_happened_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define I2C_STA2_EVENTF2_happened_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define I2C_STA2_EVENTF2_happened_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define I2C_STA2_EVENT_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define I2C_STA2_EVENT_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define I2C_STA2_EVENT_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define I2C_STA2_EVENT_shift_w                      (0)                     /*!< Bit Shift of 32bit */
#define I2C_STA2_EVENT_shift_h0                     (0)                     /*!< Bit Shift of 16bit */
#define I2C_STA2_EVENT_shift_b0                     (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_SBUF  [register's definitions]
 *              Offset[0x2C]  I2C data shift buffer register
 ******************************************************************************
 */
///@{
#define I2C_SBUF_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_SBUF */
#define I2C_SBUF_SBUF_mask_w                        ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define I2C_SBUF_SBUF_mask_h0                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define I2C_SBUF_SBUF_mask_b0                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define I2C_SBUF_SBUF_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define I2C_SBUF_SBUF_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define I2C_SBUF_SBUF_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_DAT  [register's definitions]
 *              Offset[0x30]  I2C data register
 ******************************************************************************
 */
///@{
#define I2C_DAT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_DAT */
#define I2C_DAT_DAT_mask_w                          ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define I2C_DAT_DAT_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define I2C_DAT_DAT_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define I2C_DAT_DAT_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        I2C_MASK  [register's definitions]
 *              Offset[0x34]  I2C slave address detect register
 ******************************************************************************
 */
///@{
#define I2C_MASK_default                            ((uint32_t)0x000000FE)  /*!< Reg Reset Default Value */

/* Bit fields of I2C_MASK */
#define I2C_MASK_SA_MSK_mask_w                      ((uint32_t)0x000000FE)  /*!< Bit Mask of 32bit */
#define I2C_MASK_SA_MSK_mask_h0                     ((uint16_t)0x00FE)      /*!< Bit Mask of 16bit */
#define I2C_MASK_SA_MSK_mask_b0                     ((uint8_t )0xFE)        /*!< Bit Mask of 8bit */
#define I2C_MASK_SA_MSK_shift_w                     (1)                     /*!< Bit Shift of 32bit */
#define I2C_MASK_SA_MSK_shift_h0                    (1)                     /*!< Bit Shift of 16bit */
#define I2C_MASK_SA_MSK_shift_b0                    (1)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_I2C_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_I2C.h                           */
/*----------------------------------------------------------------------------*/
