/**
 ******************************************************************************
 *
 * @file        MG32.h
 *
 * @brief       MG32 Device Peripheral Access Layer Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:38 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_H
#define _MG32_H
#define _MG32_H_VER                                 130     /*!< File Version */


// REG_GenH version V1.8
#ifdef __cplusplus
 extern "C" {
#endif

/**
 *************************************************
 *  Chip definitions
 *************************************************
 */
// Chip Generation
#if defined(MG32F02A132) || defined(MG32F02A072)
  #define MG32_1ST
#elif defined(MG32F02A032)
  #define MG32_2ND
#elif defined(MG32F02A128) || defined(MG32F02U128) || defined(MG32F02A064) || defined(MG32F02U064)
  #define MG32_3RD
#elif defined(MG32F02V032)
  #define MG32_4TH
#elif defined(MG32F02K128) || defined(MG32F02K064) || defined(MG32F02N128) || defined(MG32F02N064)
  #define MG32_5TH
#endif

#if defined(MG32F02U128) || defined(MG32F02U064)
  #define USB_TYPE                  /*!< Chip is embedded USB device */
#endif
#if defined(MG32F02K128) || defined(MG32F02K064) || defined(MG32F02N128) || defined(MG32F02N064)
  #define LCD_TYPE                  /*!< Chip is embedded LCD device */
#endif
#if defined(MG32F02N128) || defined(MG32F02N064) 
  #define CAN_TYPE                  /*!< Chip is embedded CAN device */
#endif
    
#include "MG32_Ex.h"

/**
 *************************************************
 *  ARM CPU Configuration Setting
 *************************************************
 */
#define __CM0_REV                 0 /*!< Core Revision r0p0                            */
#define __MPU_PRESENT             0 /*!< Chip do not provide MPU                       */
#define __NVIC_PRIO_BITS          2 /*!< Chip uses 2 Bits for the Priority Levels      */
#define __Vendor_SysTickConfig    0 /*!< Set to 1 if different SysTick Config is used  */

/**
 ******************************************************************************
 * @enum        IRQn
 *              Interrupt Number Definition
 ******************************************************************************
 */
typedef enum IRQn
{
/******  Cortex-M0 Processor Exceptions Numbers Definitions *****************************************/
    NMI_IRQn                    = -14 , /*!<  ;Non Maskable Interrupt                               */
    HardFault_IRQn              = -13 , /*!<  ;Cortex-M0 Hard Fault Interrupt                       */
    SVC_IRQn                    = -5 ,  /*!<  ;Cortex-M0 SV Call Interrupt                          */
    PendSV_IRQn                 = -2 ,  /*!<  ;Cortex-M0 Pend SV Interrupt                          */
    SysTick_IRQn                = -1 ,  /*!<  ;Cortex-M0 System Tick Interrupt                      */
/******  Peripheral Interrupt Numbers Definitions ***************************************************/
    WWDT_IRQn                   =  0 ,  /*!<  ;Window Watchdog interrupt                            */
    SYS_IRQn                    =  1 ,  /*!<  ;System global interrupt                              */
    EXINT0_IRQn                 =  3 ,  /*!<  ;EXIC EXINT0 (PA) interrupt                           */
    EXINT1_IRQn                 =  4 ,  /*!<  ;EXIC EXINT1 (PB) interrupt                           */
    EXINT2_IRQn                 =  5 ,  /*!<  ;EXIC EXINT2 (PC) interrupt                           */
    EXINT3_IRQn                 =  6 ,  /*!<  ;EXIC EXINT3/4 (PD/PE) interrupt                      */
    COMP_IRQn                   =  7 ,  /*!<  ;Analog Comparators global interrupt                  */
    DMA_IRQn                    =  8 ,  /*!<  ;DMA all channel global interrupt                     */
    OPA_IRQn                    =  9 ,  /*!<  ;OPA interrupt                                        */
    ADC_IRQn                    =  10 , /*!<  ;ADC interrupt                                        */
    DAC_IRQn                    =  11 , /*!<  ;DAC interrupt                                        */
    TM0x_IRQn                   =  12 , /*!<  ;Timer TM0x global interrupt                          */
    TM10_IRQn                   =  13 , /*!<  ;Timer TM10 interrupt                                 */
    TM1x_IRQn                   =  14 , /*!<  ;Timer TM16 TM1x global interrupt                     */
    TM20_IRQn                   =  15 , /*!<  ;Timer TM20 interrupt                                 */
    TM2x_IRQn                   =  16 , /*!<  ;Timer TM26 TM2x global interrupt                     */
    TM3x_IRQn                   =  17 , /*!<  ;Timer TM3x global interrupt                          */
    LCD_IRQn                    =  19 , /*!<  ;LCD interrupt                                        */
    URT0_IRQn                   =  20 , /*!<  ;UART URT0 interrupt                                  */
    URT123_IRQn                 =  21 , /*!<  ;UART URT1/2/3 global interrupt                       */
    URT4x_IRQn                  =  22 , /*!<  ;UART URT4/5/6/7 global interrupt                     */
    SPI0_IRQn                   =  24 , /*!<  ;SPI0 interrupt                                       */
    CAN0_IRQn                   =  27 , /*!<  ;CAN0 interrupt                                       */
    I2C0_IRQn                   =  28 , /*!<  ;I2C0 interrupt                                       */
    I2Cx_IRQn                   =  29 , /*!<  ;I2C1 I2Cx global interrupt                           */
    USB_IRQn                    =  30 , /*!<  ;USB interrupt                                        */
    APX_IRQn                    =  31 , /*!<  ;APX interrupt                                        */
} IRQn_Type;                    /*!< Interrupt Number Definition */


#include "core_cm0.h"
#include <stdint.h>

/**
 *************************************************
 *  New type definitions
 *************************************************
 */
typedef signed char boolean;		/*!< Boolean	*/
typedef unsigned char byte;			/*!< Byte		*/
typedef unsigned long long uint64;	/*!< Uint 64-bit	*/
typedef float float32;				/*!< Float 32-bit	*/
typedef double float64;				/*!< Float 64-bit	*/

/**
 *************************************************
 *  @union		ctype
 *				Combined 32/16/8-bit type
 *************************************************
 */
typedef union
{								
	__IO uint8_t    B[4];			/*!< Byte 8-bit 		*/
	__IO uint16_t   H[2];			/*!< Half-Word 16-bit 	*/
	__IO uint32_t   W;				/*!< Word 32-bit 		*/
} ctype;


/**
 *************************************************
 *  General definitions
 *************************************************
 */
#define TRUE		1				/*!< True	*/
#define FALSE		0				/*!< False	*/

#define MASK8(val)  (((val) < 256) ? (val) : (val) < 65536 ? (val) >> 8 : (val) < 16777216 ?  (val) >> 16 : (val) >> 24)	/*!< Mask 8-bit		*/  
#define MASK16(val)  (((val) < 65536) ? (val) : (val)>> 16) 																/*!< Mask 16-bit	*/

#define NULL_0		0				/*!< Null=0	*/

/**
 ******************************************************************************
 * @enum        FunctionalState
 *              Enable/Disable
 ******************************************************************************
 */
typedef enum {DISABLE = 0, ENABLE = !DISABLE} FunctionalState;										/*!< Enable/Disable	*/
/**
 ******************************************************************************
 * @enum        FlagStatus
 *              Clear/Se
 ******************************************************************************
 */
typedef enum {CLR = 0, SET = !CLR} FlagStatus ,BitAction;											/*!< Clear/Set	*/
/**
 ******************************************************************************
 * @enum        ITStatus
 *              None/Happened/Stable/Unstable
 ******************************************************************************
 */
typedef enum {NONE = 0,  HAPPENED = !NONE, UNSTABLE = 0, STABLE = !UNSTABLE} ITStatus, CSCStatus;	/*!< None/Happened/Stable/Unstablee	*/       


/**
 *************************************************
 *  Hardware Access
 *************************************************
 */

/**
 * @brief  read register bit value
 * @param  REG : definitions of register name, like MODULE_REGNAME
 * @param  BIT : definitions of register mask value, like MODULE_REGNAME_mask
 */
#define READ_BIT(REG, BIT)    ((REG) & (BIT))

/**
 * @brief  clear register, value = 0
 * @param  REG : definitions of register name, like MODULE_REGNAME
 */
#define CLEAR_REG(REG)        ((REG) = (0x0))                                       /*!< Hardware Clear Register */

/**
 * @brief  write register value
 * @param  REG : definitions of register name, like MODULE_REGNAME
 * @param  VAL : definitions of register value, like MODULE_REGNAME_xyz
 */
#define WRITE_REG(REG, VAL)   ((REG) = (VAL))                                       /*!< Hardware Write Register */

/**
 * @brief  read register value
 * @param  REG : definitions of register name, like MODULE_REGNAME
 */
#define READ_REG(REG)         ((REG))                                               /*!< Hardware Read Register */

/**
 * @brief  set register bits value =1
 * @param  REG : definitions of register name, like MODULE_REGNAME
 * @param  BIT : definitions of register mask value, like MODULE_REGNAME_mask
 */
#define SET_BIT(REG, BIT)     ((REG) |= (BIT))                                      /*!< Hardware Set Register Bit */

/**
 * @brief  clear register bits value =0
 * @param  REG : definitions of register name, like MODULE_REGNAME
 * @param  BIT : definitions of register mask value, like MODULE_REGNAME_mask
 */
#define CLEAR_BIT(REG, BIT)   ((REG) &= ~(BIT))                                     /*!< Hardware Clear Register Bit */

/**
 * @brief  modify register bits value
 * @param  REG : definitions of register name, like MODULE_REGNAME
 * @param  CLEARMASK : definitions of register mask value, like MODULE_REGNAME_mask
 * @param  SETMASK : definitions of register mask value, like MODULE_REGNAME_mask
 */
#define MODIFY_REG(REG, CLEARMASK, SETMASK)  WRITE_REG((REG), (((READ_REG(REG)) & (~(CLEARMASK))) | (SETMASK)))  /*!< Hardware Register Modify */

/**
 * @brief   Enter STOP mode with WFI instruction.
 * @note    In STOP mode, all I/O pins keep the same state as in ON mode.
 */
#define STOP_WFI() SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;__WFI()

/**
 * @brief   Enter SLEEP mode with WFI instruction
 */
#define SLEEP_WFI() SCB->SCR &= (uint32_t)~((uint32_t)SCB_SCR_SLEEPDEEP_Msk);__WFI()

/**
 * @brief   Enter STOP mode with WFE instruction
 * @note    In STOP mode, all I/O pins keep the same state as in ON mode.
 */
#define STOP_WFE() SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk; __SEV(); __WFE(); __WFE()

/**
 * @brief   Enter SLEEP mode with WFE instruction
 */
#define SLEEP_WFE() SCB->SCR &= (uint32_t)~((uint32_t)SCB_SCR_SLEEPDEEP_Msk); __SEV(); __WFE(); __WFE()

/**
 ******************************************************************************
 *              Module Exist Definitions
 ******************************************************************************
 */
#define ModuleExist_GPL
#define ModuleExist_DMA
#define ModuleExist_RST
#define ModuleExist_CSC
#define ModuleExist_PW
#define ModuleExist_SYS
#define ModuleExist_MEM
#define ModuleExist_EMB
#define ModuleExist_CFG
#define ModuleExist_EXIC
#define ModuleExist_I2C0
#define ModuleExist_I2C1
#define ModuleExist_URT0
#define ModuleExist_URT1
#define ModuleExist_URT2
#define ModuleExist_URT4
#define ModuleExist_URT5
#define ModuleExist_URT6
#define ModuleExist_URT7
#define ModuleExist_SPI0
#define ModuleExist_USB
#define ModuleExist_TM00
#define ModuleExist_TM01
#define ModuleExist_TM10
#define ModuleExist_TM16
#define ModuleExist_TM20
#define ModuleExist_TM26
#define ModuleExist_TM36
#define ModuleExist_ADC0
#define ModuleExist_CMP
#define ModuleExist_DAC
#define ModuleExist_IWDT
#define ModuleExist_WWDT
#define ModuleExist_RTC
#define ModuleExist_APB
#define ModuleExist_APX


/** 
  * @brief  Compiler definition
  */ 
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
  #ifndef __weak
    #define __weak  __attribute__((weak))
  #endif
  #ifndef __packed
    #define __packed  __attribute__((packed))
  #endif
#elif defined ( __GNUC__ ) && !defined (__CC_ARM) /* GNU Compiler */
  #ifndef __weak
    #define __weak   __attribute__((weak))
  #endif /* __weak */
  #ifndef __packed
    #define __packed __attribute__((__packed__))
  #endif /* __packed */
#endif /* __GNUC__ */

/** 
  * @brief  Macro to get variable aligned on 4-bytes
  *         for __ICCARM__ the directive "#pragma data_alignment=4" must be used instead
  */ 
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
  #ifndef __ALIGN_BEGIN
    #define __ALIGN_BEGIN
  #endif
  #ifndef __ALIGN_END
    #define __ALIGN_END      __attribute__ ((aligned (4)))
  #endif
#elif defined ( __GNUC__ ) && !defined (__CC_ARM) /* GNU Compiler */
  #ifndef __ALIGN_END
    #define __ALIGN_END    __attribute__ ((aligned (4)))
  #endif /* __ALIGN_END */
  #ifndef __ALIGN_BEGIN  
    #define __ALIGN_BEGIN
  #endif /* __ALIGN_BEGIN */
#else
  #ifndef __ALIGN_END
    #define __ALIGN_END
  #endif /* __ALIGN_END */
  #ifndef __ALIGN_BEGIN      
    #if defined   (__CC_ARM)      /* ARM Compiler V5*/
      #define __ALIGN_BEGIN    __align(4)  
    #elif defined (__ICCARM__)    /* IAR Compiler */
      #define __ALIGN_BEGIN 
    #endif /* __CC_ARM */
  #endif /* __ALIGN_BEGIN */
#endif /* __GNUC__ */

/** 
  * @brief  __NOINLINE definition
  */ 
#if defined ( __CC_ARM   ) || (defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)) || defined   (  __GNUC__  )
/* ARM V4/V5 and V6 & GNU Compiler
   -------------------------------
*/
  #define __NOINLINE __attribute__ ( (noinline) )

#elif defined ( __ICCARM__ )
  /* ICCARM Compiler
     ---------------
  */
  #define __NOINLINE _Pragma("optimize = no_inline")

#endif

#ifdef __cplusplus
}
#endif

/**
  * @brief  __PACK_MG definition
  */
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)   /* ARM Compiler V6 */
    #define __PACK_MG  __attribute__((packed))
#elif defined(__ICCARM__)                                       /* for IAR, iccarm */
    #define __PACK_MG
#elif defined ( __GNUC__ ) && !defined (__CC_ARM)               /* GNU Compiler */
    #define __PACK_MG  __attribute__((packed))
#else  
    #define __PACK_MG
#endif

#endif  // _MG32_H

/*----------------------------------------------------------------------------*/
/*                             End of file MG32.h                             */
/*----------------------------------------------------------------------------*/
