/**
 ******************************************************************************
 *
 * @file        MG32_RST.h
 *
 * @brief       MG32 RST Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_RST_H
#define _MG32_RST_H
#define _MG32_RST_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_RST_H_VER)
    #error "_MG32_RST_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      RST_Struct
 *              RST  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PORF          :1;     //[0] Power-on reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  SWF           :1;     //[1] Software forced reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  EXF           :1;     //[2] External input reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CPUF          :1;     //[3] CPU SYSRESETREQ bit system reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  BOD0F         :1;     //[4] BOD0 reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  BOD1F         :1;     //[5] BOD1 reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  LPMF          :1;     //[6] Low power mode reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  BOD2F         :1;     //[7] BOD2 reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CSCF          :1;     //[8] CSC missing clock detect reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  MEMF          :1;     //[10] Flash memory read/write protect or illegal address error reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  IWDTF         :1;     //[11] IWDT reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  WWDTF         :1;     //[12] WWDT reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  ADCF          :1;     //[13] ADC analog voltage watch-dog reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CMP0F         :1;     //[16] Comparator CMP0 threshold comparison reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CMP1F         :1;     //[17] Comparator CMP1 threshold comparison reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :6;     //[29..24] 
            __IO uint8_t  WRF           :1;     //[30] Warm reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CRF           :1;     //[31] Cold reset flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  RST Reset status register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x04]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] Reset key register
                                        //0 = Unprotected
                                        //1 = Protected
            __IO uint16_t LOCK          :16;    //[31..16] Reset lock register
                                        //0 = Unlocked
                                        //1 = Locked
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  RST write protected Key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  SW_EN         :1;     //[1] System software forced reset enable for whole chip reset
                                        //0 = No operation
                                        //1 = Generate reset
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  PA_DIS0       :1;     //[8] Warm reset disable for PA[3:0] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PA_DIS1       :1;     //[9] Warm reset disable for PA[11:8] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PB_DIS0       :1;     //[10] Warm reset disable for PB[3:0] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PB_DIS1       :1;     //[11] Warm reset disable for PB[11:8] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PC_DIS0       :1;     //[12] Warm reset disable for PC[3:0] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PC_DIS1       :1;     //[13] Warm reset disable for PC[11:8] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PD_DIS0       :1;     //[14] Warm reset disable for PD[3:0] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PD_DIS1       :1;     //[15] Warm reset disable for PD[11:8] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PE_DIS0       :1;     //[16] Warm reset disable for PE[3:0] pins
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PE_DIS1       :1;     //[17] Warm reset disable for PE[9:8] pins
                                        //0 = Enable
                                        //1 = Disable
            __I  uint8_t                :6;     //[23..18] 
            __IO uint8_t  WWDT_WDIS     :1;     //[24] WWDT module Warm reset disable bit
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  USB_RCTL      :1;     //[25] USB module software reset control
                                        //0 = All : USB Reset Level-0
                                        //1 = LV1 : USB Reset Level-1
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  RST control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  SW_CE         :1;     //[1] Software forced Cold reset enable. (This bit only reset by POR reset)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EX_CE         :1;     //[2] External input Cold reset enable. (This bit only reset by POR reset)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CPU_CE        :1;     //[3] CPU SYSRESETREQ bit forced Cold reset enable. (This bit only reset by POR reset)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD0_CE       :1;     //[4] BOD0 Cold reset enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD1_CE       :1;     //[5] BOD1 Cold reset enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LPM_CE        :1;     //[6] Low power STOP mode Cold reset enable. (This bit only reset by POR reset) 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD2_CE       :1;     //[7] BOD2 Cold reset enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CSC_CE        :1;     //[8] CSC missing clock detect Cold reset enable. (This bit only reset by POR reset) 
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  MEM_CE        :1;     //[10] Flash memory read/write protect or illegal address error Cold reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IWDT_CE       :1;     //[11] IWDT Cold reset enable. (This bit only reset by POR reset) 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WWDT_CE       :1;     //[12] WWDT Cold reset enable. (This bit only reset by POR reset) 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ADC_CE        :1;     //[13] ADC analog voltage watch-dog Cold reset enable. (This bit only reset by POR reset) 
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CMP0_CE       :1;     //[16] Comparator CMP0 threshold comparison Cold reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CMP1_CE       :1;     //[17] Comparator CMP1 threshold comparison Cold reset enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CE;                                /*!< CE         ~ Offset[0x14]  RST Cold reset enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  SW_WE         :1;     //[1] Software forced Warm reset enable. 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EX_WE         :1;     //[2] External input Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CPU_WE        :1;     //[3] CPU SYSRESETREQ bit forced Warm reset enable. 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD0_WE       :1;     //[4] BOD0 Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD1_WE       :1;     //[5] BOD1 Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LPM_WE        :1;     //[6] Low power STOP mode Warm reset enable.  
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD2_WE       :1;     //[7] BOD2 Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CSC_WE        :1;     //[8] CSC missing clock detect Warm reset enable.  
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  MEM_WE        :1;     //[10] Flash memory read/write protect or illegal address error Warm reset enable.  
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IWDT_WE       :1;     //[11] IWDT Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WWDT_WE       :1;     //[12] WWDT Warm reset enable.  
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ADC_WE        :1;     //[13] ADC analog voltage watch-dog Warm reset enable.  
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CMP0_WE       :1;     //[16] Comparator CMP0 threshold comparison Warm reset enable.   
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CMP1_WE       :1;     //[17] Comparator CMP1 threshold comparison Warm reset enable.  
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }WE;                                /*!< WE         ~ Offset[0x18]  RST Warm reset enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IOPA_EN       :1;     //[0] System software forced reset enable for IO Port-A.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  IOPB_EN       :1;     //[1] System software forced reset enable for IO Port-B.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  IOPC_EN       :1;     //[2] System software forced reset enable for IO Port-C.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  IOPD_EN       :1;     //[3] System software forced reset enable for IO Port-D.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  IOPE_EN       :1;     //[4] System software forced reset enable for IO Port-E.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  GPL_EN        :1;     //[8] System software forced reset enable for GPL module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :3;     //[11..9] 
            __IO uint8_t  EMB_EN        :1;     //[12] System software forced reset enable for EMB module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :1;     //[14] 
            __I  uint8_t                :1;     //[15] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }AHB;                               /*!< AHB        ~ Offset[0x1C]  RST AHB reset register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ADC0_EN       :1;     //[0] System software forced reset enable for ADC0 module.
                                        //0 = No operation
                                        //1 = Generate reset
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  CMP_EN        :1;     //[2] System software forced reset enable for CMP module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  DAC_EN        :1;     //[3] System software forced reset enable for DAC module.
                                        //0 = No operation
                                        //1 = Generate reset
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  RTC_EN        :1;     //[5] System software forced reset enable for RTC module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  IWDT_EN       :1;     //[6] System software forced reset enable for IWDT module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  WWDT_EN       :1;     //[7] System software forced reset enable for WWDT module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  I2C0_EN       :1;     //[8] System software forced reset enable for I2C0 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  I2C1_EN       :1;     //[9] System software forced reset enable for I2C1 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  SPI0_EN       :1;     //[12] System software forced reset enable for SP00 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  URT0_EN       :1;     //[16] System software forced reset enable for URT0 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  URT1_EN       :1;     //[17] System software forced reset enable for URT1 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  URT2_EN       :1;     //[18] System software forced reset enable for URT2 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  URT4_EN       :1;     //[20] System software forced reset enable for URT4 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  URT5_EN       :1;     //[21] System software forced reset enable for URT5 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  URT6_EN       :1;     //[22] System software forced reset enable for URT6 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  URT7_EN       :1;     //[23] System software forced reset enable for URT7 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :4;     //[27..24] 
            __IO uint8_t  USB_EN        :1;     //[28] System software forced reset enable for USB module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  APX_EN        :1;     //[29] System software forced reset enable for APB module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }APB0;                              /*!< APB0       ~ Offset[0x20]  RST APB reset register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TM00_EN       :1;     //[0] System software forced reset enable for TM00 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  TM01_EN       :1;     //[1] System software forced reset enable for TM01 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  TM10_EN       :1;     //[4] System software forced reset enable for TM10 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  TM16_EN       :1;     //[7] System software forced reset enable for TM16 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __IO uint8_t  TM20_EN       :1;     //[8] System software forced reset enable for TM20 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __IO uint8_t  TM26_EN       :1;     //[11] System software forced reset enable for TM26 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint8_t                :1;     //[12] 
            __I  uint8_t                :2;     //[14..13] 
            __IO uint8_t  TM36_EN       :1;     //[15] System software forced reset enable for TM36 module.
                                        //0 = No-Reset
                                        //1 = Reset
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }APB1;                              /*!< APB1       ~ Offset[0x24]  RST APB reset register 1 */

} RST_Struct;

/**
 ******************************************************************************
 *
 * @name        RST  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define RST_Base                        ((uint32_t)0x4C000000)              /*!< Reset Source Controller */
#define RST                             ((RST_Struct*) RST_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        RST  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        RST_STA  [register's definitions]
 *              Offset[0x00]  RST Reset status register (0x4C000000)
 ******************************************************************************
 */
///@{
#define RST_STA_default                             ((uint32_t)0xC0000001)  /*!< Reg Reset Default Value */

/* Bit fields of RST_STA */
#define RST_STA_CRF_mask_w                          ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define RST_STA_CRF_mask_h1                         ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define RST_STA_CRF_mask_b3                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_STA_CRF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_CRF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_CRF_normal_b3                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_CRF_happened_w                      ((uint32_t)0x80000000)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_CRF_happened_h1                     ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_CRF_happened_b3                     ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_WRF_mask_w                          ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define RST_STA_WRF_mask_h1                         ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define RST_STA_WRF_mask_b3                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_STA_WRF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_WRF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_WRF_normal_b3                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_WRF_happened_w                      ((uint32_t)0x40000000)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_WRF_happened_h1                     ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_WRF_happened_b3                     ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_CMP1F_mask_w                        ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define RST_STA_CMP1F_mask_h1                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_STA_CMP1F_mask_b2                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_STA_CMP1F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_CMP1F_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_CMP1F_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_CMP1F_happened_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_CMP1F_happened_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_CMP1F_happened_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_CMP0F_mask_w                        ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define RST_STA_CMP0F_mask_h1                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_STA_CMP0F_mask_b2                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_STA_CMP0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_CMP0F_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_CMP0F_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_CMP0F_happened_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_CMP0F_happened_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_CMP0F_happened_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_ADCF_mask_w                         ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define RST_STA_ADCF_mask_h0                        ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define RST_STA_ADCF_mask_b1                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_STA_ADCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_ADCF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_ADCF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_ADCF_happened_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_ADCF_happened_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_ADCF_happened_b1                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_WWDTF_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define RST_STA_WWDTF_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_STA_WWDTF_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_STA_WWDTF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_WWDTF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_WWDTF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_WWDTF_happened_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_WWDTF_happened_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_WWDTF_happened_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_IWDTF_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define RST_STA_IWDTF_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define RST_STA_IWDTF_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_STA_IWDTF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_IWDTF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_IWDTF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_IWDTF_happened_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_IWDTF_happened_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_IWDTF_happened_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_MEMF_mask_w                         ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define RST_STA_MEMF_mask_h0                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define RST_STA_MEMF_mask_b1                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_STA_MEMF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_MEMF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_MEMF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_MEMF_happened_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_MEMF_happened_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_MEMF_happened_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_CSCF_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_STA_CSCF_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_STA_CSCF_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_STA_CSCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_CSCF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_CSCF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_CSCF_happened_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_CSCF_happened_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_CSCF_happened_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_BOD2F_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define RST_STA_BOD2F_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RST_STA_BOD2F_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_STA_BOD2F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_BOD2F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_BOD2F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_BOD2F_happened_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_BOD2F_happened_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_BOD2F_happened_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_LPMF_mask_w                         ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define RST_STA_LPMF_mask_h0                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define RST_STA_LPMF_mask_b0                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_STA_LPMF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_LPMF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_LPMF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_LPMF_happened_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_LPMF_happened_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_LPMF_happened_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_BOD1F_mask_w                        ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define RST_STA_BOD1F_mask_h0                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RST_STA_BOD1F_mask_b0                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_STA_BOD1F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_BOD1F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_BOD1F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_BOD1F_happened_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_BOD1F_happened_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_BOD1F_happened_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_BOD0F_mask_w                        ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RST_STA_BOD0F_mask_h0                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RST_STA_BOD0F_mask_b0                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_STA_BOD0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_BOD0F_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_BOD0F_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_BOD0F_happened_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_BOD0F_happened_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_BOD0F_happened_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_CPUF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RST_STA_CPUF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RST_STA_CPUF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_STA_CPUF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_CPUF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_CPUF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_CPUF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_CPUF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_CPUF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_EXF_mask_w                          ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RST_STA_EXF_mask_h0                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RST_STA_EXF_mask_b0                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_STA_EXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_EXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_EXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_EXF_happened_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_EXF_happened_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_EXF_happened_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_SWF_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RST_STA_SWF_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_STA_SWF_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_STA_SWF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_SWF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_SWF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_SWF_happened_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_SWF_happened_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_SWF_happened_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define RST_STA_PORF_mask_w                         ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RST_STA_PORF_mask_h0                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_STA_PORF_mask_b0                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_STA_PORF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RST_STA_PORF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RST_STA_PORF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RST_STA_PORF_happened_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define RST_STA_PORF_happened_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define RST_STA_PORF_happened_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_KEY  [register's definitions]
 *              Offset[0x0C]  RST write protected Key register (0x4C00000C)
 ******************************************************************************
 */
///@{
#define RST_KEY_default                             ((uint32_t)0x00000001)  /*!< Reg Reset Default Value */

/* Bit fields of RST_KEY */
#define RST_KEY_LOCK_mask_w                         ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define RST_KEY_LOCK_mask_h1                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define RST_KEY_LOCK_unlocked_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unlocked of 32bit */
#define RST_KEY_LOCK_unlocked_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Unlocked of 16bit */
#define RST_KEY_LOCK_unlocked_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Unlocked of 8bit */
#define RST_KEY_LOCK_locked_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(1):Locked of 32bit */
#define RST_KEY_LOCK_locked_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(1):Locked of 16bit */
#define RST_KEY_LOCK_locked_b2                      ((uint8_t )0x01)        /*!< Bit Value =(1):Locked of 8bit */

#define RST_KEY_KEY_mask_w                          ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define RST_KEY_KEY_mask_h0                         ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define RST_KEY_KEY_unprotected_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define RST_KEY_KEY_unprotected_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define RST_KEY_KEY_unprotected_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define RST_KEY_KEY_protected_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define RST_KEY_KEY_protected_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define RST_KEY_KEY_protected_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_CR0  [register's definitions]
 *              Offset[0x10]  RST control register 0 (0x4C000010)
 ******************************************************************************
 */
///@{
#define RST_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RST_CR0 */
#define RST_CR0_USB_RCTL_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define RST_CR0_USB_RCTL_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define RST_CR0_USB_RCTL_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_CR0_USB_RCTL_all_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):All of 32bit */
#define RST_CR0_USB_RCTL_all_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):All of 16bit */
#define RST_CR0_USB_RCTL_all_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0):All of 8bit */
#define RST_CR0_USB_RCTL_lv1_w                      ((uint32_t)0x02000000)  /*!< Bit Value =(1):LV1 of 32bit */
#define RST_CR0_USB_RCTL_lv1_h1                     ((uint16_t)0x0200)      /*!< Bit Value =(1):LV1 of 16bit */
#define RST_CR0_USB_RCTL_lv1_b3                     ((uint8_t )0x02)        /*!< Bit Value =(1):LV1 of 8bit */

#define RST_CR0_WWDT_WDIS_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define RST_CR0_WWDT_WDIS_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_CR0_WWDT_WDIS_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_CR0_WWDT_WDIS_enable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_WWDT_WDIS_enable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_WWDT_WDIS_enable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_WWDT_WDIS_disable_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_WWDT_WDIS_disable_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_WWDT_WDIS_disable_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PE_DIS1_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define RST_CR0_PE_DIS1_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_CR0_PE_DIS1_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_CR0_PE_DIS1_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PE_DIS1_enable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PE_DIS1_enable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PE_DIS1_disable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PE_DIS1_disable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PE_DIS1_disable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PE_DIS0_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define RST_CR0_PE_DIS0_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_CR0_PE_DIS0_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_CR0_PE_DIS0_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PE_DIS0_enable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PE_DIS0_enable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PE_DIS0_disable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PE_DIS0_disable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PE_DIS0_disable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PD_DIS1_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define RST_CR0_PD_DIS1_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define RST_CR0_PD_DIS1_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_CR0_PD_DIS1_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PD_DIS1_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PD_DIS1_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PD_DIS1_disable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PD_DIS1_disable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PD_DIS1_disable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PD_DIS0_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define RST_CR0_PD_DIS0_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define RST_CR0_PD_DIS0_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_CR0_PD_DIS0_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PD_DIS0_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PD_DIS0_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PD_DIS0_disable_w                   ((uint32_t)0x00004000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PD_DIS0_disable_h0                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PD_DIS0_disable_b1                  ((uint8_t )0x40)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PC_DIS1_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define RST_CR0_PC_DIS1_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define RST_CR0_PC_DIS1_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_CR0_PC_DIS1_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PC_DIS1_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PC_DIS1_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PC_DIS1_disable_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PC_DIS1_disable_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PC_DIS1_disable_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PC_DIS0_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define RST_CR0_PC_DIS0_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_CR0_PC_DIS0_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_CR0_PC_DIS0_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PC_DIS0_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PC_DIS0_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PC_DIS0_disable_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PC_DIS0_disable_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PC_DIS0_disable_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PB_DIS1_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define RST_CR0_PB_DIS1_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define RST_CR0_PB_DIS1_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_CR0_PB_DIS1_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PB_DIS1_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PB_DIS1_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PB_DIS1_disable_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PB_DIS1_disable_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PB_DIS1_disable_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PB_DIS0_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define RST_CR0_PB_DIS0_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define RST_CR0_PB_DIS0_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_CR0_PB_DIS0_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PB_DIS0_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PB_DIS0_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PB_DIS0_disable_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PB_DIS0_disable_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PB_DIS0_disable_b1                  ((uint8_t )0x04)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PA_DIS1_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define RST_CR0_PA_DIS1_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define RST_CR0_PA_DIS1_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_CR0_PA_DIS1_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PA_DIS1_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PA_DIS1_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PA_DIS1_disable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PA_DIS1_disable_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PA_DIS1_disable_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_PA_DIS0_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_CR0_PA_DIS0_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_CR0_PA_DIS0_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_CR0_PA_DIS0_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define RST_CR0_PA_DIS0_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define RST_CR0_PA_DIS0_enable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define RST_CR0_PA_DIS0_disable_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Disable of 32bit */
#define RST_CR0_PA_DIS0_disable_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Disable of 16bit */
#define RST_CR0_PA_DIS0_disable_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Disable of 8bit */

#define RST_CR0_SW_EN_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RST_CR0_SW_EN_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_CR0_SW_EN_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_CR0_SW_EN_no_operation_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):No operation of 32bit */
#define RST_CR0_SW_EN_no_operation_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):No operation of 16bit */
#define RST_CR0_SW_EN_no_operation_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):No operation of 8bit */
#define RST_CR0_SW_EN_generate_reset_w              ((uint32_t)0x00000002)  /*!< Bit Value =(1):Generate reset of 32bit */
#define RST_CR0_SW_EN_generate_reset_h0             ((uint16_t)0x0002)      /*!< Bit Value =(1):Generate reset of 16bit */
#define RST_CR0_SW_EN_generate_reset_b0             ((uint8_t )0x02)        /*!< Bit Value =(1):Generate reset of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_CE  [register's definitions]
 *              Offset[0x14]  RST Cold reset enable register (0x4C000014)
 ******************************************************************************
 */
///@{
#define RST_CE_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RST_CE */
#define RST_CE_CMP1_CE_mask_w                       ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define RST_CE_CMP1_CE_mask_h1                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_CE_CMP1_CE_mask_b2                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_CE_CMP1_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_CMP1_CE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_CMP1_CE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_CMP1_CE_enable_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_CMP1_CE_enable_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_CMP1_CE_enable_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_CMP0_CE_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define RST_CE_CMP0_CE_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_CE_CMP0_CE_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_CE_CMP0_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_CMP0_CE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_CMP0_CE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_CMP0_CE_enable_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_CMP0_CE_enable_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_CMP0_CE_enable_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_ADC_CE_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define RST_CE_ADC_CE_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define RST_CE_ADC_CE_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_CE_ADC_CE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_ADC_CE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_ADC_CE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_ADC_CE_enable_w                      ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_ADC_CE_enable_h0                     ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_ADC_CE_enable_b1                     ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_WWDT_CE_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define RST_CE_WWDT_CE_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_CE_WWDT_CE_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_CE_WWDT_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_WWDT_CE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_WWDT_CE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_WWDT_CE_enable_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_WWDT_CE_enable_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_WWDT_CE_enable_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_IWDT_CE_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define RST_CE_IWDT_CE_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define RST_CE_IWDT_CE_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_CE_IWDT_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_IWDT_CE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_IWDT_CE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_IWDT_CE_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_IWDT_CE_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_IWDT_CE_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_MEM_CE_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define RST_CE_MEM_CE_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define RST_CE_MEM_CE_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_CE_MEM_CE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_MEM_CE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_MEM_CE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_MEM_CE_enable_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_MEM_CE_enable_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_MEM_CE_enable_b1                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_CSC_CE_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_CE_CSC_CE_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_CE_CSC_CE_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_CE_CSC_CE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_CSC_CE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_CSC_CE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_CSC_CE_enable_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_CSC_CE_enable_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_CSC_CE_enable_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_BOD2_CE_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define RST_CE_BOD2_CE_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RST_CE_BOD2_CE_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_CE_BOD2_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_BOD2_CE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_BOD2_CE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_BOD2_CE_enable_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_BOD2_CE_enable_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_BOD2_CE_enable_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_LPM_CE_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define RST_CE_LPM_CE_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define RST_CE_LPM_CE_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_CE_LPM_CE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_LPM_CE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_LPM_CE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_LPM_CE_enable_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_LPM_CE_enable_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_LPM_CE_enable_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_BOD1_CE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define RST_CE_BOD1_CE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RST_CE_BOD1_CE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_CE_BOD1_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_BOD1_CE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_BOD1_CE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_BOD1_CE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_BOD1_CE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_BOD1_CE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_BOD0_CE_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RST_CE_BOD0_CE_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RST_CE_BOD0_CE_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_CE_BOD0_CE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_BOD0_CE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_BOD0_CE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_BOD0_CE_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_BOD0_CE_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_BOD0_CE_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_CPU_CE_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RST_CE_CPU_CE_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RST_CE_CPU_CE_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_CE_CPU_CE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_CPU_CE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_CPU_CE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_CPU_CE_enable_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_CPU_CE_enable_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_CPU_CE_enable_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_EX_CE_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RST_CE_EX_CE_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RST_CE_EX_CE_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_CE_EX_CE_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_EX_CE_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_EX_CE_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_EX_CE_enable_w                       ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_EX_CE_enable_h0                      ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_EX_CE_enable_b0                      ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_CE_SW_CE_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RST_CE_SW_CE_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_CE_SW_CE_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_CE_SW_CE_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_CE_SW_CE_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_CE_SW_CE_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_CE_SW_CE_enable_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_CE_SW_CE_enable_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_CE_SW_CE_enable_b0                      ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_WE  [register's definitions]
 *              Offset[0x18]  RST Warm reset enable register (0x4C000018)
 ******************************************************************************
 */
///@{
#define RST_WE_default                              ((uint32_t)0x0000000E)  /*!< Reg Reset Default Value */

/* Bit fields of RST_WE */
#define RST_WE_CMP1_WE_mask_w                       ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define RST_WE_CMP1_WE_mask_h1                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_WE_CMP1_WE_mask_b2                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_WE_CMP1_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_CMP1_WE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_CMP1_WE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_CMP1_WE_enable_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_CMP1_WE_enable_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_CMP1_WE_enable_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_CMP0_WE_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define RST_WE_CMP0_WE_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_WE_CMP0_WE_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_WE_CMP0_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_CMP0_WE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_CMP0_WE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_CMP0_WE_enable_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_CMP0_WE_enable_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_CMP0_WE_enable_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_ADC_WE_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define RST_WE_ADC_WE_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define RST_WE_ADC_WE_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_WE_ADC_WE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_ADC_WE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_ADC_WE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_ADC_WE_enable_w                      ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_ADC_WE_enable_h0                     ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_ADC_WE_enable_b1                     ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_WWDT_WE_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define RST_WE_WWDT_WE_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_WE_WWDT_WE_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_WE_WWDT_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_WWDT_WE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_WWDT_WE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_WWDT_WE_enable_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_WWDT_WE_enable_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_WWDT_WE_enable_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_IWDT_WE_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define RST_WE_IWDT_WE_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define RST_WE_IWDT_WE_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_WE_IWDT_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_IWDT_WE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_IWDT_WE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_IWDT_WE_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_IWDT_WE_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_IWDT_WE_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_MEM_WE_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define RST_WE_MEM_WE_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define RST_WE_MEM_WE_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_WE_MEM_WE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_MEM_WE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_MEM_WE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_MEM_WE_enable_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_MEM_WE_enable_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_MEM_WE_enable_b1                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_CSC_WE_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_WE_CSC_WE_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_WE_CSC_WE_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_WE_CSC_WE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_CSC_WE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_CSC_WE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_CSC_WE_enable_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_CSC_WE_enable_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_CSC_WE_enable_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_BOD2_WE_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define RST_WE_BOD2_WE_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RST_WE_BOD2_WE_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_WE_BOD2_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_BOD2_WE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_BOD2_WE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_BOD2_WE_enable_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_BOD2_WE_enable_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_BOD2_WE_enable_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_LPM_WE_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define RST_WE_LPM_WE_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define RST_WE_LPM_WE_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_WE_LPM_WE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_LPM_WE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_LPM_WE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_LPM_WE_enable_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_LPM_WE_enable_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_LPM_WE_enable_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_BOD1_WE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define RST_WE_BOD1_WE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RST_WE_BOD1_WE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_WE_BOD1_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_BOD1_WE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_BOD1_WE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_BOD1_WE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_BOD1_WE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_BOD1_WE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_BOD0_WE_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RST_WE_BOD0_WE_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RST_WE_BOD0_WE_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_WE_BOD0_WE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_BOD0_WE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_BOD0_WE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_BOD0_WE_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_BOD0_WE_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_BOD0_WE_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_CPU_WE_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RST_WE_CPU_WE_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RST_WE_CPU_WE_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_WE_CPU_WE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_CPU_WE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_CPU_WE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_CPU_WE_enable_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_CPU_WE_enable_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_CPU_WE_enable_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_EX_WE_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RST_WE_EX_WE_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RST_WE_EX_WE_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_WE_EX_WE_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_EX_WE_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_EX_WE_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_EX_WE_enable_w                       ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_EX_WE_enable_h0                      ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_EX_WE_enable_b0                      ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define RST_WE_SW_WE_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RST_WE_SW_WE_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_WE_SW_WE_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_WE_SW_WE_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RST_WE_SW_WE_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RST_WE_SW_WE_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RST_WE_SW_WE_enable_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define RST_WE_SW_WE_enable_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RST_WE_SW_WE_enable_b0                      ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_AHB  [register's definitions]
 *              Offset[0x1C]  RST AHB reset register (0x4C00001C)
 ******************************************************************************
 */
///@{
#define RST_AHB_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RST_AHB */
#define RST_AHB_EMB_EN_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define RST_AHB_EMB_EN_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_AHB_EMB_EN_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_AHB_EMB_EN_no_reset_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_EMB_EN_no_reset_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_EMB_EN_no_reset_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_EMB_EN_reset_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_EMB_EN_reset_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_EMB_EN_reset_b1                     ((uint8_t )0x10)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_AHB_GPL_EN_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_AHB_GPL_EN_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_AHB_GPL_EN_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_AHB_GPL_EN_no_reset_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_GPL_EN_no_reset_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_GPL_EN_no_reset_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_GPL_EN_reset_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_GPL_EN_reset_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_GPL_EN_reset_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_AHB_IOPE_EN_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RST_AHB_IOPE_EN_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RST_AHB_IOPE_EN_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_AHB_IOPE_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_IOPE_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_IOPE_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_IOPE_EN_reset_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_IOPE_EN_reset_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_IOPE_EN_reset_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_AHB_IOPD_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RST_AHB_IOPD_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RST_AHB_IOPD_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_AHB_IOPD_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_IOPD_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_IOPD_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_IOPD_EN_reset_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_IOPD_EN_reset_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_IOPD_EN_reset_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_AHB_IOPC_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RST_AHB_IOPC_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RST_AHB_IOPC_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_AHB_IOPC_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_IOPC_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_IOPC_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_IOPC_EN_reset_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_IOPC_EN_reset_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_IOPC_EN_reset_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_AHB_IOPB_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RST_AHB_IOPB_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_AHB_IOPB_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_AHB_IOPB_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_IOPB_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_IOPB_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_IOPB_EN_reset_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_IOPB_EN_reset_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_IOPB_EN_reset_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_AHB_IOPA_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RST_AHB_IOPA_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_AHB_IOPA_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_AHB_IOPA_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_AHB_IOPA_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_AHB_IOPA_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_AHB_IOPA_EN_reset_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_AHB_IOPA_EN_reset_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_AHB_IOPA_EN_reset_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Reset of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_APB0  [register's definitions]
 *              Offset[0x20]  RST APB reset register 0 (0x4C000020)
 ******************************************************************************
 */
///@{
#define RST_APB0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RST_APB0 */
#define RST_APB0_APX_EN_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define RST_APB0_APX_EN_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define RST_APB0_APX_EN_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_APB0_APX_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_APX_EN_no_reset_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_APX_EN_no_reset_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_APX_EN_reset_w                     ((uint32_t)0x20000000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_APX_EN_reset_h1                    ((uint16_t)0x2000)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_APX_EN_reset_b3                    ((uint8_t )0x20)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_USB_EN_mask_w                      ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define RST_APB0_USB_EN_mask_h1                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_APB0_USB_EN_mask_b3                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_APB0_USB_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_USB_EN_no_reset_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_USB_EN_no_reset_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_USB_EN_reset_w                     ((uint32_t)0x10000000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_USB_EN_reset_h1                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_USB_EN_reset_b3                    ((uint8_t )0x10)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT7_EN_mask_w                     ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT7_EN_mask_h1                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT7_EN_mask_b2                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT7_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT7_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT7_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT7_EN_reset_w                    ((uint32_t)0x00800000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT7_EN_reset_h1                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT7_EN_reset_b2                   ((uint8_t )0x80)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT6_EN_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT6_EN_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT6_EN_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT6_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT6_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT6_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT6_EN_reset_w                    ((uint32_t)0x00400000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT6_EN_reset_h1                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT6_EN_reset_b2                   ((uint8_t )0x40)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT5_EN_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT5_EN_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT5_EN_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT5_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT5_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT5_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT5_EN_reset_w                    ((uint32_t)0x00200000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT5_EN_reset_h1                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT5_EN_reset_b2                   ((uint8_t )0x20)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT4_EN_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT4_EN_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT4_EN_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT4_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT4_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT4_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT4_EN_reset_w                    ((uint32_t)0x00100000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT4_EN_reset_h1                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT4_EN_reset_b2                   ((uint8_t )0x10)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT2_EN_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT2_EN_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT2_EN_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT2_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT2_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT2_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT2_EN_reset_w                    ((uint32_t)0x00040000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT2_EN_reset_h1                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT2_EN_reset_b2                   ((uint8_t )0x04)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT1_EN_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT1_EN_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT1_EN_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT1_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT1_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT1_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT1_EN_reset_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT1_EN_reset_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT1_EN_reset_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_URT0_EN_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define RST_APB0_URT0_EN_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_APB0_URT0_EN_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_APB0_URT0_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_URT0_EN_no_reset_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_URT0_EN_no_reset_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_URT0_EN_reset_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_URT0_EN_reset_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_URT0_EN_reset_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_SPI0_EN_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define RST_APB0_SPI0_EN_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define RST_APB0_SPI0_EN_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_APB0_SPI0_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_SPI0_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_SPI0_EN_no_reset_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_SPI0_EN_reset_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_SPI0_EN_reset_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_SPI0_EN_reset_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_I2C1_EN_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define RST_APB0_I2C1_EN_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define RST_APB0_I2C1_EN_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_APB0_I2C1_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_I2C1_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_I2C1_EN_no_reset_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_I2C1_EN_reset_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_I2C1_EN_reset_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_I2C1_EN_reset_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_I2C0_EN_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_APB0_I2C0_EN_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_APB0_I2C0_EN_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_APB0_I2C0_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_I2C0_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_I2C0_EN_no_reset_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_I2C0_EN_reset_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_I2C0_EN_reset_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_I2C0_EN_reset_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_WWDT_EN_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define RST_APB0_WWDT_EN_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RST_APB0_WWDT_EN_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_APB0_WWDT_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_WWDT_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_WWDT_EN_no_reset_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_WWDT_EN_reset_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_WWDT_EN_reset_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_WWDT_EN_reset_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_IWDT_EN_mask_w                     ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define RST_APB0_IWDT_EN_mask_h0                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define RST_APB0_IWDT_EN_mask_b0                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RST_APB0_IWDT_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_IWDT_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_IWDT_EN_no_reset_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_IWDT_EN_reset_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_IWDT_EN_reset_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_IWDT_EN_reset_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_RTC_EN_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define RST_APB0_RTC_EN_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RST_APB0_RTC_EN_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RST_APB0_RTC_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_RTC_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_RTC_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_RTC_EN_reset_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_RTC_EN_reset_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_RTC_EN_reset_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_DAC_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RST_APB0_DAC_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RST_APB0_DAC_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_APB0_DAC_EN_no_operation_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):No operation of 32bit */
#define RST_APB0_DAC_EN_no_operation_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):No operation of 16bit */
#define RST_APB0_DAC_EN_no_operation_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):No operation of 8bit */
#define RST_APB0_DAC_EN_generate_reset_w            ((uint32_t)0x00000008)  /*!< Bit Value =(1):Generate reset of 32bit */
#define RST_APB0_DAC_EN_generate_reset_h0           ((uint16_t)0x0008)      /*!< Bit Value =(1):Generate reset of 16bit */
#define RST_APB0_DAC_EN_generate_reset_b0           ((uint8_t )0x08)        /*!< Bit Value =(1):Generate reset of 8bit */

#define RST_APB0_CMP_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RST_APB0_CMP_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RST_APB0_CMP_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RST_APB0_CMP_EN_no_reset_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB0_CMP_EN_no_reset_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB0_CMP_EN_no_reset_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB0_CMP_EN_reset_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB0_CMP_EN_reset_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB0_CMP_EN_reset_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB0_ADC0_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RST_APB0_ADC0_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_APB0_ADC0_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_APB0_ADC0_EN_no_operation_w             ((uint32_t)0x00000000)  /*!< Bit Value =(0):No operation of 32bit */
#define RST_APB0_ADC0_EN_no_operation_h0            ((uint16_t)0x0000)      /*!< Bit Value =(0):No operation of 16bit */
#define RST_APB0_ADC0_EN_no_operation_b0            ((uint8_t )0x00)        /*!< Bit Value =(0):No operation of 8bit */
#define RST_APB0_ADC0_EN_generate_reset_w           ((uint32_t)0x00000001)  /*!< Bit Value =(1):Generate reset of 32bit */
#define RST_APB0_ADC0_EN_generate_reset_h0          ((uint16_t)0x0001)      /*!< Bit Value =(1):Generate reset of 16bit */
#define RST_APB0_ADC0_EN_generate_reset_b0          ((uint8_t )0x01)        /*!< Bit Value =(1):Generate reset of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RST_APB1  [register's definitions]
 *              Offset[0x24]  RST APB reset register 1 (0x4C000024)
 ******************************************************************************
 */
///@{
#define RST_APB1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RST_APB1 */
#define RST_APB1_TM36_EN_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM36_EN_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM36_EN_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM36_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM36_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM36_EN_no_reset_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM36_EN_reset_w                    ((uint32_t)0x00008000)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM36_EN_reset_h0                   ((uint16_t)0x8000)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM36_EN_reset_b1                   ((uint8_t )0x80)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB1_TM26_EN_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM26_EN_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM26_EN_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM26_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM26_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM26_EN_no_reset_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM26_EN_reset_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM26_EN_reset_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM26_EN_reset_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB1_TM20_EN_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM20_EN_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM20_EN_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM20_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM20_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM20_EN_no_reset_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM20_EN_reset_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM20_EN_reset_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM20_EN_reset_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB1_TM16_EN_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM16_EN_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM16_EN_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM16_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM16_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM16_EN_no_reset_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM16_EN_reset_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM16_EN_reset_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM16_EN_reset_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB1_TM10_EN_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM10_EN_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM10_EN_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM10_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM10_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM10_EN_no_reset_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM10_EN_reset_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM10_EN_reset_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM10_EN_reset_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB1_TM01_EN_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM01_EN_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM01_EN_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM01_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM01_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM01_EN_no_reset_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM01_EN_reset_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM01_EN_reset_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM01_EN_reset_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Reset of 8bit */

#define RST_APB1_TM00_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RST_APB1_TM00_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RST_APB1_TM00_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RST_APB1_TM00_EN_no_reset_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Reset of 32bit */
#define RST_APB1_TM00_EN_no_reset_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Reset of 16bit */
#define RST_APB1_TM00_EN_no_reset_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Reset of 8bit */
#define RST_APB1_TM00_EN_reset_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Reset of 32bit */
#define RST_APB1_TM00_EN_reset_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Reset of 16bit */
#define RST_APB1_TM00_EN_reset_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Reset of 8bit */

///@}

#endif  // _MG32_RST_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_RST.h                           */
/*----------------------------------------------------------------------------*/
