/**
 ******************************************************************************
 *
 * @file        MG32_APX.h
 *
 * @brief       MG32 APX Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_APX_H
#define _MG32_APX_H
#define _MG32_APX_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_APX_H_VER)
    #error "_MG32_APX_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      APX_Struct
 *              APX  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  SDTF4         :1;     //[12] SDT state procedures-4 detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  SDTF5         :1;     //[13] SDT state procedures-5 detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CCL0F         :1;     //[16] CCL-0 output low-to-high detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CCL1F         :1;     //[17] CCL-1 output low-to-high detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t  CCL0_OUT      :1;     //[24] CCL-0 output status bit.
            __I  uint8_t  CCL1_OUT      :1;     //[25] CCL-1 output status bit.
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  APB status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] APX interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[3..1] 
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  SDT_IE4       :1;     //[12] SDT state procedure-4 detect interrupt enable. (User definition mode procedure)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SDT_IE5       :1;     //[13] SDT state procedure-5 detect interrupt enable. (User definition mode procedure)
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CCL0_IE       :1;     //[16] CCL-0 output low-to-high detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CCL1_IE       :1;     //[17] CCL-1 output low-to-high detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  APX interrupt enable register */

    __I uint32_t  RESERVED0[6];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CCL0_EN       :1;     //[0] CCL enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  CCL0_TEN      :1;     //[1] CCL truth table enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  CCL0_FTSEL    :2;     //[5..4] CCL filter select.
                                        //0x0 = Disable
                                        //0x1 = SYNC : Synchronizer enabled
                                        //0x2 = FILTER : Filter enabled
                                        //0x3 = Reserved
            __IO uint8_t  CCL0_EDSEL    :2;     //[7..6] CCL edge detector mode select.
                                        //0x0 = Disable
                                        //0x1 = Rising
                                        //0x2 = Falling
                                        //0x3 = Dual-edge
            __IO uint8_t  CCL0_SQSEL    :3;     //[10..8] CCL sequential logic mode select.
                                        //0x0 = Disable
                                        //0x1 = DFF : D flip flop
                                        //0x2 = JK : JK flip flop
                                        //0x3 = DLH : D latch
                                        //0x4 = RS : RS latch
            __IO uint8_t  CCL0_INV      :1;     //[11] CCL output inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  CCL0_DIV      :2;     //[13..12] CCL internal clock input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CCL0_TRUTH    :8;     //[23..16] CCL lookup truth table output value definitions for mapping input states.
            __IO uint8_t  CCL0_SQIN     :2;     //[25..24] CCL sequential logic input CCL_S0 select.
                                        //0x0 = 0
                                        //0x1 = 1
                                        //0x2 = CCL_S1
                                        //0x3 = Reserved
            __I  uint8_t                :4;     //[29..26] 
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CCL00;                             /*!< CCL00      ~ Offset[0x20]  APX CCL0 control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CCL0_MUX0     :4;     //[3..0] CCL IN0 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PB11
                                        //0x4 = IN04 : PA8
                                        //0x5 = IN05 : PB0
                                        //0x6 = IN06 : PB8
                                        //0x7 = IN07 : PE0
                                        //0x8 = IN08 : CMP0_OUT
                                        //0x9 = IN09 : URT0_TX
                                        //0xA = IN0A : SPI0_MOSI (output for SPI master mode)
                                        //0xB = IN0B : TM36_OC00
                                        //0xC = IN0C : TM26_OC00
                                        //0xD = IN0D : SDT_I0
                                        //0xE = IN0E : OBM_P0
                                        //0xF = IN0F : Reserved
            __IO uint8_t  CCL0_MUX1     :4;     //[7..4] CCL IN1 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PB3
                                        //0x4 = IN04 : PA9
                                        //0x5 = IN05 : PB1
                                        //0x6 = IN06 : PB9
                                        //0x7 = IN07 : PE1
                                        //0x8 = IN08 : CMP1_OUT
                                        //0x9 = IN09 : URT1_TX
                                        //0xA = IN0A : SPI0_MISO (output for SPI slave mode)
                                        //0xB = IN0B : TM36_OC10
                                        //0xC = IN0C : TM26_OC10
                                        //0xD = IN0D : SDT_I1
                                        //0xE = IN0E : OBM_I0
                                        //0xF = IN0F : Reserved
            __IO uint8_t  CCL0_MUX2     :4;     //[11..8] CCL IN2 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PC1
                                        //0x4 = IN04 : PA10
                                        //0x5 = IN05 : PB2
                                        //0x6 = IN06 : PB10
                                        //0x7 = IN07 : PE2
                                        //0x8 = IN08 : ADC0_OUT
                                        //0x9 = IN09 : URT4_TX
                                        //0xA = IN0A : SPI0_CLK
                                        //0xB = IN0B : TM36_OC2
                                        //0xC = IN0C : TM20_OC00
                                        //0xD = IN0D : SDT_P0
                                        //0xE = IN0E : OBM_I1
                                        //0xF = IN0F : Reserved
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CCL01;                             /*!< CCL01      ~ Offset[0x24]  APX CCL0 control register-1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CCL1_EN       :1;     //[0] CCL enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  CCL1_TEN      :1;     //[1] CCL truth table enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  CCL1_FTSEL    :2;     //[5..4] CCL filter select.
                                        //0x0 = Disable
                                        //0x1 = SYNC : Synchronizer enabled
                                        //0x2 = FILTER : Filter enabled
                                        //0x3 = Reserved
            __IO uint8_t  CCL1_EDSEL    :2;     //[7..6] CCL edge detector mode select.
                                        //0x0 = Disable
                                        //0x1 = Rising
                                        //0x2 = Falling
                                        //0x3 = Dual-edge
            __IO uint8_t  CCL1_SQSEL    :3;     //[10..8] CCL sequential logic mode select.
                                        //0x0 = Disable
                                        //0x1 = DFF : D flip flop
                                        //0x2 = JK : JK flip flop
                                        //0x3 = DLH : D latch
                                        //0x4 = RS : RS latch
            __IO uint8_t  CCL1_INV      :1;     //[11] CCL output inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  CCL1_DIV      :2;     //[13..12] CCL internal clock input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CCL1_LUT      :8;     //[23..16] CCL lookup truth table output value definitions for mapping input states.
            __IO uint8_t  CCL1_SQIN     :2;     //[25..24] CCL sequential logic input CCL_S1 select.
                                        //0x0 = 0
                                        //0x1 = 1
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __I  uint8_t                :4;     //[29..26] 
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CCL10;                             /*!< CCL10      ~ Offset[0x28]  APX CCL1 control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CCL1_MUX0     :4;     //[3..0] CCL IN0 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PB11
                                        //0x4 = IN04 : PA8
                                        //0x5 = IN05 : PB0
                                        //0x6 = IN06 : PB8
                                        //0x7 = IN07 : PE0
                                        //0x8 = IN08 : CMP0_OUT
                                        //0x9 = IN09 : URT0_TX
                                        //0xA = IN0A : SPI0_MOSI (output)
                                        //0xB = IN0B : TM36_OC00
                                        //0xC = IN0C : TM26_OC00
                                        //0xD = IN0D : SDT_I0
                                        //0xE = IN0E : OBM_P0
                                        //0xF = IN0F : Reserved
            __IO uint8_t  CCL1_MUX1     :4;     //[7..4] CCL IN1 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PB3
                                        //0x4 = IN04 : PA9
                                        //0x5 = IN05 : PB1
                                        //0x6 = IN06 : PB9
                                        //0x7 = IN07 : PE1
                                        //0x8 = IN08 : CMP1_OUT
                                        //0x9 = IN09 : URT1_TX
                                        //0xA = IN0A : SPI0_MISO (output)
                                        //0xB = IN0B : TM36_OC10
                                        //0xC = IN0C : TM26_OC10
                                        //0xD = IN0D : SDT_I1
                                        //0xE = IN0E : OBM_I0
                                        //0xF = IN0F : Reserved
            __IO uint8_t  CCL1_MUX2     :4;     //[11..8] CCL IN2 input Mux select.
                                        //0x0 = Disable : Mask input
                                        //0x1 = IN01 : Feedback from CCLn_SEQ signal
                                        //0x2 = IN02 : Link from CCLn_AO signal
                                        //0x3 = IN03 : PC1
                                        //0x4 = IN04 : PA10
                                        //0x5 = IN05 : PB2
                                        //0x6 = IN06 : PB10
                                        //0x7 = IN07 : PE2
                                        //0x8 = IN08 : ADC0_OUT
                                        //0x9 = IN09 : URT4_TX
                                        //0xA = IN0A : SPI0_CLK
                                        //0xB = IN0B : TM36_OC2
                                        //0xC = IN0C : TM20_OC00
                                        //0xD = IN0D : SDT_P0
                                        //0xE = IN0E : OBM_I1
                                        //0xF = IN0F : Reserved
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CCL11;                             /*!< CCL11      ~ Offset[0x2C]  APX CCL1 control register-1 */

    __I uint32_t  RESERVED1[4];         /*!< RESERVED1  ~ Offset[0x30]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SDT_EN        :1;     //[0] SDT state detector enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  SDT_DIV       :2;     //[5..4] SDT internal clock input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  SDT_PMDS      :1;     //[7] SDT pin SDT_P0 output mode select.
                                        //0 = Normal : signal directly output
                                        //1 = Toggle : output toggle by detect event
            __IO uint8_t  SDT_PSEL      :4;     //[11..8] SDT output pin SDT_P0 source select.
                                        //0x0 = Reserved
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x3 = Reserved
                                        //0x4 = PROC4 : state procedure-4 detect event
                                        //0x5 = PROC5 : state procedure-5 detect event
                                        //0x6 = Reserved
                                        //0x7 = Reserved
                                        //0x8 = Reserved
                                        //0x9 = Reserved
                                        //0xA = Reserved
            __I  uint8_t                :4;     //[15..12] 
            __I  uint8_t                :3;     //[18..16] 
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :3;     //[22..20] 
            __I  uint8_t                :1;     //[23] 
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :5;     //[29..25] 
            __IO uint8_t  SDT_PSTA      :1;     //[30] SDT pin SDT_P0 output initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  SDT_LCK       :1;     //[31] APX_SDT_PSTA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
        }MBIT;
    }SDT0;                              /*!< SDT0       ~ Offset[0x40]  APX SDT control register-0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t SDT_P4S       :10;    //[9..0] SDT state procedure-4 detect input line state setting value.
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  SDT_P4E       :3;     //[14..12] SDT state procedure-4 detect end state index
            __I  uint8_t                :1;     //[15] 
            __IO uint16_t SDT_P5S       :10;    //[25..16] SDT state procedure-5 detect input line state setting value.
            __I  uint8_t                :2;     //[27..26] 
            __IO uint8_t  SDT_P5E       :3;     //[30..28] SDT state procedure-5 detect end state index
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }SDT1;                              /*!< SDT1       ~ Offset[0x44]  APX SDT control register-1 */

} APX_Struct;

/**
 ******************************************************************************
 *
 * @name        APX  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define APX_Base                        ((uint32_t)0x5F010000)              /*!< APB Module Extended Control */
#define APX                             ((APX_Struct*) APX_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        APX  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        APX_STA  [register's definitions]
 *              Offset[0x00]  APB status register (0x5F010000)
 ******************************************************************************
 */
///@{
#define APX_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_STA */
#define APX_STA_CCL1_OUT_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define APX_STA_CCL1_OUT_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define APX_STA_CCL1_OUT_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APX_STA_CCL1_OUT_shift_w                    (25)                    /*!< Bit Shift of 32bit */
#define APX_STA_CCL1_OUT_shift_h1                   (9)                     /*!< Bit Shift of 16bit */
#define APX_STA_CCL1_OUT_shift_b3                   (1)                     /*!< Bit Shift of 8bit */

#define APX_STA_CCL0_OUT_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define APX_STA_CCL0_OUT_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define APX_STA_CCL0_OUT_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_STA_CCL0_OUT_shift_w                    (24)                    /*!< Bit Shift of 32bit */
#define APX_STA_CCL0_OUT_shift_h1                   (8)                     /*!< Bit Shift of 16bit */
#define APX_STA_CCL0_OUT_shift_b3                   (0)                     /*!< Bit Shift of 8bit */

#define APX_STA_CCL1F_mask_w                        ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define APX_STA_CCL1F_mask_h1                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APX_STA_CCL1F_mask_b2                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APX_STA_CCL1F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APX_STA_CCL1F_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APX_STA_CCL1F_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APX_STA_CCL1F_happened_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define APX_STA_CCL1F_happened_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define APX_STA_CCL1F_happened_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define APX_STA_CCL0F_mask_w                        ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define APX_STA_CCL0F_mask_h1                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APX_STA_CCL0F_mask_b2                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_STA_CCL0F_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APX_STA_CCL0F_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APX_STA_CCL0F_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APX_STA_CCL0F_happened_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define APX_STA_CCL0F_happened_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define APX_STA_CCL0F_happened_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define APX_STA_SDTF5_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define APX_STA_SDTF5_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define APX_STA_SDTF5_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define APX_STA_SDTF5_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APX_STA_SDTF5_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APX_STA_SDTF5_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APX_STA_SDTF5_happened_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define APX_STA_SDTF5_happened_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define APX_STA_SDTF5_happened_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define APX_STA_SDTF4_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define APX_STA_SDTF4_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define APX_STA_SDTF4_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APX_STA_SDTF4_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APX_STA_SDTF4_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APX_STA_SDTF4_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APX_STA_SDTF4_happened_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define APX_STA_SDTF4_happened_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define APX_STA_SDTF4_happened_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_INT  [register's definitions]
 *              Offset[0x04]  APX interrupt enable register (0x5F010004)
 ******************************************************************************
 */
///@{
#define APX_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_INT */
#define APX_INT_CCL1_IE_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define APX_INT_CCL1_IE_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APX_INT_CCL1_IE_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APX_INT_CCL1_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_INT_CCL1_IE_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_INT_CCL1_IE_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_INT_CCL1_IE_enable_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_INT_CCL1_IE_enable_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_INT_CCL1_IE_enable_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_INT_CCL0_IE_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define APX_INT_CCL0_IE_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APX_INT_CCL0_IE_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_INT_CCL0_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_INT_CCL0_IE_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_INT_CCL0_IE_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_INT_CCL0_IE_enable_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_INT_CCL0_IE_enable_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_INT_CCL0_IE_enable_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_INT_SDT_IE5_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define APX_INT_SDT_IE5_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define APX_INT_SDT_IE5_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define APX_INT_SDT_IE5_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_INT_SDT_IE5_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_INT_SDT_IE5_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_INT_SDT_IE5_enable_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_INT_SDT_IE5_enable_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_INT_SDT_IE5_enable_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_INT_SDT_IE4_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define APX_INT_SDT_IE4_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define APX_INT_SDT_IE4_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define APX_INT_SDT_IE4_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_INT_SDT_IE4_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_INT_SDT_IE4_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_INT_SDT_IE4_enable_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_INT_SDT_IE4_enable_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_INT_SDT_IE4_enable_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APX_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APX_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_CCL00  [register's definitions]
 *              Offset[0x20]  APX CCL0 control register-0 (0x5F010020)
 ******************************************************************************
 */
///@{
#define APX_CCL00_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_CCL00 */
#define APX_CCL00_CCL0_SQIN_mask_w                  ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_SQIN_mask_h1                 ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_SQIN_mask_b3                 ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_SQIN_0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define APX_CCL00_CCL0_SQIN_0_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define APX_CCL00_CCL0_SQIN_0_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define APX_CCL00_CCL0_SQIN_1_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):1 of 32bit */
#define APX_CCL00_CCL0_SQIN_1_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(0x1):1 of 16bit */
#define APX_CCL00_CCL0_SQIN_1_b3                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):1 of 8bit */
#define APX_CCL00_CCL0_SQIN_ccl_s1_w                ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):CCL_S1 of 32bit */
#define APX_CCL00_CCL0_SQIN_ccl_s1_h1               ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CCL_S1 of 16bit */
#define APX_CCL00_CCL0_SQIN_ccl_s1_b3               ((uint8_t )0x02)        /*!< Bit Value =(0x2):CCL_S1 of 8bit */

#define APX_CCL00_CCL0_TRUTH_mask_w                 ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_TRUTH_mask_h1                ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_TRUTH_mask_b2                ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_TRUTH_shift_w                (16)                    /*!< Bit Shift of 32bit */
#define APX_CCL00_CCL0_TRUTH_shift_h1               (0)                     /*!< Bit Shift of 16bit */
#define APX_CCL00_CCL0_TRUTH_shift_b2               (0)                     /*!< Bit Shift of 8bit */

#define APX_CCL00_CCL0_DIV_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_DIV_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_DIV_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_DIV_div1_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define APX_CCL00_CCL0_DIV_div1_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define APX_CCL00_CCL0_DIV_div1_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define APX_CCL00_CCL0_DIV_div2_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define APX_CCL00_CCL0_DIV_div2_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define APX_CCL00_CCL0_DIV_div2_b1                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define APX_CCL00_CCL0_DIV_div4_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define APX_CCL00_CCL0_DIV_div4_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define APX_CCL00_CCL0_DIV_div4_b1                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define APX_CCL00_CCL0_DIV_div8_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define APX_CCL00_CCL0_DIV_div8_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define APX_CCL00_CCL0_DIV_div8_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define APX_CCL00_CCL0_INV_mask_w                   ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_INV_mask_h0                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_INV_mask_b1                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_INV_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_CCL00_CCL0_INV_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_CCL00_CCL0_INV_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_CCL00_CCL0_INV_enable_w                 ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_CCL00_CCL0_INV_enable_h0                ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_CCL00_CCL0_INV_enable_b1                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_CCL00_CCL0_SQSEL_mask_w                 ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_SQSEL_mask_h0                ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_SQSEL_mask_b1                ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_SQSEL_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL00_CCL0_SQSEL_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL00_CCL0_SQSEL_disable_b1             ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL00_CCL0_SQSEL_dff_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):DFF of 32bit */
#define APX_CCL00_CCL0_SQSEL_dff_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):DFF of 16bit */
#define APX_CCL00_CCL0_SQSEL_dff_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):DFF of 8bit */
#define APX_CCL00_CCL0_SQSEL_jk_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):JK of 32bit */
#define APX_CCL00_CCL0_SQSEL_jk_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):JK of 16bit */
#define APX_CCL00_CCL0_SQSEL_jk_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):JK of 8bit */
#define APX_CCL00_CCL0_SQSEL_dlh_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):DLH of 32bit */
#define APX_CCL00_CCL0_SQSEL_dlh_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):DLH of 16bit */
#define APX_CCL00_CCL0_SQSEL_dlh_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):DLH of 8bit */
#define APX_CCL00_CCL0_SQSEL_rs_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):RS of 32bit */
#define APX_CCL00_CCL0_SQSEL_rs_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):RS of 16bit */
#define APX_CCL00_CCL0_SQSEL_rs_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):RS of 8bit */

#define APX_CCL00_CCL0_EDSEL_mask_w                 ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_EDSEL_mask_h0                ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_EDSEL_mask_b0                ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_EDSEL_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL00_CCL0_EDSEL_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL00_CCL0_EDSEL_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL00_CCL0_EDSEL_rising_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Rising of 32bit */
#define APX_CCL00_CCL0_EDSEL_rising_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Rising of 16bit */
#define APX_CCL00_CCL0_EDSEL_rising_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Rising of 8bit */
#define APX_CCL00_CCL0_EDSEL_falling_w              ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Falling of 32bit */
#define APX_CCL00_CCL0_EDSEL_falling_h0             ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Falling of 16bit */
#define APX_CCL00_CCL0_EDSEL_falling_b0             ((uint8_t )0x80)        /*!< Bit Value =(0x2):Falling of 8bit */
#define APX_CCL00_CCL0_EDSEL_dual_edge_w            ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define APX_CCL00_CCL0_EDSEL_dual_edge_h0           ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define APX_CCL00_CCL0_EDSEL_dual_edge_b0           ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define APX_CCL00_CCL0_FTSEL_mask_w                 ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_FTSEL_mask_h0                ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_FTSEL_mask_b0                ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_FTSEL_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL00_CCL0_FTSEL_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL00_CCL0_FTSEL_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL00_CCL0_FTSEL_sync_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):SYNC of 32bit */
#define APX_CCL00_CCL0_FTSEL_sync_h0                ((uint16_t)0x0010)      /*!< Bit Value =(0x1):SYNC of 16bit */
#define APX_CCL00_CCL0_FTSEL_sync_b0                ((uint8_t )0x10)        /*!< Bit Value =(0x1):SYNC of 8bit */
#define APX_CCL00_CCL0_FTSEL_filter_w               ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):FILTER of 32bit */
#define APX_CCL00_CCL0_FTSEL_filter_h0              ((uint16_t)0x0020)      /*!< Bit Value =(0x2):FILTER of 16bit */
#define APX_CCL00_CCL0_FTSEL_filter_b0              ((uint8_t )0x20)        /*!< Bit Value =(0x2):FILTER of 8bit */

#define APX_CCL00_CCL0_TEN_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_TEN_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_TEN_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_TEN_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_CCL00_CCL0_TEN_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_CCL00_CCL0_TEN_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_CCL00_CCL0_TEN_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_CCL00_CCL0_TEN_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_CCL00_CCL0_TEN_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_CCL00_CCL0_EN_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APX_CCL00_CCL0_EN_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APX_CCL00_CCL0_EN_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_CCL00_CCL0_EN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_CCL00_CCL0_EN_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_CCL00_CCL0_EN_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_CCL00_CCL0_EN_enable_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_CCL00_CCL0_EN_enable_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_CCL00_CCL0_EN_enable_b0                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_CCL01  [register's definitions]
 *              Offset[0x24]  APX CCL0 control register-1 (0x5F010024)
 ******************************************************************************
 */
///@{
#define APX_CCL01_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_CCL01 */
#define APX_CCL01_CCL0_MUX2_mask_w                  ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define APX_CCL01_CCL0_MUX2_mask_h0                 ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define APX_CCL01_CCL0_MUX2_mask_b1                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APX_CCL01_CCL0_MUX2_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL01_CCL0_MUX2_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL01_CCL0_MUX2_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL01_CCL0_MUX2_in01_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):IN01 of 32bit */
#define APX_CCL01_CCL0_MUX2_in01_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):IN01 of 16bit */
#define APX_CCL01_CCL0_MUX2_in01_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):IN01 of 8bit */
#define APX_CCL01_CCL0_MUX2_in02_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):IN02 of 32bit */
#define APX_CCL01_CCL0_MUX2_in02_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(0x2):IN02 of 16bit */
#define APX_CCL01_CCL0_MUX2_in02_b1                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):IN02 of 8bit */
#define APX_CCL01_CCL0_MUX2_in03_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):IN03 of 32bit */
#define APX_CCL01_CCL0_MUX2_in03_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):IN03 of 16bit */
#define APX_CCL01_CCL0_MUX2_in03_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):IN03 of 8bit */
#define APX_CCL01_CCL0_MUX2_in04_w                  ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):IN04 of 32bit */
#define APX_CCL01_CCL0_MUX2_in04_h0                 ((uint16_t)0x0400)      /*!< Bit Value =(0x4):IN04 of 16bit */
#define APX_CCL01_CCL0_MUX2_in04_b1                 ((uint8_t )0x04)        /*!< Bit Value =(0x4):IN04 of 8bit */
#define APX_CCL01_CCL0_MUX2_in05_w                  ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):IN05 of 32bit */
#define APX_CCL01_CCL0_MUX2_in05_h0                 ((uint16_t)0x0500)      /*!< Bit Value =(0x5):IN05 of 16bit */
#define APX_CCL01_CCL0_MUX2_in05_b1                 ((uint8_t )0x05)        /*!< Bit Value =(0x5):IN05 of 8bit */
#define APX_CCL01_CCL0_MUX2_in06_w                  ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):IN06 of 32bit */
#define APX_CCL01_CCL0_MUX2_in06_h0                 ((uint16_t)0x0600)      /*!< Bit Value =(0x6):IN06 of 16bit */
#define APX_CCL01_CCL0_MUX2_in06_b1                 ((uint8_t )0x06)        /*!< Bit Value =(0x6):IN06 of 8bit */
#define APX_CCL01_CCL0_MUX2_in07_w                  ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):IN07 of 32bit */
#define APX_CCL01_CCL0_MUX2_in07_h0                 ((uint16_t)0x0700)      /*!< Bit Value =(0x7):IN07 of 16bit */
#define APX_CCL01_CCL0_MUX2_in07_b1                 ((uint8_t )0x07)        /*!< Bit Value =(0x7):IN07 of 8bit */
#define APX_CCL01_CCL0_MUX2_in08_w                  ((uint32_t)0x00000800)  /*!< Bit Value =(0x8):IN08 of 32bit */
#define APX_CCL01_CCL0_MUX2_in08_h0                 ((uint16_t)0x0800)      /*!< Bit Value =(0x8):IN08 of 16bit */
#define APX_CCL01_CCL0_MUX2_in08_b1                 ((uint8_t )0x08)        /*!< Bit Value =(0x8):IN08 of 8bit */
#define APX_CCL01_CCL0_MUX2_in09_w                  ((uint32_t)0x00000900)  /*!< Bit Value =(0x9):IN09 of 32bit */
#define APX_CCL01_CCL0_MUX2_in09_h0                 ((uint16_t)0x0900)      /*!< Bit Value =(0x9):IN09 of 16bit */
#define APX_CCL01_CCL0_MUX2_in09_b1                 ((uint8_t )0x09)        /*!< Bit Value =(0x9):IN09 of 8bit */
#define APX_CCL01_CCL0_MUX2_in0a_w                  ((uint32_t)0x00000A00)  /*!< Bit Value =(0xA):IN0A of 32bit */
#define APX_CCL01_CCL0_MUX2_in0a_h0                 ((uint16_t)0x0A00)      /*!< Bit Value =(0xA):IN0A of 16bit */
#define APX_CCL01_CCL0_MUX2_in0a_b1                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):IN0A of 8bit */
#define APX_CCL01_CCL0_MUX2_in0b_w                  ((uint32_t)0x00000B00)  /*!< Bit Value =(0xB):IN0B of 32bit */
#define APX_CCL01_CCL0_MUX2_in0b_h0                 ((uint16_t)0x0B00)      /*!< Bit Value =(0xB):IN0B of 16bit */
#define APX_CCL01_CCL0_MUX2_in0b_b1                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):IN0B of 8bit */
#define APX_CCL01_CCL0_MUX2_in0c_w                  ((uint32_t)0x00000C00)  /*!< Bit Value =(0xC):IN0C of 32bit */
#define APX_CCL01_CCL0_MUX2_in0c_h0                 ((uint16_t)0x0C00)      /*!< Bit Value =(0xC):IN0C of 16bit */
#define APX_CCL01_CCL0_MUX2_in0c_b1                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):IN0C of 8bit */
#define APX_CCL01_CCL0_MUX2_in0d_w                  ((uint32_t)0x00000D00)  /*!< Bit Value =(0xD):IN0D of 32bit */
#define APX_CCL01_CCL0_MUX2_in0d_h0                 ((uint16_t)0x0D00)      /*!< Bit Value =(0xD):IN0D of 16bit */
#define APX_CCL01_CCL0_MUX2_in0d_b1                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):IN0D of 8bit */
#define APX_CCL01_CCL0_MUX2_in0e_w                  ((uint32_t)0x00000E00)  /*!< Bit Value =(0xE):IN0E of 32bit */
#define APX_CCL01_CCL0_MUX2_in0e_h0                 ((uint16_t)0x0E00)      /*!< Bit Value =(0xE):IN0E of 16bit */
#define APX_CCL01_CCL0_MUX2_in0e_b1                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):IN0E of 8bit */
#define APX_CCL01_CCL0_MUX2_in0f_w                  ((uint32_t)0x00000F00)  /*!< Bit Value =(0xF):IN0F of 32bit */
#define APX_CCL01_CCL0_MUX2_in0f_h0                 ((uint16_t)0x0F00)      /*!< Bit Value =(0xF):IN0F of 16bit */
#define APX_CCL01_CCL0_MUX2_in0f_b1                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):IN0F of 8bit */

#define APX_CCL01_CCL0_MUX1_mask_w                  ((uint32_t)0x000000F0)  /*!< Bit Mask of 32bit */
#define APX_CCL01_CCL0_MUX1_mask_h0                 ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APX_CCL01_CCL0_MUX1_mask_b0                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APX_CCL01_CCL0_MUX1_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL01_CCL0_MUX1_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL01_CCL0_MUX1_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL01_CCL0_MUX1_in01_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):IN01 of 32bit */
#define APX_CCL01_CCL0_MUX1_in01_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(0x1):IN01 of 16bit */
#define APX_CCL01_CCL0_MUX1_in01_b0                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):IN01 of 8bit */
#define APX_CCL01_CCL0_MUX1_in02_w                  ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):IN02 of 32bit */
#define APX_CCL01_CCL0_MUX1_in02_h0                 ((uint16_t)0x0020)      /*!< Bit Value =(0x2):IN02 of 16bit */
#define APX_CCL01_CCL0_MUX1_in02_b0                 ((uint8_t )0x20)        /*!< Bit Value =(0x2):IN02 of 8bit */
#define APX_CCL01_CCL0_MUX1_in03_w                  ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):IN03 of 32bit */
#define APX_CCL01_CCL0_MUX1_in03_h0                 ((uint16_t)0x0030)      /*!< Bit Value =(0x3):IN03 of 16bit */
#define APX_CCL01_CCL0_MUX1_in03_b0                 ((uint8_t )0x30)        /*!< Bit Value =(0x3):IN03 of 8bit */
#define APX_CCL01_CCL0_MUX1_in04_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):IN04 of 32bit */
#define APX_CCL01_CCL0_MUX1_in04_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(0x4):IN04 of 16bit */
#define APX_CCL01_CCL0_MUX1_in04_b0                 ((uint8_t )0x40)        /*!< Bit Value =(0x4):IN04 of 8bit */
#define APX_CCL01_CCL0_MUX1_in05_w                  ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):IN05 of 32bit */
#define APX_CCL01_CCL0_MUX1_in05_h0                 ((uint16_t)0x0050)      /*!< Bit Value =(0x5):IN05 of 16bit */
#define APX_CCL01_CCL0_MUX1_in05_b0                 ((uint8_t )0x50)        /*!< Bit Value =(0x5):IN05 of 8bit */
#define APX_CCL01_CCL0_MUX1_in06_w                  ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):IN06 of 32bit */
#define APX_CCL01_CCL0_MUX1_in06_h0                 ((uint16_t)0x0060)      /*!< Bit Value =(0x6):IN06 of 16bit */
#define APX_CCL01_CCL0_MUX1_in06_b0                 ((uint8_t )0x60)        /*!< Bit Value =(0x6):IN06 of 8bit */
#define APX_CCL01_CCL0_MUX1_in07_w                  ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):IN07 of 32bit */
#define APX_CCL01_CCL0_MUX1_in07_h0                 ((uint16_t)0x0070)      /*!< Bit Value =(0x7):IN07 of 16bit */
#define APX_CCL01_CCL0_MUX1_in07_b0                 ((uint8_t )0x70)        /*!< Bit Value =(0x7):IN07 of 8bit */
#define APX_CCL01_CCL0_MUX1_in08_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(0x8):IN08 of 32bit */
#define APX_CCL01_CCL0_MUX1_in08_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(0x8):IN08 of 16bit */
#define APX_CCL01_CCL0_MUX1_in08_b0                 ((uint8_t )0x80)        /*!< Bit Value =(0x8):IN08 of 8bit */
#define APX_CCL01_CCL0_MUX1_in09_w                  ((uint32_t)0x00000090)  /*!< Bit Value =(0x9):IN09 of 32bit */
#define APX_CCL01_CCL0_MUX1_in09_h0                 ((uint16_t)0x0090)      /*!< Bit Value =(0x9):IN09 of 16bit */
#define APX_CCL01_CCL0_MUX1_in09_b0                 ((uint8_t )0x90)        /*!< Bit Value =(0x9):IN09 of 8bit */
#define APX_CCL01_CCL0_MUX1_in0a_w                  ((uint32_t)0x000000A0)  /*!< Bit Value =(0xA):IN0A of 32bit */
#define APX_CCL01_CCL0_MUX1_in0a_h0                 ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):IN0A of 16bit */
#define APX_CCL01_CCL0_MUX1_in0a_b0                 ((uint8_t )0xA0)        /*!< Bit Value =(0xA):IN0A of 8bit */
#define APX_CCL01_CCL0_MUX1_in0b_w                  ((uint32_t)0x000000B0)  /*!< Bit Value =(0xB):IN0B of 32bit */
#define APX_CCL01_CCL0_MUX1_in0b_h0                 ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):IN0B of 16bit */
#define APX_CCL01_CCL0_MUX1_in0b_b0                 ((uint8_t )0xB0)        /*!< Bit Value =(0xB):IN0B of 8bit */
#define APX_CCL01_CCL0_MUX1_in0c_w                  ((uint32_t)0x000000C0)  /*!< Bit Value =(0xC):IN0C of 32bit */
#define APX_CCL01_CCL0_MUX1_in0c_h0                 ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):IN0C of 16bit */
#define APX_CCL01_CCL0_MUX1_in0c_b0                 ((uint8_t )0xC0)        /*!< Bit Value =(0xC):IN0C of 8bit */
#define APX_CCL01_CCL0_MUX1_in0d_w                  ((uint32_t)0x000000D0)  /*!< Bit Value =(0xD):IN0D of 32bit */
#define APX_CCL01_CCL0_MUX1_in0d_h0                 ((uint16_t)0x00D0)      /*!< Bit Value =(0xD):IN0D of 16bit */
#define APX_CCL01_CCL0_MUX1_in0d_b0                 ((uint8_t )0xD0)        /*!< Bit Value =(0xD):IN0D of 8bit */
#define APX_CCL01_CCL0_MUX1_in0e_w                  ((uint32_t)0x000000E0)  /*!< Bit Value =(0xE):IN0E of 32bit */
#define APX_CCL01_CCL0_MUX1_in0e_h0                 ((uint16_t)0x00E0)      /*!< Bit Value =(0xE):IN0E of 16bit */
#define APX_CCL01_CCL0_MUX1_in0e_b0                 ((uint8_t )0xE0)        /*!< Bit Value =(0xE):IN0E of 8bit */
#define APX_CCL01_CCL0_MUX1_in0f_w                  ((uint32_t)0x000000F0)  /*!< Bit Value =(0xF):IN0F of 32bit */
#define APX_CCL01_CCL0_MUX1_in0f_h0                 ((uint16_t)0x00F0)      /*!< Bit Value =(0xF):IN0F of 16bit */
#define APX_CCL01_CCL0_MUX1_in0f_b0                 ((uint8_t )0xF0)        /*!< Bit Value =(0xF):IN0F of 8bit */

#define APX_CCL01_CCL0_MUX0_mask_w                  ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define APX_CCL01_CCL0_MUX0_mask_h0                 ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define APX_CCL01_CCL0_MUX0_mask_b0                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APX_CCL01_CCL0_MUX0_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL01_CCL0_MUX0_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL01_CCL0_MUX0_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL01_CCL0_MUX0_in01_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):IN01 of 32bit */
#define APX_CCL01_CCL0_MUX0_in01_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):IN01 of 16bit */
#define APX_CCL01_CCL0_MUX0_in01_b0                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):IN01 of 8bit */
#define APX_CCL01_CCL0_MUX0_in02_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):IN02 of 32bit */
#define APX_CCL01_CCL0_MUX0_in02_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(0x2):IN02 of 16bit */
#define APX_CCL01_CCL0_MUX0_in02_b0                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):IN02 of 8bit */
#define APX_CCL01_CCL0_MUX0_in03_w                  ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):IN03 of 32bit */
#define APX_CCL01_CCL0_MUX0_in03_h0                 ((uint16_t)0x0003)      /*!< Bit Value =(0x3):IN03 of 16bit */
#define APX_CCL01_CCL0_MUX0_in03_b0                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):IN03 of 8bit */
#define APX_CCL01_CCL0_MUX0_in04_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):IN04 of 32bit */
#define APX_CCL01_CCL0_MUX0_in04_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(0x4):IN04 of 16bit */
#define APX_CCL01_CCL0_MUX0_in04_b0                 ((uint8_t )0x04)        /*!< Bit Value =(0x4):IN04 of 8bit */
#define APX_CCL01_CCL0_MUX0_in05_w                  ((uint32_t)0x00000005)  /*!< Bit Value =(0x5):IN05 of 32bit */
#define APX_CCL01_CCL0_MUX0_in05_h0                 ((uint16_t)0x0005)      /*!< Bit Value =(0x5):IN05 of 16bit */
#define APX_CCL01_CCL0_MUX0_in05_b0                 ((uint8_t )0x05)        /*!< Bit Value =(0x5):IN05 of 8bit */
#define APX_CCL01_CCL0_MUX0_in06_w                  ((uint32_t)0x00000006)  /*!< Bit Value =(0x6):IN06 of 32bit */
#define APX_CCL01_CCL0_MUX0_in06_h0                 ((uint16_t)0x0006)      /*!< Bit Value =(0x6):IN06 of 16bit */
#define APX_CCL01_CCL0_MUX0_in06_b0                 ((uint8_t )0x06)        /*!< Bit Value =(0x6):IN06 of 8bit */
#define APX_CCL01_CCL0_MUX0_in07_w                  ((uint32_t)0x00000007)  /*!< Bit Value =(0x7):IN07 of 32bit */
#define APX_CCL01_CCL0_MUX0_in07_h0                 ((uint16_t)0x0007)      /*!< Bit Value =(0x7):IN07 of 16bit */
#define APX_CCL01_CCL0_MUX0_in07_b0                 ((uint8_t )0x07)        /*!< Bit Value =(0x7):IN07 of 8bit */
#define APX_CCL01_CCL0_MUX0_in08_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(0x8):IN08 of 32bit */
#define APX_CCL01_CCL0_MUX0_in08_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(0x8):IN08 of 16bit */
#define APX_CCL01_CCL0_MUX0_in08_b0                 ((uint8_t )0x08)        /*!< Bit Value =(0x8):IN08 of 8bit */
#define APX_CCL01_CCL0_MUX0_in09_w                  ((uint32_t)0x00000009)  /*!< Bit Value =(0x9):IN09 of 32bit */
#define APX_CCL01_CCL0_MUX0_in09_h0                 ((uint16_t)0x0009)      /*!< Bit Value =(0x9):IN09 of 16bit */
#define APX_CCL01_CCL0_MUX0_in09_b0                 ((uint8_t )0x09)        /*!< Bit Value =(0x9):IN09 of 8bit */
#define APX_CCL01_CCL0_MUX0_in0a_w                  ((uint32_t)0x0000000A)  /*!< Bit Value =(0xA):IN0A of 32bit */
#define APX_CCL01_CCL0_MUX0_in0a_h0                 ((uint16_t)0x000A)      /*!< Bit Value =(0xA):IN0A of 16bit */
#define APX_CCL01_CCL0_MUX0_in0a_b0                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):IN0A of 8bit */
#define APX_CCL01_CCL0_MUX0_in0b_w                  ((uint32_t)0x0000000B)  /*!< Bit Value =(0xB):IN0B of 32bit */
#define APX_CCL01_CCL0_MUX0_in0b_h0                 ((uint16_t)0x000B)      /*!< Bit Value =(0xB):IN0B of 16bit */
#define APX_CCL01_CCL0_MUX0_in0b_b0                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):IN0B of 8bit */
#define APX_CCL01_CCL0_MUX0_in0c_w                  ((uint32_t)0x0000000C)  /*!< Bit Value =(0xC):IN0C of 32bit */
#define APX_CCL01_CCL0_MUX0_in0c_h0                 ((uint16_t)0x000C)      /*!< Bit Value =(0xC):IN0C of 16bit */
#define APX_CCL01_CCL0_MUX0_in0c_b0                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):IN0C of 8bit */
#define APX_CCL01_CCL0_MUX0_in0d_w                  ((uint32_t)0x0000000D)  /*!< Bit Value =(0xD):IN0D of 32bit */
#define APX_CCL01_CCL0_MUX0_in0d_h0                 ((uint16_t)0x000D)      /*!< Bit Value =(0xD):IN0D of 16bit */
#define APX_CCL01_CCL0_MUX0_in0d_b0                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):IN0D of 8bit */
#define APX_CCL01_CCL0_MUX0_in0e_w                  ((uint32_t)0x0000000E)  /*!< Bit Value =(0xE):IN0E of 32bit */
#define APX_CCL01_CCL0_MUX0_in0e_h0                 ((uint16_t)0x000E)      /*!< Bit Value =(0xE):IN0E of 16bit */
#define APX_CCL01_CCL0_MUX0_in0e_b0                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):IN0E of 8bit */
#define APX_CCL01_CCL0_MUX0_in0f_w                  ((uint32_t)0x0000000F)  /*!< Bit Value =(0xF):IN0F of 32bit */
#define APX_CCL01_CCL0_MUX0_in0f_h0                 ((uint16_t)0x000F)      /*!< Bit Value =(0xF):IN0F of 16bit */
#define APX_CCL01_CCL0_MUX0_in0f_b0                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):IN0F of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_CCL10  [register's definitions]
 *              Offset[0x28]  APX CCL1 control register-0 (0x5F010028)
 ******************************************************************************
 */
///@{
#define APX_CCL10_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_CCL10 */
#define APX_CCL10_CCL1_SQIN_mask_w                  ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_SQIN_mask_h1                 ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_SQIN_mask_b3                 ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_SQIN_0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define APX_CCL10_CCL1_SQIN_0_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define APX_CCL10_CCL1_SQIN_0_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define APX_CCL10_CCL1_SQIN_1_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):1 of 32bit */
#define APX_CCL10_CCL1_SQIN_1_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(0x1):1 of 16bit */
#define APX_CCL10_CCL1_SQIN_1_b3                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):1 of 8bit */

#define APX_CCL10_CCL1_LUT_mask_w                   ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_LUT_mask_h1                  ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_LUT_mask_b2                  ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_LUT_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define APX_CCL10_CCL1_LUT_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define APX_CCL10_CCL1_LUT_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define APX_CCL10_CCL1_DIV_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_DIV_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_DIV_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_DIV_div1_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define APX_CCL10_CCL1_DIV_div1_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define APX_CCL10_CCL1_DIV_div1_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define APX_CCL10_CCL1_DIV_div2_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define APX_CCL10_CCL1_DIV_div2_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define APX_CCL10_CCL1_DIV_div2_b1                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define APX_CCL10_CCL1_DIV_div4_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define APX_CCL10_CCL1_DIV_div4_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define APX_CCL10_CCL1_DIV_div4_b1                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define APX_CCL10_CCL1_DIV_div8_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define APX_CCL10_CCL1_DIV_div8_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define APX_CCL10_CCL1_DIV_div8_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define APX_CCL10_CCL1_INV_mask_w                   ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_INV_mask_h0                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_INV_mask_b1                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_INV_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_CCL10_CCL1_INV_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_CCL10_CCL1_INV_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_CCL10_CCL1_INV_enable_w                 ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_CCL10_CCL1_INV_enable_h0                ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_CCL10_CCL1_INV_enable_b1                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_CCL10_CCL1_SQSEL_mask_w                 ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_SQSEL_mask_h0                ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_SQSEL_mask_b1                ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_SQSEL_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL10_CCL1_SQSEL_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL10_CCL1_SQSEL_disable_b1             ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL10_CCL1_SQSEL_dff_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):DFF of 32bit */
#define APX_CCL10_CCL1_SQSEL_dff_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):DFF of 16bit */
#define APX_CCL10_CCL1_SQSEL_dff_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):DFF of 8bit */
#define APX_CCL10_CCL1_SQSEL_jk_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):JK of 32bit */
#define APX_CCL10_CCL1_SQSEL_jk_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):JK of 16bit */
#define APX_CCL10_CCL1_SQSEL_jk_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):JK of 8bit */
#define APX_CCL10_CCL1_SQSEL_dlh_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):DLH of 32bit */
#define APX_CCL10_CCL1_SQSEL_dlh_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):DLH of 16bit */
#define APX_CCL10_CCL1_SQSEL_dlh_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):DLH of 8bit */
#define APX_CCL10_CCL1_SQSEL_rs_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):RS of 32bit */
#define APX_CCL10_CCL1_SQSEL_rs_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):RS of 16bit */
#define APX_CCL10_CCL1_SQSEL_rs_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):RS of 8bit */

#define APX_CCL10_CCL1_EDSEL_mask_w                 ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_EDSEL_mask_h0                ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_EDSEL_mask_b0                ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_EDSEL_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL10_CCL1_EDSEL_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL10_CCL1_EDSEL_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL10_CCL1_EDSEL_rising_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Rising of 32bit */
#define APX_CCL10_CCL1_EDSEL_rising_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Rising of 16bit */
#define APX_CCL10_CCL1_EDSEL_rising_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Rising of 8bit */
#define APX_CCL10_CCL1_EDSEL_falling_w              ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Falling of 32bit */
#define APX_CCL10_CCL1_EDSEL_falling_h0             ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Falling of 16bit */
#define APX_CCL10_CCL1_EDSEL_falling_b0             ((uint8_t )0x80)        /*!< Bit Value =(0x2):Falling of 8bit */
#define APX_CCL10_CCL1_EDSEL_dual_edge_w            ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define APX_CCL10_CCL1_EDSEL_dual_edge_h0           ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define APX_CCL10_CCL1_EDSEL_dual_edge_b0           ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define APX_CCL10_CCL1_FTSEL_mask_w                 ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_FTSEL_mask_h0                ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_FTSEL_mask_b0                ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_FTSEL_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL10_CCL1_FTSEL_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL10_CCL1_FTSEL_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL10_CCL1_FTSEL_sync_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):SYNC of 32bit */
#define APX_CCL10_CCL1_FTSEL_sync_h0                ((uint16_t)0x0010)      /*!< Bit Value =(0x1):SYNC of 16bit */
#define APX_CCL10_CCL1_FTSEL_sync_b0                ((uint8_t )0x10)        /*!< Bit Value =(0x1):SYNC of 8bit */
#define APX_CCL10_CCL1_FTSEL_filter_w               ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):FILTER of 32bit */
#define APX_CCL10_CCL1_FTSEL_filter_h0              ((uint16_t)0x0020)      /*!< Bit Value =(0x2):FILTER of 16bit */
#define APX_CCL10_CCL1_FTSEL_filter_b0              ((uint8_t )0x20)        /*!< Bit Value =(0x2):FILTER of 8bit */

#define APX_CCL10_CCL1_TEN_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_TEN_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_TEN_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_TEN_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_CCL10_CCL1_TEN_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_CCL10_CCL1_TEN_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_CCL10_CCL1_TEN_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_CCL10_CCL1_TEN_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_CCL10_CCL1_TEN_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define APX_CCL10_CCL1_EN_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APX_CCL10_CCL1_EN_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APX_CCL10_CCL1_EN_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_CCL10_CCL1_EN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_CCL10_CCL1_EN_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_CCL10_CCL1_EN_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_CCL10_CCL1_EN_enable_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_CCL10_CCL1_EN_enable_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_CCL10_CCL1_EN_enable_b0                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_CCL11  [register's definitions]
 *              Offset[0x2C]  APX CCL1 control register-1 (0x5F01002C)
 ******************************************************************************
 */
///@{
#define APX_CCL11_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_CCL11 */
#define APX_CCL11_CCL1_MUX2_mask_w                  ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define APX_CCL11_CCL1_MUX2_mask_h0                 ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define APX_CCL11_CCL1_MUX2_mask_b1                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APX_CCL11_CCL1_MUX2_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL11_CCL1_MUX2_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL11_CCL1_MUX2_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL11_CCL1_MUX2_in01_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):IN01 of 32bit */
#define APX_CCL11_CCL1_MUX2_in01_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):IN01 of 16bit */
#define APX_CCL11_CCL1_MUX2_in01_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):IN01 of 8bit */
#define APX_CCL11_CCL1_MUX2_in02_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):IN02 of 32bit */
#define APX_CCL11_CCL1_MUX2_in02_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(0x2):IN02 of 16bit */
#define APX_CCL11_CCL1_MUX2_in02_b1                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):IN02 of 8bit */
#define APX_CCL11_CCL1_MUX2_in03_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):IN03 of 32bit */
#define APX_CCL11_CCL1_MUX2_in03_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):IN03 of 16bit */
#define APX_CCL11_CCL1_MUX2_in03_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):IN03 of 8bit */
#define APX_CCL11_CCL1_MUX2_in04_w                  ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):IN04 of 32bit */
#define APX_CCL11_CCL1_MUX2_in04_h0                 ((uint16_t)0x0400)      /*!< Bit Value =(0x4):IN04 of 16bit */
#define APX_CCL11_CCL1_MUX2_in04_b1                 ((uint8_t )0x04)        /*!< Bit Value =(0x4):IN04 of 8bit */
#define APX_CCL11_CCL1_MUX2_in05_w                  ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):IN05 of 32bit */
#define APX_CCL11_CCL1_MUX2_in05_h0                 ((uint16_t)0x0500)      /*!< Bit Value =(0x5):IN05 of 16bit */
#define APX_CCL11_CCL1_MUX2_in05_b1                 ((uint8_t )0x05)        /*!< Bit Value =(0x5):IN05 of 8bit */
#define APX_CCL11_CCL1_MUX2_in06_w                  ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):IN06 of 32bit */
#define APX_CCL11_CCL1_MUX2_in06_h0                 ((uint16_t)0x0600)      /*!< Bit Value =(0x6):IN06 of 16bit */
#define APX_CCL11_CCL1_MUX2_in06_b1                 ((uint8_t )0x06)        /*!< Bit Value =(0x6):IN06 of 8bit */
#define APX_CCL11_CCL1_MUX2_in07_w                  ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):IN07 of 32bit */
#define APX_CCL11_CCL1_MUX2_in07_h0                 ((uint16_t)0x0700)      /*!< Bit Value =(0x7):IN07 of 16bit */
#define APX_CCL11_CCL1_MUX2_in07_b1                 ((uint8_t )0x07)        /*!< Bit Value =(0x7):IN07 of 8bit */
#define APX_CCL11_CCL1_MUX2_in08_w                  ((uint32_t)0x00000800)  /*!< Bit Value =(0x8):IN08 of 32bit */
#define APX_CCL11_CCL1_MUX2_in08_h0                 ((uint16_t)0x0800)      /*!< Bit Value =(0x8):IN08 of 16bit */
#define APX_CCL11_CCL1_MUX2_in08_b1                 ((uint8_t )0x08)        /*!< Bit Value =(0x8):IN08 of 8bit */
#define APX_CCL11_CCL1_MUX2_in09_w                  ((uint32_t)0x00000900)  /*!< Bit Value =(0x9):IN09 of 32bit */
#define APX_CCL11_CCL1_MUX2_in09_h0                 ((uint16_t)0x0900)      /*!< Bit Value =(0x9):IN09 of 16bit */
#define APX_CCL11_CCL1_MUX2_in09_b1                 ((uint8_t )0x09)        /*!< Bit Value =(0x9):IN09 of 8bit */
#define APX_CCL11_CCL1_MUX2_in0a_w                  ((uint32_t)0x00000A00)  /*!< Bit Value =(0xA):IN0A of 32bit */
#define APX_CCL11_CCL1_MUX2_in0a_h0                 ((uint16_t)0x0A00)      /*!< Bit Value =(0xA):IN0A of 16bit */
#define APX_CCL11_CCL1_MUX2_in0a_b1                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):IN0A of 8bit */
#define APX_CCL11_CCL1_MUX2_in0b_w                  ((uint32_t)0x00000B00)  /*!< Bit Value =(0xB):IN0B of 32bit */
#define APX_CCL11_CCL1_MUX2_in0b_h0                 ((uint16_t)0x0B00)      /*!< Bit Value =(0xB):IN0B of 16bit */
#define APX_CCL11_CCL1_MUX2_in0b_b1                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):IN0B of 8bit */
#define APX_CCL11_CCL1_MUX2_in0c_w                  ((uint32_t)0x00000C00)  /*!< Bit Value =(0xC):IN0C of 32bit */
#define APX_CCL11_CCL1_MUX2_in0c_h0                 ((uint16_t)0x0C00)      /*!< Bit Value =(0xC):IN0C of 16bit */
#define APX_CCL11_CCL1_MUX2_in0c_b1                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):IN0C of 8bit */
#define APX_CCL11_CCL1_MUX2_in0d_w                  ((uint32_t)0x00000D00)  /*!< Bit Value =(0xD):IN0D of 32bit */
#define APX_CCL11_CCL1_MUX2_in0d_h0                 ((uint16_t)0x0D00)      /*!< Bit Value =(0xD):IN0D of 16bit */
#define APX_CCL11_CCL1_MUX2_in0d_b1                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):IN0D of 8bit */
#define APX_CCL11_CCL1_MUX2_in0e_w                  ((uint32_t)0x00000E00)  /*!< Bit Value =(0xE):IN0E of 32bit */
#define APX_CCL11_CCL1_MUX2_in0e_h0                 ((uint16_t)0x0E00)      /*!< Bit Value =(0xE):IN0E of 16bit */
#define APX_CCL11_CCL1_MUX2_in0e_b1                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):IN0E of 8bit */
#define APX_CCL11_CCL1_MUX2_in0f_w                  ((uint32_t)0x00000F00)  /*!< Bit Value =(0xF):IN0F of 32bit */
#define APX_CCL11_CCL1_MUX2_in0f_h0                 ((uint16_t)0x0F00)      /*!< Bit Value =(0xF):IN0F of 16bit */
#define APX_CCL11_CCL1_MUX2_in0f_b1                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):IN0F of 8bit */

#define APX_CCL11_CCL1_MUX1_mask_w                  ((uint32_t)0x000000F0)  /*!< Bit Mask of 32bit */
#define APX_CCL11_CCL1_MUX1_mask_h0                 ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define APX_CCL11_CCL1_MUX1_mask_b0                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define APX_CCL11_CCL1_MUX1_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL11_CCL1_MUX1_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL11_CCL1_MUX1_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL11_CCL1_MUX1_in01_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):IN01 of 32bit */
#define APX_CCL11_CCL1_MUX1_in01_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(0x1):IN01 of 16bit */
#define APX_CCL11_CCL1_MUX1_in01_b0                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):IN01 of 8bit */
#define APX_CCL11_CCL1_MUX1_in02_w                  ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):IN02 of 32bit */
#define APX_CCL11_CCL1_MUX1_in02_h0                 ((uint16_t)0x0020)      /*!< Bit Value =(0x2):IN02 of 16bit */
#define APX_CCL11_CCL1_MUX1_in02_b0                 ((uint8_t )0x20)        /*!< Bit Value =(0x2):IN02 of 8bit */
#define APX_CCL11_CCL1_MUX1_in03_w                  ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):IN03 of 32bit */
#define APX_CCL11_CCL1_MUX1_in03_h0                 ((uint16_t)0x0030)      /*!< Bit Value =(0x3):IN03 of 16bit */
#define APX_CCL11_CCL1_MUX1_in03_b0                 ((uint8_t )0x30)        /*!< Bit Value =(0x3):IN03 of 8bit */
#define APX_CCL11_CCL1_MUX1_in04_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):IN04 of 32bit */
#define APX_CCL11_CCL1_MUX1_in04_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(0x4):IN04 of 16bit */
#define APX_CCL11_CCL1_MUX1_in04_b0                 ((uint8_t )0x40)        /*!< Bit Value =(0x4):IN04 of 8bit */
#define APX_CCL11_CCL1_MUX1_in05_w                  ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):IN05 of 32bit */
#define APX_CCL11_CCL1_MUX1_in05_h0                 ((uint16_t)0x0050)      /*!< Bit Value =(0x5):IN05 of 16bit */
#define APX_CCL11_CCL1_MUX1_in05_b0                 ((uint8_t )0x50)        /*!< Bit Value =(0x5):IN05 of 8bit */
#define APX_CCL11_CCL1_MUX1_in06_w                  ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):IN06 of 32bit */
#define APX_CCL11_CCL1_MUX1_in06_h0                 ((uint16_t)0x0060)      /*!< Bit Value =(0x6):IN06 of 16bit */
#define APX_CCL11_CCL1_MUX1_in06_b0                 ((uint8_t )0x60)        /*!< Bit Value =(0x6):IN06 of 8bit */
#define APX_CCL11_CCL1_MUX1_in07_w                  ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):IN07 of 32bit */
#define APX_CCL11_CCL1_MUX1_in07_h0                 ((uint16_t)0x0070)      /*!< Bit Value =(0x7):IN07 of 16bit */
#define APX_CCL11_CCL1_MUX1_in07_b0                 ((uint8_t )0x70)        /*!< Bit Value =(0x7):IN07 of 8bit */
#define APX_CCL11_CCL1_MUX1_in08_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(0x8):IN08 of 32bit */
#define APX_CCL11_CCL1_MUX1_in08_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(0x8):IN08 of 16bit */
#define APX_CCL11_CCL1_MUX1_in08_b0                 ((uint8_t )0x80)        /*!< Bit Value =(0x8):IN08 of 8bit */
#define APX_CCL11_CCL1_MUX1_in09_w                  ((uint32_t)0x00000090)  /*!< Bit Value =(0x9):IN09 of 32bit */
#define APX_CCL11_CCL1_MUX1_in09_h0                 ((uint16_t)0x0090)      /*!< Bit Value =(0x9):IN09 of 16bit */
#define APX_CCL11_CCL1_MUX1_in09_b0                 ((uint8_t )0x90)        /*!< Bit Value =(0x9):IN09 of 8bit */
#define APX_CCL11_CCL1_MUX1_in0a_w                  ((uint32_t)0x000000A0)  /*!< Bit Value =(0xA):IN0A of 32bit */
#define APX_CCL11_CCL1_MUX1_in0a_h0                 ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):IN0A of 16bit */
#define APX_CCL11_CCL1_MUX1_in0a_b0                 ((uint8_t )0xA0)        /*!< Bit Value =(0xA):IN0A of 8bit */
#define APX_CCL11_CCL1_MUX1_in0b_w                  ((uint32_t)0x000000B0)  /*!< Bit Value =(0xB):IN0B of 32bit */
#define APX_CCL11_CCL1_MUX1_in0b_h0                 ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):IN0B of 16bit */
#define APX_CCL11_CCL1_MUX1_in0b_b0                 ((uint8_t )0xB0)        /*!< Bit Value =(0xB):IN0B of 8bit */
#define APX_CCL11_CCL1_MUX1_in0c_w                  ((uint32_t)0x000000C0)  /*!< Bit Value =(0xC):IN0C of 32bit */
#define APX_CCL11_CCL1_MUX1_in0c_h0                 ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):IN0C of 16bit */
#define APX_CCL11_CCL1_MUX1_in0c_b0                 ((uint8_t )0xC0)        /*!< Bit Value =(0xC):IN0C of 8bit */
#define APX_CCL11_CCL1_MUX1_in0d_w                  ((uint32_t)0x000000D0)  /*!< Bit Value =(0xD):IN0D of 32bit */
#define APX_CCL11_CCL1_MUX1_in0d_h0                 ((uint16_t)0x00D0)      /*!< Bit Value =(0xD):IN0D of 16bit */
#define APX_CCL11_CCL1_MUX1_in0d_b0                 ((uint8_t )0xD0)        /*!< Bit Value =(0xD):IN0D of 8bit */
#define APX_CCL11_CCL1_MUX1_in0e_w                  ((uint32_t)0x000000E0)  /*!< Bit Value =(0xE):IN0E of 32bit */
#define APX_CCL11_CCL1_MUX1_in0e_h0                 ((uint16_t)0x00E0)      /*!< Bit Value =(0xE):IN0E of 16bit */
#define APX_CCL11_CCL1_MUX1_in0e_b0                 ((uint8_t )0xE0)        /*!< Bit Value =(0xE):IN0E of 8bit */
#define APX_CCL11_CCL1_MUX1_in0f_w                  ((uint32_t)0x000000F0)  /*!< Bit Value =(0xF):IN0F of 32bit */
#define APX_CCL11_CCL1_MUX1_in0f_h0                 ((uint16_t)0x00F0)      /*!< Bit Value =(0xF):IN0F of 16bit */
#define APX_CCL11_CCL1_MUX1_in0f_b0                 ((uint8_t )0xF0)        /*!< Bit Value =(0xF):IN0F of 8bit */

#define APX_CCL11_CCL1_MUX0_mask_w                  ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define APX_CCL11_CCL1_MUX0_mask_h0                 ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define APX_CCL11_CCL1_MUX0_mask_b0                 ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APX_CCL11_CCL1_MUX0_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define APX_CCL11_CCL1_MUX0_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define APX_CCL11_CCL1_MUX0_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define APX_CCL11_CCL1_MUX0_in01_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):IN01 of 32bit */
#define APX_CCL11_CCL1_MUX0_in01_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):IN01 of 16bit */
#define APX_CCL11_CCL1_MUX0_in01_b0                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):IN01 of 8bit */
#define APX_CCL11_CCL1_MUX0_in02_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):IN02 of 32bit */
#define APX_CCL11_CCL1_MUX0_in02_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(0x2):IN02 of 16bit */
#define APX_CCL11_CCL1_MUX0_in02_b0                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):IN02 of 8bit */
#define APX_CCL11_CCL1_MUX0_in03_w                  ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):IN03 of 32bit */
#define APX_CCL11_CCL1_MUX0_in03_h0                 ((uint16_t)0x0003)      /*!< Bit Value =(0x3):IN03 of 16bit */
#define APX_CCL11_CCL1_MUX0_in03_b0                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):IN03 of 8bit */
#define APX_CCL11_CCL1_MUX0_in04_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):IN04 of 32bit */
#define APX_CCL11_CCL1_MUX0_in04_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(0x4):IN04 of 16bit */
#define APX_CCL11_CCL1_MUX0_in04_b0                 ((uint8_t )0x04)        /*!< Bit Value =(0x4):IN04 of 8bit */
#define APX_CCL11_CCL1_MUX0_in05_w                  ((uint32_t)0x00000005)  /*!< Bit Value =(0x5):IN05 of 32bit */
#define APX_CCL11_CCL1_MUX0_in05_h0                 ((uint16_t)0x0005)      /*!< Bit Value =(0x5):IN05 of 16bit */
#define APX_CCL11_CCL1_MUX0_in05_b0                 ((uint8_t )0x05)        /*!< Bit Value =(0x5):IN05 of 8bit */
#define APX_CCL11_CCL1_MUX0_in06_w                  ((uint32_t)0x00000006)  /*!< Bit Value =(0x6):IN06 of 32bit */
#define APX_CCL11_CCL1_MUX0_in06_h0                 ((uint16_t)0x0006)      /*!< Bit Value =(0x6):IN06 of 16bit */
#define APX_CCL11_CCL1_MUX0_in06_b0                 ((uint8_t )0x06)        /*!< Bit Value =(0x6):IN06 of 8bit */
#define APX_CCL11_CCL1_MUX0_in07_w                  ((uint32_t)0x00000007)  /*!< Bit Value =(0x7):IN07 of 32bit */
#define APX_CCL11_CCL1_MUX0_in07_h0                 ((uint16_t)0x0007)      /*!< Bit Value =(0x7):IN07 of 16bit */
#define APX_CCL11_CCL1_MUX0_in07_b0                 ((uint8_t )0x07)        /*!< Bit Value =(0x7):IN07 of 8bit */
#define APX_CCL11_CCL1_MUX0_in08_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(0x8):IN08 of 32bit */
#define APX_CCL11_CCL1_MUX0_in08_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(0x8):IN08 of 16bit */
#define APX_CCL11_CCL1_MUX0_in08_b0                 ((uint8_t )0x08)        /*!< Bit Value =(0x8):IN08 of 8bit */
#define APX_CCL11_CCL1_MUX0_in09_w                  ((uint32_t)0x00000009)  /*!< Bit Value =(0x9):IN09 of 32bit */
#define APX_CCL11_CCL1_MUX0_in09_h0                 ((uint16_t)0x0009)      /*!< Bit Value =(0x9):IN09 of 16bit */
#define APX_CCL11_CCL1_MUX0_in09_b0                 ((uint8_t )0x09)        /*!< Bit Value =(0x9):IN09 of 8bit */
#define APX_CCL11_CCL1_MUX0_in0a_w                  ((uint32_t)0x0000000A)  /*!< Bit Value =(0xA):IN0A of 32bit */
#define APX_CCL11_CCL1_MUX0_in0a_h0                 ((uint16_t)0x000A)      /*!< Bit Value =(0xA):IN0A of 16bit */
#define APX_CCL11_CCL1_MUX0_in0a_b0                 ((uint8_t )0x0A)        /*!< Bit Value =(0xA):IN0A of 8bit */
#define APX_CCL11_CCL1_MUX0_in0b_w                  ((uint32_t)0x0000000B)  /*!< Bit Value =(0xB):IN0B of 32bit */
#define APX_CCL11_CCL1_MUX0_in0b_h0                 ((uint16_t)0x000B)      /*!< Bit Value =(0xB):IN0B of 16bit */
#define APX_CCL11_CCL1_MUX0_in0b_b0                 ((uint8_t )0x0B)        /*!< Bit Value =(0xB):IN0B of 8bit */
#define APX_CCL11_CCL1_MUX0_in0c_w                  ((uint32_t)0x0000000C)  /*!< Bit Value =(0xC):IN0C of 32bit */
#define APX_CCL11_CCL1_MUX0_in0c_h0                 ((uint16_t)0x000C)      /*!< Bit Value =(0xC):IN0C of 16bit */
#define APX_CCL11_CCL1_MUX0_in0c_b0                 ((uint8_t )0x0C)        /*!< Bit Value =(0xC):IN0C of 8bit */
#define APX_CCL11_CCL1_MUX0_in0d_w                  ((uint32_t)0x0000000D)  /*!< Bit Value =(0xD):IN0D of 32bit */
#define APX_CCL11_CCL1_MUX0_in0d_h0                 ((uint16_t)0x000D)      /*!< Bit Value =(0xD):IN0D of 16bit */
#define APX_CCL11_CCL1_MUX0_in0d_b0                 ((uint8_t )0x0D)        /*!< Bit Value =(0xD):IN0D of 8bit */
#define APX_CCL11_CCL1_MUX0_in0e_w                  ((uint32_t)0x0000000E)  /*!< Bit Value =(0xE):IN0E of 32bit */
#define APX_CCL11_CCL1_MUX0_in0e_h0                 ((uint16_t)0x000E)      /*!< Bit Value =(0xE):IN0E of 16bit */
#define APX_CCL11_CCL1_MUX0_in0e_b0                 ((uint8_t )0x0E)        /*!< Bit Value =(0xE):IN0E of 8bit */
#define APX_CCL11_CCL1_MUX0_in0f_w                  ((uint32_t)0x0000000F)  /*!< Bit Value =(0xF):IN0F of 32bit */
#define APX_CCL11_CCL1_MUX0_in0f_h0                 ((uint16_t)0x000F)      /*!< Bit Value =(0xF):IN0F of 16bit */
#define APX_CCL11_CCL1_MUX0_in0f_b0                 ((uint8_t )0x0F)        /*!< Bit Value =(0xF):IN0F of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_SDT0  [register's definitions]
 *              Offset[0x40]  APX SDT control register-0 (0x5F010040)
 ******************************************************************************
 */
///@{
#define APX_SDT0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_SDT0 */
#define APX_SDT0_SDT_LCK_mask_w                     ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define APX_SDT0_SDT_LCK_mask_h1                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define APX_SDT0_SDT_LCK_mask_b3                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define APX_SDT0_SDT_LCK_locked_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define APX_SDT0_SDT_LCK_locked_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define APX_SDT0_SDT_LCK_locked_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define APX_SDT0_SDT_LCK_un_locked_w                ((uint32_t)0x80000000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define APX_SDT0_SDT_LCK_un_locked_h1               ((uint16_t)0x8000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define APX_SDT0_SDT_LCK_un_locked_b3               ((uint8_t )0x80)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define APX_SDT0_SDT_PSTA_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define APX_SDT0_SDT_PSTA_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define APX_SDT0_SDT_PSTA_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define APX_SDT0_SDT_PSTA_0_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define APX_SDT0_SDT_PSTA_0_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define APX_SDT0_SDT_PSTA_0_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define APX_SDT0_SDT_PSTA_1_w                       ((uint32_t)0x40000000)  /*!< Bit Value =(1):1 of 32bit */
#define APX_SDT0_SDT_PSTA_1_h1                      ((uint16_t)0x4000)      /*!< Bit Value =(1):1 of 16bit */
#define APX_SDT0_SDT_PSTA_1_b3                      ((uint8_t )0x40)        /*!< Bit Value =(1):1 of 8bit */

#define APX_SDT0_SDT_PSEL_mask_w                    ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define APX_SDT0_SDT_PSEL_mask_h0                   ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define APX_SDT0_SDT_PSEL_mask_b1                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define APX_SDT0_SDT_PSEL_proc4_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):PROC4 of 32bit */
#define APX_SDT0_SDT_PSEL_proc4_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):PROC4 of 16bit */
#define APX_SDT0_SDT_PSEL_proc4_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):PROC4 of 8bit */
#define APX_SDT0_SDT_PSEL_proc5_w                   ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):PROC5 of 32bit */
#define APX_SDT0_SDT_PSEL_proc5_h0                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):PROC5 of 16bit */
#define APX_SDT0_SDT_PSEL_proc5_b1                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):PROC5 of 8bit */

#define APX_SDT0_SDT_PMDS_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define APX_SDT0_SDT_PMDS_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define APX_SDT0_SDT_PMDS_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define APX_SDT0_SDT_PMDS_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define APX_SDT0_SDT_PMDS_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define APX_SDT0_SDT_PMDS_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define APX_SDT0_SDT_PMDS_toggle_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(1):Toggle of 32bit */
#define APX_SDT0_SDT_PMDS_toggle_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(1):Toggle of 16bit */
#define APX_SDT0_SDT_PMDS_toggle_b0                 ((uint8_t )0x80)        /*!< Bit Value =(1):Toggle of 8bit */

#define APX_SDT0_SDT_DIV_mask_w                     ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define APX_SDT0_SDT_DIV_mask_h0                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define APX_SDT0_SDT_DIV_mask_b0                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define APX_SDT0_SDT_DIV_div1_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define APX_SDT0_SDT_DIV_div1_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define APX_SDT0_SDT_DIV_div1_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define APX_SDT0_SDT_DIV_div2_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define APX_SDT0_SDT_DIV_div2_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define APX_SDT0_SDT_DIV_div2_b0                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define APX_SDT0_SDT_DIV_div4_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define APX_SDT0_SDT_DIV_div4_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define APX_SDT0_SDT_DIV_div4_b0                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define APX_SDT0_SDT_DIV_div8_w                     ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define APX_SDT0_SDT_DIV_div8_h0                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define APX_SDT0_SDT_DIV_div8_b0                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define APX_SDT0_SDT_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define APX_SDT0_SDT_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define APX_SDT0_SDT_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define APX_SDT0_SDT_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define APX_SDT0_SDT_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define APX_SDT0_SDT_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define APX_SDT0_SDT_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define APX_SDT0_SDT_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define APX_SDT0_SDT_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        APX_SDT1  [register's definitions]
 *              Offset[0x44]  APX SDT control register-1 (0x5F010044)
 ******************************************************************************
 */
///@{
#define APX_SDT1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of APX_SDT1 */
#define APX_SDT1_SDT_P5E_mask_w                     ((uint32_t)0x70000000)  /*!< Bit Mask of 32bit */
#define APX_SDT1_SDT_P5E_mask_h1                    ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define APX_SDT1_SDT_P5E_mask_b3                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define APX_SDT1_SDT_P5E_shift_w                    (28)                    /*!< Bit Shift of 32bit */
#define APX_SDT1_SDT_P5E_shift_h1                   (12)                    /*!< Bit Shift of 16bit */
#define APX_SDT1_SDT_P5E_shift_b3                   (4)                     /*!< Bit Shift of 8bit */

#define APX_SDT1_SDT_P5S_mask_w                     ((uint32_t)0x03FF0000)  /*!< Bit Mask of 32bit */
#define APX_SDT1_SDT_P5S_mask_h1                    ((uint16_t)0x03FF)      /*!< Bit Mask of 16bit */
#define APX_SDT1_SDT_P5S_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define APX_SDT1_SDT_P5S_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define APX_SDT1_SDT_P5S_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define APX_SDT1_SDT_P4E_mask_w                     ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define APX_SDT1_SDT_P4E_mask_h0                    ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define APX_SDT1_SDT_P4E_mask_b1                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define APX_SDT1_SDT_P4E_shift_w                    (12)                    /*!< Bit Shift of 32bit */
#define APX_SDT1_SDT_P4E_shift_h0                   (12)                    /*!< Bit Shift of 16bit */
#define APX_SDT1_SDT_P4E_shift_b1                   (4)                     /*!< Bit Shift of 8bit */

#define APX_SDT1_SDT_P4S_mask_w                     ((uint32_t)0x000003FF)  /*!< Bit Mask of 32bit */
#define APX_SDT1_SDT_P4S_mask_h0                    ((uint16_t)0x03FF)      /*!< Bit Mask of 16bit */
#define APX_SDT1_SDT_P4S_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define APX_SDT1_SDT_P4S_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define APX_SDT1_SDT_P4S_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_APX_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_APX.h                           */
/*----------------------------------------------------------------------------*/
