/**
 ******************************************************************************
 *
 * @file        MG32_LCD_Init.h
 *
 * @brief       This file is used to configure LCD setting.
 *              Device : MG32F02K128
 *
 * @par         Project
 *              MG32
 * @version     0.21
 * @date        2025/07/25 11:06
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */
#include "MG32.h"
#include "MG32_LCD.h"


#ifndef _MG32_LCD_INIT_H
/*!< _MG32_LCD_INIT_H */ 
#define _MG32_LCD_INIT_H

#define MG32_LCD_INIT_VER            21    // LCD Initial .h Version

//*** <<< Use Configuration Wizard in Context Menu >>> ***
/**
 ******************************************************************************
 *
 * @brief       LCD Initial Configure
 *
 ******************************************************************************
 */

//<h> LCD Initial Configure

//  <o> Mode <0=>Disable <1=>Enable
#define CONF_LCD_Mode                   1

//  <h> Configure LCD Clock
//      <o.2..3> LCD input clock CK_LCD source select <0=> CK_LS
//                                     <1=> NCO_P0
//                                     <2=> PROC
//                                     <3=> TM01_TRGO
//      <i> LCD input clock CK_LCD source select
#define CONF_LCD_CK_SEL                 0x00000000       // [3:2] LCD_CK_SEL

//      <o.4..6> LCD charge pump clock selection <0x00=> DIV1
//                                     <0x01=> DIV2
//                                     <0x02=> DIV3
//                                     <0x03=> DIV4
//          <i> It is indicated divider 1, 2, 3, 4 from CK_LS.
#define CONF_LCD_CK_CDIV                0x00000000       // [6:4] LCD_CK_CDIV

//      <o.8..10> LCD internal clock CK_LCD_INT input divider <0x00=> DIV1
//                                     <0x01=> DIV2
//                                     <0x02=> DIV4
//                                     <0x03=> DIV8
//                                     <0x04=> DIV16
//                                     <0x05=> DIV32
//                                     <0x06=> DIV64
//          <i> LCD internal clock CK_LCD_INT input divider
#define CONF_LCD_CK_DIV                 0x00000200       // [10:8] LCD_CK_DIV

//      <o.12..14> LCD input clock CK_LCD_PR divider <0x00=> DIV8
//                                     <0x01=> DIV16
//                                     <0x02=> DIV32
//                                     <0x03=> DIV64
//                                     <0x04=> DIV128
//                                     <0x05=> DIV256
//                                     <0x06=> DIV512
//                                     <0x07=> DIV1024
//          <i> LCD input clock CK_LCD_PR divider
#define CONF_LCD_CK_PDIV                0x00005000       // [14:12] LCD_CK_PDIV

//      <o.16..20> LCD internal clock CK_LCD_PHS prescaler <1-32>
//      <i> The value range 0~31 is indicated divider 1~32.
#define CONF_LCD_CK_PSC                 0x000F0000        // [20:16] LCD_CK_PSC
//  </h>

//  <h> Configure LCD Mode
//      <o.1..2> LCD bias power source selection <0x00=> Off
//                                               <0x01=> AVDD
//                                               <0x02=> EXT
//                                               <0x03=> CP
//          <i> AVDD : Internal voltage source (from VDD)
//          <i> EXT : External voltage source (from LCD_VT)
//          <i> CP : Internal charge pump
#define CONF_LCD_VS_SEL                 0x00000006       // [2:1] LCD_VS_SEL

//      <o.5> LCD frame control mode selection  <0x00=> TYPEA
//                                              <0x01=> TYPEB
//          <i> LCD frame control mode selection
#define CONF_LCD_FRM_MDS                0x00000020       // [5] LCD_FRM_MDS

//      <o.6> LCD output dead time mode selection   <0x00=> Frame
//                                                  <0x01=> Duty
//          <i> Frame : insert dead time between two Frame cycle
//          <i> Duty : insert dead time between two Duty cycle
#define CONF_LCD_DT_MDS                 0x00000000       // [6] LCD_DT_MDS

//      <o.7> LCD COM/SEG waveform inverse enable   <0x00=> Disable
//                                                  <0x01=> Enable
//          <i> LCD COM/SEG waveform inverse enable
#define CONF_LCD_CS_INV                 0x00000000       // [7] LCD_CS_INV

//      <o.8..9> LCD bias voltage select bits   <0x00=> Static
//                                              <0x01=> Bias 1/2
//                                              <0x02=> Bias 1/3
//                                              <0x03=> Bias 1/4
//          <i> LCD bias voltage select bits
#define CONF_LCD_BIAS                   0x00000200       // [9:8] LCD_BIAS

//      <o.11> LCD reference voltage resister ladder selection   <0x00=> INT
//                                                  <0x01=> EXT
//          <i> INT/EXT : select internal/external resister ladder
#define CONF_LCD_RL_SEL                 0x00000000       // [11] LCD_RL_SEL

//      <o.12..14> LCD duty cycle select bits  <0x00=> Static
//                                     <0x01=> 1/2 duty
//                                     <0x02=> 1/3 duty
//                                     <0x03=> 1/4 duty
//                                     <0x04=> 1/5 duty
//                                     <0x05=> 1/6 duty
//                                     <0x06=> 1/7 duty
//                                     <0x07=> 1/8 duty
//          <i> LCD duty cycle select bits
#define CONF_LCD_DUTY                   0x00003000       // [14:12] LCD_DUTY

//      <o.24..27> LCD output dead time period width <0-15>
//      <i> The value range 0 ~ 15 is indicated the dead time duration is 0 ~ 15 unit.
#define CONF_LCD_DT_PW                  0x01000000       // [27:24] LCD_DT_PW
//  </h>

//  <h> Configure LCD Power
//      <o.1> LCD built-in charge pump enable   <0x00=> Disable
//                                              <0x01=> Enable
//          <i> LCD built-in charge pump enable
#define CONF_LCD_CP_EN                  0x00000002       // [1] LCD_CP_EN

//      <o.2> LCD over voltage detection enable bit   <0x00=> Enable
//                                              <0x01=> Disable
//          <i> LCD over voltage detection enable bit
#define CONF_LCD_OVD_DIS                0x00000000       // [1] LCD_OVD_DIS

//      <o.4> LCD drive strength mode selection <0x00=> Normal
//                                              <0x01=> High
//          <i> LCD drive strength mode selection
#define CONF_LCD_DRV_MDS                0x00000000       // [4] LCD_DRV_MDS

//      <o.6> LCD off state LCD pin control <0x00=> Hiz
//                                          <0x01=> Low
//          <i> LCD off state LCD pin control
#define CONF_LCD_OFF_CTL                0x00000000       // [6] LCD_OFF_CTL

//      <o.7> LCD charge pump counter synchronization enable <0x00=> Disable
//                                              <0x01=> Enable
//          <i> LCD charge pump counter synchronization enable
#define CONF_LCD_CP_SYNC                0x00000000       // [7] LCD_CP_SYNC

//      <o.8> LCD voltage rail LCD_VT pin connection control    <0x00=> NC
//                                                              <0x01=> PD2
//          <i> LCD voltage rail LCD_VT pin connection control
#define CONF_LCD_VT_CTL                 0x00000100       // [8] LCD_VT_CTL

//      <o.10> LCD voltage rail LCD_V1 pin connection control   <0x00=> NC
//                                                              <0x01=> PD3
//          <i> LCD voltage rail LCD_V1 pin connection control
#define CONF_LCD_V1_CTL                 0x00000400       // [10] LCD_V1_CTL

//      <o.12> LCD voltage rail LCD_V2 pin connection control   <0x00=> NC
//                                                              <0x01=> PD7
//          <i> LCD voltage rail LCD_V2 pin connection control
#define CONF_LCD_V2_CTL                 0x00001000       // [12] LCD_V2_CTL

//      <o.14> LCD voltage rail LCD_V3 pin connection control   <0x00=> NC
//                                                              <0x01=> PD9
//          <i> LCD voltage rail LCD_V3 pin connection control
#define CONF_LCD_V3_CTL                 0x00004000       // [14] LCD_V3_CTL

//      <o.16..19> LCD power top voltage select  <0x00=> LVL0
//                                     <0x01=> LVL1
//                                     <0x02=> LVL2
//                                     <0x03=> LVL3
//                                     <0x04=> LVL4
//                                     <0x05=> LVL5
//                                     <0x06=> LVL6
//                                     <0x07=> LVL7
//                                     <0x08=> LVL8
//                                     <0x09=> LVL9
//                                     <0x0A=> LVL10
//                                     <0x0B=> LVL11
//                                     <0x0C=> LVL12
//                                     <0x0D=> LVL13
//                                     <0x0E=> LVL14
//                                     <0x0F=> LVL15
//          <i> LCD power top voltage select, LVL0 is minimun vlotage.
#define CONF_LCD_VT_SEL                 0x00080000       // [19:16] LCD_VT_SEL

//      <o.24..26> LCD drive high strength pulse width <0-7>
//      <i> The value range 0 ~ 7 is indicated the drive high pulse duration is 0 ~ 7.
#define CONF_LCD_DRV_PW                 0x04000000                   // [26:24] LCD_DRV_PW

//      <o.24..30> LCD charge pump charging counter value <0-127>
//      <i>  The value range 1 ~ 127 is indicated the drive high pulse duration is 2 ~ 128. The value 0 is indicated always charging.
#define CONF_LCD_CP_CNT                 0x00000000                    // [30:24] LCD_CP_CNT
//  </h>

//  <h> Configure LCD Blinking
//      <o.24..25> LCD blinking clock CK_LCD_BLK divider <0x00=> DIV4
//                                     <0x01=> DIV8
//                                     <0x02=> DIV16
//                                     <0x03=> DIV32
//          <i> LCD blinking clock CK_LCD_BLK divider
#define CONF_LCD_CK_BDIV                0x00000000                    // [25:24] LCD_CK_BDIV

//      <o.16..20> LCD blinking maximum frame counter value <0-31>
//      <i> The value range 0 ~ 31 is indicated the counting number is 1 ~ 32.
#define CONF_LCD_BCNT                   0x00040000                   // [20:16] LCD_BCNT
//  </h>

//      <e.0> LCD Interrupt All Enable
#define CONF_LCD_IEA                    0x00000001                   // [0] LCD_IEA
//      <q0.4> LCD start of frame interrupt enable
#define CONF_LCD_SOF_IE                 0x00000000                   // [4] LCD_SOF_IE
//      <q0.5> LCD update display data completed interrupt enable
#define CONF_LCD_UDC_IE                 0x00000020                   // [5] LCD_UDC_IE
//      <q0.6> LCD charge pump power ready interrupt enable
#define CONF_LCD_CPR_IE                 0x00000000                   // [6] LCD_CPR_IE
//      <q0.8> LCD blinking on interrupt enable
#define CONF_LCD_BLKON_IE               0x00000100                   // [8] LCD_BLKON_IE
//      <q0.9> LCD blinking off interrupt enable
#define CONF_LCD_BLKOFF_IE              0x00000000                   // [9] LCD_BLKOFF_IE
//      </e>

//  <h> LCD COM/SEG Configure

//      <o.0> LCD_P0 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS0                    0x00000001                      // [0] LCD_CS0
//      <o.1> LCD_P1 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS1                    0x00000002                      // [1] LCD_CS1
//      <o.2> LCD_P2 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS2                    0x00000004                      // [2] LCD_CS2
//      <o.3> LCD_P3 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS3                    0x00000008                      // [3] LCD_CS3
//      <o.4> LCD_P4 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS4                    0x00000010                      // [4] LCD_CS4
//      <o.5> LCD_P5 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS5                    0x00000020                      // [5] LCD_CS5
//      <o.6> LCD_P6 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS6                    0x00000040                      // [6] LCD_CS6
//      <o.7> LCD_P7 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS7                    0x00000080                      // [7] LCD_CS7
//      <o.8> LCD_P8 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS8                    0x00000000                      // [8] LCD_CS8
//      <o.9> LCD_P9 pin as common or segment line selection    <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS9                    0x00000000                      // [9] LCD_CS9
//      <o.10> LCD_P10 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS10                   0x00000000                      // [10] LCD_CS10
//      <o.11> LCD_P11 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS11                   0x00000000                      // [11] LCD_CS11
//      <o.12> LCD_P12 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS12                   0x00000000                      // [12] LCD_CS12
//      <o.13> LCD_P13 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS13                   0x00000000                      // [13] LCD_CS13
//      <o.14> LCD_P14 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS14                   0x00000000                      // [14] LCD_CS14
//      <o.15> LCD_P15 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS15                   0x00000000                      // [15] LCD_CS15
//      <o.16> LCD_P16 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS16                   0x00000000                      // [16] LCD_CS16
//      <o.17> LCD_P17 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS17                   0x00000000                      // [17] LCD_CS17
//      <o.18> LCD_P18 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS18                   0x00000000                      // [18] LCD_CS18
//      <o.19> LCD_P19 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS19                   0x00000000                      // [19] LCD_CS19
//      <o.20> LCD_P20 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS20                   0x00000000                      // [20] LCD_CS20
//      <o.21> LCD_P21 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS21                   0x00000000                      // [21] LCD_CS21
//      <o.22> LCD_P22 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS22                   0x00000000                      // [22] LCD_CS22
//      <o.23> LCD_P23 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS23                   0x00000000                      // [23] LCD_CS23
//      <o.24> LCD_P24 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS24                   0x00000000                      // [24] LCD_CS24
//      <o.25> LCD_P25 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS25                   0x00000000                      // [25] LCD_CS25
//      <o.26> LCD_P26 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS26                   0x00000000                      // [26] LCD_CS26
//      <o.27> LCD_P27 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS27                   0x00000000                      // [27] LCD_CS27
//      <o.28> LCD_P28 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS28                   0x00000000                      // [28] LCD_CS28
//      <o.29> LCD_P29 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS29                   0x00000000                      // [29] LCD_CS29
//      <o.30> LCD_P30 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS30                   0x00000000                      // [30] LCD_CS30
//      <o.31> LCD_P31 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS31                   0x00000000                      // [31] LCD_CS31
//      <o.0> LCD_P32 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS32                   0x00000000                      // [0] LCD_CS32
//      <o.1> LCD_P33 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS33                   0x00000000                      // [1] LCD_CS33
//      <o.2> LCD_P34 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS34                   0x00000000                      // [2] LCD_CS34
//      <o.3> LCD_P35 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS35                   0x00000000                      // [3] LCD_CS35
//      <o.4> LCD_P36 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS36                   0x00000000                      // [4] LCD_CS36
//      <o.5> LCD_P37 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS37                   0x00000000                      // [5] LCD_CS37
//      <o.6> LCD_P38 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS38                   0x00000000                      // [6] LCD_CS38
//      <o.7> LCD_P39 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS39                   0x00000000                      // [7] LCD_CS39
//      <o.8> LCD_P40 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS40                   0x00000000                      // [8] LCD_CS40
//      <o.9> LCD_P41 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS41                   0x00000000                      // [9] LCD_CS41
//      <o.10> LCD_P42 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS42                   0x00000000                      // [10] LCD_CS42
//      <o.11> LCD_P43 pin as common or segment line selection  <0x00=> Segment
//                                                              <0x01=> Common
#define CONF_LCD_CS43                   0x00000000                      // [11] LCD_CS43
//</h> 

//<h> LCD Display Memory default Configure
//      <o.0..7> LCD_P0 pin display data or COM selection bits          <0x00-0xFF>
#define CONF_LCD_M0                    0x00000001                      // [0] LCD_M0
//      <o.8..15> LCD_P1 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M1                    0x00000200                      // [1] LCD_M1
//      <o.16..23> LCD_P2 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M2                    0x00040000                      // [2] LCD_M2
//      <o.24..31> LCD_P3 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M3                    0x08000000                      // [3] LCD_M3
//      <o.0..7> LCD_P4 pin display data or COM selection bits          <0x00-0xFF>
#define CONF_LCD_M4                    0x00000010                      // [4] LCD_M4
//      <o.8..15> LCD_P5 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M5                    0x00002000                      // [5] LCD_M5
//      <o.16..23> LCD_P6 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M6                    0x00400000                      // [6] LCD_M6
//      <o.24..31> LCD_P7 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M7                    0x80000000                      // [7] LCD_M7
//      <o.0..7> LCD_P8 pin display data or COM selection bits          <0x00-0xFF>
#define CONF_LCD_M8                    0x00000001                      // [8] LCD_M8
//      <o.8..15> LCD_P9 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M9                    0x00000200                      // [9] LCD_M9
//      <o.16..23> LCD_P10 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M10                   0x00040000                      // [10] LCD_M10
//      <o.24..31> LCD_P11 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M11                   0x08000000                      // [11] LCD_M11
//      <o.0..7> LCD_P12 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M12                   0x00000010                      // [12] LCD_M12
//      <o.8..15> LCD_P13 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M13                   0x00002000                      // [13] LCD_M13
//      <o.16..23> LCD_P14 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M14                   0x00400000                      // [14] LCD_M14
//      <o.24..31> LCD_P15 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M15                   0x80000000                      // [15] LCD_M15
//      <o.0..7> LCD_P16 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M16                   0x00000000                      // [16] LCD_M16
//      <o.8..15> LCD_P17 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M17                   0x00000000                      // [17] LCD_M17
//      <o.16..23> LCD_P18 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M18                   0x00000000                      // [18] LCD_M18
//      <o.24..31> LCD_P19 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M19                   0x00000000                      // [19] LCD_M19
//      <o.0..7> LCD_P20 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M20                   0x00000000                      // [20] LCD_M20
//      <o.8..15> LCD_P21 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M21                   0x00000000                      // [21] LCD_M21
//      <o.16..23> LCD_P22 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M22                   0x00000000                      // [22] LCD_M22
//      <o.24..31> LCD_P23 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M23                   0x00000000                      // [23] LCD_M23
//      <o.0..7> LCD_P24 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M24                   0x00000000                      // [24] LCD_M24
//      <o.8..15> LCD_P25 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M25                   0x00000000                      // [25] LCD_M25
//      <o.16..23> LCD_P26 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M26                   0x00000000                      // [26] LCD_M26
//      <o.24..31> LCD_P27 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M27                   0x00000000                      // [27] LCD_M27
//      <o.0..7> LCD_P28 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M28                   0x00000000                      // [28] LCD_M28
//      <o.8..15> LCD_P29 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M29                   0x00000000                      // [29] LCD_M29
//      <o.16..23> LCD_P30 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M30                   0x00000000                      // [30] LCD_M30
//      <o.24..31> LCD_P31 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M31                   0x00000000                      // [31] LCD_M31
//      <o.0..7> LCD_P32 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M32                   0x00000000                      // [0] LCD_M32
//      <o.8..15> LCD_P33 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M33                   0x00000000                      // [1] LCD_M33
//      <o.16..23> LCD_P34 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M34                   0x00000000                      // [2] LCD_M34
//      <o.24..31> LCD_P35 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M35                   0x00000000                      // [3] LCD_M35
//      <o.0..7> LCD_P36 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M36                   0x00000000                      // [4] LCD_M36
//      <o.8..15> LCD_P37 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M37                   0x00000000                      // [5] LCD_M37
//      <o.16..23> LCD_P38 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M38                   0x00000000                      // [6] LCD_M38
//      <o.24..31> LCD_P39 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M39                   0x00000000                      // [7] LCD_M39
//      <o.0..7> LCD_P40 pin display data or COM selection bits         <0x00-0xFF>
#define CONF_LCD_M40                   0x00000000                      // [8] LCD_M40
//      <o.8..15> LCD_P41 pin display data or COM selection bits        <0x00-0xFF>
#define CONF_LCD_M41                   0x00000000                      // [9] LCD_M41
//      <o.16..23> LCD_P42 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M42                   0x00000000                      // [10] LCD_M42
//      <o.24..31> LCD_P43 pin display data or COM selection bits       <0x00-0xFF>
#define CONF_LCD_M43                   0x00000000                      // [11] LCD_M43
//</h> 
//</h>

//*** <<< end of configuration section >>>    ***


//
//============================  LCD Control Registers  ============================
//

#define CONF_LCD_INT            (CONF_LCD_IEA | CONF_LCD_SOF_IE | CONF_LCD_UDC_IE | CONF_LCD_CPR_IE | CONF_LCD_BLKON_IE | CONF_LCD_BLKOFF_IE)
#define CONF_LCD_CLK            (CONF_LCD_CK_SEL | CONF_LCD_CK_CDIV | CONF_LCD_CK_DIV | CONF_LCD_CK_PDIV | CONF_LCD_CK_PSC | CONF_LCD_CK_BDIV)
#define CONF_LCD_CR0            (CONF_LCD_VS_SEL | CONF_LCD_FRM_MDS | CONF_LCD_DT_MDS | CONF_LCD_CS_INV | CONF_LCD_BIAS | CONF_LCD_RL_SEL | CONF_LCD_DUTY | CONF_LCD_DT_PW)
#define CONF_LCD_CR1            (CONF_LCD_CP_EN | CONF_LCD_OVD_DIS | CONF_LCD_DRV_MDS | CONF_LCD_OFF_CTL | CONF_LCD_CP_SYNC | CONF_LCD_VT_CTL | \
                                 CONF_LCD_V1_CTL | CONF_LCD_V2_CTL | CONF_LCD_V3_CTL | CONF_LCD_VT_SEL | CONF_LCD_DRV_PW)
#define CONF_LCD_CR2            (CONF_LCD_BCNT | CONF_LCD_CP_CNT)
#define CONF_LCD_MUX0           (CONF_LCD_CS0 | CONF_LCD_CS1 | CONF_LCD_CS2 | CONF_LCD_CS3 | CONF_LCD_CS4 | CONF_LCD_CS5 | CONF_LCD_CS6 | CONF_LCD_CS7 | \
                                 CONF_LCD_CS8 | CONF_LCD_CS9 | CONF_LCD_CS10 | CONF_LCD_CS11 | CONF_LCD_CS12 | CONF_LCD_CS13 | CONF_LCD_CS14 | CONF_LCD_CS15 | \
                                 CONF_LCD_CS16 | CONF_LCD_CS17 | CONF_LCD_CS18 | CONF_LCD_CS19 | CONF_LCD_CS20 | CONF_LCD_CS21 | CONF_LCD_CS22 | CONF_LCD_CS23 | \
                                 CONF_LCD_CS24 | CONF_LCD_CS25 | CONF_LCD_CS26 | CONF_LCD_CS27 | CONF_LCD_CS28 | CONF_LCD_CS29 | CONF_LCD_CS30 | CONF_LCD_CS31)
#define CONF_LCD_MUX1           (CONF_LCD_CS32 | CONF_LCD_CS33 | CONF_LCD_CS34 | CONF_LCD_CS35 | CONF_LCD_CS36 | CONF_LCD_CS37 | CONF_LCD_CS38 | CONF_LCD_CS39 | \
                                 CONF_LCD_CS40 | CONF_LCD_CS41 | CONF_LCD_CS42 | CONF_LCD_CS43)

#define CONF_LCD_MDNum                  1                               // LCD Display Data Frame Number


/**
 * @name    Function announce
 *   
 */
///@{  
void LCD_Init (void);
///@}

#endif  // _MG32_LCD_INIT_H

