/**
 *******************************************************************************
 *
 * @file        MG32_ADC_Init.c
 *
 * @brief       The ADC initial code C file
 *
 * @par         Project
 *              MG32
 * @version     V1.04
 * @date        2023/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
/* Includes ------------------------------------------------------------------*/
#include "MG32_ADC_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
// (Middleware level)
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            ADC_HandleTypeDef        mADC;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        ADC_HandleTypeDef        mADC;
    #endif
    // ------------------------------------------------------------------------
#endif

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
    

/**
 *******************************************************************************
 * @brief  	    Initialized ADC module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void ADC_Init (void)
{
    #if CONF_ADC0_MODE == 1
        uint16_t    SettleTime;
            
        /* ADC00 initial wizard */
        ADC0->CLK.W     = CONF_ADC_CLK;
        ADC0->WINDTH.W  = CONF_ADC_WINDTH; 
        ADC0->CR0.W     = CONF_ADC_CR0 | ADC_CR0_EN_enable_w;  
        ADC0->CR1.W     = CONF_ADC_CR1;  
        ADC0->MSK.W     = CONF_ADC_MSK;  
        ADC0->START.W   = CONF_ADC_START;
        ADC0->ANA.W     = CONF_ADC_ANA;  
    //    ADC0->GAIN.W    = CONF_ADC_GAIN; 
        ADC0->SUM0.W    = CONF_ADC_SUM0;
        ADC0->SUM1.W    = CONF_ADC_SUM1;
        ADC0->SUM2.W    = CONF_ADC_SUM2;
        
        
        // ADC Settle time (needs ~5us)
        for (SettleTime=0; SettleTime<250; SettleTime++);
        
        // ADC calibration 
        ADC_StartCalibration(ADC0, ENABLE); 

        // PGA calibration
        #if defined(CONF_ADC_ANA_PGA_EN)
            #if CONF_ADC_ANA_PGA_EN!=0
                ADC_PGAOffsetCalibration_Cmd(ADC0, ENABLE);
            #endif
        #endif
       
        // Set ADC interrupt register
        #if defined(CONF_ADC_INT)
        ADC0->INT.W = CONF_ADC_INT;
        #endif

        // --------------------------------------------------------------------
        // Config mADC structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mADC.Instance                   = ADC0;
            mADC.Init.ADCConType            = mADC_Conversion_Type;
            mADC.Init.ADCClock              = mADC_Clock_Select;
            mADC.Init.Resolution            = mADC_Resolution_Select;
            mADC.Init.DataAlign             = mADC_Justified_Select;
            mADC.Init.ConversionMode        = mADC_Conversion_Mode;
            mADC.Init.LowPowerAutoWait      = mADC_WaitFunction_Select;
            #if defined(MG32_3RD) || defined(MG32_4TH)
                mADC.Init.LowPowerAutoPowerOff  = mADC_AutoPowerOff_Select;
                mADC.Init.PowerupTimerDIV       = mADC_SDIV_Select;
                mADC.Init.PowerupTimerCNT       = mADC_SCNT_Select;
            #endif
            mADC.Init.TriggerConverionSrc   = mADC_TriggerConversion_Select;
            mADC.Init.TriggerConverionEdge  = mADC_TriggerEdge_Select;
            mADC.Init.Overrun               = mADC_OverWritten_Select;
            mADC.Init.ExtendSamplingTime    = mADC_ExtendSampleTime_Select;
            mADC.Init.PGACmd                = mADC_PGACmd_Select;
            mADC.Init.PGAGain               = mADC_PGAGain_Select;
            mADC.State                      = MID_ADC_STATE_RESET;

            // MID_ADC_Init(&mADC);
        #endif

    #endif

}
