/**
 ******************************************************************************
 *
 * @file        MG32_LCD.h
 *
 * @brief       MG32 LCD Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.04 (Register File Date : 2025_1014)
 * @date        2026/01/05 10:06 (H File Generated Date)
 * @author      HeadCodeGen V1.61
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_LCD_H
#define _MG32_LCD_H
#define _MG32_LCD_H_VER                             104     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_LCD_H_VER)
    #error "_MG32_LCD_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      LCD_Struct
 *              LCD  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  DEF           :1;     //[0] LCD display enabled status
                                        //0 = Inactive : LCD display disabled
                                        //1 = Active : LCD display enabled
            __I  uint8_t  PRDYF         :1;     //[1] LCD internal power source ready statue
                                        //0 = Not : Not ready
                                        //1 = Ready : Power source is ready to output voltage
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  SOF           :1;     //[4] LCD start of frame interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  UDCF          :1;     //[5] LCD update display data completed interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CPRF          :1;     //[6] LCD charge pump power ready interrupt flag
                                        //0 = Not : charge pump power is not ready
                                        //1 = Ready : charge pump power is ready
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLKONF        :1;     //[8] LCD blinking on interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BLKOFF        :1;     //[9] LCD blinking off interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  ADC0 status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] LCD interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[3..1] 
            __IO uint8_t  SOF_IE        :1;     //[4] LCD start of frame interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  UDC_IE        :1;     //[5] LCD update display data completed interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CPR_IE        :1;     //[6] LCD charge pump power ready interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BLKON_IE      :1;     //[8] LCD blinking on interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BLKOFF_IE     :1;     //[9] LCD blinking off interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  LCD interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __IO uint8_t  CK_SEL        :2;     //[3..2] LCD input clock CK_LCD source select.
                                        //0x0 = CK_LS
                                        //0x1 = NCO_P0
                                        //0x2 = PROC : CK_LCD_PR process clock from CSC
                                        //0x3 = TM01_TRGO
            __IO uint8_t  CK_CDIV       :2;     //[5..4] LCD charge pump clock selection
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV3 : divided by 3
                                        //0x3 = DIV4 : divided by 4
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  CK_DIV        :3;     //[10..8] LCD internal clock CK_LCD_INT input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
                                        //0x4 = DIV16 : divided by 16
                                        //0x5 = DIV32 : divided by 32
                                        //0x6 = DIV64 : divided by 64
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  CK_PDIV       :3;     //[14..12] LCD input clock CK_LCD_PR divider.
                                        //0x0 = DIV8 : divided by 8
                                        //0x1 = DIV16 : divided by 16
                                        //0x2 = DIV32 : divided by 32
                                        //0x3 = DIV64 : divided by 64
                                        //0x4 = DIV128 : divided by 128
                                        //0x5 = DIV256 : divided by 256 
                                        //0x6 = DIV512 : divided by 512
                                        //0x7 = DIV1024 : divided by 1024
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  CK_PSC        :5;     //[20..16] LCD internal clock CK_LCD_PHS prescaler
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  CK_BDIV       :2;     //[25..24] LCD blinking clock CK_LCD_BLK divider.
                                        //0x0 = DIV4 : divided by 4
                                        //0x1 = DIV8 : divided by 8
                                        //0x2 = DIV16 : divided by 16
                                        //0x3 = DIV32 : divided by 32
            __I  uint8_t                :1;     //[26] 
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  LCD clock source register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x0C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] LCD module enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  VS_SEL        :2;     //[2..1] LCD bias power source selection.
                                        //0x0 = Off : No power
                                        //0x1 = AVDD : Internal voltage source (from VDD)
                                        //0x2 = EXT : External voltage source (from LCD_VT)
                                        //0x3 = CP : Internal charge pump
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  FRM_MDS       :1;     //[5] LCD frame control mode selection. 
                                        //0 = TYPEA : Type-A frame control mode
                                        //1 = TYPEB : Type-B frame control mode
            __IO uint8_t  DT_MDS        :1;     //[6] LCD output dead time mode selection
                                        //0 = Frame : insert dead time between two Frame cycle
                                        //1 = Duty : insert dead time between two Duty cycle
            __IO uint8_t  CS_INV        :1;     //[7] LCD COM/SEG waveform phase inverse enable.
                                        //0 = Normal
                                        //1 = Inverse
            __IO uint8_t  BIAS          :2;     //[9..8] LCD bias voltage select bits.
                                        //0x0 = Static
                                        //0x1 = B12 : Bias 1/2
                                        //0x2 = B13 : Bias 1/3
                                        //0x3 = B14 : Bias 1/4
            __I  uint8_t                :1;     //[10] 
            __IO uint8_t  RL_SEL        :1;     //[11] LCD reference voltage resister ladder selection.
                                        //0x0 = INT : select internal resister ladder
                                        //0x1 = EXT : select external resister ladder
            __IO uint8_t  DUTY          :3;     //[14..12] LCD duty cycle select bits.
                                        //0x0 = Static : Static duty
                                        //0x1 = D12 : 1/2 duty
                                        //0x2 = D13 : 1/3 duty
                                        //0x3 = D14 : 1/4 duty
                                        //0x4 = D15 : 1/5 duty
                                        //0x5 = D16 : 1/6 duty
                                        //0x6 = D17 : 1/7 duty
                                        //0x7 = D18 : 1/8 duty
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  S0_SEL        :2;     //[17..16] LCD_S0 output signal select
                                        //0x0 = PMP : Internal using
                                        //0x1 = PHS : CK_LCD_PHS
                                        //0x2 = FRM : CK_LCD_FRM
                                        //0x3 = INT : CK_LCD_INT
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  S1_SEL        :2;     //[21..20] LCD_S1 output signal select
                                        //0x0 = OUT1 : Internal using
                                        //0x1 = PCKI : Internal using
                                        //0x2 = RMODE : Internal using
                                        //0x3 = PGO : Internal using
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  DT_PW         :4;     //[27..24] LCD output dead time period width
            __I  uint8_t                :3;     //[30..28] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  LCD control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  CP_EN         :1;     //[1] LCD built-in charge pump enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OVD_DIS       :1;     //[2] LCD over voltage detection enable bit
                                        //0 = Enable
                                        //1 = Disable
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  DRV_MDS       :1;     //[4] LCD drive strength mode selection
                                        //0 = Normal : enable a high resistance
                                        //1 = High : enable a low resistance
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  OFF_CTL       :1;     //[6] LCD off state LCD pin control
                                        //0 = Hiz : Tri-State
                                        //1 = Low : Output Low
            __IO uint8_t  CP_SYNC       :1;     //[7] LCD charge pump counter synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  VT_CTL        :1;     //[8] LCD voltage rail LCD_VT pin connection control.
                                        //0 = NC : No pin connection
                                        //1 = Pin1 : Connect to pin
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  V1_CTL        :1;     //[10] LCD voltage rail LCD_V1 pin connection control.
                                        //0 = NC : No pin connection
                                        //1 = Pin1 : Connect to pin
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  V2_CTL        :1;     //[12] LCD voltage rail LCD_V2 pin connection control.
                                        //0 = NC : No pin connection
                                        //1 = Pin1 : Connect to pin
            __I  uint8_t                :1;     //[13] 
            __IO uint8_t  V3_CTL        :1;     //[14] LCD voltage rail LCD_V3 pin connection control.
                                        //0 = NC : No pin connection
                                        //1 = Pin1 : Connect to pin
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  VT_SEL        :4;     //[19..16] LCD power top voltage select
                                        //0x0 = LVL0 : Minimun vlotage
                                        //0x1 = LVL1
                                        //0x2 = LVL2
                                        //0x3 = LVL3
                                        //0x4 = LVL4
                                        //0x5 = LVL5
                                        //0x6 = LVL6
                                        //0x7 = LVL7
                                        //0x8 = LVL8
                                        //0x9 = LVL9
                                        //0xA = LVL10
                                        //0xB = LVL11
                                        //0xC = LVL12
                                        //0xD = LVL13
                                        //0xE = LVL14 : Maximum voltage
                                        //0xF = Reserved
            __I  uint8_t                :4;     //[23..20] 
            __IO uint8_t  DRV_PW        :3;     //[26..24] LCD drive high strength pulse width
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  LCD control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  MEM_CLR       :1;     //[1] LCD display memory clear enable bit
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :5;     //[7..3] 
            __IO uint8_t  BLK_MDS       :1;     //[8] LCD blinking mode selection.
                                        //0x0 = Disable
                                        //0x1 = All : Blinking all dots on all SEGs for all COMs 
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  SEG_OFF       :1;     //[10] LCD segments all off enable bit
                                        //0 = On
                                        //1 = Off
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  BCNT          :5;     //[20..16] LCD blinking maximum frame counter value
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  CP_CNT        :7;     //[30..24] LCD charge pump charging counter value
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  LCD control register 2 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x1C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CS0           :1;     //[0] LCD_P0 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS1           :1;     //[1] LCD_P1 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS2           :1;     //[2] LCD_P2 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS3           :1;     //[3] LCD_P3 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS4           :1;     //[4] LCD_P4 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS5           :1;     //[5] LCD_P5 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS6           :1;     //[6] LCD_P6 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS7           :1;     //[7] LCD_P7 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS8           :1;     //[8] LCD_P8 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS9           :1;     //[9] LCD_P9 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS10          :1;     //[10] LCD_P10 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS11          :1;     //[11] LCD_P11 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS12          :1;     //[12] LCD_P12 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS13          :1;     //[13] LCD_P13 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS14          :1;     //[14] LCD_P14 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS15          :1;     //[15] LCD_P15 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS16          :1;     //[16] LCD_P16 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS17          :1;     //[17] LCD_P17 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS18          :1;     //[18] LCD_P18 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS19          :1;     //[19] LCD_P19 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS20          :1;     //[20] LCD_P20 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS21          :1;     //[21] LCD_P21 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS22          :1;     //[22] LCD_P22 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS23          :1;     //[23] LCD_P23 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS24          :1;     //[24] LCD_P24 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS25          :1;     //[25] LCD_P25 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS26          :1;     //[26] LCD_P26 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS27          :1;     //[27] LCD_P27 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS28          :1;     //[28] LCD_P28 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS29          :1;     //[29] LCD_P29 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS30          :1;     //[30] LCD_P30 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS31          :1;     //[31] LCD_P31 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
        }MBIT;
    }MUX0;                              /*!< MUX0       ~ Offset[0x20]  LCD COM SEG select register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CS32          :1;     //[0] LCD_P32 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS33          :1;     //[1] LCD_P33 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS34          :1;     //[2] LCD_P34 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS35          :1;     //[3] LCD_P35 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS36          :1;     //[4] LCD_P36 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS37          :1;     //[5] LCD_P37 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS38          :1;     //[6] LCD_P38 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS39          :1;     //[7] LCD_P39 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS40          :1;     //[8] LCD_P40 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS41          :1;     //[9] LCD_P41 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS42          :1;     //[10] LCD_P42 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __IO uint8_t  CS43          :1;     //[11] LCD_P43 pin as common or segment line selection
                                        //0 = SEG : Segment line
                                        //1 = COM : Common line
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }MUX1;                              /*!< MUX1       ~ Offset[0x24]  LCD COM SEG select register 1 */

    __I uint32_t  RESERVED2[2];         /*!< RESERVED2  ~ Offset[0x28]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M0            :8;     //[7..0] LCD_P0 pin display data bits or COM selection bits
            __IO uint8_t  M1            :8;     //[15..8] LCD_P1 pin display data bits or COM selection bits
            __IO uint8_t  M2            :8;     //[23..16] LCD_P2 pin display data bits or COM selection bits
            __IO uint8_t  M3            :8;     //[31..24] LCD_P3 pin display data bits or COM selection bits
        }MBIT;
    }MD0;                               /*!< MD0        ~ Offset[0x30]  LCD display memory data register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M4            :8;     //[7..0] LCD_P4 pin display data bits or COM selection bits
            __IO uint8_t  M5            :8;     //[15..8] LCD_P5 pin display data bits or COM selection bits
            __IO uint8_t  M6            :8;     //[23..16] LCD_P5 pin display data bits or COM selection bits
            __IO uint8_t  M7            :8;     //[31..24] LCD_P7 pin display data bits or COM selection bits
        }MBIT;
    }MD1;                               /*!< MD1        ~ Offset[0x34]  LCD display memory data register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M8            :8;     //[7..0] LCD_P8 pin display data bits or COM selection bits
            __IO uint8_t  M9            :8;     //[15..8] LCD_P9 pin display data bits or COM selection bits
            __IO uint8_t  M10           :8;     //[23..16] LCD_P10 pin display data bits or COM selection bits
            __IO uint8_t  M11           :8;     //[31..24] LCD_P11 pin display data bits or COM selection bits
        }MBIT;
    }MD2;                               /*!< MD2        ~ Offset[0x38]  LCD display memory data register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M12           :8;     //[7..0] LCD_P12 pin display data bits or COM selection bits
            __IO uint8_t  M13           :8;     //[15..8] LCD_P13 pin display data bits or COM selection bits
            __IO uint8_t  M14           :8;     //[23..16] LCD_P14 pin display data bits or COM selection bits
            __IO uint8_t  M15           :8;     //[31..24] LCD_P15 pin display data bits or COM selection bits
        }MBIT;
    }MD3;                               /*!< MD3        ~ Offset[0x3C]  LCD display memory data register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M16           :8;     //[7..0] LCD_P16 pin display data bits or COM selection bits
            __IO uint8_t  M17           :8;     //[15..8] LCD_P17 pin display data bits or COM selection bits
            __IO uint8_t  M18           :8;     //[23..16] LCD_P18 pin display data bits or COM selection bits
            __IO uint8_t  M19           :8;     //[31..24] LCD_P19 pin display data bits or COM selection bits
        }MBIT;
    }MD4;                               /*!< MD4        ~ Offset[0x40]  LCD display memory data register 4 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M20           :8;     //[7..0] LCD_P20 pin display data bits or COM selection bits
            __IO uint8_t  M21           :8;     //[15..8] LCD_P21 pin display data bits or COM selection bits
            __IO uint8_t  M22           :8;     //[23..16] LCD_P22 pin display data bits or COM selection bits
            __IO uint8_t  M23           :8;     //[31..24] LCD_P23 pin display data bits or COM selection bits
        }MBIT;
    }MD5;                               /*!< MD5        ~ Offset[0x44]  LCD display memory data register 5 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M24           :8;     //[7..0] LCD_P24 pin display data bits or COM selection bits
            __IO uint8_t  M25           :8;     //[15..8] LCD_P25 pin display data bits or COM selection bits
            __IO uint8_t  M26           :8;     //[23..16] LCD_P26 pin display data bits or COM selection bits
            __IO uint8_t  M27           :8;     //[31..24] LCD_P27 pin display data bits or COM selection bits
        }MBIT;
    }MD6;                               /*!< MD6        ~ Offset[0x48]  LCD display memory data register 6 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M28           :8;     //[7..0] LCD_P28 pin display data bits or COM selection bits
            __IO uint8_t  M29           :8;     //[15..8] LCD_P29 pin display data bits or COM selection bits
            __IO uint8_t  M30           :8;     //[23..16] LCD_P30 pin display data bits or COM selection bits
            __IO uint8_t  M31           :8;     //[31..24] LCD_P31 pin display data bits or COM selection bits
        }MBIT;
    }MD7;                               /*!< MD7        ~ Offset[0x4C]  LCD display memory data register 7 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M32           :8;     //[7..0] LCD_P32 pin display data bits or COM selection bits
            __IO uint8_t  M33           :8;     //[15..8] LCD_P33 pin display data bits or COM selection bits
            __IO uint8_t  M34           :8;     //[23..16] LCD_P34 pin display data bits or COM selection bits
            __IO uint8_t  M35           :8;     //[31..24] LCD_P35 pin display data bits or COM selection bits
        }MBIT;
    }MD8;                               /*!< MD8        ~ Offset[0x50]  LCD display memory data register 8 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M36           :8;     //[7..0] LCD_P36 pin display data bits or COM selection bits
            __IO uint8_t  M37           :8;     //[15..8] LCD_P37 pin display data bits or COM selection bits
            __IO uint8_t  M38           :8;     //[23..16] LCD_P38 pin display data bits or COM selection bits
            __IO uint8_t  M39           :8;     //[31..24] LCD_P39 pin display data bits or COM selection bits
        }MBIT;
    }MD9;                               /*!< MD9        ~ Offset[0x54]  LCD display memory data register 9 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  M40           :8;     //[7..0] LCD_P40 pin display data bits or COM selection bits
            __IO uint8_t  M41           :8;     //[15..8] LCD_P41 pin display data bits or COM selection bits
            __IO uint8_t  M42           :8;     //[23..16] LCD_P42 pin display data bits or COM selection bits
            __IO uint8_t  M43           :8;     //[31..24] LCD_P43 pin display data bits or COM selection bits
        }MBIT;
    }MD10;                              /*!< MD10       ~ Offset[0x58]  LCD display memory data register 10 */

} LCD_Struct;

/**
 ******************************************************************************
 *
 * @name        LCD  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define LCD_Base                        ((uint32_t)0x5A000000)              /*!< Liquid Crystal Display Controller */
#define LCD                             ((LCD_Struct*) LCD_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        LCD  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        LCD_STA  [register's definitions]
 *              Offset[0x00]  ADC0 status register (0x5A000000)
 ******************************************************************************
 */
///@{
#define LCD_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_STA */
#define LCD_STA_BLKOFF_mask_w                       ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define LCD_STA_BLKOFF_mask_h0                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define LCD_STA_BLKOFF_mask_b1                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_STA_BLKOFF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define LCD_STA_BLKOFF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define LCD_STA_BLKOFF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define LCD_STA_BLKOFF_happened_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define LCD_STA_BLKOFF_happened_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define LCD_STA_BLKOFF_happened_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define LCD_STA_BLKONF_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define LCD_STA_BLKONF_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_STA_BLKONF_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_STA_BLKONF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define LCD_STA_BLKONF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define LCD_STA_BLKONF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define LCD_STA_BLKONF_happened_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define LCD_STA_BLKONF_happened_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define LCD_STA_BLKONF_happened_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define LCD_STA_CPRF_mask_w                         ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define LCD_STA_CPRF_mask_h0                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_STA_CPRF_mask_b0                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_STA_CPRF_not_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define LCD_STA_CPRF_not_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define LCD_STA_CPRF_not_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define LCD_STA_CPRF_ready_w                        ((uint32_t)0x00000040)  /*!< Bit Value =(1):Ready of 32bit */
#define LCD_STA_CPRF_ready_h0                       ((uint16_t)0x0040)      /*!< Bit Value =(1):Ready of 16bit */
#define LCD_STA_CPRF_ready_b0                       ((uint8_t )0x40)        /*!< Bit Value =(1):Ready of 8bit */

#define LCD_STA_UDCF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define LCD_STA_UDCF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define LCD_STA_UDCF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_STA_UDCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define LCD_STA_UDCF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define LCD_STA_UDCF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define LCD_STA_UDCF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define LCD_STA_UDCF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define LCD_STA_UDCF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define LCD_STA_SOF_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define LCD_STA_SOF_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define LCD_STA_SOF_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_STA_SOF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define LCD_STA_SOF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define LCD_STA_SOF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define LCD_STA_SOF_happened_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define LCD_STA_SOF_happened_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define LCD_STA_SOF_happened_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define LCD_STA_PRDYF_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define LCD_STA_PRDYF_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define LCD_STA_PRDYF_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_STA_PRDYF_not_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define LCD_STA_PRDYF_not_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define LCD_STA_PRDYF_not_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define LCD_STA_PRDYF_ready_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(1):Ready of 32bit */
#define LCD_STA_PRDYF_ready_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(1):Ready of 16bit */
#define LCD_STA_PRDYF_ready_b0                      ((uint8_t )0x02)        /*!< Bit Value =(1):Ready of 8bit */

#define LCD_STA_DEF_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define LCD_STA_DEF_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define LCD_STA_DEF_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_STA_DEF_inactive_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Inactive of 32bit */
#define LCD_STA_DEF_inactive_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Inactive of 16bit */
#define LCD_STA_DEF_inactive_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Inactive of 8bit */
#define LCD_STA_DEF_active_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Active of 32bit */
#define LCD_STA_DEF_active_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Active of 16bit */
#define LCD_STA_DEF_active_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Active of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_INT  [register's definitions]
 *              Offset[0x04]  LCD interrupt enable register (0x5A000004)
 ******************************************************************************
 */
///@{
#define LCD_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_INT */
#define LCD_INT_BLKOFF_IE_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define LCD_INT_BLKOFF_IE_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define LCD_INT_BLKOFF_IE_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_INT_BLKOFF_IE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_INT_BLKOFF_IE_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_INT_BLKOFF_IE_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_INT_BLKOFF_IE_enable_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_INT_BLKOFF_IE_enable_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_INT_BLKOFF_IE_enable_b1                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define LCD_INT_BLKON_IE_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define LCD_INT_BLKON_IE_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_INT_BLKON_IE_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_INT_BLKON_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_INT_BLKON_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_INT_BLKON_IE_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_INT_BLKON_IE_enable_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_INT_BLKON_IE_enable_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_INT_BLKON_IE_enable_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define LCD_INT_CPR_IE_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define LCD_INT_CPR_IE_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_INT_CPR_IE_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_INT_CPR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_INT_CPR_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_INT_CPR_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_INT_CPR_IE_enable_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_INT_CPR_IE_enable_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_INT_CPR_IE_enable_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define LCD_INT_UDC_IE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define LCD_INT_UDC_IE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define LCD_INT_UDC_IE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_INT_UDC_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_INT_UDC_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_INT_UDC_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_INT_UDC_IE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_INT_UDC_IE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_INT_UDC_IE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define LCD_INT_SOF_IE_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define LCD_INT_SOF_IE_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define LCD_INT_SOF_IE_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_INT_SOF_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_INT_SOF_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_INT_SOF_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_INT_SOF_IE_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_INT_SOF_IE_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_INT_SOF_IE_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define LCD_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define LCD_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define LCD_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_CLK  [register's definitions]
 *              Offset[0x08]  LCD clock source register (0x5A000008)
 ******************************************************************************
 */
///@{
#define LCD_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_CLK */
#define LCD_CLK_CK_BDIV_mask_w                      ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define LCD_CLK_CK_BDIV_mask_h1                     ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define LCD_CLK_CK_BDIV_mask_b3                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define LCD_CLK_CK_BDIV_div4_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV4 of 32bit */
#define LCD_CLK_CK_BDIV_div4_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV4 of 16bit */
#define LCD_CLK_CK_BDIV_div4_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV4 of 8bit */
#define LCD_CLK_CK_BDIV_div8_w                      ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):DIV8 of 32bit */
#define LCD_CLK_CK_BDIV_div8_h1                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):DIV8 of 16bit */
#define LCD_CLK_CK_BDIV_div8_b3                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV8 of 8bit */
#define LCD_CLK_CK_BDIV_div16_w                     ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):DIV16 of 32bit */
#define LCD_CLK_CK_BDIV_div16_h1                    ((uint16_t)0x0200)      /*!< Bit Value =(0x2):DIV16 of 16bit */
#define LCD_CLK_CK_BDIV_div16_b3                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV16 of 8bit */
#define LCD_CLK_CK_BDIV_div32_w                     ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):DIV32 of 32bit */
#define LCD_CLK_CK_BDIV_div32_h1                    ((uint16_t)0x0300)      /*!< Bit Value =(0x3):DIV32 of 16bit */
#define LCD_CLK_CK_BDIV_div32_b3                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV32 of 8bit */

#define LCD_CLK_CK_PSC_mask_w                       ((uint32_t)0x001F0000)  /*!< Bit Mask of 32bit */
#define LCD_CLK_CK_PSC_mask_h1                      ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define LCD_CLK_CK_PSC_mask_b2                      ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define LCD_CLK_CK_PSC_shift_w                      (16)                    /*!< Bit Shift of 32bit */
#define LCD_CLK_CK_PSC_shift_h1                     (0)                     /*!< Bit Shift of 16bit */
#define LCD_CLK_CK_PSC_shift_b2                     (0)                     /*!< Bit Shift of 8bit */

#define LCD_CLK_CK_PDIV_mask_w                      ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define LCD_CLK_CK_PDIV_mask_h0                     ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define LCD_CLK_CK_PDIV_mask_b1                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define LCD_CLK_CK_PDIV_div8_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV8 of 32bit */
#define LCD_CLK_CK_PDIV_div8_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV8 of 16bit */
#define LCD_CLK_CK_PDIV_div8_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV8 of 8bit */
#define LCD_CLK_CK_PDIV_div16_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DIV16 of 32bit */
#define LCD_CLK_CK_PDIV_div16_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DIV16 of 16bit */
#define LCD_CLK_CK_PDIV_div16_b1                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV16 of 8bit */
#define LCD_CLK_CK_PDIV_div32_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):DIV32 of 32bit */
#define LCD_CLK_CK_PDIV_div32_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(0x2):DIV32 of 16bit */
#define LCD_CLK_CK_PDIV_div32_b1                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV32 of 8bit */
#define LCD_CLK_CK_PDIV_div64_w                     ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):DIV64 of 32bit */
#define LCD_CLK_CK_PDIV_div64_h0                    ((uint16_t)0x3000)      /*!< Bit Value =(0x3):DIV64 of 16bit */
#define LCD_CLK_CK_PDIV_div64_b1                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV64 of 8bit */
#define LCD_CLK_CK_PDIV_div128_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):DIV128 of 32bit */
#define LCD_CLK_CK_PDIV_div128_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(0x4):DIV128 of 16bit */
#define LCD_CLK_CK_PDIV_div128_b1                   ((uint8_t )0x40)        /*!< Bit Value =(0x4):DIV128 of 8bit */
#define LCD_CLK_CK_PDIV_div256_w                    ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):DIV256 of 32bit */
#define LCD_CLK_CK_PDIV_div256_h0                   ((uint16_t)0x5000)      /*!< Bit Value =(0x5):DIV256 of 16bit */
#define LCD_CLK_CK_PDIV_div256_b1                   ((uint8_t )0x50)        /*!< Bit Value =(0x5):DIV256 of 8bit */
#define LCD_CLK_CK_PDIV_div512_w                    ((uint32_t)0x00006000)  /*!< Bit Value =(0x6):DIV512 of 32bit */
#define LCD_CLK_CK_PDIV_div512_h0                   ((uint16_t)0x6000)      /*!< Bit Value =(0x6):DIV512 of 16bit */
#define LCD_CLK_CK_PDIV_div512_b1                   ((uint8_t )0x60)        /*!< Bit Value =(0x6):DIV512 of 8bit */
#define LCD_CLK_CK_PDIV_div1024_w                   ((uint32_t)0x00007000)  /*!< Bit Value =(0x7):DIV1024 of 32bit */
#define LCD_CLK_CK_PDIV_div1024_h0                  ((uint16_t)0x7000)      /*!< Bit Value =(0x7):DIV1024 of 16bit */
#define LCD_CLK_CK_PDIV_div1024_b1                  ((uint8_t )0x70)        /*!< Bit Value =(0x7):DIV1024 of 8bit */

#define LCD_CLK_CK_DIV_mask_w                       ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define LCD_CLK_CK_DIV_mask_h0                      ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define LCD_CLK_CK_DIV_mask_b1                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define LCD_CLK_CK_DIV_div1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define LCD_CLK_CK_DIV_div1_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define LCD_CLK_CK_DIV_div1_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define LCD_CLK_CK_DIV_div2_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define LCD_CLK_CK_DIV_div2_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define LCD_CLK_CK_DIV_div2_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define LCD_CLK_CK_DIV_div4_w                       ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define LCD_CLK_CK_DIV_div4_h0                      ((uint16_t)0x0200)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define LCD_CLK_CK_DIV_div4_b1                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define LCD_CLK_CK_DIV_div8_w                       ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define LCD_CLK_CK_DIV_div8_h0                      ((uint16_t)0x0300)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define LCD_CLK_CK_DIV_div8_b1                      ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV8 of 8bit */
#define LCD_CLK_CK_DIV_div16_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):DIV16 of 32bit */
#define LCD_CLK_CK_DIV_div16_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x4):DIV16 of 16bit */
#define LCD_CLK_CK_DIV_div16_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x4):DIV16 of 8bit */
#define LCD_CLK_CK_DIV_div32_w                      ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):DIV32 of 32bit */
#define LCD_CLK_CK_DIV_div32_h0                     ((uint16_t)0x0500)      /*!< Bit Value =(0x5):DIV32 of 16bit */
#define LCD_CLK_CK_DIV_div32_b1                     ((uint8_t )0x05)        /*!< Bit Value =(0x5):DIV32 of 8bit */
#define LCD_CLK_CK_DIV_div64_w                      ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):DIV64 of 32bit */
#define LCD_CLK_CK_DIV_div64_h0                     ((uint16_t)0x0600)      /*!< Bit Value =(0x6):DIV64 of 16bit */
#define LCD_CLK_CK_DIV_div64_b1                     ((uint8_t )0x06)        /*!< Bit Value =(0x6):DIV64 of 8bit */

#define LCD_CLK_CK_CDIV_mask_w                      ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define LCD_CLK_CK_CDIV_mask_h0                     ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define LCD_CLK_CK_CDIV_mask_b0                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define LCD_CLK_CK_CDIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define LCD_CLK_CK_CDIV_div1_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define LCD_CLK_CK_CDIV_div1_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define LCD_CLK_CK_CDIV_div2_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define LCD_CLK_CK_CDIV_div2_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define LCD_CLK_CK_CDIV_div2_b0                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define LCD_CLK_CK_CDIV_div3_w                      ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV3 of 32bit */
#define LCD_CLK_CK_CDIV_div3_h0                     ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV3 of 16bit */
#define LCD_CLK_CK_CDIV_div3_b0                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV3 of 8bit */
#define LCD_CLK_CK_CDIV_div4_w                      ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV4 of 32bit */
#define LCD_CLK_CK_CDIV_div4_h0                     ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV4 of 16bit */
#define LCD_CLK_CK_CDIV_div4_b0                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV4 of 8bit */

#define LCD_CLK_CK_SEL_mask_w                       ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define LCD_CLK_CK_SEL_mask_h0                      ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define LCD_CLK_CK_SEL_mask_b0                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define LCD_CLK_CK_SEL_ck_ls_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_LS of 32bit */
#define LCD_CLK_CK_SEL_ck_ls_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_LS of 16bit */
#define LCD_CLK_CK_SEL_ck_ls_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_LS of 8bit */
#define LCD_CLK_CK_SEL_nco_p0_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):NCO_P0 of 32bit */
#define LCD_CLK_CK_SEL_nco_p0_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(0x1):NCO_P0 of 16bit */
#define LCD_CLK_CK_SEL_nco_p0_b0                    ((uint8_t )0x04)        /*!< Bit Value =(0x1):NCO_P0 of 8bit */
#define LCD_CLK_CK_SEL_proc_w                       ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):PROC of 32bit */
#define LCD_CLK_CK_SEL_proc_h0                      ((uint16_t)0x0008)      /*!< Bit Value =(0x2):PROC of 16bit */
#define LCD_CLK_CK_SEL_proc_b0                      ((uint8_t )0x08)        /*!< Bit Value =(0x2):PROC of 8bit */
#define LCD_CLK_CK_SEL_tm01_trgo_w                  ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):TM01_TRGO of 32bit */
#define LCD_CLK_CK_SEL_tm01_trgo_h0                 ((uint16_t)0x000C)      /*!< Bit Value =(0x3):TM01_TRGO of 16bit */
#define LCD_CLK_CK_SEL_tm01_trgo_b0                 ((uint8_t )0x0C)        /*!< Bit Value =(0x3):TM01_TRGO of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_CR0  [register's definitions]
 *              Offset[0x10]  LCD control register 0 (0x5A000010)
 ******************************************************************************
 */
///@{
#define LCD_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_CR0 */
#define LCD_CR0_DT_PW_mask_w                        ((uint32_t)0x0F000000)  /*!< Bit Mask of 32bit */
#define LCD_CR0_DT_PW_mask_h1                       ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define LCD_CR0_DT_PW_mask_b3                       ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define LCD_CR0_DT_PW_shift_w                       (24)                    /*!< Bit Shift of 32bit */
#define LCD_CR0_DT_PW_shift_h1                      (8)                     /*!< Bit Shift of 16bit */
#define LCD_CR0_DT_PW_shift_b3                      (0)                     /*!< Bit Shift of 8bit */

#define LCD_CR0_S1_SEL_mask_w                       ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define LCD_CR0_S1_SEL_mask_h1                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define LCD_CR0_S1_SEL_mask_b2                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define LCD_CR0_S1_SEL_out1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):OUT1 of 32bit */
#define LCD_CR0_S1_SEL_out1_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):OUT1 of 16bit */
#define LCD_CR0_S1_SEL_out1_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):OUT1 of 8bit */
#define LCD_CR0_S1_SEL_pcki_w                       ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):PCKI of 32bit */
#define LCD_CR0_S1_SEL_pcki_h1                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):PCKI of 16bit */
#define LCD_CR0_S1_SEL_pcki_b2                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):PCKI of 8bit */
#define LCD_CR0_S1_SEL_rmode_w                      ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):RMODE of 32bit */
#define LCD_CR0_S1_SEL_rmode_h1                     ((uint16_t)0x0020)      /*!< Bit Value =(0x2):RMODE of 16bit */
#define LCD_CR0_S1_SEL_rmode_b2                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):RMODE of 8bit */
#define LCD_CR0_S1_SEL_pgo_w                        ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):PGO of 32bit */
#define LCD_CR0_S1_SEL_pgo_h1                       ((uint16_t)0x0030)      /*!< Bit Value =(0x3):PGO of 16bit */
#define LCD_CR0_S1_SEL_pgo_b2                       ((uint8_t )0x30)        /*!< Bit Value =(0x3):PGO of 8bit */

#define LCD_CR0_S0_SEL_mask_w                       ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define LCD_CR0_S0_SEL_mask_h1                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define LCD_CR0_S0_SEL_mask_b2                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define LCD_CR0_S0_SEL_pmp_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):PMP of 32bit */
#define LCD_CR0_S0_SEL_pmp_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):PMP of 16bit */
#define LCD_CR0_S0_SEL_pmp_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):PMP of 8bit */
#define LCD_CR0_S0_SEL_phs_w                        ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):PHS of 32bit */
#define LCD_CR0_S0_SEL_phs_h1                       ((uint16_t)0x0001)      /*!< Bit Value =(0x1):PHS of 16bit */
#define LCD_CR0_S0_SEL_phs_b2                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):PHS of 8bit */
#define LCD_CR0_S0_SEL_frm_w                        ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):FRM of 32bit */
#define LCD_CR0_S0_SEL_frm_h1                       ((uint16_t)0x0002)      /*!< Bit Value =(0x2):FRM of 16bit */
#define LCD_CR0_S0_SEL_frm_b2                       ((uint8_t )0x02)        /*!< Bit Value =(0x2):FRM of 8bit */
#define LCD_CR0_S0_SEL_int_w                        ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):INT of 32bit */
#define LCD_CR0_S0_SEL_int_h1                       ((uint16_t)0x0003)      /*!< Bit Value =(0x3):INT of 16bit */
#define LCD_CR0_S0_SEL_int_b2                       ((uint8_t )0x03)        /*!< Bit Value =(0x3):INT of 8bit */

#define LCD_CR0_DUTY_mask_w                         ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define LCD_CR0_DUTY_mask_h0                        ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define LCD_CR0_DUTY_mask_b1                        ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define LCD_CR0_DUTY_static_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Static of 32bit */
#define LCD_CR0_DUTY_static_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Static of 16bit */
#define LCD_CR0_DUTY_static_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):Static of 8bit */
#define LCD_CR0_DUTY_d12_w                          ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):D12 of 32bit */
#define LCD_CR0_DUTY_d12_h0                         ((uint16_t)0x1000)      /*!< Bit Value =(0x1):D12 of 16bit */
#define LCD_CR0_DUTY_d12_b1                         ((uint8_t )0x10)        /*!< Bit Value =(0x1):D12 of 8bit */
#define LCD_CR0_DUTY_d13_w                          ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):D13 of 32bit */
#define LCD_CR0_DUTY_d13_h0                         ((uint16_t)0x2000)      /*!< Bit Value =(0x2):D13 of 16bit */
#define LCD_CR0_DUTY_d13_b1                         ((uint8_t )0x20)        /*!< Bit Value =(0x2):D13 of 8bit */
#define LCD_CR0_DUTY_d14_w                          ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):D14 of 32bit */
#define LCD_CR0_DUTY_d14_h0                         ((uint16_t)0x3000)      /*!< Bit Value =(0x3):D14 of 16bit */
#define LCD_CR0_DUTY_d14_b1                         ((uint8_t )0x30)        /*!< Bit Value =(0x3):D14 of 8bit */
#define LCD_CR0_DUTY_d15_w                          ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):D15 of 32bit */
#define LCD_CR0_DUTY_d15_h0                         ((uint16_t)0x4000)      /*!< Bit Value =(0x4):D15 of 16bit */
#define LCD_CR0_DUTY_d15_b1                         ((uint8_t )0x40)        /*!< Bit Value =(0x4):D15 of 8bit */
#define LCD_CR0_DUTY_d16_w                          ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):D16 of 32bit */
#define LCD_CR0_DUTY_d16_h0                         ((uint16_t)0x5000)      /*!< Bit Value =(0x5):D16 of 16bit */
#define LCD_CR0_DUTY_d16_b1                         ((uint8_t )0x50)        /*!< Bit Value =(0x5):D16 of 8bit */
#define LCD_CR0_DUTY_d17_w                          ((uint32_t)0x00006000)  /*!< Bit Value =(0x6):D17 of 32bit */
#define LCD_CR0_DUTY_d17_h0                         ((uint16_t)0x6000)      /*!< Bit Value =(0x6):D17 of 16bit */
#define LCD_CR0_DUTY_d17_b1                         ((uint8_t )0x60)        /*!< Bit Value =(0x6):D17 of 8bit */
#define LCD_CR0_DUTY_d18_w                          ((uint32_t)0x00007000)  /*!< Bit Value =(0x7):D18 of 32bit */
#define LCD_CR0_DUTY_d18_h0                         ((uint16_t)0x7000)      /*!< Bit Value =(0x7):D18 of 16bit */
#define LCD_CR0_DUTY_d18_b1                         ((uint8_t )0x70)        /*!< Bit Value =(0x7):D18 of 8bit */

#define LCD_CR0_RL_SEL_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define LCD_CR0_RL_SEL_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define LCD_CR0_RL_SEL_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_CR0_RL_SEL_int_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):INT of 32bit */
#define LCD_CR0_RL_SEL_int_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):INT of 16bit */
#define LCD_CR0_RL_SEL_int_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):INT of 8bit */
#define LCD_CR0_RL_SEL_ext_w                        ((uint32_t)0x00000800)  /*!< Bit Value =(0x1):EXT of 32bit */
#define LCD_CR0_RL_SEL_ext_h0                       ((uint16_t)0x0800)      /*!< Bit Value =(0x1):EXT of 16bit */
#define LCD_CR0_RL_SEL_ext_b1                       ((uint8_t )0x08)        /*!< Bit Value =(0x1):EXT of 8bit */

#define LCD_CR0_BIAS_mask_w                         ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define LCD_CR0_BIAS_mask_h0                        ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define LCD_CR0_BIAS_mask_b1                        ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define LCD_CR0_BIAS_static_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Static of 32bit */
#define LCD_CR0_BIAS_static_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Static of 16bit */
#define LCD_CR0_BIAS_static_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):Static of 8bit */
#define LCD_CR0_BIAS_b12_w                          ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):B12 of 32bit */
#define LCD_CR0_BIAS_b12_h0                         ((uint16_t)0x0100)      /*!< Bit Value =(0x1):B12 of 16bit */
#define LCD_CR0_BIAS_b12_b1                         ((uint8_t )0x01)        /*!< Bit Value =(0x1):B12 of 8bit */
#define LCD_CR0_BIAS_b13_w                          ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):B13 of 32bit */
#define LCD_CR0_BIAS_b13_h0                         ((uint16_t)0x0200)      /*!< Bit Value =(0x2):B13 of 16bit */
#define LCD_CR0_BIAS_b13_b1                         ((uint8_t )0x02)        /*!< Bit Value =(0x2):B13 of 8bit */
#define LCD_CR0_BIAS_b14_w                          ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):B14 of 32bit */
#define LCD_CR0_BIAS_b14_h0                         ((uint16_t)0x0300)      /*!< Bit Value =(0x3):B14 of 16bit */
#define LCD_CR0_BIAS_b14_b1                         ((uint8_t )0x03)        /*!< Bit Value =(0x3):B14 of 8bit */

#define LCD_CR0_CS_INV_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define LCD_CR0_CS_INV_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define LCD_CR0_CS_INV_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_CR0_CS_INV_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define LCD_CR0_CS_INV_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define LCD_CR0_CS_INV_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define LCD_CR0_CS_INV_inverse_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Inverse of 32bit */
#define LCD_CR0_CS_INV_inverse_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Inverse of 16bit */
#define LCD_CR0_CS_INV_inverse_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Inverse of 8bit */

#define LCD_CR0_DT_MDS_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define LCD_CR0_DT_MDS_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_CR0_DT_MDS_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_CR0_DT_MDS_frame_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Frame of 32bit */
#define LCD_CR0_DT_MDS_frame_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Frame of 16bit */
#define LCD_CR0_DT_MDS_frame_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Frame of 8bit */
#define LCD_CR0_DT_MDS_duty_w                       ((uint32_t)0x00000040)  /*!< Bit Value =(1):Duty of 32bit */
#define LCD_CR0_DT_MDS_duty_h0                      ((uint16_t)0x0040)      /*!< Bit Value =(1):Duty of 16bit */
#define LCD_CR0_DT_MDS_duty_b0                      ((uint8_t )0x40)        /*!< Bit Value =(1):Duty of 8bit */

#define LCD_CR0_FRM_MDS_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define LCD_CR0_FRM_MDS_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define LCD_CR0_FRM_MDS_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_CR0_FRM_MDS_typea_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):TYPEA of 32bit */
#define LCD_CR0_FRM_MDS_typea_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):TYPEA of 16bit */
#define LCD_CR0_FRM_MDS_typea_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):TYPEA of 8bit */
#define LCD_CR0_FRM_MDS_typeb_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):TYPEB of 32bit */
#define LCD_CR0_FRM_MDS_typeb_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):TYPEB of 16bit */
#define LCD_CR0_FRM_MDS_typeb_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):TYPEB of 8bit */

#define LCD_CR0_VS_SEL_mask_w                       ((uint32_t)0x00000006)  /*!< Bit Mask of 32bit */
#define LCD_CR0_VS_SEL_mask_h0                      ((uint16_t)0x0006)      /*!< Bit Mask of 16bit */
#define LCD_CR0_VS_SEL_mask_b0                      ((uint8_t )0x06)        /*!< Bit Mask of 8bit */
#define LCD_CR0_VS_SEL_off_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Off of 32bit */
#define LCD_CR0_VS_SEL_off_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Off of 16bit */
#define LCD_CR0_VS_SEL_off_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):Off of 8bit */
#define LCD_CR0_VS_SEL_avdd_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(0x1):AVDD of 32bit */
#define LCD_CR0_VS_SEL_avdd_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(0x1):AVDD of 16bit */
#define LCD_CR0_VS_SEL_avdd_b0                      ((uint8_t )0x02)        /*!< Bit Value =(0x1):AVDD of 8bit */
#define LCD_CR0_VS_SEL_ext_w                        ((uint32_t)0x00000004)  /*!< Bit Value =(0x2):EXT of 32bit */
#define LCD_CR0_VS_SEL_ext_h0                       ((uint16_t)0x0004)      /*!< Bit Value =(0x2):EXT of 16bit */
#define LCD_CR0_VS_SEL_ext_b0                       ((uint8_t )0x04)        /*!< Bit Value =(0x2):EXT of 8bit */
#define LCD_CR0_VS_SEL_cp_w                         ((uint32_t)0x00000006)  /*!< Bit Value =(0x3):CP of 32bit */
#define LCD_CR0_VS_SEL_cp_h0                        ((uint16_t)0x0006)      /*!< Bit Value =(0x3):CP of 16bit */
#define LCD_CR0_VS_SEL_cp_b0                        ((uint8_t )0x06)        /*!< Bit Value =(0x3):CP of 8bit */

#define LCD_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define LCD_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define LCD_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_CR1  [register's definitions]
 *              Offset[0x14]  LCD control register 1 (0x5A000014)
 ******************************************************************************
 */
///@{
#define LCD_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_CR1 */
#define LCD_CR1_DRV_PW_mask_w                       ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define LCD_CR1_DRV_PW_mask_h1                      ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define LCD_CR1_DRV_PW_mask_b3                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define LCD_CR1_DRV_PW_shift_w                      (24)                    /*!< Bit Shift of 32bit */
#define LCD_CR1_DRV_PW_shift_h1                     (8)                     /*!< Bit Shift of 16bit */
#define LCD_CR1_DRV_PW_shift_b3                     (0)                     /*!< Bit Shift of 8bit */

#define LCD_CR1_VT_SEL_mask_w                       ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define LCD_CR1_VT_SEL_mask_h1                      ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define LCD_CR1_VT_SEL_mask_b2                      ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define LCD_CR1_VT_SEL_lvl0_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LVL0 of 32bit */
#define LCD_CR1_VT_SEL_lvl0_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LVL0 of 16bit */
#define LCD_CR1_VT_SEL_lvl0_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):LVL0 of 8bit */
#define LCD_CR1_VT_SEL_lvl1_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):LVL1 of 32bit */
#define LCD_CR1_VT_SEL_lvl1_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):LVL1 of 16bit */
#define LCD_CR1_VT_SEL_lvl1_b2                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):LVL1 of 8bit */
#define LCD_CR1_VT_SEL_lvl2_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):LVL2 of 32bit */
#define LCD_CR1_VT_SEL_lvl2_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):LVL2 of 16bit */
#define LCD_CR1_VT_SEL_lvl2_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):LVL2 of 8bit */
#define LCD_CR1_VT_SEL_lvl3_w                       ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):LVL3 of 32bit */
#define LCD_CR1_VT_SEL_lvl3_h1                      ((uint16_t)0x0003)      /*!< Bit Value =(0x3):LVL3 of 16bit */
#define LCD_CR1_VT_SEL_lvl3_b2                      ((uint8_t )0x03)        /*!< Bit Value =(0x3):LVL3 of 8bit */
#define LCD_CR1_VT_SEL_lvl4_w                       ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):LVL4 of 32bit */
#define LCD_CR1_VT_SEL_lvl4_h1                      ((uint16_t)0x0004)      /*!< Bit Value =(0x4):LVL4 of 16bit */
#define LCD_CR1_VT_SEL_lvl4_b2                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):LVL4 of 8bit */
#define LCD_CR1_VT_SEL_lvl5_w                       ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):LVL5 of 32bit */
#define LCD_CR1_VT_SEL_lvl5_h1                      ((uint16_t)0x0005)      /*!< Bit Value =(0x5):LVL5 of 16bit */
#define LCD_CR1_VT_SEL_lvl5_b2                      ((uint8_t )0x05)        /*!< Bit Value =(0x5):LVL5 of 8bit */
#define LCD_CR1_VT_SEL_lvl6_w                       ((uint32_t)0x00060000)  /*!< Bit Value =(0x6):LVL6 of 32bit */
#define LCD_CR1_VT_SEL_lvl6_h1                      ((uint16_t)0x0006)      /*!< Bit Value =(0x6):LVL6 of 16bit */
#define LCD_CR1_VT_SEL_lvl6_b2                      ((uint8_t )0x06)        /*!< Bit Value =(0x6):LVL6 of 8bit */
#define LCD_CR1_VT_SEL_lvl7_w                       ((uint32_t)0x00070000)  /*!< Bit Value =(0x7):LVL7 of 32bit */
#define LCD_CR1_VT_SEL_lvl7_h1                      ((uint16_t)0x0007)      /*!< Bit Value =(0x7):LVL7 of 16bit */
#define LCD_CR1_VT_SEL_lvl7_b2                      ((uint8_t )0x07)        /*!< Bit Value =(0x7):LVL7 of 8bit */
#define LCD_CR1_VT_SEL_lvl8_w                       ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):LVL8 of 32bit */
#define LCD_CR1_VT_SEL_lvl8_h1                      ((uint16_t)0x0008)      /*!< Bit Value =(0x8):LVL8 of 16bit */
#define LCD_CR1_VT_SEL_lvl8_b2                      ((uint8_t )0x08)        /*!< Bit Value =(0x8):LVL8 of 8bit */
#define LCD_CR1_VT_SEL_lvl9_w                       ((uint32_t)0x00090000)  /*!< Bit Value =(0x9):LVL9 of 32bit */
#define LCD_CR1_VT_SEL_lvl9_h1                      ((uint16_t)0x0009)      /*!< Bit Value =(0x9):LVL9 of 16bit */
#define LCD_CR1_VT_SEL_lvl9_b2                      ((uint8_t )0x09)        /*!< Bit Value =(0x9):LVL9 of 8bit */
#define LCD_CR1_VT_SEL_lvl10_w                      ((uint32_t)0x000A0000)  /*!< Bit Value =(0xA):LVL10 of 32bit */
#define LCD_CR1_VT_SEL_lvl10_h1                     ((uint16_t)0x000A)      /*!< Bit Value =(0xA):LVL10 of 16bit */
#define LCD_CR1_VT_SEL_lvl10_b2                     ((uint8_t )0x0A)        /*!< Bit Value =(0xA):LVL10 of 8bit */
#define LCD_CR1_VT_SEL_lvl11_w                      ((uint32_t)0x000B0000)  /*!< Bit Value =(0xB):LVL11 of 32bit */
#define LCD_CR1_VT_SEL_lvl11_h1                     ((uint16_t)0x000B)      /*!< Bit Value =(0xB):LVL11 of 16bit */
#define LCD_CR1_VT_SEL_lvl11_b2                     ((uint8_t )0x0B)        /*!< Bit Value =(0xB):LVL11 of 8bit */
#define LCD_CR1_VT_SEL_lvl12_w                      ((uint32_t)0x000C0000)  /*!< Bit Value =(0xC):LVL12 of 32bit */
#define LCD_CR1_VT_SEL_lvl12_h1                     ((uint16_t)0x000C)      /*!< Bit Value =(0xC):LVL12 of 16bit */
#define LCD_CR1_VT_SEL_lvl12_b2                     ((uint8_t )0x0C)        /*!< Bit Value =(0xC):LVL12 of 8bit */
#define LCD_CR1_VT_SEL_lvl13_w                      ((uint32_t)0x000D0000)  /*!< Bit Value =(0xD):LVL13 of 32bit */
#define LCD_CR1_VT_SEL_lvl13_h1                     ((uint16_t)0x000D)      /*!< Bit Value =(0xD):LVL13 of 16bit */
#define LCD_CR1_VT_SEL_lvl13_b2                     ((uint8_t )0x0D)        /*!< Bit Value =(0xD):LVL13 of 8bit */
#define LCD_CR1_VT_SEL_lvl14_w                      ((uint32_t)0x000E0000)  /*!< Bit Value =(0xE):LVL14 of 32bit */
#define LCD_CR1_VT_SEL_lvl14_h1                     ((uint16_t)0x000E)      /*!< Bit Value =(0xE):LVL14 of 16bit */
#define LCD_CR1_VT_SEL_lvl14_b2                     ((uint8_t )0x0E)        /*!< Bit Value =(0xE):LVL14 of 8bit */

#define LCD_CR1_V3_CTL_mask_w                       ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define LCD_CR1_V3_CTL_mask_h0                      ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define LCD_CR1_V3_CTL_mask_b1                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_CR1_V3_CTL_nc_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):NC of 32bit */
#define LCD_CR1_V3_CTL_nc_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):NC of 16bit */
#define LCD_CR1_V3_CTL_nc_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):NC of 8bit */
#define LCD_CR1_V3_CTL_pin1_w                       ((uint32_t)0x00004000)  /*!< Bit Value =(1):Pin1 of 32bit */
#define LCD_CR1_V3_CTL_pin1_h0                      ((uint16_t)0x4000)      /*!< Bit Value =(1):Pin1 of 16bit */
#define LCD_CR1_V3_CTL_pin1_b1                      ((uint8_t )0x40)        /*!< Bit Value =(1):Pin1 of 8bit */

#define LCD_CR1_V2_CTL_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define LCD_CR1_V2_CTL_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define LCD_CR1_V2_CTL_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_CR1_V2_CTL_nc_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):NC of 32bit */
#define LCD_CR1_V2_CTL_nc_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):NC of 16bit */
#define LCD_CR1_V2_CTL_nc_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):NC of 8bit */
#define LCD_CR1_V2_CTL_pin1_w                       ((uint32_t)0x00001000)  /*!< Bit Value =(1):Pin1 of 32bit */
#define LCD_CR1_V2_CTL_pin1_h0                      ((uint16_t)0x1000)      /*!< Bit Value =(1):Pin1 of 16bit */
#define LCD_CR1_V2_CTL_pin1_b1                      ((uint8_t )0x10)        /*!< Bit Value =(1):Pin1 of 8bit */

#define LCD_CR1_V1_CTL_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define LCD_CR1_V1_CTL_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define LCD_CR1_V1_CTL_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_CR1_V1_CTL_nc_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):NC of 32bit */
#define LCD_CR1_V1_CTL_nc_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):NC of 16bit */
#define LCD_CR1_V1_CTL_nc_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):NC of 8bit */
#define LCD_CR1_V1_CTL_pin1_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(1):Pin1 of 32bit */
#define LCD_CR1_V1_CTL_pin1_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(1):Pin1 of 16bit */
#define LCD_CR1_V1_CTL_pin1_b1                      ((uint8_t )0x04)        /*!< Bit Value =(1):Pin1 of 8bit */

#define LCD_CR1_VT_CTL_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define LCD_CR1_VT_CTL_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_CR1_VT_CTL_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_CR1_VT_CTL_nc_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):NC of 32bit */
#define LCD_CR1_VT_CTL_nc_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):NC of 16bit */
#define LCD_CR1_VT_CTL_nc_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):NC of 8bit */
#define LCD_CR1_VT_CTL_pin1_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(1):Pin1 of 32bit */
#define LCD_CR1_VT_CTL_pin1_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(1):Pin1 of 16bit */
#define LCD_CR1_VT_CTL_pin1_b1                      ((uint8_t )0x01)        /*!< Bit Value =(1):Pin1 of 8bit */

#define LCD_CR1_CP_SYNC_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define LCD_CR1_CP_SYNC_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define LCD_CR1_CP_SYNC_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_CR1_CP_SYNC_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_CR1_CP_SYNC_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_CR1_CP_SYNC_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_CR1_CP_SYNC_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_CR1_CP_SYNC_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_CR1_CP_SYNC_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define LCD_CR1_OFF_CTL_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define LCD_CR1_OFF_CTL_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_CR1_OFF_CTL_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_CR1_OFF_CTL_hiz_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Hiz of 32bit */
#define LCD_CR1_OFF_CTL_hiz_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Hiz of 16bit */
#define LCD_CR1_OFF_CTL_hiz_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Hiz of 8bit */
#define LCD_CR1_OFF_CTL_low_w                       ((uint32_t)0x00000040)  /*!< Bit Value =(1):Low of 32bit */
#define LCD_CR1_OFF_CTL_low_h0                      ((uint16_t)0x0040)      /*!< Bit Value =(1):Low of 16bit */
#define LCD_CR1_OFF_CTL_low_b0                      ((uint8_t )0x40)        /*!< Bit Value =(1):Low of 8bit */

#define LCD_CR1_DRV_MDS_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define LCD_CR1_DRV_MDS_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define LCD_CR1_DRV_MDS_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_CR1_DRV_MDS_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define LCD_CR1_DRV_MDS_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define LCD_CR1_DRV_MDS_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define LCD_CR1_DRV_MDS_high_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):High of 32bit */
#define LCD_CR1_DRV_MDS_high_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):High of 16bit */
#define LCD_CR1_DRV_MDS_high_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):High of 8bit */

#define LCD_CR1_OVD_DIS_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define LCD_CR1_OVD_DIS_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define LCD_CR1_OVD_DIS_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_CR1_OVD_DIS_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define LCD_CR1_OVD_DIS_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define LCD_CR1_OVD_DIS_enable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define LCD_CR1_OVD_DIS_disable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Disable of 32bit */
#define LCD_CR1_OVD_DIS_disable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Disable of 16bit */
#define LCD_CR1_OVD_DIS_disable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Disable of 8bit */

#define LCD_CR1_CP_EN_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define LCD_CR1_CP_EN_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define LCD_CR1_CP_EN_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_CR1_CP_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define LCD_CR1_CP_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define LCD_CR1_CP_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define LCD_CR1_CP_EN_enable_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_CR1_CP_EN_enable_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_CR1_CP_EN_enable_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_CR2  [register's definitions]
 *              Offset[0x18]  LCD control register 2 (0x5A000018)
 ******************************************************************************
 */
///@{
#define LCD_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_CR2 */
#define LCD_CR2_CP_CNT_mask_w                       ((uint32_t)0x7F000000)  /*!< Bit Mask of 32bit */
#define LCD_CR2_CP_CNT_mask_h1                      ((uint16_t)0x7F00)      /*!< Bit Mask of 16bit */
#define LCD_CR2_CP_CNT_mask_b3                      ((uint8_t )0x7F)        /*!< Bit Mask of 8bit */
#define LCD_CR2_CP_CNT_shift_w                      (24)                    /*!< Bit Shift of 32bit */
#define LCD_CR2_CP_CNT_shift_h1                     (8)                     /*!< Bit Shift of 16bit */
#define LCD_CR2_CP_CNT_shift_b3                     (0)                     /*!< Bit Shift of 8bit */

#define LCD_CR2_BCNT_mask_w                         ((uint32_t)0x001F0000)  /*!< Bit Mask of 32bit */
#define LCD_CR2_BCNT_mask_h1                        ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define LCD_CR2_BCNT_mask_b2                        ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define LCD_CR2_BCNT_shift_w                        (16)                    /*!< Bit Shift of 32bit */
#define LCD_CR2_BCNT_shift_h1                       (0)                     /*!< Bit Shift of 16bit */
#define LCD_CR2_BCNT_shift_b2                       (0)                     /*!< Bit Shift of 8bit */

#define LCD_CR2_SEG_OFF_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define LCD_CR2_SEG_OFF_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define LCD_CR2_SEG_OFF_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_CR2_SEG_OFF_on_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):On of 32bit */
#define LCD_CR2_SEG_OFF_on_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):On of 16bit */
#define LCD_CR2_SEG_OFF_on_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):On of 8bit */
#define LCD_CR2_SEG_OFF_off_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(1):Off of 32bit */
#define LCD_CR2_SEG_OFF_off_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(1):Off of 16bit */
#define LCD_CR2_SEG_OFF_off_b1                      ((uint8_t )0x04)        /*!< Bit Value =(1):Off of 8bit */

#define LCD_CR2_BLK_MDS_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define LCD_CR2_BLK_MDS_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_CR2_BLK_MDS_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_CR2_BLK_MDS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define LCD_CR2_BLK_MDS_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define LCD_CR2_BLK_MDS_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define LCD_CR2_BLK_MDS_all_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):All of 32bit */
#define LCD_CR2_BLK_MDS_all_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):All of 16bit */
#define LCD_CR2_BLK_MDS_all_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):All of 8bit */

#define LCD_CR2_MEM_CLR_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define LCD_CR2_MEM_CLR_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define LCD_CR2_MEM_CLR_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_CR2_MEM_CLR_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define LCD_CR2_MEM_CLR_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define LCD_CR2_MEM_CLR_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define LCD_CR2_MEM_CLR_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define LCD_CR2_MEM_CLR_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define LCD_CR2_MEM_CLR_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MUX0  [register's definitions]
 *              Offset[0x20]  LCD COM SEG select register 0 (0x5A000020)
 ******************************************************************************
 */
///@{
#define LCD_MUX0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MUX0 */
#define LCD_MUX0_CS31_mask_w                        ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS31_mask_h1                       ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS31_mask_b3                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS31_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS31_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS31_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS31_com_w                         ((uint32_t)0x80000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS31_com_h1                        ((uint16_t)0x8000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS31_com_b3                        ((uint8_t )0x80)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS30_mask_w                        ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS30_mask_h1                       ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS30_mask_b3                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS30_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS30_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS30_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS30_com_w                         ((uint32_t)0x40000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS30_com_h1                        ((uint16_t)0x4000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS30_com_b3                        ((uint8_t )0x40)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS29_mask_w                        ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS29_mask_h1                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS29_mask_b3                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS29_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS29_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS29_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS29_com_w                         ((uint32_t)0x20000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS29_com_h1                        ((uint16_t)0x2000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS29_com_b3                        ((uint8_t )0x20)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS28_mask_w                        ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS28_mask_h1                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS28_mask_b3                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS28_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS28_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS28_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS28_com_w                         ((uint32_t)0x10000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS28_com_h1                        ((uint16_t)0x1000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS28_com_b3                        ((uint8_t )0x10)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS27_mask_w                        ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS27_mask_h1                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS27_mask_b3                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS27_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS27_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS27_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS27_com_w                         ((uint32_t)0x08000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS27_com_h1                        ((uint16_t)0x0800)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS27_com_b3                        ((uint8_t )0x08)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS26_mask_w                        ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS26_mask_h1                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS26_mask_b3                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS26_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS26_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS26_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS26_com_w                         ((uint32_t)0x04000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS26_com_h1                        ((uint16_t)0x0400)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS26_com_b3                        ((uint8_t )0x04)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS25_mask_w                        ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS25_mask_h1                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS25_mask_b3                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS25_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS25_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS25_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS25_com_w                         ((uint32_t)0x02000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS25_com_h1                        ((uint16_t)0x0200)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS25_com_b3                        ((uint8_t )0x02)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS24_mask_w                        ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS24_mask_h1                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS24_mask_b3                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS24_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS24_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS24_seg_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS24_com_w                         ((uint32_t)0x01000000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS24_com_h1                        ((uint16_t)0x0100)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS24_com_b3                        ((uint8_t )0x01)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS23_mask_w                        ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS23_mask_h1                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS23_mask_b2                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS23_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS23_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS23_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS23_com_w                         ((uint32_t)0x00800000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS23_com_h1                        ((uint16_t)0x0080)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS23_com_b2                        ((uint8_t )0x80)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS22_mask_w                        ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS22_mask_h1                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS22_mask_b2                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS22_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS22_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS22_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS22_com_w                         ((uint32_t)0x00400000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS22_com_h1                        ((uint16_t)0x0040)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS22_com_b2                        ((uint8_t )0x40)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS21_mask_w                        ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS21_mask_h1                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS21_mask_b2                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS21_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS21_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS21_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS21_com_w                         ((uint32_t)0x00200000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS21_com_h1                        ((uint16_t)0x0020)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS21_com_b2                        ((uint8_t )0x20)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS20_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS20_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS20_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS20_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS20_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS20_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS20_com_w                         ((uint32_t)0x00100000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS20_com_h1                        ((uint16_t)0x0010)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS20_com_b2                        ((uint8_t )0x10)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS19_mask_w                        ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS19_mask_h1                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS19_mask_b2                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS19_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS19_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS19_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS19_com_w                         ((uint32_t)0x00080000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS19_com_h1                        ((uint16_t)0x0008)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS19_com_b2                        ((uint8_t )0x08)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS18_mask_w                        ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS18_mask_h1                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS18_mask_b2                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS18_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS18_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS18_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS18_com_w                         ((uint32_t)0x00040000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS18_com_h1                        ((uint16_t)0x0004)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS18_com_b2                        ((uint8_t )0x04)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS17_mask_w                        ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS17_mask_h1                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS17_mask_b2                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS17_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS17_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS17_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS17_com_w                         ((uint32_t)0x00020000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS17_com_h1                        ((uint16_t)0x0002)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS17_com_b2                        ((uint8_t )0x02)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS16_mask_w                        ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS16_mask_h1                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS16_mask_b2                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS16_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS16_seg_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS16_seg_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS16_com_w                         ((uint32_t)0x00010000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS16_com_h1                        ((uint16_t)0x0001)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS16_com_b2                        ((uint8_t )0x01)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS15_mask_w                        ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS15_mask_h0                       ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS15_mask_b1                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS15_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS15_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS15_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS15_com_w                         ((uint32_t)0x00008000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS15_com_h0                        ((uint16_t)0x8000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS15_com_b1                        ((uint8_t )0x80)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS14_mask_w                        ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS14_mask_h0                       ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS14_mask_b1                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS14_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS14_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS14_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS14_com_w                         ((uint32_t)0x00004000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS14_com_h0                        ((uint16_t)0x4000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS14_com_b1                        ((uint8_t )0x40)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS13_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS13_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS13_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS13_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS13_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS13_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS13_com_w                         ((uint32_t)0x00002000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS13_com_h0                        ((uint16_t)0x2000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS13_com_b1                        ((uint8_t )0x20)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS12_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS12_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS12_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS12_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS12_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS12_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS12_com_w                         ((uint32_t)0x00001000)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS12_com_h0                        ((uint16_t)0x1000)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS12_com_b1                        ((uint8_t )0x10)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS11_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS11_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS11_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS11_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS11_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS11_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS11_com_w                         ((uint32_t)0x00000800)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS11_com_h0                        ((uint16_t)0x0800)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS11_com_b1                        ((uint8_t )0x08)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS10_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS10_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS10_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS10_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS10_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS10_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS10_com_w                         ((uint32_t)0x00000400)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS10_com_h0                        ((uint16_t)0x0400)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS10_com_b1                        ((uint8_t )0x04)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS9_mask_w                         ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS9_mask_h0                        ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS9_mask_b1                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS9_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS9_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS9_seg_b1                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS9_com_w                          ((uint32_t)0x00000200)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS9_com_h0                         ((uint16_t)0x0200)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS9_com_b1                         ((uint8_t )0x02)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS8_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS8_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS8_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS8_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS8_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS8_seg_b1                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS8_com_w                          ((uint32_t)0x00000100)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS8_com_h0                         ((uint16_t)0x0100)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS8_com_b1                         ((uint8_t )0x01)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS7_mask_w                         ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS7_mask_h0                        ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS7_mask_b0                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS7_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS7_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS7_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS7_com_w                          ((uint32_t)0x00000080)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS7_com_h0                         ((uint16_t)0x0080)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS7_com_b0                         ((uint8_t )0x80)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS6_mask_w                         ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS6_mask_h0                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS6_mask_b0                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS6_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS6_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS6_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS6_com_w                          ((uint32_t)0x00000040)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS6_com_h0                         ((uint16_t)0x0040)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS6_com_b0                         ((uint8_t )0x40)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS5_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS5_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS5_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS5_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS5_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS5_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS5_com_w                          ((uint32_t)0x00000020)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS5_com_h0                         ((uint16_t)0x0020)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS5_com_b0                         ((uint8_t )0x20)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS4_mask_w                         ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS4_mask_h0                        ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS4_mask_b0                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS4_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS4_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS4_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS4_com_w                          ((uint32_t)0x00000010)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS4_com_h0                         ((uint16_t)0x0010)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS4_com_b0                         ((uint8_t )0x10)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS3_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS3_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS3_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS3_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS3_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS3_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS3_com_w                          ((uint32_t)0x00000008)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS3_com_h0                         ((uint16_t)0x0008)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS3_com_b0                         ((uint8_t )0x08)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS2_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS2_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS2_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS2_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS2_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS2_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS2_com_w                          ((uint32_t)0x00000004)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS2_com_h0                         ((uint16_t)0x0004)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS2_com_b0                         ((uint8_t )0x04)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS1_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS1_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS1_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS1_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS1_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS1_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS1_com_w                          ((uint32_t)0x00000002)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS1_com_h0                         ((uint16_t)0x0002)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS1_com_b0                         ((uint8_t )0x02)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX0_CS0_mask_w                         ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define LCD_MUX0_CS0_mask_h0                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define LCD_MUX0_CS0_mask_b0                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_MUX0_CS0_seg_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX0_CS0_seg_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX0_CS0_seg_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX0_CS0_com_w                          ((uint32_t)0x00000001)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX0_CS0_com_h0                         ((uint16_t)0x0001)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX0_CS0_com_b0                         ((uint8_t )0x01)        /*!< Bit Value =(1):COM of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MUX1  [register's definitions]
 *              Offset[0x24]  LCD COM SEG select register 1 (0x5A000024)
 ******************************************************************************
 */
///@{
#define LCD_MUX1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MUX1 */
#define LCD_MUX1_CS43_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS43_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS43_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS43_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS43_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS43_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS43_com_w                         ((uint32_t)0x00000800)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS43_com_h0                        ((uint16_t)0x0800)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS43_com_b1                        ((uint8_t )0x08)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS42_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS42_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS42_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS42_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS42_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS42_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS42_com_w                         ((uint32_t)0x00000400)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS42_com_h0                        ((uint16_t)0x0400)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS42_com_b1                        ((uint8_t )0x04)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS41_mask_w                        ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS41_mask_h0                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS41_mask_b1                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS41_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS41_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS41_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS41_com_w                         ((uint32_t)0x00000200)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS41_com_h0                        ((uint16_t)0x0200)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS41_com_b1                        ((uint8_t )0x02)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS40_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS40_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS40_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS40_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS40_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS40_seg_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS40_com_w                         ((uint32_t)0x00000100)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS40_com_h0                        ((uint16_t)0x0100)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS40_com_b1                        ((uint8_t )0x01)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS39_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS39_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS39_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS39_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS39_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS39_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS39_com_w                         ((uint32_t)0x00000080)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS39_com_h0                        ((uint16_t)0x0080)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS39_com_b0                        ((uint8_t )0x80)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS38_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS38_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS38_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS38_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS38_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS38_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS38_com_w                         ((uint32_t)0x00000040)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS38_com_h0                        ((uint16_t)0x0040)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS38_com_b0                        ((uint8_t )0x40)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS37_mask_w                        ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS37_mask_h0                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS37_mask_b0                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS37_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS37_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS37_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS37_com_w                         ((uint32_t)0x00000020)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS37_com_h0                        ((uint16_t)0x0020)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS37_com_b0                        ((uint8_t )0x20)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS36_mask_w                        ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS36_mask_h0                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS36_mask_b0                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS36_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS36_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS36_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS36_com_w                         ((uint32_t)0x00000010)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS36_com_h0                        ((uint16_t)0x0010)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS36_com_b0                        ((uint8_t )0x10)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS35_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS35_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS35_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS35_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS35_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS35_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS35_com_w                         ((uint32_t)0x00000008)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS35_com_h0                        ((uint16_t)0x0008)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS35_com_b0                        ((uint8_t )0x08)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS34_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS34_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS34_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS34_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS34_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS34_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS34_com_w                         ((uint32_t)0x00000004)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS34_com_h0                        ((uint16_t)0x0004)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS34_com_b0                        ((uint8_t )0x04)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS33_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS33_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS33_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS33_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS33_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS33_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS33_com_w                         ((uint32_t)0x00000002)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS33_com_h0                        ((uint16_t)0x0002)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS33_com_b0                        ((uint8_t )0x02)        /*!< Bit Value =(1):COM of 8bit */

#define LCD_MUX1_CS32_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define LCD_MUX1_CS32_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define LCD_MUX1_CS32_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define LCD_MUX1_CS32_seg_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):SEG of 32bit */
#define LCD_MUX1_CS32_seg_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):SEG of 16bit */
#define LCD_MUX1_CS32_seg_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):SEG of 8bit */
#define LCD_MUX1_CS32_com_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):COM of 32bit */
#define LCD_MUX1_CS32_com_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):COM of 16bit */
#define LCD_MUX1_CS32_com_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):COM of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD0  [register's definitions]
 *              Offset[0x30]  LCD display memory data register 0 (0x5A000030)
 ******************************************************************************
 */
///@{
#define LCD_MD0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD0 */
#define LCD_MD0_M3_mask_w                           ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD0_M3_mask_h1                          ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD0_M3_mask_b3                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD0_M3_shift_w                          (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD0_M3_shift_h1                         (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD0_M3_shift_b3                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD0_M2_mask_w                           ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD0_M2_mask_h1                          ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD0_M2_mask_b2                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD0_M2_shift_w                          (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD0_M2_shift_h1                         (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD0_M2_shift_b2                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD0_M1_mask_w                           ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD0_M1_mask_h0                          ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD0_M1_mask_b1                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD0_M1_shift_w                          (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD0_M1_shift_h0                         (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD0_M1_shift_b1                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD0_M0_mask_w                           ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD0_M0_mask_h0                          ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD0_M0_mask_b0                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD0_M0_shift_w                          (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD0_M0_shift_h0                         (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD0_M0_shift_b0                         (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD1  [register's definitions]
 *              Offset[0x34]  LCD display memory data register 1 (0x5A000034)
 ******************************************************************************
 */
///@{
#define LCD_MD1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD1 */
#define LCD_MD1_M7_mask_w                           ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD1_M7_mask_h1                          ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD1_M7_mask_b3                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD1_M7_shift_w                          (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD1_M7_shift_h1                         (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD1_M7_shift_b3                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD1_M6_mask_w                           ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD1_M6_mask_h1                          ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD1_M6_mask_b2                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD1_M6_shift_w                          (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD1_M6_shift_h1                         (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD1_M6_shift_b2                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD1_M5_mask_w                           ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD1_M5_mask_h0                          ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD1_M5_mask_b1                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD1_M5_shift_w                          (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD1_M5_shift_h0                         (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD1_M5_shift_b1                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD1_M4_mask_w                           ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD1_M4_mask_h0                          ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD1_M4_mask_b0                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD1_M4_shift_w                          (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD1_M4_shift_h0                         (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD1_M4_shift_b0                         (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD2  [register's definitions]
 *              Offset[0x38]  LCD display memory data register 2 (0x5A000038)
 ******************************************************************************
 */
///@{
#define LCD_MD2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD2 */
#define LCD_MD2_M11_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD2_M11_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD2_M11_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD2_M11_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD2_M11_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD2_M11_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD2_M10_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD2_M10_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD2_M10_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD2_M10_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD2_M10_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD2_M10_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD2_M9_mask_w                           ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD2_M9_mask_h0                          ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD2_M9_mask_b1                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD2_M9_shift_w                          (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD2_M9_shift_h0                         (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD2_M9_shift_b1                         (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD2_M8_mask_w                           ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD2_M8_mask_h0                          ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD2_M8_mask_b0                          ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD2_M8_shift_w                          (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD2_M8_shift_h0                         (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD2_M8_shift_b0                         (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD3  [register's definitions]
 *              Offset[0x3C]  LCD display memory data register 3 (0x5A00003C)
 ******************************************************************************
 */
///@{
#define LCD_MD3_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD3 */
#define LCD_MD3_M15_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD3_M15_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD3_M15_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD3_M15_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD3_M15_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD3_M15_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD3_M14_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD3_M14_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD3_M14_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD3_M14_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD3_M14_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD3_M14_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD3_M13_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD3_M13_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD3_M13_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD3_M13_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD3_M13_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD3_M13_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD3_M12_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD3_M12_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD3_M12_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD3_M12_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD3_M12_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD3_M12_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD4  [register's definitions]
 *              Offset[0x40]  LCD display memory data register 4 (0x5A000040)
 ******************************************************************************
 */
///@{
#define LCD_MD4_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD4 */
#define LCD_MD4_M19_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD4_M19_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD4_M19_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD4_M19_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD4_M19_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD4_M19_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD4_M18_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD4_M18_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD4_M18_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD4_M18_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD4_M18_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD4_M18_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD4_M17_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD4_M17_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD4_M17_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD4_M17_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD4_M17_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD4_M17_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD4_M16_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD4_M16_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD4_M16_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD4_M16_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD4_M16_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD4_M16_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD5  [register's definitions]
 *              Offset[0x44]  LCD display memory data register 5 (0x5A000044)
 ******************************************************************************
 */
///@{
#define LCD_MD5_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD5 */
#define LCD_MD5_M23_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD5_M23_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD5_M23_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD5_M23_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD5_M23_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD5_M23_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD5_M22_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD5_M22_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD5_M22_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD5_M22_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD5_M22_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD5_M22_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD5_M21_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD5_M21_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD5_M21_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD5_M21_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD5_M21_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD5_M21_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD5_M20_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD5_M20_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD5_M20_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD5_M20_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD5_M20_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD5_M20_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD6  [register's definitions]
 *              Offset[0x48]  LCD display memory data register 6 (0x5A000048)
 ******************************************************************************
 */
///@{
#define LCD_MD6_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD6 */
#define LCD_MD6_M27_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD6_M27_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD6_M27_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD6_M27_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD6_M27_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD6_M27_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD6_M26_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD6_M26_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD6_M26_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD6_M26_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD6_M26_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD6_M26_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD6_M25_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD6_M25_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD6_M25_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD6_M25_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD6_M25_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD6_M25_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD6_M24_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD6_M24_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD6_M24_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD6_M24_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD6_M24_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD6_M24_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD7  [register's definitions]
 *              Offset[0x4C]  LCD display memory data register 7 (0x5A00004C)
 ******************************************************************************
 */
///@{
#define LCD_MD7_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD7 */
#define LCD_MD7_M31_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD7_M31_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD7_M31_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD7_M31_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD7_M31_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD7_M31_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD7_M30_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD7_M30_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD7_M30_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD7_M30_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD7_M30_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD7_M30_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD7_M29_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD7_M29_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD7_M29_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD7_M29_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD7_M29_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD7_M29_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD7_M28_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD7_M28_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD7_M28_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD7_M28_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD7_M28_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD7_M28_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD8  [register's definitions]
 *              Offset[0x50]  LCD display memory data register 8 (0x5A000050)
 ******************************************************************************
 */
///@{
#define LCD_MD8_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD8 */
#define LCD_MD8_M35_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD8_M35_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD8_M35_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD8_M35_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD8_M35_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD8_M35_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD8_M34_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD8_M34_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD8_M34_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD8_M34_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD8_M34_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD8_M34_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD8_M33_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD8_M33_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD8_M33_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD8_M33_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD8_M33_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD8_M33_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD8_M32_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD8_M32_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD8_M32_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD8_M32_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD8_M32_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD8_M32_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD9  [register's definitions]
 *              Offset[0x54]  LCD display memory data register 9 (0x5A000054)
 ******************************************************************************
 */
///@{
#define LCD_MD9_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD9 */
#define LCD_MD9_M39_mask_w                          ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD9_M39_mask_h1                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD9_M39_mask_b3                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD9_M39_shift_w                         (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD9_M39_shift_h1                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD9_M39_shift_b3                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD9_M38_mask_w                          ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD9_M38_mask_h1                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD9_M38_mask_b2                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD9_M38_shift_w                         (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD9_M38_shift_h1                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD9_M38_shift_b2                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD9_M37_mask_w                          ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD9_M37_mask_h0                         ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD9_M37_mask_b1                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD9_M37_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD9_M37_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD9_M37_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD9_M36_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD9_M36_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD9_M36_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD9_M36_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD9_M36_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD9_M36_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        LCD_MD10  [register's definitions]
 *              Offset[0x58]  LCD display memory data register 10 (0x5A000058)
 ******************************************************************************
 */
///@{
#define LCD_MD10_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of LCD_MD10 */
#define LCD_MD10_M43_mask_w                         ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define LCD_MD10_M43_mask_h1                        ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD10_M43_mask_b3                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD10_M43_shift_w                        (24)                    /*!< Bit Shift of 32bit */
#define LCD_MD10_M43_shift_h1                       (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD10_M43_shift_b3                       (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD10_M42_mask_w                         ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define LCD_MD10_M42_mask_h1                        ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD10_M42_mask_b2                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD10_M42_shift_w                        (16)                    /*!< Bit Shift of 32bit */
#define LCD_MD10_M42_shift_h1                       (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD10_M42_shift_b2                       (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD10_M41_mask_w                         ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define LCD_MD10_M41_mask_h0                        ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define LCD_MD10_M41_mask_b1                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD10_M41_shift_w                        (8)                     /*!< Bit Shift of 32bit */
#define LCD_MD10_M41_shift_h0                       (8)                     /*!< Bit Shift of 16bit */
#define LCD_MD10_M41_shift_b1                       (0)                     /*!< Bit Shift of 8bit */

#define LCD_MD10_M40_mask_w                         ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define LCD_MD10_M40_mask_h0                        ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define LCD_MD10_M40_mask_b0                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define LCD_MD10_M40_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define LCD_MD10_M40_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define LCD_MD10_M40_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_LCD_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_LCD.h                           */
/*----------------------------------------------------------------------------*/
