/**
 ******************************************************************************
 *
 * @file        MG32_EXIC.h
 *
 * @brief       MG32 EXIC Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.04 (Register File Date : 2025_1014)
 * @date        2026/01/05 10:06 (H File Generated Date)
 * @author      HeadCodeGen V1.61
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_EXIC_H
#define _MG32_EXIC_H
#define _MG32_EXIC_H_VER                            104     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_EXIC_H_VER)
    #error "_MG32_EXIC_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      EXIC_Struct
 *              EXIC  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  PA_OF         :1;     //[0] External interrupt PAx OR path interrupt flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PA_AF         :1;     //[1] External interrupt PAx AND path interrupt flag 
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[3..2] 
            __I  uint8_t  PB_OF         :1;     //[4] External interrupt PBx OR path interrupt flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PB_AF         :1;     //[5] External interrupt PBx AND path interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t  PC_OF         :1;     //[8] External interrupt PCx OR path interrupt flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PC_AF         :1;     //[9] External interrupt PCx AND path interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[11..10] 
            __I  uint8_t  PD_OF         :1;     //[12] External interrupt PDx OR path interrupt flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PD_AF         :1;     //[13] External interrupt PDx AND path interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[15..14] 
            __I  uint8_t  PE_OF         :1;     //[16] External interrupt PEx OR path interrupt flag. (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PE_AF         :1;     //[17] External interrupt PEx AND path interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  EXIC interrupt status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PA_IEA        :1;     //[0] EXIC port PA external interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PB_IEA        :1;     //[1] EXIC port PB external interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PC_IEA        :1;     //[2] EXIC port PC external interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PD_IEA        :1;     //[3] EXIC port PD external interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PE_IEA        :1;     //[4] EXIC port PE external interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[7..5] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  EXIC interrupt enable register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  NMI_SW        :1;     //[1] Software NMI trigger bit. (set by software and clear by hardware)
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[7..2] 
            __IO uint8_t  EM_NMI        :1;     //[8] Interrupt event mask control bit for NMI.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  EM_RXEV       :1;     //[9] Interrupt event mask control bit for RXEV.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  NMI_MUX       :5;     //[14..10] NMI interrupt internal source MUX selection
            __IO uint8_t  NMI_SEL       :1;     //[15] NMI interrupt internal or external source select
                                        //0 = EXT : external pin
                                        //1 = INT : internal interupt source
            __I  uint8_t                :8;     //[23..16] 
            __IO uint8_t  PA_AINV       :1;     //[24] External interrupt PAx AND path signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  PB_AINV       :1;     //[25] External interrupt PBx AND path signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  PC_AINV       :1;     //[26] External interrupt PCx AND path signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  PD_AINV       :1;     //[27] External interrupt PDx AND path signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __IO uint8_t  PE_AINV       :1;     //[28] External interrupt PEx AND path signal inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :3;     //[31..29] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  EXIC control register 0 */

    __I uint32_t  RESERVED1[3];         /*!< RESERVED1  ~ Offset[0x14]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PA0_PF        :1;     //[0] EXIC pin input interrupt pending flag x for external input interrupt pin PAx
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA1_PF        :1;     //[1] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA2_PF        :1;     //[2] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA3_PF        :1;     //[3] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA4_PF        :1;     //[4] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA5_PF        :1;     //[5] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA6_PF        :1;     //[6] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA7_PF        :1;     //[7] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA8_PF        :1;     //[8] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA9_PF        :1;     //[9] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA10_PF       :1;     //[10] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA11_PF       :1;     //[11] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA12_PF       :1;     //[12] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA13_PF       :1;     //[13] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA14_PF       :1;     //[14] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PA15_PF       :1;     //[15] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PA_PF;                             /*!< PA_PF      ~ Offset[0x20]  EXIC PA input interrupt pending flag register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PA0_TRGS      :2;     //[1..0] External interrupt pin edge/level trigger event select
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA1_TRGS      :2;     //[3..2] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA2_TRGS      :2;     //[5..4] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA3_TRGS      :2;     //[7..6] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA4_TRGS      :2;     //[9..8] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA5_TRGS      :2;     //[11..10] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA6_TRGS      :2;     //[13..12] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA7_TRGS      :2;     //[15..14] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA8_TRGS      :2;     //[17..16] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA9_TRGS      :2;     //[19..18] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA10_TRGS     :2;     //[21..20] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA11_TRGS     :2;     //[23..22] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA12_TRGS     :2;     //[25..24] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA13_TRGS     :2;     //[27..26] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA14_TRGS     :2;     //[29..28] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PA15_TRGS     :2;     //[31..30] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
        }MBIT;
    }PA_TRGS;                           /*!< PA_TRGS    ~ Offset[0x24]  EXIC PA Pad input trigger select register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PA0_OM        :1;     //[0] External interrupt PAx OR mask bit x
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA1_OM        :1;     //[1] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA2_OM        :1;     //[2] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA3_OM        :1;     //[3] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA4_OM        :1;     //[4] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA5_OM        :1;     //[5] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA6_OM        :1;     //[6] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA7_OM        :1;     //[7] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA8_OM        :1;     //[8] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA9_OM        :1;     //[9] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA10_OM       :1;     //[10] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA11_OM       :1;     //[11] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA12_OM       :1;     //[12] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA13_OM       :1;     //[13] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA14_OM       :1;     //[14] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA15_OM       :1;     //[15] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA0_AM        :1;     //[16] External interrupt PAx AND mask bit x
                                        //0 = Disable (Mask)
                                        //1 = Enable 
            __IO uint8_t  PA1_AM        :1;     //[17] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA2_AM        :1;     //[18] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA3_AM        :1;     //[19] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA4_AM        :1;     //[20] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA5_AM        :1;     //[21] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA6_AM        :1;     //[22] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA7_AM        :1;     //[23] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA8_AM        :1;     //[24] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA9_AM        :1;     //[25] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA10_AM       :1;     //[26] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA11_AM       :1;     //[27] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA12_AM       :1;     //[28] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA13_AM       :1;     //[29] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA14_AM       :1;     //[30] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PA15_AM       :1;     //[31] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
        }MBIT;
    }PA_MSK;                            /*!< PA_MSK     ~ Offset[0x28]  EXIC PA AOI Mask register */

    __I uint32_t  RESERVED2;            /*!< RESERVED2  ~ Offset[0x2C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PB0_PF        :1;     //[0] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB1_PF        :1;     //[1] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB2_PF        :1;     //[2] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB3_PF        :1;     //[3] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB4_PF        :1;     //[4] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB5_PF        :1;     //[5] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB6_PF        :1;     //[6] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB7_PF        :1;     //[7] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB8_PF        :1;     //[8] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB9_PF        :1;     //[9] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB10_PF       :1;     //[10] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB11_PF       :1;     //[11] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB12_PF       :1;     //[12] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB13_PF       :1;     //[13] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB14_PF       :1;     //[14] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PB15_PF       :1;     //[15] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PB_PF;                             /*!< PB_PF      ~ Offset[0x30]  EXIC PB input interrupt pending flag register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PB0_TRGS      :2;     //[1..0] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB1_TRGS      :2;     //[3..2] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB2_TRGS      :2;     //[5..4] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB3_TRGS      :2;     //[7..6] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB4_TRGS      :2;     //[9..8] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB5_TRGS      :2;     //[11..10] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB6_TRGS      :2;     //[13..12] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB7_TRGS      :2;     //[15..14] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB8_TRGS      :2;     //[17..16] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB9_TRGS      :2;     //[19..18] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB10_TRGS     :2;     //[21..20] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB11_TRGS     :2;     //[23..22] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB12_TRGS     :2;     //[25..24] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB13_TRGS     :2;     //[27..26] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB14_TRGS     :2;     //[29..28] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PB15_TRGS     :2;     //[31..30] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
        }MBIT;
    }PB_TRGS;                           /*!< PB_TRGS    ~ Offset[0x34]  EXIC PB Pad input trigger select register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PB0_OM        :1;     //[0] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB1_OM        :1;     //[1] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB2_OM        :1;     //[2] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB3_OM        :1;     //[3] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB4_OM        :1;     //[4] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB5_OM        :1;     //[5] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB6_OM        :1;     //[6] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB7_OM        :1;     //[7] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB8_OM        :1;     //[8] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB9_OM        :1;     //[9] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB10_OM       :1;     //[10] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB11_OM       :1;     //[11] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB12_OM       :1;     //[12] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB13_OM       :1;     //[13] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB14_OM       :1;     //[14] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB15_OM       :1;     //[15] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB0_AM        :1;     //[16] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB1_AM        :1;     //[17] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB2_AM        :1;     //[18] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB3_AM        :1;     //[19] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB4_AM        :1;     //[20] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB5_AM        :1;     //[21] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB6_AM        :1;     //[22] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB7_AM        :1;     //[23] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB8_AM        :1;     //[24] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB9_AM        :1;     //[25] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB10_AM       :1;     //[26] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB11_AM       :1;     //[27] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB12_AM       :1;     //[28] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB13_AM       :1;     //[29] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB14_AM       :1;     //[30] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PB15_AM       :1;     //[31] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
        }MBIT;
    }PB_MSK;                            /*!< PB_MSK     ~ Offset[0x38]  EXIC PB AOI Mask register */

    __I uint32_t  RESERVED3;            /*!< RESERVED3  ~ Offset[0x3C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PC0_PF        :1;     //[0] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC1_PF        :1;     //[1] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC2_PF        :1;     //[2] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC3_PF        :1;     //[3] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC4_PF        :1;     //[4] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC5_PF        :1;     //[5] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC6_PF        :1;     //[6] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC7_PF        :1;     //[7] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC8_PF        :1;     //[8] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC9_PF        :1;     //[9] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC10_PF       :1;     //[10] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC11_PF       :1;     //[11] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC12_PF       :1;     //[12] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC13_PF       :1;     //[13] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PC14_PF       :1;     //[14] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint8_t                :1;     //[15] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PC_PF;                             /*!< PC_PF      ~ Offset[0x40]  EXIC PC input interrupt pending flag register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PC0_TRGS      :2;     //[1..0] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC1_TRGS      :2;     //[3..2] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC2_TRGS      :2;     //[5..4] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC3_TRGS      :2;     //[7..6] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC4_TRGS      :2;     //[9..8] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC5_TRGS      :2;     //[11..10] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC6_TRGS      :2;     //[13..12] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC7_TRGS      :2;     //[15..14] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC8_TRGS      :2;     //[17..16] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC9_TRGS      :2;     //[19..18] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC10_TRGS     :2;     //[21..20] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC11_TRGS     :2;     //[23..22] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC12_TRGS     :2;     //[25..24] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC13_TRGS     :2;     //[27..26] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PC14_TRGS     :2;     //[29..28] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }PC_TRGS;                           /*!< PC_TRGS    ~ Offset[0x44]  EXIC PC Pad input trigger select register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PC0_OM        :1;     //[0] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC1_OM        :1;     //[1] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC2_OM        :1;     //[2] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC3_OM        :1;     //[3] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC4_OM        :1;     //[4] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC5_OM        :1;     //[5] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC6_OM        :1;     //[6] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC7_OM        :1;     //[7] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC8_OM        :1;     //[8] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC9_OM        :1;     //[9] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC10_OM       :1;     //[10] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC11_OM       :1;     //[11] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC12_OM       :1;     //[12] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC13_OM       :1;     //[13] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC14_OM       :1;     //[14] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  PC0_AM        :1;     //[16] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC1_AM        :1;     //[17] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC2_AM        :1;     //[18] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC3_AM        :1;     //[19] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC4_AM        :1;     //[20] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC5_AM        :1;     //[21] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC6_AM        :1;     //[22] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC7_AM        :1;     //[23] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC8_AM        :1;     //[24] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC9_AM        :1;     //[25] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC10_AM       :1;     //[26] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC11_AM       :1;     //[27] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC12_AM       :1;     //[28] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC13_AM       :1;     //[29] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PC14_AM       :1;     //[30] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }PC_MSK;                            /*!< PC_MSK     ~ Offset[0x48]  EXIC  PC AOI Mask register */

    __I uint32_t  RESERVED4;            /*!< RESERVED4  ~ Offset[0x4C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PD0_PF        :1;     //[0] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD1_PF        :1;     //[1] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD2_PF        :1;     //[2] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD3_PF        :1;     //[3] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD4_PF        :1;     //[4] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD5_PF        :1;     //[5] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD6_PF        :1;     //[6] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD7_PF        :1;     //[7] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD8_PF        :1;     //[8] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD9_PF        :1;     //[9] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD10_PF       :1;     //[10] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD11_PF       :1;     //[11] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD12_PF       :1;     //[12] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD13_PF       :1;     //[13] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD14_PF       :1;     //[14] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PD15_PF       :1;     //[15] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PD_PF;                             /*!< PD_PF      ~ Offset[0x50]  EXIC PD input interrupt pending flag register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PD0_TRGS      :2;     //[1..0] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD1_TRGS      :2;     //[3..2] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD2_TRGS      :2;     //[5..4] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD3_TRGS      :2;     //[7..6] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD4_TRGS      :2;     //[9..8] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD5_TRGS      :2;     //[11..10] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD6_TRGS      :2;     //[13..12] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD7_TRGS      :2;     //[15..14] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD8_TRGS      :2;     //[17..16] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD9_TRGS      :2;     //[19..18] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD10_TRGS     :2;     //[21..20] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD11_TRGS     :2;     //[23..22] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD12_TRGS     :2;     //[25..24] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD13_TRGS     :2;     //[27..26] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD14_TRGS     :2;     //[29..28] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PD15_TRGS     :2;     //[31..30] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No updated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
        }MBIT;
    }PD_TRGS;                           /*!< PD_TRGS    ~ Offset[0x54]  EXIC PD Pad input trigger select register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PD0_OM        :1;     //[0] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD1_OM        :1;     //[1] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD2_OM        :1;     //[2] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD3_OM        :1;     //[3] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD4_OM        :1;     //[4] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD5_OM        :1;     //[5] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD6_OM        :1;     //[6] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD7_OM        :1;     //[7] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD8_OM        :1;     //[8] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD9_OM        :1;     //[9] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD10_OM       :1;     //[10] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD11_OM       :1;     //[11] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD12_OM       :1;     //[12] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD13_OM       :1;     //[13] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD14_OM       :1;     //[14] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD15_OM       :1;     //[15] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD0_AM        :1;     //[16] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD1_AM        :1;     //[17] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD2_AM        :1;     //[18] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD3_AM        :1;     //[19] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD4_AM        :1;     //[20] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD5_AM        :1;     //[21] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD6_AM        :1;     //[22] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD7_AM        :1;     //[23] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD8_AM        :1;     //[24] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD9_AM        :1;     //[25] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD10_AM       :1;     //[26] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD11_AM       :1;     //[27] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD12_AM       :1;     //[28] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD13_AM       :1;     //[29] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD14_AM       :1;     //[30] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PD15_AM       :1;     //[31] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
        }MBIT;
    }PD_MSK;                            /*!< PD_MSK     ~ Offset[0x58]  EXIC  PD AOI Mask register */

    __I uint32_t  RESERVED5;            /*!< RESERVED5  ~ Offset[0x5C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID0           :8;     //[7..0] Interrupt source-0 identity.
                                        //0x1 = WWDT
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID1           :8;     //[15..8] Interrupt source-1 identity.
                                        //0x1 = IWDT
                                        //0x2 = PW
                                        //0x4 = Reserved
                                        //0x8 = RTC
                                        //0x10 = CSC
                                        //0x20 = APB
                                        //0x40 = MEM
                                        //0x80 = Reserved
            __I  uint8_t  ID2           :8;     //[23..16] Interrupt source-2 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID3           :8;     //[31..24] Interrupt source-3 identity.
                                        //0x1 = EXINT0 (PA external interrupt)
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC0;                              /*!< SRC0       ~ Offset[0x60]  EXIC Interrupt source identity register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID4           :8;     //[7..0] Interrupt source-4 identity.
                                        //0x1 = EXINT1 (PB external interrupt)
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID5           :8;     //[15..8] Interrupt source-5 identity.
                                        //0x1 = EXINT2 (PC external interrupt)
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID6           :8;     //[23..16] Interrupt source-6 identity.
                                        //0x1 = EXINT3 (PD external interrupt)
                                        //0x2 = EXINT4 (PE external interrupt)
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID7           :8;     //[31..24] Interrupt source-7 identity.
                                        //0x1 = CMP
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC1;                              /*!< SRC1       ~ Offset[0x64]  EXIC interrupt source identity register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID8           :8;     //[7..0] Interrupt source-8 identity.
                                        //0x1 = DMA
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID9           :8;     //[15..8] Interrupt source-9 identity.
                                        //0x1 = OPA
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID10          :8;     //[23..16] Interrupt source-10 identity.
                                        //0x1 = ADC
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID11          :8;     //[31..24] Interrupt source-11 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC2;                              /*!< SRC2       ~ Offset[0x68]  EXIC interrupt source identity register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID12          :8;     //[7..0] Interrupt source-12 identity.
                                        //0x1 = TM00
                                        //0x2 = TM01
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID13          :8;     //[15..8] Interrupt source-13 identity.
                                        //0x1 = TM10
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID14          :8;     //[23..16] Interrupt source-14 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = TM16
                                        //0x8 = Reserved
            __I  uint8_t  ID15          :8;     //[31..24] Interrupt source-15 identity.
                                        //0x1 = TM20
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC3;                              /*!< SRC3       ~ Offset[0x6C]  EXIC interrupt source identity register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID16          :8;     //[7..0] Interrupt source-16 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = TM26
                                        //0x8 = Reserved
            __I  uint8_t  ID17          :8;     //[15..8] Interrupt source-17 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = TM36
                                        //0x8 = Reserved
            __I  uint8_t  ID18          :8;     //[23..16] Interrupt source-18 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID19          :8;     //[31..24] Interrupt source-19 identity.
                                        //0x1 = LCD
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC4;                              /*!< SRC4       ~ Offset[0x70]  EXIC interrupt source identity register 4 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID20          :8;     //[7..0] Interrupt source-20 identity.
                                        //0x1 = URT0
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID21          :8;     //[15..8] Interrupt source-21 identity.
                                        //0x1 = URT1
                                        //0x2 = URT2
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID22          :8;     //[23..16] Interrupt source-22 identity.
                                        //0x1 = URT4
                                        //0x2 = URT5
                                        //0x4 = URT6
                                        //0x8 = URT7
            __I  uint8_t  ID23          :8;     //[31..24] Interrupt source-23 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC5;                              /*!< SRC5       ~ Offset[0x74]  EXIC interrupt source identity register 5 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID24          :8;     //[7..0] Interrupt source-24 identity.
                                        //0x1 = SPI0
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID25          :8;     //[15..8] Interrupt source-25 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID26          :8;     //[23..16] Interrupt source-26 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID27          :8;     //[31..24] Interrupt source-27 identity.
                                        //0x1 = CAN0
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC6;                              /*!< SRC6       ~ Offset[0x78]  EXIC interrupt source identity register 6 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  ID28          :8;     //[7..0] Interrupt source-28 identity.
                                        //0x1 = I2C0
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID29          :8;     //[15..8] Interrupt source-29 identity.
                                        //0x1 = I2C1
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID30          :8;     //[23..16] Interrupt source-30 identity.
                                        //0x1 = Reserved
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
            __I  uint8_t  ID31          :8;     //[31..24] Interrupt source-31 identity.
                                        //0x1 = APX
                                        //0x2 = Reserved
                                        //0x4 = Reserved
                                        //0x8 = Reserved
        }MBIT;
    }SRC7;                              /*!< SRC7       ~ Offset[0x7C]  EXIC interrupt source identity register 7 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PE0_PF        :1;     //[0] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE1_PF        :1;     //[1] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE2_PF        :1;     //[2] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE3_PF        :1;     //[3] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  PE8_PF        :1;     //[8] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE9_PF        :1;     //[9] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  PE12_PF       :1;     //[12] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE13_PF       :1;     //[13] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE14_PF       :1;     //[14] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __IO uint8_t  PE15_PF       :1;     //[15] Refer to EXIC_PA0_PF.
                                        //0 = Normal : No event occurred
                                        //1 = Happened : Event happened
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PE_PF;                             /*!< PE_PF      ~ Offset[0x80]  EXIC PE input interrupt pending flag register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PE0_TRGS      :2;     //[1..0] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE1_TRGS      :2;     //[3..2] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE2_TRGS      :2;     //[5..4] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE3_TRGS      :2;     //[7..6] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __I  uint8_t                :2;     //[9..8] 
            __I  uint8_t                :2;     //[11..10] 
            __I  uint8_t                :2;     //[13..12] 
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  PE8_TRGS      :2;     //[17..16] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE9_TRGS      :2;     //[19..18] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  PE12_TRGS     :2;     //[25..24] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE13_TRGS     :2;     //[27..26] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE14_TRGS     :2;     //[29..28] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
            __IO uint8_t  PE15_TRGS     :2;     //[31..30] Refer to EXIC_PA0_TRGS.
                                        //0x0 = No : No uPEated flag
                                        //0x1 = Level
                                        //0x2 = Edge
                                        //0x3 = Dual-edge
        }MBIT;
    }PE_TRGS;                           /*!< PE_TRGS    ~ Offset[0x84]  EXIC PE Pad input trigger select register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PE0_OM        :1;     //[0] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE1_OM        :1;     //[1] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE2_OM        :1;     //[2] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE3_OM        :1;     //[3] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  PE8_OM        :1;     //[8] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE9_OM        :1;     //[9] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  PE12_OM       :1;     //[12] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE13_OM       :1;     //[13] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE14_OM       :1;     //[14] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE15_OM       :1;     //[15] Refer to EXIC_PA0_OM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE0_AM        :1;     //[16] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE1_AM        :1;     //[17] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE2_AM        :1;     //[18] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE3_AM        :1;     //[19] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __I  uint8_t                :1;     //[20] 
            __I  uint8_t                :1;     //[21] 
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  PE8_AM        :1;     //[24] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE9_AM        :1;     //[25] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __I  uint8_t                :1;     //[26] 
            __I  uint8_t                :1;     //[27] 
            __IO uint8_t  PE12_AM       :1;     //[28] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE13_AM       :1;     //[29] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE14_AM       :1;     //[30] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
            __IO uint8_t  PE15_AM       :1;     //[31] Refer to EXIC_PA0_AM.
                                        //0 = Disable (Mask)
                                        //1 = Enable
        }MBIT;
    }PE_MSK;                            /*!< PE_MSK     ~ Offset[0x88]  EXIC  PE AOI Mask register */

} EXIC_Struct;

/**
 ******************************************************************************
 *
 * @name        EXIC  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define EXIC_Base                       ((uint32_t)0x50000000)              /*!< External Interrupt Controller */
#define EXIC                            ((EXIC_Struct*) EXIC_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        EXIC  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        EXIC_STA  [register's definitions]
 *              Offset[0x00]  EXIC interrupt status register (0x50000000)
 ******************************************************************************
 */
///@{
#define EXIC_STA_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_STA */
#define EXIC_STA_PE_AF_mask_w                       ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PE_AF_mask_h1                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PE_AF_mask_b2                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PE_AF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PE_AF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PE_AF_normal_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PE_AF_happened_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PE_AF_happened_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PE_AF_happened_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PE_OF_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PE_OF_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PE_OF_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PE_OF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PE_OF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PE_OF_normal_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PE_OF_happened_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PE_OF_happened_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PE_OF_happened_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PD_AF_mask_w                       ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PD_AF_mask_h0                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PD_AF_mask_b1                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PD_AF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PD_AF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PD_AF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PD_AF_happened_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PD_AF_happened_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PD_AF_happened_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PD_OF_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PD_OF_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PD_OF_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PD_OF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PD_OF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PD_OF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PD_OF_happened_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PD_OF_happened_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PD_OF_happened_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PC_AF_mask_w                       ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PC_AF_mask_h0                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PC_AF_mask_b1                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PC_AF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PC_AF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PC_AF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PC_AF_happened_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PC_AF_happened_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PC_AF_happened_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PC_OF_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PC_OF_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PC_OF_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PC_OF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PC_OF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PC_OF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PC_OF_happened_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PC_OF_happened_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PC_OF_happened_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PB_AF_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PB_AF_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PB_AF_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PB_AF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PB_AF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PB_AF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PB_AF_happened_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PB_AF_happened_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PB_AF_happened_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PB_OF_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PB_OF_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PB_OF_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PB_OF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PB_OF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PB_OF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PB_OF_happened_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PB_OF_happened_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PB_OF_happened_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PA_AF_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PA_AF_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PA_AF_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PA_AF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PA_AF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PA_AF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PA_AF_happened_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PA_AF_happened_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PA_AF_happened_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_STA_PA_OF_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_STA_PA_OF_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_STA_PA_OF_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_STA_PA_OF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_STA_PA_OF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_STA_PA_OF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_STA_PA_OF_happened_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_STA_PA_OF_happened_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_STA_PA_OF_happened_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_INT  [register's definitions]
 *              Offset[0x04]  EXIC interrupt enable register (0x50000004)
 ******************************************************************************
 */
///@{
#define EXIC_INT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_INT */
#define EXIC_INT_PE_IEA_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_INT_PE_IEA_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_INT_PE_IEA_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_INT_PE_IEA_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_INT_PE_IEA_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_INT_PE_IEA_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_INT_PE_IEA_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_INT_PE_IEA_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_INT_PE_IEA_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_INT_PD_IEA_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_INT_PD_IEA_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_INT_PD_IEA_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_INT_PD_IEA_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_INT_PD_IEA_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_INT_PD_IEA_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_INT_PD_IEA_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_INT_PD_IEA_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_INT_PD_IEA_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_INT_PC_IEA_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_INT_PC_IEA_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_INT_PC_IEA_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_INT_PC_IEA_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_INT_PC_IEA_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_INT_PC_IEA_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_INT_PC_IEA_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_INT_PC_IEA_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_INT_PC_IEA_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_INT_PB_IEA_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_INT_PB_IEA_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_INT_PB_IEA_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_INT_PB_IEA_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_INT_PB_IEA_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_INT_PB_IEA_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_INT_PB_IEA_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_INT_PB_IEA_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_INT_PB_IEA_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_INT_PA_IEA_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_INT_PA_IEA_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_INT_PA_IEA_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_INT_PA_IEA_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_INT_PA_IEA_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_INT_PA_IEA_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_INT_PA_IEA_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_INT_PA_IEA_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_INT_PA_IEA_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_CR0  [register's definitions]
 *              Offset[0x10]  EXIC control register 0 (0x50000010)
 ******************************************************************************
 */
///@{
#define EXIC_CR0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_CR0 */
#define EXIC_CR0_PE_AINV_mask_w                     ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_PE_AINV_mask_h1                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_PE_AINV_mask_b3                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_PE_AINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_PE_AINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_PE_AINV_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_PE_AINV_enable_w                   ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_PE_AINV_enable_h1                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_PE_AINV_enable_b3                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_PD_AINV_mask_w                     ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_PD_AINV_mask_h1                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_PD_AINV_mask_b3                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_PD_AINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_PD_AINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_PD_AINV_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_PD_AINV_enable_w                   ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_PD_AINV_enable_h1                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_PD_AINV_enable_b3                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_PC_AINV_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_PC_AINV_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_PC_AINV_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_PC_AINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_PC_AINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_PC_AINV_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_PC_AINV_enable_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_PC_AINV_enable_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_PC_AINV_enable_b3                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_PB_AINV_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_PB_AINV_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_PB_AINV_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_PB_AINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_PB_AINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_PB_AINV_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_PB_AINV_enable_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_PB_AINV_enable_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_PB_AINV_enable_b3                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_PA_AINV_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_PA_AINV_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_PA_AINV_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_PA_AINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_PA_AINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_PA_AINV_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_PA_AINV_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_PA_AINV_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_PA_AINV_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_NMI_SEL_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_NMI_SEL_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_NMI_SEL_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_NMI_SEL_ext_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):EXT of 32bit */
#define EXIC_CR0_NMI_SEL_ext_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):EXT of 16bit */
#define EXIC_CR0_NMI_SEL_ext_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):EXT of 8bit */
#define EXIC_CR0_NMI_SEL_int_w                      ((uint32_t)0x00008000)  /*!< Bit Value =(1):INT of 32bit */
#define EXIC_CR0_NMI_SEL_int_h0                     ((uint16_t)0x8000)      /*!< Bit Value =(1):INT of 16bit */
#define EXIC_CR0_NMI_SEL_int_b1                     ((uint8_t )0x80)        /*!< Bit Value =(1):INT of 8bit */

#define EXIC_CR0_NMI_MUX_mask_w                     ((uint32_t)0x00007C00)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_NMI_MUX_mask_h0                    ((uint16_t)0x7C00)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_NMI_MUX_mask_b1                    ((uint8_t )0x7C)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_NMI_MUX_shift_w                    (10)                    /*!< Bit Shift of 32bit */
#define EXIC_CR0_NMI_MUX_shift_h0                   (10)                    /*!< Bit Shift of 16bit */
#define EXIC_CR0_NMI_MUX_shift_b1                   (2)                     /*!< Bit Shift of 8bit */

#define EXIC_CR0_EM_RXEV_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_EM_RXEV_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_EM_RXEV_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_EM_RXEV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_EM_RXEV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_EM_RXEV_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_EM_RXEV_enable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_EM_RXEV_enable_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_EM_RXEV_enable_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_EM_NMI_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_EM_NMI_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_EM_NMI_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_EM_NMI_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_EM_NMI_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_EM_NMI_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_EM_NMI_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_EM_NMI_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_EM_NMI_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_CR0_NMI_SW_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_CR0_NMI_SW_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_CR0_NMI_SW_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_CR0_NMI_SW_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_CR0_NMI_SW_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_CR0_NMI_SW_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_CR0_NMI_SW_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_CR0_NMI_SW_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_CR0_NMI_SW_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_PF  [register's definitions]
 *              Offset[0x20]  EXIC PA input interrupt pending flag register (0x50000020)
 ******************************************************************************
 */
///@{
#define EXIC_PA_PF_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PA_PF */
#define EXIC_PA_PF_PA15_PF_mask_w                   ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA15_PF_mask_h0                  ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA15_PF_mask_b1                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA15_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA15_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA15_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA15_PF_happened_w               ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA15_PF_happened_h0              ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA15_PF_happened_b1              ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA14_PF_mask_w                   ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA14_PF_mask_h0                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA14_PF_mask_b1                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA14_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA14_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA14_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA14_PF_happened_w               ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA14_PF_happened_h0              ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA14_PF_happened_b1              ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA13_PF_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA13_PF_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA13_PF_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA13_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA13_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA13_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA13_PF_happened_w               ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA13_PF_happened_h0              ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA13_PF_happened_b1              ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA12_PF_mask_w                   ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA12_PF_mask_h0                  ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA12_PF_mask_b1                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA12_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA12_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA12_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA12_PF_happened_w               ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA12_PF_happened_h0              ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA12_PF_happened_b1              ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA11_PF_mask_w                   ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA11_PF_mask_h0                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA11_PF_mask_b1                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA11_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA11_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA11_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA11_PF_happened_w               ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA11_PF_happened_h0              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA11_PF_happened_b1              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA10_PF_mask_w                   ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA10_PF_mask_h0                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA10_PF_mask_b1                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA10_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA10_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA10_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA10_PF_happened_w               ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA10_PF_happened_h0              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA10_PF_happened_b1              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA9_PF_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA9_PF_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA9_PF_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA9_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA9_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA9_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA9_PF_happened_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA9_PF_happened_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA9_PF_happened_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA8_PF_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA8_PF_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA8_PF_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA8_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA8_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA8_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA8_PF_happened_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA8_PF_happened_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA8_PF_happened_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA7_PF_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA7_PF_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA7_PF_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA7_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA7_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA7_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA7_PF_happened_w                ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA7_PF_happened_h0               ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA7_PF_happened_b0               ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA6_PF_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA6_PF_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA6_PF_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA6_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA6_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA6_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA6_PF_happened_w                ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA6_PF_happened_h0               ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA6_PF_happened_b0               ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA5_PF_mask_w                    ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA5_PF_mask_h0                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA5_PF_mask_b0                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA5_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA5_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA5_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA5_PF_happened_w                ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA5_PF_happened_h0               ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA5_PF_happened_b0               ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA4_PF_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA4_PF_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA4_PF_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA4_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA4_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA4_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA4_PF_happened_w                ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA4_PF_happened_h0               ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA4_PF_happened_b0               ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA3_PF_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA3_PF_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA3_PF_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA3_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA3_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA3_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA3_PF_happened_w                ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA3_PF_happened_h0               ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA3_PF_happened_b0               ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA2_PF_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA2_PF_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA2_PF_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA2_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA2_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA2_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA2_PF_happened_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA2_PF_happened_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA2_PF_happened_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA1_PF_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA1_PF_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA1_PF_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA1_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA1_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA1_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA1_PF_happened_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA1_PF_happened_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA1_PF_happened_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PA_PF_PA0_PF_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PA_PF_PA0_PF_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PA_PF_PA0_PF_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PA_PF_PA0_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PA_PF_PA0_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PA_PF_PA0_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PA_PF_PA0_PF_happened_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PA_PF_PA0_PF_happened_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PA_PF_PA0_PF_happened_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_TRGS  [register's definitions]
 *              Offset[0x24]  EXIC PA Pad input trigger select register (0x50000024)
 ******************************************************************************
 */
///@{
#define EXIC_PA_TRGS_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PA_TRGS */
#define EXIC_PA_TRGS_PA15_TRGS_mask_w               ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA15_TRGS_mask_h1              ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA15_TRGS_mask_b3              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA15_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA15_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA15_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA15_TRGS_level_w              ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA15_TRGS_level_h1             ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA15_TRGS_level_b3             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA15_TRGS_edge_w               ((uint32_t)0x80000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA15_TRGS_edge_h1              ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA15_TRGS_edge_b3              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA15_TRGS_dual_edge_w          ((uint32_t)0xC0000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA15_TRGS_dual_edge_h1         ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA15_TRGS_dual_edge_b3         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA14_TRGS_mask_w               ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA14_TRGS_mask_h1              ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA14_TRGS_mask_b3              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA14_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA14_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA14_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA14_TRGS_level_w              ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA14_TRGS_level_h1             ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA14_TRGS_level_b3             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA14_TRGS_edge_w               ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA14_TRGS_edge_h1              ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA14_TRGS_edge_b3              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA14_TRGS_dual_edge_w          ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA14_TRGS_dual_edge_h1         ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA14_TRGS_dual_edge_b3         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA13_TRGS_mask_w               ((uint32_t)0x0C000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA13_TRGS_mask_h1              ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA13_TRGS_mask_b3              ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA13_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA13_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA13_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA13_TRGS_level_w              ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA13_TRGS_level_h1             ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA13_TRGS_level_b3             ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA13_TRGS_edge_w               ((uint32_t)0x08000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA13_TRGS_edge_h1              ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA13_TRGS_edge_b3              ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA13_TRGS_dual_edge_w          ((uint32_t)0x0C000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA13_TRGS_dual_edge_h1         ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA13_TRGS_dual_edge_b3         ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA12_TRGS_mask_w               ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA12_TRGS_mask_h1              ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA12_TRGS_mask_b3              ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA12_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA12_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA12_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA12_TRGS_level_w              ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA12_TRGS_level_h1             ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA12_TRGS_level_b3             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA12_TRGS_edge_w               ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA12_TRGS_edge_h1              ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA12_TRGS_edge_b3              ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA12_TRGS_dual_edge_w          ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA12_TRGS_dual_edge_h1         ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA12_TRGS_dual_edge_b3         ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA11_TRGS_mask_w               ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA11_TRGS_mask_h1              ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA11_TRGS_mask_b2              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA11_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA11_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA11_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA11_TRGS_level_w              ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA11_TRGS_level_h1             ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA11_TRGS_level_b2             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA11_TRGS_edge_w               ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA11_TRGS_edge_h1              ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA11_TRGS_edge_b2              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA11_TRGS_dual_edge_w          ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA11_TRGS_dual_edge_h1         ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA11_TRGS_dual_edge_b2         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA10_TRGS_mask_w               ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA10_TRGS_mask_h1              ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA10_TRGS_mask_b2              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA10_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA10_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA10_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA10_TRGS_level_w              ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA10_TRGS_level_h1             ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA10_TRGS_level_b2             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA10_TRGS_edge_w               ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA10_TRGS_edge_h1              ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA10_TRGS_edge_b2              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA10_TRGS_dual_edge_w          ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA10_TRGS_dual_edge_h1         ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA10_TRGS_dual_edge_b2         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA9_TRGS_mask_w                ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA9_TRGS_mask_h1               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA9_TRGS_mask_b2               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA9_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA9_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA9_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA9_TRGS_level_w               ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA9_TRGS_level_h1              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA9_TRGS_level_b2              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA9_TRGS_edge_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA9_TRGS_edge_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA9_TRGS_edge_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA9_TRGS_dual_edge_w           ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA9_TRGS_dual_edge_h1          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA9_TRGS_dual_edge_b2          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA8_TRGS_mask_w                ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA8_TRGS_mask_h1               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA8_TRGS_mask_b2               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA8_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA8_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA8_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA8_TRGS_level_w               ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA8_TRGS_level_h1              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA8_TRGS_level_b2              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA8_TRGS_edge_w                ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA8_TRGS_edge_h1               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA8_TRGS_edge_b2               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA8_TRGS_dual_edge_w           ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA8_TRGS_dual_edge_h1          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA8_TRGS_dual_edge_b2          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA7_TRGS_mask_w                ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA7_TRGS_mask_h0               ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA7_TRGS_mask_b1               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA7_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA7_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA7_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA7_TRGS_level_w               ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA7_TRGS_level_h0              ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA7_TRGS_level_b1              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA7_TRGS_edge_w                ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA7_TRGS_edge_h0               ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA7_TRGS_edge_b1               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA7_TRGS_dual_edge_w           ((uint32_t)0x0000C000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA7_TRGS_dual_edge_h0          ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA7_TRGS_dual_edge_b1          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA6_TRGS_mask_w                ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA6_TRGS_mask_h0               ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA6_TRGS_mask_b1               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA6_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA6_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA6_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA6_TRGS_level_w               ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA6_TRGS_level_h0              ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA6_TRGS_level_b1              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA6_TRGS_edge_w                ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA6_TRGS_edge_h0               ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA6_TRGS_edge_b1               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA6_TRGS_dual_edge_w           ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA6_TRGS_dual_edge_h0          ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA6_TRGS_dual_edge_b1          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA5_TRGS_mask_w                ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA5_TRGS_mask_h0               ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA5_TRGS_mask_b1               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA5_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA5_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA5_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA5_TRGS_level_w               ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA5_TRGS_level_h0              ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA5_TRGS_level_b1              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA5_TRGS_edge_w                ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA5_TRGS_edge_h0               ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA5_TRGS_edge_b1               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA5_TRGS_dual_edge_w           ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA5_TRGS_dual_edge_h0          ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA5_TRGS_dual_edge_b1          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA4_TRGS_mask_w                ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA4_TRGS_mask_h0               ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA4_TRGS_mask_b1               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA4_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA4_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA4_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA4_TRGS_level_w               ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA4_TRGS_level_h0              ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA4_TRGS_level_b1              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA4_TRGS_edge_w                ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA4_TRGS_edge_h0               ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA4_TRGS_edge_b1               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA4_TRGS_dual_edge_w           ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA4_TRGS_dual_edge_h0          ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA4_TRGS_dual_edge_b1          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA3_TRGS_mask_w                ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA3_TRGS_mask_h0               ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA3_TRGS_mask_b0               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA3_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA3_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA3_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA3_TRGS_level_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA3_TRGS_level_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA3_TRGS_level_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA3_TRGS_edge_w                ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA3_TRGS_edge_h0               ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA3_TRGS_edge_b0               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA3_TRGS_dual_edge_w           ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA3_TRGS_dual_edge_h0          ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA3_TRGS_dual_edge_b0          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA2_TRGS_mask_w                ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA2_TRGS_mask_h0               ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA2_TRGS_mask_b0               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA2_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA2_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA2_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA2_TRGS_level_w               ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA2_TRGS_level_h0              ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA2_TRGS_level_b0              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA2_TRGS_edge_w                ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA2_TRGS_edge_h0               ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA2_TRGS_edge_b0               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA2_TRGS_dual_edge_w           ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA2_TRGS_dual_edge_h0          ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA2_TRGS_dual_edge_b0          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA1_TRGS_mask_w                ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA1_TRGS_mask_h0               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA1_TRGS_mask_b0               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA1_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA1_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA1_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA1_TRGS_level_w               ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA1_TRGS_level_h0              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA1_TRGS_level_b0              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA1_TRGS_edge_w                ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA1_TRGS_edge_h0               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA1_TRGS_edge_b0               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA1_TRGS_dual_edge_w           ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA1_TRGS_dual_edge_h0          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA1_TRGS_dual_edge_b0          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PA_TRGS_PA0_TRGS_mask_w                ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define EXIC_PA_TRGS_PA0_TRGS_mask_h0               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PA_TRGS_PA0_TRGS_mask_b0               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PA_TRGS_PA0_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PA_TRGS_PA0_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PA_TRGS_PA0_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PA_TRGS_PA0_TRGS_level_w               ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PA_TRGS_PA0_TRGS_level_h0              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PA_TRGS_PA0_TRGS_level_b0              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PA_TRGS_PA0_TRGS_edge_w                ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PA_TRGS_PA0_TRGS_edge_h0               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PA_TRGS_PA0_TRGS_edge_b0               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PA_TRGS_PA0_TRGS_dual_edge_w           ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PA_TRGS_PA0_TRGS_dual_edge_h0          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PA_TRGS_PA0_TRGS_dual_edge_b0          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_MSK  [register's definitions]
 *              Offset[0x28]  EXIC PA AOI Mask register (0x50000028)
 ******************************************************************************
 */
///@{
#define EXIC_PA_MSK_default                         ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PA_MSK */
#define EXIC_PA_MSK_PA15_AM_mask_w                  ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA15_AM_mask_h1                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA15_AM_mask_b3                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA15_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA15_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA15_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA15_AM_enable_w                ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA15_AM_enable_h1               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA15_AM_enable_b3               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA14_AM_mask_w                  ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA14_AM_mask_h1                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA14_AM_mask_b3                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA14_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA14_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA14_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA14_AM_enable_w                ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA14_AM_enable_h1               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA14_AM_enable_b3               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA13_AM_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA13_AM_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA13_AM_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA13_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA13_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA13_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA13_AM_enable_w                ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA13_AM_enable_h1               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA13_AM_enable_b3               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA12_AM_mask_w                  ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA12_AM_mask_h1                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA12_AM_mask_b3                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA12_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA12_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA12_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA12_AM_enable_w                ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA12_AM_enable_h1               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA12_AM_enable_b3               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA11_AM_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA11_AM_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA11_AM_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA11_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA11_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA11_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA11_AM_enable_w                ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA11_AM_enable_h1               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA11_AM_enable_b3               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA10_AM_mask_w                  ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA10_AM_mask_h1                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA10_AM_mask_b3                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA10_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA10_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA10_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA10_AM_enable_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA10_AM_enable_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA10_AM_enable_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA9_AM_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA9_AM_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA9_AM_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA9_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA9_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA9_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA9_AM_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA9_AM_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA9_AM_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA8_AM_mask_w                   ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA8_AM_mask_h1                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA8_AM_mask_b3                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA8_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA8_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA8_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA8_AM_enable_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA8_AM_enable_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA8_AM_enable_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA7_AM_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA7_AM_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA7_AM_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA7_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA7_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA7_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA7_AM_enable_w                 ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA7_AM_enable_h1                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA7_AM_enable_b2                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA6_AM_mask_w                   ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA6_AM_mask_h1                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA6_AM_mask_b2                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA6_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA6_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA6_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA6_AM_enable_w                 ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA6_AM_enable_h1                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA6_AM_enable_b2                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA5_AM_mask_w                   ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA5_AM_mask_h1                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA5_AM_mask_b2                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA5_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA5_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA5_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA5_AM_enable_w                 ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA5_AM_enable_h1                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA5_AM_enable_b2                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA4_AM_mask_w                   ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA4_AM_mask_h1                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA4_AM_mask_b2                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA4_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA4_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA4_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA4_AM_enable_w                 ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA4_AM_enable_h1                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA4_AM_enable_b2                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA3_AM_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA3_AM_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA3_AM_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA3_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA3_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA3_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA3_AM_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA3_AM_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA3_AM_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA2_AM_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA2_AM_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA2_AM_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA2_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA2_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA2_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA2_AM_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA2_AM_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA2_AM_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA1_AM_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA1_AM_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA1_AM_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA1_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA1_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA1_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA1_AM_enable_w                 ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA1_AM_enable_h1                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA1_AM_enable_b2                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA0_AM_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA0_AM_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA0_AM_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA0_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA0_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA0_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA0_AM_enable_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA0_AM_enable_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA0_AM_enable_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA15_OM_mask_w                  ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA15_OM_mask_h0                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA15_OM_mask_b1                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA15_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA15_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA15_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA15_OM_enable_w                ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA15_OM_enable_h0               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA15_OM_enable_b1               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA14_OM_mask_w                  ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA14_OM_mask_h0                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA14_OM_mask_b1                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA14_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA14_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA14_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA14_OM_enable_w                ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA14_OM_enable_h0               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA14_OM_enable_b1               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA13_OM_mask_w                  ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA13_OM_mask_h0                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA13_OM_mask_b1                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA13_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA13_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA13_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA13_OM_enable_w                ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA13_OM_enable_h0               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA13_OM_enable_b1               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA12_OM_mask_w                  ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA12_OM_mask_h0                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA12_OM_mask_b1                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA12_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA12_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA12_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA12_OM_enable_w                ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA12_OM_enable_h0               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA12_OM_enable_b1               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA11_OM_mask_w                  ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA11_OM_mask_h0                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA11_OM_mask_b1                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA11_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA11_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA11_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA11_OM_enable_w                ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA11_OM_enable_h0               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA11_OM_enable_b1               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA10_OM_mask_w                  ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA10_OM_mask_h0                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA10_OM_mask_b1                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA10_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA10_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA10_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA10_OM_enable_w                ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA10_OM_enable_h0               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA10_OM_enable_b1               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA9_OM_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA9_OM_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA9_OM_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA9_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA9_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA9_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA9_OM_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA9_OM_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA9_OM_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA8_OM_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA8_OM_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA8_OM_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA8_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA8_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA8_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA8_OM_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA8_OM_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA8_OM_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA7_OM_mask_w                   ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA7_OM_mask_h0                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA7_OM_mask_b0                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA7_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA7_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA7_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA7_OM_enable_w                 ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA7_OM_enable_h0                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA7_OM_enable_b0                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA6_OM_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA6_OM_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA6_OM_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA6_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA6_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA6_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA6_OM_enable_w                 ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA6_OM_enable_h0                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA6_OM_enable_b0                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA5_OM_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA5_OM_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA5_OM_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA5_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA5_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA5_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA5_OM_enable_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA5_OM_enable_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA5_OM_enable_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA4_OM_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA4_OM_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA4_OM_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA4_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA4_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA4_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA4_OM_enable_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA4_OM_enable_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA4_OM_enable_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA3_OM_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA3_OM_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA3_OM_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA3_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA3_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA3_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA3_OM_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA3_OM_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA3_OM_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA2_OM_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA2_OM_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA2_OM_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA2_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA2_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA2_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA2_OM_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA2_OM_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA2_OM_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA1_OM_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA1_OM_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA1_OM_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA1_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA1_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA1_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA1_OM_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA1_OM_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA1_OM_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PA_MSK_PA0_OM_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PA_MSK_PA0_OM_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PA_MSK_PA0_OM_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PA_MSK_PA0_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PA_MSK_PA0_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PA_MSK_PA0_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PA_MSK_PA0_OM_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PA_MSK_PA0_OM_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PA_MSK_PA0_OM_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_PF  [register's definitions]
 *              Offset[0x30]  EXIC PB input interrupt pending flag register (0x50000030)
 ******************************************************************************
 */
///@{
#define EXIC_PB_PF_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PB_PF */
#define EXIC_PB_PF_PB15_PF_mask_w                   ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB15_PF_mask_h0                  ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB15_PF_mask_b1                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB15_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB15_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB15_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB15_PF_happened_w               ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB15_PF_happened_h0              ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB15_PF_happened_b1              ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB14_PF_mask_w                   ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB14_PF_mask_h0                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB14_PF_mask_b1                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB14_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB14_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB14_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB14_PF_happened_w               ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB14_PF_happened_h0              ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB14_PF_happened_b1              ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB13_PF_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB13_PF_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB13_PF_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB13_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB13_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB13_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB13_PF_happened_w               ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB13_PF_happened_h0              ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB13_PF_happened_b1              ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB12_PF_mask_w                   ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB12_PF_mask_h0                  ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB12_PF_mask_b1                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB12_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB12_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB12_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB12_PF_happened_w               ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB12_PF_happened_h0              ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB12_PF_happened_b1              ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB11_PF_mask_w                   ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB11_PF_mask_h0                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB11_PF_mask_b1                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB11_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB11_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB11_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB11_PF_happened_w               ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB11_PF_happened_h0              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB11_PF_happened_b1              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB10_PF_mask_w                   ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB10_PF_mask_h0                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB10_PF_mask_b1                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB10_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB10_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB10_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB10_PF_happened_w               ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB10_PF_happened_h0              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB10_PF_happened_b1              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB9_PF_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB9_PF_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB9_PF_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB9_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB9_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB9_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB9_PF_happened_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB9_PF_happened_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB9_PF_happened_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB8_PF_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB8_PF_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB8_PF_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB8_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB8_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB8_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB8_PF_happened_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB8_PF_happened_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB8_PF_happened_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB7_PF_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB7_PF_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB7_PF_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB7_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB7_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB7_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB7_PF_happened_w                ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB7_PF_happened_h0               ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB7_PF_happened_b0               ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB6_PF_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB6_PF_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB6_PF_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB6_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB6_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB6_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB6_PF_happened_w                ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB6_PF_happened_h0               ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB6_PF_happened_b0               ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB5_PF_mask_w                    ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB5_PF_mask_h0                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB5_PF_mask_b0                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB5_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB5_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB5_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB5_PF_happened_w                ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB5_PF_happened_h0               ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB5_PF_happened_b0               ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB4_PF_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB4_PF_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB4_PF_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB4_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB4_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB4_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB4_PF_happened_w                ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB4_PF_happened_h0               ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB4_PF_happened_b0               ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB3_PF_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB3_PF_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB3_PF_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB3_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB3_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB3_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB3_PF_happened_w                ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB3_PF_happened_h0               ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB3_PF_happened_b0               ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB2_PF_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB2_PF_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB2_PF_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB2_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB2_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB2_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB2_PF_happened_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB2_PF_happened_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB2_PF_happened_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB1_PF_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB1_PF_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB1_PF_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB1_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB1_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB1_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB1_PF_happened_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB1_PF_happened_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB1_PF_happened_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PB_PF_PB0_PF_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PB_PF_PB0_PF_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PB_PF_PB0_PF_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PB_PF_PB0_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PB_PF_PB0_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PB_PF_PB0_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PB_PF_PB0_PF_happened_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PB_PF_PB0_PF_happened_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PB_PF_PB0_PF_happened_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_TRGS  [register's definitions]
 *              Offset[0x34]  EXIC PB Pad input trigger select register (0x50000034)
 ******************************************************************************
 */
///@{
#define EXIC_PB_TRGS_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PB_TRGS */
#define EXIC_PB_TRGS_PB15_TRGS_mask_w               ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB15_TRGS_mask_h1              ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB15_TRGS_mask_b3              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB15_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB15_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB15_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB15_TRGS_level_w              ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB15_TRGS_level_h1             ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB15_TRGS_level_b3             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB15_TRGS_edge_w               ((uint32_t)0x80000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB15_TRGS_edge_h1              ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB15_TRGS_edge_b3              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB15_TRGS_dual_edge_w          ((uint32_t)0xC0000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB15_TRGS_dual_edge_h1         ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB15_TRGS_dual_edge_b3         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB14_TRGS_mask_w               ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB14_TRGS_mask_h1              ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB14_TRGS_mask_b3              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB14_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB14_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB14_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB14_TRGS_level_w              ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB14_TRGS_level_h1             ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB14_TRGS_level_b3             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB14_TRGS_edge_w               ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB14_TRGS_edge_h1              ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB14_TRGS_edge_b3              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB14_TRGS_dual_edge_w          ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB14_TRGS_dual_edge_h1         ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB14_TRGS_dual_edge_b3         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB13_TRGS_mask_w               ((uint32_t)0x0C000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB13_TRGS_mask_h1              ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB13_TRGS_mask_b3              ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB13_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB13_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB13_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB13_TRGS_level_w              ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB13_TRGS_level_h1             ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB13_TRGS_level_b3             ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB13_TRGS_edge_w               ((uint32_t)0x08000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB13_TRGS_edge_h1              ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB13_TRGS_edge_b3              ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB13_TRGS_dual_edge_w          ((uint32_t)0x0C000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB13_TRGS_dual_edge_h1         ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB13_TRGS_dual_edge_b3         ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB12_TRGS_mask_w               ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB12_TRGS_mask_h1              ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB12_TRGS_mask_b3              ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB12_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB12_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB12_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB12_TRGS_level_w              ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB12_TRGS_level_h1             ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB12_TRGS_level_b3             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB12_TRGS_edge_w               ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB12_TRGS_edge_h1              ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB12_TRGS_edge_b3              ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB12_TRGS_dual_edge_w          ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB12_TRGS_dual_edge_h1         ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB12_TRGS_dual_edge_b3         ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB11_TRGS_mask_w               ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB11_TRGS_mask_h1              ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB11_TRGS_mask_b2              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB11_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB11_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB11_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB11_TRGS_level_w              ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB11_TRGS_level_h1             ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB11_TRGS_level_b2             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB11_TRGS_edge_w               ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB11_TRGS_edge_h1              ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB11_TRGS_edge_b2              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB11_TRGS_dual_edge_w          ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB11_TRGS_dual_edge_h1         ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB11_TRGS_dual_edge_b2         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB10_TRGS_mask_w               ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB10_TRGS_mask_h1              ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB10_TRGS_mask_b2              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB10_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB10_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB10_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB10_TRGS_level_w              ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB10_TRGS_level_h1             ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB10_TRGS_level_b2             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB10_TRGS_edge_w               ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB10_TRGS_edge_h1              ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB10_TRGS_edge_b2              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB10_TRGS_dual_edge_w          ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB10_TRGS_dual_edge_h1         ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB10_TRGS_dual_edge_b2         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB9_TRGS_mask_w                ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB9_TRGS_mask_h1               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB9_TRGS_mask_b2               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB9_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB9_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB9_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB9_TRGS_level_w               ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB9_TRGS_level_h1              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB9_TRGS_level_b2              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB9_TRGS_edge_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB9_TRGS_edge_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB9_TRGS_edge_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB9_TRGS_dual_edge_w           ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB9_TRGS_dual_edge_h1          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB9_TRGS_dual_edge_b2          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB8_TRGS_mask_w                ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB8_TRGS_mask_h1               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB8_TRGS_mask_b2               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB8_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB8_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB8_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB8_TRGS_level_w               ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB8_TRGS_level_h1              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB8_TRGS_level_b2              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB8_TRGS_edge_w                ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB8_TRGS_edge_h1               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB8_TRGS_edge_b2               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB8_TRGS_dual_edge_w           ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB8_TRGS_dual_edge_h1          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB8_TRGS_dual_edge_b2          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB7_TRGS_mask_w                ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB7_TRGS_mask_h0               ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB7_TRGS_mask_b1               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB7_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB7_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB7_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB7_TRGS_level_w               ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB7_TRGS_level_h0              ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB7_TRGS_level_b1              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB7_TRGS_edge_w                ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB7_TRGS_edge_h0               ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB7_TRGS_edge_b1               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB7_TRGS_dual_edge_w           ((uint32_t)0x0000C000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB7_TRGS_dual_edge_h0          ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB7_TRGS_dual_edge_b1          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB6_TRGS_mask_w                ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB6_TRGS_mask_h0               ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB6_TRGS_mask_b1               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB6_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB6_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB6_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB6_TRGS_level_w               ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB6_TRGS_level_h0              ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB6_TRGS_level_b1              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB6_TRGS_edge_w                ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB6_TRGS_edge_h0               ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB6_TRGS_edge_b1               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB6_TRGS_dual_edge_w           ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB6_TRGS_dual_edge_h0          ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB6_TRGS_dual_edge_b1          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB5_TRGS_mask_w                ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB5_TRGS_mask_h0               ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB5_TRGS_mask_b1               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB5_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB5_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB5_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB5_TRGS_level_w               ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB5_TRGS_level_h0              ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB5_TRGS_level_b1              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB5_TRGS_edge_w                ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB5_TRGS_edge_h0               ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB5_TRGS_edge_b1               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB5_TRGS_dual_edge_w           ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB5_TRGS_dual_edge_h0          ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB5_TRGS_dual_edge_b1          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB4_TRGS_mask_w                ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB4_TRGS_mask_h0               ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB4_TRGS_mask_b1               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB4_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB4_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB4_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB4_TRGS_level_w               ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB4_TRGS_level_h0              ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB4_TRGS_level_b1              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB4_TRGS_edge_w                ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB4_TRGS_edge_h0               ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB4_TRGS_edge_b1               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB4_TRGS_dual_edge_w           ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB4_TRGS_dual_edge_h0          ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB4_TRGS_dual_edge_b1          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB3_TRGS_mask_w                ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB3_TRGS_mask_h0               ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB3_TRGS_mask_b0               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB3_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB3_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB3_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB3_TRGS_level_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB3_TRGS_level_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB3_TRGS_level_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB3_TRGS_edge_w                ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB3_TRGS_edge_h0               ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB3_TRGS_edge_b0               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB3_TRGS_dual_edge_w           ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB3_TRGS_dual_edge_h0          ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB3_TRGS_dual_edge_b0          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB2_TRGS_mask_w                ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB2_TRGS_mask_h0               ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB2_TRGS_mask_b0               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB2_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB2_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB2_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB2_TRGS_level_w               ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB2_TRGS_level_h0              ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB2_TRGS_level_b0              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB2_TRGS_edge_w                ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB2_TRGS_edge_h0               ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB2_TRGS_edge_b0               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB2_TRGS_dual_edge_w           ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB2_TRGS_dual_edge_h0          ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB2_TRGS_dual_edge_b0          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB1_TRGS_mask_w                ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB1_TRGS_mask_h0               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB1_TRGS_mask_b0               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB1_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB1_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB1_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB1_TRGS_level_w               ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB1_TRGS_level_h0              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB1_TRGS_level_b0              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB1_TRGS_edge_w                ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB1_TRGS_edge_h0               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB1_TRGS_edge_b0               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB1_TRGS_dual_edge_w           ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB1_TRGS_dual_edge_h0          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB1_TRGS_dual_edge_b0          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PB_TRGS_PB0_TRGS_mask_w                ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define EXIC_PB_TRGS_PB0_TRGS_mask_h0               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PB_TRGS_PB0_TRGS_mask_b0               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PB_TRGS_PB0_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PB_TRGS_PB0_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PB_TRGS_PB0_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PB_TRGS_PB0_TRGS_level_w               ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PB_TRGS_PB0_TRGS_level_h0              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PB_TRGS_PB0_TRGS_level_b0              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PB_TRGS_PB0_TRGS_edge_w                ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PB_TRGS_PB0_TRGS_edge_h0               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PB_TRGS_PB0_TRGS_edge_b0               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PB_TRGS_PB0_TRGS_dual_edge_w           ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PB_TRGS_PB0_TRGS_dual_edge_h0          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PB_TRGS_PB0_TRGS_dual_edge_b0          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_MSK  [register's definitions]
 *              Offset[0x38]  EXIC PB AOI Mask register (0x50000038)
 ******************************************************************************
 */
///@{
#define EXIC_PB_MSK_default                         ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PB_MSK */
#define EXIC_PB_MSK_PB15_AM_mask_w                  ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB15_AM_mask_h1                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB15_AM_mask_b3                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB15_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB15_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB15_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB15_AM_enable_w                ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB15_AM_enable_h1               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB15_AM_enable_b3               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB14_AM_mask_w                  ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB14_AM_mask_h1                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB14_AM_mask_b3                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB14_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB14_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB14_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB14_AM_enable_w                ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB14_AM_enable_h1               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB14_AM_enable_b3               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB13_AM_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB13_AM_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB13_AM_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB13_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB13_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB13_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB13_AM_enable_w                ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB13_AM_enable_h1               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB13_AM_enable_b3               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB12_AM_mask_w                  ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB12_AM_mask_h1                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB12_AM_mask_b3                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB12_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB12_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB12_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB12_AM_enable_w                ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB12_AM_enable_h1               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB12_AM_enable_b3               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB11_AM_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB11_AM_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB11_AM_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB11_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB11_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB11_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB11_AM_enable_w                ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB11_AM_enable_h1               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB11_AM_enable_b3               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB10_AM_mask_w                  ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB10_AM_mask_h1                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB10_AM_mask_b3                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB10_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB10_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB10_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB10_AM_enable_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB10_AM_enable_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB10_AM_enable_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB9_AM_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB9_AM_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB9_AM_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB9_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB9_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB9_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB9_AM_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB9_AM_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB9_AM_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB8_AM_mask_w                   ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB8_AM_mask_h1                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB8_AM_mask_b3                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB8_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB8_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB8_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB8_AM_enable_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB8_AM_enable_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB8_AM_enable_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB7_AM_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB7_AM_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB7_AM_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB7_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB7_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB7_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB7_AM_enable_w                 ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB7_AM_enable_h1                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB7_AM_enable_b2                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB6_AM_mask_w                   ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB6_AM_mask_h1                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB6_AM_mask_b2                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB6_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB6_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB6_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB6_AM_enable_w                 ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB6_AM_enable_h1                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB6_AM_enable_b2                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB5_AM_mask_w                   ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB5_AM_mask_h1                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB5_AM_mask_b2                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB5_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB5_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB5_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB5_AM_enable_w                 ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB5_AM_enable_h1                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB5_AM_enable_b2                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB4_AM_mask_w                   ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB4_AM_mask_h1                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB4_AM_mask_b2                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB4_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB4_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB4_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB4_AM_enable_w                 ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB4_AM_enable_h1                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB4_AM_enable_b2                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB3_AM_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB3_AM_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB3_AM_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB3_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB3_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB3_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB3_AM_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB3_AM_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB3_AM_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB2_AM_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB2_AM_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB2_AM_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB2_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB2_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB2_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB2_AM_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB2_AM_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB2_AM_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB1_AM_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB1_AM_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB1_AM_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB1_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB1_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB1_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB1_AM_enable_w                 ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB1_AM_enable_h1                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB1_AM_enable_b2                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB0_AM_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB0_AM_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB0_AM_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB0_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB0_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB0_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB0_AM_enable_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB0_AM_enable_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB0_AM_enable_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB15_OM_mask_w                  ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB15_OM_mask_h0                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB15_OM_mask_b1                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB15_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB15_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB15_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB15_OM_enable_w                ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB15_OM_enable_h0               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB15_OM_enable_b1               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB14_OM_mask_w                  ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB14_OM_mask_h0                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB14_OM_mask_b1                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB14_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB14_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB14_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB14_OM_enable_w                ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB14_OM_enable_h0               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB14_OM_enable_b1               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB13_OM_mask_w                  ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB13_OM_mask_h0                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB13_OM_mask_b1                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB13_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB13_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB13_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB13_OM_enable_w                ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB13_OM_enable_h0               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB13_OM_enable_b1               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB12_OM_mask_w                  ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB12_OM_mask_h0                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB12_OM_mask_b1                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB12_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB12_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB12_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB12_OM_enable_w                ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB12_OM_enable_h0               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB12_OM_enable_b1               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB11_OM_mask_w                  ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB11_OM_mask_h0                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB11_OM_mask_b1                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB11_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB11_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB11_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB11_OM_enable_w                ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB11_OM_enable_h0               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB11_OM_enable_b1               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB10_OM_mask_w                  ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB10_OM_mask_h0                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB10_OM_mask_b1                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB10_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB10_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB10_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB10_OM_enable_w                ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB10_OM_enable_h0               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB10_OM_enable_b1               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB9_OM_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB9_OM_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB9_OM_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB9_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB9_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB9_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB9_OM_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB9_OM_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB9_OM_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB8_OM_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB8_OM_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB8_OM_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB8_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB8_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB8_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB8_OM_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB8_OM_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB8_OM_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB7_OM_mask_w                   ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB7_OM_mask_h0                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB7_OM_mask_b0                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB7_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB7_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB7_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB7_OM_enable_w                 ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB7_OM_enable_h0                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB7_OM_enable_b0                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB6_OM_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB6_OM_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB6_OM_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB6_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB6_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB6_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB6_OM_enable_w                 ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB6_OM_enable_h0                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB6_OM_enable_b0                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB5_OM_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB5_OM_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB5_OM_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB5_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB5_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB5_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB5_OM_enable_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB5_OM_enable_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB5_OM_enable_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB4_OM_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB4_OM_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB4_OM_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB4_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB4_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB4_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB4_OM_enable_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB4_OM_enable_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB4_OM_enable_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB3_OM_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB3_OM_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB3_OM_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB3_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB3_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB3_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB3_OM_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB3_OM_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB3_OM_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB2_OM_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB2_OM_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB2_OM_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB2_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB2_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB2_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB2_OM_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB2_OM_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB2_OM_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB1_OM_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB1_OM_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB1_OM_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB1_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB1_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB1_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB1_OM_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB1_OM_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB1_OM_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PB_MSK_PB0_OM_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PB_MSK_PB0_OM_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PB_MSK_PB0_OM_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PB_MSK_PB0_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PB_MSK_PB0_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PB_MSK_PB0_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PB_MSK_PB0_OM_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PB_MSK_PB0_OM_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PB_MSK_PB0_OM_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_PF  [register's definitions]
 *              Offset[0x40]  EXIC PC input interrupt pending flag register (0x50000040)
 ******************************************************************************
 */
///@{
#define EXIC_PC_PF_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PC_PF */
#define EXIC_PC_PF_PC14_PF_mask_w                   ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC14_PF_mask_h0                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC14_PF_mask_b1                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC14_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC14_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC14_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC14_PF_happened_w               ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC14_PF_happened_h0              ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC14_PF_happened_b1              ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC13_PF_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC13_PF_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC13_PF_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC13_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC13_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC13_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC13_PF_happened_w               ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC13_PF_happened_h0              ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC13_PF_happened_b1              ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC12_PF_mask_w                   ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC12_PF_mask_h0                  ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC12_PF_mask_b1                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC12_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC12_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC12_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC12_PF_happened_w               ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC12_PF_happened_h0              ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC12_PF_happened_b1              ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC11_PF_mask_w                   ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC11_PF_mask_h0                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC11_PF_mask_b1                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC11_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC11_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC11_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC11_PF_happened_w               ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC11_PF_happened_h0              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC11_PF_happened_b1              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC10_PF_mask_w                   ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC10_PF_mask_h0                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC10_PF_mask_b1                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC10_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC10_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC10_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC10_PF_happened_w               ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC10_PF_happened_h0              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC10_PF_happened_b1              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC9_PF_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC9_PF_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC9_PF_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC9_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC9_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC9_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC9_PF_happened_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC9_PF_happened_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC9_PF_happened_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC8_PF_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC8_PF_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC8_PF_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC8_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC8_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC8_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC8_PF_happened_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC8_PF_happened_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC8_PF_happened_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC7_PF_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC7_PF_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC7_PF_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC7_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC7_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC7_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC7_PF_happened_w                ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC7_PF_happened_h0               ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC7_PF_happened_b0               ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC6_PF_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC6_PF_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC6_PF_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC6_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC6_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC6_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC6_PF_happened_w                ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC6_PF_happened_h0               ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC6_PF_happened_b0               ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC5_PF_mask_w                    ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC5_PF_mask_h0                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC5_PF_mask_b0                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC5_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC5_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC5_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC5_PF_happened_w                ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC5_PF_happened_h0               ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC5_PF_happened_b0               ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC4_PF_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC4_PF_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC4_PF_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC4_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC4_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC4_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC4_PF_happened_w                ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC4_PF_happened_h0               ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC4_PF_happened_b0               ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC3_PF_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC3_PF_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC3_PF_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC3_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC3_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC3_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC3_PF_happened_w                ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC3_PF_happened_h0               ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC3_PF_happened_b0               ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC2_PF_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC2_PF_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC2_PF_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC2_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC2_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC2_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC2_PF_happened_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC2_PF_happened_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC2_PF_happened_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC1_PF_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC1_PF_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC1_PF_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC1_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC1_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC1_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC1_PF_happened_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC1_PF_happened_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC1_PF_happened_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PC_PF_PC0_PF_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PC_PF_PC0_PF_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PC_PF_PC0_PF_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PC_PF_PC0_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PC_PF_PC0_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PC_PF_PC0_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PC_PF_PC0_PF_happened_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PC_PF_PC0_PF_happened_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PC_PF_PC0_PF_happened_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_TRGS  [register's definitions]
 *              Offset[0x44]  EXIC PC Pad input trigger select register (0x50000044)
 ******************************************************************************
 */
///@{
#define EXIC_PC_TRGS_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PC_TRGS */
#define EXIC_PC_TRGS_PC14_TRGS_mask_w               ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC14_TRGS_mask_h1              ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC14_TRGS_mask_b3              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC14_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC14_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC14_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC14_TRGS_level_w              ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC14_TRGS_level_h1             ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC14_TRGS_level_b3             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC14_TRGS_edge_w               ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC14_TRGS_edge_h1              ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC14_TRGS_edge_b3              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC14_TRGS_dual_edge_w          ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC14_TRGS_dual_edge_h1         ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC14_TRGS_dual_edge_b3         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC13_TRGS_mask_w               ((uint32_t)0x0C000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC13_TRGS_mask_h1              ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC13_TRGS_mask_b3              ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC13_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC13_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC13_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC13_TRGS_level_w              ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC13_TRGS_level_h1             ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC13_TRGS_level_b3             ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC13_TRGS_edge_w               ((uint32_t)0x08000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC13_TRGS_edge_h1              ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC13_TRGS_edge_b3              ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC13_TRGS_dual_edge_w          ((uint32_t)0x0C000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC13_TRGS_dual_edge_h1         ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC13_TRGS_dual_edge_b3         ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC12_TRGS_mask_w               ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC12_TRGS_mask_h1              ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC12_TRGS_mask_b3              ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC12_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC12_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC12_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC12_TRGS_level_w              ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC12_TRGS_level_h1             ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC12_TRGS_level_b3             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC12_TRGS_edge_w               ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC12_TRGS_edge_h1              ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC12_TRGS_edge_b3              ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC12_TRGS_dual_edge_w          ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC12_TRGS_dual_edge_h1         ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC12_TRGS_dual_edge_b3         ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC11_TRGS_mask_w               ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC11_TRGS_mask_h1              ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC11_TRGS_mask_b2              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC11_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC11_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC11_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC11_TRGS_level_w              ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC11_TRGS_level_h1             ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC11_TRGS_level_b2             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC11_TRGS_edge_w               ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC11_TRGS_edge_h1              ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC11_TRGS_edge_b2              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC11_TRGS_dual_edge_w          ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC11_TRGS_dual_edge_h1         ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC11_TRGS_dual_edge_b2         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC10_TRGS_mask_w               ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC10_TRGS_mask_h1              ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC10_TRGS_mask_b2              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC10_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC10_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC10_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC10_TRGS_level_w              ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC10_TRGS_level_h1             ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC10_TRGS_level_b2             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC10_TRGS_edge_w               ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC10_TRGS_edge_h1              ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC10_TRGS_edge_b2              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC10_TRGS_dual_edge_w          ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC10_TRGS_dual_edge_h1         ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC10_TRGS_dual_edge_b2         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC9_TRGS_mask_w                ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC9_TRGS_mask_h1               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC9_TRGS_mask_b2               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC9_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC9_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC9_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC9_TRGS_level_w               ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC9_TRGS_level_h1              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC9_TRGS_level_b2              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC9_TRGS_edge_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC9_TRGS_edge_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC9_TRGS_edge_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC9_TRGS_dual_edge_w           ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC9_TRGS_dual_edge_h1          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC9_TRGS_dual_edge_b2          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC8_TRGS_mask_w                ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC8_TRGS_mask_h1               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC8_TRGS_mask_b2               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC8_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC8_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC8_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC8_TRGS_level_w               ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC8_TRGS_level_h1              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC8_TRGS_level_b2              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC8_TRGS_edge_w                ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC8_TRGS_edge_h1               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC8_TRGS_edge_b2               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC8_TRGS_dual_edge_w           ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC8_TRGS_dual_edge_h1          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC8_TRGS_dual_edge_b2          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC7_TRGS_mask_w                ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC7_TRGS_mask_h0               ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC7_TRGS_mask_b1               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC7_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC7_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC7_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC7_TRGS_level_w               ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC7_TRGS_level_h0              ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC7_TRGS_level_b1              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC7_TRGS_edge_w                ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC7_TRGS_edge_h0               ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC7_TRGS_edge_b1               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC7_TRGS_dual_edge_w           ((uint32_t)0x0000C000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC7_TRGS_dual_edge_h0          ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC7_TRGS_dual_edge_b1          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC6_TRGS_mask_w                ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC6_TRGS_mask_h0               ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC6_TRGS_mask_b1               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC6_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC6_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC6_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC6_TRGS_level_w               ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC6_TRGS_level_h0              ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC6_TRGS_level_b1              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC6_TRGS_edge_w                ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC6_TRGS_edge_h0               ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC6_TRGS_edge_b1               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC6_TRGS_dual_edge_w           ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC6_TRGS_dual_edge_h0          ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC6_TRGS_dual_edge_b1          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC5_TRGS_mask_w                ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC5_TRGS_mask_h0               ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC5_TRGS_mask_b1               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC5_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC5_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC5_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC5_TRGS_level_w               ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC5_TRGS_level_h0              ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC5_TRGS_level_b1              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC5_TRGS_edge_w                ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC5_TRGS_edge_h0               ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC5_TRGS_edge_b1               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC5_TRGS_dual_edge_w           ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC5_TRGS_dual_edge_h0          ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC5_TRGS_dual_edge_b1          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC4_TRGS_mask_w                ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC4_TRGS_mask_h0               ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC4_TRGS_mask_b1               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC4_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC4_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC4_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC4_TRGS_level_w               ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC4_TRGS_level_h0              ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC4_TRGS_level_b1              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC4_TRGS_edge_w                ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC4_TRGS_edge_h0               ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC4_TRGS_edge_b1               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC4_TRGS_dual_edge_w           ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC4_TRGS_dual_edge_h0          ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC4_TRGS_dual_edge_b1          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC3_TRGS_mask_w                ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC3_TRGS_mask_h0               ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC3_TRGS_mask_b0               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC3_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC3_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC3_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC3_TRGS_level_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC3_TRGS_level_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC3_TRGS_level_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC3_TRGS_edge_w                ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC3_TRGS_edge_h0               ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC3_TRGS_edge_b0               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC3_TRGS_dual_edge_w           ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC3_TRGS_dual_edge_h0          ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC3_TRGS_dual_edge_b0          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC2_TRGS_mask_w                ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC2_TRGS_mask_h0               ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC2_TRGS_mask_b0               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC2_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC2_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC2_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC2_TRGS_level_w               ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC2_TRGS_level_h0              ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC2_TRGS_level_b0              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC2_TRGS_edge_w                ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC2_TRGS_edge_h0               ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC2_TRGS_edge_b0               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC2_TRGS_dual_edge_w           ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC2_TRGS_dual_edge_h0          ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC2_TRGS_dual_edge_b0          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC1_TRGS_mask_w                ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC1_TRGS_mask_h0               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC1_TRGS_mask_b0               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC1_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC1_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC1_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC1_TRGS_level_w               ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC1_TRGS_level_h0              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC1_TRGS_level_b0              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC1_TRGS_edge_w                ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC1_TRGS_edge_h0               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC1_TRGS_edge_b0               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC1_TRGS_dual_edge_w           ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC1_TRGS_dual_edge_h0          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC1_TRGS_dual_edge_b0          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PC_TRGS_PC0_TRGS_mask_w                ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define EXIC_PC_TRGS_PC0_TRGS_mask_h0               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PC_TRGS_PC0_TRGS_mask_b0               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PC_TRGS_PC0_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PC_TRGS_PC0_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PC_TRGS_PC0_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PC_TRGS_PC0_TRGS_level_w               ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PC_TRGS_PC0_TRGS_level_h0              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PC_TRGS_PC0_TRGS_level_b0              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PC_TRGS_PC0_TRGS_edge_w                ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PC_TRGS_PC0_TRGS_edge_h0               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PC_TRGS_PC0_TRGS_edge_b0               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PC_TRGS_PC0_TRGS_dual_edge_w           ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PC_TRGS_PC0_TRGS_dual_edge_h0          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PC_TRGS_PC0_TRGS_dual_edge_b0          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_MSK  [register's definitions]
 *              Offset[0x48]  EXIC  PC AOI Mask register (0x50000048)
 ******************************************************************************
 */
///@{
#define EXIC_PC_MSK_default                         ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PC_MSK */
#define EXIC_PC_MSK_PC14_AM_mask_w                  ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC14_AM_mask_h1                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC14_AM_mask_b3                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC14_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC14_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC14_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC14_AM_enable_w                ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC14_AM_enable_h1               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC14_AM_enable_b3               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC13_AM_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC13_AM_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC13_AM_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC13_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC13_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC13_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC13_AM_enable_w                ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC13_AM_enable_h1               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC13_AM_enable_b3               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC12_AM_mask_w                  ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC12_AM_mask_h1                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC12_AM_mask_b3                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC12_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC12_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC12_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC12_AM_enable_w                ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC12_AM_enable_h1               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC12_AM_enable_b3               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC11_AM_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC11_AM_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC11_AM_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC11_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC11_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC11_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC11_AM_enable_w                ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC11_AM_enable_h1               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC11_AM_enable_b3               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC10_AM_mask_w                  ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC10_AM_mask_h1                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC10_AM_mask_b3                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC10_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC10_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC10_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC10_AM_enable_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC10_AM_enable_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC10_AM_enable_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC9_AM_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC9_AM_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC9_AM_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC9_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC9_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC9_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC9_AM_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC9_AM_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC9_AM_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC8_AM_mask_w                   ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC8_AM_mask_h1                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC8_AM_mask_b3                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC8_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC8_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC8_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC8_AM_enable_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC8_AM_enable_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC8_AM_enable_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC7_AM_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC7_AM_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC7_AM_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC7_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC7_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC7_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC7_AM_enable_w                 ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC7_AM_enable_h1                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC7_AM_enable_b2                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC6_AM_mask_w                   ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC6_AM_mask_h1                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC6_AM_mask_b2                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC6_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC6_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC6_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC6_AM_enable_w                 ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC6_AM_enable_h1                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC6_AM_enable_b2                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC5_AM_mask_w                   ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC5_AM_mask_h1                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC5_AM_mask_b2                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC5_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC5_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC5_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC5_AM_enable_w                 ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC5_AM_enable_h1                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC5_AM_enable_b2                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC4_AM_mask_w                   ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC4_AM_mask_h1                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC4_AM_mask_b2                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC4_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC4_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC4_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC4_AM_enable_w                 ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC4_AM_enable_h1                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC4_AM_enable_b2                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC3_AM_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC3_AM_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC3_AM_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC3_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC3_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC3_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC3_AM_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC3_AM_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC3_AM_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC2_AM_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC2_AM_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC2_AM_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC2_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC2_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC2_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC2_AM_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC2_AM_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC2_AM_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC1_AM_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC1_AM_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC1_AM_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC1_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC1_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC1_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC1_AM_enable_w                 ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC1_AM_enable_h1                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC1_AM_enable_b2                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC0_AM_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC0_AM_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC0_AM_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC0_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC0_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC0_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC0_AM_enable_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC0_AM_enable_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC0_AM_enable_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC14_OM_mask_w                  ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC14_OM_mask_h0                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC14_OM_mask_b1                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC14_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC14_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC14_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC14_OM_enable_w                ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC14_OM_enable_h0               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC14_OM_enable_b1               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC13_OM_mask_w                  ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC13_OM_mask_h0                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC13_OM_mask_b1                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC13_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC13_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC13_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC13_OM_enable_w                ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC13_OM_enable_h0               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC13_OM_enable_b1               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC12_OM_mask_w                  ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC12_OM_mask_h0                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC12_OM_mask_b1                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC12_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC12_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC12_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC12_OM_enable_w                ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC12_OM_enable_h0               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC12_OM_enable_b1               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC11_OM_mask_w                  ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC11_OM_mask_h0                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC11_OM_mask_b1                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC11_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC11_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC11_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC11_OM_enable_w                ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC11_OM_enable_h0               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC11_OM_enable_b1               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC10_OM_mask_w                  ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC10_OM_mask_h0                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC10_OM_mask_b1                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC10_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC10_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC10_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC10_OM_enable_w                ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC10_OM_enable_h0               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC10_OM_enable_b1               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC9_OM_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC9_OM_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC9_OM_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC9_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC9_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC9_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC9_OM_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC9_OM_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC9_OM_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC8_OM_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC8_OM_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC8_OM_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC8_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC8_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC8_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC8_OM_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC8_OM_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC8_OM_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC7_OM_mask_w                   ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC7_OM_mask_h0                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC7_OM_mask_b0                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC7_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC7_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC7_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC7_OM_enable_w                 ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC7_OM_enable_h0                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC7_OM_enable_b0                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC6_OM_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC6_OM_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC6_OM_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC6_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC6_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC6_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC6_OM_enable_w                 ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC6_OM_enable_h0                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC6_OM_enable_b0                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC5_OM_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC5_OM_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC5_OM_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC5_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC5_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC5_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC5_OM_enable_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC5_OM_enable_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC5_OM_enable_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC4_OM_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC4_OM_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC4_OM_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC4_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC4_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC4_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC4_OM_enable_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC4_OM_enable_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC4_OM_enable_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC3_OM_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC3_OM_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC3_OM_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC3_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC3_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC3_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC3_OM_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC3_OM_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC3_OM_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC2_OM_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC2_OM_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC2_OM_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC2_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC2_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC2_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC2_OM_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC2_OM_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC2_OM_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC1_OM_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC1_OM_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC1_OM_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC1_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC1_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC1_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC1_OM_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC1_OM_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC1_OM_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PC_MSK_PC0_OM_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PC_MSK_PC0_OM_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PC_MSK_PC0_OM_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PC_MSK_PC0_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PC_MSK_PC0_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PC_MSK_PC0_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PC_MSK_PC0_OM_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PC_MSK_PC0_OM_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PC_MSK_PC0_OM_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_PF  [register's definitions]
 *              Offset[0x50]  EXIC PD input interrupt pending flag register (0x50000050)
 ******************************************************************************
 */
///@{
#define EXIC_PD_PF_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PD_PF */
#define EXIC_PD_PF_PD15_PF_mask_w                   ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD15_PF_mask_h0                  ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD15_PF_mask_b1                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD15_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD15_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD15_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD15_PF_happened_w               ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD15_PF_happened_h0              ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD15_PF_happened_b1              ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD14_PF_mask_w                   ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD14_PF_mask_h0                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD14_PF_mask_b1                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD14_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD14_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD14_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD14_PF_happened_w               ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD14_PF_happened_h0              ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD14_PF_happened_b1              ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD13_PF_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD13_PF_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD13_PF_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD13_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD13_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD13_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD13_PF_happened_w               ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD13_PF_happened_h0              ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD13_PF_happened_b1              ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD12_PF_mask_w                   ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD12_PF_mask_h0                  ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD12_PF_mask_b1                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD12_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD12_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD12_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD12_PF_happened_w               ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD12_PF_happened_h0              ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD12_PF_happened_b1              ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD11_PF_mask_w                   ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD11_PF_mask_h0                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD11_PF_mask_b1                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD11_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD11_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD11_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD11_PF_happened_w               ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD11_PF_happened_h0              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD11_PF_happened_b1              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD10_PF_mask_w                   ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD10_PF_mask_h0                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD10_PF_mask_b1                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD10_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD10_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD10_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD10_PF_happened_w               ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD10_PF_happened_h0              ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD10_PF_happened_b1              ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD9_PF_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD9_PF_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD9_PF_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD9_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD9_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD9_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD9_PF_happened_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD9_PF_happened_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD9_PF_happened_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD8_PF_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD8_PF_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD8_PF_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD8_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD8_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD8_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD8_PF_happened_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD8_PF_happened_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD8_PF_happened_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD7_PF_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD7_PF_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD7_PF_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD7_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD7_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD7_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD7_PF_happened_w                ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD7_PF_happened_h0               ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD7_PF_happened_b0               ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD6_PF_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD6_PF_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD6_PF_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD6_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD6_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD6_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD6_PF_happened_w                ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD6_PF_happened_h0               ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD6_PF_happened_b0               ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD5_PF_mask_w                    ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD5_PF_mask_h0                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD5_PF_mask_b0                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD5_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD5_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD5_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD5_PF_happened_w                ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD5_PF_happened_h0               ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD5_PF_happened_b0               ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD4_PF_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD4_PF_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD4_PF_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD4_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD4_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD4_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD4_PF_happened_w                ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD4_PF_happened_h0               ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD4_PF_happened_b0               ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD3_PF_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD3_PF_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD3_PF_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD3_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD3_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD3_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD3_PF_happened_w                ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD3_PF_happened_h0               ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD3_PF_happened_b0               ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD2_PF_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD2_PF_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD2_PF_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD2_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD2_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD2_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD2_PF_happened_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD2_PF_happened_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD2_PF_happened_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD1_PF_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD1_PF_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD1_PF_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD1_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD1_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD1_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD1_PF_happened_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD1_PF_happened_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD1_PF_happened_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PD_PF_PD0_PF_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PD_PF_PD0_PF_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PD_PF_PD0_PF_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PD_PF_PD0_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PD_PF_PD0_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PD_PF_PD0_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PD_PF_PD0_PF_happened_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PD_PF_PD0_PF_happened_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PD_PF_PD0_PF_happened_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_TRGS  [register's definitions]
 *              Offset[0x54]  EXIC PD Pad input trigger select register (0x50000054)
 ******************************************************************************
 */
///@{
#define EXIC_PD_TRGS_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PD_TRGS */
#define EXIC_PD_TRGS_PD15_TRGS_mask_w               ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD15_TRGS_mask_h1              ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD15_TRGS_mask_b3              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD15_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD15_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD15_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD15_TRGS_level_w              ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD15_TRGS_level_h1             ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD15_TRGS_level_b3             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD15_TRGS_edge_w               ((uint32_t)0x80000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD15_TRGS_edge_h1              ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD15_TRGS_edge_b3              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD15_TRGS_dual_edge_w          ((uint32_t)0xC0000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD15_TRGS_dual_edge_h1         ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD15_TRGS_dual_edge_b3         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD14_TRGS_mask_w               ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD14_TRGS_mask_h1              ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD14_TRGS_mask_b3              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD14_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD14_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD14_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD14_TRGS_level_w              ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD14_TRGS_level_h1             ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD14_TRGS_level_b3             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD14_TRGS_edge_w               ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD14_TRGS_edge_h1              ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD14_TRGS_edge_b3              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD14_TRGS_dual_edge_w          ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD14_TRGS_dual_edge_h1         ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD14_TRGS_dual_edge_b3         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD13_TRGS_mask_w               ((uint32_t)0x0C000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD13_TRGS_mask_h1              ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD13_TRGS_mask_b3              ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD13_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD13_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD13_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD13_TRGS_level_w              ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD13_TRGS_level_h1             ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD13_TRGS_level_b3             ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD13_TRGS_edge_w               ((uint32_t)0x08000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD13_TRGS_edge_h1              ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD13_TRGS_edge_b3              ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD13_TRGS_dual_edge_w          ((uint32_t)0x0C000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD13_TRGS_dual_edge_h1         ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD13_TRGS_dual_edge_b3         ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD12_TRGS_mask_w               ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD12_TRGS_mask_h1              ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD12_TRGS_mask_b3              ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD12_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD12_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD12_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD12_TRGS_level_w              ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD12_TRGS_level_h1             ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD12_TRGS_level_b3             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD12_TRGS_edge_w               ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD12_TRGS_edge_h1              ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD12_TRGS_edge_b3              ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD12_TRGS_dual_edge_w          ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD12_TRGS_dual_edge_h1         ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD12_TRGS_dual_edge_b3         ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD11_TRGS_mask_w               ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD11_TRGS_mask_h1              ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD11_TRGS_mask_b2              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD11_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD11_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD11_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD11_TRGS_level_w              ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD11_TRGS_level_h1             ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD11_TRGS_level_b2             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD11_TRGS_edge_w               ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD11_TRGS_edge_h1              ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD11_TRGS_edge_b2              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD11_TRGS_dual_edge_w          ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD11_TRGS_dual_edge_h1         ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD11_TRGS_dual_edge_b2         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD10_TRGS_mask_w               ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD10_TRGS_mask_h1              ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD10_TRGS_mask_b2              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD10_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD10_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD10_TRGS_no_b2                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD10_TRGS_level_w              ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD10_TRGS_level_h1             ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD10_TRGS_level_b2             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD10_TRGS_edge_w               ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD10_TRGS_edge_h1              ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD10_TRGS_edge_b2              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD10_TRGS_dual_edge_w          ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD10_TRGS_dual_edge_h1         ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD10_TRGS_dual_edge_b2         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD9_TRGS_mask_w                ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD9_TRGS_mask_h1               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD9_TRGS_mask_b2               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD9_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD9_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD9_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD9_TRGS_level_w               ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD9_TRGS_level_h1              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD9_TRGS_level_b2              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD9_TRGS_edge_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD9_TRGS_edge_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD9_TRGS_edge_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD9_TRGS_dual_edge_w           ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD9_TRGS_dual_edge_h1          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD9_TRGS_dual_edge_b2          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD8_TRGS_mask_w                ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD8_TRGS_mask_h1               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD8_TRGS_mask_b2               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD8_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD8_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD8_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD8_TRGS_level_w               ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD8_TRGS_level_h1              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD8_TRGS_level_b2              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD8_TRGS_edge_w                ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD8_TRGS_edge_h1               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD8_TRGS_edge_b2               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD8_TRGS_dual_edge_w           ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD8_TRGS_dual_edge_h1          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD8_TRGS_dual_edge_b2          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD7_TRGS_mask_w                ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD7_TRGS_mask_h0               ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD7_TRGS_mask_b1               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD7_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD7_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD7_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD7_TRGS_level_w               ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD7_TRGS_level_h0              ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD7_TRGS_level_b1              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD7_TRGS_edge_w                ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD7_TRGS_edge_h0               ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD7_TRGS_edge_b1               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD7_TRGS_dual_edge_w           ((uint32_t)0x0000C000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD7_TRGS_dual_edge_h0          ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD7_TRGS_dual_edge_b1          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD6_TRGS_mask_w                ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD6_TRGS_mask_h0               ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD6_TRGS_mask_b1               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD6_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD6_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD6_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD6_TRGS_level_w               ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD6_TRGS_level_h0              ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD6_TRGS_level_b1              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD6_TRGS_edge_w                ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD6_TRGS_edge_h0               ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD6_TRGS_edge_b1               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD6_TRGS_dual_edge_w           ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD6_TRGS_dual_edge_h0          ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD6_TRGS_dual_edge_b1          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD5_TRGS_mask_w                ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD5_TRGS_mask_h0               ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD5_TRGS_mask_b1               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD5_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD5_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD5_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD5_TRGS_level_w               ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD5_TRGS_level_h0              ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD5_TRGS_level_b1              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD5_TRGS_edge_w                ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD5_TRGS_edge_h0               ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD5_TRGS_edge_b1               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD5_TRGS_dual_edge_w           ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD5_TRGS_dual_edge_h0          ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD5_TRGS_dual_edge_b1          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD4_TRGS_mask_w                ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD4_TRGS_mask_h0               ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD4_TRGS_mask_b1               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD4_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD4_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD4_TRGS_no_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD4_TRGS_level_w               ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD4_TRGS_level_h0              ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD4_TRGS_level_b1              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD4_TRGS_edge_w                ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD4_TRGS_edge_h0               ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD4_TRGS_edge_b1               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD4_TRGS_dual_edge_w           ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD4_TRGS_dual_edge_h0          ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD4_TRGS_dual_edge_b1          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD3_TRGS_mask_w                ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD3_TRGS_mask_h0               ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD3_TRGS_mask_b0               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD3_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD3_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD3_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD3_TRGS_level_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD3_TRGS_level_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD3_TRGS_level_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD3_TRGS_edge_w                ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD3_TRGS_edge_h0               ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD3_TRGS_edge_b0               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD3_TRGS_dual_edge_w           ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD3_TRGS_dual_edge_h0          ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD3_TRGS_dual_edge_b0          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD2_TRGS_mask_w                ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD2_TRGS_mask_h0               ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD2_TRGS_mask_b0               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD2_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD2_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD2_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD2_TRGS_level_w               ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD2_TRGS_level_h0              ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD2_TRGS_level_b0              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD2_TRGS_edge_w                ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD2_TRGS_edge_h0               ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD2_TRGS_edge_b0               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD2_TRGS_dual_edge_w           ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD2_TRGS_dual_edge_h0          ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD2_TRGS_dual_edge_b0          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD1_TRGS_mask_w                ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD1_TRGS_mask_h0               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD1_TRGS_mask_b0               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD1_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD1_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD1_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD1_TRGS_level_w               ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD1_TRGS_level_h0              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD1_TRGS_level_b0              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD1_TRGS_edge_w                ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD1_TRGS_edge_h0               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD1_TRGS_edge_b0               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD1_TRGS_dual_edge_w           ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD1_TRGS_dual_edge_h0          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD1_TRGS_dual_edge_b0          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PD_TRGS_PD0_TRGS_mask_w                ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define EXIC_PD_TRGS_PD0_TRGS_mask_h0               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PD_TRGS_PD0_TRGS_mask_b0               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PD_TRGS_PD0_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PD_TRGS_PD0_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PD_TRGS_PD0_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PD_TRGS_PD0_TRGS_level_w               ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PD_TRGS_PD0_TRGS_level_h0              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PD_TRGS_PD0_TRGS_level_b0              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PD_TRGS_PD0_TRGS_edge_w                ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PD_TRGS_PD0_TRGS_edge_h0               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PD_TRGS_PD0_TRGS_edge_b0               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PD_TRGS_PD0_TRGS_dual_edge_w           ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PD_TRGS_PD0_TRGS_dual_edge_h0          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PD_TRGS_PD0_TRGS_dual_edge_b0          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_MSK  [register's definitions]
 *              Offset[0x58]  EXIC  PD AOI Mask register (0x50000058)
 ******************************************************************************
 */
///@{
#define EXIC_PD_MSK_default                         ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PD_MSK */
#define EXIC_PD_MSK_PD15_AM_mask_w                  ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD15_AM_mask_h1                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD15_AM_mask_b3                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD15_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD15_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD15_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD15_AM_enable_w                ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD15_AM_enable_h1               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD15_AM_enable_b3               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD14_AM_mask_w                  ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD14_AM_mask_h1                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD14_AM_mask_b3                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD14_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD14_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD14_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD14_AM_enable_w                ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD14_AM_enable_h1               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD14_AM_enable_b3               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD13_AM_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD13_AM_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD13_AM_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD13_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD13_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD13_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD13_AM_enable_w                ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD13_AM_enable_h1               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD13_AM_enable_b3               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD12_AM_mask_w                  ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD12_AM_mask_h1                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD12_AM_mask_b3                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD12_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD12_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD12_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD12_AM_enable_w                ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD12_AM_enable_h1               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD12_AM_enable_b3               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD11_AM_mask_w                  ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD11_AM_mask_h1                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD11_AM_mask_b3                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD11_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD11_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD11_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD11_AM_enable_w                ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD11_AM_enable_h1               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD11_AM_enable_b3               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD10_AM_mask_w                  ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD10_AM_mask_h1                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD10_AM_mask_b3                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD10_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD10_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD10_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD10_AM_enable_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD10_AM_enable_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD10_AM_enable_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD9_AM_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD9_AM_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD9_AM_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD9_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD9_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD9_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD9_AM_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD9_AM_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD9_AM_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD8_AM_mask_w                   ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD8_AM_mask_h1                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD8_AM_mask_b3                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD8_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD8_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD8_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD8_AM_enable_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD8_AM_enable_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD8_AM_enable_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD7_AM_mask_w                   ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD7_AM_mask_h1                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD7_AM_mask_b2                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD7_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD7_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD7_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD7_AM_enable_w                 ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD7_AM_enable_h1                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD7_AM_enable_b2                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD6_AM_mask_w                   ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD6_AM_mask_h1                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD6_AM_mask_b2                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD6_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD6_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD6_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD6_AM_enable_w                 ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD6_AM_enable_h1                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD6_AM_enable_b2                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD5_AM_mask_w                   ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD5_AM_mask_h1                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD5_AM_mask_b2                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD5_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD5_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD5_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD5_AM_enable_w                 ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD5_AM_enable_h1                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD5_AM_enable_b2                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD4_AM_mask_w                   ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD4_AM_mask_h1                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD4_AM_mask_b2                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD4_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD4_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD4_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD4_AM_enable_w                 ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD4_AM_enable_h1                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD4_AM_enable_b2                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD3_AM_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD3_AM_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD3_AM_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD3_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD3_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD3_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD3_AM_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD3_AM_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD3_AM_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD2_AM_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD2_AM_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD2_AM_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD2_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD2_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD2_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD2_AM_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD2_AM_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD2_AM_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD1_AM_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD1_AM_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD1_AM_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD1_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD1_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD1_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD1_AM_enable_w                 ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD1_AM_enable_h1                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD1_AM_enable_b2                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD0_AM_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD0_AM_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD0_AM_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD0_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD0_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD0_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD0_AM_enable_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD0_AM_enable_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD0_AM_enable_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD15_OM_mask_w                  ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD15_OM_mask_h0                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD15_OM_mask_b1                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD15_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD15_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD15_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD15_OM_enable_w                ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD15_OM_enable_h0               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD15_OM_enable_b1               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD14_OM_mask_w                  ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD14_OM_mask_h0                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD14_OM_mask_b1                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD14_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD14_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD14_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD14_OM_enable_w                ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD14_OM_enable_h0               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD14_OM_enable_b1               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD13_OM_mask_w                  ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD13_OM_mask_h0                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD13_OM_mask_b1                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD13_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD13_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD13_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD13_OM_enable_w                ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD13_OM_enable_h0               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD13_OM_enable_b1               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD12_OM_mask_w                  ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD12_OM_mask_h0                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD12_OM_mask_b1                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD12_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD12_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD12_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD12_OM_enable_w                ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD12_OM_enable_h0               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD12_OM_enable_b1               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD11_OM_mask_w                  ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD11_OM_mask_h0                 ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD11_OM_mask_b1                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD11_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD11_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD11_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD11_OM_enable_w                ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD11_OM_enable_h0               ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD11_OM_enable_b1               ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD10_OM_mask_w                  ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD10_OM_mask_h0                 ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD10_OM_mask_b1                 ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD10_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD10_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD10_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD10_OM_enable_w                ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD10_OM_enable_h0               ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD10_OM_enable_b1               ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD9_OM_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD9_OM_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD9_OM_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD9_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD9_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD9_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD9_OM_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD9_OM_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD9_OM_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD8_OM_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD8_OM_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD8_OM_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD8_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD8_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD8_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD8_OM_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD8_OM_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD8_OM_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD7_OM_mask_w                   ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD7_OM_mask_h0                  ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD7_OM_mask_b0                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD7_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD7_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD7_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD7_OM_enable_w                 ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD7_OM_enable_h0                ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD7_OM_enable_b0                ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD6_OM_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD6_OM_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD6_OM_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD6_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD6_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD6_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD6_OM_enable_w                 ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD6_OM_enable_h0                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD6_OM_enable_b0                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD5_OM_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD5_OM_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD5_OM_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD5_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD5_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD5_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD5_OM_enable_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD5_OM_enable_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD5_OM_enable_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD4_OM_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD4_OM_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD4_OM_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD4_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD4_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD4_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD4_OM_enable_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD4_OM_enable_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD4_OM_enable_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD3_OM_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD3_OM_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD3_OM_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD3_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD3_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD3_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD3_OM_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD3_OM_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD3_OM_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD2_OM_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD2_OM_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD2_OM_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD2_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD2_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD2_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD2_OM_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD2_OM_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD2_OM_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD1_OM_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD1_OM_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD1_OM_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD1_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD1_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD1_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD1_OM_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD1_OM_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD1_OM_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PD_MSK_PD0_OM_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PD_MSK_PD0_OM_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PD_MSK_PD0_OM_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PD_MSK_PD0_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PD_MSK_PD0_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PD_MSK_PD0_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PD_MSK_PD0_OM_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PD_MSK_PD0_OM_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PD_MSK_PD0_OM_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC0  [register's definitions]
 *              Offset[0x60]  EXIC Interrupt source identity register 0 (0x50000060)
 ******************************************************************************
 */
///@{
#define EXIC_SRC0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC0 */
#define EXIC_SRC0_ID3_mask_w                        ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC0_ID3_mask_h1                       ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC0_ID3_mask_b3                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC0_ID3_exint0_w                      ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):EXINT0 of 32bit */
#define EXIC_SRC0_ID3_exint0_h1                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):EXINT0 of 16bit */
#define EXIC_SRC0_ID3_exint0_b3                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):EXINT0 of 8bit */

#define EXIC_SRC0_ID2_mask_w                        ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC0_ID2_mask_h1                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC0_ID2_mask_b2                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC0_ID1_mask_w                        ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC0_ID1_mask_h0                       ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC0_ID1_mask_b1                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC0_ID1_iwdt_w                        ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):IWDT of 32bit */
#define EXIC_SRC0_ID1_iwdt_h0                       ((uint16_t)0x0100)      /*!< Bit Value =(0x1):IWDT of 16bit */
#define EXIC_SRC0_ID1_iwdt_b1                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):IWDT of 8bit */
#define EXIC_SRC0_ID1_pw_w                          ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):PW of 32bit */
#define EXIC_SRC0_ID1_pw_h0                         ((uint16_t)0x0200)      /*!< Bit Value =(0x2):PW of 16bit */
#define EXIC_SRC0_ID1_pw_b1                         ((uint8_t )0x02)        /*!< Bit Value =(0x2):PW of 8bit */
#define EXIC_SRC0_ID1_rtc_w                         ((uint32_t)0x00000800)  /*!< Bit Value =(0x8):RTC of 32bit */
#define EXIC_SRC0_ID1_rtc_h0                        ((uint16_t)0x0800)      /*!< Bit Value =(0x8):RTC of 16bit */
#define EXIC_SRC0_ID1_rtc_b1                        ((uint8_t )0x08)        /*!< Bit Value =(0x8):RTC of 8bit */
#define EXIC_SRC0_ID1_csc_w                         ((uint32_t)0x00001000)  /*!< Bit Value =(0x10):CSC of 32bit */
#define EXIC_SRC0_ID1_csc_h0                        ((uint16_t)0x1000)      /*!< Bit Value =(0x10):CSC of 16bit */
#define EXIC_SRC0_ID1_csc_b1                        ((uint8_t )0x10)        /*!< Bit Value =(0x10):CSC of 8bit */
#define EXIC_SRC0_ID1_apb_w                         ((uint32_t)0x00002000)  /*!< Bit Value =(0x20):APB of 32bit */
#define EXIC_SRC0_ID1_apb_h0                        ((uint16_t)0x2000)      /*!< Bit Value =(0x20):APB of 16bit */
#define EXIC_SRC0_ID1_apb_b1                        ((uint8_t )0x20)        /*!< Bit Value =(0x20):APB of 8bit */
#define EXIC_SRC0_ID1_mem_w                         ((uint32_t)0x00004000)  /*!< Bit Value =(0x40):MEM of 32bit */
#define EXIC_SRC0_ID1_mem_h0                        ((uint16_t)0x4000)      /*!< Bit Value =(0x40):MEM of 16bit */
#define EXIC_SRC0_ID1_mem_b1                        ((uint8_t )0x40)        /*!< Bit Value =(0x40):MEM of 8bit */

#define EXIC_SRC0_ID0_mask_w                        ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC0_ID0_mask_h0                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC0_ID0_mask_b0                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC0_ID0_wwdt_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):WWDT of 32bit */
#define EXIC_SRC0_ID0_wwdt_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(0x1):WWDT of 16bit */
#define EXIC_SRC0_ID0_wwdt_b0                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):WWDT of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC1  [register's definitions]
 *              Offset[0x64]  EXIC interrupt source identity register 1 (0x50000064)
 ******************************************************************************
 */
///@{
#define EXIC_SRC1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC1 */
#define EXIC_SRC1_ID7_mask_w                        ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC1_ID7_mask_h1                       ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC1_ID7_mask_b3                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC1_ID7_cmp_w                         ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):CMP of 32bit */
#define EXIC_SRC1_ID7_cmp_h1                        ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CMP of 16bit */
#define EXIC_SRC1_ID7_cmp_b3                        ((uint8_t )0x01)        /*!< Bit Value =(0x1):CMP of 8bit */

#define EXIC_SRC1_ID6_mask_w                        ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC1_ID6_mask_h1                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC1_ID6_mask_b2                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC1_ID6_exint3_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):EXINT3 of 32bit */
#define EXIC_SRC1_ID6_exint3_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(0x1):EXINT3 of 16bit */
#define EXIC_SRC1_ID6_exint3_b2                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):EXINT3 of 8bit */
#define EXIC_SRC1_ID6_exint4_w                      ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):EXINT4 of 32bit */
#define EXIC_SRC1_ID6_exint4_h1                     ((uint16_t)0x0002)      /*!< Bit Value =(0x2):EXINT4 of 16bit */
#define EXIC_SRC1_ID6_exint4_b2                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):EXINT4 of 8bit */

#define EXIC_SRC1_ID5_mask_w                        ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC1_ID5_mask_h0                       ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC1_ID5_mask_b1                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC1_ID5_exint2_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):EXINT2 of 32bit */
#define EXIC_SRC1_ID5_exint2_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):EXINT2 of 16bit */
#define EXIC_SRC1_ID5_exint2_b1                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):EXINT2 of 8bit */

#define EXIC_SRC1_ID4_mask_w                        ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC1_ID4_mask_h0                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC1_ID4_mask_b0                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC1_ID4_exint1_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):EXINT1 of 32bit */
#define EXIC_SRC1_ID4_exint1_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(0x1):EXINT1 of 16bit */
#define EXIC_SRC1_ID4_exint1_b0                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):EXINT1 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC2  [register's definitions]
 *              Offset[0x68]  EXIC interrupt source identity register 2 (0x50000068)
 ******************************************************************************
 */
///@{
#define EXIC_SRC2_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC2 */
#define EXIC_SRC2_ID11_mask_w                       ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC2_ID11_mask_h1                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC2_ID11_mask_b3                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC2_ID10_mask_w                       ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC2_ID10_mask_h1                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC2_ID10_mask_b2                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC2_ID10_adc_w                        ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):ADC of 32bit */
#define EXIC_SRC2_ID10_adc_h1                       ((uint16_t)0x0001)      /*!< Bit Value =(0x1):ADC of 16bit */
#define EXIC_SRC2_ID10_adc_b2                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):ADC of 8bit */

#define EXIC_SRC2_ID9_mask_w                        ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC2_ID9_mask_h0                       ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC2_ID9_mask_b1                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC2_ID9_opa_w                         ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):OPA of 32bit */
#define EXIC_SRC2_ID9_opa_h0                        ((uint16_t)0x0100)      /*!< Bit Value =(0x1):OPA of 16bit */
#define EXIC_SRC2_ID9_opa_b1                        ((uint8_t )0x01)        /*!< Bit Value =(0x1):OPA of 8bit */

#define EXIC_SRC2_ID8_mask_w                        ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC2_ID8_mask_h0                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC2_ID8_mask_b0                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC2_ID8_dma_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):DMA of 32bit */
#define EXIC_SRC2_ID8_dma_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(0x1):DMA of 16bit */
#define EXIC_SRC2_ID8_dma_b0                        ((uint8_t )0x01)        /*!< Bit Value =(0x1):DMA of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC3  [register's definitions]
 *              Offset[0x6C]  EXIC interrupt source identity register 3 (0x5000006C)
 ******************************************************************************
 */
///@{
#define EXIC_SRC3_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC3 */
#define EXIC_SRC3_ID15_mask_w                       ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC3_ID15_mask_h1                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC3_ID15_mask_b3                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC3_ID15_tm20_w                       ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):TM20 of 32bit */
#define EXIC_SRC3_ID15_tm20_h1                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):TM20 of 16bit */
#define EXIC_SRC3_ID15_tm20_b3                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):TM20 of 8bit */

#define EXIC_SRC3_ID14_mask_w                       ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC3_ID14_mask_h1                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC3_ID14_mask_b2                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC3_ID14_tm16_w                       ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):TM16 of 32bit */
#define EXIC_SRC3_ID14_tm16_h1                      ((uint16_t)0x0004)      /*!< Bit Value =(0x4):TM16 of 16bit */
#define EXIC_SRC3_ID14_tm16_b2                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):TM16 of 8bit */

#define EXIC_SRC3_ID13_mask_w                       ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC3_ID13_mask_h0                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC3_ID13_mask_b1                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC3_ID13_tm10_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):TM10 of 32bit */
#define EXIC_SRC3_ID13_tm10_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):TM10 of 16bit */
#define EXIC_SRC3_ID13_tm10_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):TM10 of 8bit */

#define EXIC_SRC3_ID12_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC3_ID12_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC3_ID12_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC3_ID12_tm00_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):TM00 of 32bit */
#define EXIC_SRC3_ID12_tm00_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):TM00 of 16bit */
#define EXIC_SRC3_ID12_tm00_b0                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):TM00 of 8bit */
#define EXIC_SRC3_ID12_tm01_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):TM01 of 32bit */
#define EXIC_SRC3_ID12_tm01_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):TM01 of 16bit */
#define EXIC_SRC3_ID12_tm01_b0                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):TM01 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC4  [register's definitions]
 *              Offset[0x70]  EXIC interrupt source identity register 4 (0x50000070)
 ******************************************************************************
 */
///@{
#define EXIC_SRC4_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC4 */
#define EXIC_SRC4_ID19_mask_w                       ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC4_ID19_mask_h1                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC4_ID19_mask_b3                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC4_ID19_lcd_w                        ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):LCD of 32bit */
#define EXIC_SRC4_ID19_lcd_h1                       ((uint16_t)0x0100)      /*!< Bit Value =(0x1):LCD of 16bit */
#define EXIC_SRC4_ID19_lcd_b3                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):LCD of 8bit */

#define EXIC_SRC4_ID18_mask_w                       ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC4_ID18_mask_h1                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC4_ID18_mask_b2                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC4_ID17_mask_w                       ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC4_ID17_mask_h0                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC4_ID17_mask_b1                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC4_ID17_tm36_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):TM36 of 32bit */
#define EXIC_SRC4_ID17_tm36_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(0x4):TM36 of 16bit */
#define EXIC_SRC4_ID17_tm36_b1                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):TM36 of 8bit */

#define EXIC_SRC4_ID16_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC4_ID16_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC4_ID16_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC4_ID16_tm26_w                       ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):TM26 of 32bit */
#define EXIC_SRC4_ID16_tm26_h0                      ((uint16_t)0x0004)      /*!< Bit Value =(0x4):TM26 of 16bit */
#define EXIC_SRC4_ID16_tm26_b0                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):TM26 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC5  [register's definitions]
 *              Offset[0x74]  EXIC interrupt source identity register 5 (0x50000074)
 ******************************************************************************
 */
///@{
#define EXIC_SRC5_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC5 */
#define EXIC_SRC5_ID23_mask_w                       ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC5_ID23_mask_h1                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC5_ID23_mask_b3                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC5_ID22_mask_w                       ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC5_ID22_mask_h1                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC5_ID22_mask_b2                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC5_ID22_urt4_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):URT4 of 32bit */
#define EXIC_SRC5_ID22_urt4_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):URT4 of 16bit */
#define EXIC_SRC5_ID22_urt4_b2                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):URT4 of 8bit */
#define EXIC_SRC5_ID22_urt5_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):URT5 of 32bit */
#define EXIC_SRC5_ID22_urt5_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):URT5 of 16bit */
#define EXIC_SRC5_ID22_urt5_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):URT5 of 8bit */
#define EXIC_SRC5_ID22_urt6_w                       ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):URT6 of 32bit */
#define EXIC_SRC5_ID22_urt6_h1                      ((uint16_t)0x0004)      /*!< Bit Value =(0x4):URT6 of 16bit */
#define EXIC_SRC5_ID22_urt6_b2                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):URT6 of 8bit */
#define EXIC_SRC5_ID22_urt7_w                       ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):URT7 of 32bit */
#define EXIC_SRC5_ID22_urt7_h1                      ((uint16_t)0x0008)      /*!< Bit Value =(0x8):URT7 of 16bit */
#define EXIC_SRC5_ID22_urt7_b2                      ((uint8_t )0x08)        /*!< Bit Value =(0x8):URT7 of 8bit */

#define EXIC_SRC5_ID21_mask_w                       ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC5_ID21_mask_h0                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC5_ID21_mask_b1                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC5_ID21_urt1_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):URT1 of 32bit */
#define EXIC_SRC5_ID21_urt1_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):URT1 of 16bit */
#define EXIC_SRC5_ID21_urt1_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):URT1 of 8bit */
#define EXIC_SRC5_ID21_urt2_w                       ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):URT2 of 32bit */
#define EXIC_SRC5_ID21_urt2_h0                      ((uint16_t)0x0200)      /*!< Bit Value =(0x2):URT2 of 16bit */
#define EXIC_SRC5_ID21_urt2_b1                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):URT2 of 8bit */

#define EXIC_SRC5_ID20_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC5_ID20_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC5_ID20_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC5_ID20_urt0_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):URT0 of 32bit */
#define EXIC_SRC5_ID20_urt0_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):URT0 of 16bit */
#define EXIC_SRC5_ID20_urt0_b0                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):URT0 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC6  [register's definitions]
 *              Offset[0x78]  EXIC interrupt source identity register 6 (0x50000078)
 ******************************************************************************
 */
///@{
#define EXIC_SRC6_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC6 */
#define EXIC_SRC6_ID27_mask_w                       ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC6_ID27_mask_h1                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC6_ID27_mask_b3                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC6_ID27_can0_w                       ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):CAN0 of 32bit */
#define EXIC_SRC6_ID27_can0_h1                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CAN0 of 16bit */
#define EXIC_SRC6_ID27_can0_b3                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):CAN0 of 8bit */

#define EXIC_SRC6_ID26_mask_w                       ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC6_ID26_mask_h1                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC6_ID26_mask_b2                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC6_ID25_mask_w                       ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC6_ID25_mask_h0                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC6_ID25_mask_b1                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC6_ID24_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC6_ID24_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC6_ID24_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC6_ID24_spi0_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):SPI0 of 32bit */
#define EXIC_SRC6_ID24_spi0_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):SPI0 of 16bit */
#define EXIC_SRC6_ID24_spi0_b0                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):SPI0 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC7  [register's definitions]
 *              Offset[0x7C]  EXIC interrupt source identity register 7 (0x5000007C)
 ******************************************************************************
 */
///@{
#define EXIC_SRC7_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_SRC7 */
#define EXIC_SRC7_ID31_mask_w                       ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC7_ID31_mask_h1                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC7_ID31_mask_b3                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC7_ID31_apx_w                        ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):APX of 32bit */
#define EXIC_SRC7_ID31_apx_h1                       ((uint16_t)0x0100)      /*!< Bit Value =(0x1):APX of 16bit */
#define EXIC_SRC7_ID31_apx_b3                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):APX of 8bit */

#define EXIC_SRC7_ID30_mask_w                       ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define EXIC_SRC7_ID30_mask_h1                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC7_ID30_mask_b2                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define EXIC_SRC7_ID29_mask_w                       ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define EXIC_SRC7_ID29_mask_h0                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define EXIC_SRC7_ID29_mask_b1                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC7_ID29_i2c1_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):I2C1 of 32bit */
#define EXIC_SRC7_ID29_i2c1_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):I2C1 of 16bit */
#define EXIC_SRC7_ID29_i2c1_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):I2C1 of 8bit */

#define EXIC_SRC7_ID28_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define EXIC_SRC7_ID28_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define EXIC_SRC7_ID28_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define EXIC_SRC7_ID28_i2c0_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):I2C0 of 32bit */
#define EXIC_SRC7_ID28_i2c0_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):I2C0 of 16bit */
#define EXIC_SRC7_ID28_i2c0_b0                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):I2C0 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PE_PF  [register's definitions]
 *              Offset[0x80]  EXIC PE input interrupt pending flag register (0x50000080)
 ******************************************************************************
 */
///@{
#define EXIC_PE_PF_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PE_PF */
#define EXIC_PE_PF_PE15_PF_mask_w                   ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE15_PF_mask_h0                  ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE15_PF_mask_b1                  ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE15_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE15_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE15_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE15_PF_happened_w               ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE15_PF_happened_h0              ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE15_PF_happened_b1              ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE14_PF_mask_w                   ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE14_PF_mask_h0                  ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE14_PF_mask_b1                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE14_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE14_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE14_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE14_PF_happened_w               ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE14_PF_happened_h0              ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE14_PF_happened_b1              ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE13_PF_mask_w                   ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE13_PF_mask_h0                  ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE13_PF_mask_b1                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE13_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE13_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE13_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE13_PF_happened_w               ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE13_PF_happened_h0              ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE13_PF_happened_b1              ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE12_PF_mask_w                   ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE12_PF_mask_h0                  ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE12_PF_mask_b1                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE12_PF_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE12_PF_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE12_PF_normal_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE12_PF_happened_w               ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE12_PF_happened_h0              ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE12_PF_happened_b1              ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE9_PF_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE9_PF_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE9_PF_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE9_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE9_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE9_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE9_PF_happened_w                ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE9_PF_happened_h0               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE9_PF_happened_b1               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE8_PF_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE8_PF_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE8_PF_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE8_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE8_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE8_PF_normal_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE8_PF_happened_w                ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE8_PF_happened_h0               ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE8_PF_happened_b1               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE3_PF_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE3_PF_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE3_PF_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE3_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE3_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE3_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE3_PF_happened_w                ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE3_PF_happened_h0               ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE3_PF_happened_b0               ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE2_PF_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE2_PF_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE2_PF_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE2_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE2_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE2_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE2_PF_happened_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE2_PF_happened_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE2_PF_happened_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE1_PF_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE1_PF_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE1_PF_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE1_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE1_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE1_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE1_PF_happened_w                ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE1_PF_happened_h0               ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE1_PF_happened_b0               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EXIC_PE_PF_PE0_PF_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PE_PF_PE0_PF_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PE_PF_PE0_PF_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PE_PF_PE0_PF_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EXIC_PE_PF_PE0_PF_normal_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EXIC_PE_PF_PE0_PF_normal_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EXIC_PE_PF_PE0_PF_happened_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define EXIC_PE_PF_PE0_PF_happened_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define EXIC_PE_PF_PE0_PF_happened_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PE_TRGS  [register's definitions]
 *              Offset[0x84]  EXIC PE Pad input trigger select register (0x50000084)
 ******************************************************************************
 */
///@{
#define EXIC_PE_TRGS_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PE_TRGS */
#define EXIC_PE_TRGS_PE15_TRGS_mask_w               ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE15_TRGS_mask_h1              ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE15_TRGS_mask_b3              ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE15_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE15_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE15_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE15_TRGS_level_w              ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE15_TRGS_level_h1             ((uint16_t)0x4000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE15_TRGS_level_b3             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE15_TRGS_edge_w               ((uint32_t)0x80000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE15_TRGS_edge_h1              ((uint16_t)0x8000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE15_TRGS_edge_b3              ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE15_TRGS_dual_edge_w          ((uint32_t)0xC0000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE15_TRGS_dual_edge_h1         ((uint16_t)0xC000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE15_TRGS_dual_edge_b3         ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE14_TRGS_mask_w               ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE14_TRGS_mask_h1              ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE14_TRGS_mask_b3              ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE14_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE14_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE14_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE14_TRGS_level_w              ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE14_TRGS_level_h1             ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE14_TRGS_level_b3             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE14_TRGS_edge_w               ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE14_TRGS_edge_h1              ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE14_TRGS_edge_b3              ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE14_TRGS_dual_edge_w          ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE14_TRGS_dual_edge_h1         ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE14_TRGS_dual_edge_b3         ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE13_TRGS_mask_w               ((uint32_t)0x0C000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE13_TRGS_mask_h1              ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE13_TRGS_mask_b3              ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE13_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE13_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE13_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE13_TRGS_level_w              ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE13_TRGS_level_h1             ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE13_TRGS_level_b3             ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE13_TRGS_edge_w               ((uint32_t)0x08000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE13_TRGS_edge_h1              ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE13_TRGS_edge_b3              ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE13_TRGS_dual_edge_w          ((uint32_t)0x0C000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE13_TRGS_dual_edge_h1         ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE13_TRGS_dual_edge_b3         ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE12_TRGS_mask_w               ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE12_TRGS_mask_h1              ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE12_TRGS_mask_b3              ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE12_TRGS_no_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE12_TRGS_no_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE12_TRGS_no_b3                ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE12_TRGS_level_w              ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE12_TRGS_level_h1             ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE12_TRGS_level_b3             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE12_TRGS_edge_w               ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE12_TRGS_edge_h1              ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE12_TRGS_edge_b3              ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE12_TRGS_dual_edge_w          ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE12_TRGS_dual_edge_h1         ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE12_TRGS_dual_edge_b3         ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE9_TRGS_mask_w                ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE9_TRGS_mask_h1               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE9_TRGS_mask_b2               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE9_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE9_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE9_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE9_TRGS_level_w               ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE9_TRGS_level_h1              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE9_TRGS_level_b2              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE9_TRGS_edge_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE9_TRGS_edge_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE9_TRGS_edge_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE9_TRGS_dual_edge_w           ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE9_TRGS_dual_edge_h1          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE9_TRGS_dual_edge_b2          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE8_TRGS_mask_w                ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE8_TRGS_mask_h1               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE8_TRGS_mask_b2               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE8_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE8_TRGS_no_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE8_TRGS_no_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE8_TRGS_level_w               ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE8_TRGS_level_h1              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE8_TRGS_level_b2              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE8_TRGS_edge_w                ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE8_TRGS_edge_h1               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE8_TRGS_edge_b2               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE8_TRGS_dual_edge_w           ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE8_TRGS_dual_edge_h1          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE8_TRGS_dual_edge_b2          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE3_TRGS_mask_w                ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE3_TRGS_mask_h0               ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE3_TRGS_mask_b0               ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE3_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE3_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE3_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE3_TRGS_level_w               ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE3_TRGS_level_h0              ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE3_TRGS_level_b0              ((uint8_t )0x40)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE3_TRGS_edge_w                ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE3_TRGS_edge_h0               ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE3_TRGS_edge_b0               ((uint8_t )0x80)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE3_TRGS_dual_edge_w           ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE3_TRGS_dual_edge_h0          ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE3_TRGS_dual_edge_b0          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE2_TRGS_mask_w                ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE2_TRGS_mask_h0               ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE2_TRGS_mask_b0               ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE2_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE2_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE2_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE2_TRGS_level_w               ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE2_TRGS_level_h0              ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE2_TRGS_level_b0              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE2_TRGS_edge_w                ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE2_TRGS_edge_h0               ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE2_TRGS_edge_b0               ((uint8_t )0x20)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE2_TRGS_dual_edge_w           ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE2_TRGS_dual_edge_h0          ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE2_TRGS_dual_edge_b0          ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE1_TRGS_mask_w                ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE1_TRGS_mask_h0               ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE1_TRGS_mask_b0               ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE1_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE1_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE1_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE1_TRGS_level_w               ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE1_TRGS_level_h0              ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE1_TRGS_level_b0              ((uint8_t )0x04)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE1_TRGS_edge_w                ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE1_TRGS_edge_h0               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE1_TRGS_edge_b0               ((uint8_t )0x08)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE1_TRGS_dual_edge_w           ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE1_TRGS_dual_edge_h0          ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE1_TRGS_dual_edge_b0          ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define EXIC_PE_TRGS_PE0_TRGS_mask_w                ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define EXIC_PE_TRGS_PE0_TRGS_mask_h0               ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EXIC_PE_TRGS_PE0_TRGS_mask_b0               ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EXIC_PE_TRGS_PE0_TRGS_no_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EXIC_PE_TRGS_PE0_TRGS_no_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EXIC_PE_TRGS_PE0_TRGS_no_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EXIC_PE_TRGS_PE0_TRGS_level_w               ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Level of 32bit */
#define EXIC_PE_TRGS_PE0_TRGS_level_h0              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level of 16bit */
#define EXIC_PE_TRGS_PE0_TRGS_level_b0              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level of 8bit */
#define EXIC_PE_TRGS_PE0_TRGS_edge_w                ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Edge of 32bit */
#define EXIC_PE_TRGS_PE0_TRGS_edge_h0               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Edge of 16bit */
#define EXIC_PE_TRGS_PE0_TRGS_edge_b0               ((uint8_t )0x02)        /*!< Bit Value =(0x2):Edge of 8bit */
#define EXIC_PE_TRGS_PE0_TRGS_dual_edge_w           ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define EXIC_PE_TRGS_PE0_TRGS_dual_edge_h0          ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define EXIC_PE_TRGS_PE0_TRGS_dual_edge_b0          ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EXIC_PE_MSK  [register's definitions]
 *              Offset[0x88]  EXIC  PE AOI Mask register (0x50000088)
 ******************************************************************************
 */
///@{
#define EXIC_PE_MSK_default                         ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EXIC_PE_MSK */
#define EXIC_PE_MSK_PE15_AM_mask_w                  ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE15_AM_mask_h1                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE15_AM_mask_b3                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE15_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE15_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE15_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE15_AM_enable_w                ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE15_AM_enable_h1               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE15_AM_enable_b3               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE14_AM_mask_w                  ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE14_AM_mask_h1                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE14_AM_mask_b3                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE14_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE14_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE14_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE14_AM_enable_w                ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE14_AM_enable_h1               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE14_AM_enable_b3               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE13_AM_mask_w                  ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE13_AM_mask_h1                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE13_AM_mask_b3                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE13_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE13_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE13_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE13_AM_enable_w                ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE13_AM_enable_h1               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE13_AM_enable_b3               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE12_AM_mask_w                  ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE12_AM_mask_h1                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE12_AM_mask_b3                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE12_AM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE12_AM_disable_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE12_AM_disable_b3              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE12_AM_enable_w                ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE12_AM_enable_h1               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE12_AM_enable_b3               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE9_AM_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE9_AM_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE9_AM_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE9_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE9_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE9_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE9_AM_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE9_AM_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE9_AM_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE8_AM_mask_w                   ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE8_AM_mask_h1                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE8_AM_mask_b3                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE8_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE8_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE8_AM_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE8_AM_enable_w                 ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE8_AM_enable_h1                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE8_AM_enable_b3                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE3_AM_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE3_AM_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE3_AM_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE3_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE3_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE3_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE3_AM_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE3_AM_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE3_AM_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE2_AM_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE2_AM_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE2_AM_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE2_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE2_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE2_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE2_AM_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE2_AM_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE2_AM_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE1_AM_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE1_AM_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE1_AM_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE1_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE1_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE1_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE1_AM_enable_w                 ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE1_AM_enable_h1                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE1_AM_enable_b2                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE0_AM_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE0_AM_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE0_AM_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE0_AM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE0_AM_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE0_AM_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE0_AM_enable_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE0_AM_enable_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE0_AM_enable_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE15_OM_mask_w                  ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE15_OM_mask_h0                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE15_OM_mask_b1                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE15_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE15_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE15_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE15_OM_enable_w                ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE15_OM_enable_h0               ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE15_OM_enable_b1               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE14_OM_mask_w                  ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE14_OM_mask_h0                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE14_OM_mask_b1                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE14_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE14_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE14_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE14_OM_enable_w                ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE14_OM_enable_h0               ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE14_OM_enable_b1               ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE13_OM_mask_w                  ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE13_OM_mask_h0                 ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE13_OM_mask_b1                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE13_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE13_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE13_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE13_OM_enable_w                ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE13_OM_enable_h0               ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE13_OM_enable_b1               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE12_OM_mask_w                  ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE12_OM_mask_h0                 ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE12_OM_mask_b1                 ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE12_OM_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE12_OM_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE12_OM_disable_b1              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE12_OM_enable_w                ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE12_OM_enable_h0               ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE12_OM_enable_b1               ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE9_OM_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE9_OM_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE9_OM_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE9_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE9_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE9_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE9_OM_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE9_OM_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE9_OM_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE8_OM_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE8_OM_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE8_OM_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE8_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE8_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE8_OM_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE8_OM_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE8_OM_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE8_OM_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE3_OM_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE3_OM_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE3_OM_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE3_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE3_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE3_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE3_OM_enable_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE3_OM_enable_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE3_OM_enable_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE2_OM_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE2_OM_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE2_OM_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE2_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE2_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE2_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE2_OM_enable_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE2_OM_enable_h0                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE2_OM_enable_b0                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE1_OM_mask_w                   ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE1_OM_mask_h0                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE1_OM_mask_b0                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE1_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE1_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE1_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE1_OM_enable_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE1_OM_enable_h0                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE1_OM_enable_b0                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EXIC_PE_MSK_PE0_OM_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EXIC_PE_MSK_PE0_OM_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EXIC_PE_MSK_PE0_OM_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EXIC_PE_MSK_PE0_OM_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EXIC_PE_MSK_PE0_OM_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EXIC_PE_MSK_PE0_OM_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EXIC_PE_MSK_PE0_OM_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EXIC_PE_MSK_PE0_OM_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EXIC_PE_MSK_PE0_OM_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}

#endif  // _MG32_EXIC_H

/*----------------------------------------------------------------------------*/
/*                          End of file MG32_EXIC.h                           */
/*----------------------------------------------------------------------------*/
