
/**
  ******************************************************************************
 *
 * @file        Sample_RTC_WakeupFromSTOPMode.c
 *
 * @brief       RTC sample code
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2025/06/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO_DRV.h"
#include "MG32_CSC_DRV.h"
#include "MG32_RTC_DRV.h"
#include "MG32_SYS_DRV.h"
#include "MG32_PW_DRV.h"
#include "RTE_Components.h"
#if !defined(MG32_SYS_RTC_IRQ_)
    #include "core_cm0.h"
#endif
/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
uint32_t Sample_RTC_WakeupFromSTOPMode(void);
void SYS_IRQHandler(void);
void RTC_IRQ(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
 
 
/**
*******************************************************************************
* @brief  	    Sample RTC WakeupFromSTOPMode
* @details     1. Enable CSC to RTC clock
*      \n      2. Configure RTC clock
*      \n      3. Set RTC timer value
*      \n      4. Update ALM value
*      \n      5. Enable RTC module
*      \n      6. Wait Alarm
*      \n      7. Get RTC timer value
*      \n      8. Disable RTC module
* @return	    None	
* @note        
* @par         Example
* @code
   Sample_RTC_Init();
   // To do ...
   {
   
   }
   STOP();
* @endcode
*******************************************************************************
*/
uint32_t Sample_RTC_WakeupFromSTOPMode(void)
{
    //===CSC Initialize Set Description====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12Mz
    //Select CK_MAIN Source = CK_HS
    //Select CK_LS Source = CK_ILRCO
    //Configure Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->RTC = Enable
    //
    //MG32_GPIO_Init.H(Configuration Wizard)
    //Select GPIO Initial -> GPIOC configuration -> PB8 configuration
    //Select Pin mode = PPO
    //Select Pin alternate function = RTC_OUT
    //Other selection keep default value
    //Initial PC0 to Push-Pull output will toggle at RTC interrupt service routine.

    /*=== 1. Enable CSC to RTC clock ===*/
    UnProtectModuleReg(CSCprotect);                                 // Unprotect CSC module
    CSC_PeriphOnModeClock_Config(CSC_ON_RTC, ENABLE);               // Enable RTC module clock
    CSC_PeriphSTOPModeClock_Config(CSC_STP_RTC, ENABLE);            // Enable RTC module clock in STOP mode
    ProtectModuleReg(CSCprotect);                                   // protect CSC module
    
    /*=== 2. Configuring the RTC clock. ===*/
    UnProtectModuleReg(RTCprotect);                                 // Unprotect RTC module
    RTC_CLK_Select(RTC_CK_APB);                                      // RTC clock source = CK_LS
    RTC_PreDivider_Select(RTC_PDIV_4096);                           // PDIV output = RTC clock / 4096
    RTC_Divider_Select(RTC_DIV_8);                                  // DIV output = (RTC clock / 4096) / 8
    RTC_OutputSignal_Select(RTC_TO);                                // Configuring RTC_OUT output RTC overflow signal.
    
    /*=== 3. Set RTC timer value ===*/
    RTC_RCR_Mode_Select(RTC_RCR_MOD_ForceReload);                   // RTC switch to reload mode
    RTC_SetReloadReg(0xFFFFFF00);                                            // RTC reload register setting
    RTC_TriggerStamp_SW();                                          // Trigger reload data update to RTC timer
    while(RTC_GetSingleFlagStatus(RTC_RCRF) == DRV_UnHappened);     // Waiting reload complete
    RTC_ClearFlag(RTC_ALLF);                                        // Clear flag
    RTC_RCR_Mode_Select(RTC_RCR_MOD_AutoReload);                    // RTC switch to reload mode
    
    /*=== 4. Configuring RTC interrupt ===*/
    #if !defined(MG32_SYS_RTC_IRQ_)
        NVIC_EnableIRQ(SYS_IRQn);
        NVIC_SetPriority(SYS_IRQn,0);
    #endif
    RTC_IT_Config(RTC_INT_TO, ENABLE);                              // Enable RTC overflow interrupt.
    RTC_ITEA_Cmd(ENABLE);                                           // Enable RTC all interrupt
    SYS_ITEA_Cmd(ENABLE);
    
    /*=== 5. Configuring RTC WakeUp ===*/
    RTC_StopModeWakeUpEvent_Config(RTC_TF_WPEN, ENABLE);            // Enable RTC Wakeup in STOP mode.
    UnProtectModuleReg(PWprotect);                                 // Protect PW module
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_RTC, ENABLE);           // Enable RTC module wake up in STOP mode.
    UnProtectModuleReg(PWprotect);                                 // Protect PW module

    /*=== 6. Enable RTC module ===*/
    RTC_Cmd (ENABLE);                                               // Enable RTC module
    
    UnProtectModuleReg(RTCprotect);                                 // Unprotect RTC module
    //Configuring chip into STOP mode.
    STOP_WFI();                                                         // Chip Working at STOP mode.
    return DRV_Completed;
}

/**
*******************************************************************************
* @brief       RTC interrupt sevice routine Handler
* @details     1. Clear RTC all event flag
*      \n      2. Toggle GPIOC (PC0).
* @return      None
* @note        
* @par         Example
* @code
   RTC_IRQ();
* @endcode
*******************************************************************************
*/
#if !defined(MG32_IRQ_Handler_)
void SYS_IRQHandler(void)
{
    #if defined(MG32_SYS_RTC_IRQ_)
        RTC_IRQ();
    #endif
}
#endif
/**
*******************************************************************************
* @brief       RTC interrupt sevice routine
* @details     1. Clear RTC all event flag
*      \n      2. Toggle GPIOC (PC0).
* @return      None
* @note        
* @par         Example
* @code
   RTC_IRQ();
* @endcode
*******************************************************************************
*/
void RTC_IRQ(void)
{
    RTC_ClearFlag(RTC_ALLF);                                        // Clear flag
    PC0 =~ PC0;                                                     // IO Toggle
}



