

/**
 ******************************************************************************
 *
 * @file        BSP_RotaryEncoder.h
 * @brief       This is Rotary Encoder H file.
 
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2021/05/17
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _BSP_9_ROTARYENCODER_H

#define _BSP_9_ROTARYENCODER_H


#include "MG32_GPIO_DRV.h"
#include "MG32_TM_DRV.h"


/**
 * @name define
 *   		
 */ 
///@{

//Change flag mask
#define ROTARY_CHANGEFLAG_NONE     0x00
#define ROTARY_CHANGEFLAG_BUTTON   0x01
#define ROTARY_CHANGEFLAG_ENCODE   0x02

///@}

/** 
 * @name  typedef
 */                                                      
///@{


/*! @struct RotaryCTR_TypeDef
    @brief  Rotary control struct
*/ 
typedef struct  __attribute__((packed))
{
    uint8_t ChangeFlag;           /*!<Rotary encoder status change flag.*/
    uint8_t SWButton_Status;      /*!<Button status.*/
    int32_t Encoder_Status;       /*!<Encoder status.*/
    
}RotaryCTR_TypeDef;

///@}

/** 
 * @name  variables
 */                                                      
///@{
extern RotaryCTR_TypeDef Rotary_CTR;

///@}


/**
 * @name function
 *   		
 */ 
///@{
void BSP_RotaryEncoder_Init(void);
void BSP_RotaryEncoder_main(void);

///}

#endif









