/**
 ******************************************************************************
 *
 * @file        BSP_TemperatureSensor.c
 * @brief       
 
 * @par         Project
 *              MG32F02N128
 * @version     V1.01
 * @date        2024/09/24
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "BSP_TemperatureSensor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define TEMP_ADC                 ADC0

#define TEMP_ADC_SMPTIME         20
#define TEMP_ADC_OPERATION_TIME  16
#define TEMP_ADC_OPERATION_START 2
#define TEMP_ADC_OPERATION_END   (TEMP_ADC_OPERATION_START + TEMP_ADC_OPERATION_TIME)

//Device #1
// Temperature=20(C), The ADC converts the TSO then get this conversion data.
#define ADC_T20_TSOValue      (1344)

// Temperature=60(C), The ADC converts the TSO then get this conversion data.
#define ADC_T60_TSOValue      (1509)

//Device #2
//// Temperature=20(C), The ADC converts the TSO then get this conversion data.
//#define ADC_T20_TSOValue      (1353)

//// Temperature=60(C), The ADC converts the TSO then get this conversion data.
//#define ADC_T60_TSOValue      (1518)

//Device #3
//// Temperature=20(C), The ADC converts the TSO then get this conversion data.
//#define ADC_T20_TSOValue      (1316)

//// Temperature=60(C), The ADC converts the TSO then get this conversion data.
//#define ADC_T60_TSOValue      (1481)

//Device #4
//// Temperature=20(C), The ADC converts the TSO then get this conversion data.
//#define ADC_T20_TSOValue      (1358)

//// Temperature=60(C), The ADC converts the TSO then get this conversion data.
//#define ADC_T60_TSOValue      (1523)

#define T60_T20_Gap           (60 - 20)
#define T60_T20_ADCGap        (ADC_T60_TSOValue - ADC_T20_TSOValue)
#define T60_T20_DegreeGap     (T60_T20_ADCGap / 40)

/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static int16_t  BSP_TempBuf[TEMP_ADC_SMPTIME];
static uint8_t  BSP_Temp_SampleCount;
static int16_t  BSP_TempCelsius_degree;

/* Private function ----------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       Temperature sensor initial
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_TemperatureSensor_Init(void)
{
//    ADC_InitTypeDef ADC_Base;
//
//    /*ADC Default Initial.*/
//    ADC_DeInit(TEMP_ADC);
//
//    ADC_BaseStructure_Init(&ADC_Base);
//
//    ADC_Base.ADCMainClockSelect   = ADC_CKADC; 
//    ADC_Base.ADC_IntCK_Div        = ADC_IntDIV2;
//    ADC_Base.ADC_CKPLL_Div        = ADC_PLLDIV6;
//    ADC_Base.ADC_DataAlign        = ADC_RightJustified;
//    ADC_Base.ADC_ResolutionSel    = ADC_12BitData;
//    ADC_Base.ADC_DataOverrunEvent = ADC_DataOverWritten;
//
//    ADC_Base_Init(TEMP_ADC, &ADC_Base);
//
//    ADC_WaitDataReadOut(TEMP_ADC, DISABLE);
//    ADC_Cmd(TEMP_ADC, ENABLE);
//    ADC_SampleClockPhase_Select(TEMP_ADC, ADC_CK_PHASE0);
//
//    //Disable PGA
//    ADC_PGA_Cmd(TEMP_ADC, DISABLE);
//    ADC_SetPGAGain(TEMP_ADC,0);
//
//    //
//    ADC_TriggerSource_Select(TEMP_ADC, ADC_START);
//    ADC_TriggerEdge_Select(TEMP_ADC, ADC_DisableTrg);
//    ADC_ConversionMode_Select(TEMP_ADC, ADCMode);
//    ADC_ContinueMode_Cmd(TEMP_ADC, DISABLE);
//    ADC_MainConversionMode_Select(TEMP_ADC, ADC_OneShot);
//
//    ADC_SetExtendSampling(TEMP_ADC, 30);
//
//    ADC_SetConversionTime(TEMP_ADC, ADC_FastCONV);
//    ADC_SetOperationCurrent(TEMP_ADC, ADC_BIAS_LVL3);
//    ADC_SampleClockPhase_Select(TEMP_ADC, ADC_CK_PHASE2);
//
//    ADC_SingleDifferentMode_Select(TEMP_ADC, ADC_SingleMode);
//    ADC_SetOutputCodeFormat(TEMP_ADC, ADC_UnsignedFormat);
//
//    //ADC calibration
//    ADC_StartCalibration(TEMP_ADC, ENABLE);

    /**/
    ADC_TSO_Cmd(TEMP_ADC, ENABLE);
    ADC_IVR24_Cmd(TEMP_ADC, DISABLE);
    ADC_TSOVref_Select(TEMP_ADC, ADC_IVR24);
    ADC_InternalChannel_Select(TEMP_ADC, ADC_INT_TSO); 
    ADC_ClearFlag(TEMP_ADC,ADC_E1CNVF);
    ADC_ChannelMUX_Select(TEMP_ADC,ADC_InternalChannel);
    ADC_SoftwareConversion_Cmd(TEMP_ADC, ENABLE);
    while(ADC_GetSingleFlagStatus(TEMP_ADC, ADC_E1CNVF) == DRV_UnHappened);
    ADC_ClearFlag(TEMP_ADC, ADC_E1CNVF);

    /*Parameter initial*/
    BSP_Temp_SampleCount = 0;
    BSP_TempCelsius_degree = 0;
}

/**
 *******************************************************************************
 * @brief       Trigger ADC conversion( internal channel(TSO : Temperature
 *              sensor output voltage))
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_TemperatureSensor_Trigger(void)
{
    ADC_ClearFlag(TEMP_ADC, ADC_E1CNVF);
    ADC_ChannelMUX_Select(TEMP_ADC, ADC_InternalChannel);
    ADC_InternalChannel_Select(TEMP_ADC, ADC_INT_TSO); 
    ADC_SoftwareConversion_Cmd(TEMP_ADC, ENABLE);
}

/**
 *******************************************************************************
 * @brief       Trigger ADC conversion(internal channel(VSSA))
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_TemperatureSensor_DischargeTrigger(void)
{
    ADC_ClearFlag(TEMP_ADC, ADC_E1CNVF);
    ADC_ChannelMUX_Select(TEMP_ADC, ADC_InternalChannel);
    ADC_InternalChannel_Select(TEMP_ADC, ADC_INT_VSSA); 
    ADC_SoftwareConversion_Cmd(TEMP_ADC, ENABLE);
}

/**
 *******************************************************************************
 * @brief       Temperature Sensor handler after get new ADC value
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_TemperatureSensor_Handler(void)
{
    int16_t  BSP_TempHandler_ADCData;
    uint8_t  BSP_TempHandler_Tmp;
    uint8_t  BSP_TempHandler_Tmp2;
    int32_t  BSP_TempHandler_Value;
    int32_t  BSP_TempCelsius_degreeTmp;

    /*Check ADC conversion whether complete or not.*/
    if((ADC_GetAllFlagStatus(TEMP_ADC)&ADC_STA_E1CNVF_happened_w) == 0) 
    {
        return;
    }

    if( BSP_Temp_SampleCount == TEMP_ADC_SMPTIME)
    {
        BSP_Temp_SampleCount  = 0;
        BSP_TempHandler_Value = 0;

        for( BSP_TempHandler_Tmp = TEMP_ADC_OPERATION_START; BSP_TempHandler_Tmp < TEMP_ADC_OPERATION_END; BSP_TempHandler_Tmp ++)
        {
            BSP_TempHandler_Value += BSP_TempBuf[BSP_TempHandler_Tmp];
        }

        BSP_TempHandler_Value     = (BSP_TempHandler_Value >> 4);
        BSP_TempHandler_Value     = BSP_TempHandler_Value - ADC_T20_TSOValue;           
        BSP_TempCelsius_degreeTmp = (BSP_TempHandler_Value * 40) + (T60_T20_ADCGap * 20);
        BSP_TempCelsius_degreeTmp = BSP_TempCelsius_degreeTmp / T60_T20_ADCGap;

        /*Variable resistor change*/
        BSP_TempCelsius_degree = (int16_t)BSP_TempCelsius_degreeTmp;
        BSP_TemperatureSensor_CpltCallback();
    }
    else
    {
        BSP_TempHandler_ADCData = ADC_GetDAT0Data(TEMP_ADC);

        if( BSP_Temp_SampleCount == 0)
        {
            BSP_TempBuf[0] = BSP_TempHandler_ADCData;
        }
        else
        {
            for(BSP_TempHandler_Tmp = 0; BSP_TempHandler_Tmp < BSP_Temp_SampleCount; BSP_TempHandler_Tmp ++)
            {
                if( BSP_TempBuf[BSP_TempHandler_Tmp] > BSP_TempHandler_ADCData)
                {
                    for( BSP_TempHandler_Tmp2 = BSP_Temp_SampleCount; BSP_TempHandler_Tmp2 > BSP_TempHandler_Tmp; BSP_TempHandler_Tmp2 --)
                    {
                        BSP_TempBuf[BSP_TempHandler_Tmp2] = BSP_TempBuf[(BSP_TempHandler_Tmp2 - 1)];
                    }
                    BSP_TempBuf[BSP_TempHandler_Tmp] = BSP_TempHandler_ADCData;
                    break;
                }
                else if( BSP_TempHandler_Tmp == (BSP_Temp_SampleCount - 1))
                {
                    BSP_TempBuf[(BSP_TempHandler_Tmp + 1)] = BSP_TempHandler_ADCData;
                }
            }
        }
        BSP_Temp_SampleCount ++;
    }

    ADC_ClearFlag(TEMP_ADC, ADC_E1CNVF);  
}

/**
 *******************************************************************************
 * @brief       Skip this ADC data.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_TemperatureSensor_SkipADCData(void)
{
    ADC_ClearFlag(TEMP_ADC, ADC_E1CNVF); 
}

/**
 *******************************************************************************
 * @brief       Get degree value.
 * @details     
 * @return      Now degree value.
 * @exception   No
 * @note        No
 *******************************************************************************
 */
int16_t BSP_TemperatureSensor_GetDegree(void)
{
    return(BSP_TempCelsius_degree);
}

/**
 *******************************************************************************
 * @brief       Degree value upadte callback function.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
__WEAK void BSP_TemperatureSensor_CpltCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the callback
    //       is needed, the BSP_TemperatureSensor_CpltCallback can
    //       be implemented in the user file.
}

