
/**
 ******************************************************************************
 *
 * @file        LEDBreathing_SW.H
 *
 * @brief       This file provides firmware functions to manage the following 
 *              functionalities of the LED breathing function:
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 


#ifndef _LCDDEMO_RGBLED_API_H

/*!< _LCDDEMO_RGBLED_API_H */ 
#define _LCDDEMO_RGBLED_API_H


/* Includes ------------------------------------------------------------------*/
#include "MG32_GPIO.h" 

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define LED_OFF               1
#define LED_ON                0

#define LED_PWM_MAX           255                       /*!< Define PWM max level*/


#define LED_CTR_LEN           11
   #define LED_MODE           0
   #define LED_MAIN_STEP      1
   #define LED_MAIN_STEP_CMP  2
   #define LED_SUB_STEP       3
   #define LED_SUB_STEP_CMP   4
   #define LED_TEMPO_CNT      5
   #define LED_TEMPO_CNT_CMP  6
   #define LED_PWM_CNT        7
   #define LED1_PWM_CMP       8
   #define LED2_PWM_CMP       9    
   #define LED3_PWM_CMP       10
   



#if defined(MG32_2ND)
    #define LED1_PINSET       PIND(8)                   /*!< To define register of LED2 pin control*/
    #define LED2_PINSET       PIND(9)                   /*!< To define register of LED2 pin control*/
    #define LED3_PINSET       PIND(10)                  /*!< To define register of LED2 pin control*/
                    
    #define LED1_PIN          PD8                       /*!< Define LED1 PIN*/
    #define LED2_PIN          PD9                       /*!< Define LED2 PIN*/
    #define LED3_PIN          PD10                      /*!< Define LED3 PIN*/                                                        
    
    #define LED123_OFF        GPIOD->SC.H[0] = (PX_Pin_8|PX_Pin_9|PX_Pin_10)
#endif
#if defined(MG32_1ST) || defined(MG32_3RD)  
    #define LED1_PINSET       PINE(13)                  /*!< To define register of LED1 pin control*/
    #define LED2_PINSET       PINE(14)                  /*!< To define register of LED2 pin control*/
    #define LED3_PINSET       PINE(15)                  /*!< To define register of LED1 pin control*/
                
    #define LED1_PIN          PE13                      /*!< Define LED1 PIN*/
    #define LED2_PIN          PE14                      /*!< Define LED2 PIN*/
    #define LED3_PIN          PE15                      /*!< Define LED3 PIN*/
        
    #define LED123_OFF        GPIOE->SC.H[0] = (PX_Pin_13|PX_Pin_14|PX_Pin_15)
#endif



#define LED1_SET_PWM(__HANDLE__)  LED_CTR[LED1_PWM_CMP]  = (__HANDLE__) /*!< Set LED1 PWM . */
#define LED2_SET_PWM(__HANDLE__)  LED_CTR[LED2_PWM_CMP]  = (__HANDLE__) /*!< Set LED2 PWM . */
#define LED3_SET_PWM(__HANDLE__)  LED_CTR[LED3_PWM_CMP]  = (__HANDLE__) /*!< Set LED3 PWM . */

#define LED123_MODE               LED_CTR[LED_MODE]
     #define LED123_MODE_POWERON  0
     #define LED123_MODE_NORAML   1
#define LED123_TEMP_CNT           LED_CTR[LED_TEMPO_CNT]
#define LED123_TEMP_CNT_CMP       LED_CTR[LED_TEMPO_CNT_CMP]
#define LED123_MAIN_STEP          LED_CTR[LED_MAIN_STEP]
#define LED123_MAIN_STEP_CMP      LED_CTR[LED_MAIN_STEP_CMP]
#define LED123_SUB_STEP           LED_CTR[LED_SUB_STEP]
#define LED123_SUB_STEP_CMP       LED_CTR[LED_SUB_STEP_CMP]
#define LED123_PWM_CNT            LED_CTR[LED_PWM_CNT]

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
///@{
void LEDBreathing_Init(void);
void LEDBreathing_main(void);
///@}

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


#endif






