/**
 ******************************************************************************
 *
 * @file        MG32_CSC.h
 *
 * @brief       MG32 CSC Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_CSC_H
#define _MG32_CSC_H
#define _MG32_CSC_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_CSC_H_VER)
    #error "_MG32_CSC_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      CSC_Struct
 *              CSC  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  PLL_LOCKF     :1;     //[0] 
            __IO uint8_t  XOSCF         :1;     //[1] XOSC clock stable and ready detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  ILRCOF        :1;     //[4] ILRCO clock stable and ready detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  IHRCOF        :1;     //[5] IHRCO clock stable and ready detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PLLF          :1;     //[6] PLL clock stable and ready detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  MCDF          :1;     //[7] XOSC missing clock detect failure event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  HS2_STA       :4;     //[11..8] Input high speed clock source-2 select MUX switching status
                                        //0x0 = Switching : MUX is switching and clock is not yet stable
                                        //0x1 = IHRCO
                                        //0x2 = XOSC
                                        //0x4 = Reserved
                                        //0x8 = CK_EXT
            __I  uint8_t  PLLI_STA      :2;     //[13..12] PLL input clock source select MUX switching status
                                        //0x0 = Switching : MUX is switching and clock is not yet stable
                                        //0x1 = CK_HS
                                        //0x2 = CK_HS2
            __I  uint8_t                :2;     //[15..14] 
            __I  uint8_t  LS_STA        :4;     //[19..16] Input low speed clock source select MUX switching status
                                        //0x0 = Switching : MUX is switching and clock is not yet stable
                                        //0x2 = XOSC
                                        //0x4 = ILRCO
                                        //0x8 = CK_EXT
            __I  uint8_t  HS_STA        :4;     //[23..20] Input high speed clock source select MUX switching status
                                        //0x0 = Switching : MUX is switching and clock is not yet stable
                                        //0x1 = IHRCO
                                        //0x2 = XOSC
                                        //0x4 = ILRCO
                                        //0x8 = CK_EXT
            __I  uint8_t  MAIN_STA      :3;     //[26..24] System main clock source select MUX switching status
                                        //0x0 = Switching : MUX is switching and clock is not yet stable 
                                        //0x1 = CK_HS : MUX has switched and clock is ready
                                        //0x2 = CK_PLLI : MUX has switched and clock is ready
                                        //0x4 = CK_PLLO : MUX has switched and clock is ready
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t  XOSC_STA      :1;     //[28] XOSC clock stable and ready status after XOSC enabled.
                                        //0 = Unready
                                        //1 = Ready
            __I  uint8_t  ILRCO_STA     :1;     //[29] ILRCO clock stable and ready status after ILRCO enabled.
                                        //0 = Unready
                                        //1 = Ready
            __I  uint8_t  IHRCO_STA     :1;     //[30] IHRCO clock stable and ready status after IHRCO enabled.
                                        //0 = Unready
                                        //1 = Ready
            __I  uint8_t  PLL_STA       :1;     //[31] PLL clock stable and ready status after PLL enabled.
                                        //0 = Unready
                                        //1 = Ready
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  CSC status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] CSC interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  XOSC_IE       :1;     //[1] XOSC clock stable interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  ILRCO_IE      :1;     //[4] ILRCO clock stable interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IHRCO_IE      :1;     //[5] IHRCO clock stable interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PLL_IE        :1;     //[6] PLL clock stable interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MCD_IE        :1;     //[7] XOSC missing clock detect failure event interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  CSC interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PLL_MDS       :1;     //[0] CSC PLL multiplication mode select.
                                        //0 = MUL : Use CSC_PLL_MUL as PLL multiplication value
                                        //1 = MULX : Use CSC_PLL_MULX as PLL multiplication value
            __IO uint8_t  PLLI_SEL      :1;     //[1] CSC PLL input clock source select.
                                        //0 = CK_HS
                                        //1 = CK_HS2
            __IO uint8_t  PLL_LDEN      :1;     //[2] 
            __I  uint8_t                :4;     //[6..3] 
            __IO uint8_t  PLL_VCOS      :1;     //[7] 
            __IO uint8_t  PLL_MUL       :1;     //[8] CSC PLL multiplication factor select. These bits are no effect when CSC_PLL_MDS=1.
                                        //0 = 16 : PLL input clock x 16
                                        //1 = 24 : PLL input clock x 24
            __IO uint8_t  PLL_MULX      :6;     //[14..9] CSC PLL multiplication value
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  XOSC_GN       :2;     //[17..16] Gain control bits of XOSC. (The default value is loaded from CFG OR after Warm reset)
                                        //0x0 = 32K_Normal (for 32KHz crystal)
                                        //0x1 = Medium
                                        //0x2 = 32K_Lowest (for 32KHz crystal)
                                        //0x3 = Reserved
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }PLL;                               /*!< PLL        ~ Offset[0x08]  CSC OSC and PLL control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] CSC key register
                                        //0 = Unprotected
                                        //1 = Protected
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  CSC write protected Key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :3;     //[2..0] 
            __IO uint8_t  IHRCO_EN      :1;     //[3] IHRCO circuit enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MCD_DIS       :1;     //[4] MCD missing clock detector circuit disable.
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  PLL_EN        :1;     //[5] PLL circuit enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  LS_SEL        :2;     //[9..8] Input low speed clock source select
                                        //0x0 = Reserved
                                        //0x1 = XOSC
                                        //0x2 = ILRCO
                                        //0x3 = CK_EXT
            __IO uint8_t  HS_SEL        :2;     //[11..10] Input high speed clock source select
                                        //0x0 = IHRCO
                                        //0x1 = XOSC
                                        //0x2 = ILRCO
                                        //0x3 = CK_EXT
            __IO uint8_t  HS2_SEL       :2;     //[13..12] Input high speed clock-2 source select.
                                        //0x0 = IHRCO
                                        //0x1 = XOSC
                                        //0x2 = Reserved
                                        //0x3 = CK_EXT
            __IO uint8_t  MAIN_SEL      :2;     //[15..14] System main clock source select.
                                        //0x0 = CK_HS
                                        //0x1 = CK_PLLI
                                        //0x2 = CK_PLLO
                                        //0x3 = Reserved
            __IO uint8_t  ST_SEL        :1;     //[16] System tick timer external clock source select.
                                        //0 = HCLK8 : HCLK divided by 8
                                        //1 = CK_LS2 : CK_LS divided by 2
            __I  uint8_t                :1;     //[17] 
            __IO uint8_t  IHRCO_SEL     :1;     //[18] IHRCO clock frequency trimming set select.
                                        //0 = 12 : 12MHz from trimming set 0
                                        //1 = 11 : 11.059MHz from trimming set 1
            __I  uint8_t                :3;     //[21..19] 
            __IO uint8_t  MCD_SEL       :2;     //[23..22] Missing clock detection duration select.
                                        //0x0 = 125us
                                        //0x1 = 250us
                                        //0x2 = 500us
                                        //0x3 = 1ms
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  CSC clock source control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PLLI_DIV      :2;     //[1..0] PLL input clock source divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV6 : divided by 6
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  PLLO_DIV      :2;     //[5..4] PLL output clock source divider
                                        //0x0 = DIV4 : divided by 4
                                        //0x1 = DIV3 : divided by 3
                                        //0x2 = DIV2 : divided by 2
                                        //0x3 = DIV1 : divided by 1
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  AHB_DIV       :4;     //[11..8] AHB clock source divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
                                        //0x4 = DIV16 : divided by 16
                                        //0x5 = DIV32 : divided by 32
                                        //0x6 = DIV64 : divided by 64
                                        //0x7 = DIV128 : divided by 128
                                        //0x8 = DIV256 : divided by 256
                                        //0x9 = DIV512 : divided by 512
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  APB_DIV       :3;     //[18..16] APB clock source divider. Value 0~4 mean to divide by 1,2,4,8,16.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
                                        //0x4 = DIV16 : divided by 16
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  USB_DIV       :2;     //[21..20] USB SIE clock input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV3 : divided by 3
                                        //0x3 = DIV4 : divided by 4
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :1;     //[25] 
            __IO uint8_t  UT_DIV        :2;     //[27..26] Unit time clock source divider.
                                        //0x0 = DIV32 : divided by 32
                                        //0x1 = DIV8 : divided by 8
                                        //0x2 = DIV16 : divided by 16
                                        //0x3 = DIV128 : divided by 128
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }DIV;                               /*!< DIV        ~ Offset[0x14]  CSC clock  divider register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CKO_EN        :1;     //[0] Internal clock output enable. When enables, it will reset the output divider.
                                        //0x0 = Disable
                                        //0x1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  CKO_DIV       :2;     //[3..2] Internal clock output divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __IO uint8_t  CKO_SEL       :3;     //[6..4] Internal clock output source select
                                        //0x0 = CK_MAIN
                                        //0x1 = CK_AHB
                                        //0x2 = CK_APB
                                        //0x3 = CK_HS
                                        //0x4 = CK_LS
                                        //0x5 = CK_XOSC
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CKO;                               /*!< CKO        ~ Offset[0x18]  CSC internal clock output control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IOPA_EN       :1;     //[0] IO Port A clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IOPB_EN       :1;     //[1] IO Port B clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IOPC_EN       :1;     //[2] IO Port C clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IOPD_EN       :1;     //[3] IO Port D clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IOPE_EN       :1;     //[4] IO Port E clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  GPL_EN        :1;     //[8] GPL clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[11..9] 
            __IO uint8_t  EMB_EN        :1;     //[12] External memory bus clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[14..13] 
            __IO uint8_t  DMA_EN        :1;     //[15] DMA clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }AHB;                               /*!< AHB        ~ Offset[0x1C]  CSC AHB clock control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ADC0_EN       :1;     //[0] ADC module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  CMP_EN        :1;     //[2] CMP module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DAC_EN        :1;     //[3] DAC module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  RTC_EN        :1;     //[5] RTC module clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IWDT_EN       :1;     //[6] IWDT module clock source enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WWDT_EN       :1;     //[7] WWDT module clock source enable. (This register is reset only by Cold reset.)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  I2C0_EN       :1;     //[8] I2C0 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  I2C1_EN       :1;     //[9] I2C1 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  SPI0_EN       :1;     //[12] SPI0 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  URT0_EN       :1;     //[16] URT0 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  URT1_EN       :1;     //[17] URT1 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  URT2_EN       :1;     //[18] URT2 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  URT4_EN       :1;     //[20] URT4 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  URT5_EN       :1;     //[21] URT5 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  URT6_EN       :1;     //[22] URT6 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  URT7_EN       :1;     //[23] URT7 UART module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[27..24] 
            __IO uint8_t  USB_EN        :1;     //[28] USB module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  APX_EN        :1;     //[29] APB module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }APB0;                              /*!< APB0       ~ Offset[0x20]  CSC APB clock control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TM00_EN       :1;     //[0] TM00 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TM01_EN       :1;     //[1] TM01 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  TM10_EN       :1;     //[4] TM10 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[6..5] 
            __IO uint8_t  TM16_EN       :1;     //[7] TM16 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TM20_EN       :1;     //[8] TM20 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[10..9] 
            __IO uint8_t  TM26_EN       :1;     //[11] TM26 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[14..12] 
            __IO uint8_t  TM36_EN       :1;     //[15] TM36 module clock source enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }APB1;                              /*!< APB1       ~ Offset[0x24]  CSC APB clock control register 1 */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x28]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SLP_ADC0      :1;     //[0] ADC module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  SLP_CMP       :1;     //[2] CMP module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_DAC       :1;     //[3] DAC module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  SLP_RTC       :1;     //[5] IWDT module clock enable in SLEEP mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_IWDT      :1;     //[6] IWDT module clock enable in SLEEP mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_WWDT      :1;     //[7] WWDT module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_I2C0      :1;     //[8] I2C0 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_I2C1      :1;     //[9] I2C1 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  SLP_SPI0      :1;     //[12] SPI0 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[15..13] 
            __IO uint8_t  SLP_URT0      :1;     //[16] URT0 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_URT1      :1;     //[17] URT1 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_URT2      :1;     //[18] URT2 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  SLP_URT4      :1;     //[20] URT4 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_URT5      :1;     //[21] URT5 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_URT6      :1;     //[22] URT6 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_URT7      :1;     //[23] URT7 UART module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[27..24] 
            __IO uint8_t  SLP_USB       :1;     //[28] USB module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_APX       :1;     //[29] APB module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }SLP0;                              /*!< SLP0       ~ Offset[0x30]  CSC SLEEP mode clock enable register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SLP_TM00      :1;     //[0] TM00 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_TM01      :1;     //[1] TM01 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  SLP_TM10      :1;     //[4] TM10 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[6..5] 
            __IO uint8_t  SLP_TM16      :1;     //[7] TM11 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_TM20      :1;     //[8] TM20 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[10..9] 
            __IO uint8_t  SLP_TM26      :1;     //[11] TM26 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[14..12] 
            __IO uint8_t  SLP_TM36      :1;     //[15] TM36 module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :8;     //[23..16] 
            __IO uint8_t  SLP_SRAM      :1;     //[24] Embedded SRAM memory clock enable in SLEEP mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_FLASH     :1;     //[25] Embedded Flash memory clock enable in SLEEP mode
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[28..26] 
            __IO uint8_t  SLP_DMA       :1;     //[29] DMA module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SLP_EMB       :1;     //[30] EMB module clock enable in SLEEP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }SLP1;                              /*!< SLP1       ~ Offset[0x34]  CSC SLEEP mode clock enable register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  STP_RTC       :1;     //[5] IWDT module clock enable in STOP mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  STP_IWDT      :1;     //[6] IWDT module clock enable in STOP mode
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STP0;                              /*!< STP0       ~ Offset[0x38]  CSC STOP mode clock enable register 0 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x3C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ADC0_CKS      :1;     //[0] ADC0 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :3;     //[3..1] 
            __IO uint8_t  CMP_CKS       :1;     //[4] CMP process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __IO uint8_t  DAC_CKS       :1;     //[5] DAC process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  USB_CKS       :1;     //[8] USB SIE clock source select.
                                        //0 = CK_PLL : PLL clock out
                                        //1 = CK_SYS : CPU System Clock.
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  APX_CKS       :1;     //[10] APB module process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :5;     //[15..11] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CKS0;                              /*!< CKS0       ~ Offset[0x40]  CSC clock source select register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  I2C0_CKS      :1;     //[0] I2C0 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  I2C1_CKS      :1;     //[2] I2C1 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :5;     //[7..3] 
            __IO uint8_t  SPI0_CKS      :1;     //[8] SPI0 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :7;     //[15..9] 
            __IO uint8_t  URT0_CKS      :1;     //[16] URT0 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[17] 
            __IO uint8_t  URT1_CKS      :1;     //[18] URT1 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  URT2_CKS      :1;     //[20] URT2 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[21] 
            __I  uint8_t                :1;     //[22] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  URT4_CKS      :1;     //[24] URT4 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[25] 
            __IO uint8_t  URT5_CKS      :1;     //[26] URT5 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[27] 
            __IO uint8_t  URT6_CKS      :1;     //[28] URT6 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[29] 
            __IO uint8_t  URT7_CKS      :1;     //[30] URT7 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CKS1;                              /*!< CKS1       ~ Offset[0x44]  CSC clock source select register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TM00_CKS      :1;     //[0] TM00 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  TM01_CKS      :1;     //[2] TM01 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :5;     //[7..3] 
            __IO uint8_t  TM10_CKS      :1;     //[8] TM10 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :5;     //[13..9] 
            __IO uint8_t  TM16_CKS      :1;     //[14] TM11 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  TM20_CKS      :1;     //[16] TM20 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :5;     //[21..17] 
            __IO uint8_t  TM26_CKS      :1;     //[22] TM26 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[23] 
            __I  uint8_t                :6;     //[29..24] 
            __IO uint8_t  TM36_CKS      :1;     //[30] TM36 process clock source select.
                                        //0x0 = CK_APB
                                        //0x1 = CK_AHB
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CKS2;                              /*!< CKS2       ~ Offset[0x48]  CSC clock source select register 2 */

} CSC_Struct;

/**
 ******************************************************************************
 *
 * @name        CSC  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CSC_Base                        ((uint32_t)0x4C010000)              /*!< Clock Source Controller */
#define CSC                             ((CSC_Struct*) CSC_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        CSC  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        CSC_STA  [register's definitions]
 *              Offset[0x00]  CSC status register (0x4C010000)
 ******************************************************************************
 */
///@{
#define CSC_STA_default                             ((uint32_t)0x00020000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_STA */
#define CSC_STA_PLL_STA_mask_w                      ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CSC_STA_PLL_STA_mask_h1                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CSC_STA_PLL_STA_mask_b3                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_STA_PLL_STA_unready_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unready of 32bit */
#define CSC_STA_PLL_STA_unready_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Unready of 16bit */
#define CSC_STA_PLL_STA_unready_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Unready of 8bit */
#define CSC_STA_PLL_STA_ready_w                     ((uint32_t)0x80000000)  /*!< Bit Value =(1):Ready of 32bit */
#define CSC_STA_PLL_STA_ready_h1                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Ready of 16bit */
#define CSC_STA_PLL_STA_ready_b3                    ((uint8_t )0x80)        /*!< Bit Value =(1):Ready of 8bit */

#define CSC_STA_IHRCO_STA_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CSC_STA_IHRCO_STA_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CSC_STA_IHRCO_STA_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_STA_IHRCO_STA_unready_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unready of 32bit */
#define CSC_STA_IHRCO_STA_unready_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Unready of 16bit */
#define CSC_STA_IHRCO_STA_unready_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Unready of 8bit */
#define CSC_STA_IHRCO_STA_ready_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(1):Ready of 32bit */
#define CSC_STA_IHRCO_STA_ready_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Ready of 16bit */
#define CSC_STA_IHRCO_STA_ready_b3                  ((uint8_t )0x40)        /*!< Bit Value =(1):Ready of 8bit */

#define CSC_STA_ILRCO_STA_mask_w                    ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CSC_STA_ILRCO_STA_mask_h1                   ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CSC_STA_ILRCO_STA_mask_b3                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_STA_ILRCO_STA_unready_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unready of 32bit */
#define CSC_STA_ILRCO_STA_unready_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Unready of 16bit */
#define CSC_STA_ILRCO_STA_unready_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Unready of 8bit */
#define CSC_STA_ILRCO_STA_ready_w                   ((uint32_t)0x20000000)  /*!< Bit Value =(1):Ready of 32bit */
#define CSC_STA_ILRCO_STA_ready_h1                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Ready of 16bit */
#define CSC_STA_ILRCO_STA_ready_b3                  ((uint8_t )0x20)        /*!< Bit Value =(1):Ready of 8bit */

#define CSC_STA_XOSC_STA_mask_w                     ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CSC_STA_XOSC_STA_mask_h1                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_STA_XOSC_STA_mask_b3                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_STA_XOSC_STA_unready_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unready of 32bit */
#define CSC_STA_XOSC_STA_unready_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Unready of 16bit */
#define CSC_STA_XOSC_STA_unready_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Unready of 8bit */
#define CSC_STA_XOSC_STA_ready_w                    ((uint32_t)0x10000000)  /*!< Bit Value =(1):Ready of 32bit */
#define CSC_STA_XOSC_STA_ready_h1                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Ready of 16bit */
#define CSC_STA_XOSC_STA_ready_b3                   ((uint8_t )0x10)        /*!< Bit Value =(1):Ready of 8bit */

#define CSC_STA_MAIN_STA_mask_w                     ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define CSC_STA_MAIN_STA_mask_h1                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CSC_STA_MAIN_STA_mask_b3                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CSC_STA_MAIN_STA_switching_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Switching of 32bit */
#define CSC_STA_MAIN_STA_switching_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Switching of 16bit */
#define CSC_STA_MAIN_STA_switching_b3               ((uint8_t )0x00)        /*!< Bit Value =(0x0):Switching of 8bit */
#define CSC_STA_MAIN_STA_ck_hs_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):CK_HS of 32bit */
#define CSC_STA_MAIN_STA_ck_hs_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CK_HS of 16bit */
#define CSC_STA_MAIN_STA_ck_hs_b3                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_HS of 8bit */
#define CSC_STA_MAIN_STA_ck_plli_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):CK_PLLI of 32bit */
#define CSC_STA_MAIN_STA_ck_plli_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CK_PLLI of 16bit */
#define CSC_STA_MAIN_STA_ck_plli_b3                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):CK_PLLI of 8bit */
#define CSC_STA_MAIN_STA_ck_pllo_w                  ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):CK_PLLO of 32bit */
#define CSC_STA_MAIN_STA_ck_pllo_h1                 ((uint16_t)0x0400)      /*!< Bit Value =(0x4):CK_PLLO of 16bit */
#define CSC_STA_MAIN_STA_ck_pllo_b3                 ((uint8_t )0x04)        /*!< Bit Value =(0x4):CK_PLLO of 8bit */

#define CSC_STA_HS_STA_mask_w                       ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define CSC_STA_HS_STA_mask_h1                      ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define CSC_STA_HS_STA_mask_b2                      ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define CSC_STA_HS_STA_switching_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Switching of 32bit */
#define CSC_STA_HS_STA_switching_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Switching of 16bit */
#define CSC_STA_HS_STA_switching_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Switching of 8bit */
#define CSC_STA_HS_STA_ihrco_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):IHRCO of 32bit */
#define CSC_STA_HS_STA_ihrco_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):IHRCO of 16bit */
#define CSC_STA_HS_STA_ihrco_b2                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):IHRCO of 8bit */
#define CSC_STA_HS_STA_xosc_w                       ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):XOSC of 32bit */
#define CSC_STA_HS_STA_xosc_h1                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):XOSC of 16bit */
#define CSC_STA_HS_STA_xosc_b2                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):XOSC of 8bit */
#define CSC_STA_HS_STA_ilrco_w                      ((uint32_t)0x00400000)  /*!< Bit Value =(0x4):ILRCO of 32bit */
#define CSC_STA_HS_STA_ilrco_h1                     ((uint16_t)0x0040)      /*!< Bit Value =(0x4):ILRCO of 16bit */
#define CSC_STA_HS_STA_ilrco_b2                     ((uint8_t )0x40)        /*!< Bit Value =(0x4):ILRCO of 8bit */
#define CSC_STA_HS_STA_ck_ext_w                     ((uint32_t)0x00800000)  /*!< Bit Value =(0x8):CK_EXT of 32bit */
#define CSC_STA_HS_STA_ck_ext_h1                    ((uint16_t)0x0080)      /*!< Bit Value =(0x8):CK_EXT of 16bit */
#define CSC_STA_HS_STA_ck_ext_b2                    ((uint8_t )0x80)        /*!< Bit Value =(0x8):CK_EXT of 8bit */

#define CSC_STA_LS_STA_mask_w                       ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define CSC_STA_LS_STA_mask_h1                      ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CSC_STA_LS_STA_mask_b2                      ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CSC_STA_LS_STA_switching_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Switching of 32bit */
#define CSC_STA_LS_STA_switching_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Switching of 16bit */
#define CSC_STA_LS_STA_switching_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Switching of 8bit */
#define CSC_STA_LS_STA_xosc_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):XOSC of 32bit */
#define CSC_STA_LS_STA_xosc_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):XOSC of 16bit */
#define CSC_STA_LS_STA_xosc_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):XOSC of 8bit */
#define CSC_STA_LS_STA_ilrco_w                      ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):ILRCO of 32bit */
#define CSC_STA_LS_STA_ilrco_h1                     ((uint16_t)0x0004)      /*!< Bit Value =(0x4):ILRCO of 16bit */
#define CSC_STA_LS_STA_ilrco_b2                     ((uint8_t )0x04)        /*!< Bit Value =(0x4):ILRCO of 8bit */
#define CSC_STA_LS_STA_ck_ext_w                     ((uint32_t)0x00080000)  /*!< Bit Value =(0x8):CK_EXT of 32bit */
#define CSC_STA_LS_STA_ck_ext_h1                    ((uint16_t)0x0008)      /*!< Bit Value =(0x8):CK_EXT of 16bit */
#define CSC_STA_LS_STA_ck_ext_b2                    ((uint8_t )0x08)        /*!< Bit Value =(0x8):CK_EXT of 8bit */

#define CSC_STA_PLLI_STA_mask_w                     ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define CSC_STA_PLLI_STA_mask_h0                    ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define CSC_STA_PLLI_STA_mask_b1                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CSC_STA_PLLI_STA_switching_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Switching of 32bit */
#define CSC_STA_PLLI_STA_switching_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Switching of 16bit */
#define CSC_STA_PLLI_STA_switching_b1               ((uint8_t )0x00)        /*!< Bit Value =(0x0):Switching of 8bit */
#define CSC_STA_PLLI_STA_ck_hs_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):CK_HS of 32bit */
#define CSC_STA_PLLI_STA_ck_hs_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):CK_HS of 16bit */
#define CSC_STA_PLLI_STA_ck_hs_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):CK_HS of 8bit */
#define CSC_STA_PLLI_STA_ck_hs2_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):CK_HS2 of 32bit */
#define CSC_STA_PLLI_STA_ck_hs2_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(0x2):CK_HS2 of 16bit */
#define CSC_STA_PLLI_STA_ck_hs2_b1                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):CK_HS2 of 8bit */

#define CSC_STA_HS2_STA_mask_w                      ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define CSC_STA_HS2_STA_mask_h0                     ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define CSC_STA_HS2_STA_mask_b1                     ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CSC_STA_HS2_STA_switching_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Switching of 32bit */
#define CSC_STA_HS2_STA_switching_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Switching of 16bit */
#define CSC_STA_HS2_STA_switching_b1                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Switching of 8bit */
#define CSC_STA_HS2_STA_ihrco_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):IHRCO of 32bit */
#define CSC_STA_HS2_STA_ihrco_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(0x1):IHRCO of 16bit */
#define CSC_STA_HS2_STA_ihrco_b1                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):IHRCO of 8bit */
#define CSC_STA_HS2_STA_xosc_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):XOSC of 32bit */
#define CSC_STA_HS2_STA_xosc_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):XOSC of 16bit */
#define CSC_STA_HS2_STA_xosc_b1                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):XOSC of 8bit */
#define CSC_STA_HS2_STA_ck_ext_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(0x8):CK_EXT of 32bit */
#define CSC_STA_HS2_STA_ck_ext_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(0x8):CK_EXT of 16bit */
#define CSC_STA_HS2_STA_ck_ext_b1                   ((uint8_t )0x08)        /*!< Bit Value =(0x8):CK_EXT of 8bit */

#define CSC_STA_MCDF_mask_w                         ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_STA_MCDF_mask_h0                        ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_STA_MCDF_mask_b0                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_STA_MCDF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CSC_STA_MCDF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CSC_STA_MCDF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CSC_STA_MCDF_happened_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define CSC_STA_MCDF_happened_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define CSC_STA_MCDF_happened_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define CSC_STA_PLLF_mask_w                         ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CSC_STA_PLLF_mask_h0                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_STA_PLLF_mask_b0                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_STA_PLLF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CSC_STA_PLLF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CSC_STA_PLLF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CSC_STA_PLLF_happened_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define CSC_STA_PLLF_happened_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define CSC_STA_PLLF_happened_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define CSC_STA_IHRCOF_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_STA_IHRCOF_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_STA_IHRCOF_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_STA_IHRCOF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CSC_STA_IHRCOF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CSC_STA_IHRCOF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CSC_STA_IHRCOF_happened_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define CSC_STA_IHRCOF_happened_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define CSC_STA_IHRCOF_happened_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define CSC_STA_ILRCOF_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_STA_ILRCOF_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_STA_ILRCOF_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_STA_ILRCOF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CSC_STA_ILRCOF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CSC_STA_ILRCOF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CSC_STA_ILRCOF_happened_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define CSC_STA_ILRCOF_happened_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define CSC_STA_ILRCOF_happened_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define CSC_STA_XOSCF_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CSC_STA_XOSCF_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_STA_XOSCF_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_STA_XOSCF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CSC_STA_XOSCF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CSC_STA_XOSCF_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CSC_STA_XOSCF_happened_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define CSC_STA_XOSCF_happened_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define CSC_STA_XOSCF_happened_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define CSC_STA_PLL_LOCKF_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_STA_PLL_LOCKF_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_STA_PLL_LOCKF_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_STA_PLL_LOCKF_unlock_w                  ((uint32_t)0x00000000)
#define CSC_STA_PLL_LOCKF_unlock_h0                 ((uint16_t)0x0000)
#define CSC_STA_PLL_LOCKF_unlock_b0                 ((uint8_t )0x00)
#define CSC_STA_PLL_LOCKF_lock_w                    ((uint32_t)0x00000001)
#define CSC_STA_PLL_LOCKF_lock_h0                   ((uint16_t)0x0001)
#define CSC_STA_PLL_LOCKF_lock_b0                   ((uint8_t )0x01)

///@}
/**
 ******************************************************************************
 * @name        CSC_INT  [register's definitions]
 *              Offset[0x04]  CSC interrupt enable register (0x4C010004)
 ******************************************************************************
 */
///@{
#define CSC_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_INT */
#define CSC_INT_MCD_IE_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_INT_MCD_IE_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_INT_MCD_IE_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_INT_MCD_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_INT_MCD_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_INT_MCD_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_INT_MCD_IE_enable_w                     ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_INT_MCD_IE_enable_h0                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_INT_MCD_IE_enable_b0                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_INT_PLL_IE_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CSC_INT_PLL_IE_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_INT_PLL_IE_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_INT_PLL_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_INT_PLL_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_INT_PLL_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_INT_PLL_IE_enable_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_INT_PLL_IE_enable_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_INT_PLL_IE_enable_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_INT_IHRCO_IE_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_INT_IHRCO_IE_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_INT_IHRCO_IE_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_INT_IHRCO_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_INT_IHRCO_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_INT_IHRCO_IE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_INT_IHRCO_IE_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_INT_IHRCO_IE_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_INT_IHRCO_IE_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_INT_ILRCO_IE_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_INT_ILRCO_IE_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_INT_ILRCO_IE_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_INT_ILRCO_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_INT_ILRCO_IE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_INT_ILRCO_IE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_INT_ILRCO_IE_enable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_INT_ILRCO_IE_enable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_INT_ILRCO_IE_enable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_INT_XOSC_IE_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CSC_INT_XOSC_IE_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_INT_XOSC_IE_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_INT_XOSC_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_INT_XOSC_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_INT_XOSC_IE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_INT_XOSC_IE_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_INT_XOSC_IE_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_INT_XOSC_IE_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_PLL  [register's definitions]
 *              Offset[0x08]  CSC OSC and PLL control register (0x4C010008)
 ******************************************************************************
 */
///@{
#define CSC_PLL_default                             ((uint32_t)0x00000004)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_PLL */
#define CSC_PLL_XOSC_GN_mask_w                      ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define CSC_PLL_XOSC_GN_mask_h1                     ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define CSC_PLL_XOSC_GN_mask_b2                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CSC_PLL_XOSC_GN_32k_normal_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):32K_Normal of 32bit */
#define CSC_PLL_XOSC_GN_32k_normal_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0x0):32K_Normal of 16bit */
#define CSC_PLL_XOSC_GN_32k_normal_b2               ((uint8_t )0x00)        /*!< Bit Value =(0x0):32K_Normal of 8bit */
#define CSC_PLL_XOSC_GN_medium_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Medium of 32bit */
#define CSC_PLL_XOSC_GN_medium_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Medium of 16bit */
#define CSC_PLL_XOSC_GN_medium_b2                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):Medium of 8bit */
#define CSC_PLL_XOSC_GN_32k_lowest_w                ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):32K_Lowest of 32bit */
#define CSC_PLL_XOSC_GN_32k_lowest_h1               ((uint16_t)0x0002)      /*!< Bit Value =(0x2):32K_Lowest of 16bit */
#define CSC_PLL_XOSC_GN_32k_lowest_b2               ((uint8_t )0x02)        /*!< Bit Value =(0x2):32K_Lowest of 8bit */

#define CSC_PLL_PLL_MULX_mask_w                     ((uint32_t)0x00007E00)  /*!< Bit Mask of 32bit */
#define CSC_PLL_PLL_MULX_mask_h0                    ((uint16_t)0x7E00)      /*!< Bit Mask of 16bit */
#define CSC_PLL_PLL_MULX_mask_b1                    ((uint8_t )0x7E)        /*!< Bit Mask of 8bit */

#define CSC_PLL_PLL_MUL_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_PLL_PLL_MUL_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_PLL_PLL_MUL_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_PLL_PLL_MUL_16_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):16 of 32bit */
#define CSC_PLL_PLL_MUL_16_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):16 of 16bit */
#define CSC_PLL_PLL_MUL_16_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):16 of 8bit */
#define CSC_PLL_PLL_MUL_24_w                        ((uint32_t)0x00000100)  /*!< Bit Value =(1):24 of 32bit */
#define CSC_PLL_PLL_MUL_24_h0                       ((uint16_t)0x0100)      /*!< Bit Value =(1):24 of 16bit */
#define CSC_PLL_PLL_MUL_24_b1                       ((uint8_t )0x01)        /*!< Bit Value =(1):24 of 8bit */

#define CSC_PLL_PLL_VCOS_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_PLL_PLL_VCOS_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_PLL_PLL_VCOS_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_PLL_PLL_VCOS_low_w                      ((uint32_t)0x00000000)
#define CSC_PLL_PLL_VCOS_low_h0                     ((uint16_t)0x0000)
#define CSC_PLL_PLL_VCOS_low_b0                     ((uint8_t )0x00)
#define CSC_PLL_PLL_VCOS_high_w                     ((uint32_t)0x00000080)
#define CSC_PLL_PLL_VCOS_high_h0                    ((uint16_t)0x0080)
#define CSC_PLL_PLL_VCOS_high_b0                    ((uint8_t )0x80)

#define CSC_PLL_PLL_LDEN_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CSC_PLL_PLL_LDEN_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_PLL_PLL_LDEN_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_PLL_PLL_LDEN_disable_w                  ((uint32_t)0x00000000)
#define CSC_PLL_PLL_LDEN_disable_h0                 ((uint16_t)0x0000)
#define CSC_PLL_PLL_LDEN_disable_b0                 ((uint8_t )0x00)
#define CSC_PLL_PLL_LDEN_enable_w                   ((uint32_t)0x00000004)
#define CSC_PLL_PLL_LDEN_enable_h0                  ((uint16_t)0x0004)
#define CSC_PLL_PLL_LDEN_enable_b0                  ((uint8_t )0x04)

#define CSC_PLL_PLLI_SEL_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CSC_PLL_PLLI_SEL_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_PLL_PLLI_SEL_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_PLL_PLLI_SEL_ck_hs_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):CK_HS of 32bit */
#define CSC_PLL_PLLI_SEL_ck_hs_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):CK_HS of 16bit */
#define CSC_PLL_PLLI_SEL_ck_hs_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):CK_HS of 8bit */
#define CSC_PLL_PLLI_SEL_ck_hs2_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):CK_HS2 of 32bit */
#define CSC_PLL_PLLI_SEL_ck_hs2_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):CK_HS2 of 16bit */
#define CSC_PLL_PLLI_SEL_ck_hs2_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):CK_HS2 of 8bit */

#define CSC_PLL_PLL_MDS_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_PLL_PLL_MDS_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_PLL_PLL_MDS_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_PLL_PLL_MDS_mul_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):MUL of 32bit */
#define CSC_PLL_PLL_MDS_mul_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):MUL of 16bit */
#define CSC_PLL_PLL_MDS_mul_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):MUL of 8bit */
#define CSC_PLL_PLL_MDS_mulx_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(1):MULX of 32bit */
#define CSC_PLL_PLL_MDS_mulx_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(1):MULX of 16bit */
#define CSC_PLL_PLL_MDS_mulx_b0                     ((uint8_t )0x01)        /*!< Bit Value =(1):MULX of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_KEY  [register's definitions]
 *              Offset[0x0C]  CSC write protected Key register (0x4C01000C)
 ******************************************************************************
 */
///@{
#define CSC_KEY_default                             ((uint32_t)0x00000001)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_KEY */
#define CSC_KEY_KEY_mask_w                          ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define CSC_KEY_KEY_mask_h0                         ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define CSC_KEY_KEY_unprotected_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define CSC_KEY_KEY_unprotected_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define CSC_KEY_KEY_unprotected_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define CSC_KEY_KEY_protected_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define CSC_KEY_KEY_protected_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define CSC_KEY_KEY_protected_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_CR0  [register's definitions]
 *              Offset[0x10]  CSC clock source control register 0 (0x4C010010)
 ******************************************************************************
 */
///@{
#define CSC_CR0_default                             ((uint32_t)0x00000200)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_CR0 */
#define CSC_CR0_MCD_SEL_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CSC_CR0_MCD_SEL_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CSC_CR0_MCD_SEL_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CSC_CR0_MCD_SEL_125us_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):125us of 32bit */
#define CSC_CR0_MCD_SEL_125us_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):125us of 16bit */
#define CSC_CR0_MCD_SEL_125us_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):125us of 8bit */
#define CSC_CR0_MCD_SEL_250us_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):250us of 32bit */
#define CSC_CR0_MCD_SEL_250us_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(0x1):250us of 16bit */
#define CSC_CR0_MCD_SEL_250us_b2                    ((uint8_t )0x40)        /*!< Bit Value =(0x1):250us of 8bit */
#define CSC_CR0_MCD_SEL_500us_w                     ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):500us of 32bit */
#define CSC_CR0_MCD_SEL_500us_h1                    ((uint16_t)0x0080)      /*!< Bit Value =(0x2):500us of 16bit */
#define CSC_CR0_MCD_SEL_500us_b2                    ((uint8_t )0x80)        /*!< Bit Value =(0x2):500us of 8bit */
#define CSC_CR0_MCD_SEL_1ms_w                       ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):1ms of 32bit */
#define CSC_CR0_MCD_SEL_1ms_h1                      ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):1ms of 16bit */
#define CSC_CR0_MCD_SEL_1ms_b2                      ((uint8_t )0xC0)        /*!< Bit Value =(0x3):1ms of 8bit */

#define CSC_CR0_IHRCO_SEL_mask_w                    ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CSC_CR0_IHRCO_SEL_mask_h1                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_CR0_IHRCO_SEL_mask_b2                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_CR0_IHRCO_SEL_12_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):12 of 32bit */
#define CSC_CR0_IHRCO_SEL_12_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):12 of 16bit */
#define CSC_CR0_IHRCO_SEL_12_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):12 of 8bit */
#define CSC_CR0_IHRCO_SEL_11_w                      ((uint32_t)0x00040000)  /*!< Bit Value =(1):11 of 32bit */
#define CSC_CR0_IHRCO_SEL_11_h1                     ((uint16_t)0x0004)      /*!< Bit Value =(1):11 of 16bit */
#define CSC_CR0_IHRCO_SEL_11_b2                     ((uint8_t )0x04)        /*!< Bit Value =(1):11 of 8bit */

#define CSC_CR0_ST_SEL_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CSC_CR0_ST_SEL_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CR0_ST_SEL_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CR0_ST_SEL_hclk8_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):HCLK8 of 32bit */
#define CSC_CR0_ST_SEL_hclk8_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):HCLK8 of 16bit */
#define CSC_CR0_ST_SEL_hclk8_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):HCLK8 of 8bit */
#define CSC_CR0_ST_SEL_ck_ls2_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):CK_LS2 of 32bit */
#define CSC_CR0_ST_SEL_ck_ls2_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):CK_LS2 of 16bit */
#define CSC_CR0_ST_SEL_ck_ls2_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):CK_LS2 of 8bit */

#define CSC_CR0_MAIN_SEL_mask_w                     ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CSC_CR0_MAIN_SEL_mask_h0                    ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CSC_CR0_MAIN_SEL_mask_b1                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CSC_CR0_MAIN_SEL_ck_hs_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_HS of 32bit */
#define CSC_CR0_MAIN_SEL_ck_hs_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_HS of 16bit */
#define CSC_CR0_MAIN_SEL_ck_hs_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_HS of 8bit */
#define CSC_CR0_MAIN_SEL_ck_plli_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):CK_PLLI of 32bit */
#define CSC_CR0_MAIN_SEL_ck_plli_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(0x1):CK_PLLI of 16bit */
#define CSC_CR0_MAIN_SEL_ck_plli_b1                 ((uint8_t )0x40)        /*!< Bit Value =(0x1):CK_PLLI of 8bit */
#define CSC_CR0_MAIN_SEL_ck_pllo_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):CK_PLLO of 32bit */
#define CSC_CR0_MAIN_SEL_ck_pllo_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(0x2):CK_PLLO of 16bit */
#define CSC_CR0_MAIN_SEL_ck_pllo_b1                 ((uint8_t )0x80)        /*!< Bit Value =(0x2):CK_PLLO of 8bit */

#define CSC_CR0_HS2_SEL_mask_w                      ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define CSC_CR0_HS2_SEL_mask_h0                     ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define CSC_CR0_HS2_SEL_mask_b1                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CSC_CR0_HS2_SEL_ihrco_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IHRCO of 32bit */
#define CSC_CR0_HS2_SEL_ihrco_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IHRCO of 16bit */
#define CSC_CR0_HS2_SEL_ihrco_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):IHRCO of 8bit */
#define CSC_CR0_HS2_SEL_xosc_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):XOSC of 32bit */
#define CSC_CR0_HS2_SEL_xosc_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(0x1):XOSC of 16bit */
#define CSC_CR0_HS2_SEL_xosc_b1                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):XOSC of 8bit */
#define CSC_CR0_HS2_SEL_ck_ext_w                    ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):CK_EXT of 32bit */
#define CSC_CR0_HS2_SEL_ck_ext_h0                   ((uint16_t)0x3000)      /*!< Bit Value =(0x3):CK_EXT of 16bit */
#define CSC_CR0_HS2_SEL_ck_ext_b1                   ((uint8_t )0x30)        /*!< Bit Value =(0x3):CK_EXT of 8bit */

#define CSC_CR0_HS_SEL_mask_w                       ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define CSC_CR0_HS_SEL_mask_h0                      ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define CSC_CR0_HS_SEL_mask_b1                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CSC_CR0_HS_SEL_ihrco_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IHRCO of 32bit */
#define CSC_CR0_HS_SEL_ihrco_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IHRCO of 16bit */
#define CSC_CR0_HS_SEL_ihrco_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):IHRCO of 8bit */
#define CSC_CR0_HS_SEL_xosc_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):XOSC of 32bit */
#define CSC_CR0_HS_SEL_xosc_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(0x1):XOSC of 16bit */
#define CSC_CR0_HS_SEL_xosc_b1                      ((uint8_t )0x04)        /*!< Bit Value =(0x1):XOSC of 8bit */
#define CSC_CR0_HS_SEL_ilrco_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):ILRCO of 32bit */
#define CSC_CR0_HS_SEL_ilrco_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):ILRCO of 16bit */
#define CSC_CR0_HS_SEL_ilrco_b1                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):ILRCO of 8bit */
#define CSC_CR0_HS_SEL_ck_ext_w                     ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):CK_EXT of 32bit */
#define CSC_CR0_HS_SEL_ck_ext_h0                    ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):CK_EXT of 16bit */
#define CSC_CR0_HS_SEL_ck_ext_b1                    ((uint8_t )0x0C)        /*!< Bit Value =(0x3):CK_EXT of 8bit */

#define CSC_CR0_LS_SEL_mask_w                       ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define CSC_CR0_LS_SEL_mask_h0                      ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define CSC_CR0_LS_SEL_mask_b1                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CSC_CR0_LS_SEL_xosc_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):XOSC of 32bit */
#define CSC_CR0_LS_SEL_xosc_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):XOSC of 16bit */
#define CSC_CR0_LS_SEL_xosc_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):XOSC of 8bit */
#define CSC_CR0_LS_SEL_ilrco_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):ILRCO of 32bit */
#define CSC_CR0_LS_SEL_ilrco_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):ILRCO of 16bit */
#define CSC_CR0_LS_SEL_ilrco_b1                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):ILRCO of 8bit */
#define CSC_CR0_LS_SEL_ck_ext_w                     ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):CK_EXT of 32bit */
#define CSC_CR0_LS_SEL_ck_ext_h0                    ((uint16_t)0x0300)      /*!< Bit Value =(0x3):CK_EXT of 16bit */
#define CSC_CR0_LS_SEL_ck_ext_b1                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):CK_EXT of 8bit */

#define CSC_CR0_PLL_EN_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_CR0_PLL_EN_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_CR0_PLL_EN_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_CR0_PLL_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_CR0_PLL_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_CR0_PLL_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_CR0_PLL_EN_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_CR0_PLL_EN_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_CR0_PLL_EN_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_CR0_MCD_DIS_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_CR0_MCD_DIS_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_CR0_MCD_DIS_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_CR0_MCD_DIS_enable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define CSC_CR0_MCD_DIS_enable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define CSC_CR0_MCD_DIS_enable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define CSC_CR0_MCD_DIS_disable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Disable of 32bit */
#define CSC_CR0_MCD_DIS_disable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Disable of 16bit */
#define CSC_CR0_MCD_DIS_disable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Disable of 8bit */

#define CSC_CR0_IHRCO_EN_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CSC_CR0_IHRCO_EN_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CSC_CR0_IHRCO_EN_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CSC_CR0_IHRCO_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_CR0_IHRCO_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_CR0_IHRCO_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_CR0_IHRCO_EN_enable_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_CR0_IHRCO_EN_enable_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_CR0_IHRCO_EN_enable_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_DIV  [register's definitions]
 *              Offset[0x14]  CSC clock  divider register (0x4C010014)
 ******************************************************************************
 */
///@{
#define CSC_DIV_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_DIV */
#define CSC_DIV_UT_DIV_mask_w                       ((uint32_t)0x0C000000)  /*!< Bit Mask of 32bit */
#define CSC_DIV_UT_DIV_mask_h1                      ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define CSC_DIV_UT_DIV_mask_b3                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CSC_DIV_UT_DIV_div32_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV32 of 32bit */
#define CSC_DIV_UT_DIV_div32_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV32 of 16bit */
#define CSC_DIV_UT_DIV_div32_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV32 of 8bit */
#define CSC_DIV_UT_DIV_div8_w                       ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):DIV8 of 32bit */
#define CSC_DIV_UT_DIV_div8_h1                      ((uint16_t)0x0400)      /*!< Bit Value =(0x1):DIV8 of 16bit */
#define CSC_DIV_UT_DIV_div8_b3                      ((uint8_t )0x04)        /*!< Bit Value =(0x1):DIV8 of 8bit */
#define CSC_DIV_UT_DIV_div16_w                      ((uint32_t)0x08000000)  /*!< Bit Value =(0x2):DIV16 of 32bit */
#define CSC_DIV_UT_DIV_div16_h1                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):DIV16 of 16bit */
#define CSC_DIV_UT_DIV_div16_b3                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):DIV16 of 8bit */
#define CSC_DIV_UT_DIV_div128_w                     ((uint32_t)0x0C000000)  /*!< Bit Value =(0x3):DIV128 of 32bit */
#define CSC_DIV_UT_DIV_div128_h1                    ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):DIV128 of 16bit */
#define CSC_DIV_UT_DIV_div128_b3                    ((uint8_t )0x0C)        /*!< Bit Value =(0x3):DIV128 of 8bit */

#define CSC_DIV_USB_DIV_mask_w                      ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define CSC_DIV_USB_DIV_mask_h1                     ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CSC_DIV_USB_DIV_mask_b2                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CSC_DIV_USB_DIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CSC_DIV_USB_DIV_div1_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CSC_DIV_USB_DIV_div1_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CSC_DIV_USB_DIV_div2_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CSC_DIV_USB_DIV_div2_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CSC_DIV_USB_DIV_div2_b2                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CSC_DIV_USB_DIV_div3_w                      ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):DIV3 of 32bit */
#define CSC_DIV_USB_DIV_div3_h1                     ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV3 of 16bit */
#define CSC_DIV_USB_DIV_div3_b2                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV3 of 8bit */
#define CSC_DIV_USB_DIV_div4_w                      ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):DIV4 of 32bit */
#define CSC_DIV_USB_DIV_div4_h1                     ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV4 of 16bit */
#define CSC_DIV_USB_DIV_div4_b2                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV4 of 8bit */

#define CSC_DIV_APB_DIV_mask_w                      ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define CSC_DIV_APB_DIV_mask_h1                     ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define CSC_DIV_APB_DIV_mask_b2                     ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CSC_DIV_APB_DIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CSC_DIV_APB_DIV_div1_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CSC_DIV_APB_DIV_div1_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CSC_DIV_APB_DIV_div2_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CSC_DIV_APB_DIV_div2_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CSC_DIV_APB_DIV_div2_b2                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CSC_DIV_APB_DIV_div4_w                      ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CSC_DIV_APB_DIV_div4_h1                     ((uint16_t)0x0002)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CSC_DIV_APB_DIV_div4_b2                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CSC_DIV_APB_DIV_div8_w                      ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define CSC_DIV_APB_DIV_div8_h1                     ((uint16_t)0x0003)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define CSC_DIV_APB_DIV_div8_b2                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV8 of 8bit */
#define CSC_DIV_APB_DIV_div16_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):DIV16 of 32bit */
#define CSC_DIV_APB_DIV_div16_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(0x4):DIV16 of 16bit */
#define CSC_DIV_APB_DIV_div16_b2                    ((uint8_t )0x04)        /*!< Bit Value =(0x4):DIV16 of 8bit */

#define CSC_DIV_AHB_DIV_mask_w                      ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define CSC_DIV_AHB_DIV_mask_h0                     ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define CSC_DIV_AHB_DIV_mask_b1                     ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CSC_DIV_AHB_DIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CSC_DIV_AHB_DIV_div1_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CSC_DIV_AHB_DIV_div1_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CSC_DIV_AHB_DIV_div2_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CSC_DIV_AHB_DIV_div2_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CSC_DIV_AHB_DIV_div2_b1                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CSC_DIV_AHB_DIV_div4_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CSC_DIV_AHB_DIV_div4_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CSC_DIV_AHB_DIV_div4_b1                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CSC_DIV_AHB_DIV_div8_w                      ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define CSC_DIV_AHB_DIV_div8_h0                     ((uint16_t)0x0300)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define CSC_DIV_AHB_DIV_div8_b1                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV8 of 8bit */
#define CSC_DIV_AHB_DIV_div16_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):DIV16 of 32bit */
#define CSC_DIV_AHB_DIV_div16_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(0x4):DIV16 of 16bit */
#define CSC_DIV_AHB_DIV_div16_b1                    ((uint8_t )0x04)        /*!< Bit Value =(0x4):DIV16 of 8bit */
#define CSC_DIV_AHB_DIV_div32_w                     ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):DIV32 of 32bit */
#define CSC_DIV_AHB_DIV_div32_h0                    ((uint16_t)0x0500)      /*!< Bit Value =(0x5):DIV32 of 16bit */
#define CSC_DIV_AHB_DIV_div32_b1                    ((uint8_t )0x05)        /*!< Bit Value =(0x5):DIV32 of 8bit */
#define CSC_DIV_AHB_DIV_div64_w                     ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):DIV64 of 32bit */
#define CSC_DIV_AHB_DIV_div64_h0                    ((uint16_t)0x0600)      /*!< Bit Value =(0x6):DIV64 of 16bit */
#define CSC_DIV_AHB_DIV_div64_b1                    ((uint8_t )0x06)        /*!< Bit Value =(0x6):DIV64 of 8bit */
#define CSC_DIV_AHB_DIV_div128_w                    ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):DIV128 of 32bit */
#define CSC_DIV_AHB_DIV_div128_h0                   ((uint16_t)0x0700)      /*!< Bit Value =(0x7):DIV128 of 16bit */
#define CSC_DIV_AHB_DIV_div128_b1                   ((uint8_t )0x07)        /*!< Bit Value =(0x7):DIV128 of 8bit */
#define CSC_DIV_AHB_DIV_div256_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(0x8):DIV256 of 32bit */
#define CSC_DIV_AHB_DIV_div256_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(0x8):DIV256 of 16bit */
#define CSC_DIV_AHB_DIV_div256_b1                   ((uint8_t )0x08)        /*!< Bit Value =(0x8):DIV256 of 8bit */
#define CSC_DIV_AHB_DIV_div512_w                    ((uint32_t)0x00000900)  /*!< Bit Value =(0x9):DIV512 of 32bit */
#define CSC_DIV_AHB_DIV_div512_h0                   ((uint16_t)0x0900)      /*!< Bit Value =(0x9):DIV512 of 16bit */
#define CSC_DIV_AHB_DIV_div512_b1                   ((uint8_t )0x09)        /*!< Bit Value =(0x9):DIV512 of 8bit */

#define CSC_DIV_PLLO_DIV_mask_w                     ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define CSC_DIV_PLLO_DIV_mask_h0                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CSC_DIV_PLLO_DIV_mask_b0                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CSC_DIV_PLLO_DIV_div4_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV4 of 32bit */
#define CSC_DIV_PLLO_DIV_div4_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV4 of 16bit */
#define CSC_DIV_PLLO_DIV_div4_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV4 of 8bit */
#define CSC_DIV_PLLO_DIV_div3_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV3 of 32bit */
#define CSC_DIV_PLLO_DIV_div3_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV3 of 16bit */
#define CSC_DIV_PLLO_DIV_div3_b0                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV3 of 8bit */
#define CSC_DIV_PLLO_DIV_div2_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV2 of 32bit */
#define CSC_DIV_PLLO_DIV_div2_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV2 of 16bit */
#define CSC_DIV_PLLO_DIV_div2_b0                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV2 of 8bit */
#define CSC_DIV_PLLO_DIV_div1_w                     ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV1 of 32bit */
#define CSC_DIV_PLLO_DIV_div1_h0                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV1 of 16bit */
#define CSC_DIV_PLLO_DIV_div1_b0                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV1 of 8bit */

#define CSC_DIV_PLLI_DIV_mask_w                     ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define CSC_DIV_PLLI_DIV_mask_h0                    ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define CSC_DIV_PLLI_DIV_mask_b0                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CSC_DIV_PLLI_DIV_div1_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CSC_DIV_PLLI_DIV_div1_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CSC_DIV_PLLI_DIV_div1_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CSC_DIV_PLLI_DIV_div2_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CSC_DIV_PLLI_DIV_div2_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CSC_DIV_PLLI_DIV_div2_b0                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CSC_DIV_PLLI_DIV_div4_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CSC_DIV_PLLI_DIV_div4_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CSC_DIV_PLLI_DIV_div4_b0                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CSC_DIV_PLLI_DIV_div6_w                     ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):DIV6 of 32bit */
#define CSC_DIV_PLLI_DIV_div6_h0                    ((uint16_t)0x0003)      /*!< Bit Value =(0x3):DIV6 of 16bit */
#define CSC_DIV_PLLI_DIV_div6_b0                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV6 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_CKO  [register's definitions]
 *              Offset[0x18]  CSC internal clock output control register (0x4C010018)
 ******************************************************************************
 */
///@{
#define CSC_CKO_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_CKO */
#define CSC_CKO_CKO_SEL_mask_w                      ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define CSC_CKO_CKO_SEL_mask_h0                     ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define CSC_CKO_CKO_SEL_mask_b0                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define CSC_CKO_CKO_SEL_ck_main_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_MAIN of 32bit */
#define CSC_CKO_CKO_SEL_ck_main_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_MAIN of 16bit */
#define CSC_CKO_CKO_SEL_ck_main_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_MAIN of 8bit */
#define CSC_CKO_CKO_SEL_ck_ahb_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKO_CKO_SEL_ck_ahb_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKO_CKO_SEL_ck_ahb_b0                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):CK_AHB of 8bit */
#define CSC_CKO_CKO_SEL_ck_apb_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):CK_APB of 32bit */
#define CSC_CKO_CKO_SEL_ck_apb_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(0x2):CK_APB of 16bit */
#define CSC_CKO_CKO_SEL_ck_apb_b0                   ((uint8_t )0x20)        /*!< Bit Value =(0x2):CK_APB of 8bit */
#define CSC_CKO_CKO_SEL_ck_hs_w                     ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):CK_HS of 32bit */
#define CSC_CKO_CKO_SEL_ck_hs_h0                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):CK_HS of 16bit */
#define CSC_CKO_CKO_SEL_ck_hs_b0                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):CK_HS of 8bit */
#define CSC_CKO_CKO_SEL_ck_ls_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):CK_LS of 32bit */
#define CSC_CKO_CKO_SEL_ck_ls_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(0x4):CK_LS of 16bit */
#define CSC_CKO_CKO_SEL_ck_ls_b0                    ((uint8_t )0x40)        /*!< Bit Value =(0x4):CK_LS of 8bit */
#define CSC_CKO_CKO_SEL_ck_xosc_w                   ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):CK_XOSC of 32bit */
#define CSC_CKO_CKO_SEL_ck_xosc_h0                  ((uint16_t)0x0050)      /*!< Bit Value =(0x5):CK_XOSC of 16bit */
#define CSC_CKO_CKO_SEL_ck_xosc_b0                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):CK_XOSC of 8bit */

#define CSC_CKO_CKO_DIV_mask_w                      ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define CSC_CKO_CKO_DIV_mask_h0                     ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define CSC_CKO_CKO_DIV_mask_b0                     ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CSC_CKO_CKO_DIV_div1_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CSC_CKO_CKO_DIV_div1_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CSC_CKO_CKO_DIV_div1_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CSC_CKO_CKO_DIV_div2_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CSC_CKO_CKO_DIV_div2_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CSC_CKO_CKO_DIV_div2_b0                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CSC_CKO_CKO_DIV_div4_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CSC_CKO_CKO_DIV_div4_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CSC_CKO_CKO_DIV_div4_b0                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CSC_CKO_CKO_DIV_div8_w                      ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define CSC_CKO_CKO_DIV_div8_h0                     ((uint16_t)0x000C)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define CSC_CKO_CKO_DIV_div8_b0                     ((uint8_t )0x0C)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define CSC_CKO_CKO_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_CKO_CKO_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CKO_CKO_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKO_CKO_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define CSC_CKO_CKO_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define CSC_CKO_CKO_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define CSC_CKO_CKO_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Enable of 32bit */
#define CSC_CKO_CKO_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Enable of 16bit */
#define CSC_CKO_CKO_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_AHB  [register's definitions]
 *              Offset[0x1C]  CSC AHB clock control register (0x4C01001C)
 ******************************************************************************
 */
///@{
#define CSC_AHB_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_AHB */
#define CSC_AHB_DMA_EN_mask_w                       ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CSC_AHB_DMA_EN_mask_h0                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CSC_AHB_DMA_EN_mask_b1                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_AHB_DMA_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_DMA_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_DMA_EN_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_DMA_EN_enable_w                     ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_DMA_EN_enable_h0                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_DMA_EN_enable_b1                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_EMB_EN_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CSC_AHB_EMB_EN_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_AHB_EMB_EN_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_AHB_EMB_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_EMB_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_EMB_EN_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_EMB_EN_enable_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_EMB_EN_enable_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_EMB_EN_enable_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_GPL_EN_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_AHB_GPL_EN_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_AHB_GPL_EN_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_AHB_GPL_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_GPL_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_GPL_EN_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_GPL_EN_enable_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_GPL_EN_enable_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_GPL_EN_enable_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_IOPE_EN_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_AHB_IOPE_EN_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_AHB_IOPE_EN_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_AHB_IOPE_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_IOPE_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_IOPE_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_IOPE_EN_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_IOPE_EN_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_IOPE_EN_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_IOPD_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CSC_AHB_IOPD_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CSC_AHB_IOPD_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CSC_AHB_IOPD_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_IOPD_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_IOPD_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_IOPD_EN_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_IOPD_EN_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_IOPD_EN_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_IOPC_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CSC_AHB_IOPC_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_AHB_IOPC_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_AHB_IOPC_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_IOPC_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_IOPC_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_IOPC_EN_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_IOPC_EN_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_IOPC_EN_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_IOPB_EN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CSC_AHB_IOPB_EN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_AHB_IOPB_EN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_AHB_IOPB_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_IOPB_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_IOPB_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_IOPB_EN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_IOPB_EN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_IOPB_EN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_AHB_IOPA_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_AHB_IOPA_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_AHB_IOPA_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_AHB_IOPA_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_AHB_IOPA_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_AHB_IOPA_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_AHB_IOPA_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_AHB_IOPA_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_AHB_IOPA_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_APB0  [register's definitions]
 *              Offset[0x20]  CSC APB clock control register 0 (0x4C010020)
 ******************************************************************************
 */
///@{
#define CSC_APB0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_APB0 */
#define CSC_APB0_APX_EN_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_APX_EN_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CSC_APB0_APX_EN_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_APB0_APX_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_APX_EN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_APX_EN_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_APX_EN_enable_w                    ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_APX_EN_enable_h1                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_APX_EN_enable_b3                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_USB_EN_mask_w                      ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_USB_EN_mask_h1                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_APB0_USB_EN_mask_b3                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_APB0_USB_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_USB_EN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_USB_EN_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_USB_EN_enable_w                    ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_USB_EN_enable_h1                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_USB_EN_enable_b3                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT7_EN_mask_w                     ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT7_EN_mask_h1                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT7_EN_mask_b2                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT7_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT7_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT7_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT7_EN_enable_w                   ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT7_EN_enable_h1                  ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT7_EN_enable_b2                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT6_EN_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT6_EN_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT6_EN_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT6_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT6_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT6_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT6_EN_enable_w                   ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT6_EN_enable_h1                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT6_EN_enable_b2                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT5_EN_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT5_EN_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT5_EN_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT5_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT5_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT5_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT5_EN_enable_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT5_EN_enable_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT5_EN_enable_b2                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT4_EN_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT4_EN_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT4_EN_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT4_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT4_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT4_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT4_EN_enable_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT4_EN_enable_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT4_EN_enable_b2                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT2_EN_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT2_EN_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT2_EN_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT2_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT2_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT2_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT2_EN_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT2_EN_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT2_EN_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT1_EN_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT1_EN_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT1_EN_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT1_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT1_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT1_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT1_EN_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT1_EN_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT1_EN_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_URT0_EN_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_URT0_EN_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_APB0_URT0_EN_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_APB0_URT0_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_URT0_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_URT0_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_URT0_EN_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_URT0_EN_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_URT0_EN_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_SPI0_EN_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CSC_APB0_SPI0_EN_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_APB0_SPI0_EN_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_APB0_SPI0_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_SPI0_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_SPI0_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_SPI0_EN_enable_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_SPI0_EN_enable_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_SPI0_EN_enable_b1                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_I2C1_EN_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CSC_APB0_I2C1_EN_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CSC_APB0_I2C1_EN_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_APB0_I2C1_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_I2C1_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_I2C1_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_I2C1_EN_enable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_I2C1_EN_enable_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_I2C1_EN_enable_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_I2C0_EN_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_APB0_I2C0_EN_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_APB0_I2C0_EN_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_APB0_I2C0_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_I2C0_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_I2C0_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_I2C0_EN_enable_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_I2C0_EN_enable_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_I2C0_EN_enable_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_WWDT_EN_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_APB0_WWDT_EN_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_APB0_WWDT_EN_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_APB0_WWDT_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_WWDT_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_WWDT_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_WWDT_EN_enable_w                   ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_WWDT_EN_enable_h0                  ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_WWDT_EN_enable_b0                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_IWDT_EN_mask_w                     ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CSC_APB0_IWDT_EN_mask_h0                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_APB0_IWDT_EN_mask_b0                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_APB0_IWDT_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_IWDT_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_IWDT_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_IWDT_EN_enable_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_IWDT_EN_enable_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_IWDT_EN_enable_b0                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_RTC_EN_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_APB0_RTC_EN_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_APB0_RTC_EN_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_APB0_RTC_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_RTC_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_RTC_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_RTC_EN_enable_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_RTC_EN_enable_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_RTC_EN_enable_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_DAC_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CSC_APB0_DAC_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CSC_APB0_DAC_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CSC_APB0_DAC_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_DAC_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_DAC_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_DAC_EN_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_DAC_EN_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_DAC_EN_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_CMP_EN_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CSC_APB0_CMP_EN_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_APB0_CMP_EN_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_APB0_CMP_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_CMP_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_CMP_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_CMP_EN_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_CMP_EN_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_CMP_EN_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB0_ADC0_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_APB0_ADC0_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_APB0_ADC0_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_APB0_ADC0_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB0_ADC0_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB0_ADC0_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB0_ADC0_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB0_ADC0_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB0_ADC0_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_APB1  [register's definitions]
 *              Offset[0x24]  CSC APB clock control register 1 (0x4C010024)
 ******************************************************************************
 */
///@{
#define CSC_APB1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_APB1 */
#define CSC_APB1_TM36_EN_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM36_EN_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM36_EN_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM36_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM36_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM36_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM36_EN_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM36_EN_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM36_EN_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB1_TM26_EN_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM26_EN_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM26_EN_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM26_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM26_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM26_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM26_EN_enable_w                   ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM26_EN_enable_h0                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM26_EN_enable_b1                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB1_TM20_EN_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM20_EN_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM20_EN_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM20_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM20_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM20_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM20_EN_enable_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM20_EN_enable_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM20_EN_enable_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB1_TM16_EN_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM16_EN_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM16_EN_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM16_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM16_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM16_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM16_EN_enable_w                   ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM16_EN_enable_h0                  ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM16_EN_enable_b0                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB1_TM10_EN_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM10_EN_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM10_EN_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM10_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM10_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM10_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM10_EN_enable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM10_EN_enable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM10_EN_enable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB1_TM01_EN_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM01_EN_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM01_EN_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM01_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM01_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM01_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM01_EN_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM01_EN_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM01_EN_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_APB1_TM00_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_APB1_TM00_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_APB1_TM00_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_APB1_TM00_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_APB1_TM00_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_APB1_TM00_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_APB1_TM00_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_APB1_TM00_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_APB1_TM00_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_SLP0  [register's definitions]
 *              Offset[0x30]  CSC SLEEP mode clock enable register 0 (0x4C010030)
 ******************************************************************************
 */
///@{
#define CSC_SLP0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_SLP0 */
#define CSC_SLP0_SLP_APX_mask_w                     ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_APX_mask_h1                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_APX_mask_b3                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_APX_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_APX_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_APX_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_APX_enable_w                   ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_APX_enable_h1                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_APX_enable_b3                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_USB_mask_w                     ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_USB_mask_h1                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_USB_mask_b3                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_USB_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_USB_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_USB_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_USB_enable_w                   ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_USB_enable_h1                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_USB_enable_b3                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT7_mask_w                    ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT7_mask_h1                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT7_mask_b2                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT7_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT7_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT7_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT7_enable_w                  ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT7_enable_h1                 ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT7_enable_b2                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT6_mask_w                    ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT6_mask_h1                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT6_mask_b2                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT6_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT6_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT6_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT6_enable_w                  ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT6_enable_h1                 ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT6_enable_b2                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT5_mask_w                    ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT5_mask_h1                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT5_mask_b2                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT5_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT5_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT5_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT5_enable_w                  ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT5_enable_h1                 ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT5_enable_b2                 ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT4_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT4_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT4_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT4_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT4_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT4_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT4_enable_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT4_enable_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT4_enable_b2                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT2_mask_w                    ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT2_mask_h1                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT2_mask_b2                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT2_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT2_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT2_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT2_enable_w                  ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT2_enable_h1                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT2_enable_b2                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT1_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT1_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT1_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT1_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT1_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT1_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT1_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT1_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT1_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_URT0_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_URT0_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_URT0_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_URT0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_URT0_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_URT0_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_URT0_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_URT0_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_URT0_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_SPI0_mask_w                    ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_SPI0_mask_h0                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_SPI0_mask_b1                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_SPI0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_SPI0_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_SPI0_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_SPI0_enable_w                  ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_SPI0_enable_h0                 ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_SPI0_enable_b1                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_I2C1_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_I2C1_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_I2C1_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_I2C1_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_I2C1_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_I2C1_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_I2C1_enable_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_I2C1_enable_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_I2C1_enable_b1                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_I2C0_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_I2C0_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_I2C0_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_I2C0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_I2C0_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_I2C0_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_I2C0_enable_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_I2C0_enable_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_I2C0_enable_b1                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_WWDT_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_WWDT_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_WWDT_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_WWDT_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_WWDT_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_WWDT_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_WWDT_enable_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_WWDT_enable_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_WWDT_enable_b0                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_IWDT_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_IWDT_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_IWDT_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_IWDT_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_IWDT_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_IWDT_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_IWDT_enable_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_IWDT_enable_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_IWDT_enable_b0                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_RTC_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_RTC_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_RTC_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_RTC_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_RTC_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_RTC_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_RTC_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_RTC_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_RTC_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_DAC_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_DAC_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_DAC_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_DAC_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_DAC_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_DAC_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_DAC_enable_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_DAC_enable_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_DAC_enable_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_CMP_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_CMP_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_CMP_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_CMP_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_CMP_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_CMP_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_CMP_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_CMP_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_CMP_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP0_SLP_ADC0_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_SLP0_SLP_ADC0_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_SLP0_SLP_ADC0_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_SLP0_SLP_ADC0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP0_SLP_ADC0_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP0_SLP_ADC0_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP0_SLP_ADC0_enable_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP0_SLP_ADC0_enable_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP0_SLP_ADC0_enable_b0                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_SLP1  [register's definitions]
 *              Offset[0x34]  CSC SLEEP mode clock enable register 1 (0x4C010034)
 ******************************************************************************
 */
///@{
#define CSC_SLP1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_SLP1 */
#define CSC_SLP1_SLP_EMB_mask_w                     ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_EMB_mask_h1                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_EMB_mask_b3                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_EMB_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_EMB_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_EMB_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_EMB_enable_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_EMB_enable_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_EMB_enable_b3                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_DMA_mask_w                     ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_DMA_mask_h1                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_DMA_mask_b3                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_DMA_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_DMA_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_DMA_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_DMA_enable_w                   ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_DMA_enable_h1                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_DMA_enable_b3                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_FLASH_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_FLASH_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_FLASH_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_FLASH_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_FLASH_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_FLASH_disable_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_FLASH_enable_w                 ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_FLASH_enable_h1                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_FLASH_enable_b3                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_SRAM_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_SRAM_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_SRAM_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_SRAM_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_SRAM_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_SRAM_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_SRAM_enable_w                  ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_SRAM_enable_h1                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_SRAM_enable_b3                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM36_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM36_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM36_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM36_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM36_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM36_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM36_enable_w                  ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM36_enable_h0                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM36_enable_b1                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM26_mask_w                    ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM26_mask_h0                   ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM26_mask_b1                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM26_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM26_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM26_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM26_enable_w                  ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM26_enable_h0                 ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM26_enable_b1                 ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM20_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM20_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM20_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM20_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM20_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM20_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM20_enable_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM20_enable_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM20_enable_b1                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM16_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM16_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM16_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM16_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM16_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM16_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM16_enable_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM16_enable_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM16_enable_b0                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM10_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM10_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM10_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM10_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM10_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM10_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM10_enable_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM10_enable_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM10_enable_b0                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM01_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM01_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM01_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM01_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM01_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM01_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM01_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM01_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM01_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_SLP1_SLP_TM00_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_SLP1_SLP_TM00_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_SLP1_SLP_TM00_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_SLP1_SLP_TM00_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_SLP1_SLP_TM00_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_SLP1_SLP_TM00_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_SLP1_SLP_TM00_enable_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_SLP1_SLP_TM00_enable_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_SLP1_SLP_TM00_enable_b0                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_STP0  [register's definitions]
 *              Offset[0x38]  CSC STOP mode clock enable register 0 (0x4C010038)
 ******************************************************************************
 */
///@{
#define CSC_STP0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_STP0 */
#define CSC_STP0_STP_IWDT_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CSC_STP0_STP_IWDT_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_STP0_STP_IWDT_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_STP0_STP_IWDT_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_STP0_STP_IWDT_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_STP0_STP_IWDT_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_STP0_STP_IWDT_enable_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_STP0_STP_IWDT_enable_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_STP0_STP_IWDT_enable_b0                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CSC_STP0_STP_RTC_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_STP0_STP_RTC_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_STP0_STP_RTC_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_STP0_STP_RTC_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CSC_STP0_STP_RTC_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CSC_STP0_STP_RTC_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CSC_STP0_STP_RTC_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define CSC_STP0_STP_RTC_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define CSC_STP0_STP_RTC_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_CKS0  [register's definitions]
 *              Offset[0x40]  CSC clock source select register 0 (0x4C010040)
 ******************************************************************************
 */
///@{
#define CSC_CKS0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_CKS0 */
#define CSC_CKS0_APX_CKS_mask_w                     ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define CSC_CKS0_APX_CKS_mask_h0                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CSC_CKS0_APX_CKS_mask_b1                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_CKS0_APX_CKS_ck_apb_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS0_APX_CKS_ck_apb_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS0_APX_CKS_ck_apb_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS0_APX_CKS_ck_ahb_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS0_APX_CKS_ck_ahb_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS0_APX_CKS_ck_ahb_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS0_USB_CKS_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_CKS0_USB_CKS_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_CKS0_USB_CKS_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS0_USB_CKS_ck_pll_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):CK_PLL of 32bit */
#define CSC_CKS0_USB_CKS_ck_pll_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):CK_PLL of 16bit */
#define CSC_CKS0_USB_CKS_ck_pll_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):CK_PLL of 8bit */
#define CSC_CKS0_USB_CKS_ck_sys_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(1):CK_SYS of 32bit */
#define CSC_CKS0_USB_CKS_ck_sys_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(1):CK_SYS of 16bit */
#define CSC_CKS0_USB_CKS_ck_sys_b1                  ((uint8_t )0x01)        /*!< Bit Value =(1):CK_SYS of 8bit */

#define CSC_CKS0_DAC_CKS_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CSC_CKS0_DAC_CKS_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CSC_CKS0_DAC_CKS_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CSC_CKS0_DAC_CKS_ck_apb_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS0_DAC_CKS_ck_apb_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS0_DAC_CKS_ck_apb_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS0_DAC_CKS_ck_ahb_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS0_DAC_CKS_ck_ahb_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS0_DAC_CKS_ck_ahb_b0                  ((uint8_t )0x20)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS0_CMP_CKS_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CSC_CKS0_CMP_CKS_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_CKS0_CMP_CKS_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_CKS0_CMP_CKS_ck_apb_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS0_CMP_CKS_ck_apb_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS0_CMP_CKS_ck_apb_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS0_CMP_CKS_ck_ahb_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS0_CMP_CKS_ck_ahb_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS0_CMP_CKS_ck_ahb_b0                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS0_ADC0_CKS_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_CKS0_ADC0_CKS_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CKS0_ADC0_CKS_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS0_ADC0_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS0_ADC0_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS0_ADC0_CKS_ck_apb_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS0_ADC0_CKS_ck_ahb_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS0_ADC0_CKS_ck_ahb_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS0_ADC0_CKS_ck_ahb_b0                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_CKS1  [register's definitions]
 *              Offset[0x44]  CSC clock source select register 1 (0x4C010044)
 ******************************************************************************
 */
///@{
#define CSC_CKS1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_CKS1 */
#define CSC_CKS1_URT7_CKS_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT7_CKS_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT7_CKS_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT7_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT7_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT7_CKS_ck_apb_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT7_CKS_ck_ahb_w                  ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT7_CKS_ck_ahb_h1                 ((uint16_t)0x4000)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT7_CKS_ck_ahb_b3                 ((uint8_t )0x40)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_URT6_CKS_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT6_CKS_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT6_CKS_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT6_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT6_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT6_CKS_ck_apb_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT6_CKS_ck_ahb_w                  ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT6_CKS_ck_ahb_h1                 ((uint16_t)0x1000)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT6_CKS_ck_ahb_b3                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_URT5_CKS_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT5_CKS_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT5_CKS_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT5_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT5_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT5_CKS_ck_apb_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT5_CKS_ck_ahb_w                  ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT5_CKS_ck_ahb_h1                 ((uint16_t)0x0400)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT5_CKS_ck_ahb_b3                 ((uint8_t )0x04)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_URT4_CKS_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT4_CKS_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT4_CKS_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT4_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT4_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT4_CKS_ck_apb_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT4_CKS_ck_ahb_w                  ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT4_CKS_ck_ahb_h1                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT4_CKS_ck_ahb_b3                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_URT2_CKS_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT2_CKS_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT2_CKS_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT2_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT2_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT2_CKS_ck_apb_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT2_CKS_ck_ahb_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT2_CKS_ck_ahb_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT2_CKS_ck_ahb_b2                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_URT1_CKS_mask_w                    ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT1_CKS_mask_h1                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT1_CKS_mask_b2                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT1_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT1_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT1_CKS_ck_apb_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT1_CKS_ck_ahb_w                  ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT1_CKS_ck_ahb_h1                 ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT1_CKS_ck_ahb_b2                 ((uint8_t )0x04)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_URT0_CKS_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_URT0_CKS_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_URT0_CKS_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_URT0_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_URT0_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_URT0_CKS_ck_apb_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_URT0_CKS_ck_ahb_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_URT0_CKS_ck_ahb_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_URT0_CKS_ck_ahb_b2                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_SPI0_CKS_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_SPI0_CKS_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_SPI0_CKS_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_SPI0_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_SPI0_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_SPI0_CKS_ck_apb_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_SPI0_CKS_ck_ahb_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_SPI0_CKS_ck_ahb_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_SPI0_CKS_ck_ahb_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_I2C1_CKS_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_I2C1_CKS_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_I2C1_CKS_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_I2C1_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_I2C1_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_I2C1_CKS_ck_apb_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_I2C1_CKS_ck_ahb_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_I2C1_CKS_ck_ahb_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_I2C1_CKS_ck_ahb_b0                 ((uint8_t )0x04)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS1_I2C0_CKS_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_CKS1_I2C0_CKS_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CKS1_I2C0_CKS_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS1_I2C0_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS1_I2C0_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS1_I2C0_CKS_ck_apb_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS1_I2C0_CKS_ck_ahb_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS1_I2C0_CKS_ck_ahb_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS1_I2C0_CKS_ck_ahb_b0                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CSC_CKS2  [register's definitions]
 *              Offset[0x48]  CSC clock source select register 2 (0x4C010048)
 ******************************************************************************
 */
///@{
#define CSC_CKS2_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CSC_CKS2 */
#define CSC_CKS2_TM36_CKS_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM36_CKS_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM36_CKS_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM36_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM36_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM36_CKS_ck_apb_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM36_CKS_ck_ahb_w                  ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM36_CKS_ck_ahb_h1                 ((uint16_t)0x4000)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM36_CKS_ck_ahb_b3                 ((uint8_t )0x40)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS2_TM26_CKS_mask_w                    ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM26_CKS_mask_h1                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM26_CKS_mask_b2                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM26_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM26_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM26_CKS_ck_apb_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM26_CKS_ck_ahb_w                  ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM26_CKS_ck_ahb_h1                 ((uint16_t)0x0040)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM26_CKS_ck_ahb_b2                 ((uint8_t )0x40)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS2_TM20_CKS_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM20_CKS_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM20_CKS_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM20_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM20_CKS_ck_apb_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM20_CKS_ck_apb_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM20_CKS_ck_ahb_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM20_CKS_ck_ahb_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM20_CKS_ck_ahb_b2                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS2_TM16_CKS_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM16_CKS_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM16_CKS_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM16_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM16_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM16_CKS_ck_apb_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM16_CKS_ck_ahb_w                  ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM16_CKS_ck_ahb_h0                 ((uint16_t)0x4000)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM16_CKS_ck_ahb_b1                 ((uint8_t )0x40)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS2_TM10_CKS_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM10_CKS_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM10_CKS_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM10_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM10_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM10_CKS_ck_apb_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM10_CKS_ck_ahb_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM10_CKS_ck_ahb_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM10_CKS_ck_ahb_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS2_TM01_CKS_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM01_CKS_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM01_CKS_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM01_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM01_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM01_CKS_ck_apb_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM01_CKS_ck_ahb_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM01_CKS_ck_ahb_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM01_CKS_ck_ahb_b0                 ((uint8_t )0x04)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

#define CSC_CKS2_TM00_CKS_mask_w                    ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CSC_CKS2_TM00_CKS_mask_h0                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CSC_CKS2_TM00_CKS_mask_b0                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CSC_CKS2_TM00_CKS_ck_apb_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_APB of 32bit */
#define CSC_CKS2_TM00_CKS_ck_apb_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_APB of 16bit */
#define CSC_CKS2_TM00_CKS_ck_apb_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_APB of 8bit */
#define CSC_CKS2_TM00_CKS_ck_ahb_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):CK_AHB of 32bit */
#define CSC_CKS2_TM00_CKS_ck_ahb_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):CK_AHB of 16bit */
#define CSC_CKS2_TM00_CKS_ck_ahb_b0                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CK_AHB of 8bit */

///@}

#endif  // _MG32_CSC_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_CSC.h                           */
/*----------------------------------------------------------------------------*/
