

/**
 ******************************************************************************
 *
 * @file        MG32_Wheel_API.c
 * @brief       
 
 * @par         Project
 *              Mouse
 * @version     V1.01
 * @date        2025/06/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_API.h"
#include "MG32_Wheel_API.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
WheelCTR_TypeDef Wheel_CTR;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/  
 

/**
 *******************************************************************************
 * @brief	   Wheel initial. 
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */ 
void API_Wheel_Init(void)
{
    /*GPIO mode initial*/
    GPIO_PinConfig( WHEEL_ZA_IOM_PIN, Data_DIR_IN_RU, WHEEL_ZA_IOM_AFS);
    GPIO_PinConfig( WHEEL_ZB_IOM_PIN, Data_DIR_IN_RU, WHEEL_ZB_IOM_AFS);
        
    /*GPIO filter
    1. Filter clock source is AHB / 8 (24M / 8)
    2. Pin input deglitch filter clock divider is /16
    3. It can filter less than 600ns signal.
    */
    GPIO_PortFilterClockSource_Select(WHEEL_IOM_PORT,GPIO_FT_CLK_AHB_DIV8);
    GPIO_PinInFilterDivider_Select( WHEEL_ZA_IOM_PIN, PINX_FilterDivider_16);
    GPIO_PinInFilterDivider_Select( WHEEL_ZB_IOM_PIN, PINX_FilterDivider_16);
    
    /*Parameter*/
    Wheel_CTR.Wheel_ChangeFlag  = 0;
    Wheel_CTR.Wheel_Data        = 0;
    Wheel_CTR.Wheel_Status.W    = 0;
    Wheel_CTR.Wheel_Status.B[0] = API_Wheel_GetStatus();
}

/**
 *******************************************************************************
 * @brief	   Simple flow for that detect wheel status. 
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */ 
void API_Wheel_DetectStatus(void)
{
    uint8_t API_Wheel_DetectStatusTmp;

       
    API_Wheel_DetectStatusTmp = API_Wheel_GetStatus();
   
    if( Wheel_CTR.Wheel_Status.B[0] == API_Wheel_DetectStatusTmp)
    {
        return;
    }

    Wheel_CTR.Wheel_Status.B[2] = Wheel_CTR.Wheel_Status.B[1];
    Wheel_CTR.Wheel_Status.B[1] = Wheel_CTR.Wheel_Status.B[0];
    Wheel_CTR.Wheel_Status.B[0] = API_Wheel_DetectStatusTmp;
    

    switch(( Wheel_CTR.Wheel_Status.W & WHEEL_STATE_MASK))
    {
        case 0x00001011:
        case 0x00110100:
                        Wheel_CTR.Wheel_Data = Wheel_CTR.Wheel_Data + 1;
                        break;
        case 0x00000111:
        case 0x00111000:
                        Wheel_CTR.Wheel_Data = Wheel_CTR.Wheel_Data - 1;
                        break;
        default:
                        return;
    }
    
    Wheel_CTR.Wheel_ChangeFlag = 1;
}

/**
 *******************************************************************************
 * @brief      Get wheel status
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */ 
uint8_t API_Wheel_GetStatus(void)
{
    uint8_t API_Wheel_GetStatusTmp;
      
    API_Wheel_GetStatusTmp  = ((uint8_t)(PB1 << 4)); 
    API_Wheel_GetStatusTmp |= ((uint8_t)PB0); 
    return(API_Wheel_GetStatusTmp);
}













