
/**
 ******************************************************************************
 *
 * @file        font24.c
 * @brief       This is a raw data of character (mono color). 
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2025/07/14
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

// Bitmap raw data, size: 17 x 24 (per character)
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
        __ALIGNED(4) const uint8_t Font24_Table[] = {
    #pragma clang diagnostic pop
#else
    __ALIGNED(4) const uint8_t Font24_Table[] = {
#endif
    // ASCII: space, Dec=32, Hex=0x20 
	// @0 ' ' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: !, Dec=33, Hex=0x21 
	// @72 '!' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ", Dec=34, Hex=0x22
	// @144 '"' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0E, 0x70, 0x00, //     ###  ###     
	0x0E, 0x70, 0x00, //     ###  ###     
	0x0E, 0x70, 0x00, //     ###  ###     
	0x04, 0x20, 0x00, //      #    #      
	0x04, 0x20, 0x00, //      #    #      
	0x04, 0x20, 0x00, //      #    #      
	0x04, 0x20, 0x00, //      #    #      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: #, Dec=35, Hex=0x23
	// @216 '#' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: $, Dec=36, Hex=0x24
	// @288 '$' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x07, 0xB0, 0x00, //      #### ##     
	0x0F, 0xF0, 0x00, //     ########     
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x70, 0x00, //    ##    ###     
	0x1C, 0x00, 0x00, //    ###           
	0x0F, 0x80, 0x00, //     #####        
	0x07, 0xE0, 0x00, //      ######      
	0x00, 0xF0, 0x00, //         ####     
	0x18, 0x30, 0x00, //    ##     ##     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x1C, 0x70, 0x00, //    ###   ###     
	0x1F, 0xE0, 0x00, //    ########      
	0x1B, 0xC0, 0x00, //    ## ####       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: %, Dec=37, Hex=0x25
	// @360 '%' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0x80, 0x00, //      ####        
	0x0F, 0xC0, 0x00, //     ######       
	0x1C, 0xE0, 0x00, //    ###  ###      
	0x18, 0x60, 0x00, //    ##    ##      
	0x18, 0x60, 0x00, //    ##    ##      
	0x1C, 0xE0, 0x00, //    ###  ###      
	0x0F, 0xF8, 0x00, //     #########    
	0x07, 0xE0, 0x00, //      ######      
	0x1F, 0xF0, 0x00, //    #########     
	0x07, 0x38, 0x00, //      ###  ###    
	0x06, 0x18, 0x00, //      ##    ##    
	0x06, 0x18, 0x00, //      ##    ##    
	0x07, 0x38, 0x00, //      ###  ###    
	0x03, 0xF0, 0x00, //       ######     
	0x01, 0xE0, 0x00, //        ####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: &, Dec=38, Hex=0x26
	// @432 '&' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xF0, 0x00, //       ######     
	0x07, 0xF0, 0x00, //      #######     
	0x0C, 0x60, 0x00, //     ##   ##      
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x06, 0x00, 0x00, //      ##          
	0x07, 0x00, 0x00, //      ###         
	0x0F, 0x9C, 0x00, //     #####  ###   
	0x1D, 0xFC, 0x00, //    ### #######   
	0x18, 0xF0, 0x00, //    ##   ####     
	0x18, 0x70, 0x00, //    ##    ###     
	0x0F, 0xFC, 0x00, //     ##########   
	0x07, 0xDC, 0x00, //      ##### ###   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ', Dec=39, Hex=0x27
	// @504 ''' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x01, 0x00, 0x00, //        #         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: (, Dec=40, Hex=0x28
	// @576 '(' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x70, 0x00, //          ###     
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ), Dec=41, Hex=0x29
	// @648 ')' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x18, 0x00, 0x00, //    ##            
	0x1C, 0x00, 0x00, //    ###           
	0x0E, 0x00, 0x00, //     ###          
	0x0E, 0x00, 0x00, //     ###          
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x00, 0x00, //      ###         
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x80, 0x00, //       ###        
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x00, 0x00, //      ###         
	0x0F, 0x00, 0x00, //     ####         
	0x0E, 0x00, 0x00, //     ###          
	0x1C, 0x00, 0x00, //    ###           
	0x18, 0x00, 0x00, //    ##            
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: *, Dec=42, Hex=0x2A
	// @720 '*' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x1D, 0xB8, 0x00, //    ### ## ###    
	0x1F, 0xF8, 0x00, //    ##########    
	0x07, 0xE0, 0x00, //      ######      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: +, Dec=43, Hex=0x2B
	// @792 '+' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ,, Dec=44, Hex=0x2C
	// @864 ',' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x00, 0x00, //       ##         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: -, Dec=45, Hex=0x2D
	// @936 '-' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ., Dec=46, Hex=0x2E
	// @1008 '.' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: /, Dec=47, Hex=0x2F
	// @1080 '/' (17 pixels wide)
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x00, 0x00, //       ##         
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x0E, 0x00, 0x00, //     ###          
	0x0C, 0x00, 0x00, //     ##           
	0x1C, 0x00, 0x00, //    ###           
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: 0, Dec=48, Hex=0x30
	// @1152 '0' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x07, 0xE0, 0x00, //      ######      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x07, 0xE0, 0x00, //      ######      
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: 1, Dec=49, Hex=0x31
	// @1224 '1' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x80, 0x00, //         #        
	0x07, 0x80, 0x00, //      ####        
	0x1F, 0x80, 0x00, //    ######        
	0x1D, 0x80, 0x00, //    ### ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1296 '2' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xC0, 0x00, //      #####       
	0x1F, 0xF0, 0x00, //    #########     
	0x38, 0x30, 0x00, //   ###     ##     
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x60, 0x00, //          ##      
	0x01, 0xC0, 0x00, //        ###       
	0x03, 0x80, 0x00, //       ###        
	0x06, 0x00, 0x00, //      ##          
	0x0C, 0x00, 0x00, //     ##           
	0x18, 0x00, 0x00, //    ##            
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1368 '3' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xE0, 0x00, //     #######      
	0x0C, 0x70, 0x00, //     ##   ###     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x60, 0x00, //          ##      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xE0, 0x00, //       #####      
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x0F, 0xC0, 0x00, //     ######       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1440 '4' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xE0, 0x00, //        ####      
	0x01, 0xE0, 0x00, //        ####      
	0x03, 0x60, 0x00, //       ## ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x18, 0x60, 0x00, //    ##    ##      
	0x30, 0x60, 0x00, //   ##     ##      
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x00, 0x60, 0x00, //          ##      
	0x03, 0xF8, 0x00, //       #######    
	0x03, 0xF8, 0x00, //       #######    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1512 '5' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xF0, 0x00, //    #########     
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xC0, 0x00, //    ## ####       
	0x1F, 0xF0, 0x00, //    #########     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x30, 0x30, 0x00, //   ##      ##     
	0x3F, 0xF0, 0x00, //   ##########     
	0x0F, 0xC0, 0x00, //     ######       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1584 '6' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xF8, 0x00, //         #####    
	0x03, 0xF8, 0x00, //       #######    
	0x07, 0x00, 0x00, //      ###         
	0x0E, 0x00, 0x00, //     ###          
	0x0C, 0x00, 0x00, //     ##           
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xC0, 0x00, //    ## ####       
	0x1F, 0xF0, 0x00, //    #########     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x38, 0x00, //     ##    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xE0, 0x00, //       #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1656 '7' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @1728 '8' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xE0, 0x00, //      ######      
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x07, 0xE0, 0x00, //      ######      
	0x07, 0xE0, 0x00, //      ######      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x07, 0xE0, 0x00, //      ######      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: 9, Dec=57, Hex=0x39
	// @1800 '9' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xC0, 0x00, //      #####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x30, 0x00, //    ###    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x38, 0x00, //     ##    ###    
	0x0F, 0xF8, 0x00, //     #########    
	0x03, 0xD8, 0x00, //       #### ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0xE0, 0x00, //         ###      
	0x1F, 0xC0, 0x00, //    #######       
	0x1F, 0x00, 0x00, //    #####         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: :, Dec=58, Hex=0x3A
	// @1872 ':' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ;, Dec=59, Hex=0x3B
	// @1944 ';' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x02, 0x00, 0x00, //       #          
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: <, Dec=60, Hex=0x3C
	// @2016 '<' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x1C, 0x00, //            ###   
	0x00, 0x3C, 0x00, //           ####   
	0x00, 0xF0, 0x00, //         ####     
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0x00, 0x00, //     ####         
	0x3C, 0x00, 0x00, //   ####           
	0xF0, 0x00, 0x00, // ####             
	0x3C, 0x00, 0x00, //   ####           
	0x0F, 0x00, 0x00, //     ####         
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0xF0, 0x00, //         ####     
	0x00, 0x3C, 0x00, //           ####   
	0x00, 0x1C, 0x00, //            ###   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: =, Dec=61, Hex=0x3D
	// @2088 '=' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xFC, 0x00, //  #############   
	0x7F, 0xFC, 0x00, //  #############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xFC, 0x00, //  #############   
	0x7F, 0xFC, 0x00, //  #############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: >, Dec=62, Hex=0x3E
	// @2160 '>' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x70, 0x00, 0x00, //  ###             
	0x78, 0x00, 0x00, //  ####            
	0x1E, 0x00, 0x00, //    ####          
	0x07, 0x80, 0x00, //      ####        
	0x01, 0xE0, 0x00, //        ####      
	0x00, 0x78, 0x00, //          ####    
	0x00, 0x1E, 0x00, //            ####  
	0x00, 0x78, 0x00, //          ####    
	0x01, 0xE0, 0x00, //        ####      
	0x07, 0x80, 0x00, //      ####        
	0x1E, 0x00, 0x00, //    ####          
	0x78, 0x00, 0x00, //  ####            
	0x70, 0x00, 0x00, //  ###             
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ?, Dec=63, Hex=0x3F
	// @2232 '?' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xC0, 0x00, //      #####       
	0x0F, 0xE0, 0x00, //     #######      
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x30, 0x00, //    ##     ##     
	0x00, 0x70, 0x00, //          ###     
	0x00, 0xE0, 0x00, //         ###      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0x80, 0x00, //       ###        
	0x03, 0x00, 0x00, //       ##         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x00, 0x00, //      ###         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: @, Dec=64, Hex=0x40
	// @2304 '@' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xE0, 0x00, //       #####      
	0x07, 0xF0, 0x00, //      #######     
	0x0E, 0x38, 0x00, //     ###   ###    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x18, 0x78, 0x00, //    ##    ####    
	0x18, 0xF8, 0x00, //    ##   #####    
	0x19, 0xD8, 0x00, //    ##  ### ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x18, 0xF8, 0x00, //    ##   #####    
	0x18, 0x78, 0x00, //    ##    ####    
	0x18, 0x00, 0x00, //    ##            
	0x0C, 0x00, 0x00, //     ##           
	0x0E, 0x18, 0x00, //     ###    ##    
	0x07, 0xF8, 0x00, //      ########    
	0x03, 0xE0, 0x00, //       #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: A, Dec=65, Hex=0x41
	// @2376 'A' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0xC0, 0x00, //    #######       
	0x01, 0xC0, 0x00, //        ###       
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0x60, 0x00, //       ## ##      
	0x06, 0x30, 0x00, //      ##   ##     
	0x06, 0x30, 0x00, //      ##   ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0F, 0xF8, 0x00, //     #########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0xFC, 0x7F, 0x00, // ######   ####### 
	0xFC, 0x7F, 0x00, // ######   ####### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: B, Dec=66, Hex=0x42
	// @2448 'B' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xE0, 0x00, //  ##########      
	0x7F, 0xF0, 0x00, //  ###########     
	0x18, 0x38, 0x00, //    ##     ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x1C, 0x00, //    ##      ###   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x7F, 0xF8, 0x00, //  ############    
	0x7F, 0xF0, 0x00, //  ###########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2520 'C' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xEC, 0x00, //       ##### ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x0F, 0xF8, 0x00, //     #########    
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2592 'D' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xC0, 0x00, //  #########       
	0x7F, 0xF0, 0x00, //  ###########     
	0x18, 0x38, 0x00, //    ##     ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0xF0, 0x00, //  ###########     
	0x7F, 0xE0, 0x00, //  ##########      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2664 'E' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xF8, 0x00, //  ############    
	0x7F, 0xF8, 0x00, //  ############    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x19, 0x80, 0x00, //    ##  ##        
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0x80, 0x00, //    ######        
	0x19, 0x80, 0x00, //    ##  ##        
	0x19, 0x98, 0x00, //    ##  ##  ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7F, 0xF8, 0x00, //  ############    
	0x7F, 0xF8, 0x00, //  ############    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2736 'F' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0xCC, 0x00, //     ##  ##  ##   
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0F, 0xC0, 0x00, //     ######       
	0x0F, 0xC0, 0x00, //     ######       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x3F, 0xC0, 0x00, //   ########       
	0x3F, 0xC0, 0x00, //   ########       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2808 'G' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xEC, 0x00, //       ##### ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x30, 0xFE, 0x00, //   ##    #######  
	0x30, 0xFE, 0x00, //   ##    #######  
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x0C, 0x00, //   ###       ##   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x0F, 0xFC, 0x00, //     ##########   
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2880 'H' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2952 'I' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3024 'J' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xFE, 0x00, //      ##########  
	0x07, 0xFE, 0x00, //      ##########  
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x60, 0x00, //   ##     ##      
	0x3F, 0xE0, 0x00, //   #########      
	0x0F, 0x80, 0x00, //     #####        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3096 'K' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0x3E, 0x00, //  #######  #####  
	0x7F, 0x3E, 0x00, //  #######  #####  
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x60, 0x00, //    ##    ##      
	0x18, 0xC0, 0x00, //    ##   ##       
	0x19, 0x80, 0x00, //    ##  ##        
	0x1B, 0x80, 0x00, //    ## ###        
	0x1F, 0xC0, 0x00, //    #######       
	0x1C, 0xE0, 0x00, //    ###  ###      
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0x1F, 0x00, //  #######   ##### 
	0x7F, 0x1F, 0x00, //  #######   ##### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3168 'L' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0x80, 0x00, //  ########        
	0x7F, 0x80, 0x00, //  ########        
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x7F, 0xFC, 0x00, //  #############   
	0x7F, 0xFC, 0x00, //  #############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3240 'M' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xF0, 0x0F, 0x00, // ####        #### 
	0xF8, 0x1F, 0x00, // #####      ##### 
	0x38, 0x1C, 0x00, //   ###      ###   
	0x3C, 0x3C, 0x00, //   ####    ####   
	0x3C, 0x3C, 0x00, //   ####    ####   
	0x36, 0x6C, 0x00, //   ## ##  ## ##   
	0x36, 0x6C, 0x00, //   ## ##  ## ##   
	0x33, 0xCC, 0x00, //   ##  ####  ##   
	0x33, 0xCC, 0x00, //   ##  ####  ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0xFE, 0x7F, 0x00, // #######  ####### 
	0xFE, 0x7F, 0x00, // #######  ####### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3312 'N' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0xFE, 0x00, //  ####   #######  
	0x78, 0xFE, 0x00, //  ####   #######  
	0x1C, 0x18, 0x00, //    ###     ##    
	0x1E, 0x18, 0x00, //    ####    ##    
	0x1F, 0x18, 0x00, //    #####   ##    
	0x1B, 0x18, 0x00, //    ## ##   ##    
	0x1B, 0x98, 0x00, //    ## ###  ##    
	0x19, 0xD8, 0x00, //    ##  ### ##    
	0x18, 0xD8, 0x00, //    ##   ## ##    
	0x18, 0xF8, 0x00, //    ##   #####    
	0x18, 0x78, 0x00, //    ##    ####    
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0x18, 0x00, //  #######   ##    
	0x7F, 0x18, 0x00, //  #######   ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3384 'O' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x38, 0x1C, 0x00, //   ###      ###   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x1C, 0x00, //   ###      ###   
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3456 'P' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF8, 0x00, //   ###########    
	0x0C, 0x1C, 0x00, //     ##     ###   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x0C, 0x00, //     ##      ##   
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0F, 0xF8, 0x00, //     #########    
	0x0F, 0xE0, 0x00, //     #######      
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x3F, 0xC0, 0x00, //   ########       
	0x3F, 0xC0, 0x00, //   ########       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3528 'Q' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x38, 0x1C, 0x00, //   ###      ###   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x1C, 0x00, //   ###      ###   
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x07, 0xC0, 0x00, //      #####       
	0x07, 0xCC, 0x00, //      #####  ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x0C, 0x38, 0x00, //     ##    ###    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3600 'R' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0xE0, 0x00, //  ##########      
	0x7F, 0xF0, 0x00, //  ###########     
	0x18, 0x38, 0x00, //    ##     ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xC0, 0x00, //    #######       
	0x18, 0xE0, 0x00, //    ##   ###      
	0x18, 0x70, 0x00, //    ##    ###     
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x38, 0x00, //    ##     ###    
	0x7F, 0x1E, 0x00, //  #######   ####  
	0x7F, 0x0E, 0x00, //  #######    ###  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3672 'S' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xD8, 0x00, //      ##### ##    
	0x0F, 0xF8, 0x00, //     #########    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1E, 0x00, 0x00, //    ####          
	0x0F, 0xC0, 0x00, //     ######       
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x78, 0x00, //          ####    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1C, 0x38, 0x00, //    ###    ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1B, 0xE0, 0x00, //    ## #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3744 'T' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x0F, 0xF0, 0x00, //     ########     
	0x0F, 0xF0, 0x00, //     ########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3816 'U' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3888 'V' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7F, 0x7F, 0x00, //  ####### ####### 
	0x7F, 0x7F, 0x00, //  ####### ####### 
	0x18, 0x0C, 0x00, //    ##       ##   
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x06, 0x30, 0x00, //      ##   ##     
	0x06, 0x30, 0x00, //      ##   ##     
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0x60, 0x00, //       ## ##      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0x80, 0x00, //         #        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @3960 'W' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xFE, 0x3F, 0x80, // #######   #######
	0xFE, 0x3F, 0x80, // #######   #######
	0x30, 0x06, 0x00, //   ##         ##  
	0x30, 0x06, 0x00, //   ##         ##  
	0x30, 0x86, 0x00, //   ##    #    ##  
	0x19, 0xCC, 0x00, //    ##  ###  ##   
	0x19, 0xCC, 0x00, //    ##  ###  ##   
	0x1B, 0x6C, 0x00, //    ## ## ## ##   
	0x1B, 0x6C, 0x00, //    ## ## ## ##   
	0x1E, 0x7C, 0x00, //    ####  #####   
	0x0E, 0x38, 0x00, //     ###   ###    
	0x0E, 0x38, 0x00, //     ###   ###    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4032 'X' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x03, 0xC0, 0x00, //       ####       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0xC0, 0x00, //       ####       
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4104 'Y' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7C, 0x7E, 0x00, //  #####   ######  
	0x7C, 0x7E, 0x00, //  #####   ######  
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x03, 0xC0, 0x00, //       ####       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x0F, 0xF0, 0x00, //     ########     
	0x0F, 0xF0, 0x00, //     ########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: Z, Dec=90, Hex=0x5A
	// @4176 'Z' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x60, 0x00, //    ##    ##      
	0x18, 0xC0, 0x00, //    ##   ##       
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x06, 0x18, 0x00, //      ##    ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: [, Dec=91, Hex=0x5B
	// @4248 '[' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0xF0, 0x00, //        #####     
	0x01, 0xF0, 0x00, //        #####     
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0xF0, 0x00, //        #####     
	0x01, 0xF0, 0x00, //        #####     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: \, Dec=92, Hex=0x5C
	// @4320 '\' (17 pixels wide)
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1C, 0x00, 0x00, //    ###           
	0x0C, 0x00, 0x00, //     ##           
	0x0E, 0x00, 0x00, //     ###          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x00, 0x00, //       ##         
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x70, 0x00, //          ###     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x38, 0x00, //           ###    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ], Dec=93, Hex=0x5D
	// @4392 ']' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0F, 0x80, 0x00, //     #####        
	0x0F, 0x80, 0x00, //     #####        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x0F, 0x80, 0x00, //     #####        
	0x0F, 0x80, 0x00, //     #####        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ^, Dec=94, Hex=0x5E
	// @4464 '^' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x80, 0x00, //         #        
	0x01, 0xC0, 0x00, //        ###       
	0x03, 0xE0, 0x00, //       #####      
	0x07, 0x70, 0x00, //      ### ###     
	0x06, 0x30, 0x00, //      ##   ##     
	0x0C, 0x18, 0x00, //     ##     ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x10, 0x04, 0x00, //    #         #   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: _, Dec=95, Hex=0x5F
	// @4536 '_' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xFF, 0xFF, 0x00, // ################ 
	0xFF, 0xFF, 0x00, // ################ 

    // ASCII: ', Dec=96, Hex=0x60
	// @4608 '`' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x03, 0x00, 0x00, //       ##         
	0x03, 0x80, 0x00, //       ###        
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x60, 0x00, //          ##      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: a, Dec=97, Hex=0x61
	// @4680 'a' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0F, 0xC0, 0x00, //     ######       
	0x1F, 0xE0, 0x00, //    ########      
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x07, 0xF0, 0x00, //      #######     
	0x1F, 0xF0, 0x00, //    #########     
	0x38, 0x30, 0x00, //   ###     ##     
	0x30, 0x30, 0x00, //   ##      ##     
	0x30, 0x70, 0x00, //   ##     ###     
	0x1F, 0xFC, 0x00, //    ###########   
	0x0F, 0xBC, 0x00, //     ##### ####   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: b, Dec=98, Hex=0x62
	// @4752 'b' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x00, 0x00, //  ####            
	0x78, 0x00, 0x00, //  ####            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xE0, 0x00, //    ## #####      
	0x1F, 0xF8, 0x00, //    ##########    
	0x1C, 0x18, 0x00, //    ###     ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1C, 0x18, 0x00, //    ###     ##    
	0x7F, 0xF8, 0x00, //  ############    
	0x7B, 0xE0, 0x00, //  #### #####      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4824 'c' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xEC, 0x00, //       ##### ##   
	0x0F, 0xFC, 0x00, //     ##########   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x38, 0x0C, 0x00, //   ###       ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x38, 0x0C, 0x00, //   ###       ##   
	0x1C, 0x1C, 0x00, //    ###     ###   
	0x0F, 0xF8, 0x00, //     #########    
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4896 'd' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x78, 0x00, //          ####    
	0x00, 0x78, 0x00, //          ####    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x07, 0xD8, 0x00, //      ##### ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x38, 0x00, //    ##     ###    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xFE, 0x00, //    ############  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @4968 'e' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xE0, 0x00, //      ######      
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x30, 0x0C, 0x00, //   ##        ##   
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x30, 0x00, 0x00, //   ##             
	0x30, 0x00, 0x00, //   ##             
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1F, 0xFC, 0x00, //    ###########   
	0x07, 0xF0, 0x00, //      #######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5040 'f' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0xFC, 0x00, //        #######   
	0x03, 0xFC, 0x00, //       ########   
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x3F, 0xF8, 0x00, //   ###########    
	0x3F, 0xF8, 0x00, //   ###########    
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF0, 0x00, //   ##########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5112 'g' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x1F, 0xFE, 0x00, //    ############  
	0x18, 0x38, 0x00, //    ##     ###    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF8, 0x00, //    ##########    
	0x07, 0xD8, 0x00, //      ##### ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x38, 0x00, //           ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x0F, 0xC0, 0x00, //     ######       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5184 'h' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x00, 0x00, //  ####            
	0x78, 0x00, 0x00, //  ####            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x1B, 0xE0, 0x00, //    ## #####      
	0x1F, 0xF0, 0x00, //    #########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5256 'i' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0x80, 0x00, //    ######        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5328 'j' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0xC0, 0x00, //         ##       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xF0, 0x00, //    #########     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x70, 0x00, //          ###     
	0x1F, 0xE0, 0x00, //    ########      
	0x1F, 0x80, 0x00, //    ######        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5400 'k' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3C, 0x00, 0x00, //   ####           
	0x3C, 0x00, 0x00, //   ####           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0xF8, 0x00, //     ##  #####    
	0x0C, 0xF8, 0x00, //     ##  #####    
	0x0C, 0xC0, 0x00, //     ##  ##       
	0x0D, 0x80, 0x00, //     ## ##        
	0x0F, 0x80, 0x00, //     #####        
	0x0F, 0x00, 0x00, //     ####         
	0x0F, 0x80, 0x00, //     #####        
	0x0D, 0xC0, 0x00, //     ## ###       
	0x0C, 0xE0, 0x00, //     ##  ###      
	0x3C, 0x7C, 0x00, //   ####   #####   
	0x3C, 0x7C, 0x00, //   ####   #####   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5472 'l' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0x80, 0x00, //    ######        
	0x1F, 0x80, 0x00, //    ######        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x3F, 0xFC, 0x00, //   ############   
	0x3F, 0xFC, 0x00, //   ############   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5544 'm' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0xF7, 0x78, 0x00, // #### ### ####    
	0xFF, 0xFC, 0x00, // ##############   
	0x39, 0xCC, 0x00, //   ###  ###  ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0x31, 0x8C, 0x00, //   ##   ##   ##   
	0xFD, 0xEF, 0x00, // ###### #### #### 
	0xFD, 0xEF, 0x00, // ###### #### #### 
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5616 'n' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7B, 0xE0, 0x00, //  #### #####      
	0x7F, 0xF0, 0x00, //  ###########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x7E, 0x7E, 0x00, //  ######  ######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5688 'o' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x03, 0xC0, 0x00, //       ####       
	0x0F, 0xF0, 0x00, //     ########     
	0x1C, 0x38, 0x00, //    ###    ###    
	0x38, 0x1C, 0x00, //   ###      ###   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x30, 0x0C, 0x00, //   ##        ##   
	0x38, 0x1C, 0x00, //   ###      ###   
	0x1C, 0x38, 0x00, //    ###    ###    
	0x0F, 0xF0, 0x00, //     ########     
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5760 'p' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7B, 0xE0, 0x00, //  #### #####      
	0x7F, 0xF8, 0x00, //  ############    
	0x1C, 0x18, 0x00, //    ###     ##    
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x18, 0x0C, 0x00, //    ##       ##   
	0x1C, 0x18, 0x00, //    ###     ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x1B, 0xE0, 0x00, //    ## #####      
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x18, 0x00, 0x00, //    ##            
	0x7F, 0x00, 0x00, //  #######         
	0x7F, 0x00, 0x00, //  #######         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5832 'q' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x1F, 0xFE, 0x00, //    ############  
	0x18, 0x38, 0x00, //    ##     ###    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x30, 0x18, 0x00, //   ##       ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF8, 0x00, //    ##########    
	0x07, 0xD8, 0x00, //      ##### ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x18, 0x00, //            ##    
	0x00, 0xFE, 0x00, //         #######  
	0x00, 0xFE, 0x00, //         #######  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5904 'r' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3E, 0x78, 0x00, //   #####  ####    
	0x3E, 0xFC, 0x00, //   ##### ######   
	0x07, 0xCC, 0x00, //      #####  ##   
	0x07, 0x00, 0x00, //      ###         
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x06, 0x00, 0x00, //      ##          
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF0, 0x00, //   ##########     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @5976 's' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0xF8, 0x00, //      ########    
	0x0F, 0xF8, 0x00, //     #########    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x1F, 0x80, 0x00, //    ######        
	0x0F, 0xF0, 0x00, //     ########     
	0x00, 0xF8, 0x00, //         #####    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x1F, 0xF0, 0x00, //    #########     
	0x1F, 0xE0, 0x00, //    ########      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6048 't' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x3F, 0xF0, 0x00, //   ##########     
	0x3F, 0xF0, 0x00, //   ##########     
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x00, 0x00, //     ##           
	0x0C, 0x1C, 0x00, //     ##     ###   
	0x07, 0xFC, 0x00, //      #########   
	0x03, 0xF0, 0x00, //       ######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6120 'u' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x78, 0x00, //  ####    ####    
	0x78, 0x78, 0x00, //  ####    ####    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x38, 0x00, //    ##     ###    
	0x0F, 0xFE, 0x00, //     ###########  
	0x07, 0xDE, 0x00, //      ##### ####  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6192 'v' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7C, 0x3E, 0x00, //  #####    #####  
	0x7C, 0x3E, 0x00, //  #####    #####  
	0x18, 0x18, 0x00, //    ##      ##    
	0x18, 0x18, 0x00, //    ##      ##    
	0x0C, 0x30, 0x00, //     ##    ##     
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x06, 0x60, 0x00, //      ##  ##      
	0x07, 0xE0, 0x00, //      ######      
	0x03, 0xC0, 0x00, //       ####       
	0x03, 0xC0, 0x00, //       ####       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6264 'w' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x78, 0x3C, 0x00, //  ####     ####   
	0x78, 0x3C, 0x00, //  ####     ####   
	0x31, 0x18, 0x00, //   ##   #   ##    
	0x33, 0x98, 0x00, //   ##  ###  ##    
	0x33, 0x98, 0x00, //   ##  ###  ##    
	0x1A, 0xB0, 0x00, //    ## # # ##     
	0x1E, 0xF0, 0x00, //    #### ####     
	0x1E, 0xF0, 0x00, //    #### ####     
	0x1C, 0x60, 0x00, //    ###   ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x0C, 0x60, 0x00, //     ##   ##      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6336 'x' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x0C, 0x30, 0x00, //     ##    ##     
	0x06, 0x60, 0x00, //      ##  ##      
	0x03, 0xC0, 0x00, //       ####       
	0x01, 0x80, 0x00, //        ##        
	0x03, 0xC0, 0x00, //       ####       
	0x06, 0x60, 0x00, //      ##  ##      
	0x0C, 0x30, 0x00, //     ##    ##     
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x3E, 0x7C, 0x00, //   #####  #####   
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @6408 'y' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x7E, 0x1F, 0x00, //  ######    ##### 
	0x7E, 0x1F, 0x00, //  ######    ##### 
	0x18, 0x0C, 0x00, //    ##       ##   
	0x0C, 0x18, 0x00, //     ##     ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x06, 0x30, 0x00, //      ##   ##     
	0x06, 0x30, 0x00, //      ##   ##     
	0x03, 0x60, 0x00, //       ## ##      
	0x03, 0xE0, 0x00, //       #####      
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x3F, 0xC0, 0x00, //   ########       
	0x3F, 0xC0, 0x00, //   ########       
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: z, Dec=122, Hex=0x7A
	// @6480 'z' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x18, 0x30, 0x00, //    ##     ##     
	0x18, 0x60, 0x00, //    ##    ##      
	0x00, 0xC0, 0x00, //         ##       
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x00, 0x00, //       ##         
	0x06, 0x18, 0x00, //      ##    ##    
	0x0C, 0x18, 0x00, //     ##     ##    
	0x1F, 0xF8, 0x00, //    ##########    
	0x1F, 0xF8, 0x00, //    ##########    
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: {, Dec=123, Hex=0x7B
	// @6552 '{' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xE0, 0x00, //        ####      
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x03, 0x80, 0x00, //       ###        
	0x07, 0x00, 0x00, //      ###         
	0x03, 0x80, 0x00, //       ###        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0xE0, 0x00, //        ####      
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: |, Dec=124, Hex=0x7C
	// @6624 '|' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: }, Dec=125, Hex=0x7D
	// @6696 '}' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x07, 0x00, 0x00, //      ###         
	0x07, 0x80, 0x00, //      ####        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0xC0, 0x00, //        ###       
	0x00, 0xE0, 0x00, //         ###      
	0x01, 0xC0, 0x00, //        ###       
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x01, 0x80, 0x00, //        ##        
	0x07, 0x80, 0x00, //      ####        
	0x07, 0x00, 0x00, //      ###         
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

    // ASCII: ~, Dec=126, Hex=0x7E
	// @6768 '~' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x0E, 0x00, 0x00, //     ###          
	0x1F, 0x18, 0x00, //    #####   ##    
	0x3B, 0xB8, 0x00, //   ### ### ###    
	0x31, 0xF0, 0x00, //   ##   #####     
	0x00, 0xE0, 0x00, //         ###      
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
};

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
