/**
 ******************************************************************************
 *
 * @file        MG32_MEM_Init.h
 *
 * @brief       The MEM Init C file.
 *
 * @par         Project
 *              MG32
 * @version     V2.10
 * @date        2025/12/12
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2025 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef __MG32_MEM_INIT_H
#define __MG32_MEM_INIT_H
#define __MG32_MEM_INIT_H_VER                          2.10

#ifdef __cplusplus
 extern "C" {
#endif

#include "MG32_DRV.h"
#include "MG32_MEM.h"

//*** <<< Use Configuration Wizard in Context Menu >>> ***

//  <o0> FCLK Frequency(unit:HZ).<1-50000000>
//  <o4.0..15> IAP memory size(unit:Page Size).
//    <i> Default value is loaded from CFG OR after Warm reset.
//    <i> Page Size 1KByte for MG32F02A132 / A072 / A032 
//    <i> Page Size 512Byte for MG32F02A128 / A064 / U128 / U064 / V032 / K128 / K064 / N128 / N064
//  <q6> Lock IAP memory size MEM_IAP_SIZE register access.
//    <i>  Default value is loaded from CFG OR only after Cold reset.
//  <q2.2> CPU hold control under flash memory access
//    <i> Only using on Boot from SRAM Mode.
//  <q7> Disable Flash data access error HardFault.
//    <i> Default: 0 Enable
//  <e1.0> Memory controller interrupt all.
//    <q1.1> Flash end of processing interrupt.
//    <q1.4> code execution illegal address error detection interrupt.
//    <q1.5> Flash write protect error detection interrupt.
//    <q1.6> Flash read protect error detection interrupt.
//  </e>
//  <q1.20> Code execution illegal address detection reset.
//  <q1.21> Flash write protect error detection reset.
//  <q1.22> Flash read protect error detection reset.
//*** <<< end of configuration section >>> ***

#define CONF_MEM_FCLK         24000000
#define CONF_MEM_INT          0x00000000
#define CONF_MEM_CR0          0x00000002
#define CONF_MEM_CR1          0x00000000
#define CONF_MEM_IAPSZ        0x00001000
#define CONF_MEM_LSFAPD       0
#define CONF_MEM_IAPSZ_Lock   0
#define CONF_MEM_HardFault    0



void MEM_Init(void);


#ifdef __cplusplus
}
#endif

#endif

