/*********************************************************************
*	 Project: MG82F6P32-DEMO
*			TH253A MG82F6P32_LQFP32_QFN32_EV_V11 EV	Board
*			CpuCLK=12MHz, SysCLK=12MHz
*	 Description:
*			UART1_ARGB_Mode	(TXD1/P1.3)
*			Master
*	 Note:
*
*	 Creat time:2024.02.26
*	 Modify:
*
*********************************************************************/
#define	_MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>	// for printf

#include ".\include\REG_MG82F6P32.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6P32.H"
#include ".\include\API_Uart_BRGRL_MG82F6P32.H"

/*************************************************
*Set SysClk	(MAX.50MHz)
*Selection:
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define	MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*Set CpuClk	(MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define	MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define	TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256)
#define	TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define	TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000))))	/256)
#define	TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000))))	%256)

#define	IO_LED_R		P22
#define	IO_LED_Y		P24
#define	IO_LED_G		P26

#define	DUTY_1_3		3		// Duty	1/3
#define	DUTY_1_4		4		// Duty	1/4
#define	ARGB_DUTY			DUTY_1_4

//10 pcs ARGB LED
bit	argb_update_flag;

#define	Breathing_Frame_Time_Default		30 //30*1ms	= 30ms
u8 Breathing_Counter;
u8 Breathing_Frame_Value;
u8 Breathing_Frame_Time_Value;

/***********************************************************************************
*Function:		void INT_T0(void)
*Description:	T0 Interrupt handler
*Input:
*Output:
*************************************************************************************/
void INT_T0(void) interrupt	INT_VECTOR_T0
{
	  Breathing_Counter	++;
	  TH0=TIMER_1T_1ms_TH;
	  TL0=TIMER_1T_1ms_TL;
}

/***********************************************************************************
*Function:		void INT_UART1(void)
*Description:	UART1 Interrupt	handler
*Input:
*Output:
*************************************************************************************/
void INT_UART1(void) interrupt INT_VECTOR_UART1
{
	_push_(SFRPI);		   //Protect SFRPI

	SFR_SetPage(1);		   //S1CON:Page	1 only
	if(TI1)
	{
	}
	if(RI1)
	{
		IO_LED_R=!IO_LED_R;
		argb_update_flag=1;
		RI1= 0;
	}
	_pop_(SFRPI);		   //restore SFRPI
}

/*************************************************
*Function:		void DelayXus(u16 xUs)
*Description:		delay,unit:us
*Input:				u8 Us -> *1us  (1~255)
*Output:
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if	(MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if	(MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if	(MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:		void DelayXms(u16 xMs)
*Description:	 delay,unit:ms
*Input:				u16	xMs	-> *1ms	 (1~65535)
*Output:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;

	}
}

/***********************************************************************************
*Function:		void InitPort()
*Description:	Initialize IO Port
*Input:
*Output:
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);				// SetP22,P24,P26 as push-pull(LED)
	PORT_SetP1PushPull(BIT3);						// Set P13(TXD1) as	push-pul
}

/***********************************************************************************
*Function:		void InitClock()
*Description:	Initialize clock
*Input:
*Output:
*************************************************************************************/
void InitClock(void)
{
#if	(MCU_SYSCLK==11059200)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);

#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if	(MCU_SYSCLK==12000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz	CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);

#else
	// SysClk=12MHz	CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if	(MCU_SYSCLK==22118400)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==24000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz	CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz	CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==29491200)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==32000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz	CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz	CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if	(MCU_SYSCLK==48000000)
	// SysClk=48MHz	CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60 output MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*Function:		void UART1ARGBTransceiver(u8 S1_DATA)
*Description:	UART1 ARGB Master transmit data
*Input:			u8 S1_DATA
*Output:
*************************************************************************************/
void UART1ARGBTransceiver(u8 S1_DATA)
{
	SFR_SetPage(1);
	S1BUF=S1_DATA;
	while(TI1==0);
	TI1=0;
	SFR_SetPage(0);
}

/***********************************************************************************
*Function:		void InitTimer0()
*Description:	Initialize Timer0
*Input:
*Output:
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// TIMER0 Mode:	16-bit
	TM_SetT0Clock_SYSCLK();					// TIMER0 Clock	source:	SYSCLK
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(TIMER_1T_1ms_TL);		// Set TL0 value
	TM_SetT0HighByte(TIMER_1T_1ms_TH);		// Set TH0 value
	TM_EnableT0();							// Enable T0
}

/***********************************************************************************
*Function:		void InitUart1_ARGB(void)
*Description:	Initialize Uart1 for ARGB
*Input:
*Output:
*************************************************************************************/
void InitUart1_ARGB(void)
{

	UART1_SetModeARGB();				// Set UART1 as	ARGB master	mode
	UART1_SetRXD1TXD1_P12P13();			// Set TXD1(P13)

#if(ARGB_DUTY==DUTY_1_3)
	UART1_SetARGBDuty_1_3();
#else
	UART1_SetARGBDuty_1_4();
#endif
	UART1_SetARGBResetTime_BaudRate_x8x20();

	UART1_SetS1BRGSelSYSCLK();			// S1BRG clock source: SYSCLK
	UART1_SetS1BRGValue(256-((MCU_SYSCLK/750000)/ARGB_DUTY));
	UART1_EnS1BRG();					// Enable S1BRG
	UART1_SetDataMSB();

	UART1_SetARGBTI1Interrupt_Disable();

	argb_update_flag=0;


}

/***********************************************************************************
*Function:		void InitInterrupt()
*Description:	Initialize Interrupt
*Input:
*Output:
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();			//	Enable Timer0 interrupt
	INT_EnUART1();			//	Enable UART1 interrupt
}

/***********************************************************************************
*Function:		 void InitSystem(void)
*Description:	 Initialize	MCU
*Input:
*Output:
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();

	InitUart1_ARGB();
	InitTimer0();
	InitInterrupt();
}

//**********************Breathing Lighting Effect=****************************
WORD m_breathing_formula(BYTE Data)
{
	  BYTE opposite	= 0;
	WORD wTmp;

	  if (Data < 94)
	  {
	  }
	  else if (Data	< 188)
	  {
			Data = Data-94;
			opposite = 1;
	  }
	  else
	  {
			Data = 0;
	  }

	  if (Data < 64)
	  {
			wTmp = 256-(4*Data);
	  }
	  else
	  {
			wTmp = 0;
	  }

	  if (opposite)
	  {
			wTmp = 256 - wTmp;
	  }

	  return wTmp;
}

void Breathing_Lighting_Effect(void)
{
	  WORD B_Tmp;
	  char x;

	  if (Breathing_Counter	>= Breathing_Frame_Time_Default) //Breathing
	  {
			Breathing_Counter =	CLR;
			B_Tmp =	m_breathing_formula(Breathing_Frame_Value);//Breathing Frame 0~187,	total 188 frame	= 188*30ms = 5.64sec

			if (Breathing_Frame_Value >= 187)
		{
				  Breathing_Frame_Value	= CLR;
		}
			else
				  Breathing_Frame_Value	++;


		for	(x=0; x<10;	x++)
		{
			UART1ARGBTransceiver(HIBYTE( B_Tmp * 0x0F ));
			UART1ARGBTransceiver(HIBYTE( B_Tmp * 0x1F ));
			UART1ARGBTransceiver( 0	);
		}

	}
}
//****************************************************************************

void main()
{
  u8 x;

	InitSystem();

	INT_EnAll();

	for	(x=0; x<87;	x++)
	{
		UART1ARGBTransceiver(0x00);
	}

	while(1)
	{
		DelayXms(1);
		x++;
		if(x>=100)
		{
			x=0;
			IO_LED_G=!IO_LED_G;
		}
		if (argb_update_flag)
		{
			Breathing_Lighting_Effect();
			argb_update_flag = 0;
		}
	}
}




