#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_WDT_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
WDT overflow Interrupt(WDTF) => WDTF_Flag
****************************************************************/
uint8_t WDTF_Flag;

/****************************************************************
 *  Delay function
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P56 used for LED_D5
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P56_PushPull);

    /****************************************************************
     *  WDT Initialized
     *  1. Setting prescaler to div 256
     *  2. Enable WREN, If WDT overflow will reset MCU.
     *  3. Enable WDT
     ****************************************************************/
    __DRV_WDT_SetPrescaler(WDT_PRESCALER_DIV_256);
    __DRV_WDT_Reset_Cmd(MW_ENABLE);
    __DRV_WDT_Cmd(MW_ENABLE);
    delay_ms(500);

    while (1)
    {
        __DRV_GPIO_InversePinP5(P56);
        delay_ms(20);
    }
}
