#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer4 overflow Interrupt(TH4) => TF4_Flag
Timer4 external Interrupt      => EXF4_Flag
Timer4 overflow Interrupt(TL4) => TF4L_Flag
****************************************************************/
uint8_t TF4_Flag, EXF4_Flag, TF4L_Flag;

void main()
{
    /****************************************************************
    Variables
    count       => For time delay
    ****************************************************************/
    uint16_t count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer4 interrupt (ET4) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER4_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P71 used for T4EX Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P7ModeSelect(P71_OpenDrainPullUp);

    /****************************************************************
     *  Timer4 Initialized
     *  Interrupt time => (1 / (SYSCLK/12)) * 65536 * 15 = 0.983 S
     *  Trigger T4EX pin(P71) to start the timer4 counter.
     ****************************************************************/
    __DRV_TIMER4_Mode_Select(TIMER4_MODE6_DUTY_CAPTURE);
    __DRV_TIMER4_Clock_Source_Select(TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER4_Run_Cmd(MW_ENABLE);
    __DRV_GPIO_WriteP7(P71, 0);
    __DRV_GPIO_WriteP7(P71, 1);

    while (1)
    {
        if (TF4_Flag)
        {
            count += 1;
            if (count == 15)
            {
                __DRV_GPIO_InversePinP5(P55);
                count = 0;
            }
            TF4_Flag = 0;
        }
    }
}

/****************************************************************
Timer4 interrupt
The Timer4 has TF4, EXF4, TF4L flags to trigger the Timer4 interrupt.
****************************************************************/
void TIMER4_TF4_EXF4_TF4L_ISR(void) interrupt TIMER4_ISR_VECTOR
{
    if (DRV_TIMER4_GetTF4() == 1)
    {
        TF4_Flag = 1;
        DRV_TIMER4_ClearTF4();
    }

    if (DRV_TIMER4_GetTF4L() == 1)
    {
        TF4L_Flag = 1;
        DRV_TIMER4_ClearTF4L();
    }

    if (DRV_TIMER4_GetEXF4() == 1)
    {
        EXF4_Flag = 1;
        DRV_TIMER4_ClearEXF4();
    }
}

