#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

/****************************************************************
Variables
Timer2 overflow Interrupt(TH2) => TF2_Flag
Timer2 external Interrupt      => EXF2_Flag
Timer2 overflow Interrupt(TL2) => TF2L_Flag
****************************************************************/
uint8_t TF2_Flag, EXF2_Flag, TF2L_Flag;

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer2 interrupt (ET2) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER2_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P11 used for T2EX Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P1ModeSelect(P11_OpenDrainPullUp);

    /****************************************************************
     *  Timer2 Initialized
     *  1. Capture Source = T2EX Pin
     *  2. Capture Edge = FALLING
     ****************************************************************/
    __DRV_TIMER2_Capture_Source_Select(TIMER2_CAPTURE_SOURCE_T2EX_PIN);
    __DRV_TIMER2_Capture_Source_Dectect(Timer2_FALLING_EDGE);

    /****************************************************************
     *  Timer2 External Trigger
     *  Trigger source = T2EX Pin(P11)
     ****************************************************************/
    __DRV_GPIO_WriteP1(P11, 1);
    while (1)
    {
        __DRV_GPIO_WriteP1(P11, 0);
        if (EXF2_Flag == 1)
        {
            __DRV_GPIO_InversePinP5(P55);
            __DRV_GPIO_WriteP1(P11, 1);
            delay_ms(50);
            EXF2_Flag = 0;
        }
    }
}

/****************************************************************
Timer2 interrupt
The Timer2 has TF2, EXF2, TF2L flags to trigger the Timer2 interrupt.
****************************************************************/
void TIMER2_TF2_EXF2_TF2L_ISR(void) interrupt TIMER2_ISR_VECTOR
{
    if (DRV_TIMER2_GetTF2() == 1)
    {
        TF2_Flag = 1;
        DRV_TIMER2_ClearTF2();
    }

    if (DRV_TIMER2_GetTF2L() == 1)
    {
        TF2L_Flag = 1;
        DRV_TIMER2_ClearTF2L();
    }

    if (DRV_TIMER2_GetEXF2() == 1)
    {
        EXF2_Flag = 1;
        DRV_TIMER2_ClearEXF2();
    }
}
