#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer0 Interrupt => TF0_Flag
****************************************************************/
uint8_t TF0_Flag;

void main()
{
    /****************************************************************
    Variables
    count => For time delay
    ****************************************************************/
    uint16_t count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer0 interrupt (ET0) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER0_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer0 Initialized
     *  Interrupt time => (1/ILRCO * 224) * 1000 = 1 S
     ****************************************************************/
    __DRV_TIMER0_Mode_Select(TIMER0_MODE2_8BIT_AUTORELOAD);
    __DRV_TIMER0_Clock_Source_Select(TIMER0_CLOCK_SOURCE_ILRCO);
    __DRV_TIMER0_SetHighByte(224);
    __DRV_TIMER0_Run_Cmd(MW_ENABLE);

    while (1)
    {
        if (TF0_Flag)
        {
            count += 1;
            if (count == 1000)
            {
                __DRV_GPIO_InversePinP5(P55);
                count = 0;
            }
            TF0_Flag = 0;
        }
    }
}

/****************************************************************
Timer0 interrupt
Timer0 interrupt flag (TF0) is cleared by hardware interrupt.
****************************************************************/
void TIMER0_TF0_ISR(void) interrupt TIMER0_ISR_VECTOR
{
    TF0_Flag = 1;
}

