#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_RTC_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
RTC Interrupt => RTCF_Flag
****************************************************************/
uint8_t RTCF_Flag = 0;

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable RTCF interrupt (RTCFIE) = Enable;
     *  2. Enable System Flag interrupt (ESF) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_RTC_IT_Cmd(MW_ENABLE);
    __DRV_INT_SystemFlag_IT_Enable();
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P44 & P45 Disable OCD Function
     *  2. P45 used for RTCKO
     *  3. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_SetOCD2IO(MW_DISABLE);
    __DRV_GPIO_P4ModeSelect(P45_OpenDrainPullUp);
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  RTC Initialized
     *  1. Clock Source = ILRCO
     *  2. Enable the RTCKO output on P4.5
     *  3. RTC = Enable
     ****************************************************************/
    __DRV_RTC_ClockSource_Select(RTC_CLK_ILRCO);
    __DRV_RTC_SetRTCKO(MW_ENABLE);
    __DRV_RTC_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  Interrupt time of RTC_Flag
         *  ILRCO(32KHz) / 16384(Defaule prescaler) = 0.512S (ILRCO Deviation +/- 8%)
         *  MCU will inverse the P55 when occurs the RTC Interrupt.
         ****************************************************************/
        if (RTCF_Flag)
        {
            __DRV_GPIO_InversePinP5(P55);
            RTCF_Flag = 0;
        }
    }
}

void SYSFlag_RTC_ISR() interrupt SYSFLAG_ISR_VECTOR
{
    // To check RTC Flag
    if ((PCON1 & RTCF) == RTCF)
    {
        RTCF_Flag = 1;
        __DRV_RTC_ClearFlag();
    }
}
