/**
 ******************************************************************************
 *
 * @file        MAIN.C
 *
 * @brief       This is the C code demo.
 *
 * @par         Project
 *              MGEQ1C064
 * @version     V1.00
 * @date        2022/5/5
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IF"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 * @par         Figure
 * @image       html DRV_CLK_Figure.png width=1024
 ******************************************************************************
 * Modify History:
 * #1.00_Brian_20220505 //bugNum_Authour_Date
 * >> Initial version
 ******************************************************************************
 */


#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "stdio.h"
#define MWT( __stuff__ )  do { __stuff__ } while (0)

#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_CLK_DRV.h"
#include "MGEQ1C064_CLK_MID.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_WDT_DRV.h"

/**
 *******************************************************************************
 * @brief   Demo GPIO mode config.
 *******************************************************************************
 */
void InitPort(void)
{
    __DRV_GPIO_P6ModeSelect(P60_PushPull);  // Set P60 as push pull mode
    __DRV_GPIO_P5ModeSelect(P55_PushPull);  // Set P55 as push pull mode
    __DRV_GPIO_P5ModeSelect(P56_PushPull);  // Set P56 as push pull mode
    __DRV_GPIO_P5ModeSelect(P57_PushPull);  // Set P57 as push pull mode
}


/**
 *******************************************************************************
 * @brief   Demo easy select system clock and cpu clock.
 * @note    __DRV_CLK_EasySelect(__SELECT__) : System Clock Selection.
 * @par     PCA_12M_SYS_12M_CPU_12M        : PCA CKMIX16=NA, MCKDO=12MHz; SYSCLK=12MHz, CPUCLK=12MHz (Default)
 * @par     PCA_96M_SYS_24M_CPU_24M        : PCA CKMIX16=96MHz, MCKDO=24MHz; SYSCLK=24MHz, CPUCLK=24MHz
 * @par     PCA_96M_SYS_32M_CPU_16M        : PCA CKMIX16=96MHz, MCKDO=32MHz; SYSCLK=32MHz, CPUCLK=16MHz
 * @par     PCA_96M_SYS_32M_CPU_32M        : PCA CKMIX16=96MHz, MCKDO=32MHz; SYSCLK=32MHz, CPUCLK=32MHz
 * @par     PCA_96M_SYS_48M_CPU_24M        : PCA CKMIX16=96MHz, MCKDO=48MHz; SYSCLK=48MHz, CPUCLK=24MHz
 * @par     PCA_114M_SYS_36M_CPU_36M       : PCA CKMIX16=144MHz, MCKDO=36MHz; SYSCLK=36MHz, CPUCLK=36MHz
 * @par     PCA_114M_SYS_48M_CPU_24M       : PCA CKMIX16=144MHz, MCKDO=48MHz; SYSCLK=48MHz, CPUCLK=24MHz
 * @par     PCA_11M06_SYS_11M06_CPU_11M06  : PCA CKMIX16=NA, MCKDO=11.06MHz; SYSCLK=11.06MHz, CPUCLK=11.06MHz
 * @par     PCA_88M47_SYS_22M12_CPU_22M12  : PCA CKMIX16=88.47MHz, MCKDO=22.12MHz; SYSCLK=22.12MHz, CPUCLK=22.12MHz
 * @par     PCA_88M47_SYS_29M49_CPU_14M75  : PCA CKMIX16=88.47MHz, MCKDO=29.49MHz; SYSCLK=29.49MHz, CPUCLK=14.75MHz
 * @par     PCA_88M47_SYS_29M49_CPU_29M49  : PCA CKMIX16=88.47MHz, MCKDO=29.49MHz; SYSCLK=29.49MHz, CPUCLK=29.49MHz
 * @par     PCA_88M47_SYS_44M24_CPU_22M12  : PCA CKMIX16=88.47MHz, MCKDO=44.24MHz; SYSCLK=44.24MHz, CPUCLK=22.12MHz
 * @par     PCA_132M71_SYS_33M18_CPU_33M18 : PCA CKMIX16=132.71MHz, MCKDO=33.18MHz; SYSCLK=33.18MHz, CPUCLK=33.18MHz
 * @par     PCA_132M71_SYS_44M24_CPU_22M12 : PCA CKMIX16=132.71MHz, MCKDO=44.24MHz; SYSCLK=44.24MHz, CPUCLK=22.12MHz
 * @par     PCA_SYS_CPU_XTAL_2M_to_25M     : PCA CKMIX16=NA, MCKDO=XTAL; SYSCLK=CPUCLK=XTAL(2MHz~25MHz)
 * @par     PCA_SYS_CPU_XTAL_32768         : PCA CKMIX16=NA, MCKDO=XTAL(32768); SYSCLK=CPUCLK=XTAL(32768)
 * @par     PCA_SYS_CPU_XTAL_32768_LowGain : PCA CKMIX16=NA, MCKDO=XTAL(32768)(Low Gain); SYSCLK=CPUCLK=XTAL(32768)(Low Gain)
 * @par     PCA_SYS_CPU_ILRCO_32K          : PCA CKMIX16=NA, MCKDO=ILRCO(32KHz); SYSCLK=CPUCLK=ILRCO(32KHz)
 * @par     PCA_SYS_CPU_ECKI               : PCA CKMIX16=NA, MCKDO=ECKI; SYSCLK=CPUCLK=ECKI(0~25MHz)
 *******************************************************************************
 */

void InitClock(void)
{
    //=====================================================
    #if 1   //PCA CKMIX16=NA, MCKDO=11.06MHz; SYSCLK=11.06MHz, CPUCLK=5.53MHz
        __DRV_CLK_Easy_Select(PCA_11M06_SYS_11M06_CPU_11M06);
        __DRV_CLK_CPUCLK_Select(CPUCLK_SYSCLK_DIV_2);
    #endif
    //-----------------------------------------------------
    #if 0    //PCA CKMIX16=NA, MCKDO=11.06MHz; SYSCLK=11.06MHz, CPUCLK=11.06MHz
        __DRV_CLK_Easy_Select(PCA_11M06_SYS_11M06_CPU_11M06);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=NA, MCKDO=12MHz; SYSCLK=12MHz, CPUCLK=6MHz
        __DRV_CLK_Easy_Select(PCA_12M_SYS_12M_CPU_12M);
        __DRV_CLK_CPUCLK_Select(CPUCLK_SYSCLK_DIV_2);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=NA, MCKDO=12MHz; SYSCLK=12MHz, CPUCLK=12MHz
        __DRV_CLK_Easy_Select(PCA_12M_SYS_12M_CPU_12M);
    #endif


    //=====================================================
    #if 0   //PCA CKMIX16=88.47MHz, MCKDO=22.12MHz; SYSCLK=22.12MHz, CPUCLK=11.06MHz
        __DRV_CLK_Easy_Select(PCA_88M47_SYS_22M12_CPU_22M12);
        __DRV_CLK_CPUCLK_Select(CPUCLK_SYSCLK_DIV_2);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=88.47MHz, MCKDO=22.12MHz; SYSCLK=22.12MHz, CPUCLK=22.12MHz
        __DRV_CLK_Easy_Select(PCA_88M47_SYS_22M12_CPU_22M12);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=88.47MHz, MCKDO=29.49MHz; SYSCLK=29.49MHz, CPUCLK=14.75MHz
        __DRV_CLK_Easy_Select(PCA_88M47_SYS_29M49_CPU_14M75);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=88.47MHz, MCKDO=29.49MHz; SYSCLK=29.49MHz, CPUCLK=29.49MHz
        __DRV_CLK_Easy_Select(PCA_88M47_SYS_29M49_CPU_29M49);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=88.47MHz, MCKDO=44.24MHz; SYSCLK=44.24MHz, CPUCLK=22.12MHz
        __DRV_CLK_Easy_Select(PCA_88M47_SYS_44M24_CPU_22M12);
    #endif


    //=====================================================
    #if 0   //PCA CKMIX16=96MHz, MCKDO=24MHz; SYSCLK=24MHz, CPUCLK=12MHz
        __DRV_CLK_Easy_Select(PCA_96M_SYS_24M_CPU_24M);
        __DRV_CLK_CPUCLK_Select(CPUCLK_SYSCLK_DIV_2);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=96MHz, MCKDO=24MHz; SYSCLK=24MHz, CPUCLK=24MHz
        __DRV_CLK_Easy_Select(PCA_96M_SYS_24M_CPU_24M);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=96MHz, MCKDO=32MHz; SYSCLK=32MHz, CPUCLK=16MHz
        __DRV_CLK_Easy_Select(PCA_96M_SYS_32M_CPU_16M);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=96MHz, MCKDO=32MHz; SYSCLK=32MHz, CPUCLK=32MHz
        __DRV_CLK_Easy_Select(PCA_96M_SYS_32M_CPU_32M);
    #endif


    //=====================================================
    #if 0   //PCA CKMIX16=144MHz, MCKDO=36MHz; SYSCLK=36MHz, CPUCLK=18MHz
        __DRV_CLK_Easy_Select(PCA_114M_SYS_36M_CPU_36M);
        __DRV_CLK_CPUCLK_Select(CPUCLK_SYSCLK_DIV_2);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=144MHz, MCKDO=36MHz; SYSCLK=36MHz, CPUCLK=36MHz
        __DRV_CLK_Easy_Select(PCA_114M_SYS_36M_CPU_36M);
    #endif
    //-----------------------------------------------------
    #if 0   //PCA CKMIX16=144MHz, MCKDO=48MHz; SYSCLK=48MHz, CPUCLK=24MHz
        __DRV_CLK_Easy_Select(PCA_114M_SYS_48M_CPU_24M);
    #endif

}


/**
 *******************************************************************************
 * @brief   Main Loop
 *******************************************************************************
 */

void main(void)
{
    uint16_t Delay_NOP;
    uint8_t LED_Buf=0;

    InitPort();     //Initial GPIO
    InitClock();    //Initial Clock

    //=====================================================
    #if 0   //P60 output MCK/4
        __DRV_CLK_P60Mux_Select(P60_MCK_DIV_4);
    #endif

    while(1)
    {
        __DRV_WDT_ClearCounter();

        for (Delay_NOP=0 ; Delay_NOP<1000 ; Delay_NOP++);

        __DRV_GPIO_InversePinP3(P37);

        LED_Buf++;
        if (LED_Buf & 0x08)
        {
            __DRV_GPIO_WriteP5(P55,0);
        }
        else
        {
            __DRV_GPIO_WriteP5(P55,1);
        }

        if (LED_Buf & 0x20)
        {
            __DRV_GPIO_WriteP5(P56,0);
        }
        else
        {
            __DRV_GPIO_WriteP5(P56,1);
        }

        if (LED_Buf & 0x80)
        {
            __DRV_GPIO_WriteP5(P57,0);
        }
        else
        {
            __DRV_GPIO_WriteP5(P57,1);
        }
    }
}

