#ifndef _API_MACRO_MA82G5Cxx_H
#define _API_MACRO_MA82G5Cxx_H

#define SFR_SetPage(x)		SFRPI=x

/*
*************************************************************************************
*  INTERRUPT ж 
*
*************************************************************************************
*/
//ж
#define INT_VECTOR_INT0		0
#define INT_VECTOR_T0		1
#define INT_VECTOR_INT1		2
#define INT_VECTOR_T1		3
#define INT_VECTOR_UART0	4
#define INT_VECTOR_T2		5
#define INT_VECTOR_INT2		6
#define INT_VECTOR_INT3		7
#define INT_VECTOR_SPI		8
#define INT_VECTOR_ADC		9
#define INT_VECTOR_PCA0		10
#define INT_VECTOR_SF		11
#define INT_VECTOR_UART1	12
#define INT_VECTOR_KB		13
#define INT_VECTOR_TWI0		14
#define INT_VECTOR_AC0		15
#define INT_VECTOR_T3		16
#define INT_VECTOR_AC1		17
#define INT_VECTOR_UART2	18
#define INT_VECTOR_T4		19
#define INT_VECTOR_UART3	20
#define INT_VECTOR_PCA1		21
#define INT_VECTOR_TWI1		22
#define INT_VECTOR_AC2		23

//жʹ/ֹ
#define INT_EnAll()			EA=1		// ʹȫж
#define INT_DisAll()		EA=0		// ֹȫж
#define INT_EnINT0()		EX0=1
#define INT_DisINT0()		EX0=0
#define INT_EnTIMER0()		ET0=1
#define INT_DisTIMER0()		ET0=0
#define INT_EnINT1()		EX1=1
#define INT_DisINT1()		EX1=0
#define INT_EnTIMER1()		ET1=1
#define INT_DisTIMER1()		ET1=0
#define INT_EnUART0()		ES0=1
#define INT_DisUART0()		ES0=0
#define INT_EnTIMER2()		ET2=1
#define INT_DisTIMER2()		ET2=0

#define INT_EnINT2()		EX2=1
#define INT_DisINT2()		EX2=0
#define INT_EnINT3()		EX3=1
#define INT_DisINT3()		EX3=0

#define INT_EnSPI()			EIE1=EIE1|ESPI
#define INT_DiSPI()			EIE1=EIE1&(~ESPI)
#define INT_EnADC()			EIE1=EIE1|EADC
#define INT_DisADC()		EIE1=EIE1&(~EADC)
#define INT_EnPCA0()		EIE1=EIE1|EPCA
#define INT_DisPCA0()		EIE1=EIE1&(~EPCA)
#define INT_EnSF()			EIE1=EIE1|ESF
#define INT_DisSF()			EIE1=EIE1&(~ESF)
#define INT_EnUART1()		EIE1=EIE1|ES1
#define INT_DisUART1()		EIE1=EIE1&(~ES1)
#define INT_EnKBI()			EIE1=EIE1|EKB
#define INT_DisKBI()		EIE1=EIE1&(~EKB)
#define INT_EnTWI0()		EIE1=EIE1|ETWSI
#define INT_DisTWI0()		EIE1=EIE1&(~ETWSI)
#define INT_EnAC0()			EIE1=EIE1|EAC0
#define INT_DisAC0()		EIE1=EIE1&(~EAC0)

#define INT_EnTIMER3()		EIE2=EIE2|ET3
#define INT_DisTIMER3()		EIE2=EIE2&(~ET3)
#define INT_EnAC1()			EIE2=EIE2|EAC1
#define INT_DisAC1()		EIE2=EIE2&(~EAC1)
#define INT_EnUART2()		EIE2=EIE2|ES2
#define INT_DisUART2()		EIE2=EIE2&(~ES2)
#define INT_EnTIMER4()		EIE2=EIE2|ET4
#define INT_DisTIMER4()		EIE2=EIE2&(~ET4)
#define INT_EnUART3()		EIE2=EIE2|ES3
#define INT_DisUART3()		EIE2=EIE2&(~ES3)
#define INT_EnPCA1()		EIE2=EIE2|EPCA1
#define INT_DisPCA1()		EIE2=EIE2&(~EPCA1)
#define INT_EnTWI1()		EIE2=EIE2|ETWI1
#define INT_DisTWI1()		EIE2=EIE2&(~ETWI1)
#define INT_EnAC2()			EIE2=EIE2|EAC2
#define INT_DisAC2()		EIE2=EIE2&(~EAC2)

#define INT_EnSF_WDT()		SFIE=SFIE|WDTFIE
#define INT_DisSF_WDT()		SFIE=SFIE&(~WDTFIE)
#define INT_EnSF_BOD0()		SFIE=SFIE|BOF0IE
#define INT_DisSF_BOD0()	SFIE=SFIE&(~BOF0IE)
#define INT_EnSF_BOD1()		SFIE=SFIE|BOF1IE
#define INT_DisSF_BOD1()	SFIE=SFIE&(~BOF1IE)
#define INT_EnSF_RTC()		SFIE=SFIE|RTCFIE
#define INT_DisSF_RTC()		SFIE=SFIE&(~RTCFIE)
#define INT_EnSF_MCD()		SFIE=SFIE|MCDFIE
#define INT_DisSF_MCD()		SFIE=SFIE&(~MCDFIE)
#define INT_EnSF_SID()		SFIE=SFIE|SIDFIE
#define INT_DisSF_SID()		SFIE=SFIE&(~SIDFIE)


// жȼ
#define IP_INT0		BIT0
#define IP_T0		BIT1
#define IP_INT1		BIT2
#define IP_T1		BIT3
#define IP_UART0	BIT4
#define IP_T2		BIT5
#define IP_INT2		BIT6
#define INT_SetIPHighest(x)			IP0H=IP0H|x;IP0L=IP0L|x
#define INT_SetIPHigh(x)			IP0H=IP0H|x;IP0L=IP0L&(~x)
#define INT_SetIPLow(x)				IP0H=IP0H&(~x);IP0L=IP0L|x
#define INT_SetIPLowest(x)			IP0H=IP0H&(~x);IP0L=IP0L&(~x)

#define IPX_SPI		BIT0
#define IPX_ADC		BIT1
#define IPX_PCA		BIT2
#define IPX_SF		BIT3
#define IPX_KB		BIT5
#define IPX_TWI0	BIT6
#define IPX_AC0		BIT7
#define INT_SetIPXHighest(x)		EIP1H=EIP1H|x;EIP1L=EIP1L|x
#define INT_SetIPXHigh(x)			EIP1H=EIP1H|x;EIP1L=EIP1L&(~x)
#define INT_SetIPXLow(x)			EIP1H=EIP1H&(~x);EIP1L=EIP1L|x
#define INT_SetIPXLowest(x)			EIP1H=EIP1H&(~x);EIP1L=EIP1L&(~x)

// жϱ־λ
#define INT_ClrIFEX0()				IE0=0
#define INT_ClrIFEX1()				IE1=0
#define INT_ClrIFEX2()				IE2=0
#define INT_ClrIFET0()				TF0=0
#define INT_ClrIFET1()				TF1=0
#define INT_ClrIFET2()				TF2=0

#define INT_ClrIFWDTF()				PCON1=WDTF
#define INT_ClrIFBOF0()				PCON1=BOF0
#define INT_ClrIFBOF1()				PCON1=BOF1
#define INT_ClrIFRTCF()				PCON1=RTCF
#define INT_ClrIFMCDF()				PCON1=MCDF

#define INT_ClrIFKBI()				KBCON=KBCON&(~KBIF)

// ⲿж ѡж
#define INT_SetINT0P32()			XICFG=XICFG&(~(INT0IS0|INT0IS1))
#define INT_SetINT0P30()			XICFG=(XICFG&(~(INT0IS0|INT0IS1)))|INT0IS0
#define INT_SetINT0P16()			XICFG=(XICFG&(~(INT0IS0|INT0IS1)))|INT0IS1
#define INT_SetINT0P40()			XICFG=(XICFG|(INT0IS0|INT0IS1))

#define INT_SetINT1P33()			XICFG=XICFG&(~(INT1IS0|INT1IS1))
#define INT_SetINT1P31()			XICFG=(XICFG&(~INT1IS1))|INT1IS0
#define INT_SetINT1P17()			XICFG=(XICFG&(~INT1IS0))|INT1IS1
#define INT_SetINT1P41()			XICFG=XICFG|(INT1IS0|INT1IS1)

#define INT_SetINT2P43()			SFRPI=1;XICFG1=XICFG1&(~(INT2IS0|INT2IS1));SFRPI=0
#define INT_SetINT2P62()			SFRPI=1;XICFG1=(XICFG1&(~INT2IS1))|INT2IS0;SFRPI=0
#define INT_SetINT2P14()			SFRPI=1;XICFG1=(XICFG1&(~INT2IS0))|INT2IS1;SFRPI=0
#define INT_SetINT2P61()			SFRPI=1;XICFG1=XICFG1|(INT2IS0|INT2IS1);SFRPI=0

#define INT_SetINT3P42()			SFRPI=1;XICFG1=XICFG1&(~(INT3IS0|INT3IS1));SFRPI=0
#define INT_SetINT3P63()			SFRPI=1;XICFG1=(XICFG1&(~INT3IS1))|INT3IS0;SFRPI=0
#define INT_SetINT3P15()			SFRPI=1;XICFG1=(XICFG1&(~INT3IS0))|INT3IS1;SFRPI=0
#define INT_SetINT3P60()			SFRPI=1;XICFG1=XICFG1|(INT3IS0|INT3IS1);SFRPI=0

// ⲿж üƽ/
#define INT_SetINT0_DetectLevel()		IT0=0
#define	INT_SetINT0_DetectEdge()		IT0=1

#define INT_SetINT1_DetectLevel()		IT1=0
#define	INT_SetINT1_DetectEdge()		IT1=1

#define INT_SetINT2_DetectLevel()		IT2=0
#define	INT_SetINT2_DetectEdge()		IT2=1

#define INT_SetINT3_DetectLevel()		IT3=0
#define	INT_SetINT3_DetectEdge()		IT3=1

// ⲿж ϸжһ/ƽ
#define INT_SetINT0_DetectLowFalling()	AUXR0=AUXR0&(~INT0H)
#define INT_SetINT0_DetectHighRising()	AUXR0=AUXR0|INT0H

#define INT_SetINT1_DetectLowFalling()	AUXR0=AUXR0&(~INT1H)
#define INT_SetINT1_DetectHighRising()	AUXR0=AUXR0|INT1H

#define INT_SetINT2_DetectLowFalling()	INT2H=0
#define INT_SetINT2_DetectHighRising()	INT2H=1

#define INT_SetINT3_DetectLowFalling()	INT3H=0
#define INT_SetINT3_DetectHighRising()	INT3H=1


#define INT_SetINT0_DetectHighLevel()		IT0=0;AUXR0=AUXR0|INT0H
#define INT_SetINT0_DetectLowLevel()		IT0=0;AUXR0=AUXR0&(~INT0H)
#define	INT_SetINT0_DetectFallingEdge()		IT0=1;AUXR0=AUXR0&(~INT0H)
#define	INT_SetINT0_DetectRisingEdge()		IT0=1;AUXR0=AUXR0|INT0H

#define INT_SetINT1_DetectHighLevel()		IT1=0;AUXR0=AUXR0|INT1H
#define INT_SetINT1_DetectLowLevel()		IT1=0;AUXR0=AUXR0&(~INT1H)
#define	INT_SetINT1_DetectFallingEdge()		IT1=1;AUXR0=AUXR0&(~INT1H)
#define	INT_SetINT1_DetectRisingEdge()		IT1=1;AUXR0=AUXR0|INT1H

#define INT_SetINT2_DetectHighLevel()		IT2=0;INT2H=1
#define INT_SetINT2_DetectLowLevel()		IT2=0;INT2H=0
#define	INT_SetINT2_DetectFallingEdge()		IT2=1;INT2H=0
#define	INT_SetINT2_DetectRisingEdge()		IT2=1;INT2H=1

#define INT_SetINT3_DetectHighLevel()		IT3=0;INT3H=1
#define INT_SetINT3_DetectLowLevel()		IT3=0;INT3H=0
#define	INT_SetINT3_DetectFallingEdge()		IT3=1;INT3H=0
#define	INT_SetINT3_DetectRisingEdge()		IT3=1;INT3H=1



// ⲿж ˲
#define INT_SetINT0Filter_Disable()				XICFG=XICFG&(~X0FLT);SFRPI=1;XICFG1=XICFG1&(~X0FLT1);SFRPI=0
#define INT_SetINT0Filter_Sysclk_x3()			XICFG=XICFG|X0FLT;SFRPI=1;XICFG1=XICFG1&(~X0FLT1);SFRPI=0
#define INT_SetINT0Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X0FLT);SFRPI=1;XICFG1=XICFG1|X0FLT1;SFRPI=0
#define INT_SetINT0Filter_T3TOF_x3()			XICFG=XICFG|X0FLT;SFRPI=1;XICFG1=XICFG1|X0FLT1;SFRPI=0

#define INT_SetINT1Filter_Disable()				XICFG=XICFG&(~X1FLT);SFRPI=1;XICFG1=XICFG1&(~X1FLT1);SFRPI=0
#define INT_SetINT1Filter_Sysclk_x3()			XICFG=XICFG|X1FLT;SFRPI=1;XICFG1=XICFG1&(~X1FLT1);SFRPI=0
#define INT_SetINT1Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X1FLT);SFRPI=1;XICFG1=XICFG1|X1FLT1;SFRPI=0
#define INT_SetINT1Filter_T3TOF_x3()			XICFG=XICFG|X1FLT;SFRPI=1;XICFG1=XICFG1|X1FLT1;SFRPI=0

#define INT_SetINT2Filter_Disable()				XICFG=XICFG&(~X2FLT);SFRPI=1;XICFG1=XICFG1&(~X2FLT1);SFRPI=0
#define INT_SetINT2Filter_Sysclk_x3()			XICFG=XICFG|X2FLT;SFRPI=1;XICFG1=XICFG1&(~X2FLT1);SFRPI=0
#define INT_SetINT2Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X2FLT);SFRPI=1;XICFG1=XICFG1|X2FLT1;SFRPI=0
#define INT_SetINT2Filter_T3TOF_x3()			XICFG=XICFG|X2FLT;SFRPI=1;XICFG1=XICFG1|X2FLT1;SFRPI=0

#define INT_SetINT3Filter_Disable()				XICFG=XICFG&(~X3FLT);SFRPI=1;XICFG1=XICFG1&(~X3FLT1);SFRPI=0
#define INT_SetINT3Filter_Sysclk_x3()			XICFG=XICFG|X3FLT;SFRPI=1;XICFG1=XICFG1&(~X3FLT1);SFRPI=0
#define INT_SetINT3Filter_SysclkDiv6_x3()		XICFG=XICFG&(~X3FLT);SFRPI=1;XICFG1=XICFG1|X3FLT1;SFRPI=0
#define INT_SetINT3Filter_T3TOF_x3()			XICFG=XICFG|X3FLT;SFRPI=1;XICFG1=XICFG1|X3FLT1;SFRPI=0

/*
*************************************************************************************
*/ 



/*
*************************************************************************************
*  IAP 
*
*************************************************************************************
*/
//IAP 
#define ISP_STANBY		0
#define ISP_READ		1 	  //
#define ISP_WRITE 	    2 	  //д
#define ISP_ERASE 	    3 	  //
#define ISP_WRITE_P     4     //дPҳĴ
#define ISP_READ_P     	5     //PҳĴ


/*
*************************************************************************************
*/


/*
*************************************************************************************
*  CLOCK 
*
*************************************************************************************
*/
// CLOCK IHRCO 12MHz/11.0592MHz
#define IHRCO_12MHz					0
#define IHRCO_110592MHz				0x80
#define CLK_SelIHRCO12MHz()					CKCON0=CKCON0&(~AFS)				
#define CLK_SelIHRCO110592MHz()				CKCON0=CKCON0|(AFS)	

// CLOCK CPUCLK 
#define CPUCLK_SYSCLK_DIV_1			0
#define CPUCLK_SYSCLK_DIV_2			0x08
#define CLK_SetCpuclkUseSysclk()			CKCON0=CKCON0&(~CCKS)				
#define CLK_SetCpuclkUseSysclkDiv2()		CKCON0=CKCON0|(CCKS)	

// CLOCK SYSCLK
#define SYSCLK_MCKDO_DIV_1			0
#define SYSCLK_MCKDO_DIV_2			1
#define SYSCLK_MCKDO_DIV_4			2
#define SYSCLK_MCKDO_DIV_8			3
#define SYSCLK_MCKDO_DIV_16			4
#define SYSCLK_MCKDO_DIV_32			5
#define SYSCLK_MCKDO_DIV_64			6
#define SYSCLK_MCKDO_DIV_128		7
#define CLK_SetSysclk(x)					CKCON0=(CKCON0&(~0x07))|x

// CLOCK /رCKM
#define DISABLE_CKM					0
#define ENABLE_CKM					0x40
#define CLK_DisCKM()						CKCON0=CKCON0&(~ENCKM)
#define CLK_EnCKM()							CKCON0=CKCON0|(ENCKM)

// CLOCK ѡCKMԴ
#define CKM_OSCIN_DIV_1				0x00	// OSCin=5~7MHz
#define CKM_OSCIN_DIV_2				0x10	// OSCin=10~14MHz	
#define CKM_OSCIN_DIV_4				0x20	// OSCin=20~28MHz
#define CKM_OSCIN_DIV_6				0x30	// OSCin=30~42MHz
#define CLK_SetCKMOSCin(x)					CKCON0=(CKCON0&(~0x30))|x

// CLOCK CKCON0
#define CLK_SetCKCON0(x)					CKCON0=x

// CLOCK CKCON2
#define GAIN_FOR_32K				0x00
#define GAIN_FOR_2M_25M				0x40

#define DISABLE_XTAL				0x00
#define ENABLE_XTAL					0x20

#define DISABLE_IHRCO				0x00
#define ENABLE_IHRCO				0x10

#define MCK_OSCin					0x00
#define MCK_CKMI_X4					0x04
#define MCK_CKMI_X533				0x08
#define MCK_CKMI_X8					0x0C

#define OSCIn_IHRCO					0x00
#define OSCIn_XTAL					0x01
#define OSCIn_ILRCO					0x02
#define OSCIn_ECKI_P60				0x03

#define CLK_SetCKCON2(x)			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON2_P;IFMT=ISP_WRITE_P;IFD=x;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// CLOCK CPU(>=24MHz)
#define CLK_SetCpuCLK_HighSpeed()	ISPCR=0x80;IFADRH=0x0;IFADRL=DCON0_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=IFD|(HSE_P);IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// CLOCK IAPʱ 
#define CLK_SetIAPTimeBase(x)		CKCON1=x-1

// CLOCK P60CLK
#define CLK_P60OC_P60()			AUXR0=AUXR0&(~(P60OC0|P60OC1))
#define CLK_P60OC_MCK()			AUXR0=(AUXR0&(~(P60OC0|P60OC1)))|(P60OC0)
#define CLK_P60OC_MCKDiv2()		AUXR0=(AUXR0&(~(P60OC0|P60OC1)))|(P60OC1)
#define CLK_P60OC_MCKDiv4()		AUXR0=AUXR0|((P60OC0|P60OC1))

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TIMER0 & TIMER1 
*
*************************************************************************************
*/
// ʹܻرTIMER
#define TM_DisableT0()			TR0=0					
#define TM_EnableT0()			TR0=1
#define TM_DisableT1()			TR1=0					
#define TM_EnableT1()			TR1=1

// ѡTIMERģʽ
#define TM_SetT0Mode_0_8BIT_PWM()				TMOD=(TMOD&(~(T0M0|T0M1)))
#define TM_SetT0Mode_1_16BIT_TIMER()			TMOD=(TMOD&(~(T0M0|T0M1)))|(T0M0)
#define TM_SetT0Mode_2_8BIT_AUTORELOAD()		TMOD=(TMOD&(~(T0M0|T0M1)))|(T0M1)
#define TM_SetT0Mode_3_TWO_8BIT()				TMOD=(TMOD|(T0M0|T0M1))

#define TM_SetT0Gate_Disable()					TMOD=TMOD&(~T0GATE)
#define TM_SetT0Gate_INT0()						TMOD=TMOD|T0GATE

#define TM_SetT1Mode_0_8BIT_PWM()				TMOD=(TMOD&(~(T1M0|T1M1)))          
#define TM_SetT1Mode_1_16BIT_TIMER()			TMOD=(TMOD&(~(T1M0|T1M1)))|(T1M0)    
#define TM_SetT1Mode_2_8BIT_AUTORELOAD()		TMOD=(TMOD&(~(T1M0|T1M1)))|(T1M1)    
#define TM_SetT1Mode_3_Disable()				TMOD=(TMOD|(T1M0|T1M1))             

#define TM_SetT1Gate_Disable()					TMOD=TMOD&(~T1GATE)
#define TM_SetT1Gate_TI1()						TMOD=TMOD|T1GATE

// ѡTIMERʱԴ
#define TM_SetT0Clock_SYSCLKDiv12()				AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_T0Port()					AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD|(T0C_T))
#define TM_SetT0Clock_SYSCLK()					AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_ILRCO()					AUXR3=(AUXR3&(~T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD|(T0C_T))
#define TM_SetT0Clock_SYSCLKDiv48()				AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_WDTPS()					AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2&(~T0X12));TMOD=(TMOD|(T0C_T))
#define TM_SetT0Clock_SYSCLKDiv192()			AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD&(~T0C_T))
#define TM_SetT0Clock_T1OF()					AUXR3=(AUXR3|(T0XL));AUXR2=(AUXR2|(T0X12));TMOD=(TMOD|(T0C_T))

#define TM_SetT1Clock_SYSCLKDiv12()				AUXR2=(AUXR2&(~T1X12));TMOD=(TMOD&(~T1C_T))
#define TM_SetT1Clock_T1Port()					AUXR2=(AUXR2&(~T1X12));TMOD=(TMOD|(T1C_T))
#define TM_SetT1Clock_SYSCLK()					AUXR2=(AUXR2|(T1X12));TMOD=(TMOD&(~T1C_T))
#define TM_SetT1Clock_SYSCLKDiv48()				AUXR2=(AUXR2|(T1X12));TMOD=(TMOD|(T1C_T))


// TIMERֵ
#define TM_SetT0HighByte(x)			TH0=x
#define TM_SetT0LowByte(x)			TL0=x

#define TM_SetT1HighByte(x)			TH1=x
#define TM_SetT1LowByte(x)			TL1=x

// TIMER
#define TM_SetT0CKOT1CKO_P34P35()			AUXR1=AUXR1&(~(T01PS0))
#define TM_SetT0CKOT1CKO_P55P56()			AUXR1=AUXR1|(T01PS0)


// TIMER CKOʹ/ֹ
#define TM_EnT0CKO()				AUXR2=AUXR2|(T0CKOE)
#define TM_EnT1CKO()				AUXR2=AUXR2|(T1CKOE)

#define TM_DisT0CKO()				AUXR2=AUXR2&(~T0CKOE)
#define TM_DisT1CKO()				AUXR2=AUXR2&(~T1CKOE)


/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TIMER2
*
*************************************************************************************
*/
// ʹܻرTIMER2
#define TM_DisableT2()			TR2=0					
#define TM_EnableT2()			TR2=1

// ʹܻرTL2
#define TM_DisableTL2()			T2MOD=T2MOD&(~TR2L)					
#define TM_EnableTL2()			T2MOD=T2MOD|(TR2L)	

// ʹܻرӲTR2L
#define TM_DisableTR2LC()			T2MOD=T2MOD&(~TR2LC)					
#define TM_EnableTR2LC()			T2MOD=T2MOD|(TR2LC)	

// ѡTIMER2ģʽ
#define TM_SetT2Mode_AutoRLandExI()			CP_RL2=0;T2MOD=T2MOD&(~T2MS0)
#define TM_SetT2Mode_AutoRLwithExI()		CP_RL2=0;T2MOD=T2MOD|(T2MS0)
#define TM_SetT2Mode_Capture()				CP_RL2=1;T2MOD=T2MOD&(~T2MS0)
#define TM_SetT2Mode_CapturewithAutoZero()	CP_RL2=1;T2MOD=T2MOD|(T2MS0)

// TIMER2ָģʽ
#define TM_EnT2Split()					T2MOD=T2MOD|(T2SPL)
#define TM_DisT2Split()					T2MOD=T2MOD&(~T2SPL)

// TIMER2
#define TM_EnT2CKO()					T2MOD=T2MOD|(T2OE)
#define TM_DisT2CKO()					T2MOD=T2MOD&(~T2OE)

// ѡTIMER2ʱԴ
#define TM_SetT2Clock_SYSCLKDiv12()		C_T2=0;T2MOD=T2MOD&(~T2X12);SFRPI=1;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_T2Pin()			C_T2=1;T2MOD=T2MOD&(~T2X12);SFRPI=1;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_SYSCLK()			C_T2=0;T2MOD=T2MOD|(T2X12);SFRPI=1;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0
#define TM_SetT2Clock_INT0ET()			C_T2=1;T2MOD=T2MOD|(T2X12);SFRPI=1;T2MOD1=T2MOD1&(~T2CKS);SFRPI=0	
#define TM_SetT2Clock_S1TOF()			C_T2=0;T2MOD=T2MOD&(~T2X12);SFRPI=1;T2MOD1=T2MOD1|(T2CKS);SFRPI=0
#define TM_SetT2Clock_T0OF()			C_T2=1;T2MOD=T2MOD&(~T2X12);SFRPI=1;T2MOD1=T2MOD1|(T2CKS);SFRPI=0
#define TM_SetT2Clock_AC0ES()			C_T2=0;T2MOD=T2MOD|(T2X12);SFRPI=1;T2MOD1=T2MOD1|(T2CKS);SFRPI=0
#define TM_SetT2Clock_AC1ES()			C_T2=1;T2MOD=T2MOD|(T2X12);SFRPI=1;T2MOD1=T2MOD1|(T2CKS);SFRPI=0

// ѡTIMER2ָģʽTL2ʱԴ
#define TM_SetTL2Clock_SYSCLKDiv12()	T2MOD=T2MOD&(~TL2X12);SFRPI=1;T2MOD1=T2MOD1&(~TL2CS);SFRPI=0
#define TM_SetTL2Clock_SYSCLK()			T2MOD=T2MOD|(TL2X12);SFRPI=1;T2MOD1=T2MOD1&(~TL2CS);SFRPI=0
#define TM_SetTL2Clock_S0TOF()			T2MOD=T2MOD&(~TL2X12);SFRPI=1;T2MOD1=T2MOD1|(TL2CS);SFRPI=0
#define TM_SetTL2Clock_INTET()			T2MOD=T2MOD1|(TL2X12);SFRPI=1;T2MOD1=T2MOD1|(TL2CS);SFRPI=0


// ѡTIMER2׽ģʽµĲ׽Դ
#define TM_SetT2Capture_T2EXPin()		SFRPI=1;T2MOD1=T2MOD1&(0xF8);SFRPI=0
#define TM_SetT2Capture_RXD0()			SFRPI=1;T2MOD1=(T2MOD1&(0xF8))|(CP2S0);SFRPI=0
#define TM_SetT2Capture_P60()			SFRPI=1;T2MOD1=(T2MOD1&(0xF8))|(CP2S1);SFRPI=0
#define TM_SetT2Capture_INT2ET()		SFRPI=1;T2MOD1=(T2MOD1&(0xF8))|(CP2S0|CP2S1);SFRPI=0	
#define TM_SetT2Capture_RXD1()			SFRPI=1;T2MOD1=(T2MOD1&(0xF8))|(CP2S2);SFRPI=0
#define TM_SetT2Capture_AC0OUT()		SFRPI=1;T2MOD1=(T2MOD1&(0xF8))|(CP2S0|CP2S2);SFRPI=0
#define TM_SetT2Capture_AC1OUT()		SFRPI=1;T2MOD1=(T2MOD1&(0xF8))|(CP2S1|CP2S2);SFRPI=0
#define TM_SetT2Capture_TWSI_SCL()		SFRPI=1;T2MOD1=T2MOD1|(CP2S0|CP2S1|CP2S2);SFRPI=0

// TIMER2
#define TM_SetT2CKOT2EX_P10P11()		AUXR3=AUXR3&(~T2PS0)
#define TM_SetT2CKOT2EX_P36P37()		AUXR3=AUXR3|(T2PS0)

// TIMER2жϼ
#define TM_EnableT2EX_DetectFalling()					EXEN2=1
#define TM_DisableT2EX_DetectFalling()					EXEN2=0
#define TM_EnableT2EX_DetectRising()					T2MOD=T2MOD|T2EXH
#define TM_DisableT2EX_DetectRising()					T2MOD=T2MOD&(~T2EXH)

// TIMER2ֵ
#define TM_SetT2HighByte(x)			TH2=x
#define TM_SetT2LowByte(x)			TL2=x

#define TM_SetT2RLHighByte(x)		RCAP2H=x
#define TM_SetT2RLLowByte(x)		RCAP2L=x

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TIMER3
*
*************************************************************************************
*/
// ʹܻرTIMER3
#define TM_DisableT3()			SFRPI=1;TR3=0;SFRPI=0					
#define TM_EnableT3()			SFRPI=1;TR3=1;SFRPI=0

// ʹܻرTL3
#define TM_DisableTL3()			SFRPI=1;T3MOD=T3MOD&(~TR3L);SFRPI=0				
#define TM_EnableTL3()			SFRPI=1;T3MOD=T3MOD|(TR3L);SFRPI=0	

// ʹܻرӲTR3L
#define TM_DisableTR3LC()			SFRPI=1;T3MOD=T3MOD&(~TR3LC);SFRPI=0					
#define TM_EnableTR3LC()			SFRPI=1;T3MOD=T3MOD|(TR3LC);SFRPI=0	

// ѡTIMER3ģʽ
#define TM_SetT3Mode_AutoRLandExI()			SFRPI=1;CP_RL3=0;T3MOD=T3MOD&(~T3MS0);SFRPI=0
#define TM_SetT3Mode_AutoRLwithExI()		SFRPI=1;CP_RL3=0;T3MOD=T3MOD|(T3MS0);SFRPI=0
#define TM_SetT3Mode_Capture()				SFRPI=1;CP_RL3=1;T3MOD=T3MOD&(~T3MS0);SFRPI=0
#define TM_SetT3Mode_CapturewithAutoZero()	SFRPI=1;CP_RL3=1;T3MOD=T3MOD|(T3MS0);SFRPI=0

// TIMER3ָģʽ
#define TM_EnT3Split()					SFRPI=1;T3MOD=T3MOD|(T3SPL);SFRPI=0
#define TM_DisT3Split()					SFRPI=1;T3MOD=T3MOD&(~T3SPL);SFRPI=0

// TIMER3
#define TM_EnT3CKO()					SFRPI=1;T3MOD=T3MOD|(T3OE);SFRPI=0
#define TM_DisT3CKO()					SFRPI=1;T3MOD=T3MOD&(~T3OE);SFRPI=0

// ѡTIMER3ʱԴ
#define TM_SetT3Clock_SYSCLKDiv12()		SFRPI=1;C_T3=0;T3MOD=T3MOD&(~T3X12);SFRPI=2;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_T3Pin()			SFRPI=1;C_T3=1;T3MOD=T3MOD&(~T3X12);SFRPI=2;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_SYSCLK()			SFRPI=1;C_T3=0;T3MOD=T3MOD|(T3X12);SFRPI=2;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0
#define TM_SetT3Clock_INT1ET()			SFRPI=1;C_T3=1;T3MOD=T3MOD|(T3X12);SFRPI=2;T3MOD1=T3MOD1&(~T3CKS);SFRPI=0	
#define TM_SetT3Clock_S2TOF()			SFRPI=1;C_T3=0;T3MOD=T3MOD&(~T3X12);SFRPI=2;T3MOD1=T3MOD1|(T3CKS);SFRPI=0
#define TM_SetT3Clock_T0OF()			SFRPI=1;C_T3=1;T3MOD=T3MOD&(~T3X12);SFRPI=2;T3MOD1=T3MOD1|(T3CKS);SFRPI=0
#define TM_SetT3Clock_AC1ES()			SFRPI=1;C_T3=0;T3MOD=T3MOD|(T3X12);SFRPI=2;T3MOD1=T3MOD1|(T3CKS);SFRPI=0
#define TM_SetT3Clock_ILRCO()			SFRPI=1;C_T3=1;T3MOD=T3MOD|(T3X12);SFRPI=2;T3MOD1=T3MOD1|(T3CKS);SFRPI=0

// ѡTIMER3ָģʽTL3ʱԴ
#define TM_SetTL3Clock_SYSCLKDiv12()	SFRPI=1;T3MOD=T3MOD&(~TL3X12);SFRPI=2;T3MOD1=T3MOD1&(~TL3CS);SFRPI=0
#define TM_SetTL3Clock_SYSCLK()			SFRPI=1;T3MOD=T3MOD|(TL3X12);SFRPI=2;T3MOD1=T3MOD1&(~TL3CS);SFRPI=0
#define TM_SetTL3Clock_S2TOF()			SFRPI=1;T3MOD=T3MOD&(~TL3X12);SFRPI=2;T3MOD1=T3MOD1|(TL3CS);SFRPI=0
#define TM_SetTL3Clock_INT1ET()			SFRPI=1;T3MOD=T3MOD|(TL3X12);SFRPI=2;T3MOD1=T3MOD1|(TL3CS);SFRPI=0

// ѡTIMER3׽ģʽµĲ׽Դ
#define TM_SetT3Capture_T3EXPin()		SFRPI=2;T3MOD1=T3MOD1&(0xF8);SFRPI=0
#define TM_SetT3Capture_RXD0()			SFRPI=2;T3MOD1=(T3MOD1&(0xF8))|(CP3S0);SFRPI=0
#define TM_SetT3Capture_P60()			SFRPI=2;T3MOD1=(T3MOD1&(0xF8))|(CP3S1);SFRPI=0
#define	TM_SetT3Capture_INT3()			SFRPI=2;T3MOD1=(T3MOD1&(0xF8))|(CP3S0|CP3S1);SFRPI=0
#define TM_SetT3Capture_RXD2()			SFRPI=2;T3MOD1=(T3MOD1&(0xF8))|(CP3S2);SFRPI=0
#define TM_SetT3Capture_AC0OUT()		SFRPI=2;T3MOD1=(T3MOD1&(0xF8))|(CP3S0|CP3S2);SFRPI=0
#define TM_SetT3Capture_AC1OUT()		SFRPI=2;T3MOD1=(T3MOD1&(0xF8))|(CP3S1|CP3S2);SFRPI=0
#define TM_SetT3Capture_TWI1_SCL()		SFRPI=2;T3MOD1=T3MOD1|(CP3S0|CP3S1|CP3S2);SFRPI=0

// TIMER3
#define TM_SetT3CKOT3EX_P46P72()		SFRPI=2;AUXR5=AUXR5&(~(T3PS1|T3PS0));SFRPI=0
#define TM_SetT3CKOT3EX_P40P41()		SFRPI=2;AUXR5=(AUXR5&(~(T3PS1|T3PS0)))|(T3PS0);SFRPI=0
#define TM_SetT3CKOT3EX_P21P20()		SFRPI=2;AUXR5=(AUXR5&(~(T3PS1|T3PS0)))|(T3PS1);SFRPI=0
#define TM_SetT3CKOT3EX_P67P57()		SFRPI=2;AUXR5=AUXR5|((T3PS1|T3PS0));SFRPI=0

// TIMER3жϼ
#define TM_EnableT3EX_DetectFalling()					SFRPI=1;EXEN3=1;SFRPI=0
#define TM_DisableT3EX_DetectFalling()					SFRPI=1;EXEN3=0;SFRPI=0
#define TM_EnableT3EX_DetectRising()					SFRPI=1;T3MOD=T3MOD|T3EXH;SFRPI=0
#define TM_DisableT3EX_DetectRising()					SFRPI=1;T3MOD=T3MOD&(~T3EXH);SFRPI=0


// TIMER3ֵ
#define TM_SetT3HighByte(x)			SFRPI=1;TH3=x;SFRPI=0
#define TM_SetT3LowByte(x)			SFRPI=1;TL3=x;SFRPI=0

#define TM_SetT3RLHighByte(x)		SFRPI=1;RCAP3H=x;SFRPI=0
#define TM_SetT3RLLowByte(x)		SFRPI=1;RCAP3L=x;SFRPI=0

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TIMER4
*
*************************************************************************************
*/
// ʹܻرTIMER4
#define TM_DisableT4()			SFRPI=2;TR4=0;SFRPI=0					
#define TM_EnableT4()			SFRPI=2;TR4=1;SFRPI=0

// ʹܻرTL4
#define TM_DisableTL4()			SFRPI=2;T4MOD=T4MOD&(~TR4L);SFRPI=0				
#define TM_EnableTL4()			SFRPI=2;T4MOD=T4MOD|(TR4L);SFRPI=0	

// ʹܻرӲTR4L
#define TM_DisableTR4LC()			SFRPI=2;T4MOD=T4MOD&(~TR4LC);SFRPI=0					
#define TM_EnableTR4LC()			SFRPI=2;T4MOD=T4MOD|(TR4LC);SFRPI=0	

// ѡTIMER4ģʽ
#define TM_SetT4Mode_AutoRLandExI()			SFRPI=2;CP_RL4=0;T4MOD=T4MOD&(~T4MS0);SFRPI=0
#define TM_SetT4Mode_AutoRLwithExI()		SFRPI=2;CP_RL4=0;T4MOD=T4MOD|(T4MS0);SFRPI=0
#define TM_SetT4Mode_Capture()				SFRPI=2;CP_RL4=1;T4MOD=T4MOD&(~T4MS0);SFRPI=0
#define TM_SetT4Mode_CapturewithAutoZero()	SFRPI=2;CP_RL4=1;T4MOD=T4MOD|(T4MS0);SFRPI=0

// TIMER4ָģʽ
#define TM_EnT4Split()					SFRPI=2;T4MOD=T4MOD|(T4SPL);SFRPI=0
#define TM_DisT4Split()					SFRPI=2;T4MOD=T4MOD&(~T4SPL);SFRPI=0

// TIMER4
#define TM_EnT4CKO()					SFRPI=2;T4MOD=T4MOD|(T4OE);SFRPI=0
#define TM_DisT4CKO()					SFRPI=2;T4MOD=T4MOD&(~T4OE);SFRPI=0

// ѡTIMER4ʱԴ
#define TM_SetT4Clock_SYSCLKDiv12()		SFRPI=2;C_T4=0;T4MOD=T4MOD&(~T4X12);SFRPI=3;T4MOD1=T4MOD1&(~T4CKS);SFRPI=0
#define TM_SetT4Clock_T4Pin()			SFRPI=2;C_T4=1;T4MOD=T4MOD&(~T4X12);SFRPI=3;T4MOD1=T4MOD1&(~T4CKS);SFRPI=0
#define TM_SetT4Clock_SYSCLK()			SFRPI=2;C_T4=0;T4MOD=T4MOD|(T4X12);SFRPI=3;T4MOD1=T4MOD1&(~T4CKS);SFRPI=0
#define TM_SetT4Clock_INT2ET()			SFRPI=2;C_T4=1;T4MOD=T4MOD|(T4X12);SFRPI=3;T4MOD1=T4MOD1&(~T4CKS);SFRPI=0	
#define TM_SetT4Clock_S3TOF()			SFRPI=2;C_T4=0;T4MOD=T4MOD&(~T4X12);SFRPI=3;T4MOD1=T4MOD1|(T4CKS);SFRPI=0
#define TM_SetT4Clock_T0OF()			SFRPI=2;C_T4=1;T4MOD=T4MOD&(~T4X12);SFRPI=3;T4MOD1=T4MOD1|(T4CKS);SFRPI=0
#define TM_SetT4Clock_AC2ES()			SFRPI=2;C_T4=0;T4MOD=T4MOD|(T4X12);SFRPI=3;T4MOD1=T4MOD1|(T4CKS);SFRPI=0
#define TM_SetT4Clock_AC0ES()			SFRPI=2;C_T4=1;T4MOD=T4MOD|(T4X12);SFRPI=3;T4MOD1=T4MOD1|(T4CKS);SFRPI=0

// ѡTIMER4ָģʽTL4ʱԴ
#define TM_SetTL4Clock_SYSCLKDiv12()	SFRPI=2;T4MOD=T4MOD&(~TL4X12);SFRPI=3;T4MOD1=T4MOD1&(~TL4CS);SFRPI=0
#define TM_SetTL4Clock_SYSCLK()			SFRPI=2;T4MOD=T4MOD|(TL4X12);SFRPI=3;T4MOD1=T4MOD1&(~TL4CS);SFRPI=0
#define TM_SetTL4Clock_S3TOF()			SFRPI=2;T4MOD=T4MOD&(~TL4X12);SFRPI=3;T4MOD1=T4MOD1|(TL4CS);SFRPI=0
#define TM_SetTL4Clock_INT2ET()			SFRPI=2;T4MOD=T4MOD|(TL4X12);SFRPI=3;T4MOD1=T4MOD1|(TL4CS);SFRPI=0

// ѡTIMER4׽ģʽµĲ׽Դ
#define TM_SetT4Capture_T4EXPin()		SFRPI=3;T4MOD1=T4MOD1&(0xF8);SFRPI=0
#define TM_SetT4Capture_RXD0()			SFRPI=3;T4MOD1=(T4MOD1&(0xF8))|(CP4S0);SFRPI=0
#define TM_SetT4Capture_P60()			SFRPI=3;T4MOD1=(T4MOD1&(0xF8))|(CP4S1);SFRPI=0
#define TM_SetT4Capture_INT31ET()		SFRPI=3;T4MOD1=(T4MOD1&(0xF8))|(CP4S1|CP4S0);SFRPI=0
#define TM_SetT4Capture_RXD3()			SFRPI=3;T4MOD1=(T4MOD1&(0xF8))|(CP4S2);SFRPI=0
#define TM_SetT4Capture_AC0OUT()		SFRPI=3;T4MOD1=(T4MOD1&(0xF8))|(CP4S0|CP4S2);SFRPI=0
#define TM_SetT4Capture_AC2OUT()		SFRPI=3;T4MOD1=(T4MOD1&(0xF8))|(CP4S1|CP4S2);SFRPI=0
#define TM_SetT4Capture_TWI1_SCL()		SFRPI=3;T4MOD1=T4MOD1|(CP4S0|CP4S1|CP4S2);SFRPI=0

// TIMER4
#define TM_SetT4CKOT4EX_P70P71()		SFRPI=0x02;AUXR5=AUXR5&(~T4PS0);SFRPI=0
#define TM_SetT4CKOT4EX_P42P43()		SFRPI=0x02;AUXR5=AUXR5|(T4PS0);SFRPI=0

// TIMER4жϼ
#define TM_EnableT4EX_DetectFalling()					SFRPI=2;EXEN4=1;SFRPI=0
#define TM_DisableT4EX_DetectFalling()					SFRPI=2;EXEN4=0;SFRPI=0
#define TM_EnableT4EX_DetectRising()					SFRPI=2;T4MOD=T4MOD|T4EXH;SFRPI=0
#define TM_DisableT4EX_DetectRising()					SFRPI=2;T4MOD=T4MOD&(~T4EXH);SFRPI=0

// TIMER4ֵ
#define TM_SetT4HighByte(x)			SFRPI=2;TH4=x;SFRPI=0
#define TM_SetT4LowByte(x)			SFRPI=2;TL4=x;SFRPI=0

#define TM_SetT4RLHighByte(x)		SFRPI=2;RCAP4H=x;SFRPI=0
#define TM_SetT4RLLowByte(x)		SFRPI=2;RCAP4L=x;SFRPI=0


/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TIMER ȫֿ
*
*************************************************************************************
*/
#define	TIMER0_GLOBAL_BIT  		0x01
#define	TIMER1_GLOBAL_BIT  		0x02
#define	TIMER2_GLOBAL_BIT  		0x04
#define	TIMER3_GLOBAL_BIT  		0x08
#define	TIMER4_GLOBAL_BIT  		0x10
#define	TIMER2TL_GLOBAL_BIT 	0x20
#define	TIMER3TL_GLOBAL_BIT 	0x40
#define	TIMER4TL_GLOBAL_BIT 	0x80
// ȫʹTIMER
#define TM_GlobalStart(x)				SFRPI=1;TREN0=TREN0|x;SFRPI=0

// ȫִTimer
#define TM_GlobalReload(x)				SFRPI=2;TRLC0=TRLC0|x;SFRPI=0

// ȫֹͣTIMER
#define TM_GlobalSTOP(x)				SFRPI=3;TSPC0=TSPC0|x;SFRPI=0

/*
*************************************************************************************
*/ 


/*
*************************************************************************************
*  IO PORT 
*
*************************************************************************************
*/
// P3ģʽ
#define PORT_SetP3QuasiBi(x)				P3M0=P3M0&(~(x));P3M1=P3M1&(~(x))
#define PORT_SetP3PushPull(x)				P3M0=P3M0&(~(x));P3M1=P3M1|(x)
#define PORT_SetP3InputOnly(x)				P3M0=P3M0|(x);P3M1=P3M1&(~(x))
#define PORT_SetP3OpenDrain(x)				P3M0=P3M0|(x);P3M1=P3M1|(x)

// P0ģʽ
#define PORT_SetP0PushPull(x)				P0M0=P0M0|(x)
#define PORT_SetP0OpenDrain(x)				P0M0=P0M0&(~(x))

#define PORT_SetP0AInputOnly(x)				PxAIO1=PxAIO1|(x)		// no P00
#define PORT_SetP0DigitalIO(x)				PxAIO1=PxAIO1&(~(x))	// no P00

#define PORT_EnP00P01P02P03PullHigh()			PUCON0=PUCON0|(P0PU0)
#define PORT_DisP00P01P02P03PullHigh()			PUCON0=PUCON0&(~(P0PU0))
#define PORT_EnP04P05P06P07PullHigh()			PUCON0=PUCON0|(P0PU1)
#define PORT_DisP04P05P06P07PullHigh()			PUCON0=PUCON0&(~(P0PU1))

// P1ģʽ
#define PORT_SetP1PushPull(x)				P1M0=P1M0|(x)
#define PORT_SetP1OpenDrain(x)				P1M0=P1M0&(~(x))

#define PORT_SetP1AInputOnly(x)				P1AIO=P1AIO|(x)
#define PORT_SetP1DigitalIO(x)				P1AIO=P1AIO&(~(x))	// no P00

#define PORT_EnP10P11P12P13PullHigh()		PUCON0=PUCON0|P1PU0
#define PORT_DisP10P11P12P13PullHigh()		PUCON0=PUCON0&(P1PU0)
#define PORT_EnP14P15P16P17PullHigh()		PUCON0=PUCON0|P1PU1
#define PORT_DisP14P15P16P17PullHigh()		PUCON0=PUCON0&(P1PU1)

// P2ģʽ
#define PORT_SetP2PushPull(x)				P2M0=P2M0|(x)
#define PORT_SetP2OpenDrain(x)				P2M0=P2M0&(~(x))

#define PORT_SetP20AInputOnly()				SFRPI=1;PxAIO2=PxAIO2|(P20AIO);SFRPI=0			
#define PORT_SetP20DigitalIO()				SFRPI=1;PxAIO2=PxAIO2&(~(P20AIO));SFRPI=0			

#define PORT_EnP20P21P22P23PullHigh()		PUCON0=PUCON0|P2PU0
#define PORT_DisP20P21P22P23PullHigh()		PUCON0=PUCON0&(P2PU0)
#define PORT_EnP24P25P26P27PullHigh()		PUCON0=PUCON0|P2PU1
#define PORT_DisP24P25P26P27PullHigh()		PUCON0=PUCON0&(P2PU1)

// P4ģʽ
#define PORT_SetP4PushPull(x)				P4M0=P4M0|(x)
#define PORT_SetP4OpenDrain(x)				P4M0=P4M0&(~(x))
#define PORT_EnP40P41P42P43PullHigh()			PUCON0=PUCON0|(P4PU0)
#define PORT_DisP40P41P42P43PullHigh()			PUCON0=PUCON0&(~(P4PU0))
#define PORT_EnP44P45P46P47PullHigh()			PUCON0=PUCON0|(P4PU1)
#define PORT_DisP44P45P46P47PullHigh()			PUCON0=PUCON0&(~(P4PU1))
                                                                               
// P5ģʽ
#define PORT_SetP5PushPull(x)				P5M0=P5M0|(x)
#define PORT_SetP5OpenDrain(x)				P5M0=P5M0&(~(x))
#define PORT_EnP50P51P52P53PullHigh()			SFRPI=1;PUCON1=PUCON1|(P5PU0);SFRPI=0
#define PORT_DisP50P52P52P53PullHigh()			SFRPI=1;PUCON1=PUCON1&(~(P5PU0));SFRPI=0
#define PORT_EnP54P55P56P57PullHigh()			SFRPI=1;PUCON1=PUCON1|(P5PU1);SFRPI=0
#define PORT_DisP54P55P56P57PullHigh()			SFRPI=1;PUCON1=PUCON1&(~(P5PU1));SFRPI=0

// P6ģʽ
#define PORT_SetP6PushPull(x)				SFRPI=1;P6M0=P6M0|(x);SFRPI=0
#define PORT_SetP6OpenDrain(x)				SFRPI=1;P6M0=P6M0&(~(x));SFRPI=0

#define PORT_SetP62P63AInputOnly()			PxAIO1=PxAIO1|(AC2AIO)			
#define PORT_SetP62P63DigitalIO()			PxAIO1=PxAIO1&(~(AC2AIO))			


#define PORT_EnP60P61P62P63PullHigh()			SFRPI=1;PUCON1=PUCON1|(P6PU0);SFRPI=0
#define PORT_DisP60P61P62P63PullHigh()			SFRPI=1;PUCON1=PUCON1&(~(P6PU0));SFRPI=0
#define PORT_EnP64P65P66P67PullHigh()			SFRPI=1;PUCON1=PUCON1|(P6PU1);SFRPI=0
#define PORT_DisP64P65P66P67PullHigh()			SFRPI=1;PUCON1=PUCON1&(~(P6PU1));SFRPI=0

// P7ģʽ
#define PORT_SetP7PushPull(x)				SFRPI=2;P7M0=P7M0|(x);SFRPI=0
#define PORT_SetP7OpenDrain(x)				SFRPI=2;P7M0=P7M0&(~(x));SFRPI=0

#define PORT_EnP70P71P72PullHigh()			SFRPI=1;PUCON1=PUCON1|(P7PU0);SFRPI=0
#define PORT_DisP70P71P72PullHigh()			SFRPI=1;PUCON1=PUCON1&(~(P7PU0));SFRPI=0
/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TWI0 
*
*************************************************************************************
*/
// TWI0
#define TWI0_Clear()				SICON=0
// رTWI0
#define TWI0_Disable()						SICON=SICON&(~ENSI)					
#define TWI0_Enable()						SICON=SICON|(ENSI)

// ѡTWI0 Ĵٶ  1MHz, ӻͬκƵ,֧400KHz
#define TWI0_CLK_SYSCLK_8	0	// SYSCLK/8
#define TWI0_CLK_SYSCLK_16	1	// SYSCLK/16
#define TWI0_CLK_SYSCLK_32	2	// SYSCLK/32
#define TWI0_CLK_SYSCLK_64	3	// SYSCLK/64
#define TWI0_CLK_SYSCLK_128	4	// SYSCLK/128
#define TWI0_CLK_SYSCLK_256	5	// SYSCLK/256
#define TWI0_CLK_T0OF_6		7	// T0OF/6	

#define TWI0_SetClock(x)			SICON=(SICON&B01111100)|((x&0x03)|((x<<5)&B10000000))

#define TWI0_SetSlaveAddr(x)		SIADR=x			// ôӻַ
#define TWI0_SendACK()				SICON |= AA		// ACK
#define TWI0_SendNOACK()			SICON &= ~AA	//  NO ACK
#define TWI0_SendSTART()			SICON |= STA	// ʼλ
#define TWI0_ClearSTART()			SICON &= ~STA	// ʼ־
#define TWI0_SendSTOP()				SICON |= STO	// ֹͣλֹͣ־Ӳ
#define TWI0_ClearSI()				SICON &= ~SI	// TWIжϱ־

// ѡTWI0 õIO
#define TWI0_SetSCLSDAP40P41()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))
#define TWI0_SetSCLSDAP60P61()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))|TWIPS0
#define TWI0_SetSCLSDAP30P31()			AUXR3=(AUXR3&(~(TWIPS1|TWIPS0)))|TWIPS1
#define TWI0_SetSCLSDAP22P24()			AUXR3=(AUXR3|(TWIPS1|TWIPS0))


/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  TWI1 
*
*************************************************************************************
*/
// TWI1
#define TWI1_Clear()				SFRPI=1;SI1CON=0;SFRPI=0
// رTWI1
#define TWI1_Disable()				SFRPI=1;SI1CON=SI1CON&(~ENSI1);SFRPI=0					
#define TWI1_Enable()				SFRPI=1;SI1CON=SI1CON|(ENSI1);SFRPI=0 

// ѡTWI1 Ĵٶ  1MHz, ӻͬκƵ,֧400KHz
#define TWI1_CLK_SYSCLK_8	0	// SYSCLK/8
#define TWI1_CLK_SYSCLK_16	1	// SYSCLK/16
#define TWI1_CLK_SYSCLK_32	2	// SYSCLK/32
#define TWI1_CLK_SYSCLK_64	3	// SYSCLK/64
#define TWI1_CLK_SYSCLK_128	4	// SYSCLK/128
#define TWI1_CLK_SYSCLK_256	5	// SYSCLK/256
#define TWI1_CLK_S1TOF_6	6	// S1TOF/6	
#define TWI1_CLK_T0OF_6		7	// T0OF/6	

#define TWI1_SetClock(x)			SFRPI=1;SI1CON=(SI1CON&B01111100)|((x&0x03)|((x<<5)&B10000000));SFRPI=0

#define TWI1_SetSlaveAddr(x)		SFRPI=1;SI1ADR=x;SFRPI=0			// ôӻַ
#define TWI1_SendACK()				SFRPI=1;SI1CON |= AA1;SFRPI=0		// ACK
#define TWI1_SendNOACK()			SFRPI=1;SI1CON &= ~AA1;SFRPI=0		//  NO ACK
#define TWI1_SendSTART()			SFRPI=1;SI1CON |= STA1;SFRPI=0		// ʼλ
#define TWI1_ClearSTART()			SFRPI=1;SI1CON &= ~STA1;SFRPI=0		// ʼ־
#define TWI1_SendSTOP()				SFRPI=1;SI1CON |= STO1;SFRPI=0		// ֹͣλֹͣ־Ӳ
#define TWI1_ClearSI()				SFRPI=1;SI1CON &= ~SI1;SFRPI=0		// TWIжϱ־


// ѡTWI1 õIO SCL/SDA
#define TWI1_SetSCLSDAP42P43()			SFRPI=3;AUXR6=(AUXR6&(~(TWI1PS1|TWI1PS0)));SFRPI=0
#define TWI1_SetSCLSDAP62P63()			SFRPI=3;AUXR6=(AUXR6&(~(TWI1PS1|TWI1PS0)))|TWI1PS0;SFRPI=0
#define TWI1_SetSCLSDAP32P33()			SFRPI=3;AUXR6=(AUXR6&(~(TWI1PS1|TWI1PS0)))|TWI1PS1;SFRPI=0
#define TWI1_SetSCLSDAP03P04()			SFRPI=3;AUXR6=(AUXR6|(TWI1PS1|TWI1PS0));SFRPI=0


/*
*************************************************************************************
*/ 


/*
*************************************************************************************
*  UART0 
*
*************************************************************************************
*/
// UART0 UART0ģʽ
#define UART0_SetModeShiftReg()				S0CFG=S0CFG&(~SM30);SM00_FE=0;SM10=0
#define UART0_SetMode8bitUARTVar()			S0CFG=S0CFG&(~SM30);SM00_FE=0;SM10=1
#define UART0_SetMode9bitUART()				S0CFG=S0CFG&(~SM30);SM00_FE=1;SM10=0
#define UART0_SetMode9bitUARTVar()			S0CFG=S0CFG&(~SM30);SM00_FE=1;SM10=1
#define UART0_SetModeSPIMaster()			S0CFG=S0CFG|(SM30);SM00_FE=0;SM10=0

// UART0 /رԶַʶ
#define UART0_EnAutoAddressRecognition()	SM20=1
#define UART0_DisAutoAddressRecognition()	SM20=0

// UART0 /رսݹ
#define UART0_EnReception()					REN0=1
#define UART0_DisReception()				REN0=0

// UART0 SPI MASTERSPIٶ
#define UART0_SetSPIClock_SYSCLKDiv4()		S0CFG=S0CFG|(URM0X3)
#define UART0_SetSPIClock_SYSCLKDiv12()		S0CFG=S0CFG&(~URM0X3)

// UART0 λ(MSB:λǰ,LSB:λǰ)
#define UART0_SetDataMSB()					S0CFG=S0CFG&(~S0DOR)
#define UART0_SetDataLSB()					S0CFG=S0CFG|(S0DOR)

// UART0 /رӦжTI0
#define UART0_EnTI0toS0Interrupt()			S0CFG=S0CFG&(~BTI)
#define UART0_DisTI0toS0Interrupt()			S0CFG=S0CFG|(BTI)

// UART0 /رϵͳ־жӦжTI0
#define UART0_EnTI0toSysFlagInterrupt()		S0CFG=S0CFG|(UTIE)
#define UART0_DisTI0toSysFlagInterrupt()	S0CFG=S0CFG&(~UTIE)

// UART0 ôӻַ
#define UART0_SetSlaveAddr(x)				SADDR=x

// UART0 ôӻַ
#define UART0_SetSlaveAddrMask(x)			SADEN=x

// UART0 òʼӱ 
#define UART0_SetBaudRateX1()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetBaudRateX2()				PCON0=PCON0|(SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetBaudRateX4()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)
#define UART0_SetBaudRateX8()				PCON0=PCON0|(SMOD1);S0CFG=S0CFG|(SMOD2)

#define UART0_SetT1BaudRateX1()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetT1BaudRateX2()				PCON0=PCON0|(SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetT1BaudRateX4()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)
#define UART0_SetT1BaudRateX8()				PCON0=PCON0|(SMOD1);S0CFG=S0CFG|(SMOD2)

#define UART0_SetT2BaudRateX1()				S0CFG=S0CFG&(~SMOD2)
#define UART0_SetT2BaudRateX2()				PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)
#define UART0_SetT2BaudRateX4()				PCON0=PCON0|(SMOD1);S0CFG=S0CFG|(SMOD2)


#define UART0_SetS1BRGBaudRateX1()			PCON0=PCON0&(~SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetS1BRGBaudRateX2()			PCON0=PCON0|(SMOD1);S0CFG=S0CFG&(~SMOD2)
#define UART0_SetS1BRGBaudRateX4()			PCON0=PCON0&(~SMOD1);S0CFG=S0CFG|(SMOD2)
#define UART0_SetS1BRGBaudRateX8()			PCON0=PCON0|(SMOD1);S0CFG=S0CFG|(SMOD2)

// UART òԴ
#define UART0_SetBRGFromT1()				RCLK=0;TCLK=0;S0CFG=S0CFG&(~URTS)		
#define UART0_SetBRGFromT2()				RCLK=1;TCLK=1
#define UART0_SetBRGFromS1BRG()				RCLK=0;TCLK=0;S0CFG=S0CFG|(URTS)


// UART SPI Masterģʽ MISO
#define UART_SetS0MIS1MIS2MIS3MI_P40P41P42P43()		SFRPI=2;AUXR5=AUXR5&(~(SnMIPS));SFRPI=0
#define UART_SetS0MIS1MIS2MIS3MI_P53P54P55P56()		SFRPI=2;AUXR5=AUXR5|(SnMIPS);SFRPI=0
/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  UART1 
*
*************************************************************************************
*/
// UART1 UART1ģʽ
#define UART1_SetModeShiftReg()				SFRPI=1;S1CFG=S1CFG&(~SM31);SM01=0;SM11=0
#define UART1_SetMode8bitUARTVar()			SFRPI=1;S1CFG=S1CFG&(~SM31);SM01=0;SM11=1
#define UART1_SetMode9bitUART()				SFRPI=1;S1CFG=S1CFG&(~SM31);SM01=1;SM11=0
#define UART1_SetMode9bitUARTVar()			SFRPI=1;S1CFG=S1CFG&(~SM31);SM01=1;SM11=1
#define UART1_SetModeSPIMaster()			SFRPI=1;S1CFG=S1CFG|(SM31);SM01=0;SM11=0


// UART1 /رսݹ
#define UART1_EnReception()					SFRPI=1;REN1=1;SFRPI=0
#define UART1_DisReception()				SFRPI=1;REN1=0;SFRPI=0

// UART1 λ(MSB:λǰ,LSB:λǰ)
#define UART1_SetDataMSB()					SFRPI=1;S1CFG=S1CFG&(~S1DOR);SFRPI=0
#define UART1_SetDataLSB()					SFRPI=1;S1CFG=S1CFG|(S1DOR);SFRPI=0

// UART1 òʼӱ 
#define UART1_SetBaudRateX1()				SFRPI=1;S1CFG=S1CFG&(~S1MOD1);SFRPI=0
#define UART1_SetBaudRateX2()				SFRPI=1;S1CFG=S1CFG|(S1MOD1);SFRPI=0

// UART1 /رղʷ
#define UART1_EnS1BRG()						SFRPI=1;S1CFG=S1CFG|(S1TR);SFRPI=0
#define UART1_DisS1BRG()					SFRPI=1;S1CFG=S1CFG&(~S1TR);SFRPI=0


// UART1 S1BRGʱԴ
#define UART1_SetS1BRGSelSYSCLK()			SFRPI=1;S1CFG=S1CFG|(S1TX12);SFRPI=0
#define UART1_SetS1BRGSelSYSCLKdiv12()		SFRPI=1;S1CFG=S1CFG&(~S1TX12);SFRPI=0

// UART1 S1BRG Value
#define UART1_SetS1BRGValue(x)				SFRPI=1;S1BRT=x;S1BRC=x;SFRPI=0

// UART1 ѡUART1 õIO
#define UART1_SetRxTxP12P13()			SFRPI=3;AUXR6=AUXR6&(~S1PS2);SFRPI=0;AUXR1=(AUXR1&(~(S1PS0|S1PS1)))
#define UART1_SetRxTxP32P33()			SFRPI=3;AUXR6=AUXR6&(~S1PS2);AUXR1=(AUXR1&(~(S1PS0|S1PS1)))|(S1PS0)
#define UART1_SetRxTxP06P07()			SFRPI=3;AUXR6=AUXR6&(~S1PS2);AUXR1=(AUXR1&(~(S1PS0|S1PS1)))|(S1PS1)
#define UART1_SetRxTxP00P05()			SFRPI=3;AUXR6=AUXR6&(~S1PS2);AUXR1=AUXR1|((S1PS0|S1PS1))
#define UART1_SetRxTxP70P71()			SFRPI=3;AUXR6=AUXR6|S1PS2;SFRPI=0


/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  UART2 
*
*************************************************************************************
*/
// UART2 UART2ģʽ
#define UART2_SetModeShiftReg()				SFRPI=3;S2CFG=S2CFG&(~SM32);SM02=0;SM12=0;SFRPI=0
#define UART2_SetMode8bitUARTVar()			SFRPI=3;S2CFG=S2CFG&(~SM32);SM02=0;SM12=1;SFRPI=0
#define UART2_SetMode9bitUART()				SFRPI=3;S2CFG=S2CFG&(~SM32);SM02=1;SM12=0;SFRPI=0
#define UART2_SetMode9bitUARTVar()			SFRPI=3;S2CFG=S2CFG&(~SM32);SM02=1;SM12=1;SFRPI=0
#define UART2_SetModeSPIMaster()			SFRPI=3;S2CFG=S2CFG|(SM32);SM02=0;SM12=0;SFRPI=0
#define UART2_SetMode8BitTimer()			SFRPI=3;S2CFG=S2CFG|(S2TME);S2CFG=S2CFG&(~S2DOR);SFRPI=0
#define UART2_SetMode16BitTimer()			SFRPI=3;S2CFG=S2CFG|(S2TME);S2CFG=S2CFG|(S2DOR);SFRPI=0

// UART2 /رսݹ
#define UART2_EnReception()					SFRPI=3;REN2=1;SFRPI=0
#define UART2_DisReception()				SFRPI=3;REN2=0;SFRPI=0

// UART2 λ(MSB:λǰ,LSB:λǰ)
#define UART2_SetDataMSB()					SFRPI=3;S2CFG=S2CFG&(~S2DOR);SFRPI=0
#define UART2_SetDataLSB()					SFRPI=3;S2CFG=S2CFG|(S2DOR);SFRPI=0

// UART2 òʼӱ 
#define UART2_SetBaudRateX1()				SFRPI=3;S2CFG=S2CFG&(~S2MOD1);SFRPI=0
#define UART2_SetBaudRateX2()				SFRPI=3;S2CFG=S2CFG|(S2MOD1);SFRPI=0

// UART2 /رղʷ
#define UART2_EnS2BRG()						SFRPI=3;S2CFG=S2CFG|(S2TR);SFRPI=0
#define UART2_DisS2BRG()					SFRPI=3;S2CFG=S2CFG&(~S2TR);SFRPI=0

// UART2 S2BRGʱԴ
#define UART2_SetS2BRGSelSYSCLK()			SFRPI=3;S2CFG=S2CFG|(S2TX12);SFRPI=0
#define UART2_SetS2BRGSelSYSCLKdiv12()		SFRPI=3;S2CFG=S2CFG&(~S2TX12);SFRPI=0

// UART2 S2BRG Value
#define UART2_SetS2BRGValue(x)				SFRPI=3;S2BRT=x;S2BRC=x;SFRPI=0

// UART2 ѡUART2 õIO
#define UART2_SetRxTxP32P33()				SFRPI=2;AUXR5=AUXR5&(~S2PS0);SFRPI=0
#define UART2_SetRxTxP57P67()				SFRPI=2;AUXR5=AUXR5|S2PS0;SFRPI=0


/*
*************************************************************************************
*  UART3 
*
*************************************************************************************
*/
// UART3 UART3ģʽ
#define UART3_SetModeShiftReg()				SFRPI=4;S3CFG=S3CFG&(~SM33);SM03=0;SM13=0;SFRPI=0
#define UART3_SetMode8bitUARTVar()			SFRPI=4;S3CFG=S3CFG&(~SM33);SM03=0;SM13=1;SFRPI=0
#define UART3_SetMode9bitUART()				SFRPI=4;S3CFG=S3CFG&(~SM33);SM03=1;SM13=0;SFRPI=0
#define UART3_SetMode9bitUARTVar()			SFRPI=4;S3CFG=S3CFG&(~SM33);SM03=1;SM13=1;SFRPI=0
#define UART3_SetModeSPIMaster()			SFRPI=4;S3CFG=S3CFG|(SM33);SM03=0;SM13=0;SFRPI=0
#define UART3_SetMode8BitTimer()			SFRPI=4;S3CFG=S3CFG|(S3TME);S3CFG=S3CFG&(~S3DOR);SFRPI=0
#define UART3_SetMode16BitTimer()			SFRPI=4;S3CFG=S3CFG|(S3TME);S3CFG=S3CFG|(S3DOR);SFRPI=0

// UART3 /رսݹ
#define UART3_EnReception()					SFRPI=4;REN3=1;SFRPI=0
#define UART3_DisReception()				SFRPI=4;REN3=0;SFRPI=0

// UART3 λ(MSB:λǰ,LSB:λǰ)
#define UART3_SetDataMSB()					SFRPI=4;S3CFG=S3CFG&(~S3DOR);SFRPI=0
#define UART3_SetDataLSB()					SFRPI=4;S3CFG=S3CFG|(S3DOR);SFRPI=0

// UART3 òʼӱ 
#define UART3_SetBaudRateX1()				SFRPI=4;S3CFG=S3CFG&(~S3MOD1);SFRPI=0
#define UART3_SetBaudRateX2()				SFRPI=4;S3CFG=S3CFG|(S3MOD1);SFRPI=0

// UART3 /رղʷ
#define UART3_EnS3BRG()						SFRPI=4;S3CFG=S3CFG|(S3TR);SFRPI=0
#define UART3_DisS3BRG()					SFRPI=4;S3CFG=S3CFG&(~S3TR);SFRPI=0

// UART3 S3BRGʱԴ
#define UART3_SetS3BRGSelSYSCLK()			SFRPI=4;S3CFG=S3CFG|(S3TX12);SFRPI=0
#define UART3_SetS3BRGSelSYSCLKdiv12()		SFRPI=4;S3CFG=S3CFG&(~S3TX12);SFRPI=0

// UART3 S3BRG Value
#define UART3_SetS3BRGValue(x)				SFRPI=4;S3BRT=x;S3BRC=x;SFRPI=0

// UART3 ѡUART3 õIO
#define UART3_SetRxTxP36P37()				SFRPI=2;AUXR5=AUXR5&(~S3PS0);SFRPI=0
#define UART3_SetRxTxP65P66()				SFRPI=2;AUXR5=AUXR5|S3PS0;SFRPI=0

/*
*************************************************************************************
*/ 


/*
*************************************************************************************
*  ADC
*
*************************************************************************************
*/
// رADC
#define ADC_Disable()						ADCON0=ADCON0&(~ADCEN)					
#define ADC_Enable()						ADCON0=ADCON0|(ADCEN)

// رADC
#define ADC_SoftStart()						ADCON0=ADCON0|(ADCS)					

// ADCתʱԴ
#define ADC_SetClock_SYSCLK()				ADCFG0=ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2))
#define ADC_SetClock_SYSCLKDiv2()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS0)
#define ADC_SetClock_SYSCLKDiv4()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS1)
#define ADC_SetClock_SYSCLKDiv8()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS0|ADCKS1)
#define ADC_SetClock_SYSCLKDiv16()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS2)
#define ADC_SetClock_SYSCLKDiv32()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS0|ADCKS2)
#define ADC_SetClock_S3TOFDiv2()			ADCFG0=(ADCFG0&(~(ADCKS0|ADCKS1|ADCKS2)))|(ADCKS1|ADCKS2)
#define ADC_SetClock_T4OFDiv2()				ADCFG0=ADCFG0|(ADCKS0|ADCKS1|ADCKS2)

// ADCתͨ
#define ADC_SetChannel_AIN0()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))
#define ADC_SetChannel_AIN1()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS0)
#define ADC_SetChannel_AIN2()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS1)
#define ADC_SetChannel_AIN3()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS1|CHS0)
#define ADC_SetChannel_AIN4()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2)
#define ADC_SetChannel_AIN5()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2|CHS0)
#define ADC_SetChannel_AIN6()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2|CHS1)
#define ADC_SetChannel_AIN7()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS2|CHS1|CHS0)
#define ADC_SetChannel_AIN8()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3)                  
#define ADC_SetChannel_AIN9()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS0)          
#define ADC_SetChannel_AIN10()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS1)          
#define ADC_SetChannel_AIN11()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS1|CHS0)     
#define ADC_SetChannel_AIN12()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS2)          
#define ADC_SetChannel_AIN13()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS2|CHS0)     
#define ADC_SetChannel_AIN14()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS2|CHS1)     
#define ADC_SetChannel_AIN15()				ADCON0=(ADCON0&(~(CHS3|CHS2|CHS1|CHS0)))|(CHS3|CHS2|CHS1|CHS0)

// ADCתģʽ
#define ADC_SetMode_SetADCS()				ADCFG0=ADCFG0&(~(ADTM0|ADTM1))
#define ADC_SetMode_T0Overflow()			ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM0)
#define ADC_SetMode_FreeRunning()			ADCFG0=(ADCFG0&(~(ADTM0|ADTM1)))|(ADTM1)
#define ADC_SetMode_S3BRGOverflow()			ADCFG0=ADCFG0|(ADTM0|ADTM1)


// ADCֵ(ADCDH[7:0]ADCDL[7:4])/Ҷ(ADCDH[3:0]ADCDL[7:0])
#define ADC_SetLeftJustified()				ADCFG0=ADCFG0&(~ADRJ)					
#define ADC_SetRightJustified()				ADCFG0=ADCFG0|(ADRJ)					


// ADCתƫֵ
#define ADC_SetOffsetAdd(x)				SFRPI=1;ADCFG1=(ADCFG1&(~(0x1F)))|(x);SFRPI=0	// ADCֵ+x (x=0~15)
#define ADC_SetOffsetSub(x)				SFRPI=1;ADCFG1=(ADCFG1&(~(0x1F)))|((~x));SFRPI=0	// ADCֵ-x (x=1~16)


/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  SPI 
*
*************************************************************************************
*/
// رSPI
#define SPI_Disable()						SPCON=SPCON&(~SPEN)					
#define SPI_Enable()						SPCON=SPCON|(SPEN)

// ѡMASTER/SLAVE
#define SPI_SelectMASTERByMSTRbit()			SPCON=SPCON|(SSIG|MSTR)					
#define SPI_SelectSLAVEByMSTRbit()			SPCON=(SPCON|(SSIG))&(~MSTR)						
#define SPI_SelectMASTERSLAVEBynSSpin()		SPCON=SPCON&(~SSIG)

// ѡSPICLK ʼƽ 0:SPICLK  ʼΪ͵ƽ 1: SPICLK  ʼΪ͵ƽ
#define SPI_SetCPOL_0()						SPCON=SPCON&(~CPOL)
#define SPI_SetCPOL_1()						SPCON=SPCON|(CPOL)

// ѡݴ˳	0:λ 1: λ
#define SPI_SetDataMSB()					SPCON=SPCON&(~DORD)
#define SPI_SetDataLSB()					SPCON=SPCON|(DORD)

// ѡSPI Ĵٶ
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_8	1	// SYSCLK/8
#define SPI_CLK_SYSCLK_16	2	// SYSCLK/16
#define SPI_CLK_SYSCLK_32	3	// SYSCLK/32
#define SPI_CLK_SYSCLK_64	4	// SYSCLK/64
#define SPI_CLK_SYSCLK_128	5	// SYSCLK/128
#define SPI_CLK_S1TOF_6		6	// S1TOF/6	
#define SPI_CLK_T0OF_6		7	// T0OF/6	

#define SPI_SetClock(x)						SPCON=(SPCON&B11111100)|(x&0x03);SPSTAT=(x>>2)

// ѡݲģʽ	0:ǰز,ظı 1: ǰظı,ز
#define SPI_SetCPHA_0()						SPCON=SPCON&(~CPHA)
#define SPI_SetCPHA_1()						SPCON=SPCON|(CPHA)

// ѡSPI õIO
#define SPI_SetUseP14P15P16P17()			AUXR1=AUXR1&(~SPIPS0)
#define SPI_SetUseP43P42P41P40()			AUXR1=AUXR1|(SPIPS0)

// SPI /SPIɱ־
#define SPI_ClearCompleteFlag()		SPSTAT=SPSTAT|SPIF
#define SPI_ChkCompleteFlag()		(SPSTAT&SPIF)

// SPI /
#define SPI_SendData(x)		SPDAT=x
#define SPI_GetData()		SPDAT

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  PCA0
*
*************************************************************************************
*/
// PCA /رռ
#define	PCA_EnPCACounter()					CR=1
#define	PCA_DisPCACounter()					CR=0

// PCA ʱԴ, ѡCKMIX16MCKDOʱ,>=SYSCLKx2 & >=CPUCLKx3
#define PCA_SetCLOCK_SYSCLKdiv12()			CMOD=CMOD&(~(CPS2|CPS1|CPS0))
#define PCA_SetCLOCK_SYSCLKdiv2()			CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS0)
#define PCA_SetCLOCK_TO()					CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS1)
#define PCA_SetCLOCK_ECI()					CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS1|CPS0)
#define PCA_SetCLOCK_CKMIX16()				CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS2)
#define PCA_SetCLOCK_SYSCLK()				CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS0)
#define PCA_SetCLOCK_S0BRT()				CMOD=(CMOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS1)
#define PCA_SetCLOCK_MCKDO()				CMOD=CMOD|(CPS2|CPS1|CPS0)

// PCA üֵֵ
#define PCA_SetCounter(x)					CH=HIBYTE(x);CL=LOBYTE(x)
#define PCA_SetCounterReload(x)				CHRL=HIBYTE(x);CLRL=LOBYTE(x)


// PCA ģʽ
#define PCA_CH0_SetMode_16BitCaptureRising()	CCAPM0=CAPP0		
#define PCA_CH0_SetMode_16BitCaptureFalling()	CCAPM0=CAPN0		
#define PCA_CH0_SetMode_16BitCaptureDaul()		CCAPM0=CAPP0|CAPN0		
#define PCA_CH0_SetMode_16BitSoftwareTimer()	CCAPM0=ECOM0|MAT0		
#define PCA_CH0_SetMode_16BitHighSpeedOutput()	CCAPM0=ECOM0|MAT0|TOG0		
#define PCA_CH0_SetMode_PWM()					CCAPM0=ECOM0|PWM0	

#define PCA_CH1_SetMode_16BitCaptureRising()	CCAPM1=CAPP1		
#define PCA_CH1_SetMode_16BitCaptureFalling()	CCAPM1=CAPN1		
#define PCA_CH1_SetMode_16BitCaptureDaul()		CCAPM1=CAPP1|CAPN1		
#define PCA_CH1_SetMode_16BitSoftwareTimer()	CCAPM1=ECOM1|MAT1		
#define PCA_CH1_SetMode_16BitHighSpeedOutput()	CCAPM1=ECOM1|MAT1|TOG1		
#define PCA_CH1_SetMode_PWM()					CCAPM1=ECOM1|PWM1	

#define PCA_CH2_SetMode_16BitCaptureRising()	CCAPM2=CAPP2		
#define PCA_CH2_SetMode_16BitCaptureFalling()	CCAPM2=CAPN2		
#define PCA_CH2_SetMode_16BitCaptureDaul()		CCAPM2=CAPP2|CAPN2		
#define PCA_CH2_SetMode_16BitSoftwareTimer()	CCAPM2=ECOM2|MAT2		
#define PCA_CH2_SetMode_16BitHighSpeedOutput()	CCAPM2=ECOM2|MAT2|TOG2		
#define PCA_CH2_SetMode_PWM()					CCAPM2=ECOM2|PWM2	

#define PCA_CH3_SetMode_16BitCaptureRising()	CCAPM3=CAPP3		
#define PCA_CH3_SetMode_16BitCaptureFalling()	CCAPM3=CAPN3		
#define PCA_CH3_SetMode_16BitCaptureDaul()		CCAPM3=CAPP3|CAPN3		
#define PCA_CH3_SetMode_16BitSoftwareTimer()	CCAPM3=ECOM3|MAT3		
#define PCA_CH3_SetMode_16BitHighSpeedOutput()	CCAPM3=ECOM3|MAT3|TOG3		
#define PCA_CH3_SetMode_PWM()					CCAPM3=ECOM3|PWM3	

#define PCA_CH4_SetMode_16BitCaptureRising()	CCAPM4=CAPP4		
#define PCA_CH4_SetMode_16BitCaptureFalling()	CCAPM4=CAPN4		
#define PCA_CH4_SetMode_16BitCaptureDaul()		CCAPM4=CAPP4|CAPN4		
#define PCA_CH4_SetMode_16BitSoftwareTimer()	CCAPM4=ECOM4|MAT4		
#define PCA_CH4_SetMode_16BitHighSpeedOutput()	CCAPM4=ECOM4|MAT4|TOG4		
#define PCA_CH4_SetMode_PWM()					CCAPM4=ECOM4|PWM4	

#define PCA_CH5_SetMode_16BitCaptureRising()	CCAPM5=CAPP5		
#define PCA_CH5_SetMode_16BitCaptureFalling()	CCAPM5=CAPN5		
#define PCA_CH5_SetMode_16BitCaptureDaul()		CCAPM5=CAPP5|CAPN5		
#define PCA_CH5_SetMode_16BitSoftwareTimer()	CCAPM5=ECOM5|MAT5		
#define PCA_CH5_SetMode_16BitHighSpeedOutput()	CCAPM5=ECOM5|MAT5|TOG5		
#define PCA_CH5_SetMode_PWM()					CCAPM5=ECOM5|PWM5	

#define PCA_CH0_SetPWM_8Bit()					PCAPWM0=PCAPWM0&(~(P0RS0|P0RS1))
#define PCA_CH0_SetPWM_10Bit()					PCAPWM0=(PCAPWM0&(~(P0RS0|P0RS1)))|(P0RS0)
#define PCA_CH0_SetPWM_12Bit()					PCAPWM0=(PCAPWM0&(~(P0RS0|P0RS1)))|(P0RS1)
#define PCA_CH0_SetPWM_16Bit()					PCAPWM0=PCAPWM0|((P0RS0|P0RS1))

#define PCA_CH1_SetPWM_8Bit()					PCAPWM1=PCAPWM1&(~(P1RS0|P1RS1))
#define PCA_CH1_SetPWM_10Bit()					PCAPWM1=(PCAPWM1&(~(P1RS0|P1RS1)))|(P1RS0)
#define PCA_CH1_SetPWM_12Bit()					PCAPWM1=(PCAPWM1&(~(P1RS0|P1RS1)))|(P1RS1)
#define PCA_CH1_SetPWM_16Bit()					PCAPWM1=PCAPWM1|((P1RS0|P1RS1))

#define PCA_CH2_SetPWM_8Bit()					PCAPWM2=PCAPWM0&(~(P2RS0|P2RS1))
#define PCA_CH2_SetPWM_10Bit()					PCAPWM2=(PCAPWM0&(~(P2RS0|P2RS1)))|(P2RS0)
#define PCA_CH2_SetPWM_12Bit()					PCAPWM2=(PCAPWM0&(~(P2RS0|P2RS1)))|(P2RS1)
#define PCA_CH2_SetPWM_16Bit()					PCAPWM2=PCAPWM0|((P2RS0|P2RS1))

#define PCA_CH3_SetPWM_8Bit()					PCAPWM3=PCAPWM0&(~(P3RS0|P3RS1))
#define PCA_CH3_SetPWM_10Bit()					PCAPWM3=(PCAPWM0&(~(P3RS0|P3RS1)))|(P3RS0)
#define PCA_CH3_SetPWM_12Bit()					PCAPWM3=(PCAPWM0&(~(P3RS0|P3RS1)))|(P3RS1)
#define PCA_CH3_SetPWM_16Bit()					PCAPWM3=PCAPWM0|((P3RS0|P3RS1))

#define PCA_CH4_SetPWM_8Bit()					PCAPWM4=PCAPWM0&(~(P4RS0|P4RS1))
#define PCA_CH4_SetPWM_10Bit()					PCAPWM4=(PCAPWM0&(~(P4RS0|P4RS1)))|(P4RS0)
#define PCA_CH4_SetPWM_12Bit()					PCAPWM4=(PCAPWM0&(~(P4RS0|P4RS1)))|(P4RS1)
#define PCA_CH4_SetPWM_16Bit()					PCAPWM4=PCAPWM0|((P4RS0|P4RS1))

#define PCA_CH5_SetPWM_8Bit()					PCAPWM5=PCAPWM0&(~(P5RS0|P5RS1))
#define PCA_CH5_SetPWM_10Bit()					PCAPWM5=(PCAPWM0&(~(P5RS0|P5RS1)))|(P5RS0)
#define PCA_CH5_SetPWM_12Bit()					PCAPWM5=(PCAPWM0&(~(P5RS0|P5RS1)))|(P5RS1)
#define PCA_CH5_SetPWM_16Bit()					PCAPWM5=PCAPWM0|((P5RS0|P5RS1))


// PCA øֵͨ
#define PCA_CH0_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM0=PCAPWM0|0x03;}else{CCAP0L=y;CCAP0H=x;PCAPWM0=PCAPWM0&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 0 0,1
#define PCA_CH1_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM1=PCAPWM1|0x03;}else{CCAP1L=y;CCAP1H=x;PCAPWM1=PCAPWM1&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 1 0,1
#define PCA_CH2_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM2=PCAPWM2|0x03;}else{CCAP2L=y;CCAP2H=x;PCAPWM2=PCAPWM2&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 2 2,3
#define PCA_CH3_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM3=PCAPWM3|0x03;}else{CCAP3L=y;CCAP3H=x;PCAPWM3=PCAPWM3&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 3 2,3
#define PCA_CH4_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM4=PCAPWM4|0x03;}else{CCAP4L=y;CCAP4H=x;PCAPWM4=PCAPWM4&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 4 4,5
#define PCA_CH5_SetValue(x,y)					AUXR2=AUXR2|(C0PLK);if((x==0)&&(y==0)){PCAPWM5=PCAPWM5|0x03;}else{CCAP5L=y;CCAP5H=x;PCAPWM5=PCAPWM5&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 5 4,5

#define PCA_CH0_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM0=PCAPWM0|0x03;}else{CCAP0L=y;CCAP0H=x;PCAPWM0=PCAPWM0&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 0 0,1
#define PCA_CH1_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM1=PCAPWM1|0x03;}else{CCAP1L=y;CCAP1H=x;PCAPWM1=PCAPWM1&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 1 0,1
#define PCA_CH2_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM2=PCAPWM2|0x03;}else{CCAP2L=y;CCAP2H=x;PCAPWM2=PCAPWM2&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 2 2,3
#define PCA_CH3_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM3=PCAPWM3|0x03;}else{CCAP3L=y;CCAP3H=x;PCAPWM3=PCAPWM3&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 3 2,3
#define PCA_CH4_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM4=PCAPWM4|0x03;}else{CCAP4L=y;CCAP4H=x;PCAPWM4=PCAPWM4&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 4 4,5
#define PCA_CH5_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x10)){PCAPWM5=PCAPWM5|0x03;}else{CCAP5L=y;CCAP5H=x;PCAPWM5=PCAPWM5&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 5 4,5

#define PCA_CH0_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM0=PCAPWM0|0x03;}else{CCAP0L=y;CCAP0H=x;PCAPWM0=PCAPWM0&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 0 0,1
#define PCA_CH1_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM1=PCAPWM1|0x03;}else{CCAP1L=y;CCAP1H=x;PCAPWM1=PCAPWM1&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 1 0,1
#define PCA_CH2_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM2=PCAPWM2|0x03;}else{CCAP2L=y;CCAP2H=x;PCAPWM2=PCAPWM2&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 2 2,3
#define PCA_CH3_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM3=PCAPWM3|0x03;}else{CCAP3L=y;CCAP3H=x;PCAPWM3=PCAPWM3&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 3 2,3
#define PCA_CH4_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM4=PCAPWM4|0x03;}else{CCAP4L=y;CCAP4H=x;PCAPWM4=PCAPWM4&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 4 4,5
#define PCA_CH5_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x>=0x04)){PCAPWM5=PCAPWM5|0x03;}else{CCAP5L=y;CCAP5H=x;PCAPWM5=PCAPWM5&(~0x03);};AUXR2=AUXR2&(~C0PLK)		// 5 4,5

#define PCA_CH0_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM0=PCAPWM0|0x02;}else{CCAP0H=y;PCAPWM0=PCAPWM0&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 0 
#define PCA_CH1_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM1=PCAPWM1|0x02;}else{CCAP1H=y;PCAPWM1=PCAPWM1&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 1 
#define PCA_CH2_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM2=PCAPWM2|0x02;}else{CCAP2H=y;PCAPWM2=PCAPWM2&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 2 
#define PCA_CH3_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM3=PCAPWM3|0x02;}else{CCAP3H=y;PCAPWM3=PCAPWM3&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 3 
#define PCA_CH4_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM4=PCAPWM4|0x02;}else{CCAP4H=y;PCAPWM4=PCAPWM4&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 4 
#define PCA_CH5_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C0PLK);if((x!=0)){PCAPWM5=PCAPWM5|0x02;}else{CCAP5H=y;PCAPWM5=PCAPWM5&(~0x02);};AUXR2=AUXR2&(~C0PLK)		// 5 

#define PCA_CH0_SetValue_L(x)					CCAP0L=x                        // 0
#define PCA_CH1_SetValue_L(x)					CCAP1L=x                        // 1
#define PCA_CH2_SetValue_L(x)					CCAP2L=x                        // 2
#define PCA_CH3_SetValue_L(x)					CCAP3L=x                        // 3
#define PCA_CH4_SetValue_L(x)					CCAP4L=x                        // 4
#define PCA_CH5_SetValue_L(x)					CCAP5L=x                        // 5

#define PCA_CH0_SetValue_H(x)					CCAP0H=x						// 0
#define PCA_CH1_SetValue_H(x)					CCAP1H=x                        // 1
#define PCA_CH2_SetValue_H(x)					CCAP2H=x                        // 2
#define PCA_CH3_SetValue_H(x)					CCAP3H=x                        // 3
#define PCA_CH4_SetValue_H(x)					CCAP4H=x                        // 4
#define PCA_CH5_SetValue_H(x)					CCAP5H=x                        // 5

#define PCA_CH0_SetValue_9thBit_L_0()			PCAPWM0=PCAPWM0&(~0x01)        	// 0
#define PCA_CH1_SetValue_9thBit_L_0()			PCAPWM1=PCAPWM1&(~0x01)         // 1
#define PCA_CH2_SetValue_9thBit_L_0()			PCAPWM2=PCAPWM2&(~0x01)         // 2
#define PCA_CH3_SetValue_9thBit_L_0()			PCAPWM3=PCAPWM3&(~0x01)         // 3
#define PCA_CH4_SetValue_9thBit_L_0()			PCAPWM4=PCAPWM4&(~0x01)         // 4
#define PCA_CH5_SetValue_9thBit_L_0()			PCAPWM5=PCAPWM5&(~0x01)         // 5

#define PCA_CH0_SetValue_9thBit_L_1()			PCAPWM0=PCAPWM0|(0x01)        	// 0             
#define PCA_CH1_SetValue_9thBit_L_1()			PCAPWM1=PCAPWM1|(0x01)         // 1             
#define PCA_CH2_SetValue_9thBit_L_1()			PCAPWM2=PCAPWM2|(0x01)         // 2             
#define PCA_CH3_SetValue_9thBit_L_1()			PCAPWM3=PCAPWM3|(0x01)         // 3             
#define PCA_CH4_SetValue_9thBit_L_1()			PCAPWM4=PCAPWM4|(0x01)         // 4             
#define PCA_CH5_SetValue_9thBit_L_1()			PCAPWM5=PCAPWM5|(0x01)         // 5             

#define PCA_CH0_SetValue_9thBit_H_0()			PCAPWM0=PCAPWM0&(~0x02)        	// 0             
#define PCA_CH1_SetValue_9thBit_H_0()			PCAPWM1=PCAPWM1&(~0x02)         // 1             
#define PCA_CH2_SetValue_9thBit_H_0()			PCAPWM2=PCAPWM2&(~0x02)         // 2             
#define PCA_CH3_SetValue_9thBit_H_0()			PCAPWM3=PCAPWM3&(~0x02)         // 3             
#define PCA_CH4_SetValue_9thBit_H_0()			PCAPWM4=PCAPWM4&(~0x02)         // 4             
#define PCA_CH5_SetValue_9thBit_H_0()			PCAPWM5=PCAPWM5&(~0x02)         // 5             

#define PCA_CH0_SetValue_9thBit_H_1()			PCAPWM0=PCAPWM0|(0x02)        	// 0             
#define PCA_CH1_SetValue_9thBit_H_1()			PCAPWM1=PCAPWM1|(0x02)         // 1              
#define PCA_CH2_SetValue_9thBit_H_1()			PCAPWM2=PCAPWM2|(0x02)         // 2              
#define PCA_CH3_SetValue_9thBit_H_1()			PCAPWM3=PCAPWM3|(0x02)         // 3              
#define PCA_CH4_SetValue_9thBit_H_1()			PCAPWM4=PCAPWM4|(0x02)         // 4              
#define PCA_CH5_SetValue_9thBit_H_1()			PCAPWM5=PCAPWM5|(0x02)         // 5              

// PCA PWM
#define PCA_CH0_SetPWM_EnInvert()				PCAPWM0=PCAPWM0|P0INV
#define PCA_CH1_SetPWM_EnInvert()				PCAPWM1=PCAPWM1|P1INV
#define PCA_CH2_SetPWM_EnInvert()				PCAPWM2=PCAPWM2|P2INV
#define PCA_CH3_SetPWM_EnInvert()				PCAPWM3=PCAPWM3|P3INV
#define PCA_CH4_SetPWM_EnInvert()				PCAPWM4=PCAPWM4|P4INV
#define PCA_CH5_SetPWM_EnInvert()				PCAPWM5=PCAPWM5|P5INV

#define PCA_CH0_SetPWM_DisInvert()				PCAPWM0=PCAPWM0&(~(P0INV))
#define PCA_CH1_SetPWM_DisInvert()				PCAPWM1=PCAPWM1&(~(P1INV))
#define PCA_CH2_SetPWM_DisInvert()				PCAPWM2=PCAPWM2&(~(P2INV))
#define PCA_CH3_SetPWM_DisInvert()				PCAPWM3=PCAPWM3&(~(P3INV))
#define PCA_CH4_SetPWM_DisInvert()				PCAPWM4=PCAPWM4&(~(P4INV))
#define PCA_CH5_SetPWM_DisInvert()				PCAPWM5=PCAPWM5&(~(P5INV))

// PCA ʹ/ֹPWM
#define PCA_CH0_EnPWM()			CCAPM0=CCAPM0|PWM0	
#define PCA_CH1_EnPWM()			CCAPM1=CCAPM1|PWM1
#define PCA_CH2_EnPWM()			CCAPM2=CCAPM2|PWM2
#define PCA_CH3_EnPWM()			CCAPM3=CCAPM3|PWM3
#define PCA_CH4_EnPWM()			CCAPM4=CCAPM4|PWM4
#define PCA_CH5_EnPWM()			CCAPM5=CCAPM5|PWM5

#define PCA_CH0_DisPWM()		CCAPM0=CCAPM0&(~PWM0)
#define PCA_CH1_DisPWM()        CCAPM1=CCAPM1&(~PWM1)
#define PCA_CH2_DisPWM()        CCAPM2=CCAPM2&(~PWM2)
#define PCA_CH3_DisPWM()        CCAPM3=CCAPM3&(~PWM3)
#define PCA_CH4_DisPWM()        CCAPM4=CCAPM4&(~PWM4)
#define PCA_CH5_DisPWM()        CCAPM5=CCAPM5&(~PWM5)

// PCA PWM ģʽ
#define PCA_CH01_SetPWM_EnBufferMode()				CMOD=CMOD|BME0
#define PCA_CH23_SetPWM_EnBufferMode()				CMOD=CMOD|BME2
#define PCA_CH45_SetPWM_EnBufferMode()				CMOD=CMOD|BME4
#define PCA_CH01_SetPWM_DisBufferMode()				CMOD=CMOD&(~(BME0))
#define PCA_CH23_SetPWM_DisBufferMode()				CMOD=CMOD&(~(BME2))
#define PCA_CH45_SetPWM_DisBufferMode()				CMOD=CMOD&(~(BME4))


// PCA ж

#define PCA_CF_EnInterrupt()				CMOD=CMOD|ECF
#define PCA_CF_DisInterrupt()				CMOD=CMOD&(~(ECF))

#define PCA_CH0_EnInterrupt()				CCAPM0=CCAPM0|ECCF0
#define PCA_CH1_EnInterrupt()				CCAPM1=CCAPM1|ECCF1
#define PCA_CH2_EnInterrupt()				CCAPM2=CCAPM2|ECCF2
#define PCA_CH3_EnInterrupt()				CCAPM3=CCAPM3|ECCF3
#define PCA_CH4_EnInterrupt()				CCAPM4=CCAPM4|ECCF4
#define PCA_CH5_EnInterrupt()				CCAPM5=CCAPM5|ECCF5

#define PCA_CH0_DisInterrupt()				CCAPM0=CCAPM0&(~(ECCF0))
#define PCA_CH1_DisInterrupt()				CCAPM1=CCAPM1&(~(ECCF1))
#define PCA_CH2_DisInterrupt()				CCAPM2=CCAPM2&(~(ECCF2))
#define PCA_CH3_DisInterrupt()				CCAPM3=CCAPM3&(~(ECCF3))
#define PCA_CH4_DisInterrupt()				CCAPM4=CCAPM4&(~(ECCF4))
#define PCA_CH5_DisInterrupt()				CCAPM5=CCAPM5&(~(ECCF5))

// PCA PWM뷽ʽ

// PCA 

#define PCA_SetECICEX0CEX1CEX2CEX3CEX4CEX5_P21P22P23P24P25P26P27()		SFRPI=3;AUXR6=AUXR6&(~PCAPS0);SFRPI=0
#define PCA_SetECICEX0CEX1CEX2CEX3CEX4CEX5_P00P34P35P40P41P42P43()		SFRPI=3;AUXR6=AUXR6|(PCAPS0);SFRPI=0

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  PCA1
*
*************************************************************************************
*/
// PCA1 /رռ
#define	PCA1_EnPCACounter()					SFRPI=1;C1R=1;SFRPI=0
#define	PCA1_DisPCACounter()				SFRPI=1;C1R=0;SFRPI=0

// PCA1 ʱԴ, ѡCKMIX16MCKDOʱ,>=SYSCLKx2 & >=CPUCLKx3
#define PCA1_SetCLOCK_SYSCLKdiv12()			SFRPI=1;C1MOD=C1MOD&(~(CPS2|CPS1|CPS0));SFRPI=0
#define PCA1_SetCLOCK_SYSCLKdiv2()			SFRPI=1;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS0);SFRPI=0
#define PCA1_SetCLOCK_TO()					SFRPI=1;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS1);SFRPI=0
#define PCA1_SetCLOCK_ECI()					SFRPI=1;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS1|CPS0);SFRPI=0
#define PCA1_SetCLOCK_CKMIX16()				SFRPI=1;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS2);SFRPI=0
#define PCA1_SetCLOCK_SYSCLK()				SFRPI=1;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS0);SFRPI=0
#define PCA1_SetCLOCK_S0BRT()				SFRPI=1;C1MOD=(C1MOD&(~(CPS2|CPS1|CPS0)))|(CPS2|CPS1);SFRPI=0
#define PCA1_SetCLOCK_MCKDO()				SFRPI=1;C1MOD=C1MOD|(CPS2|CPS1|CPS0);SFRPI=0

// PCA1 üֵֵ
#define PCA1_SetCounter(x)					SFRPI=1;CH=HIBYTE(x);CL=LOBYTE(x);SFRPI=0
#define PCA1_SetCounterReload(x)			SFRPI=1;CHRL=HIBYTE(x);CLRL=LOBYTE(x);SFRPI=0


// PCA1 ģʽ
#define PCA1_CH0_SetMode_16BitCaptureRising()	SFRPI=1;C1CAPM0=CAPP0;SFRPI=0		
#define PCA1_CH0_SetMode_16BitCaptureFalling()	SFRPI=1;C1CAPM0=CAPN0;SFRPI=0		
#define PCA1_CH0_SetMode_16BitCaptureDaul()		SFRPI=1;C1CAPM0=CAPP0|CAPN0;SFRPI=0		
#define PCA1_CH0_SetMode_16BitSoftwareTimer()	SFRPI=1;C1CAPM0=ECOM0|MAT0;SFRPI=0		
#define PCA1_CH0_SetMode_16BitHighSpeedOutput()	SFRPI=1;C1CAPM0=ECOM0|MAT0|TOG0;SFRPI=0		
#define PCA1_CH0_SetMode_PWM()					SFRPI=1;C1CAPM0=ECOM0|PWM0;SFRPI=0	

#define PCA1_CH1_SetMode_16BitCaptureRising()	SFRPI=1;C1CAPM1=CAPP1;SFRPI=0		
#define PCA1_CH1_SetMode_16BitCaptureFalling()	SFRPI=1;C1CAPM1=CAPN1;SFRPI=0		
#define PCA1_CH1_SetMode_16BitCaptureDaul()		SFRPI=1;C1CAPM1=CAPP1|CAPN1;SFRPI=0		
#define PCA1_CH1_SetMode_16BitSoftwareTimer()	SFRPI=1;C1CAPM1=ECOM1|MAT1;SFRPI=0		
#define PCA1_CH1_SetMode_16BitHighSpeedOutput()	SFRPI=1;C1CAPM1=ECOM1|MAT1|TOG1;SFRPI=0		
#define PCA1_CH1_SetMode_PWM()					SFRPI=1;C1CAPM1=ECOM1|PWM1;SFRPI=0	

#define PCA1_CH2_SetMode_16BitCaptureRising()	SFRPI=1;C1CAPM2=CAPP2;SFRPI=0		
#define PCA1_CH2_SetMode_16BitCaptureFalling()	SFRPI=1;C1CAPM2=CAPN2;SFRPI=0		
#define PCA1_CH2_SetMode_16BitCaptureDaul()		SFRPI=1;C1CAPM2=CAPP2|CAPN2;SFRPI=0		
#define PCA1_CH2_SetMode_16BitSoftwareTimer()	SFRPI=1;C1CAPM2=ECOM2|MAT2;SFRPI=0		
#define PCA1_CH2_SetMode_16BitHighSpeedOutput()	SFRPI=1;C1CAPM2=ECOM2|MAT2|TOG2;SFRPI=0		
#define PCA1_CH2_SetMode_PWM()					SFRPI=1;C1CAPM2=ECOM2|PWM2;SFRPI=0	

#define PCA1_CH3_SetMode_16BitCaptureRising()	SFRPI=1;C1CAPM3=CAPP3;SFRPI=0		
#define PCA1_CH3_SetMode_16BitCaptureFalling()	SFRPI=1;C1CAPM3=CAPN3;SFRPI=0		
#define PCA1_CH3_SetMode_16BitCaptureDaul()		SFRPI=1;C1CAPM3=CAPP3|CAPN3;SFRPI=0		
#define PCA1_CH3_SetMode_16BitSoftwareTimer()	SFRPI=1;C1CAPM3=ECOM3|MAT3;SFRPI=0		
#define PCA1_CH3_SetMode_16BitHighSpeedOutput()	SFRPI=1;C1CAPM3=ECOM3|MAT3|TOG3;SFRPI=0		
#define PCA1_CH3_SetMode_PWM()					SFRPI=1;C1CAPM3=ECOM3|PWM3;SFRPI=0	

#define PCA1_CH4_SetMode_16BitCaptureRising()	SFRPI=1;C1CAPM4=CAPP4;SFRPI=0		
#define PCA1_CH4_SetMode_16BitCaptureFalling()	SFRPI=1;C1CAPM4=CAPN4;SFRPI=0		
#define PCA1_CH4_SetMode_16BitCaptureDaul()		SFRPI=1;C1CAPM4=CAPP4|CAPN4;SFRPI=0		
#define PCA1_CH4_SetMode_16BitSoftwareTimer()	SFRPI=1;C1CAPM4=ECOM4|MAT4;SFRPI=0		
#define PCA1_CH4_SetMode_16BitHighSpeedOutput()	SFRPI=1;C1CAPM4=ECOM4|MAT4|TOG4;SFRPI=0		
#define PCA1_CH4_SetMode_PWM()					SFRPI=1;C1CAPM4=ECOM4|PWM4;SFRPI=0	

#define PCA1_CH5_SetMode_16BitCaptureRising()	SFRPI=1;C1CAPM5=CAPP5;SFRPI=0		
#define PCA1_CH5_SetMode_16BitCaptureFalling()	SFRPI=1;C1CAPM5=CAPN5;SFRPI=0		
#define PCA1_CH5_SetMode_16BitCaptureDaul()		SFRPI=1;C1CAPM5=CAPP5|CAPN5;SFRPI=0		
#define PCA1_CH5_SetMode_16BitSoftwareTimer()	SFRPI=1;C1CAPM5=ECOM5|MAT5;SFRPI=0		
#define PCA1_CH5_SetMode_16BitHighSpeedOutput()	SFRPI=1;C1CAPM5=ECOM5|MAT5|TOG5;SFRPI=0		
#define PCA1_CH5_SetMode_PWM()					SFRPI=1;C1CAPM5=ECOM5|PWM5;SFRPI=0	

#define PCA1_CH0_SetPWM_8Bit()					SFRPI=1;C1PWM0=C1PWM0&(~(P0RS0|P0RS1));SFRPI=0
#define PCA1_CH0_SetPWM_10Bit()					SFRPI=1;C1PWM0=(C1PWM0&(~(P0RS0|P0RS1)))|(P0RS0);SFRPI=0
#define PCA1_CH0_SetPWM_12Bit()					SFRPI=1;C1PWM0=(C1PWM0&(~(P0RS0|P0RS1)))|(P0RS1);SFRPI=0
#define PCA1_CH0_SetPWM_16Bit()					SFRPI=1;C1PWM0=C1PWM0|((P0RS0|P0RS1));SFRPI=0
                                   
#define PCA1_CH1_SetPWM_8Bit()					SFRPI=1;C1PWM1=C1PWM1&(~(P1RS0|P1RS1));SFRPI=0
#define PCA1_CH1_SetPWM_10Bit()					SFRPI=1;C1PWM1=(C1PWM1&(~(P1RS0|P1RS1)))|(P1RS0);SFRPI=0
#define PCA1_CH1_SetPWM_12Bit()					SFRPI=1;C1PWM1=(C1PWM1&(~(P1RS0|P1RS1)))|(P1RS1);SFRPI=0
#define PCA1_CH1_SetPWM_16Bit()					SFRPI=1;C1PWM1=C1PWM1|((P1RS0|P1RS1));SFRPI=0

#define PCA1_CH2_SetPWM_8Bit()					SFRPI=1;C1PWM2=C1PWM0&(~(P2RS0|P2RS1));SFRPI=0
#define PCA1_CH2_SetPWM_10Bit()					SFRPI=1;C1PWM2=(C1PWM0&(~(P2RS0|P2RS1)))|(P2RS0);SFRPI=0
#define PCA1_CH2_SetPWM_12Bit()					SFRPI=1;C1PWM2=(C1PWM0&(~(P2RS0|P2RS1)))|(P2RS1);SFRPI=0
#define PCA1_CH2_SetPWM_16Bit()					SFRPI=1;C1PWM2=C1PWM0|((P2RS0|P2RS1));SFRPI=0

#define PCA1_CH3_SetPWM_8Bit()					SFRPI=1;C1PWM3=C1PWM0&(~(P3RS0|P3RS1));SFRPI=0
#define PCA1_CH3_SetPWM_10Bit()					SFRPI=1;C1PWM3=(C1PWM0&(~(P3RS0|P3RS1)))|(P3RS0);SFRPI=0
#define PCA1_CH3_SetPWM_12Bit()					SFRPI=1;C1PWM3=(C1PWM0&(~(P3RS0|P3RS1)))|(P3RS1);SFRPI=0
#define PCA1_CH3_SetPWM_16Bit()					SFRPI=1;C1PWM3=C1PWM0|((P3RS0|P3RS1));SFRPI=0

#define PCA1_CH4_SetPWM_8Bit()					SFRPI=1;C1PWM4=C1PWM0&(~(P4RS0|P4RS1));SFRPI=0
#define PCA1_CH4_SetPWM_10Bit()					SFRPI=1;C1PWM4=(C1PWM0&(~(P4RS0|P4RS1)))|(P4RS0);SFRPI=0
#define PCA1_CH4_SetPWM_12Bit()					SFRPI=1;C1PWM4=(C1PWM0&(~(P4RS0|P4RS1)))|(P4RS1);SFRPI=0
#define PCA1_CH4_SetPWM_16Bit()					SFRPI=1;C1PWM4=C1PWM0|((P4RS0|P4RS1));SFRPI=0

#define PCA1_CH5_SetPWM_8Bit()					SFRPI=1;C1PWM5=C1PWM0&(~(P5RS0|P5RS1));SFRPI=0
#define PCA1_CH5_SetPWM_10Bit()					SFRPI=1;C1PWM5=(C1PWM0&(~(P5RS0|P5RS1)))|(P5RS0);SFRPI=0
#define PCA1_CH5_SetPWM_12Bit()					SFRPI=1;C1PWM5=(C1PWM0&(~(P5RS0|P5RS1)))|(P5RS1);SFRPI=0
#define PCA1_CH5_SetPWM_16Bit()					SFRPI=1;C1PWM5=C1PWM0|((P5RS0|P5RS1));SFRPI=0


// PCA1 øֵͨ
#define PCA1_CH0_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM0=C1PWM0|0x03;}else{C1CAP0L=y;C1CAP0H=x;C1PWM0=C1PWM0&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 0 0,1
#define PCA1_CH1_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM1=C1PWM1|0x03;}else{C1CAP1L=y;C1CAP1H=x;C1PWM1=C1PWM1&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 1 0,1
#define PCA1_CH2_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM2=C1PWM2|0x03;}else{C1CAP2L=y;C1CAP2H=x;C1PWM2=C1PWM2&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 2 2,3
#define PCA1_CH3_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM3=C1PWM3|0x03;}else{C1CAP3L=y;C1CAP3H=x;C1PWM3=C1PWM3&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 3 2,3
#define PCA1_CH4_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM4=C1PWM4|0x03;}else{C1CAP4L=y;C1CAP4H=x;C1PWM4=C1PWM4&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 4 4,5
#define PCA1_CH5_SetValue(x,y)					AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x==0)&&(y==0)){C1PWM5=C1PWM5|0x03;}else{C1CAP5L=y;C1CAP5H=x;C1PWM5=C1PWM5&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)	// 5 4,5


#define PCA1_CH0_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM0=C1PWM0|0x03;}else{C1CAP0L=y;C1CAP0H=x;C1PWM0=C1PWM0&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 0 0,1
#define PCA1_CH1_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM1=C1PWM1|0x03;}else{C1CAP1L=y;C1CAP1H=x;C1PWM1=C1PWM1&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 1 0,1
#define PCA1_CH2_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM2=C1PWM2|0x03;}else{C1CAP2L=y;C1CAP2H=x;C1PWM2=C1PWM2&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 2 2,3
#define PCA1_CH3_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM3=C1PWM3|0x03;}else{C1CAP3L=y;C1CAP3H=x;C1PWM3=C1PWM3&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 3 2,3
#define PCA1_CH4_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM4=C1PWM4|0x03;}else{C1CAP4L=y;C1CAP4H=x;C1PWM4=C1PWM4&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 4 4,5
#define PCA1_CH5_SetValue_12Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x10)){C1PWM5=C1PWM5|0x03;}else{C1CAP5L=y;C1CAP5H=x;C1PWM5=C1PWM5&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 5 4,5

#define PCA1_CH0_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM0=C1PWM0|0x03;}else{C1CAP0L=y;C1CAP0H=x;C1PWM0=C1PWM0&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 0 0,1
#define PCA1_CH1_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM1=C1PWM1|0x03;}else{C1CAP1L=y;C1CAP1H=x;C1PWM1=C1PWM1&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 1 0,1
#define PCA1_CH2_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM2=C1PWM2|0x03;}else{C1CAP2L=y;C1CAP2H=x;C1PWM2=C1PWM2&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 2 2,3
#define PCA1_CH3_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM3=C1PWM3|0x03;}else{C1CAP3L=y;C1CAP3H=x;C1PWM3=C1PWM3&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 3 2,3
#define PCA1_CH4_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM4=C1PWM4|0x03;}else{C1CAP4L=y;C1CAP4H=x;C1PWM4=C1PWM4&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 4 4,5
#define PCA1_CH5_SetValue_10Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x>=0x04)){C1PWM5=C1PWM5|0x03;}else{C1CAP5L=y;C1CAP5H=x;C1PWM5=C1PWM5&(~0x03);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 5 4,5

#define PCA1_CH0_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM0=C1PWM0|0x02;}else{C1CAP0H=y;C1PWM0=C1PWM0&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 0 
#define PCA1_CH1_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM1=C1PWM1|0x02;}else{C1CAP1H=y;C1PWM1=C1PWM1&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 1 
#define PCA1_CH2_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM2=C1PWM2|0x02;}else{C1CAP2H=y;C1PWM2=C1PWM2&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 2 
#define PCA1_CH3_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM3=C1PWM3|0x02;}else{C1CAP3H=y;C1PWM3=C1PWM3&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 3 
#define PCA1_CH4_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM4=C1PWM4|0x02;}else{C1CAP4H=y;C1PWM4=C1PWM4&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 4 
#define PCA1_CH5_SetValue_8Bit(x,y)				AUXR2=AUXR2|(C1PLK);SFRPI=1;if((x!=0)){C1PWM5=C1PWM5|0x02;}else{C1CAP5H=y;C1PWM5=C1PWM5&(~0x02);};SFRPI=0;AUXR2=AUXR2&(~C1PLK)		// 5 

#define PCA1_CH0_SetValue_L(x)					SFRPI=1;CCAP0L=x;SFRPI=0                        // 0
#define PCA1_CH1_SetValue_L(x)					SFRPI=1;CCAP1L=x;SFRPI=0                        // 1
#define PCA1_CH2_SetValue_L(x)					SFRPI=1;CCAP2L=x;SFRPI=0                        // 2
#define PCA1_CH3_SetValue_L(x)					SFRPI=1;CCAP3L=x;SFRPI=0                        // 3
#define PCA1_CH4_SetValue_L(x)					SFRPI=1;CCAP4L=x;SFRPI=0                        // 4
#define PCA1_CH5_SetValue_L(x)					SFRPI=1;CCAP5L=x;SFRPI=0                        // 5

#define PCA1_CH0_SetValue_H(x)					SFRPI=1;CCAP0H=x;SFRPI=0						// 0
#define PCA1_CH1_SetValue_H(x)					SFRPI=1;CCAP1H=x;SFRPI=0                        // 1
#define PCA1_CH2_SetValue_H(x)					SFRPI=1;CCAP2H=x;SFRPI=0                        // 2
#define PCA1_CH3_SetValue_H(x)					SFRPI=1;CCAP3H=x;SFRPI=0                        // 3
#define PCA1_CH4_SetValue_H(x)					SFRPI=1;CCAP4H=x;SFRPI=0                        // 4
#define PCA1_CH5_SetValue_H(x)					SFRPI=1;CCAP5H=x;SFRPI=0                        // 5

#define PCA1_CH0_SetValue_9thBit_L_0()			SFRPI=1;PCAPWM0=PCAPWM0&(~0x01);SFRPI=0        	// 0
#define PCA1_CH1_SetValue_9thBit_L_0()			SFRPI=1;PCAPWM1=PCAPWM1&(~0x01);SFRPI=0         // 1
#define PCA1_CH2_SetValue_9thBit_L_0()			SFRPI=1;PCAPWM2=PCAPWM2&(~0x01);SFRPI=0         // 2
#define PCA1_CH3_SetValue_9thBit_L_0()			SFRPI=1;PCAPWM3=PCAPWM3&(~0x01);SFRPI=0         // 3
#define PCA1_CH4_SetValue_9thBit_L_0()			SFRPI=1;PCAPWM4=PCAPWM4&(~0x01);SFRPI=0         // 4
#define PCA1_CH5_SetValue_9thBit_L_0()			SFRPI=1;PCAPWM5=PCAPWM5&(~0x01);SFRPI=0         // 5

#define PCA1_CH0_SetValue_9thBit_L_1()			SFRPI=1;PCAPWM0=PCAPWM0|(0x01);SFRPI=0        	// 0             
#define PCA1_CH1_SetValue_9thBit_L_1()			SFRPI=1;PCAPWM1=PCAPWM1|(0x01);SFRPI=0         // 1             
#define PCA1_CH2_SetValue_9thBit_L_1()			SFRPI=1;PCAPWM2=PCAPWM2|(0x01);SFRPI=0         // 2             
#define PCA1_CH3_SetValue_9thBit_L_1()			SFRPI=1;PCAPWM3=PCAPWM3|(0x01);SFRPI=0         // 3             
#define PCA1_CH4_SetValue_9thBit_L_1()			SFRPI=1;PCAPWM4=PCAPWM4|(0x01);SFRPI=0         // 4             
#define PCA1_CH5_SetValue_9thBit_L_1()			SFRPI=1;PCAPWM5=PCAPWM5|(0x01);SFRPI=0         // 5             

#define PCA1_CH0_SetValue_9thBit_H_0()			SFRPI=1;PCAPWM0=PCAPWM0&(~0x02);SFRPI=0        	// 0             
#define PCA1_CH1_SetValue_9thBit_H_0()			SFRPI=1;PCAPWM1=PCAPWM1&(~0x02);SFRPI=0         // 1             
#define PCA1_CH2_SetValue_9thBit_H_0()			SFRPI=1;PCAPWM2=PCAPWM2&(~0x02);SFRPI=0         // 2             
#define PCA1_CH3_SetValue_9thBit_H_0()			SFRPI=1;PCAPWM3=PCAPWM3&(~0x02);SFRPI=0         // 3             
#define PCA1_CH4_SetValue_9thBit_H_0()			SFRPI=1;PCAPWM4=PCAPWM4&(~0x02);SFRPI=0         // 4             
#define PCA1_CH5_SetValue_9thBit_H_0()			SFRPI=1;PCAPWM5=PCAPWM5&(~0x02);SFRPI=0         // 5             

#define PCA1_CH0_SetValue_9thBit_H_1()			SFRPI=1;PCAPWM0=PCAPWM0|(0x02);SFRPI=0        	// 0             
#define PCA1_CH1_SetValue_9thBit_H_1()			SFRPI=1;PCAPWM1=PCAPWM1|(0x02);SFRPI=0         // 1              
#define PCA1_CH2_SetValue_9thBit_H_1()			SFRPI=1;PCAPWM2=PCAPWM2|(0x02);SFRPI=0         // 2              
#define PCA1_CH3_SetValue_9thBit_H_1()			SFRPI=1;PCAPWM3=PCAPWM3|(0x02);SFRPI=0         // 3              
#define PCA1_CH4_SetValue_9thBit_H_1()			SFRPI=1;PCAPWM4=PCAPWM4|(0x02);SFRPI=0         // 4              
#define PCA1_CH5_SetValue_9thBit_H_1()			SFRPI=1;PCAPWM5=PCAPWM5|(0x02);SFRPI=0         // 5              


// PCA1 PWM
#define PCA1_CH0_SetPWM_EnInvert()				SFRPI=1;C1PWM0=C1PWM0|P0INV;SFRPI=0
#define PCA1_CH1_SetPWM_EnInvert()				SFRPI=1;C1PWM1=C1PWM1|P1INV;SFRPI=0
#define PCA1_CH2_SetPWM_EnInvert()				SFRPI=1;C1PWM2=C1PWM2|P2INV;SFRPI=0
#define PCA1_CH3_SetPWM_EnInvert()				SFRPI=1;C1PWM3=C1PWM3|P3INV;SFRPI=0
#define PCA1_CH4_SetPWM_EnInvert()				SFRPI=1;C1PWM4=C1PWM4|P4INV;SFRPI=0
#define PCA1_CH5_SetPWM_EnInvert()				SFRPI=1;C1PWM5=C1PWM5|P5INV;SFRPI=0

#define PCA1_CH0_SetPWM_DisInvert()				SFRPI=1;C1PWM0=C1PWM0&(~(P0INV));SFRPI=0
#define PCA1_CH1_SetPWM_DisInvert()				SFRPI=1;C1PWM1=C1PWM1&(~(P1INV));SFRPI=0
#define PCA1_CH2_SetPWM_DisInvert()				SFRPI=1;C1PWM2=C1PWM2&(~(P2INV));SFRPI=0
#define PCA1_CH3_SetPWM_DisInvert()				SFRPI=1;C1PWM3=C1PWM3&(~(P3INV));SFRPI=0
#define PCA1_CH4_SetPWM_DisInvert()				SFRPI=1;C1PWM4=C1PWM4&(~(P4INV));SFRPI=0
#define PCA1_CH5_SetPWM_DisInvert()				SFRPI=1;C1PWM5=C1PWM5&(~(P5INV));SFRPI=0

// PCA ʹ/ֹPWM
#define PCA1_CH0_EnPWM()			SFRPI=1;C1CAPM0=C1CAPM0|PWM0;SFRPI=0
#define PCA1_CH1_EnPWM()			SFRPI=1;C1CAPM1=C1CAPM1|PWM1;SFRPI=0
#define PCA1_CH2_EnPWM()			SFRPI=1;C1CAPM2=C1CAPM2|PWM2;SFRPI=0
#define PCA1_CH3_EnPWM()			SFRPI=1;C1CAPM3=C1CAPM3|PWM3;SFRPI=0
#define PCA1_CH4_EnPWM()			SFRPI=1;C1CAPM4=C1CAPM4|PWM4;SFRPI=0
#define PCA1_CH5_EnPWM()			SFRPI=1;C1CAPM5=C1CAPM5|PWM5;SFRPI=0

#define PCA1_CH0_DisPWM()		SFRPI=1;C1CAPM0=C1CAPM0&(~PWM0);SFRPI=0
#define PCA1_CH1_DisPWM()       SFRPI=1;C1CAPM1=C1CAPM1&(~PWM1);SFRPI=0
#define PCA1_CH2_DisPWM()       SFRPI=1;C1CAPM2=C1CAPM2&(~PWM2);SFRPI=0
#define PCA1_CH3_DisPWM()       SFRPI=1;C1CAPM3=C1CAPM3&(~PWM3);SFRPI=0
#define PCA1_CH4_DisPWM()       SFRPI=1;C1CAPM4=C1CAPM4&(~PWM4);SFRPI=0
#define PCA1_CH5_DisPWM()       SFRPI=1;C1CAPM5=C1CAPM5&(~PWM5);SFRPI=0

// PCA1 ʹ/ֹPWM
#define PCA1_SetPWM0_1st_EnOutput()				PAOE=PAOE|(C1P0O)
#define PCA1_SetPWM0_2nd_EnOutput()				PAOE=PAOE|(C1P0AO)
#define PCA1_SetPWM0_3rd_EnOutput()				PAOE=PAOE|(C1P0BO)
#define PCA1_SetPWM2_1st_EnOutput()				PAOE=PAOE|(C1P2O)
#define PCA1_SetPWM2_2nd_EnOutput()				PAOE=PAOE|(C1P2AO)
#define PCA1_SetPWM2_3rd_EnOutput()				PAOE=PAOE|(C1P2BO)

#define PCA1_SetPWM0_1st_DisOutput()				PAOE=PAOE&(~C1P0O)
#define PCA1_SetPWM0_2nd_DisOutput()				PAOE=PAOE&(~C1P0AO)
#define PCA1_SetPWM0_3rd_DisOutput()				PAOE=PAOE&(~C1P0BO)
#define PCA1_SetPWM2_1st_DisOutput()				PAOE=PAOE&(~C1P2O)
#define PCA1_SetPWM2_2nd_DisOutput()				PAOE=PAOE&(~C1P2AO)
#define PCA1_SetPWM2_3rd_DisOutput()				PAOE=PAOE&(~C1P2BO)

// PCA1 PWM ģʽ
#define PCA1_CH01_SetPWM_EnBufferMode()				SFRPI=1;C1MOD=C1MOD|BME0;SFRPI=0
#define PCA1_CH23_SetPWM_EnBufferMode()				SFRPI=1;C1MOD=C1MOD|BME2;SFRPI=0
#define PCA1_CH45_SetPWM_EnBufferMode()				SFRPI=1;C1MOD=C1MOD|BME4;SFRPI=0
#define PCA1_CH01_SetPWM_DisBufferMode()			SFRPI=1;C1MOD=C1MOD&(~(BME0));SFRPI=0
#define PCA1_CH23_SetPWM_DisBufferMode()			SFRPI=1;C1MOD=C1MOD&(~(BME2));SFRPI=0
#define PCA1_CH45_SetPWM_DisBufferMode()			SFRPI=1;C1MOD=C1MOD&(~(BME4));SFRPI=0


// PCA1 ж

#define PCA1_CF_EnInterrupt()				SFRPI=1;C1MOD=C1MOD|ECF;SFRPI=0
#define PCA1_CF_DisInterrupt()				SFRPI=1;C1MOD=C1MOD&(~(ECF));SFRPI=0

#define PCA1_CH0_EnInterrupt()				SFRPI=1;C1CAPM0=C1CAPM0|ECCF0;SFRPI=0
#define PCA1_CH1_EnInterrupt()				SFRPI=1;C1CAPM1=C1CAPM1|ECCF1;SFRPI=0
#define PCA1_CH2_EnInterrupt()				SFRPI=1;C1CAPM2=C1CAPM2|ECCF2;SFRPI=0
#define PCA1_CH3_EnInterrupt()				SFRPI=1;C1CAPM3=C1CAPM3|ECCF3;SFRPI=0
#define PCA1_CH4_EnInterrupt()				SFRPI=1;C1CAPM4=C1CAPM4|ECCF4;SFRPI=0
#define PCA1_CH5_EnInterrupt()				SFRPI=1;C1CAPM5=C1CAPM5|ECCF5;SFRPI=0

#define PCA1_CH0_DisInterrupt()				SFRPI=1;C1CAPM0=C1CAPM0&(~(ECCF0));SFRPI=0
#define PCA1_CH1_DisInterrupt()				SFRPI=1;C1CAPM1=C1CAPM1&(~(ECCF1));SFRPI=0
#define PCA1_CH2_DisInterrupt()				SFRPI=1;C1CAPM2=C1CAPM2&(~(ECCF2));SFRPI=0
#define PCA1_CH3_DisInterrupt()				SFRPI=1;C1CAPM3=C1CAPM3&(~(ECCF3));SFRPI=0
#define PCA1_CH4_DisInterrupt()				SFRPI=1;C1CAPM4=C1CAPM4&(~(ECCF4));SFRPI=0
#define PCA1_CH5_DisInterrupt()				SFRPI=1;C1CAPM5=C1CAPM5&(~(ECCF5));SFRPI=0

// PCA1 PWM뷽ʽ

// PCA1 
#define PCA1_SetC1CEX0InputPort_C1EX0()		SFRPI=2;AUXR4=(AUXR4&(~(C1IC0S0|C1IC0S1)));SFRPI=0
#define PCA1_SetC1CEX0InputPort_AC0OUT()	SFRPI=2;AUXR4=(AUXR4&(~(C1IC0S0|C1IC0S1)))|(C1IC0S0);SFRPI=0
#define PCA1_SetC1CEX0InputPort_ILRCO()		SFRPI=2;AUXR4=(AUXR4|((C1IC0S0|C1IC0S1)));SFRPI=0

#define PCA1_SetC1CEX2InputPort_C1EX2()		SFRPI=2;AUXR4=(AUXR4&(~(C1IC2S0|C1IC2S1)));SFRPI=0
#define PCA1_SetC1CEX2InputPort_AC1OUT()	SFRPI=2;AUXR4=(AUXR4&(~(C1IC2S0|C1IC2S1)))|(C1IC2S0);SFRPI=0
#define PCA1_SetC1CEX2InputPort_AC0OUT()	SFRPI=2;AUXR4=(AUXR4|((C1IC2S0|C1IC2S1)));SFRPI=0


#define PCA1_SetC1CEX4InputPort_C1EX4()		SFRPI=3;AUXR6=(AUXR6&(~(C1IC4S0)));SFRPI=0
#define PCA1_SetC1CEX4InputPort_AC2OUT()	SFRPI=3;AUXR6=(AUXR6|((C1IC4S0)));SFRPI=0

#define PCA1_SetC1PWM0AC1PWM0BC1PWM2AC1PWM2B_P34P35P36P37()		SFRPI=2;AUXR5=AUXR5&(~C1PPS0);SFRPI=0
#define PCA1_SetC1PWM0AC1PWM0BC1PWM2AC1PWM2B_P60P61P62P63()		SFRPI=2;AUXR5=AUXR5|(C1PPS0);SFRPI=0

#define PCA1_SetCEX0CEX1CEX2CEX3CEX4CEX5_P62P65P63P66P64P67()		SFRPI=3;AUXR6=AUXR6&(~C1PS0);SFRPI=0
#define PCA1_SetCEX0CEX1CEX2CEX3CEX4CEX5_P36P41P37P42P40P43()		SFRPI=3;AUXR6=AUXR6|(C1PS0);SFRPI=0




/*
*************************************************************************************
*/ 


/*
*************************************************************************************
*  AC0 
*
*************************************************************************************
*/
// AC0 õ͹ģʽ
#define AC0_DisLowPower()							AC0CON=AC0CON&(~(AC0LP))
#define AC0_EnLowPower()							AC0CON=AC0CON|AC0LP

// AC0 õģʽ
#define AC0_DisPDRunning()							AC0CON=AC0CON&(~(AC0PDX))
#define AC0_EnPDRunning()							AC0CON=AC0CON|AC0PDX

// AC0 ʹ
#define AC0_Disable()								AC0CON=AC0CON&(~(AC0EN))
#define AC0_Enable()								AC0CON=AC0CON|AC0EN

// AC0 
#define AC0_SetOutput_DisInvert()					AC0CON=AC0CON&(~(AC0INV))
#define AC0_SetOutput_EnInvert()					AC0CON=AC0CON|AC0INV

// AC0 жģʽ
#define AC0_SetInterruptMode_Falling()				AC0CON=AC0CON&(~(AC0M0|AC0M1))|(AC0M0)
#define AC0_SetInterruptMode_Rising()				AC0CON=AC0CON&(~(AC0M0|AC0M1))|(AC0M1)
#define AC0_SetInterruptMode_Togging()				AC0CON=AC0CON|(AC0M0|AC0M1)

// AC0 øοѹ
#define AC0_SetNegaReferenceVoltage_1_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_2_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_3_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_4_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRL)
#define AC0_SetNegaReferenceVoltage_5_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_6_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_7_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_8_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRL)
#define AC0_SetNegaReferenceVoltage_9_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_10_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_11_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_12_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRL)
#define AC0_SetNegaReferenceVoltage_13_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_14_24_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS1|NVRL)
#define AC0_SetNegaReferenceVoltage_15_24_VDD()		AC0MOD=AC0MOD|(NVRS3|NVRS2|NVRS1|NVRS0|NVRL)
#define AC0_SetNegaReferenceVoltage_AC0NI()			AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))
#define AC0_SetNegaReferenceVoltage_9_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0)
#define AC0_SetNegaReferenceVoltage_10_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS1)
#define AC0_SetNegaReferenceVoltage_11_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS0|NVRS1)
#define AC0_SetNegaReferenceVoltage_12_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2)
#define AC0_SetNegaReferenceVoltage_13_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS0)
#define AC0_SetNegaReferenceVoltage_14_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1)
#define AC0_SetNegaReferenceVoltage_15_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS2|NVRS1|NVRS0)
#define AC0_SetNegaReferenceVoltage_16_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3)
#define AC0_SetNegaReferenceVoltage_17_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS0)
#define AC0_SetNegaReferenceVoltage_18_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1)
#define AC0_SetNegaReferenceVoltage_19_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS1|NVRS0)
#define AC0_SetNegaReferenceVoltage_20_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2)
#define AC0_SetNegaReferenceVoltage_21_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS0)
#define AC0_SetNegaReferenceVoltage_22_32_VDD()		AC0MOD=AC0MOD&(~(NVRS0|NVRS1|NVRS2|NVRS3|NVRL))|(NVRS3|NVRS2|NVRS1)
#define AC0_SetNegaReferenceVoltage_23_32_VDD()		AC0MOD=AC0MOD&(~(NVRL))|(NVRS3|NVRS2|NVRS1|NVRS0)

// AC0 ˲
#define AC0_SetFilter_Disable()						AC0MOD=AC0MOD&(~(AC0FLT));SFRPI=1;AUXR4=AUXR4&(~(AC0FLT1));SFRPI=0
#define AC0_SetFilter_Sysclk_x3()					AC0MOD=AC0MOD|((AC0FLT));SFRPI=1;AUXR4=AUXR4&(~(AC0FLT1));SFRPI=0
#define AC0_SetFilter_SysclkDiv6_x3()				AC0MOD=AC0MOD&(~(AC0FLT));SFRPI=1;AUXR4=AUXR4|((AC0FLT1));SFRPI=0
#define AC0_SetFilter_T3OF_x3()						AC0MOD=AC0MOD|((AC0FLT));SFRPI=1;AUXR4=AUXR4|((AC0FLT1));SFRPI=0

// AC0 
#define AC0_SetPosInputP02()						AC0MOD=AC0MOD&(~(AC0PIS0|AC0PIS1))
#define AC0_SetPosInputP03()						AC0MOD=AC0MOD&(~(AC0PIS0|AC0PIS1))|(AC0PIS0)
#define AC0_SetPosInputP04()						AC0MOD=AC0MOD&(~(AC0PIS0|AC0PIS1))|(AC0PIS1)
#define AC0_SetPosInputP05()						AC0MOD=AC0MOD|(AC0PIS0|AC0PIS1)


// AC0 AC0OUTPUT
#define AC0_DisableAC0OUTPUTP00()					SFRPI=1;AUXR4=AUXR4&(~(AC0OE));SFRPI=0
#define AC0_EnableAC0OUTPUTP00()					SFRPI=1;AUXR4=AUXR4|AC0OE;SFRPI=0

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  AC1 
*
*************************************************************************************
*/
// AC1 õ͹ģʽ
#define AC1_DisLowPower()							SFRPI=1;AC1CON=AC1CON&(~(AC1LP));SFRPI=0
#define AC1_EnLowPower()							SFRPI=1;AC1CON=AC1CON|AC1LP;SFRPI=0

// AC1 õģʽ
#define AC1_DisPDRunning()							SFRPI=1;AC1CON=AC1CON&(~(AC1PDX));SFRPI=0
#define AC1_EnPDRunning()							SFRPI=1;AC1CON=AC1CON|AC1PDX;SFRPI=0

// AC1 ʹ
#define AC1_Disable()								SFRPI=1;AC1CON=AC1CON&(~(AC1EN));SFRPI=0
#define AC1_Enable()								SFRPI=1;AC1CON=AC1CON|AC1EN;SFRPI=0

// AC1 
#define AC1_SetOutput_DisInvert()					SFRPI=1;AC1CON=AC1CON&(~(AC1INV));SFRPI=0
#define AC1_SetOutput_EnInvert()					SFRPI=1;AC1CON=AC1CON|AC1INV;SFRPI=0

// AC1 жģʽ
#define AC1_SetInterruptMode_Falling()				SFRPI=1;AC1CON=AC1CON&(~(AC1M0|AC1M1))|(AC1M0);SFRPI=0
#define AC1_SetInterruptMode_Rising()				SFRPI=1;AC1CON=AC1CON&(~(AC1M0|AC1M1))|(AC1M1);SFRPI=0
#define AC1_SetInterruptMode_Togging()				SFRPI=1;AC1CON=AC1CON|(AC1M0|AC1M1);SFRPI=0

// AC1 øοѹ
#define AC1_SetNegaInput_AC1NI()					SFRPI=1;AC1MOD=AC1MOD&(~(AC1NIS));SFRPI=0
#define AC1_SetNegaInput_ACNI0()					SFRPI=1;AC1MOD=AC1MOD|(AC1NIS);SFRPI=0

// AC1 ˲
#define AC1_SetFilter_Disable()						SFRPI=1;AC1MOD=AC1MOD&(~(AC1FLT));AUXR4=AUXR4&(~(AC1FLT1));SFRPI=0
#define AC1_SetFilter_Sysclk_x3()					SFRPI=1;AC1MOD=AC1MOD|((AC1FLT));AUXR4=AUXR4&(~(AC1FLT1));SFRPI=0
#define AC1_SetFilter_SysclkDiv6_x3()				SFRPI=1;AC1MOD=AC1MOD&(~(AC1FLT));AUXR4=AUXR4|((AC1FLT1));SFRPI=0
#define AC1_SetFilter_T3OF_x3()						SFRPI=1;AC1MOD=AC1MOD|((AC1FLT));AUXR4=AUXR4|((AC1FLT1));SFRPI=0


// AC1 AC1OUTPUT
#define AC1_DisableAC1OUTPUTP72()					SFRPI=1;AUXR4=AUXR4&(~(AC1OE));SFRPI=0
#define AC1_EnableAC1OUTPUTP72()					SFRPI=1;AUXR4=AUXR4|AC1OE;SFRPI=0

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  AC2 
*
*************************************************************************************
*/
// AC2 õ͹ģʽ
#define AC2_DisLowPower()							SFRPI=2;AC2CON=AC2CON&(~(AC2LP));SFRPI=0
#define AC2_EnLowPower()							SFRPI=2;AC2CON=AC2CON|AC2LP;SFRPI=0

// AC2 õģʽ
#define AC2_DisPDRunning()							SFRPI=2;AC2CON=AC2CON&(~(AC2PDX));SFRPI=0
#define AC2_EnPDRunning()							SFRPI=2;AC2CON=AC2CON|AC2PDX;SFRPI=0

// AC2 ʹ
#define AC2_Disable()								SFRPI=2;AC2CON=AC2CON&(~(AC2EN));SFRPI=0
#define AC2_Enable()								SFRPI=2;AC2CON=AC2CON|AC2EN;SFRPI=0

// AC2 
#define AC2_SetOutput_DisInvert()					SFRPI=2;AC2CON=AC2CON&(~(AC2INV));SFRPI=0
#define AC2_SetOutput_EnInvert()					SFRPI=2;AC2CON=AC2CON|AC2INV;SFRPI=0

// AC2 жģʽ
#define AC2_SetInterruptMode_Falling()				SFRPI=2;AC2CON=AC2CON&(~(AC2M0|AC2M1))|(AC2M0);SFRPI=0
#define AC2_SetInterruptMode_Rising()				SFRPI=2;AC2CON=AC2CON&(~(AC2M0|AC2M1))|(AC2M1);SFRPI=0
#define AC2_SetInterruptMode_Togging()				SFRPI=2;AC2CON=AC2CON|(AC2M0|AC2M1);SFRPI=0

// AC2 øοѹ
#define AC2_SetNegaInput_AC2NI()					SFRPI=2;AC2MOD=AC2MOD&(~(AC2NIS));SFRPI=0
#define AC2_SetNegaInput_ACNI0()					SFRPI=2;AC2MOD=AC2MOD|(AC2NIS);SFRPI=0

// AC2 ˲
#define AC2_SetFilter_Disable()						SFRPI=3;AC2MOD=AC2MOD&(~(AC2FLT));SFRPI=4;AUXR7=AUXR7&(~(AC2FLT1));SFRPI=0
#define AC2_SetFilter_Sysclk_x3()					SFRPI=3;AC2MOD=AC2MOD|((AC2FLT));SFRPI=4;AUXR7=AUXR7&(~(AC2FLT1));SFRPI=0
#define AC2_SetFilter_SysclkDiv6_x3()				SFRPI=3;AC2MOD=AC2MOD&(~(AC2FLT));SFRPI=4;AUXR7=AUXR7|((AC2FLT1));SFRPI=0
#define AC2_SetFilter_T3OF_x3()						SFRPI=3;AC2MOD=AC2MOD|((AC2FLT));SFRPI=4;AUXR7=AUXR7|((AC2FLT1));SFRPI=0


// AC2 AC2OUTPUT
#define AC2_DisableAC1OUTPUTP64()					SFRPI=4;AUXR7=AUXR7&(~(AC2OE));SFRPI=0
#define AC2_EnableAC1OUTPUTP64()					SFRPI=4;AUXR7=AUXR7|AC2OE;SFRPI=0

/*
*************************************************************************************
*/ 


/*
*************************************************************************************
*  WDT 
*
*************************************************************************************
*/
#define WDT_SetClock_32K_DIV_1_16ms()		WDTCR=(WDTCR&(~0x07))
#define WDT_SetClock_32K_DIV_2_32ms()		WDTCR=(WDTCR&(~0x07))|0x01	
#define WDT_SetClock_32K_DIV_4_64ms()		WDTCR=(WDTCR&(~0x07))|0x02
#define WDT_SetClock_32K_DIV_8_128ms()		WDTCR=(WDTCR&(~0x07))|0x03
#define WDT_SetClock_32K_DIV_16_256ms()		WDTCR=(WDTCR&(~0x07))|0x04
#define WDT_SetClock_32K_DIV_32_512ms()		WDTCR=(WDTCR&(~0x07))|0x05
#define WDT_SetClock_32K_DIV_64_1024ms()	WDTCR=(WDTCR&(~0x07))|0x06
#define WDT_SetClock_32K_DIV_128_2048ms()	WDTCR=(WDTCR|(0x07))

// WDT ʱԴ
#define WDT_SetClock_ILRCO()			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=IFD&(0x3F);IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define WDT_SetClock_XTAL2()			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x3F))|WDTCS0_P;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define WDT_SetClock_SYSCLKDiv12()		ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x3F))|WDTCS1_P;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define WDT_SetClock_T4TOF()			ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x3F))|(WDTCS1_P|WDTCS0_P);IFADRH=0x0;IFADRL=CKCON3_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

#define WDT_EnReset()		WDTCR|=WREN
#define WDT_Enable_OnPD()	WDTCR|=NSW
#define WDT_Enable_OnIDLE()	WDTCR|=WIDL
#define WDT_Clear()			WDTCR|=CLRW
#define WDT_Enable()		WDTCR|=ENW

#define CLRWDT()	WDTCR|=CLRW
#define ENWDT()		WDTCR|=ENW

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  RTC  
*
*************************************************************************************
*/
// RTC ʹֹܻ
#define RTC_Enable()			RTCCR=RTCCR|RTCE
#define RTC_Disable()			RTCCR=RTCCR&(~RTCE)

// RTC ʹֹܻRTCOP4.5 
#define RTC_EnRTCO_OutP45()			RTCCR=RTCCR|RTCO
#define RTC_DisRTCO_OutP45()		RTCCR=RTCCR&(~RTCO)

// RTC ֵ x=0~63 
#define RTC_SetReload(x)		RTCCR=(RTCCR&(0xC0))|(x)

// RTC üֵ x=0~63
#define RTC_SetCounter(x)		RTCTM=(RTCTM&(0xC0))|(x)

// RTC ʱӷƵֵ x=0~15 2^15~2^0
#define RTC_SetClock_Div_1()		RTCTM=(RTCTM&(0x3F))|(BIT7|BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1|BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_2()		RTCTM=(RTCTM&(0x3F))|(BIT7);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1|BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_4()		RTCTM=(RTCTM&(0x3F))|(BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1|BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_8()		RTCTM=(RTCTM&(0x3F));ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1|BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_16()		RTCTM=(RTCTM&(0x3F))|(BIT7|BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_32()		RTCTM=(RTCTM&(0x3F))|(BIT7);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_64()		RTCTM=(RTCTM&(0x3F))|(BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_128()		RTCTM=(RTCTM&(0x3F));ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT1);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_256()		RTCTM=(RTCTM&(0x3F))|(BIT7|BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_512()		RTCTM=(RTCTM&(0x3F))|(BIT7);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_1024()		RTCTM=(RTCTM&(0x3F))|(BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_2048()		RTCTM=(RTCTM&(0x3F));ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC))|(BIT0);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_4096()		RTCTM=(RTCTM&(0x3F))|(BIT7|BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC));IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_8192()		RTCTM=(RTCTM&(0x3F))|(BIT7);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC));IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_16384()	RTCTM=(RTCTM&(0x3F))|(BIT6);ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC));IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_Div_32768()	RTCTM=(RTCTM&(0x3F));ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0xFC));IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// RTC ʱԴ
#define RTC_SetClock_XTAL2_ECKI_P60()		ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x1F));IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_ILRCO()				ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x1F))|(RCSS0_P);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_WDTPS()				ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x1F))|(RCSS1_P);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_WDTOF()				ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x1F))|(RCSS1_P|RCSS0_P);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0
#define RTC_SetClock_SYSCLK()				ISPCR=0x80;IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_READ_P;SCMD=0x46;SCMD=0xB9;_nop_();IFD=(IFD&(0x1F))|(RCSS2_P);IFADRH=0x0;IFADRL=CKCON4_P;IFMT=ISP_WRITE_P;SCMD=0x46;SCMD=0xB9;_nop_();IFMT=0;ISPCR=0x0

// RTC ־λRTCF
#define RTC_ClearRTCF()				PCON1=RTCF

// RTC ʹ/ֹRTCж
#define RTC_EnInterrupt()			SFIE=SFIE|RTCFIE
#define RTC_DisInterrupt()			SFIE=SFIE&(~RTCFIE)

/*
*************************************************************************************
*/ 
/*
*************************************************************************************
*  SID  I2C START/STOP 
*
*************************************************************************************
*/

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  BEEPER  
*
*************************************************************************************
*/
// BEEPER IO
#define BEEP_SetP44_IOPort()						AUXR3=AUXR3&(~(BPOC0|BPOC1))
#define BEEP_SetP44_OutILRCODiv32_1KHz()			AUXR3=(AUXR3&(~(BPOC0|BPOC1)))|(BPOC0)
#define BEEP_SetP44_OutILRCODiv16_2KHz()			AUXR3=(AUXR3&(~(BPOC0|BPOC1)))|(BPOC1)
#define BEEP_SetP44_OutILRCODiv8_4KHz()				AUXR3=AUXR3|((BPOC0|BPOC1))

/*
*************************************************************************************
*/ 

/*
*************************************************************************************
*  KBI  
*
*************************************************************************************
*/
// KBI IO
#define KBI_SetKBI_P0()						AUXR1=AUXR1&(~(KBIPS0|KBIPS1))		
#define KBI_SetKBI_P2()						AUXR1=(AUXR1&(~(KBIPS0|KBIPS1)))|(KBIPS0)	
#define KBI_SetKBI_P5()						AUXR1=(AUXR1&(~(KBIPS0|KBIPS1)))|(KBIPS1)		
#define KBI_SetKBI_P34_P37_P40_P43()		AUXR1=AUXR1|((KBIPS0|KBIPS1))	

// KBI ñȽֵ
#define KBI0_1	0x01
#define KBI1_1	0x02
#define KBI2_1	0x04
#define KBI3_1	0x08
#define KBI4_1	0x10
#define KBI5_1	0x20
#define KBI6_1	0x40
#define KBI7_1	0x80
#define KBI0_0	0x00
#define KBI1_0	0x00
#define KBI2_0	0x00
#define KBI3_0	0x00
#define KBI4_0	0x00
#define KBI5_0	0x00
#define KBI6_0	0x00
#define KBI7_0	0x00
#define KBI_SetKBPattern(x)					KBPATN=x

// KBI ѡʹKBIͨ
#define KBI0	0x01
#define KBI1	0x02
#define KBI2	0x04
#define KBI3	0x08
#define KBI4	0x10
#define KBI5	0x20
#define KBI6	0x40
#define KBI7	0x80
#define KBI_SetKBMask(x)					KBMASK=x

// KBI ѡڱȽֵڱȽֵ
#define KBI_SetPatternNotEqual()			KBCON=KBCON&(~PATN_SEL)
#define KBI_SetPatternEqual()				KBCON=KBCON|(PATN_SEL)

// KBI ˲
#define KBI_SetFilter_Disable()				KBCON=KBCON&(~(KBCS0|KBCS1))
#define KBI_SetFilter_Sysclk_x3()			KBCON=(KBCON&(~(KBCS0|KBCS1)))|(KBCS0)
#define KBI_SetFilter_SysclkDiv6_x3()		KBCON=(KBCON&(~(KBCS0|KBCS1)))|(KBCS1)
#define KBI_SetFilter_T3OF_x3()				KBCON=KBCON|((KBCS0|KBCS1))

/*
*************************************************************************************
*/ 


/*
*************************************************************************************
*  POWER Դ
*
*************************************************************************************
*/
#define POW_BOD1_Enable_OnPD		BIT7
#define POW_BOD1_Disable_OnPD		0x00

#define POW_BOD1_Set20V			0x00
#define POW_BOD1_Set24V			B00010000
#define POW_BOD1_Set37V			B00100000
#define POW_BOD1_Set42V			B00110000

#define POW_BOD1_Enable			BIT2
#define POW_BOD1_Disable		0x00

#define POW_BOD1_EnReset		BIT3
#define POW_BOD1_DisReset		0x00

#define POW_BOD0_EnReset		BIT1
#define POW_BOD0_DisReset		0x00

#define POW_SetMode_PD()			PCON0|=PD;

#define POW_ResetToAP()			ISPCR=SRST
#define POW_ResetToISP()		ISPCR=SWBS|SRST

/*
*************************************************************************************
*/ 



#endif



