

#include "REG_MG82FG5A64.H"
#include "delay.H"

//	Table 12-2
//	Where y=0~7 (port pin). The registers P3M0 and P3M1 are listed in each port description.
//	P3M0.y	|	P3M1.y	|	Port Mode
//	------------------------------------------
//		0	|	0		|	Quasi-Bidirectional
//		0	|	1		|	Push-Pull Output
//		1	|	0		|	Input Only(High Impedance Input)
//		1	|	1		|	Open-Drain Output


//	Table 12-3
//	Where x= 0, 1, 2, 4, 5, 6 (port number), and y=0~7 (port pin). 
//	The registers PxM0 are listed in each port description.
//	PxM0.y	|	Port Mode
//	------------------------------------------
//		0	|	Open-Drain Output
//		1	|	Push-Pull Output
//


//	PUCON0, PUCON1: Port Pull-Up Control Register
//	Enable pull-up resistor in oopen-drain output mode.

void main(void)
{

	P0M0 = 0xFF;
	P2M0 = 0x00;
	PUCON0 = P2PU0;


	P0 = 0;
	P1 = 0;
	P2 = 0;
	P3 = 0;
	P4 = 0;
	P5 = 0x00;
	SFRPI = 1;
	P6 = 0;
	SFRPI = 0;

	
	while(1)
	{
		P00 = ~P00;
		P20 = ~P20;
		P34 = ~P34;
		
		delay_ms(2);
	}
}
