

#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#include "REG_MG82FG5A64.H"


#define		Int_IHRCO		0
#define		Ext_XTAL		1
#define		OSC_Type		Int_IHRCO

#define		T0_1MSL				0x67				//( 65536 - 1000 * 0.9216 ) % 256
#define		T0_1MSH				0xFC				//( 65536 - 1000 * 0.9216 ) / 256

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

uCHAR T0Cnt;

void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	ISPCR = ISP_ENABLE;
	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}

void Delay_Xms( uCHAR X )
{
	TR0 = 0;                                   // Disable Timer0

	T0Cnt = X;                                   // X*1ms = Xms

	TL0 = T0_1MSL;
	TH0 = T0_1MSH;
	TR0 = 1;                                   // Enable Timer0
	while( T0Cnt );
}

void INT_TIMER0(void) interrupt 1 using 1        // Timer0 Interrupt
{
	TR0 = 0;                                   // Disable Timer0

	if ( T0Cnt )
	{
		T0Cnt--;
		TL0 = T0_1MSL;
		TH0 = T0_1MSH;
		TR0 = 1;                               // Enable Timer0
	}
}

void main(void)
{
	uCHAR	tmp;

    TMOD = 0x01;                                 // Set Timer0/1 in Mode1/2 ( 16/8 bit )
    ET0 = 1;                                     // Enable Timer0 interrupt
	EA = 1;
	
#if (OSC_Type == Int_IHRCO)
    CKCON0 |= ENCKM;
	
	Delay_Xms(1);
	
	tmp = PageP_Read(PCON2);
	tmp |= HSE;
	PageP_Write(PCON2, tmp);
	
	tmp = PageP_Read(CKCON2);
	tmp |= MCKS0;
	PageP_Write(CKCON2, tmp);						//MCU run 22.1184MHz
#else
	tmp = PageP_Read(CKCON2);
	tmp |= XTALE;
	PageP_Write(CKCON2, tmp);
	
	Delay_Xms(1);

	tmp = PageP_Read(CKCON2);
	tmp |= OSCS0;
	PageP_Write(CKCON2, tmp);
#endif

	TMOD |= 0x20;
	TH1 = TL1 = 0xFB;
	AUXR2 = T1X12 | T1CKOE;							//Check Timer1 clock output sysclk / 10.
	TR1 = 1;
	
	while(1);
}
