#ifndef GPIO_H
#define GPIO_H

// <<< Use Configuration Wizard in Context Menu >>>
// <h> PINCONG1
// <o.0..1> CH7/CAP2/P2.7
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> CH6/P2.6
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> CH5/P2.5
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> CH4/P2.4
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG1_REGS 0xAA

// <h> PINSET1
// <o.0..1> CH7/CAP2/P2.7
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> CH6/P2.6
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> CH5/P2.5
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> CH4/P2.4 
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET1_REGS 0x00

// <h> PINCONG2
// <o.0..1> CH3/P2.3
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> CH2/INT1n/P3.3
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> CH1/INT0n/P3.2
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> CH0/CAP1/GPWM/P1.6
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG2_REGS 0xA6

// <h> PINSET2
// <o.0..1> CH3/P2.3
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> CH2/INT1n/P3.3
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> CH1/INT0n/P3.2
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> CH0/CAP1/GPWM/P1.6
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET2_REGS 0x48

// <h> PINCONG3
// <o.0..1> XTALI/T1/P3.5
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> XTALO/T0/P3.4
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> PWM_U/P1.0
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> PWM_X/P1.1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG3_REGS 0x59

// <h> PINSET3
// <o.0..1> XTALI/T1/P3.5
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> XTALO/T0/P3.4 
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> PWM_U/P1.0
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> PWM_X/P1.1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET3_REGS 0x09

// <h> PINCONG4
// <o.0..1> PWM_V/P1.2
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> PWM_Y/P1.3 
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> PWM_W/P1.4
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> PWM_Z/P1.5
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG4_REGS 0x55

// <h> PINSET4
// <o.0..1> PWM_V/P1.2
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> PWM_Y/P1.3
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> PWM_W/P1.4
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> PWM_Z/P1.5
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET4_REGS 0x00

// <h> PINCONG5
// <o.0..1> HUP/P0.0
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> HVP/P0.1 
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> HWP/P0.2
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> OCPn/P0.3
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG5_REGS 0xAA

// <h> PINSET5
// <o.0..1> HUP/P0.0
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> HVP/P0.1  
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4..5> HWP/P0.2
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.6..7> OCPn/P0.3
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET5_REGS 0x40

// <h> PINCONG6
// <o.0..1> TX/P3.1
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.2..3> RX/P3.0 
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.4..5> HUNCON/P0.4
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// <o.6..7> HVNCON/P0.5 
// <0=> Quasi-bidirectional(standard 8051 port outputs) 
// <1=> Push-pull output 
// <2=> Input-only (High impedance) 
// <3=> Open drain output
// </h>
#define PINCONG6_REGS 0xA9

// <h> PINSET6
// <o.0..1> TX/P3.1
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.2..3> RX/P3.0
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// <o.4> GPWMS
// <0=> CH0 is GPIO or AD
// <1=> CH0 is GPWM
// <o.5> MOCS
//<i>0 (GPIO pin Enablde) :
//<i>U B V B W B X B Y B Z B HUP B HUN B HVP B HVN B
//<i>HWP B HWN B OCPN is GPIO
//<i>1 (MOC pin Enable) :
//<i>U B V B W B X B Y B Z B HUP B HVP B HWP B OCPN
//<i>is MOC interface . If MOCS = 1 and MCONT2 0 = 1,	HUN B HVN B HWN is MOC interface.
// <0=> GPIO pin Enablde
// <1=> MOC pin Enable
// <o.6..7> HUNSET/P0.6
// <0=> No Pull
// <1=> Pull Down
// <2=> Pull Up
// <3=> No Pull
// </h>
#define PINSET6_REGS 0x2A


// <h> PINSET7
// <o.0..1> HUP/P0.0
// <0=> 0ns
// <1=> 250ns
// <2=> 500ns
// <3=> 1000ns
// <o.2..3> HVP/P0.1
// <0=> 0ns
// <1=> 250ns
// <2=> 500ns
// <3=> 1000ns
// <o.4..5> HWP/P0.2
// <0=> 0ns
// <1=> 250ns
// <2=> 500ns
// <3=> 1000ns
// <o.6..7> OCPn/P0.3
// <0=> 0ns
// <1=> 250ns
// <2=> 500ns
// <3=> 1000ns
// </h>
#define PINSET7_REGS 0xFF

// <<< end of configuration section >>>

extern void GPIO_Init (void);
#endif
