/**
 * @file    mdf101a_it.c
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _MDF101A_IT_C_

/* Files include */
#include "platform.h"
#include "usart_receiveridleframe_interrupt.h"
#include "mdf101a_it.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup USART
  * @{
  */

/**
  * @addtogroup USART_ReceiverIdleFrame_Interrupt
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief  This function handles NMI exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void NMI_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles Hard Fault exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void HardFault_Handler(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/***********************************************************************************************************************
  * @brief  This function handles SVCall exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SVC_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles PendSVC exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void PendSV_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles SysTick Handler
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SysTick_Handler(void)
{
    if (0 != PLATFORM_DelayTick)
    {
        PLATFORM_DelayTick--;
    }
}

/***********************************************************************************************************************
  * @brief  This function handles USART1 Handler
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void USART1_IRQHandler(void)
{
    uint8_t i = 0;

    if (RESET != USART_GetITStatus(USART1, USART_IT_RXNE))
    {
        USART_RxBuffer[USART_RxLength++] = USART_ReceiveData(USART1);

        if(RESET == READ_BIT(USART1->CR1, USART_CR1_IDLEIEN))
        {
            USART_ITConfig(USART1, USART_IT_IDLE, ENABLE);
        }
    }

    if (RESET != USART_GetITStatus(USART1, USART_IT_IDLE))
    {
        for (i = 0; i < USART_RxLength; i++)
        {
            USART_SendData(USART1, USART_RxBuffer[i]);

            while (RESET == USART_GetFlagStatus(USART1, USART_FLAG_TXE))
            {
            }
        }

        USART_RxLength = 0;

        USART_ITConfig(USART1, USART_IT_IDLE, DISABLE);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */


