/**
 * @file    tim13_14_timebase.c
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the system functions 
 */

/* Define to prevent recursive inclusion */
#define _TIM13_14_TIMEBASE_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "tim13_14_timebase.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup TIM13_14
  * @{
  */

/**
  * @addtogroup TIM13_14_TimeBase
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void TIM13_14_Configure(void)
{
    NVIC_InitTypeDef        NVIC_InitStruct;
    RCC_ClocksTypeDef       RCC_Clocks;
    TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStruct;

    RCC_GetClocksFreq(&RCC_Clocks);

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM13, ENABLE);

    TIM_TimeBaseStructInit(&TIM_TimeBaseInitStruct);
    TIM_TimeBaseInitStruct.TIM_Prescaler         = (RCC_Clocks.HCLK_Frequency / 60000000 - 1);
    TIM_TimeBaseInitStruct.TIM_CounterMode       = TIM_CounterMode_Up;
    TIM_TimeBaseInitStruct.TIM_Period            = (100 - 1);
    TIM_TimeBaseInitStruct.TIM_ClockDivision     = TIM_CKD_Div1;
    TIM_TimeBaseInitStruct.TIM_RepetitionCounter = 0;
    TIM_TimeBaseInit(TIM13, &TIM_TimeBaseInitStruct);

    TIM_ClearFlag(TIM13, TIM_FLAG_Update);
    TIM_ITConfig(TIM13, TIM_IT_Update, ENABLE);

    NVIC_InitStruct.NVIC_IRQChannel = TIM13_IRQn;
    NVIC_InitStruct.NVIC_IRQChannelPriority = 0x01;
    NVIC_InitStruct.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStruct);

    TIM_Cmd(TIM13, ENABLE);

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM14, ENABLE);

    TIM_TimeBaseStructInit(&TIM_TimeBaseInitStruct);
    TIM_TimeBaseInitStruct.TIM_Prescaler         = (RCC_Clocks.SYSCLK_Frequency);
    TIM_TimeBaseInitStruct.TIM_CounterMode       = TIM_CounterMode_Up;
    TIM_TimeBaseInitStruct.TIM_Period            = (100 - 1);
    TIM_TimeBaseInitStruct.TIM_ClockDivision     = TIM_CKD_Div1;
    TIM_TimeBaseInitStruct.TIM_RepetitionCounter = 0;
    TIM_TimeBaseInit(TIM14, &TIM_TimeBaseInitStruct);

    TIM_ClearFlag(TIM14, TIM_FLAG_Update);
    TIM_ITConfig(TIM14, TIM_IT_Update, ENABLE);

    NVIC_InitStruct.NVIC_IRQChannel = TIM14_IRQn;
    NVIC_InitStruct.NVIC_IRQChannelPriority = 0x01;
    NVIC_InitStruct.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStruct);

    TIM_Cmd(TIM14, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void TIM13_14_TimeBase_Sample(void)
{
    printf("\r\nTest %s", __FUNCTION__);

    TIM13_14_Configure();

    while (1)
    {
        if (0 != TIM13_UpdateFlag)
        {
            TIM13_UpdateFlag = 0;

            PLATFORM_LED_Toggle(LED1);
        }

        if (0 != TIM14_UpdateFlag)
        {
            TIM14_UpdateFlag = 0;

            PLATFORM_LED_Toggle(LED2);
        }
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */



