/**
 * @file    mg32_iwdg.h
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the functions prototypes for the IWDG firmware
 *          library.
 */


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __MG32_IWDG_H
#define __MG32_IWDG_H

/* Files includes ------------------------------------------------------------*/
#include <core_cm0.h>


#ifdef __cplusplus
extern "C" {
#endif

#if defined(__CC_ARM)
#pragma anon_unions
#elif defined(__ICCARM__)
#pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic ignored "-Wc11-extensions"
#pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined(__GNUC__)
/* anonymous unions are enabled by default -----------------------------------*/
#else
#warning Not supported compiler type
#endif

/**
  * @brief IWDG Base Address Definition
  */
#define IWDG_BASE                       (APB1PERIPH_BASE + 0x3000)    /*!< Base Address: 0x40003000 */

/**
  * @brief IWDG Register Structure Definition
  */
typedef struct
{
    __IO uint32_t KR;                   /*!< Key Register                                   offset: 0x00 */
    __IO uint32_t PR;                   /*!< Prescaler Register                             offset: 0x04 */
    __IO uint32_t RLR;                  /*!< Reload Register                                offset: 0x08 */
    __IO uint32_t SR;                   /*!< Status Register                                offset: 0x0C */
    __IO uint32_t CR;                   /*!< Control Register                               offset: 0x10 */
    __IO uint32_t IGEN;                 /*!< Interrupt Generator Register                   offset: 0x14 */
    __IO uint32_t CNT;                  /*!< Count register                                 offset: 0x18 */
    __IO uint32_t PS;                   /*!< Frequency division count register              offset: 0x1C */
} IWDG_TypeDef;

/**
  * @brief IWDG type pointer Definition
  */
#define IWDG                            ((IWDG_TypeDef *)IWDG_BASE)

/**
  * @brief IWDG_KR Register Bit Definition
  */
#define IWDG_KR_KEY_Pos                 (0)
#define IWDG_KR_KEY                     (0xFFFFU << IWDG_KR_KEY_Pos)            /*!< Key Value */

/**
  * @brief IWDG_PR Register Bit Definition
  */
#define IWDG_PR_PR_Pos                  (0)
#define IWDG_PR_PR                      (0x07U << IWDG_PR_PR_Pos)               /*!< Prescaler divided mask */

/**
  * @brief IWDG_RLR Register Bit Definition
  */
#define IWDG_RLR_RL_Pos                 (0)
#define IWDG_RLR_RL                     (0xFFFU << IWDG_RLR_RL_Pos)             /*!< Watchdog counter reload value */

/**
  * @brief IWDG_SR Register Bit Definition
  */
#define IWDG_SR_PVU_Pos                 (0)
#define IWDG_SR_PVU                     (0x01U << IWDG_SR_PVU_Pos)              /*!< Watchdog prescaler value update */
#define IWDG_SR_RVU_Pos                 (1)          
#define IWDG_SR_RVU                     (0x01U << IWDG_SR_RVU_Pos)              /*!< Watchdog counter reload value update */
#define IWDG_SR_IVU_Pos                 (2)          
#define IWDG_SR_IVU                     (0x01U << IWDG_SR_IVU_Pos)              /*!< Watchdog Interrupt Generate value update */
#define IWDG_SR_UPDATE_Pos              (3)          
#define IWDG_SR_UPDATE                  (0x01U << IWDG_SR_UPDATE_Pos)           /*!< Watchdog reload value update flag */
          
/**
  * @brief IWDG_CR Register Bit Definition
  */
#define IWDG_CR_IRQ_SEL_Pos             (0)
#define IWDG_CR_IRQ_SEL_Msk             (0x01U << IWDG_CR_IRQ_SEL_Pos)          /*!< IWDG overflow operation selection */
#define IWDG_CR_IRQ_CLR_Pos             (1)    
#define IWDG_CR_IRQ_CLR                 (0x01U << IWDG_CR_IRQ_CLR_Pos)          /*!< IWDG interrupt clear */

/**
  * @brief IWDG_IGRN Register Bit Definition
  */
#define IWDG_IGEN_IGEN_Pos              (0)
#define IWDG_IGEN_IGEN                  (0xFFFU << IWDG_IGEN_IGEN_Pos)          /*!< IWDG Interrupt Generate value */

/**
  * @brief IWDG_CNT Register Bit Definition
  */

#define IWDG_CNT_Pos                    (0)
#define IWDG_CNT_Msk                    (0xFFFU << IWDG_CNT_Pos)                /*!< IWDG counter value */

/**
  * @brief IWDG_PS Register Bit Definition
  */
#define IWDG_PS_Pos                     (0)
#define IWDG_PS_Msk                     (0xFFU << IWDG_PS_Pos)                  /*!< IWDG clock divider counter value */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

/*----------------------------------------------------------------------------*/
#endif
/** --------------------------------------------------------------------------*/

