/**
 * @file    mg32_dbg.h
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the functions prototypes for the DBG firmware
 *          library.
 */

/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __MG32_DBG_H
#define __MG32_DBG_H

/* Files includes ------------------------------------------------------------*/
#include <core_cm0.h>

#if defined(__CC_ARM)
#pragma anon_unions
#endif

/**
  * @brief DBG Base Address Definition
  */
#define DBG_BASE                        (0x40013400UL) /*!< Base Address: 0x40013400 */

/**
  * @brief DEBUG Registers Structure Definition
  */
typedef struct
{
    __IO uint32_t IDCODE;              /*!< Code ID                                        offset: 0x00 */
    __IO uint32_t CR;                  /*!< Control Register                               offset: 0x04 */
} DBGMCU_TypeDef;

/**
  * @brief DBGMCU type pointer Definition
  */
#define DBGMCU                          ((DBGMCU_TypeDef *)DBG_BASE)

/**
  * @brief DBGMCU_IDCODE Register Bit Definition
  */
#define DBGMCU_IDCODE_DEV_ID_Pos        (0)
#define DBGMCU_IDCODE_DEV_ID            (0xFFFFFFFFU << DBGMCU_IDCODE_DEV_ID_Pos) /*!< Device identifier */

/**
  * @brief DBGMCU_CR Register Bit Definition
  */
#define DBGMCU_CR_SLEEP_Pos             (0)
#define DBGMCU_CR_SLEEP                 (0x01U << DBGMCU_CR_SLEEP_Pos)          /*!< Debug Sleep mode */

#define DBGMCU_CR_IWDG_STOP_Pos         (8)
#define DBGMCU_CR_IWDG_STOP             (0x01U << DBGMCU_CR_IWDG_STOP_Pos)      /*!< Debug independent watchdog stopped when core is halted */

#define DBGMCU_CR_TIM1_STOP_Pos         (10)
#define DBGMCU_CR_TIM1_STOP             (0x01U << DBGMCU_CR_TIM1_STOP_Pos)      /*!< TIM1 counter stopped when core is halted */
#define DBGMCU_CR_TIM2_STOP_Pos         (11)
#define DBGMCU_CR_TIM2_STOP             (0x01U << DBGMCU_CR_TIM2_STOP_Pos)      /*!< TIM2 counter stopped when core is halted */

#define DBGMCU_CR_TIM1_PWM_OFF_Pos      (13)
#define DBGMCU_CR_TIM1_PWM_OFF          (0x01U << DBGMCU_CR_TIM1_PWM_OFF_Pos)   /*!< TIM1 in debug mode PWM output is all 0 */
#define DBGMCU_CR_TIM2_PWM_OFF_Pos      (14)
#define DBGMCU_CR_TIM2_PWM_OFF          (0x01U << DBGMCU_CR_TIM2_PWM_OFF_Pos)   /*!< TIM2 in debug mode PWM output is all 0*/

#define DBGMCU_CR_TIM14_STOP_Pos        (18)
#define DBGMCU_CR_TIM14_STOP            (0x01U << DBGMCU_CR_TIM14_STOP_Pos)     /*!< TIM14 counter stopped when core is halted */
#define DBGMCU_CR_TIM13_STOP_Pos        (19)
#define DBGMCU_CR_TIM13_STOP            (0x01U << DBGMCU_CR_TIM13_STOP_Pos)     /*!< TIM13 counter stopped when core is halted */

#define DBGMCU_CR_TIM6_STOP_Pos         (22)
#define DBGMCU_CR_TIM6_STOP             (0x01U << DBGMCU_CR_TIM6_STOP_Pos)      /*!< TIM6 counter stopped when core is halted */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/** --------------------------------------------------------------------------*/
#endif
/** --------------------------------------------------------------------------*/

