#ifndef CGH0X1A_MDE_ONEHALL_H
#define CGH0X1A_MDE_ONEHALL_H

// <<< Use Configuration Wizard in Context Menu >>>

// <e> 3 Hall to 1Hall Function  
#define ThreeHall_to_Onehall_Function  0
#if (ThreeHall_to_Onehall_Function == 1)
	// 	<o> Speed_3_To_1 (unit : rpm)
		#define	SPEED_3_TO_1							(300)	// @RPM, Level for Switch to 1-Hall Operation, "SPEED_3_TO_1" Must Bigger Than "SPEED_1_TO_3"
	// 	<o> Speed_1_To_3 (unit : rpm)
		#define	SPEED_1_TO_3							(100)	// @RPM, Level for Switch to 3-Hall Operation
#endif
// </e>

// <e> One Hall Startup Function
// <i> Only place one Hall in HU
#define OneHall_Startup_Function 0
#if (OneHall_Startup_Function == 1)
// <o> HU rising edge start ZONE <0=> 0 degrees <1=> 60degress <2=> 120degress <3=> 180degress <4=> 240degress <5=> 300degress
#define dZONE	2
#define	dONE_HALLSET	(0x88|dZONE)
// <o> ONE_HALL_STARTUP_AMP_Align (unit : %) <0-100>
// <i> Limit : 0 ~ 100%
#define	ONE_HALL_STARTUP_AMP_ALIGN			(unsigned int)((float)8.0 / 100 * DUTY_MAX)
// <o> One_Hall_Startup_AMP_OPLP (unit : %) <0-100>
// <i> Limit : 0 ~ 100%
#define	ONE_HALL_STARTUP_AMP_OPLP				(unsigned int)((float)50.0 / 100 * DUTY_MAX)
// <o> One_Hall_Startup_Freq_Min (unit : Hz) <1-50>
// <i> Limit : 3 ~ 100Hz
#define	ONE_HALL_STARTUP_FREQ_MIN				(3)
#define	ONE_HALL_STARTUP_FREQ_MIN_CNT		(unsigned int)(1000 / ONE_HALL_STARTUP_FREQ_MIN)
// <o> One_Hall_Startup_Freq_Max (unit : Hz) <3-100>
// <i> Limit : 3 ~ 100Hz
#define	ONE_HALL_STARTUP_FREQ_MAX				(100)
#define	ONE_HALL_STARTUP_FREQ_MAX_CNT		(unsigned int)(1000 / ONE_HALL_STARTUP_FREQ_MAX)
#endif
// </e>

extern unsigned char One_Hall_Startup_Status;
extern unsigned int  One_Hall_Startup_Theta;
extern unsigned int One_Hall_Startup_Freq;
extern unsigned int  One_Hall_Startup_Freq_Meas;
extern unsigned int  One_Hall_Startup_Freq_Meas_Pos;
//unsigned int  One_Hall_Startup_Freq_Meas_Neg;
extern unsigned int  One_Hall_Startup_Freq_Cnt;
extern unsigned char  One_Hall_Startup_Openloop_FREQ;
extern unsigned long One_Hall_Startup_PLL_Integral;
extern unsigned int  One_Hall_Startup_Openloop_TMR;
extern unsigned int  One_Hall_Startup_Alignment_TMR;
// extern unsigned int  One_Hall_Startup_TMR;
extern unsigned char One_Hall_Startup_Linkin_Cnt;

extern void HallTable_Init(void);
extern void OneHall_Init(void);
extern void OneHall_Startup(void);
extern void OneHall_Control(void);
extern void HALL_3_TO_1(void);
extern void HALL_1_TO_3(void);
#endif

