//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//datawqܶqbe128r`]0x00~0x7F^a}Ŷ
//idatawqܶqb]0x00~0xFF^a}Ŷ
//xdatawqܶqhObW~XiRAMŶ]@~0xF000~0xF1FFŶAŶjp]ӲAS~RAM^

//datawqܶqt׳̧֡AidataAxdatae̺C
//`QϥΪܼƥdata/idataŧi; `ϥΪܼƥxdataŧi.

/* Vdc Bus */
#ifdef dOVP_PROTECTION_ON
	data  unsigned int					Vdc_Bus_Data             = 0;
	xdata volatile unsigned char		VDC_BUS_OV_COUNTER       = 0;
	xdata volatile unsigned char		VDC_BUS_LV_COUNTER       = 0;
	xdata volatile unsigned short int 	VDC_BUS_StartCheck_Cnt   = 0;
	xdata volatile unsigned short int 	VDC_BUS_ReStartCheck_Cnt = 0;
	xdata volatile unsigned char		Flag_Vdc_Bus_Check       = 0;
#else
	xdata volatile unsigned char		Flag_Vdc_Bus_Check       = 0;
#endif

/* OTP */
#ifdef dOTP_PROTECTION_ON
	data  unsigned int	OTP_Data		= 0;
	xdata unsigned char OTP_COUNTER		= 0;
	xdata unsigned char OTP_LM_COUNTER	= 0;
	bit OTP_Duty_Limit					= 0;
#endif

bit	Flag_Rotor_Lock_Status;	
unsigned int  Hall_Lock_Cnt;
//********************************************************************************
//								    OVP/UVP
//********************************************************************************
#ifdef dOVP_PROTECTION_ON
void OVP_Function(void){
	if((Vdc_Bus_Data >= dVDC_BUS_OV_VALUE) && (VDC_BUS_OV_COUNTER < 255)){
		VDC_BUS_OV_COUNTER += 1;
	}
	else if((Vdc_Bus_Data <= dVDC_BUS_LV_VALUE) && (VDC_BUS_LV_COUNTER < 255)){
		VDC_BUS_LV_COUNTER += 1;
	}
	else{
		VDC_BUS_OV_COUNTER  = 0;
		VDC_BUS_LV_COUNTER  = 0;
	}
	if((VDC_BUS_LV_COUNTER >= 50) || (VDC_BUS_OV_COUNTER >= 50)){
		Error_Code             = dERRORCODE_OVERVOLTAGEPROTECTION;
		Flag_Vdc_Bus_Check     = 0;
		VDC_BUS_StartCheck_Cnt = 0;
		Flag_Motor_Running = 0;
	}
	else{
		if(!Flag_Vdc_Bus_Check){
			if(++VDC_BUS_StartCheck_Cnt >= 100){
				Flag_Vdc_Bus_Check   = 1; 
				VDC_BUS_StartCheck_Cnt = 0;
			}
			else
				Flag_Vdc_Bus_Check   = 0;
		}
	}
}
#endif
//********************************************************************************
//								     OTP
//********************************************************************************
#ifdef	dOTP_PROTECTION_ON
void OTP_Function(void){
	#if(OTP_Mode == 1)
		#if (OTP_DUTY_LIMIT_PROTECTION == 1)
			if(OTP_Duty_Limit == 0){
				if(OTP_Data <= dOTP_LM_VALUE){
					if(OTP_LM_COUNTER < 255)	
						OTP_LM_COUNTER += 1;
					else											
						OTP_LM_COUNTER  = 255;
				}
				else													
					OTP_LM_COUNTER  = 0;
				if((OTP_Data <= dOTP_LM_VALUE) && (OTP_LM_COUNTER >= 255))
						OTP_Duty_Limit = 1;	
			}
			else{
				if(OTP_Duty_Limit == 1){
					if(OTP_Data >= dOTP_LM_RESTART_VALUE){
						if(OTP_LM_COUNTER < 255)	
							OTP_LM_COUNTER += 1;
						else											
							OTP_LM_COUNTER  = 255;
					}
					else													
						OTP_LM_COUNTER  = 0;
					if((OTP_Data >= dOTP_LM_RESTART_VALUE) && (OTP_LM_COUNTER >= 255))
						OTP_Duty_Limit = 0;	
				}
			}
		#endif
		
		if(Error_Code != dERRORCODE_OVERTEMPPROTECTION){
			if(OTP_Data <= dOTP_OV_VALUE){
				if(OTP_COUNTER < 255)	
					OTP_COUNTER += 1;
				else									
					OTP_COUNTER  = 255;
			}
			else											
				OTP_COUNTER  = 0;

			if((OTP_Data <= dOTP_OV_VALUE) && (OTP_COUNTER >= 255)){
				Error_Code = dERRORCODE_OVERTEMPPROTECTION;
				Motor_Stop();
			}
		}
		else{
			if(Error_Code == dERRORCODE_OVERTEMPPROTECTION){
				if(OTP_Data >= dOTP_OV_RESTART_VALUE){
					if(OTP_COUNTER < 255)	
						OTP_COUNTER += 1;
					else									
						OTP_COUNTER  = 255;
				}
				else											
					OTP_COUNTER  = 0;

				if((OTP_Data >= dOTP_OV_RESTART_VALUE) && (OTP_COUNTER >= 255)){	
					Error_Code = dERRORCODE_NORMALOPERATION;		
				}
			}
		}
	#endif	
		
	#if(OTP_Mode == 0)
		#if (OTP_DUTY_LIMIT_PROTECTION == 1)
			if(OTP_Duty_Limit == 0){
				if(OTP_Data >= dOTP_LM_VALUE){
					if(OTP_LM_COUNTER < 255)	
						OTP_LM_COUNTER += 1;
					else											
						OTP_LM_COUNTER  = 255;
				}
				else													
					OTP_LM_COUNTER  = 0;
				if((OTP_Data >= dOTP_LM_VALUE) && (OTP_LM_COUNTER >= 255)){
					OTP_Duty_Limit = 1;
				}
			}
			else{
				if(OTP_Duty_Limit == 1){
					if(OTP_Data <= dOTP_LM_RESTART_VALUE){
						if(OTP_LM_COUNTER < 255)	
							OTP_LM_COUNTER += 1;
						else											
							OTP_LM_COUNTER  = 255;
					}
					else													
						OTP_LM_COUNTER  = 0;
					if((OTP_Data <= dOTP_LM_RESTART_VALUE) && (OTP_LM_COUNTER >= 255))	
						OTP_Duty_Limit = 0;		
				}
			}		
		#endif
		
		if(Error_Code != dERRORCODE_OVERTEMPPROTECTION){
			if(OTP_Data >= dOTP_OV_VALUE){
				if(OTP_COUNTER < 255)	
					OTP_COUNTER += 1;
				else									
					OTP_COUNTER  = 255;
			}
			else											
				OTP_COUNTER  = 0;

			if((OTP_Data >= dOTP_OV_VALUE) && (OTP_COUNTER >= 255)){
				Error_Code = dERRORCODE_OVERTEMPPROTECTION;
				Motor_Stop();
			}
		}
		else{
			if(Error_Code == dERRORCODE_OVERTEMPPROTECTION){
				if(OTP_Data <= dOTP_OV_RESTART_VALUE){
					if(OTP_COUNTER < 255)	
						OTP_COUNTER += 1;
					else									
						OTP_COUNTER  = 255;
				}
				else											
					OTP_COUNTER  = 0;

				if((OTP_Data <= dOTP_OV_RESTART_VALUE) && (OTP_COUNTER >= 255)){
					Error_Code = dERRORCODE_NORMALOPERATION;
				}
			}
		}
	#endif
}
#endif
//********************************************************************************
//								 Lock Protect
//********************************************************************************
bit Rotor_Lock_Detection(bit Input_Bit, unsigned int HALL_LOCK_TIME){
unsigned int dMCONT1;
	dMCONT1 = MCONT1;
	if(Input_Bit){
		if(dMCONT1&=0x80){
			if(++Hall_Lock_Cnt >= HALL_LOCK_TIME){
				Flag_Rotor_Lock_Status = 1;
				Error_Code             = dERRORCODE_ROTORLOCKPROTECTION;
				Hall_Lock_Cnt          = HALL_LOCK_TIME;
				Estimated_Speed = 0;
			}
			else
				Flag_Rotor_Lock_Status = 0;
		}
		else
			Hall_Lock_Cnt              = 0;
	}
	else{
		Hall_Lock_Cnt                  = 0;
		Flag_Rotor_Lock_Status         = 0;
	}
	return Flag_Rotor_Lock_Status;
}
//********************************************************************************
//								  Hall Error
//********************************************************************************
bit Hall_Error_Status_Detection(bit Input_Bit, unsigned char HALL_STATUS_1, unsigned char HALL_STATUS_2, unsigned int HALL_ERROR_TIME){
	unsigned char Hall_Status;
	unsigned int  Hall_Error_Cnt;
	bit	Flag_Hall_Error_Status;

	if(Input_Bit){
		Hall_Status  = HALLST & 0x07;
		if((Hall_Status == HALL_STATUS_1) || (Hall_Status == HALL_STATUS_2)){
			if(++Hall_Error_Cnt > HALL_ERROR_TIME){
				Flag_Hall_Error_Status = 1;
				Hall_Error_Cnt         = HALL_ERROR_TIME;
			}
			else
				Flag_Hall_Error_Status = 0;
		}
		else
			Hall_Error_Cnt             = 0;
	}
	else{
		Hall_Error_Cnt                 = 0;
		Flag_Hall_Error_Status         = 0;
	}
	return Flag_Hall_Error_Status;
}