//---------------------------------------------------------------------------//
// Head Files                                                                //
//---------------------------------------------------------------------------//
#include "CGH0X1A_SFR.h"
#include "Allhex.h"

//---------------------------------------------------------------------------//
// Subroutine                                                                //
//---------------------------------------------------------------------------//
void InitPI(tPIParm *pParm);
void CalcPI(tPIParm *pParm);
void InitPI_ALL(void);

//---------------------------------------------------------------------------//
// Global Variable Parameters                                                //
//---------------------------------------------------------------------------// 
xdata tPIParm			PIParm_W;	// Structure definition for Speed, or Omega
xdata tPIParm			PIParm_IBUS;

//---------------------------------------------------------------------------//
// Initial PI                                                                //
//---------------------------------------------------------------------------// 
void InitPI_ALL(void)
{
		#ifdef	SPEEDLOOP_CONTROL
				PIParm_W.qInRefMin			= WRefMin;
				PIParm_W.qInRefMax			= WRefMax;
				PIParm_W.qOutMax				= WOutMax;
				PIParm_W.qOutMin				= WOutMin;
				PIParm_W.qKp						= WKp;
				PIParm_W.qNko						= WNko;
				PIParm_W.qKi						= WKi;
				PIParm_W.qKd						= WKd;
				PIParm_W.qKc						= WKc;
			//PIParm_W.qSampingFre		= WFreInHz;
			//PIParm_W.qSampingTime		= (32768 / PIParm_W.qSampingFre);
		#endif

		#ifdef	CURRENTLOOP_CONTROL
				PIParm_IBUS.qInRefMin		= IBUSRefMin;
				PIParm_IBUS.qInRefMax		= IBUSRefMax;
				PIParm_IBUS.qOutMax			= IBUSOutMax;
				PIParm_IBUS.qOutMin			= IBUSOutMin;
				PIParm_IBUS.qKp					= IBUSKp;
				PIParm_IBUS.qNko				= IBUSNko;
				PIParm_IBUS.qKi					= IBUSKi;
				PIParm_IBUS.qKd					= IBUSKd;
				PIParm_IBUS.qKc					= IBUSKc;
		//	PIParm_IBUS.qSampingFre	= IBUSFreInHz;
		//	PIParm_IBUS.qSampingTime= (32768 / PIParm_IBUS.qSampingFre);
		#endif
}

void InitPI(tPIParm *pParm)
{
		pParm->qSum					= 0;
//		pParm->qSumErr			= 0;
		pParm->qErrOld			= 0;
		pParm->qPOut				= 0;
		pParm->qIOut				= 0;
		pParm->qDOut				= 0;
		pParm->qOut					= 0;
}


//---------------------------------------------------------------------------//
// PI Calculate                                                              //
//---------------------------------------------------------------------------// 
void CalcPI(tPIParm *pParm)
{
		if(pParm->qInRef >= pParm->qInRefMax)		pParm->qInRef = pParm->qInRefMax;
		if(pParm->qInRef <= pParm->qInRefMin)		pParm->qInRef = pParm->qInRefMin;
	
		pParm->qErr         = pParm->qInRef - pParm->qInMeas;
		pParm->qErrDelta    = 0;//(signed long)(pParm->qErr - pParm->qErrOld) * pParm->qSampingFre;
		
		pParm->qPOut        = (pParm->qKp * (signed long)pParm->qErr)      >> 15;
		pParm->qPOut        = pParm->qPOut << pParm->qNko;
		if(pParm->qPOut >= 32767)                 pParm->qPOut = 32767;
		pParm->qIOut        = (pParm->qSum)                     >> 15;
		pParm->qDOut        = 0;//(pParm->qKd * pParm->qErrDelta) >> 15;
		pParm->qU           = (pParm->qPOut + pParm->qIOut + pParm->qDOut);

		if(pParm->qU      > pParm->qOutMax)     pParm->qOut  = pParm->qOutMax;
		else if(pParm->qU < pParm->qOutMin)     pParm->qOut  = pParm->qOutMin;
		else                                        pParm->qOut  = pParm->qU;
		
		pParm->qExcess      = pParm->qU - pParm->qOut;
		pParm->qSum         = pParm->qSum + (pParm->qKi * (signed long)pParm->qErr) - (pParm->qKc * (signed long)pParm->qExcess);
		pParm->qErrOld      = pParm->qErr;
//	if(pParm->qInRef == 0 && pParm->qInMeas == 0)	pParm->qSum = pParm->qSumErr = 0;
}
//---------------------------------------------------------------------------//