//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//data定義的變量放在單片機前128字節（0x00~0x7F）地址空間中
//idata定義的變量放在（0x00~0xFF）地址空間中
//xdata定義的變量則是放在單片機片上外部擴展RAM空間中（一般指外部0xF000~0xF1FF空間，具體空間大小因單片機而異，有的單片機沒有外部RAM）

//data定義的變量速度最快，idata次之，xdata較前兩者慢
//常被使用的變數用data/idata宣告; 不常使用的變數用xdata宣告.

unsigned char Hall_Status;
unsigned char Hall_Status_Old;
unsigned char Hall_Status_ONE_Old;

xdata unsigned int  System_Reset_Count    = 0;
data unsigned int ROTOR_60				  = 0;

xdata unsigned char	fg_cnt      = 0;
//********************************************************************************
//								Interrupt_Init
//********************************************************************************
void Interrupt_Init(void){
	EA 		  = 0;
	IRCON1    = 0x00;			// Clear Flag

	EX0 = dIE0;					// XINT0_ISR          Interrupt 0
	IT0 = dIT0;
	ET0 = dITR0;				// Timer0_ISR         Interrupt 1
	EX1 = dIE1;					// XINT1_ISR          Interrupt 2
	IT1 = dIT1;
	ET1 = dITR1;				// Timer1_ISR         Interrupt 3
	ESP = dIUR;					// Serial_Port_ISR    Interrupt 4
	ET2 = dITR2;				// Timer2_ISR         Interrupt 5
	CAPIE = dICAP;				// Capture ISR		  Interrupt 7
	OCPSIE = dIOCPS;			// OCP_Short_ISR      Interrupt 8
	HALLIE = dIHall;			// Hall_ISR           Interrupt 9
	MPWMMINIE = dIPWM_min;		// MPWM_Min_ISR       Interrupt 10
	MPWMMAXIE = dIPWM_MAX;		// MPWM_Max_ISR       Interrupt 11
	GPWMIE    = dIGPWM_MAX;		// GPWM_ISR           Interrupt 12
	WDTIE     = dIWDF;			// Watchdog_Timer_ISR Interrupt 14
	OCPLIE    = dIOCPL;			// OCP_Limit_ISR      Interrupt 15
	
	#ifdef	FG_CAL
		ET1   = 0;				
		TR1   = 0;				
	#endif
	
	#ifdef OCP_LIMIT_ENABLE
		OCPLIE = 1;
	#endif

	#ifdef	WATCHDOG_EN
		TAKEY = 0x55;
		TAKEY = 0xAA;
		TAKEY = 0x5A;			// WDTC Write is Available
		WDTC  = 0x23;			// WDTM[3:0] = 0011b, Time-out Period is 5.461ms, Enable the WDT, Enable WDT Reset
		//WDTC  = 0x63;				// WDTM[3:0] = 0011b, Time-out Period is 5.461ms, Enable the WDT, Enable WDT Interrupt
		WDTK  = 0x55;			// Refresh WDT
	#endif
// 			x x G5 G4 G3 G2 G1 G0
//IP1		0 0 0 1   0  1  0  0
//IP0		0 0 0 1   0  0  0  0
	#ifdef	FG_CAL
		IP0     = 0X28;				// Interrupt Priority
		IP1		= 0X0C;				// G3(MPWM > TIMER1) > G2(OCPSIF > HALLIF > IE1) > G5(OCPLIF > TIMER2 > CAP) > G0(IE0) > 
									// G1(WDTIF >TIMER0) > G4(GPWM > UART)
	#else
		IP0     = 0x0C;				// Interrupt Priority
		IP1     = 0x24;				// G2(OCPSIF > HALLIF > IE1) > G5(OCPLIF > TIMER2 > CAP) > G3(MPWM > TIMER1) > G0(IE0) > 
									// G1(WDTIF >TIMER0) > G4(GPWM > UART)
	#endif
	
	#if (dUART_MODE == 1)
		IP0 = 0x10;					//Interrupt Priority
		IP1 = 0x14;					//Group 4 > 2 = 0 = 1 = 3 = 5(解決UR突波問題)
	#endif
	
	#if (AS_CORRECTION_ENABLE==1)
		IP0 |= 0x04;				//G2(OCPSIF > HALLIF > IE1)設為最高優先
		IP1 |= 0x04;
	#endif
	
	EA = 1;
}
//********************************************************************************
//								    TIMER0
//********************************************************************************
void Timer0_ISR(void) interrupt 1{	//1ms
	TH0 = TIMER0_TH; 
	TL0 = TIMER0_TL;

	#ifdef WATCHDOG_EN
		WDTK = 0x55; // Refresh WDT
	#endif
	
	#if (OneHall_Startup_Function == Enable)
		OneHall_Startup();
	#endif
		
	// PWM Capturer
	if(System_Reset_Count >= 255) 
		PWM_CAPTURER();
	else
		System_Reset_Count++;
	//-------------------------------------//

	// System Protection
	#ifdef dOVP_PROTECTION_ON
		Vdc_Bus_Data = Adc_Channel(OVP_CH);
		OVP_Function();
	#else
		Flag_Vdc_Bus_Check = 1;
	#endif

	#ifdef	dOTP_PROTECTION_ON
		OTP_Data = Adc_Channel(OTP_CH);
		OTP_Function();
	#endif
	//-------------------------------------//

	// IBus Measurement
	#ifdef	CURRENTLOOP_CONTROL
		Idc_Bua_Data        = Adc_Channel(IBUS_CH);
		Idc_Bua_Data_FILTED     = Idc_Bua_Data;
		Idc_Bua_Data_FILTED_Pre = Idc_Bua_Data_FILTED * 31 + Idc_Bua_Data_FILTED_Pre;
		Idc_Bua_Data_FILTED_Pre = Idc_Bua_Data_FILTED_Pre >> 5;
		Idc_Bua_Data_FILTED     = Idc_Bua_Data_FILTED_Pre;
		
		#if(IBus_Signal_Delay == 0)
			Idc_Bua_FILTED_Out = Idc_Bua_Data_FILTED;
		#elif (IBus_Signal_Delay==1)
			if(Idc_Bua_FILTED_Out < Idc_Bua_Data_FILTED)
				Idc_Bua_FILTED_Out ++;
			else if(Idc_Bua_FILTED_Out > Idc_Bua_Data_FILTED)
				Idc_Bua_FILTED_Out --;			
		#endif
	#endif

	#ifdef FR_EN	
		#if (Direction == CCW)
			FR_OUT = FR_PIN;
		#else
			FR_OUT = !FR_PIN;
		#endif
		
		if(FR != FR_OUT){
			if(FR_Delay >= 60){
				FR = FR_OUT;
				FR_Delay = 0;
			}
			else
				FR_Delay ++;
		}
		else
			FR_Delay = 0;

		if(Flag_Reverse_Temp != FR ){		
			VSP = 0;
			if(Estimated_Speed < REVERSE_SPEED){
				HallTable_Init();
			}
		}
	#endif
	
		Motor_strat();
		Motor_Running();
// Error Action
		if(Error_Code == dERRORCODE_MOTORSTOP){
			Motor_Stop();
		}
		
		#ifdef	dOVP_PROTECTION_ON
		if(Error_Code == dERRORCODE_OVERVOLTAGEPROTECTION){
			if(Flag_Vdc_Bus_Check && (Vdc_Bus_Data >= dVDC_BUS_LV_RESTART_VALUE) && (Vdc_Bus_Data <= dVDC_BUS_OV_RESTART_VALUE)){
				if(++VDC_BUS_ReStartCheck_Cnt >= 50){
					VDC_BUS_ReStartCheck_Cnt = 0;
					Error_Code               = dERRORCODE_NORMALOPERATION;
					Motor_Stop();
				}
			}
			else{
				if(VDC_BUS_ReStartCheck_Cnt > 10){
					VDC_BUS_ReStartCheck_Cnt = VDC_BUS_ReStartCheck_Cnt - 10;
				}
				else{
					VDC_BUS_ReStartCheck_Cnt = 0;
				}
			}
		}
		#endif
		
		#if(dUART_MODE == 1)
			UartCount += Timer1ms;
			if(UartCount >= Timer10ms){
				UartFlag = 1;
				UartCount = 0;
			}
			Uart_Read_Handle();
		#endif

		TF0 = 0;
}
//********************************************************************************
//								     INT1
//********************************************************************************
// void External1_ISR (void) interrupt 2{

// }
//********************************************************************************
//								     Timer1
//********************************************************************************
#ifdef	FG_CAL
void Timer1_ISR (void) interrupt 3{
	TH1 = RTH2;
	TL1 = RTL2;
	FG ^= 1;
	TF1 = 0; 
}
#endif
//********************************************************************************
//								     UART
//********************************************************************************
#if (dUART_MODE == 1)
void Uart_ISR (void) interrupt 4{
	if(TI){	//Data transmission completed
		Uart_Send_Buffer();
		TI = 0;
	}
	if(RI){
		Uart_Read_Buffer();
		RI = 0;
	}
}
#endif
//********************************************************************************
//								     Timer2
//********************************************************************************
// void Timer2_ISR(void) interrupt 5{
	// TH2 = (ROTOR_60 >> 8) & 0xFF;
	// TL2 = ROTOR_60 & 0xFF;
	// TF2 = 0; 
// }
//********************************************************************************
//						         CAP interrupt
//********************************************************************************
// void Cap_ISR (void) interrupt 7{

// }
//********************************************************************************
//							   OCP Short interrupt
//********************************************************************************
void OCPS_ISR (void) interrupt 8{
	#ifdef	BOOTSTRAP
	if(BootStrap_Cnt >= BOOTSTRAP_TIME)
	#endif
	{
		RST_PWM();
		Flag_OCP   = 1;
		Error_Code = dERRORCODE_OVERCURRENTPROTECTION;
		SYNC = 0x00;
	}
}
//********************************************************************************
//						      HALL_ISR interrupt
//********************************************************************************
void HALL_ISR (void) interrupt 9{//Hall state change.
	unsigned long ul_rotorspeed_t = 0;
	#if (AS_CORRECTION_ENABLE==1)
		AS_correction_sub(AS_Command_Buffer, AS_CORRECTION_ENABLE);
	#endif
	
	Hall_Status_Old = Hall_Status;
	Hall_Status     = HALLST & 0x07;
	Reset_Estimated_Count = 0;
	
	#if (OneHall_Startup_Function == Enable)
		OneHall_Control();
	#endif

	if(Hall_Status != Hall_Status_Old){
		#ifndef	FG_CAL
			if(++fg_cnt >= FG_PULSE_PER_ROUND){ // FG Output
				FG = ~FG;
				fg_cnt = 0;
			}
		#endif
			
		if(((Flag_Reverse == CCW) && (Hall_Status == HALL_TABLE[5])) || ((Flag_Reverse == CW) && (Hall_Status == HALL_TABLE[0]))){
			Speed_Estimation();

			#if (ThreeHall_to_Onehall_Function == Enable)
				if(Flag_Virtual_Hall == 0){
					if(Flag_Reverse == CCW){
						if((Estimated_Speed_Cnt[7] < SPEED_3_TO_1_VAL) && (Hall_Status_Old == HALL_TABLE[0])){
							HALL_3_TO_1();
						}
					}
					else{
						if((Estimated_Speed_Cnt[7] < SPEED_3_TO_1_VAL) && (Hall_Status_Old == HALL_TABLE[5])){
							HALL_3_TO_1();
						}
					}
				}
				else{
					if(Estimated_Speed_Cnt[7] > SPEED_1_TO_3_VAL){
						HALL_1_TO_3();
					}
				}
			#endif
		}
	}
}
//********************************************************************************
//						    PWM_MIN_ISR interrupt
//********************************************************************************
void PmwMin_ISR (void) interrupt 10{
	#ifdef OCP_LIMIT_ENABLE
		if(AOCPCONT & 0x80){	
			#ifdef	DUTY_CONTROL
				if(Duty_Command_Buffer > AMP_MIN)
					Duty_Command_Buffer -= 1;//dDUTY_SLOPE_DELTA;

				#if( AMP_FINE_TUNE == 1)
					SVPWMAMPFT = Duty_Command_Buffer & 0x07;
					SVPWMAMPL = (Duty_Command_Buffer>>3) & 0xFF;
					SVPWMAMPH = (Duty_Command_Buffer>>11) & 0xFF;
				#else
					SVPWMAMPL = Duty_Command_Buffer        & 0xFF;
					SVPWMAMPH = (Duty_Command_Buffer >> 8) & 0xFF;
				#endif

				#ifdef	SINUSOLIDAL_CONTROL
						MPWMCONT1 = 0x2A; // High-side Active High
						MPWMCONT2 = 0x3F; // Low-side Active Low 
				#else
					#ifdef	LOWSIDESWITHCING
						MPWMCONT1 = 0x15; // High-side Force High
						MPWMCONT2 = 0x3F; // Low-side Active Low
					#else
						MPWMCONT1 = 0x3F; // High-side Active Low
						MPWMCONT2 = 0x15; // Low-side Force High
					#endif
				#endif

				SYNC = 0x00;
			#endif

			#ifdef	SPEEDLOOP_CONTROL
				if(Speed_Command_Buffer > 0)
					//Speed_Command_Buffer -= (unsigned long)WFSOutMax << 6;
					Speed_Command_Buffer = (Speed_Command_Buffer>>4)*15 ;//PIParm_W.qSum  -= (unsigned long)WFSOutMax << 6;;//dSPEED_SLOPE_DELTA
					//Speed_Command_Buffer = Speed_Command_Buffer>>1;
			#endif		
		}	
	#endif
}
//********************************************************************************
//						    PWM_MAX_ISR interrupt
//********************************************************************************
void PmwMax_ISR (void) interrupt 11{
}
//********************************************************************************
//						    PWM_MAX_ISR interrupt
//********************************************************************************
void GPWMMAX_ISR (void) interrupt 12{
}
//********************************************************************************
//						      WatchDoag interrupt
//********************************************************************************
//void WatchDoag_ISR (void) interrupt 14{

//}
//********************************************************************************
//							   OCP lIMIT interrupt
//********************************************************************************
void OCPL_ISR (void) interrupt 15{
	#ifdef	DUTY_CONTROL
		if(Duty_Command_Buffer > AMP_MIN)
			Duty_Command_Buffer -= 1;//dDUTY_SLOPE_DELTA;

		#if(AMP_FINE_TUNE == 1)
			SVPWMAMPFT = Duty_Command_Buffer & 0x07;
			SVPWMAMPL = (Duty_Command_Buffer>>3) & 0xFF;
			SVPWMAMPH = (Duty_Command_Buffer>>11) & 0xFF;
		#else
			SVPWMAMPL = Duty_Command_Buffer        & 0xFF;
			SVPWMAMPH = (Duty_Command_Buffer >> 8) & 0xFF;
		#endif

		#ifdef	SINUSOLIDAL_CONTROL
			MPWMCONT1 = 0x2A; // High-side Active High
			MPWMCONT2 = 0x3F; // Low-side Active Low 
		#else
			#ifdef	LOWSIDESWITHCING
				MPWMCONT1 = 0x15; // High-side Force High
				MPWMCONT2 = 0x3F; // Low-side Active Low
			#else
				MPWMCONT1 = 0x3F; // High-side Active Low
				MPWMCONT2 = 0x15; // Low-side Force High
			#endif
		#endif

		SYNC = 0x55;
	#endif
}